// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2_test

import (
	"context"
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/awserr"
	"github.com/aws/aws-sdk-go-v2/aws/external"
	"github.com/aws/aws-sdk-go-v2/service/ec2"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To allocate an Elastic IP address for EC2-VPC
//
// This example allocates an Elastic IP address to use with an instance in a VPC.
func ExampleClient_AllocateAddressRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AllocateAddressInput{
		Domain: ec2.DomainTypeVpc,
	}

	req := svc.AllocateAddressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To allocate an Elastic IP address for EC2-Classic
//
// This example allocates an Elastic IP address to use with an instance in EC2-Classic.
func ExampleClient_AllocateAddressRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AllocateAddressInput{}

	req := svc.AllocateAddressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To assign a specific secondary private IP address to an interface
//
// This example assigns the specified secondary private IP address to the specified
// network interface.
func ExampleClient_AssignPrivateIpAddressesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AssignPrivateIpAddressesInput{
		NetworkInterfaceId: aws.String("eni-e5aa89a3"),
		PrivateIpAddresses: []string{
			"10.0.0.82",
		},
	}

	req := svc.AssignPrivateIpAddressesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To assign secondary private IP addresses that Amazon EC2 selects to an interface
//
// This example assigns two secondary private IP addresses to the specified network
// interface. Amazon EC2 automatically assigns these IP addresses from the available
// IP addresses in the CIDR block range of the subnet the network interface is associated
// with.
func ExampleClient_AssignPrivateIpAddressesRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AssignPrivateIpAddressesInput{
		NetworkInterfaceId:             aws.String("eni-e5aa89a3"),
		SecondaryPrivateIpAddressCount: aws.Int64(2),
	}

	req := svc.AssignPrivateIpAddressesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate an Elastic IP address in EC2-VPC
//
// This example associates the specified Elastic IP address with the specified instance
// in a VPC.
func ExampleClient_AssociateAddressRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AssociateAddressInput{
		AllocationId: aws.String("eipalloc-64d5890a"),
		InstanceId:   aws.String("i-0b263919b6498b123"),
	}

	req := svc.AssociateAddressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate an Elastic IP address with a network interface
//
// This example associates the specified Elastic IP address with the specified network
// interface.
func ExampleClient_AssociateAddressRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AssociateAddressInput{
		AllocationId:       aws.String("eipalloc-64d5890a"),
		NetworkInterfaceId: aws.String("eni-1a2b3c4d"),
	}

	req := svc.AssociateAddressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate an Elastic IP address in EC2-Classic
//
// This example associates an Elastic IP address with an instance in EC2-Classic.
func ExampleClient_AssociateAddressRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AssociateAddressInput{
		InstanceId: aws.String("i-07ffe74c7330ebf53"),
		PublicIp:   aws.String("198.51.100.0"),
	}

	req := svc.AssociateAddressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate a DHCP options set with a VPC
//
// This example associates the specified DHCP options set with the specified VPC.
func ExampleClient_AssociateDhcpOptionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AssociateDhcpOptionsInput{
		DhcpOptionsId: aws.String("dopt-d9070ebb"),
		VpcId:         aws.String("vpc-a01106c2"),
	}

	req := svc.AssociateDhcpOptionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate the default DHCP options set with a VPC
//
// This example associates the default DHCP options set with the specified VPC.
func ExampleClient_AssociateDhcpOptionsRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AssociateDhcpOptionsInput{
		DhcpOptionsId: aws.String("default"),
		VpcId:         aws.String("vpc-a01106c2"),
	}

	req := svc.AssociateDhcpOptionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate an IAM instance profile with an instance
//
// This example associates an IAM instance profile named admin-role with the specified
// instance.
func ExampleClient_AssociateIamInstanceProfileRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AssociateIamInstanceProfileInput{
		IamInstanceProfile: &ec2.IamInstanceProfileSpecification{
			Name: aws.String("admin-role"),
		},
		InstanceId: aws.String("i-123456789abcde123"),
	}

	req := svc.AssociateIamInstanceProfileRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate a route table with a subnet
//
// This example associates the specified route table with the specified subnet.
func ExampleClient_AssociateRouteTableRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AssociateRouteTableInput{
		RouteTableId: aws.String("rtb-22574640"),
		SubnetId:     aws.String("subnet-9d4a7b6"),
	}

	req := svc.AssociateRouteTableRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach an Internet gateway to a VPC
//
// This example attaches the specified Internet gateway to the specified VPC.
func ExampleClient_AttachInternetGatewayRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AttachInternetGatewayInput{
		InternetGatewayId: aws.String("igw-c0a643a9"),
		VpcId:             aws.String("vpc-a01106c2"),
	}

	req := svc.AttachInternetGatewayRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a network interface to an instance
//
// This example attaches the specified network interface to the specified instance.
func ExampleClient_AttachNetworkInterfaceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AttachNetworkInterfaceInput{
		DeviceIndex:        aws.Int64(1),
		InstanceId:         aws.String("i-1234567890abcdef0"),
		NetworkInterfaceId: aws.String("eni-e5aa89a3"),
	}

	req := svc.AttachNetworkInterfaceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a volume to an instance
//
// This example attaches a volume (``vol-1234567890abcdef0``) to an instance (``i-01474ef662b89480``)
// as ``/dev/sdf``.
func ExampleClient_AttachVolumeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AttachVolumeInput{
		Device:     aws.String("/dev/sdf"),
		InstanceId: aws.String("i-01474ef662b89480"),
		VolumeId:   aws.String("vol-1234567890abcdef0"),
	}

	req := svc.AttachVolumeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a rule that allows outbound traffic to a specific address range
//
// This example adds a rule that grants access to the specified address ranges on TCP
// port 80.
func ExampleClient_AuthorizeSecurityGroupEgressRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AuthorizeSecurityGroupEgressInput{
		GroupId: aws.String("sg-1a2b3c4d"),
		IpPermissions: []ec2.IpPermission{
			{
				FromPort:   aws.Int64(80),
				IpProtocol: aws.String("tcp"),
				IpRanges: []ec2.IpRange{
					{
						CidrIp: aws.String("10.0.0.0/16"),
					},
				},
				ToPort: aws.Int64(80),
			},
		},
	}

	req := svc.AuthorizeSecurityGroupEgressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a rule that allows outbound traffic to a specific security group
//
// This example adds a rule that grants access to the specified security group on TCP
// port 80.
func ExampleClient_AuthorizeSecurityGroupEgressRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AuthorizeSecurityGroupEgressInput{
		GroupId: aws.String("sg-1a2b3c4d"),
		IpPermissions: []ec2.IpPermission{
			{
				FromPort:   aws.Int64(80),
				IpProtocol: aws.String("tcp"),
				ToPort:     aws.Int64(80),
				UserIdGroupPairs: []ec2.UserIdGroupPair{
					{
						GroupId: aws.String("sg-4b51a32f"),
					},
				},
			},
		},
	}

	req := svc.AuthorizeSecurityGroupEgressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a rule that allows inbound SSH traffic from an IPv4 address range
//
// This example enables inbound traffic on TCP port 22 (SSH). The rule includes a description
// to help you identify it later.
func ExampleClient_AuthorizeSecurityGroupIngressRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AuthorizeSecurityGroupIngressInput{
		GroupId: aws.String("sg-903004f8"),
		IpPermissions: []ec2.IpPermission{
			{
				FromPort:   aws.Int64(22),
				IpProtocol: aws.String("tcp"),
				IpRanges: []ec2.IpRange{
					{
						CidrIp:      aws.String("203.0.113.0/24"),
						Description: aws.String("SSH access from the LA office"),
					},
				},
				ToPort: aws.Int64(22),
			},
		},
	}

	req := svc.AuthorizeSecurityGroupIngressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a rule that allows inbound HTTP traffic from another security group
//
// This example enables inbound traffic on TCP port 80 from the specified security group.
// The group must be in the same VPC or a peer VPC. Incoming traffic is allowed based
// on the private IP addresses of instances that are associated with the specified security
// group.
func ExampleClient_AuthorizeSecurityGroupIngressRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AuthorizeSecurityGroupIngressInput{
		GroupId: aws.String("sg-111aaa22"),
		IpPermissions: []ec2.IpPermission{
			{
				FromPort:   aws.Int64(80),
				IpProtocol: aws.String("tcp"),
				ToPort:     aws.Int64(80),
				UserIdGroupPairs: []ec2.UserIdGroupPair{
					{
						Description: aws.String("HTTP access from other instances"),
						GroupId:     aws.String("sg-1a2b3c4d"),
					},
				},
			},
		},
	}

	req := svc.AuthorizeSecurityGroupIngressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a rule that allows inbound RDP traffic from an IPv6 address range
//
// This example adds an inbound rule that allows RDP traffic from the specified IPv6
// address range. The rule includes a description to help you identify it later.
func ExampleClient_AuthorizeSecurityGroupIngressRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.AuthorizeSecurityGroupIngressInput{
		GroupId: aws.String("sg-123abc12 "),
		IpPermissions: []ec2.IpPermission{
			{
				FromPort:   aws.Int64(3389),
				IpProtocol: aws.String("tcp"),
				Ipv6Ranges: []ec2.Ipv6Range{
					{
						CidrIpv6:    aws.String("2001:db8:1234:1a00::/64"),
						Description: aws.String("RDP access from the NY office"),
					},
				},
				ToPort: aws.Int64(3389),
			},
		},
	}

	req := svc.AuthorizeSecurityGroupIngressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To cancel a Spot fleet request
//
// This example cancels the specified Spot fleet request and terminates its associated
// Spot Instances.
func ExampleClient_CancelSpotFleetRequestsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CancelSpotFleetRequestsInput{
		SpotFleetRequestIds: []string{
			"sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE",
		},
		TerminateInstances: aws.Bool(true),
	}

	req := svc.CancelSpotFleetRequestsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To cancel a Spot fleet request without terminating its Spot Instances
//
// This example cancels the specified Spot fleet request without terminating its associated
// Spot Instances.
func ExampleClient_CancelSpotFleetRequestsRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CancelSpotFleetRequestsInput{
		SpotFleetRequestIds: []string{
			"sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE",
		},
		TerminateInstances: aws.Bool(false),
	}

	req := svc.CancelSpotFleetRequestsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To cancel Spot Instance requests
//
// This example cancels a Spot Instance request.
func ExampleClient_CancelSpotInstanceRequestsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CancelSpotInstanceRequestsInput{
		SpotInstanceRequestIds: []string{
			"sir-08b93456",
		},
	}

	req := svc.CancelSpotInstanceRequestsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To confirm the product instance
//
// This example determines whether the specified product code is associated with the
// specified instance.
func ExampleClient_ConfirmProductInstanceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ConfirmProductInstanceInput{
		InstanceId:  aws.String("i-1234567890abcdef0"),
		ProductCode: aws.String("774F4FF8"),
	}

	req := svc.ConfirmProductInstanceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To copy an AMI to another region
//
// This example copies the specified AMI from the us-east-1 region to the current region.
func ExampleClient_CopyImageRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CopyImageInput{
		Description:   aws.String(""),
		Name:          aws.String("My server"),
		SourceImageId: aws.String("ami-5731123e"),
		SourceRegion:  aws.String("us-east-1"),
	}

	req := svc.CopyImageRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To copy a snapshot
//
// This example copies a snapshot with the snapshot ID of ``snap-066877671789bd71b``
// from the ``us-west-2`` region to the ``us-east-1`` region and adds a short description
// to identify the snapshot.
func ExampleClient_CopySnapshotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CopySnapshotInput{
		Description:       aws.String("This is my copied snapshot."),
		DestinationRegion: aws.String("us-east-1"),
		SourceRegion:      aws.String("us-west-2"),
		SourceSnapshotId:  aws.String("snap-066877671789bd71b"),
	}

	req := svc.CopySnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a customer gateway
//
// This example creates a customer gateway with the specified IP address for its outside
// interface.
func ExampleClient_CreateCustomerGatewayRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateCustomerGatewayInput{
		BgpAsn:   aws.Int64(65534),
		PublicIp: aws.String("12.1.2.3"),
		Type:     ec2.GatewayTypeIpsec1,
	}

	req := svc.CreateCustomerGatewayRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a DHCP options set
//
// This example creates a DHCP options set.
func ExampleClient_CreateDhcpOptionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateDhcpOptionsInput{
		DhcpConfigurations: []ec2.NewDhcpConfiguration{
			{
				Key: aws.String("domain-name-servers"),
				Values: []string{
					"10.2.5.1",
					"10.2.5.2",
				},
			},
		},
	}

	req := svc.CreateDhcpOptionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an AMI from an Amazon EBS-backed instance
//
// This example creates an AMI from the specified instance and adds an EBS volume with
// the device name /dev/sdh and an instance store volume with the device name /dev/sdc.
func ExampleClient_CreateImageRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateImageInput{
		BlockDeviceMappings: []ec2.BlockDeviceMapping{
			{
				DeviceName: aws.String("/dev/sdh"),
			},
			{
				DeviceName:  aws.String("/dev/sdc"),
				VirtualName: aws.String("ephemeral1"),
			},
		},
		Description: aws.String("An AMI for my server"),
		InstanceId:  aws.String("i-1234567890abcdef0"),
		Name:        aws.String("My server"),
		NoReboot:    aws.Bool(true),
	}

	req := svc.CreateImageRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an Internet gateway
//
// This example creates an Internet gateway.
func ExampleClient_CreateInternetGatewayRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateInternetGatewayInput{}

	req := svc.CreateInternetGatewayRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a key pair
//
// This example creates a key pair named my-key-pair.
func ExampleClient_CreateKeyPairRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateKeyPairInput{
		KeyName: aws.String("my-key-pair"),
	}

	req := svc.CreateKeyPairRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a launch template
//
// This example creates a launch template that specifies the subnet in which to launch
// the instance, assigns a public IP address and an IPv6 address to the instance, and
// creates a tag for the instance.
func ExampleClient_CreateLaunchTemplateRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateLaunchTemplateInput{
		LaunchTemplateData: &ec2.RequestLaunchTemplateData{
			ImageId:      aws.String("ami-8c1be5f6"),
			InstanceType: ec2.InstanceTypeT2Small,
			NetworkInterfaces: []ec2.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest{
				{
					AssociatePublicIpAddress: aws.Bool(true),
					DeviceIndex:              aws.Int64(0),
					Ipv6AddressCount:         aws.Int64(1),
					SubnetId:                 aws.String("subnet-7b16de0c"),
				},
			},
			TagSpecifications: []ec2.LaunchTemplateTagSpecificationRequest{
				{
					ResourceType: ec2.ResourceTypeInstance,
					Tags: []ec2.Tag{
						{
							Key:   aws.String("Name"),
							Value: aws.String("webserver"),
						},
					},
				},
			},
		},
		LaunchTemplateName: aws.String("my-template"),
		VersionDescription: aws.String("WebVersion1"),
	}

	req := svc.CreateLaunchTemplateRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a launch template version
//
// This example creates a new launch template version based on version 1 of the specified
// launch template and specifies a different AMI ID.
func ExampleClient_CreateLaunchTemplateVersionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateLaunchTemplateVersionInput{
		LaunchTemplateData: &ec2.RequestLaunchTemplateData{
			ImageId: aws.String("ami-c998b6b2"),
		},
		LaunchTemplateId:   aws.String("lt-0abcd290751193123"),
		SourceVersion:      aws.String("1"),
		VersionDescription: aws.String("WebVersion2"),
	}

	req := svc.CreateLaunchTemplateVersionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a NAT gateway
//
// This example creates a NAT gateway in subnet subnet-1a2b3c4d and associates an Elastic
// IP address with the allocation ID eipalloc-37fc1a52 with the NAT gateway.
func ExampleClient_CreateNatGatewayRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateNatGatewayInput{
		AllocationId: aws.String("eipalloc-37fc1a52"),
		SubnetId:     aws.String("subnet-1a2b3c4d"),
	}

	req := svc.CreateNatGatewayRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a network ACL
//
// This example creates a network ACL for the specified VPC.
func ExampleClient_CreateNetworkAclRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateNetworkAclInput{
		VpcId: aws.String("vpc-a01106c2"),
	}

	req := svc.CreateNetworkAclRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a network ACL entry
//
// This example creates an entry for the specified network ACL. The rule allows ingress
// traffic from anywhere (0.0.0.0/0) on UDP port 53 (DNS) into any associated subnet.
func ExampleClient_CreateNetworkAclEntryRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateNetworkAclEntryInput{
		CidrBlock:    aws.String("0.0.0.0/0"),
		Egress:       aws.Bool(false),
		NetworkAclId: aws.String("acl-5fb85d36"),
		PortRange: &ec2.PortRange{
			From: aws.Int64(53),
			To:   aws.Int64(53),
		},
		Protocol:   aws.String("17"),
		RuleAction: ec2.RuleActionAllow,
		RuleNumber: aws.Int64(100),
	}

	req := svc.CreateNetworkAclEntryRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a network interface
//
// This example creates a network interface for the specified subnet.
func ExampleClient_CreateNetworkInterfaceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateNetworkInterfaceInput{
		Description: aws.String("my network interface"),
		Groups: []string{
			"sg-903004f8",
		},
		PrivateIpAddress: aws.String("10.0.2.17"),
		SubnetId:         aws.String("subnet-9d4a7b6c"),
	}

	req := svc.CreateNetworkInterfaceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a placement group
//
// This example creates a placement group with the specified name.
func ExampleClient_CreatePlacementGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreatePlacementGroupInput{
		GroupName: aws.String("my-cluster"),
		Strategy:  ec2.PlacementStrategyCluster,
	}

	req := svc.CreatePlacementGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a route
//
// This example creates a route for the specified route table. The route matches all
// traffic (0.0.0.0/0) and routes it to the specified Internet gateway.
func ExampleClient_CreateRouteRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateRouteInput{
		DestinationCidrBlock: aws.String("0.0.0.0/0"),
		GatewayId:            aws.String("igw-c0a643a9"),
		RouteTableId:         aws.String("rtb-22574640"),
	}

	req := svc.CreateRouteRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a route table
//
// This example creates a route table for the specified VPC.
func ExampleClient_CreateRouteTableRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateRouteTableInput{
		VpcId: aws.String("vpc-a01106c2"),
	}

	req := svc.CreateRouteTableRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a security group for a VPC
//
// This example creates a security group for the specified VPC.
func ExampleClient_CreateSecurityGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateSecurityGroupInput{
		Description: aws.String("My security group"),
		GroupName:   aws.String("my-security-group"),
		VpcId:       aws.String("vpc-1a2b3c4d"),
	}

	req := svc.CreateSecurityGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a snapshot
//
// This example creates a snapshot of the volume with a volume ID of ``vol-1234567890abcdef0``
// and a short description to identify the snapshot.
func ExampleClient_CreateSnapshotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateSnapshotInput{
		Description: aws.String("This is my root volume snapshot."),
		VolumeId:    aws.String("vol-1234567890abcdef0"),
	}

	req := svc.CreateSnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a Spot Instance datafeed
//
// This example creates a Spot Instance data feed for your AWS account.
func ExampleClient_CreateSpotDatafeedSubscriptionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateSpotDatafeedSubscriptionInput{
		Bucket: aws.String("my-s3-bucket"),
		Prefix: aws.String("spotdata"),
	}

	req := svc.CreateSpotDatafeedSubscriptionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a subnet
//
// This example creates a subnet in the specified VPC with the specified CIDR block.
// We recommend that you let us select an Availability Zone for you.
func ExampleClient_CreateSubnetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateSubnetInput{
		CidrBlock: aws.String("10.0.1.0/24"),
		VpcId:     aws.String("vpc-a01106c2"),
	}

	req := svc.CreateSubnetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a tag to a resource
//
// This example adds the tag Stack=production to the specified image, or overwrites
// an existing tag for the AMI where the tag key is Stack.
func ExampleClient_CreateTagsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateTagsInput{
		Resources: []string{
			"ami-78a54011",
		},
		Tags: []ec2.Tag{
			{
				Key:   aws.String("Stack"),
				Value: aws.String("production"),
			},
		},
	}

	req := svc.CreateTagsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a new volume
//
// This example creates an 80 GiB General Purpose (SSD) volume in the Availability Zone
// ``us-east-1a``.
func ExampleClient_CreateVolumeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateVolumeInput{
		AvailabilityZone: aws.String("us-east-1a"),
		Size:             aws.Int64(80),
		VolumeType:       ec2.VolumeTypeGp2,
	}

	req := svc.CreateVolumeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a new Provisioned IOPS (SSD) volume from a snapshot
//
// This example creates a new Provisioned IOPS (SSD) volume with 1000 provisioned IOPS
// from a snapshot in the Availability Zone ``us-east-1a``.
func ExampleClient_CreateVolumeRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateVolumeInput{
		AvailabilityZone: aws.String("us-east-1a"),
		Iops:             aws.Int64(1000),
		SnapshotId:       aws.String("snap-066877671789bd71b"),
		VolumeType:       ec2.VolumeTypeIo1,
	}

	req := svc.CreateVolumeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a VPC
//
// This example creates a VPC with the specified CIDR block.
func ExampleClient_CreateVpcRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.CreateVpcInput{
		CidrBlock: aws.String("10.0.0.0/16"),
	}

	req := svc.CreateVpcRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a customer gateway
//
// This example deletes the specified customer gateway.
func ExampleClient_DeleteCustomerGatewayRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteCustomerGatewayInput{
		CustomerGatewayId: aws.String("cgw-0e11f167"),
	}

	req := svc.DeleteCustomerGatewayRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a DHCP options set
//
// This example deletes the specified DHCP options set.
func ExampleClient_DeleteDhcpOptionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteDhcpOptionsInput{
		DhcpOptionsId: aws.String("dopt-d9070ebb"),
	}

	req := svc.DeleteDhcpOptionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an Internet gateway
//
// This example deletes the specified Internet gateway.
func ExampleClient_DeleteInternetGatewayRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteInternetGatewayInput{
		InternetGatewayId: aws.String("igw-c0a643a9"),
	}

	req := svc.DeleteInternetGatewayRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a key pair
//
// This example deletes the specified key pair.
func ExampleClient_DeleteKeyPairRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteKeyPairInput{
		KeyName: aws.String("my-key-pair"),
	}

	req := svc.DeleteKeyPairRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a launch template
//
// This example deletes the specified launch template.
func ExampleClient_DeleteLaunchTemplateRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteLaunchTemplateInput{
		LaunchTemplateId: aws.String("lt-0abcd290751193123"),
	}

	req := svc.DeleteLaunchTemplateRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a launch template version
//
// This example deletes the specified launch template version.
func ExampleClient_DeleteLaunchTemplateVersionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteLaunchTemplateVersionsInput{
		LaunchTemplateId: aws.String("lt-0abcd290751193123"),
		Versions: []string{
			"1",
		},
	}

	req := svc.DeleteLaunchTemplateVersionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a NAT gateway
//
// This example deletes the specified NAT gateway.
func ExampleClient_DeleteNatGatewayRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteNatGatewayInput{
		NatGatewayId: aws.String("nat-04ae55e711cec5680"),
	}

	req := svc.DeleteNatGatewayRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a network ACL
//
// This example deletes the specified network ACL.
func ExampleClient_DeleteNetworkAclRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteNetworkAclInput{
		NetworkAclId: aws.String("acl-5fb85d36"),
	}

	req := svc.DeleteNetworkAclRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a network ACL entry
//
// This example deletes ingress rule number 100 from the specified network ACL.
func ExampleClient_DeleteNetworkAclEntryRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteNetworkAclEntryInput{
		Egress:       aws.Bool(true),
		NetworkAclId: aws.String("acl-5fb85d36"),
		RuleNumber:   aws.Int64(100),
	}

	req := svc.DeleteNetworkAclEntryRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a network interface
//
// This example deletes the specified network interface.
func ExampleClient_DeleteNetworkInterfaceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteNetworkInterfaceInput{
		NetworkInterfaceId: aws.String("eni-e5aa89a3"),
	}

	req := svc.DeleteNetworkInterfaceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a placement group
//
// This example deletes the specified placement group.
func ExampleClient_DeletePlacementGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeletePlacementGroupInput{
		GroupName: aws.String("my-cluster"),
	}

	req := svc.DeletePlacementGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a route
//
// This example deletes the specified route from the specified route table.
func ExampleClient_DeleteRouteRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteRouteInput{
		DestinationCidrBlock: aws.String("0.0.0.0/0"),
		RouteTableId:         aws.String("rtb-22574640"),
	}

	req := svc.DeleteRouteRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a route table
//
// This example deletes the specified route table.
func ExampleClient_DeleteRouteTableRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteRouteTableInput{
		RouteTableId: aws.String("rtb-22574640"),
	}

	req := svc.DeleteRouteTableRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a security group
//
// This example deletes the specified security group.
func ExampleClient_DeleteSecurityGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteSecurityGroupInput{
		GroupId: aws.String("sg-903004f8"),
	}

	req := svc.DeleteSecurityGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a snapshot
//
// This example deletes a snapshot with the snapshot ID of ``snap-1234567890abcdef0``.
// If the command succeeds, no output is returned.
func ExampleClient_DeleteSnapshotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteSnapshotInput{
		SnapshotId: aws.String("snap-1234567890abcdef0"),
	}

	req := svc.DeleteSnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To cancel a Spot Instance data feed subscription
//
// This example deletes a Spot data feed subscription for the account.
func ExampleClient_DeleteSpotDatafeedSubscriptionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteSpotDatafeedSubscriptionInput{}

	req := svc.DeleteSpotDatafeedSubscriptionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a subnet
//
// This example deletes the specified subnet.
func ExampleClient_DeleteSubnetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteSubnetInput{
		SubnetId: aws.String("subnet-9d4a7b6c"),
	}

	req := svc.DeleteSubnetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a tag from a resource
//
// This example deletes the tag Stack=test from the specified image.
func ExampleClient_DeleteTagsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteTagsInput{
		Resources: []string{
			"ami-78a54011",
		},
		Tags: []ec2.Tag{
			{
				Key:   aws.String("Stack"),
				Value: aws.String("test"),
			},
		},
	}

	req := svc.DeleteTagsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a volume
//
// This example deletes an available volume with the volume ID of ``vol-049df61146c4d7901``.
// If the command succeeds, no output is returned.
func ExampleClient_DeleteVolumeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteVolumeInput{
		VolumeId: aws.String("vol-049df61146c4d7901"),
	}

	req := svc.DeleteVolumeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a VPC
//
// This example deletes the specified VPC.
func ExampleClient_DeleteVpcRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DeleteVpcInput{
		VpcId: aws.String("vpc-a01106c2"),
	}

	req := svc.DeleteVpcRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a single attribute for your AWS account
//
// This example describes the supported-platforms attribute for your AWS account.
func ExampleClient_DescribeAccountAttributesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeAccountAttributesInput{
		AttributeNames: []ec2.AccountAttributeName{
			ec2.AccountAttributeName("supported-platforms"),
		},
	}

	req := svc.DescribeAccountAttributesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe all attributes for your AWS account
//
// This example describes the attributes for your AWS account.
func ExampleClient_DescribeAccountAttributesRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeAccountAttributesInput{}

	req := svc.DescribeAccountAttributesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Elastic IP addresses
//
// This example describes your Elastic IP addresses.
func ExampleClient_DescribeAddressesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeAddressesInput{}

	req := svc.DescribeAddressesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Elastic IP addresses for EC2-VPC
//
// This example describes your Elastic IP addresses for use with instances in a VPC.
func ExampleClient_DescribeAddressesRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeAddressesInput{
		Filters: []ec2.Filter{
			{
				Name: aws.String("domain"),
				Values: []string{
					"vpc",
				},
			},
		},
	}

	req := svc.DescribeAddressesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Elastic IP addresses for EC2-Classic
//
// This example describes your Elastic IP addresses for use with instances in EC2-Classic.
func ExampleClient_DescribeAddressesRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeAddressesInput{
		Filters: []ec2.Filter{
			{
				Name: aws.String("domain"),
				Values: []string{
					"standard",
				},
			},
		},
	}

	req := svc.DescribeAddressesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Availability Zones
//
// This example describes the Availability Zones that are available to you. The response
// includes Availability Zones only for the current region.
func ExampleClient_DescribeAvailabilityZonesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeAvailabilityZonesInput{}

	req := svc.DescribeAvailabilityZonesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a customer gateway
//
// This example describes the specified customer gateway.
func ExampleClient_DescribeCustomerGatewaysRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeCustomerGatewaysInput{
		CustomerGatewayIds: []string{
			"cgw-0e11f167",
		},
	}

	req := svc.DescribeCustomerGatewaysRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a DHCP options set
//
// This example describes the specified DHCP options set.
func ExampleClient_DescribeDhcpOptionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeDhcpOptionsInput{
		DhcpOptionsIds: []string{
			"dopt-d9070ebb",
		},
	}

	req := svc.DescribeDhcpOptionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe an IAM instance profile association
//
// This example describes the specified IAM instance profile association.
func ExampleClient_DescribeIamInstanceProfileAssociationsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeIamInstanceProfileAssociationsInput{
		AssociationIds: []string{
			"iip-assoc-0db249b1f25fa24b8",
		},
	}

	req := svc.DescribeIamInstanceProfileAssociationsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the launch permissions for an AMI
//
// This example describes the launch permissions for the specified AMI.
func ExampleClient_DescribeImageAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeImageAttributeInput{
		Attribute: ec2.ImageAttributeNameLaunchPermission,
		ImageId:   aws.String("ami-5731123e"),
	}

	req := svc.DescribeImageAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe an AMI
//
// This example describes the specified AMI.
func ExampleClient_DescribeImagesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeImagesInput{
		ImageIds: []string{
			"ami-5731123e",
		},
	}

	req := svc.DescribeImagesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the instance type
//
// This example describes the instance type of the specified instance.
func ExampleClient_DescribeInstanceAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeInstanceAttributeInput{
		Attribute:  ec2.InstanceAttributeNameInstanceType,
		InstanceId: aws.String("i-1234567890abcdef0"),
	}

	req := svc.DescribeInstanceAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the disableApiTermination attribute
//
// This example describes the ``disableApiTermination`` attribute of the specified instance.
func ExampleClient_DescribeInstanceAttributeRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeInstanceAttributeInput{
		Attribute:  ec2.InstanceAttributeNameDisableApiTermination,
		InstanceId: aws.String("i-1234567890abcdef0"),
	}

	req := svc.DescribeInstanceAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the block device mapping for an instance
//
// This example describes the ``blockDeviceMapping`` attribute of the specified instance.
func ExampleClient_DescribeInstanceAttributeRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeInstanceAttributeInput{
		Attribute:  ec2.InstanceAttributeNameBlockDeviceMapping,
		InstanceId: aws.String("i-1234567890abcdef0"),
	}

	req := svc.DescribeInstanceAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the status of an instance
//
// This example describes the current status of the specified instance.
func ExampleClient_DescribeInstanceStatusRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeInstanceStatusInput{
		InstanceIds: []string{
			"i-1234567890abcdef0",
		},
	}

	req := svc.DescribeInstanceStatusRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe an Amazon EC2 instance
//
// This example describes the specified instance.
func ExampleClient_DescribeInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeInstancesInput{
		InstanceIds: []string{
			"i-1234567890abcdef0",
		},
	}

	req := svc.DescribeInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the instances with a specific instance type
//
// This example describes the instances with the t2.micro instance type.
func ExampleClient_DescribeInstancesRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeInstancesInput{
		Filters: []ec2.Filter{
			{
				Name: aws.String("instance-type"),
				Values: []string{
					"t2.micro",
				},
			},
		},
	}

	req := svc.DescribeInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the instances with a specific tag
//
// This example describes the instances with the Purpose=test tag.
func ExampleClient_DescribeInstancesRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeInstancesInput{
		Filters: []ec2.Filter{
			{
				Name: aws.String("tag:Purpose"),
				Values: []string{
					"test",
				},
			},
		},
	}

	req := svc.DescribeInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the Internet gateway for a VPC
//
// This example describes the Internet gateway for the specified VPC.
func ExampleClient_DescribeInternetGatewaysRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeInternetGatewaysInput{
		Filters: []ec2.Filter{
			{
				Name: aws.String("attachment.vpc-id"),
				Values: []string{
					"vpc-a01106c2",
				},
			},
		},
	}

	req := svc.DescribeInternetGatewaysRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To display a key pair
//
// This example displays the fingerprint for the specified key.
func ExampleClient_DescribeKeyPairsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeKeyPairsInput{
		KeyNames: []string{
			"my-key-pair",
		},
	}

	req := svc.DescribeKeyPairsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the versions for a launch template
//
// This example describes the versions for the specified launch template.
func ExampleClient_DescribeLaunchTemplateVersionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeLaunchTemplateVersionsInput{
		LaunchTemplateId: aws.String("068f72b72934aff71"),
	}

	req := svc.DescribeLaunchTemplateVersionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a launch template
//
// This example describes the specified launch template.
func ExampleClient_DescribeLaunchTemplatesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeLaunchTemplatesInput{
		LaunchTemplateIds: []string{
			"lt-01238c059e3466abc",
		},
	}

	req := svc.DescribeLaunchTemplatesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your moving addresses
//
// This example describes all of your moving Elastic IP addresses.
func ExampleClient_DescribeMovingAddressesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeMovingAddressesInput{}

	req := svc.DescribeMovingAddressesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a NAT gateway
//
// This example describes the NAT gateway for the specified VPC.
func ExampleClient_DescribeNatGatewaysRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeNatGatewaysInput{
		Filter: []ec2.Filter{
			{
				Name: aws.String("vpc-id"),
				Values: []string{
					"vpc-1a2b3c4d",
				},
			},
		},
	}

	req := svc.DescribeNatGatewaysRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a network ACL
//
// This example describes the specified network ACL.
func ExampleClient_DescribeNetworkAclsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeNetworkAclsInput{
		NetworkAclIds: []string{
			"acl-5fb85d36",
		},
	}

	req := svc.DescribeNetworkAclsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the attachment attribute of a network interface
//
// This example describes the attachment attribute of the specified network interface.
func ExampleClient_DescribeNetworkInterfaceAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeNetworkInterfaceAttributeInput{
		Attribute:          ec2.NetworkInterfaceAttributeAttachment,
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	req := svc.DescribeNetworkInterfaceAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the description attribute of a network interface
//
// This example describes the description attribute of the specified network interface.
func ExampleClient_DescribeNetworkInterfaceAttributeRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeNetworkInterfaceAttributeInput{
		Attribute:          ec2.NetworkInterfaceAttributeDescription,
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	req := svc.DescribeNetworkInterfaceAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the groupSet attribute of a network interface
//
// This example describes the groupSet attribute of the specified network interface.
func ExampleClient_DescribeNetworkInterfaceAttributeRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeNetworkInterfaceAttributeInput{
		Attribute:          ec2.NetworkInterfaceAttributeGroupSet,
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	req := svc.DescribeNetworkInterfaceAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the sourceDestCheck attribute of a network interface
//
// This example describes the sourceDestCheck attribute of the specified network interface.
func ExampleClient_DescribeNetworkInterfaceAttributeRequest_shared03() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeNetworkInterfaceAttributeInput{
		Attribute:          ec2.NetworkInterfaceAttributeSourceDestCheck,
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	req := svc.DescribeNetworkInterfaceAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a network interface
//

func ExampleClient_DescribeNetworkInterfacesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeNetworkInterfacesInput{
		NetworkInterfaceIds: []string{
			"eni-e5aa89a3",
		},
	}

	req := svc.DescribeNetworkInterfacesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your regions
//
// This example describes all the regions that are available to you.
func ExampleClient_DescribeRegionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeRegionsInput{}

	req := svc.DescribeRegionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a route table
//
// This example describes the specified route table.
func ExampleClient_DescribeRouteTablesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeRouteTablesInput{
		RouteTableIds: []string{
			"rtb-1f382e7d",
		},
	}

	req := svc.DescribeRouteTablesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe an available schedule
//
// This example describes a schedule that occurs every week on Sunday, starting on the
// specified date. Note that the output contains a single schedule as an example.
func ExampleClient_DescribeScheduledInstanceAvailabilityRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeScheduledInstanceAvailabilityInput{
		FirstSlotStartTimeRange: &ec2.SlotDateTimeRangeRequest{
			EarliestTime: parseTime("2006-01-02T15:04:05Z", "2016-01-31T00:00:00Z"),
			LatestTime:   parseTime("2006-01-02T15:04:05Z", "2016-01-31T04:00:00Z"),
		},
		Recurrence: &ec2.ScheduledInstanceRecurrenceRequest{
			Frequency: aws.String("Weekly"),
			Interval:  aws.Int64(1),
			OccurrenceDays: []int64{
				1,
			},
		},
	}

	req := svc.DescribeScheduledInstanceAvailabilityRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Scheduled Instances
//
// This example describes the specified Scheduled Instance.
func ExampleClient_DescribeScheduledInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeScheduledInstancesInput{
		ScheduledInstanceIds: []string{
			"sci-1234-1234-1234-1234-123456789012",
		},
	}

	req := svc.DescribeScheduledInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe security group references
//
// This example describes the security group references for the specified security group.
func ExampleClient_DescribeSecurityGroupReferencesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeSecurityGroupReferencesInput{
		GroupId: []string{
			"sg-903004f8",
		},
	}

	req := svc.DescribeSecurityGroupReferencesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a security group
//
// This example describes the specified security group.
func ExampleClient_DescribeSecurityGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeSecurityGroupsInput{
		GroupIds: []string{
			"sg-903004f8",
		},
	}

	req := svc.DescribeSecurityGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a tagged security group
//
// This example describes the security groups that include the specified tag (Purpose=test).
func ExampleClient_DescribeSecurityGroupsRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeSecurityGroupsInput{
		Filters: []ec2.Filter{
			{
				Name: aws.String("tag:Purpose"),
				Values: []string{
					"test",
				},
			},
		},
	}

	req := svc.DescribeSecurityGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe snapshot attributes
//
// This example describes the ``createVolumePermission`` attribute on a snapshot with
// the snapshot ID of ``snap-066877671789bd71b``.
func ExampleClient_DescribeSnapshotAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeSnapshotAttributeInput{
		Attribute:  ec2.SnapshotAttributeNameCreateVolumePermission,
		SnapshotId: aws.String("snap-066877671789bd71b"),
	}

	req := svc.DescribeSnapshotAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a snapshot
//
// This example describes a snapshot with the snapshot ID of ``snap-1234567890abcdef0``.
func ExampleClient_DescribeSnapshotsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeSnapshotsInput{
		SnapshotIds: []string{
			"snap-1234567890abcdef0",
		},
	}

	req := svc.DescribeSnapshotsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe snapshots using filters
//
// This example describes all snapshots owned by the ID 012345678910 that are in the
// ``pending`` status.
func ExampleClient_DescribeSnapshotsRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeSnapshotsInput{
		Filters: []ec2.Filter{
			{
				Name: aws.String("status"),
				Values: []string{
					"pending",
				},
			},
		},
		OwnerIds: []string{
			"012345678910",
		},
	}

	req := svc.DescribeSnapshotsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the datafeed for your AWS account
//
// This example describes the Spot Instance datafeed subscription for your AWS account.
func ExampleClient_DescribeSpotDatafeedSubscriptionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeSpotDatafeedSubscriptionInput{}

	req := svc.DescribeSpotDatafeedSubscriptionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the Spot Instances associated with a Spot fleet
//
// This example lists the Spot Instances associated with the specified Spot fleet.
func ExampleClient_DescribeSpotFleetInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeSpotFleetInstancesInput{
		SpotFleetRequestId: aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
	}

	req := svc.DescribeSpotFleetInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe Spot fleet history
//
// This example returns the history for the specified Spot fleet starting at the specified
// time.
func ExampleClient_DescribeSpotFleetRequestHistoryRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeSpotFleetRequestHistoryInput{
		SpotFleetRequestId: aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
		StartTime:          parseTime("2006-01-02T15:04:05Z", "2015-05-26T00:00:00Z"),
	}

	req := svc.DescribeSpotFleetRequestHistoryRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a Spot fleet request
//
// This example describes the specified Spot fleet request.
func ExampleClient_DescribeSpotFleetRequestsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeSpotFleetRequestsInput{
		SpotFleetRequestIds: []string{
			"sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE",
		},
	}

	req := svc.DescribeSpotFleetRequestsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a Spot Instance request
//
// This example describes the specified Spot Instance request.
func ExampleClient_DescribeSpotInstanceRequestsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeSpotInstanceRequestsInput{
		SpotInstanceRequestIds: []string{
			"sir-08b93456",
		},
	}

	req := svc.DescribeSpotInstanceRequestsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe Spot price history for Linux/UNIX (Amazon VPC)
//
// This example returns the Spot Price history for m1.xlarge, Linux/UNIX (Amazon VPC)
// instances for a particular day in January.
func ExampleClient_DescribeSpotPriceHistoryRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeSpotPriceHistoryInput{
		EndTime: parseTime("2006-01-02T15:04:05Z", "2014-01-06T08:09:10"),
		InstanceTypes: []ec2.InstanceType{
			ec2.InstanceType("m1.xlarge"),
		},
		ProductDescriptions: []string{
			"Linux/UNIX (Amazon VPC)",
		},
		StartTime: parseTime("2006-01-02T15:04:05Z", "2014-01-06T07:08:09"),
	}

	req := svc.DescribeSpotPriceHistoryRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the subnets for a VPC
//
// This example describes the subnets for the specified VPC.
func ExampleClient_DescribeSubnetsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeSubnetsInput{
		Filters: []ec2.Filter{
			{
				Name: aws.String("vpc-id"),
				Values: []string{
					"vpc-a01106c2",
				},
			},
		},
	}

	req := svc.DescribeSubnetsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the tags for a single resource
//
// This example describes the tags for the specified instance.
func ExampleClient_DescribeTagsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeTagsInput{
		Filters: []ec2.Filter{
			{
				Name: aws.String("resource-id"),
				Values: []string{
					"i-1234567890abcdef8",
				},
			},
		},
	}

	req := svc.DescribeTagsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a volume attribute
//
// This example describes the ``autoEnableIo`` attribute of the volume with the ID ``vol-049df61146c4d7901``.
func ExampleClient_DescribeVolumeAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeVolumeAttributeInput{
		Attribute: ec2.VolumeAttributeNameAutoEnableIo,
		VolumeId:  aws.String("vol-049df61146c4d7901"),
	}

	req := svc.DescribeVolumeAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the status of a single volume
//
// This example describes the status for the volume ``vol-1234567890abcdef0``.
func ExampleClient_DescribeVolumeStatusRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeVolumeStatusInput{
		VolumeIds: []string{
			"vol-1234567890abcdef0",
		},
	}

	req := svc.DescribeVolumeStatusRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the status of impaired volumes
//
// This example describes the status for all volumes that are impaired. In this example
// output, there are no impaired volumes.
func ExampleClient_DescribeVolumeStatusRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeVolumeStatusInput{
		Filters: []ec2.Filter{
			{
				Name: aws.String("volume-status.status"),
				Values: []string{
					"impaired",
				},
			},
		},
	}

	req := svc.DescribeVolumeStatusRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe all volumes
//
// This example describes all of your volumes in the default region.
func ExampleClient_DescribeVolumesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeVolumesInput{}

	req := svc.DescribeVolumesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe volumes that are attached to a specific instance
//
// This example describes all volumes that are both attached to the instance with the
// ID i-1234567890abcdef0 and set to delete when the instance terminates.
func ExampleClient_DescribeVolumesRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeVolumesInput{
		Filters: []ec2.Filter{
			{
				Name: aws.String("attachment.instance-id"),
				Values: []string{
					"i-1234567890abcdef0",
				},
			},
			{
				Name: aws.String("attachment.delete-on-termination"),
				Values: []string{
					"true",
				},
			},
		},
	}

	req := svc.DescribeVolumesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the enableDnsSupport attribute
//
// This example describes the enableDnsSupport attribute. This attribute indicates whether
// DNS resolution is enabled for the VPC. If this attribute is true, the Amazon DNS
// server resolves DNS hostnames for your instances to their corresponding IP addresses;
// otherwise, it does not.
func ExampleClient_DescribeVpcAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeVpcAttributeInput{
		Attribute: ec2.VpcAttributeNameEnableDnsSupport,
		VpcId:     aws.String("vpc-a01106c2"),
	}

	req := svc.DescribeVpcAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the enableDnsHostnames attribute
//
// This example describes the enableDnsHostnames attribute. This attribute indicates
// whether the instances launched in the VPC get DNS hostnames. If this attribute is
// true, instances in the VPC get DNS hostnames; otherwise, they do not.
func ExampleClient_DescribeVpcAttributeRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeVpcAttributeInput{
		Attribute: ec2.VpcAttributeNameEnableDnsHostnames,
		VpcId:     aws.String("vpc-a01106c2"),
	}

	req := svc.DescribeVpcAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a VPC
//
// This example describes the specified VPC.
func ExampleClient_DescribeVpcsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DescribeVpcsInput{
		VpcIds: []string{
			"vpc-a01106c2",
		},
	}

	req := svc.DescribeVpcsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach an Internet gateway from a VPC
//
// This example detaches the specified Internet gateway from the specified VPC.
func ExampleClient_DetachInternetGatewayRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DetachInternetGatewayInput{
		InternetGatewayId: aws.String("igw-c0a643a9"),
		VpcId:             aws.String("vpc-a01106c2"),
	}

	req := svc.DetachInternetGatewayRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach a network interface from an instance
//
// This example detaches the specified network interface from its attached instance.
func ExampleClient_DetachNetworkInterfaceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DetachNetworkInterfaceInput{
		AttachmentId: aws.String("eni-attach-66c4350a"),
	}

	req := svc.DetachNetworkInterfaceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach a volume from an instance
//
// This example detaches the volume (``vol-049df61146c4d7901``) from the instance it
// is attached to.
func ExampleClient_DetachVolumeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DetachVolumeInput{
		VolumeId: aws.String("vol-1234567890abcdef0"),
	}

	req := svc.DetachVolumeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disable route propagation
//
// This example disables the specified virtual private gateway from propagating static
// routes to the specified route table.
func ExampleClient_DisableVgwRoutePropagationRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DisableVgwRoutePropagationInput{
		GatewayId:    aws.String("vgw-9a4cacf3"),
		RouteTableId: aws.String("rtb-22574640"),
	}

	req := svc.DisableVgwRoutePropagationRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disassociate an Elastic IP address in EC2-VPC
//
// This example disassociates an Elastic IP address from an instance in a VPC.
func ExampleClient_DisassociateAddressRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DisassociateAddressInput{
		AssociationId: aws.String("eipassoc-2bebb745"),
	}

	req := svc.DisassociateAddressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disassociate an Elastic IP addresses in EC2-Classic
//
// This example disassociates an Elastic IP address from an instance in EC2-Classic.
func ExampleClient_DisassociateAddressRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DisassociateAddressInput{
		PublicIp: aws.String("198.51.100.0"),
	}

	req := svc.DisassociateAddressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disassociate an IAM instance profile
//
// This example disassociates the specified IAM instance profile from an instance.
func ExampleClient_DisassociateIamInstanceProfileRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DisassociateIamInstanceProfileInput{
		AssociationId: aws.String("iip-assoc-05020b59952902f5f"),
	}

	req := svc.DisassociateIamInstanceProfileRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disassociate a route table
//
// This example disassociates the specified route table from its associated subnet.
func ExampleClient_DisassociateRouteTableRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.DisassociateRouteTableInput{
		AssociationId: aws.String("rtbassoc-781d0d1a"),
	}

	req := svc.DisassociateRouteTableRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable route propagation
//
// This example enables the specified virtual private gateway to propagate static routes
// to the specified route table.
func ExampleClient_EnableVgwRoutePropagationRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.EnableVgwRoutePropagationInput{
		GatewayId:    aws.String("vgw-9a4cacf3"),
		RouteTableId: aws.String("rtb-22574640"),
	}

	req := svc.EnableVgwRoutePropagationRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable I/O for a volume
//
// This example enables I/O on volume ``vol-1234567890abcdef0``.
func ExampleClient_EnableVolumeIORequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.EnableVolumeIOInput{
		VolumeId: aws.String("vol-1234567890abcdef0"),
	}

	req := svc.EnableVolumeIORequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get the console output
//
// This example gets the console output for the specified instance.
func ExampleClient_GetConsoleOutputRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.GetConsoleOutputInput{
		InstanceId: aws.String("i-1234567890abcdef0"),
	}

	req := svc.GetConsoleOutputRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get the launch template data for an instance
//
// This example gets the launch template data for the specified instance.
func ExampleClient_GetLaunchTemplateDataRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.GetLaunchTemplateDataInput{
		InstanceId: aws.String("0123d646e8048babc"),
	}

	req := svc.GetLaunchTemplateDataRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To make an AMI public
//
// This example makes the specified AMI public.
func ExampleClient_ModifyImageAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifyImageAttributeInput{
		ImageId: aws.String("ami-5731123e"),
		LaunchPermission: &ec2.LaunchPermissionModifications{
			Add: []ec2.LaunchPermission{
				{
					Group: ec2.PermissionGroupAll,
				},
			},
		},
	}

	req := svc.ModifyImageAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To grant launch permissions
//
// This example grants launch permissions for the specified AMI to the specified AWS
// account.
func ExampleClient_ModifyImageAttributeRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifyImageAttributeInput{
		ImageId: aws.String("ami-5731123e"),
		LaunchPermission: &ec2.LaunchPermissionModifications{
			Add: []ec2.LaunchPermission{
				{
					UserId: aws.String("123456789012"),
				},
			},
		},
	}

	req := svc.ModifyImageAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the instance type
//
// This example modifies the instance type of the specified stopped instance.
func ExampleClient_ModifyInstanceAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifyInstanceAttributeInput{
		InstanceId: aws.String("i-1234567890abcdef0"),
		InstanceType: &ec2.AttributeValue{
			Value: aws.String("m5.large"),
		},
	}

	req := svc.ModifyInstanceAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable enhanced networking
//
// This example enables enhanced networking for the specified stopped instance.
func ExampleClient_ModifyInstanceAttributeRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifyInstanceAttributeInput{
		EnaSupport: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
		InstanceId: aws.String("i-1234567890abcdef0"),
	}

	req := svc.ModifyInstanceAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change the default version of a launch template
//
// This example specifies version 2 as the default version of the specified launch template.
func ExampleClient_ModifyLaunchTemplateRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifyLaunchTemplateInput{
		DefaultVersion:   aws.String("2"),
		LaunchTemplateId: aws.String("lt-0abcd290751193123"),
	}

	req := svc.ModifyLaunchTemplateRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the attachment attribute of a network interface
//
// This example modifies the attachment attribute of the specified network interface.
func ExampleClient_ModifyNetworkInterfaceAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifyNetworkInterfaceAttributeInput{
		Attachment: &ec2.NetworkInterfaceAttachmentChanges{
			AttachmentId:        aws.String("eni-attach-43348162"),
			DeleteOnTermination: aws.Bool(false),
		},
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	req := svc.ModifyNetworkInterfaceAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the description attribute of a network interface
//
// This example modifies the description attribute of the specified network interface.
func ExampleClient_ModifyNetworkInterfaceAttributeRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifyNetworkInterfaceAttributeInput{
		Description: &ec2.AttributeValue{
			Value: aws.String("My description"),
		},
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	req := svc.ModifyNetworkInterfaceAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the groupSet attribute of a network interface
//
// This example command modifies the groupSet attribute of the specified network interface.
func ExampleClient_ModifyNetworkInterfaceAttributeRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifyNetworkInterfaceAttributeInput{
		Groups: []string{
			"sg-903004f8",
			"sg-1a2b3c4d",
		},
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	req := svc.ModifyNetworkInterfaceAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the sourceDestCheck attribute of a network interface
//
// This example command modifies the sourceDestCheck attribute of the specified network
// interface.
func ExampleClient_ModifyNetworkInterfaceAttributeRequest_shared03() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifyNetworkInterfaceAttributeInput{
		NetworkInterfaceId: aws.String("eni-686ea200"),
		SourceDestCheck: &ec2.AttributeBooleanValue{
			Value: aws.Bool(false),
		},
	}

	req := svc.ModifyNetworkInterfaceAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify a snapshot attribute
//
// This example modifies snapshot ``snap-1234567890abcdef0`` to remove the create volume
// permission for a user with the account ID ``123456789012``. If the command succeeds,
// no output is returned.
func ExampleClient_ModifySnapshotAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifySnapshotAttributeInput{
		Attribute:     ec2.SnapshotAttributeNameCreateVolumePermission,
		OperationType: ec2.OperationTypeRemove,
		SnapshotId:    aws.String("snap-1234567890abcdef0"),
		UserIds: []string{
			"123456789012",
		},
	}

	req := svc.ModifySnapshotAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To make a snapshot public
//
// This example makes the snapshot ``snap-1234567890abcdef0`` public.
func ExampleClient_ModifySnapshotAttributeRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifySnapshotAttributeInput{
		Attribute: ec2.SnapshotAttributeNameCreateVolumePermission,
		GroupNames: []string{
			"all",
		},
		OperationType: ec2.OperationTypeAdd,
		SnapshotId:    aws.String("snap-1234567890abcdef0"),
	}

	req := svc.ModifySnapshotAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To increase the target capacity of a Spot fleet request
//
// This example increases the target capacity of the specified Spot fleet request.
func ExampleClient_ModifySpotFleetRequestRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifySpotFleetRequestInput{
		SpotFleetRequestId: aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
		TargetCapacity:     aws.Int64(20),
	}

	req := svc.ModifySpotFleetRequestRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To decrease the target capacity of a Spot fleet request
//
// This example decreases the target capacity of the specified Spot fleet request without
// terminating any Spot Instances as a result.
func ExampleClient_ModifySpotFleetRequestRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifySpotFleetRequestInput{
		ExcessCapacityTerminationPolicy: ec2.ExcessCapacityTerminationPolicy("NoTermination "),
		SpotFleetRequestId:              aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
		TargetCapacity:                  aws.Int64(10),
	}

	req := svc.ModifySpotFleetRequestRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change a subnet's public IP addressing behavior
//
// This example modifies the specified subnet so that all instances launched into this
// subnet are assigned a public IP address.
func ExampleClient_ModifySubnetAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifySubnetAttributeInput{
		MapPublicIpOnLaunch: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
		SubnetId: aws.String("subnet-1a2b3c4d"),
	}

	req := svc.ModifySubnetAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify a volume attribute
//
// This example sets the ``autoEnableIo`` attribute of the volume with the ID ``vol-1234567890abcdef0``
// to ``true``. If the command succeeds, no output is returned.
func ExampleClient_ModifyVolumeAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifyVolumeAttributeInput{
		AutoEnableIO: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
		DryRun:   aws.Bool(true),
		VolumeId: aws.String("vol-1234567890abcdef0"),
	}

	req := svc.ModifyVolumeAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the enableDnsSupport attribute
//
// This example modifies the enableDnsSupport attribute. This attribute indicates whether
// DNS resolution is enabled for the VPC. If this attribute is true, the Amazon DNS
// server resolves DNS hostnames for instances in the VPC to their corresponding IP
// addresses; otherwise, it does not.
func ExampleClient_ModifyVpcAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifyVpcAttributeInput{
		EnableDnsSupport: &ec2.AttributeBooleanValue{
			Value: aws.Bool(false),
		},
		VpcId: aws.String("vpc-a01106c2"),
	}

	req := svc.ModifyVpcAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the enableDnsHostnames attribute
//
// This example modifies the enableDnsHostnames attribute. This attribute indicates
// whether instances launched in the VPC get DNS hostnames. If this attribute is true,
// instances in the VPC get DNS hostnames; otherwise, they do not.
func ExampleClient_ModifyVpcAttributeRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ModifyVpcAttributeInput{
		EnableDnsHostnames: &ec2.AttributeBooleanValue{
			Value: aws.Bool(false),
		},
		VpcId: aws.String("vpc-a01106c2"),
	}

	req := svc.ModifyVpcAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To move an address to EC2-VPC
//
// This example moves the specified Elastic IP address to the EC2-VPC platform.
func ExampleClient_MoveAddressToVpcRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.MoveAddressToVpcInput{
		PublicIp: aws.String("54.123.4.56"),
	}

	req := svc.MoveAddressToVpcRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To purchase a Scheduled Instance
//
// This example purchases a Scheduled Instance.
func ExampleClient_PurchaseScheduledInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.PurchaseScheduledInstancesInput{
		PurchaseRequests: []ec2.PurchaseRequest{
			{
				InstanceCount: aws.Int64(1),
				PurchaseToken: aws.String("eyJ2IjoiMSIsInMiOjEsImMiOi..."),
			},
		},
	}

	req := svc.PurchaseScheduledInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To reboot an EC2 instance
//
// This example reboots the specified EC2 instance.
func ExampleClient_RebootInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.RebootInstancesInput{
		InstanceIds: []string{
			"i-1234567890abcdef5",
		},
	}

	req := svc.RebootInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To release an Elastic IP address for EC2-VPC
//
// This example releases an Elastic IP address for use with instances in a VPC.
func ExampleClient_ReleaseAddressRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ReleaseAddressInput{
		AllocationId: aws.String("eipalloc-64d5890a"),
	}

	req := svc.ReleaseAddressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To release an Elastic IP addresses for EC2-Classic
//
// This example releases an Elastic IP address for use with instances in EC2-Classic.
func ExampleClient_ReleaseAddressRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ReleaseAddressInput{
		PublicIp: aws.String("198.51.100.0"),
	}

	req := svc.ReleaseAddressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace the network ACL associated with a subnet
//
// This example associates the specified network ACL with the subnet for the specified
// network ACL association.
func ExampleClient_ReplaceNetworkAclAssociationRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ReplaceNetworkAclAssociationInput{
		AssociationId: aws.String("aclassoc-e5b95c8c"),
		NetworkAclId:  aws.String("acl-5fb85d36"),
	}

	req := svc.ReplaceNetworkAclAssociationRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace a network ACL entry
//
// This example replaces an entry for the specified network ACL. The new rule 100 allows
// ingress traffic from 203.0.113.12/24 on UDP port 53 (DNS) into any associated subnet.
func ExampleClient_ReplaceNetworkAclEntryRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ReplaceNetworkAclEntryInput{
		CidrBlock:    aws.String("203.0.113.12/24"),
		Egress:       aws.Bool(false),
		NetworkAclId: aws.String("acl-5fb85d36"),
		PortRange: &ec2.PortRange{
			From: aws.Int64(53),
			To:   aws.Int64(53),
		},
		Protocol:   aws.String("17"),
		RuleAction: ec2.RuleActionAllow,
		RuleNumber: aws.Int64(100),
	}

	req := svc.ReplaceNetworkAclEntryRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace a route
//
// This example replaces the specified route in the specified table table. The new route
// matches the specified CIDR and sends the traffic to the specified virtual private
// gateway.
func ExampleClient_ReplaceRouteRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ReplaceRouteInput{
		DestinationCidrBlock: aws.String("10.0.0.0/16"),
		GatewayId:            aws.String("vgw-9a4cacf3"),
		RouteTableId:         aws.String("rtb-22574640"),
	}

	req := svc.ReplaceRouteRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace the route table associated with a subnet
//
// This example associates the specified route table with the subnet for the specified
// route table association.
func ExampleClient_ReplaceRouteTableAssociationRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ReplaceRouteTableAssociationInput{
		AssociationId: aws.String("rtbassoc-781d0d1a"),
		RouteTableId:  aws.String("rtb-22574640"),
	}

	req := svc.ReplaceRouteTableAssociationRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To request a Spot fleet in the subnet with the lowest price
//
// This example creates a Spot fleet request with two launch specifications that differ
// only by subnet. The Spot fleet launches the instances in the specified subnet with
// the lowest price. If the instances are launched in a default VPC, they receive a
// public IP address by default. If the instances are launched in a nondefault VPC,
// they do not receive a public IP address by default. Note that you can't specify different
// subnets from the same Availability Zone in a Spot fleet request.
func ExampleClient_RequestSpotFleetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.RequestSpotFleetInput{
		SpotFleetRequestConfig: &ec2.SpotFleetRequestConfigData{
			IamFleetRole: aws.String("arn:aws:iam::123456789012:role/my-spot-fleet-role"),
			LaunchSpecifications: []ec2.SpotFleetLaunchSpecification{
				{
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: ec2.InstanceTypeM3Medium,
					KeyName:      aws.String("my-key-pair"),
					SecurityGroups: []ec2.GroupIdentifier{
						{
							GroupId: aws.String("sg-1a2b3c4d"),
						},
					},
					SubnetId: aws.String("subnet-1a2b3c4d, subnet-3c4d5e6f"),
				},
			},
			SpotPrice:      aws.String("0.04"),
			TargetCapacity: aws.Int64(2),
		},
	}

	req := svc.RequestSpotFleetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To request a Spot fleet in the Availability Zone with the lowest price
//
// This example creates a Spot fleet request with two launch specifications that differ
// only by Availability Zone. The Spot fleet launches the instances in the specified
// Availability Zone with the lowest price. If your account supports EC2-VPC only, Amazon
// EC2 launches the Spot instances in the default subnet of the Availability Zone. If
// your account supports EC2-Classic, Amazon EC2 launches the instances in EC2-Classic
// in the Availability Zone.
func ExampleClient_RequestSpotFleetRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.RequestSpotFleetInput{
		SpotFleetRequestConfig: &ec2.SpotFleetRequestConfigData{
			IamFleetRole: aws.String("arn:aws:iam::123456789012:role/my-spot-fleet-role"),
			LaunchSpecifications: []ec2.SpotFleetLaunchSpecification{
				{
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: ec2.InstanceTypeM3Medium,
					KeyName:      aws.String("my-key-pair"),
					SecurityGroups: []ec2.GroupIdentifier{
						{
							GroupId: aws.String("sg-1a2b3c4d"),
						},
					},
				},
			},
			SpotPrice:      aws.String("0.04"),
			TargetCapacity: aws.Int64(2),
		},
	}

	req := svc.RequestSpotFleetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To launch Spot instances in a subnet and assign them public IP addresses
//
// This example assigns public addresses to instances launched in a nondefault VPC.
// Note that when you specify a network interface, you must include the subnet ID and
// security group ID using the network interface.
func ExampleClient_RequestSpotFleetRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.RequestSpotFleetInput{
		SpotFleetRequestConfig: &ec2.SpotFleetRequestConfigData{
			IamFleetRole: aws.String("arn:aws:iam::123456789012:role/my-spot-fleet-role"),
			LaunchSpecifications: []ec2.SpotFleetLaunchSpecification{
				{
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: ec2.InstanceTypeM3Medium,
					KeyName:      aws.String("my-key-pair"),
					NetworkInterfaces: []ec2.InstanceNetworkInterfaceSpecification{
						{
							AssociatePublicIpAddress: aws.Bool(true),
							DeviceIndex:              aws.Int64(0),
							Groups: []string{
								"sg-1a2b3c4d",
							},
							SubnetId: aws.String("subnet-1a2b3c4d"),
						},
					},
				},
			},
			SpotPrice:      aws.String("0.04"),
			TargetCapacity: aws.Int64(2),
		},
	}

	req := svc.RequestSpotFleetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To request a Spot fleet using the diversified allocation strategy
//
// This example creates a Spot fleet request that launches 30 instances using the diversified
// allocation strategy. The launch specifications differ by instance type. The Spot
// fleet distributes the instances across the launch specifications such that there
// are 10 instances of each type.
func ExampleClient_RequestSpotFleetRequest_shared03() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.RequestSpotFleetInput{
		SpotFleetRequestConfig: &ec2.SpotFleetRequestConfigData{
			AllocationStrategy: ec2.AllocationStrategyDiversified,
			IamFleetRole:       aws.String("arn:aws:iam::123456789012:role/my-spot-fleet-role"),
			LaunchSpecifications: []ec2.SpotFleetLaunchSpecification{
				{
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: ec2.InstanceTypeC42xlarge,
					SubnetId:     aws.String("subnet-1a2b3c4d"),
				},
				{
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: ec2.InstanceTypeM32xlarge,
					SubnetId:     aws.String("subnet-1a2b3c4d"),
				},
				{
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: ec2.InstanceTypeR32xlarge,
					SubnetId:     aws.String("subnet-1a2b3c4d"),
				},
			},
			SpotPrice:      aws.String("0.70"),
			TargetCapacity: aws.Int64(30),
		},
	}

	req := svc.RequestSpotFleetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a one-time Spot Instance request
//
// This example creates a one-time Spot Instance request for five instances in the specified
// Availability Zone. If your account supports EC2-VPC only, Amazon EC2 launches the
// instances in the default subnet of the specified Availability Zone. If your account
// supports EC2-Classic, Amazon EC2 launches the instances in EC2-Classic in the specified
// Availability Zone.
func ExampleClient_RequestSpotInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.RequestSpotInstancesInput{
		InstanceCount: aws.Int64(5),
		LaunchSpecification: &ec2.RequestSpotLaunchSpecification{
			IamInstanceProfile: &ec2.IamInstanceProfileSpecification{
				Arn: aws.String("arn:aws:iam::123456789012:instance-profile/my-iam-role"),
			},
			ImageId:      aws.String("ami-1a2b3c4d"),
			InstanceType: ec2.InstanceTypeM3Medium,
			KeyName:      aws.String("my-key-pair"),
			Placement: &ec2.SpotPlacement{
				AvailabilityZone: aws.String("us-west-2a"),
			},
			SecurityGroupIds: []string{
				"sg-1a2b3c4d",
			},
		},
		SpotPrice: aws.String("0.03"),
		Type:      ec2.SpotInstanceTypeOneTime,
	}

	req := svc.RequestSpotInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a one-time Spot Instance request
//
// This example command creates a one-time Spot Instance request for five instances
// in the specified subnet. Amazon EC2 launches the instances in the specified subnet.
// If the VPC is a nondefault VPC, the instances do not receive a public IP address
// by default.
func ExampleClient_RequestSpotInstancesRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.RequestSpotInstancesInput{
		InstanceCount: aws.Int64(5),
		LaunchSpecification: &ec2.RequestSpotLaunchSpecification{
			IamInstanceProfile: &ec2.IamInstanceProfileSpecification{
				Arn: aws.String("arn:aws:iam::123456789012:instance-profile/my-iam-role"),
			},
			ImageId:      aws.String("ami-1a2b3c4d"),
			InstanceType: ec2.InstanceTypeM3Medium,
			SecurityGroupIds: []string{
				"sg-1a2b3c4d",
			},
			SubnetId: aws.String("subnet-1a2b3c4d"),
		},
		SpotPrice: aws.String("0.050"),
		Type:      ec2.SpotInstanceTypeOneTime,
	}

	req := svc.RequestSpotInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To reset the launchPermission attribute
//
// This example resets the launchPermission attribute for the specified AMI. By default,
// AMIs are private.
func ExampleClient_ResetImageAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ResetImageAttributeInput{
		Attribute: ec2.ResetImageAttributeNameLaunchPermission,
		ImageId:   aws.String("ami-5731123e"),
	}

	req := svc.ResetImageAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To reset the sourceDestCheck attribute
//
// This example resets the sourceDestCheck attribute for the specified instance.
func ExampleClient_ResetInstanceAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ResetInstanceAttributeInput{
		Attribute:  ec2.InstanceAttributeNameSourceDestCheck,
		InstanceId: aws.String("i-1234567890abcdef0"),
	}

	req := svc.ResetInstanceAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To reset a snapshot attribute
//
// This example resets the create volume permissions for snapshot ``snap-1234567890abcdef0``.
// If the command succeeds, no output is returned.
func ExampleClient_ResetSnapshotAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.ResetSnapshotAttributeInput{
		Attribute:  ec2.SnapshotAttributeNameCreateVolumePermission,
		SnapshotId: aws.String("snap-1234567890abcdef0"),
	}

	req := svc.ResetSnapshotAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To restore an address to EC2-Classic
//
// This example restores the specified Elastic IP address to the EC2-Classic platform.
func ExampleClient_RestoreAddressToClassicRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.RestoreAddressToClassicInput{
		PublicIp: aws.String("198.51.100.0"),
	}

	req := svc.RestoreAddressToClassicRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To launch an instance
//
// This example launches an instance using the specified AMI, instance type, security
// group, subnet, block device mapping, and tags.
func ExampleClient_RunInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.RunInstancesInput{
		BlockDeviceMappings: []ec2.BlockDeviceMapping{
			{
				DeviceName: aws.String("/dev/sdh"),
			},
		},
		ImageId:      aws.String("ami-abc12345"),
		InstanceType: ec2.InstanceTypeT2Micro,
		KeyName:      aws.String("my-key-pair"),
		MaxCount:     aws.Int64(1),
		MinCount:     aws.Int64(1),
		SecurityGroupIds: []string{
			"sg-1a2b3c4d",
		},
		SubnetId: aws.String("subnet-6e7f829e"),
		TagSpecifications: []ec2.TagSpecification{
			{
				ResourceType: ec2.ResourceTypeInstance,
				Tags: []ec2.Tag{
					{
						Key:   aws.String("Purpose"),
						Value: aws.String("test"),
					},
				},
			},
		},
	}

	req := svc.RunInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To launch a Scheduled Instance in a VPC
//
// This example launches the specified Scheduled Instance in a VPC.
func ExampleClient_RunScheduledInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.RunScheduledInstancesInput{
		InstanceCount: aws.Int64(1),
		LaunchSpecification: &ec2.ScheduledInstancesLaunchSpecification{
			IamInstanceProfile: &ec2.ScheduledInstancesIamInstanceProfile{
				Name: aws.String("my-iam-role"),
			},
			ImageId:      aws.String("ami-12345678"),
			InstanceType: aws.String("c4.large"),
			KeyName:      aws.String("my-key-pair"),
			NetworkInterfaces: []ec2.ScheduledInstancesNetworkInterface{
				{
					AssociatePublicIpAddress: aws.Bool(true),
					DeviceIndex:              aws.Int64(0),
					Groups: []string{
						"sg-12345678",
					},
					SubnetId: aws.String("subnet-12345678"),
				},
			},
		},
		ScheduledInstanceId: aws.String("sci-1234-1234-1234-1234-123456789012"),
	}

	req := svc.RunScheduledInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To launch a Scheduled Instance in EC2-Classic
//
// This example launches the specified Scheduled Instance in EC2-Classic.
func ExampleClient_RunScheduledInstancesRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.RunScheduledInstancesInput{
		InstanceCount: aws.Int64(1),
		LaunchSpecification: &ec2.ScheduledInstancesLaunchSpecification{
			IamInstanceProfile: &ec2.ScheduledInstancesIamInstanceProfile{
				Name: aws.String("my-iam-role"),
			},
			ImageId:      aws.String("ami-12345678"),
			InstanceType: aws.String("c4.large"),
			KeyName:      aws.String("my-key-pair"),
			Placement: &ec2.ScheduledInstancesPlacement{
				AvailabilityZone: aws.String("us-west-2b"),
			},
			SecurityGroupIds: []string{
				"sg-12345678",
			},
		},
		ScheduledInstanceId: aws.String("sci-1234-1234-1234-1234-123456789012"),
	}

	req := svc.RunScheduledInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To start a stopped EC2 instance
//
// This example starts the specified EC2 instance.
func ExampleClient_StartInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.StartInstancesInput{
		InstanceIds: []string{
			"i-1234567890abcdef0",
		},
	}

	req := svc.StartInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To stop a running EC2 instance
//
// This example stops the specified EC2 instance.
func ExampleClient_StopInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.StopInstancesInput{
		InstanceIds: []string{
			"i-1234567890abcdef0",
		},
	}

	req := svc.StopInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To terminate an EC2 instance
//
// This example terminates the specified EC2 instance.
func ExampleClient_TerminateInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.TerminateInstancesInput{
		InstanceIds: []string{
			"i-1234567890abcdef0",
		},
	}

	req := svc.TerminateInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To unassign a secondary private IP address from a network interface
//
// This example unassigns the specified private IP address from the specified network
// interface.
func ExampleClient_UnassignPrivateIpAddressesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.UnassignPrivateIpAddressesInput{
		NetworkInterfaceId: aws.String("eni-e5aa89a3"),
		PrivateIpAddresses: []string{
			"10.0.0.82",
		},
	}

	req := svc.UnassignPrivateIpAddressesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update an outbound security group rule description
//
// This example updates the description for the specified security group rule.
func ExampleClient_UpdateSecurityGroupRuleDescriptionsEgressRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.UpdateSecurityGroupRuleDescriptionsEgressInput{
		GroupId: aws.String("sg-123abc12"),
		IpPermissions: []ec2.IpPermission{
			{
				FromPort:   aws.Int64(80),
				IpProtocol: aws.String("tcp"),
				IpRanges: []ec2.IpRange{
					{
						CidrIp:      aws.String("203.0.113.0/24"),
						Description: aws.String("Outbound HTTP access to server 2"),
					},
				},
				ToPort: aws.Int64(80),
			},
		},
	}

	req := svc.UpdateSecurityGroupRuleDescriptionsEgressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update an inbound security group rule description
//
// This example updates the description for the specified security group rule.
func ExampleClient_UpdateSecurityGroupRuleDescriptionsIngressRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := ec2.New(cfg)
	input := &ec2.UpdateSecurityGroupRuleDescriptionsIngressInput{
		GroupId: aws.String("sg-123abc12"),
		IpPermissions: []ec2.IpPermission{
			{
				FromPort:   aws.Int64(22),
				IpProtocol: aws.String("tcp"),
				IpRanges: []ec2.IpRange{
					{
						CidrIp:      aws.String("203.0.113.0/16"),
						Description: aws.String("SSH access from the LA office"),
					},
				},
				ToPort: aws.Int64(22),
			},
		},
	}

	req := svc.UpdateSecurityGroupRuleDescriptionsIngressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
