// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartImportLabelsTaskRunInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Simple Storage Service (Amazon S3) path from where you import
	// the labels.
	//
	// InputS3Path is a required field
	InputS3Path *string `type:"string" required:"true"`

	// Indicates whether to overwrite your existing labels.
	ReplaceAllLabels *bool `type:"boolean"`

	// The unique identifier of the machine learning transform.
	//
	// TransformId is a required field
	TransformId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartImportLabelsTaskRunInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartImportLabelsTaskRunInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartImportLabelsTaskRunInput"}

	if s.InputS3Path == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputS3Path"))
	}

	if s.TransformId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformId"))
	}
	if s.TransformId != nil && len(*s.TransformId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TransformId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartImportLabelsTaskRunOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the task run.
	TaskRunId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartImportLabelsTaskRunOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartImportLabelsTaskRun = "StartImportLabelsTaskRun"

// StartImportLabelsTaskRunRequest returns a request value for making API operation for
// AWS Glue.
//
// Enables you to provide additional labels (examples of truth) to be used to
// teach the machine learning transform and improve its quality. This API operation
// is generally used as part of the active learning workflow that starts with
// the StartMLLabelingSetGenerationTaskRun call and that ultimately results
// in improving the quality of your machine learning transform.
//
// After the StartMLLabelingSetGenerationTaskRun finishes, AWS Glue machine
// learning will have generated a series of questions for humans to answer.
// (Answering these questions is often called 'labeling' in the machine learning
// workflows). In the case of the FindMatches transform, these questions are
// of the form, “What is the correct way to group these rows together into
// groups composed entirely of matching records?” After the labeling process
// is finished, users upload their answers/labels with a call to StartImportLabelsTaskRun.
// After StartImportLabelsTaskRun finishes, all future runs of the machine learning
// transform use the new and improved labels and perform a higher-quality transformation.
//
// By default, StartMLLabelingSetGenerationTaskRun continually learns from and
// combines all labels that you upload unless you set Replace to true. If you
// set Replace to true, StartImportLabelsTaskRun deletes and forgets all previously
// uploaded labels and learns only from the exact set that you upload. Replacing
// labels can be helpful if you realize that you previously uploaded incorrect
// labels, and you believe that they are having a negative effect on your transform
// quality.
//
// You can check on the status of your task run by calling the GetMLTaskRun
// operation.
//
//    // Example sending a request using StartImportLabelsTaskRunRequest.
//    req := client.StartImportLabelsTaskRunRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartImportLabelsTaskRun
func (c *Client) StartImportLabelsTaskRunRequest(input *StartImportLabelsTaskRunInput) StartImportLabelsTaskRunRequest {
	op := &aws.Operation{
		Name:       opStartImportLabelsTaskRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartImportLabelsTaskRunInput{}
	}

	req := c.newRequest(op, input, &StartImportLabelsTaskRunOutput{})
	return StartImportLabelsTaskRunRequest{Request: req, Input: input, Copy: c.StartImportLabelsTaskRunRequest}
}

// StartImportLabelsTaskRunRequest is the request type for the
// StartImportLabelsTaskRun API operation.
type StartImportLabelsTaskRunRequest struct {
	*aws.Request
	Input *StartImportLabelsTaskRunInput
	Copy  func(*StartImportLabelsTaskRunInput) StartImportLabelsTaskRunRequest
}

// Send marshals and sends the StartImportLabelsTaskRun API request.
func (r StartImportLabelsTaskRunRequest) Send(ctx context.Context) (*StartImportLabelsTaskRunResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartImportLabelsTaskRunResponse{
		StartImportLabelsTaskRunOutput: r.Request.Data.(*StartImportLabelsTaskRunOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartImportLabelsTaskRunResponse is the response type for the
// StartImportLabelsTaskRun API operation.
type StartImportLabelsTaskRunResponse struct {
	*StartImportLabelsTaskRunOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartImportLabelsTaskRun request.
func (r *StartImportLabelsTaskRunResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
