// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsecuretunneling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeTunnelInput struct {
	_ struct{} `type:"structure"`

	// The tunnel to describe.
	//
	// TunnelId is a required field
	TunnelId *string `locationName:"tunnelId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTunnelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTunnelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTunnelInput"}

	if s.TunnelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TunnelId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeTunnelOutput struct {
	_ struct{} `type:"structure"`

	// The tunnel being described.
	Tunnel *Tunnel `locationName:"tunnel" type:"structure"`
}

// String returns the string representation
func (s DescribeTunnelOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTunnel = "DescribeTunnel"

// DescribeTunnelRequest returns a request value for making API operation for
// AWS IoT Secure Tunneling.
//
// Gets information about a tunnel identified by the unique tunnel id.
//
//    // Example sending a request using DescribeTunnelRequest.
//    req := client.DescribeTunnelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/DescribeTunnel
func (c *Client) DescribeTunnelRequest(input *DescribeTunnelInput) DescribeTunnelRequest {
	op := &aws.Operation{
		Name:       opDescribeTunnel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTunnelInput{}
	}

	req := c.newRequest(op, input, &DescribeTunnelOutput{})
	return DescribeTunnelRequest{Request: req, Input: input, Copy: c.DescribeTunnelRequest}
}

// DescribeTunnelRequest is the request type for the
// DescribeTunnel API operation.
type DescribeTunnelRequest struct {
	*aws.Request
	Input *DescribeTunnelInput
	Copy  func(*DescribeTunnelInput) DescribeTunnelRequest
}

// Send marshals and sends the DescribeTunnel API request.
func (r DescribeTunnelRequest) Send(ctx context.Context) (*DescribeTunnelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTunnelResponse{
		DescribeTunnelOutput: r.Request.Data.(*DescribeTunnelOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTunnelResponse is the response type for the
// DescribeTunnel API operation.
type DescribeTunnelResponse struct {
	*DescribeTunnelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTunnel request.
func (r *DescribeTunnelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
