// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetDomainsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get domains
	// request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetDomainsInput) String() string {
	return awsutil.Prettify(s)
}

type GetDomainsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about each of the domain
	// entries in the user's account.
	Domains []Domain `locationName:"domains" type:"list"`

	// A token used for advancing to the next page of results from your get active
	// names request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDomains = "GetDomains"

// GetDomainsRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns a list of all domains in the user's account.
//
//    // Example sending a request using GetDomainsRequest.
//    req := client.GetDomainsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains
func (c *Client) GetDomainsRequest(input *GetDomainsInput) GetDomainsRequest {
	op := &aws.Operation{
		Name:       opGetDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDomainsInput{}
	}

	req := c.newRequest(op, input, &GetDomainsOutput{})
	return GetDomainsRequest{Request: req, Input: input, Copy: c.GetDomainsRequest}
}

// GetDomainsRequest is the request type for the
// GetDomains API operation.
type GetDomainsRequest struct {
	*aws.Request
	Input *GetDomainsInput
	Copy  func(*GetDomainsInput) GetDomainsRequest
}

// Send marshals and sends the GetDomains API request.
func (r GetDomainsRequest) Send(ctx context.Context) (*GetDomainsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDomainsResponse{
		GetDomainsOutput: r.Request.Data.(*GetDomainsOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDomainsResponse is the response type for the
// GetDomains API operation.
type GetDomainsResponse struct {
	*GetDomainsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDomains request.
func (r *GetDomainsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
