// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1/featurestore_online_service.proto

package aiplatformpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	FeaturestoreOnlineServingService_ReadFeatureValues_FullMethodName          = "/google.cloud.aiplatform.v1.FeaturestoreOnlineServingService/ReadFeatureValues"
	FeaturestoreOnlineServingService_StreamingReadFeatureValues_FullMethodName = "/google.cloud.aiplatform.v1.FeaturestoreOnlineServingService/StreamingReadFeatureValues"
	FeaturestoreOnlineServingService_WriteFeatureValues_FullMethodName         = "/google.cloud.aiplatform.v1.FeaturestoreOnlineServingService/WriteFeatureValues"
)

// FeaturestoreOnlineServingServiceClient is the client API for FeaturestoreOnlineServingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FeaturestoreOnlineServingServiceClient interface {
	// Reads Feature values of a specific entity of an EntityType. For reading
	// feature values of multiple entities of an EntityType, please use
	// StreamingReadFeatureValues.
	ReadFeatureValues(ctx context.Context, in *ReadFeatureValuesRequest, opts ...grpc.CallOption) (*ReadFeatureValuesResponse, error)
	// Reads Feature values for multiple entities. Depending on their size, data
	// for different entities may be broken
	// up across multiple responses.
	StreamingReadFeatureValues(ctx context.Context, in *StreamingReadFeatureValuesRequest, opts ...grpc.CallOption) (FeaturestoreOnlineServingService_StreamingReadFeatureValuesClient, error)
	// Writes Feature values of one or more entities of an EntityType.
	//
	// The Feature values are merged into existing entities if any. The Feature
	// values to be written must have timestamp within the online storage
	// retention.
	WriteFeatureValues(ctx context.Context, in *WriteFeatureValuesRequest, opts ...grpc.CallOption) (*WriteFeatureValuesResponse, error)
}

type featurestoreOnlineServingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFeaturestoreOnlineServingServiceClient(cc grpc.ClientConnInterface) FeaturestoreOnlineServingServiceClient {
	return &featurestoreOnlineServingServiceClient{cc}
}

func (c *featurestoreOnlineServingServiceClient) ReadFeatureValues(ctx context.Context, in *ReadFeatureValuesRequest, opts ...grpc.CallOption) (*ReadFeatureValuesResponse, error) {
	out := new(ReadFeatureValuesResponse)
	err := c.cc.Invoke(ctx, FeaturestoreOnlineServingService_ReadFeatureValues_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreOnlineServingServiceClient) StreamingReadFeatureValues(ctx context.Context, in *StreamingReadFeatureValuesRequest, opts ...grpc.CallOption) (FeaturestoreOnlineServingService_StreamingReadFeatureValuesClient, error) {
	stream, err := c.cc.NewStream(ctx, &FeaturestoreOnlineServingService_ServiceDesc.Streams[0], FeaturestoreOnlineServingService_StreamingReadFeatureValues_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &featurestoreOnlineServingServiceStreamingReadFeatureValuesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type FeaturestoreOnlineServingService_StreamingReadFeatureValuesClient interface {
	Recv() (*ReadFeatureValuesResponse, error)
	grpc.ClientStream
}

type featurestoreOnlineServingServiceStreamingReadFeatureValuesClient struct {
	grpc.ClientStream
}

func (x *featurestoreOnlineServingServiceStreamingReadFeatureValuesClient) Recv() (*ReadFeatureValuesResponse, error) {
	m := new(ReadFeatureValuesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *featurestoreOnlineServingServiceClient) WriteFeatureValues(ctx context.Context, in *WriteFeatureValuesRequest, opts ...grpc.CallOption) (*WriteFeatureValuesResponse, error) {
	out := new(WriteFeatureValuesResponse)
	err := c.cc.Invoke(ctx, FeaturestoreOnlineServingService_WriteFeatureValues_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FeaturestoreOnlineServingServiceServer is the server API for FeaturestoreOnlineServingService service.
// All implementations should embed UnimplementedFeaturestoreOnlineServingServiceServer
// for forward compatibility
type FeaturestoreOnlineServingServiceServer interface {
	// Reads Feature values of a specific entity of an EntityType. For reading
	// feature values of multiple entities of an EntityType, please use
	// StreamingReadFeatureValues.
	ReadFeatureValues(context.Context, *ReadFeatureValuesRequest) (*ReadFeatureValuesResponse, error)
	// Reads Feature values for multiple entities. Depending on their size, data
	// for different entities may be broken
	// up across multiple responses.
	StreamingReadFeatureValues(*StreamingReadFeatureValuesRequest, FeaturestoreOnlineServingService_StreamingReadFeatureValuesServer) error
	// Writes Feature values of one or more entities of an EntityType.
	//
	// The Feature values are merged into existing entities if any. The Feature
	// values to be written must have timestamp within the online storage
	// retention.
	WriteFeatureValues(context.Context, *WriteFeatureValuesRequest) (*WriteFeatureValuesResponse, error)
}

// UnimplementedFeaturestoreOnlineServingServiceServer should be embedded to have forward compatible implementations.
type UnimplementedFeaturestoreOnlineServingServiceServer struct {
}

func (UnimplementedFeaturestoreOnlineServingServiceServer) ReadFeatureValues(context.Context, *ReadFeatureValuesRequest) (*ReadFeatureValuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadFeatureValues not implemented")
}
func (UnimplementedFeaturestoreOnlineServingServiceServer) StreamingReadFeatureValues(*StreamingReadFeatureValuesRequest, FeaturestoreOnlineServingService_StreamingReadFeatureValuesServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingReadFeatureValues not implemented")
}
func (UnimplementedFeaturestoreOnlineServingServiceServer) WriteFeatureValues(context.Context, *WriteFeatureValuesRequest) (*WriteFeatureValuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteFeatureValues not implemented")
}

// UnsafeFeaturestoreOnlineServingServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FeaturestoreOnlineServingServiceServer will
// result in compilation errors.
type UnsafeFeaturestoreOnlineServingServiceServer interface {
	mustEmbedUnimplementedFeaturestoreOnlineServingServiceServer()
}

func RegisterFeaturestoreOnlineServingServiceServer(s grpc.ServiceRegistrar, srv FeaturestoreOnlineServingServiceServer) {
	s.RegisterService(&FeaturestoreOnlineServingService_ServiceDesc, srv)
}

func _FeaturestoreOnlineServingService_ReadFeatureValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadFeatureValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreOnlineServingServiceServer).ReadFeatureValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreOnlineServingService_ReadFeatureValues_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreOnlineServingServiceServer).ReadFeatureValues(ctx, req.(*ReadFeatureValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreOnlineServingService_StreamingReadFeatureValues_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamingReadFeatureValuesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(FeaturestoreOnlineServingServiceServer).StreamingReadFeatureValues(m, &featurestoreOnlineServingServiceStreamingReadFeatureValuesServer{stream})
}

type FeaturestoreOnlineServingService_StreamingReadFeatureValuesServer interface {
	Send(*ReadFeatureValuesResponse) error
	grpc.ServerStream
}

type featurestoreOnlineServingServiceStreamingReadFeatureValuesServer struct {
	grpc.ServerStream
}

func (x *featurestoreOnlineServingServiceStreamingReadFeatureValuesServer) Send(m *ReadFeatureValuesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _FeaturestoreOnlineServingService_WriteFeatureValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteFeatureValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreOnlineServingServiceServer).WriteFeatureValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreOnlineServingService_WriteFeatureValues_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreOnlineServingServiceServer).WriteFeatureValues(ctx, req.(*WriteFeatureValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// FeaturestoreOnlineServingService_ServiceDesc is the grpc.ServiceDesc for FeaturestoreOnlineServingService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var FeaturestoreOnlineServingService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.FeaturestoreOnlineServingService",
	HandlerType: (*FeaturestoreOnlineServingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ReadFeatureValues",
			Handler:    _FeaturestoreOnlineServingService_ReadFeatureValues_Handler,
		},
		{
			MethodName: "WriteFeatureValues",
			Handler:    _FeaturestoreOnlineServingService_WriteFeatureValues_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingReadFeatureValues",
			Handler:       _FeaturestoreOnlineServingService_StreamingReadFeatureValues_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/aiplatform/v1/featurestore_online_service.proto",
}
