// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1beta1/pipeline_job.proto

package aiplatformpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// An enum that specifies the behavior to take if the timeout is reached.
type PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior int32

const (
	// Unspecified. Behavior is same as `FAIL`.
	PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TASK_RESOURCE_UNAVAILABLE_TIMEOUT_BEHAVIOR_UNSPECIFIED PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior = 0
	// Fail the task if the timeout is reached.
	PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_FAIL PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior = 1
	// Fall back to on-demand execution if the timeout is reached.
	PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_FALL_BACK_TO_ON_DEMAND PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior = 2
)

// Enum value maps for PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior.
var (
	PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior_name = map[int32]string{
		0: "TASK_RESOURCE_UNAVAILABLE_TIMEOUT_BEHAVIOR_UNSPECIFIED",
		1: "FAIL",
		2: "FALL_BACK_TO_ON_DEMAND",
	}
	PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior_value = map[string]int32{
		"TASK_RESOURCE_UNAVAILABLE_TIMEOUT_BEHAVIOR_UNSPECIFIED": 0,
		"FAIL":                   1,
		"FALL_BACK_TO_ON_DEMAND": 2,
	}
)

func (x PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior) Enum() *PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior {
	p := new(PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior)
	*p = x
	return p
}

func (x PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_enumTypes[0].Descriptor()
}

func (PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_enumTypes[0]
}

func (x PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior.Descriptor instead.
func (PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{0, 0, 1, 0}
}

// Specifies state of TaskExecution
type PipelineTaskDetail_State int32

const (
	// Unspecified.
	PipelineTaskDetail_STATE_UNSPECIFIED PipelineTaskDetail_State = 0
	// Specifies pending state for the task.
	PipelineTaskDetail_PENDING PipelineTaskDetail_State = 1
	// Specifies task is being executed.
	PipelineTaskDetail_RUNNING PipelineTaskDetail_State = 2
	// Specifies task completed successfully.
	PipelineTaskDetail_SUCCEEDED PipelineTaskDetail_State = 3
	// Specifies Task cancel is in pending state.
	PipelineTaskDetail_CANCEL_PENDING PipelineTaskDetail_State = 4
	// Specifies task is being cancelled.
	PipelineTaskDetail_CANCELLING PipelineTaskDetail_State = 5
	// Specifies task was cancelled.
	PipelineTaskDetail_CANCELLED PipelineTaskDetail_State = 6
	// Specifies task failed.
	PipelineTaskDetail_FAILED PipelineTaskDetail_State = 7
	// Specifies task was skipped due to cache hit.
	PipelineTaskDetail_SKIPPED PipelineTaskDetail_State = 8
	// Specifies that the task was not triggered because the task's trigger
	// policy is not satisfied. The trigger policy is specified in the
	// `condition` field of
	// [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec].
	PipelineTaskDetail_NOT_TRIGGERED PipelineTaskDetail_State = 9
)

// Enum value maps for PipelineTaskDetail_State.
var (
	PipelineTaskDetail_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "RUNNING",
		3: "SUCCEEDED",
		4: "CANCEL_PENDING",
		5: "CANCELLING",
		6: "CANCELLED",
		7: "FAILED",
		8: "SKIPPED",
		9: "NOT_TRIGGERED",
	}
	PipelineTaskDetail_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"RUNNING":           2,
		"SUCCEEDED":         3,
		"CANCEL_PENDING":    4,
		"CANCELLING":        5,
		"CANCELLED":         6,
		"FAILED":            7,
		"SKIPPED":           8,
		"NOT_TRIGGERED":     9,
	}
)

func (x PipelineTaskDetail_State) Enum() *PipelineTaskDetail_State {
	p := new(PipelineTaskDetail_State)
	*p = x
	return p
}

func (x PipelineTaskDetail_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PipelineTaskDetail_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_enumTypes[1].Descriptor()
}

func (PipelineTaskDetail_State) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_enumTypes[1]
}

func (x PipelineTaskDetail_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PipelineTaskDetail_State.Descriptor instead.
func (PipelineTaskDetail_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{3, 0}
}

// An instance of a machine learning PipelineJob.
type PipelineJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the PipelineJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The display name of the Pipeline.
	// The name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Pipeline creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Pipeline start time.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Pipeline end time.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Timestamp when this PipelineJob was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The spec of the pipeline.
	PipelineSpec *structpb.Struct `protobuf:"bytes,7,opt,name=pipeline_spec,json=pipelineSpec,proto3" json:"pipeline_spec,omitempty"`
	// Output only. The detailed state of the job.
	State PipelineState `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.aiplatform.v1beta1.PipelineState" json:"state,omitempty"`
	// Output only. The details of pipeline run. Not available in the list view.
	JobDetail *PipelineJobDetail `protobuf:"bytes,9,opt,name=job_detail,json=jobDetail,proto3" json:"job_detail,omitempty"`
	// Output only. The error that occurred during pipeline execution.
	// Only populated when the pipeline's state is FAILED or CANCELLED.
	Error *status.Status `protobuf:"bytes,10,opt,name=error,proto3" json:"error,omitempty"`
	// The labels with user-defined metadata to organize PipelineJob.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	//
	// Note there is some reserved label key for Vertex AI Pipelines.
	// - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
	Labels map[string]string `protobuf:"bytes,11,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Runtime config of the pipeline.
	RuntimeConfig *PipelineJob_RuntimeConfig `protobuf:"bytes,12,opt,name=runtime_config,json=runtimeConfig,proto3" json:"runtime_config,omitempty"`
	// Customer-managed encryption key spec for a pipelineJob. If set, this
	// PipelineJob and all of its sub-resources will be secured by this key.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,16,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
	// The service account that the pipeline workload runs as.
	// If not specified, the Compute Engine default service account in the project
	// will be used.
	// See
	// https://cloud.google.com/compute/docs/access/service-accounts#default_service_account
	//
	// Users starting the pipeline must have the `iam.serviceAccounts.actAs`
	// permission on this service account.
	ServiceAccount string `protobuf:"bytes,17,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// The full name of the Compute Engine
	// [network](/compute/docs/networks-and-firewalls#networks) to which the
	// Pipeline Job's workload should be peered. For example,
	// `projects/12345/global/networks/myVPC`.
	// [Format](/compute/docs/reference/rest/v1/networks/insert)
	// is of the form `projects/{project}/global/networks/{network}`.
	// Where {project} is a project number, as in `12345`, and {network} is a
	// network name.
	//
	// Private services access must already be configured for the network.
	// Pipeline job will apply the network configuration to the Google Cloud
	// resources being launched, if applied, such as Vertex AI
	// Training or Dataflow job. If left unspecified, the workload is not peered
	// with any network.
	Network string `protobuf:"bytes,18,opt,name=network,proto3" json:"network,omitempty"`
	// A list of names for the reserved ip ranges under the VPC network
	// that can be used for this Pipeline Job's workload.
	//
	// If set, we will deploy the Pipeline Job's workload within the provided ip
	// ranges. Otherwise, the job will be deployed to any ip ranges under the
	// provided VPC network.
	//
	// Example: ['vertex-ai-ip-range'].
	ReservedIpRanges []string `protobuf:"bytes,25,rep,name=reserved_ip_ranges,json=reservedIpRanges,proto3" json:"reserved_ip_ranges,omitempty"`
	// Optional. Configuration for PSC-I for PipelineJob.
	PscInterfaceConfig *PscInterfaceConfig `protobuf:"bytes,31,opt,name=psc_interface_config,json=pscInterfaceConfig,proto3" json:"psc_interface_config,omitempty"`
	// A template uri from where the
	// [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec],
	// if empty, will be downloaded. Currently, only uri from Vertex Template
	// Registry & Gallery is supported. Reference to
	// https://cloud.google.com/vertex-ai/docs/pipelines/create-pipeline-template.
	TemplateUri string `protobuf:"bytes,19,opt,name=template_uri,json=templateUri,proto3" json:"template_uri,omitempty"`
	// Output only. Pipeline template metadata. Will fill up fields if
	// [PipelineJob.template_uri][google.cloud.aiplatform.v1beta1.PipelineJob.template_uri]
	// is from supported template registry.
	TemplateMetadata *PipelineTemplateMetadata `protobuf:"bytes,20,opt,name=template_metadata,json=templateMetadata,proto3" json:"template_metadata,omitempty"`
	// Output only. The schedule resource name.
	// Only returned if the Pipeline is created by Schedule API.
	ScheduleName string `protobuf:"bytes,22,opt,name=schedule_name,json=scheduleName,proto3" json:"schedule_name,omitempty"`
	// Optional. Whether to do component level validations before job creation.
	PreflightValidations bool `protobuf:"varint,26,opt,name=preflight_validations,json=preflightValidations,proto3" json:"preflight_validations,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs bool `protobuf:"varint,27,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,28,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
	// Optional. The original pipeline job id if this pipeline job is a rerun of a
	// previous pipeline job.
	OriginalPipelineJobId int64 `protobuf:"varint,29,opt,name=original_pipeline_job_id,json=originalPipelineJobId,proto3" json:"original_pipeline_job_id,omitempty"`
	// Optional. The rerun configs for each task in the pipeline job.
	// By default, the rerun will:
	// 1. Use the same input artifacts as the original run.
	// 2. Use the same input parameters as the original run.
	// 3. Skip all the tasks that are already succeeded in the original run.
	// 4. Rerun all the tasks that are not succeeded in the original run.
	// By providing this field, users can override the default behavior and
	// specify the rerun config for each task.
	PipelineTaskRerunConfigs []*PipelineTaskRerunConfig `protobuf:"bytes,30,rep,name=pipeline_task_rerun_configs,json=pipelineTaskRerunConfigs,proto3" json:"pipeline_task_rerun_configs,omitempty"`
}

func (x *PipelineJob) Reset() {
	*x = PipelineJob{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineJob) ProtoMessage() {}

func (x *PipelineJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineJob.ProtoReflect.Descriptor instead.
func (*PipelineJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{0}
}

func (x *PipelineJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PipelineJob) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PipelineJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PipelineJob) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *PipelineJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *PipelineJob) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PipelineJob) GetPipelineSpec() *structpb.Struct {
	if x != nil {
		return x.PipelineSpec
	}
	return nil
}

func (x *PipelineJob) GetState() PipelineState {
	if x != nil {
		return x.State
	}
	return PipelineState_PIPELINE_STATE_UNSPECIFIED
}

func (x *PipelineJob) GetJobDetail() *PipelineJobDetail {
	if x != nil {
		return x.JobDetail
	}
	return nil
}

func (x *PipelineJob) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *PipelineJob) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PipelineJob) GetRuntimeConfig() *PipelineJob_RuntimeConfig {
	if x != nil {
		return x.RuntimeConfig
	}
	return nil
}

func (x *PipelineJob) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

func (x *PipelineJob) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *PipelineJob) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *PipelineJob) GetReservedIpRanges() []string {
	if x != nil {
		return x.ReservedIpRanges
	}
	return nil
}

func (x *PipelineJob) GetPscInterfaceConfig() *PscInterfaceConfig {
	if x != nil {
		return x.PscInterfaceConfig
	}
	return nil
}

func (x *PipelineJob) GetTemplateUri() string {
	if x != nil {
		return x.TemplateUri
	}
	return ""
}

func (x *PipelineJob) GetTemplateMetadata() *PipelineTemplateMetadata {
	if x != nil {
		return x.TemplateMetadata
	}
	return nil
}

func (x *PipelineJob) GetScheduleName() string {
	if x != nil {
		return x.ScheduleName
	}
	return ""
}

func (x *PipelineJob) GetPreflightValidations() bool {
	if x != nil {
		return x.PreflightValidations
	}
	return false
}

func (x *PipelineJob) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *PipelineJob) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

func (x *PipelineJob) GetOriginalPipelineJobId() int64 {
	if x != nil {
		return x.OriginalPipelineJobId
	}
	return 0
}

func (x *PipelineJob) GetPipelineTaskRerunConfigs() []*PipelineTaskRerunConfig {
	if x != nil {
		return x.PipelineTaskRerunConfigs
	}
	return nil
}

// Pipeline template metadata if
// [PipelineJob.template_uri][google.cloud.aiplatform.v1beta1.PipelineJob.template_uri]
// is from supported template registry. Currently, the only supported registry
// is Artifact Registry.
type PipelineTemplateMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version_name in artifact registry.
	//
	// Will always be presented in output if the
	// [PipelineJob.template_uri][google.cloud.aiplatform.v1beta1.PipelineJob.template_uri]
	// is from supported template registry.
	//
	// Format is "sha256:abcdef123456...".
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *PipelineTemplateMetadata) Reset() {
	*x = PipelineTemplateMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineTemplateMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineTemplateMetadata) ProtoMessage() {}

func (x *PipelineTemplateMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineTemplateMetadata.ProtoReflect.Descriptor instead.
func (*PipelineTemplateMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{1}
}

func (x *PipelineTemplateMetadata) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// The runtime detail of PipelineJob.
type PipelineJobDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The context of the pipeline.
	PipelineContext *Context `protobuf:"bytes,1,opt,name=pipeline_context,json=pipelineContext,proto3" json:"pipeline_context,omitempty"`
	// Output only. The context of the current pipeline run.
	PipelineRunContext *Context `protobuf:"bytes,2,opt,name=pipeline_run_context,json=pipelineRunContext,proto3" json:"pipeline_run_context,omitempty"`
	// Output only. The runtime details of the tasks under the pipeline.
	TaskDetails []*PipelineTaskDetail `protobuf:"bytes,3,rep,name=task_details,json=taskDetails,proto3" json:"task_details,omitempty"`
}

func (x *PipelineJobDetail) Reset() {
	*x = PipelineJobDetail{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineJobDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineJobDetail) ProtoMessage() {}

func (x *PipelineJobDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineJobDetail.ProtoReflect.Descriptor instead.
func (*PipelineJobDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{2}
}

func (x *PipelineJobDetail) GetPipelineContext() *Context {
	if x != nil {
		return x.PipelineContext
	}
	return nil
}

func (x *PipelineJobDetail) GetPipelineRunContext() *Context {
	if x != nil {
		return x.PipelineRunContext
	}
	return nil
}

func (x *PipelineJobDetail) GetTaskDetails() []*PipelineTaskDetail {
	if x != nil {
		return x.TaskDetails
	}
	return nil
}

// The runtime detail of a task execution.
type PipelineTaskDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The system generated ID of the task.
	TaskId int64 `protobuf:"varint,1,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Output only. The id of the parent task if the task is within a component
	// scope. Empty if the task is at the root level.
	ParentTaskId int64 `protobuf:"varint,12,opt,name=parent_task_id,json=parentTaskId,proto3" json:"parent_task_id,omitempty"`
	// Output only. The user specified name of the task that is defined in
	// [pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec].
	TaskName string `protobuf:"bytes,2,opt,name=task_name,json=taskName,proto3" json:"task_name,omitempty"`
	// Output only. Task create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Task start time.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Task end time.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The detailed execution info.
	ExecutorDetail *PipelineTaskExecutorDetail `protobuf:"bytes,6,opt,name=executor_detail,json=executorDetail,proto3" json:"executor_detail,omitempty"`
	// Output only. State of the task.
	State PipelineTaskDetail_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.aiplatform.v1beta1.PipelineTaskDetail_State" json:"state,omitempty"`
	// Output only. The execution metadata of the task.
	Execution *Execution `protobuf:"bytes,8,opt,name=execution,proto3" json:"execution,omitempty"`
	// Output only. The error that occurred during task execution.
	// Only populated when the task's state is FAILED or CANCELLED.
	Error *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. A list of task status. This field keeps a record of task
	// status evolving over time.
	PipelineTaskStatus []*PipelineTaskDetail_PipelineTaskStatus `protobuf:"bytes,13,rep,name=pipeline_task_status,json=pipelineTaskStatus,proto3" json:"pipeline_task_status,omitempty"`
	// Output only. The runtime input artifacts of the task.
	Inputs map[string]*PipelineTaskDetail_ArtifactList `protobuf:"bytes,10,rep,name=inputs,proto3" json:"inputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The runtime output artifacts of the task.
	Outputs map[string]*PipelineTaskDetail_ArtifactList `protobuf:"bytes,11,rep,name=outputs,proto3" json:"outputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The unique name of a task.
	// This field is used by pipeline job reruns.
	// Console UI and Vertex AI SDK will support triggering pipeline job reruns.
	// The name is constructed by concatenating all the parent tasks' names with
	// the task name. For example, if a task named "child_task" has a parent task
	// named "parent_task_1" and parent task 1 has a parent task named
	// "parent_task_2", the task unique name will be
	// "parent_task_2.parent_task_1.child_task".
	TaskUniqueName string `protobuf:"bytes,14,opt,name=task_unique_name,json=taskUniqueName,proto3" json:"task_unique_name,omitempty"`
}

func (x *PipelineTaskDetail) Reset() {
	*x = PipelineTaskDetail{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineTaskDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineTaskDetail) ProtoMessage() {}

func (x *PipelineTaskDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineTaskDetail.ProtoReflect.Descriptor instead.
func (*PipelineTaskDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{3}
}

func (x *PipelineTaskDetail) GetTaskId() int64 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *PipelineTaskDetail) GetParentTaskId() int64 {
	if x != nil {
		return x.ParentTaskId
	}
	return 0
}

func (x *PipelineTaskDetail) GetTaskName() string {
	if x != nil {
		return x.TaskName
	}
	return ""
}

func (x *PipelineTaskDetail) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PipelineTaskDetail) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *PipelineTaskDetail) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *PipelineTaskDetail) GetExecutorDetail() *PipelineTaskExecutorDetail {
	if x != nil {
		return x.ExecutorDetail
	}
	return nil
}

func (x *PipelineTaskDetail) GetState() PipelineTaskDetail_State {
	if x != nil {
		return x.State
	}
	return PipelineTaskDetail_STATE_UNSPECIFIED
}

func (x *PipelineTaskDetail) GetExecution() *Execution {
	if x != nil {
		return x.Execution
	}
	return nil
}

func (x *PipelineTaskDetail) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *PipelineTaskDetail) GetPipelineTaskStatus() []*PipelineTaskDetail_PipelineTaskStatus {
	if x != nil {
		return x.PipelineTaskStatus
	}
	return nil
}

func (x *PipelineTaskDetail) GetInputs() map[string]*PipelineTaskDetail_ArtifactList {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *PipelineTaskDetail) GetOutputs() map[string]*PipelineTaskDetail_ArtifactList {
	if x != nil {
		return x.Outputs
	}
	return nil
}

func (x *PipelineTaskDetail) GetTaskUniqueName() string {
	if x != nil {
		return x.TaskUniqueName
	}
	return ""
}

// The runtime detail of a pipeline executor.
type PipelineTaskExecutorDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Details:
	//
	//	*PipelineTaskExecutorDetail_ContainerDetail_
	//	*PipelineTaskExecutorDetail_CustomJobDetail_
	Details isPipelineTaskExecutorDetail_Details `protobuf_oneof:"details"`
}

func (x *PipelineTaskExecutorDetail) Reset() {
	*x = PipelineTaskExecutorDetail{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineTaskExecutorDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineTaskExecutorDetail) ProtoMessage() {}

func (x *PipelineTaskExecutorDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineTaskExecutorDetail.ProtoReflect.Descriptor instead.
func (*PipelineTaskExecutorDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{4}
}

func (m *PipelineTaskExecutorDetail) GetDetails() isPipelineTaskExecutorDetail_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *PipelineTaskExecutorDetail) GetContainerDetail() *PipelineTaskExecutorDetail_ContainerDetail {
	if x, ok := x.GetDetails().(*PipelineTaskExecutorDetail_ContainerDetail_); ok {
		return x.ContainerDetail
	}
	return nil
}

func (x *PipelineTaskExecutorDetail) GetCustomJobDetail() *PipelineTaskExecutorDetail_CustomJobDetail {
	if x, ok := x.GetDetails().(*PipelineTaskExecutorDetail_CustomJobDetail_); ok {
		return x.CustomJobDetail
	}
	return nil
}

type isPipelineTaskExecutorDetail_Details interface {
	isPipelineTaskExecutorDetail_Details()
}

type PipelineTaskExecutorDetail_ContainerDetail_ struct {
	// Output only. The detailed info for a container executor.
	ContainerDetail *PipelineTaskExecutorDetail_ContainerDetail `protobuf:"bytes,1,opt,name=container_detail,json=containerDetail,proto3,oneof"`
}

type PipelineTaskExecutorDetail_CustomJobDetail_ struct {
	// Output only. The detailed info for a custom job executor.
	CustomJobDetail *PipelineTaskExecutorDetail_CustomJobDetail `protobuf:"bytes,2,opt,name=custom_job_detail,json=customJobDetail,proto3,oneof"`
}

func (*PipelineTaskExecutorDetail_ContainerDetail_) isPipelineTaskExecutorDetail_Details() {}

func (*PipelineTaskExecutorDetail_CustomJobDetail_) isPipelineTaskExecutorDetail_Details() {}

// User provided rerun config to submit a rerun pipelinejob. This includes
// 1. Which task to rerun
// 2. User override input parameters and artifacts.
type PipelineTaskRerunConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The system generated ID of the task. Retrieved from original run.
	TaskId int64 `protobuf:"varint,1,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Optional. The name of the task.
	TaskName string `protobuf:"bytes,2,opt,name=task_name,json=taskName,proto3" json:"task_name,omitempty"`
	// Optional. The runtime input of the task overridden by the user.
	Inputs *PipelineTaskRerunConfig_Inputs `protobuf:"bytes,3,opt,name=inputs,proto3" json:"inputs,omitempty"`
	// Optional. Whether to skip this task. Default value is False.
	SkipTask bool `protobuf:"varint,4,opt,name=skip_task,json=skipTask,proto3" json:"skip_task,omitempty"`
	// Optional. Whether to skip downstream tasks. Default value is False.
	SkipDownstreamTasks bool `protobuf:"varint,5,opt,name=skip_downstream_tasks,json=skipDownstreamTasks,proto3" json:"skip_downstream_tasks,omitempty"`
}

func (x *PipelineTaskRerunConfig) Reset() {
	*x = PipelineTaskRerunConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineTaskRerunConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineTaskRerunConfig) ProtoMessage() {}

func (x *PipelineTaskRerunConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineTaskRerunConfig.ProtoReflect.Descriptor instead.
func (*PipelineTaskRerunConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{5}
}

func (x *PipelineTaskRerunConfig) GetTaskId() int64 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *PipelineTaskRerunConfig) GetTaskName() string {
	if x != nil {
		return x.TaskName
	}
	return ""
}

func (x *PipelineTaskRerunConfig) GetInputs() *PipelineTaskRerunConfig_Inputs {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *PipelineTaskRerunConfig) GetSkipTask() bool {
	if x != nil {
		return x.SkipTask
	}
	return false
}

func (x *PipelineTaskRerunConfig) GetSkipDownstreamTasks() bool {
	if x != nil {
		return x.SkipDownstreamTasks
	}
	return false
}

// The runtime config of a PipelineJob.
type PipelineJob_RuntimeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. Use
	// [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values]
	// instead. The runtime parameters of the PipelineJob. The parameters will
	// be passed into
	// [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
	// to replace the placeholders at runtime. This field is used by pipelines
	// built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
	// such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/pipeline_job.proto.
	Parameters map[string]*Value `protobuf:"bytes,1,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. A path in a Cloud Storage bucket, which will be treated as the
	// root output directory of the pipeline. It is used by the system to
	// generate the paths of output artifacts. The artifact paths are generated
	// with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
	// specified output directory. The service account specified in this
	// pipeline must have the `storage.objects.get` and `storage.objects.create`
	// permissions for this bucket.
	GcsOutputDirectory string `protobuf:"bytes,2,opt,name=gcs_output_directory,json=gcsOutputDirectory,proto3" json:"gcs_output_directory,omitempty"`
	// The runtime parameters of the PipelineJob. The parameters will be
	// passed into
	// [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
	// to replace the placeholders at runtime. This field is used by pipelines
	// built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
	// pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
	// DSL.
	ParameterValues map[string]*structpb.Value `protobuf:"bytes,3,rep,name=parameter_values,json=parameterValues,proto3" json:"parameter_values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Represents the failure policy of a pipeline. Currently, the default of a
	// pipeline is that the pipeline will continue to run until no more tasks
	// can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
	// However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
	// will stop scheduling any new tasks when a task has failed. Any scheduled
	// tasks will continue to completion.
	FailurePolicy PipelineFailurePolicy `protobuf:"varint,4,opt,name=failure_policy,json=failurePolicy,proto3,enum=google.cloud.aiplatform.v1beta1.PipelineFailurePolicy" json:"failure_policy,omitempty"`
	// The runtime artifacts of the PipelineJob. The key will be the input
	// artifact name and the value would be one of the InputArtifact.
	InputArtifacts map[string]*PipelineJob_RuntimeConfig_InputArtifact `protobuf:"bytes,5,rep,name=input_artifacts,json=inputArtifacts,proto3" json:"input_artifacts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The default runtime for the PipelineJob. If not provided,
	// Vertex Custom Job(on demand) is used as the runtime. For Vertex Custom
	// Job, please refer to
	// https://cloud.google.com/vertex-ai/docs/training/overview.
	DefaultRuntime *PipelineJob_RuntimeConfig_DefaultRuntime `protobuf:"bytes,6,opt,name=default_runtime,json=defaultRuntime,proto3" json:"default_runtime,omitempty"`
}

func (x *PipelineJob_RuntimeConfig) Reset() {
	*x = PipelineJob_RuntimeConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineJob_RuntimeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineJob_RuntimeConfig) ProtoMessage() {}

func (x *PipelineJob_RuntimeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineJob_RuntimeConfig.ProtoReflect.Descriptor instead.
func (*PipelineJob_RuntimeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{0, 0}
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/pipeline_job.proto.
func (x *PipelineJob_RuntimeConfig) GetParameters() map[string]*Value {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *PipelineJob_RuntimeConfig) GetGcsOutputDirectory() string {
	if x != nil {
		return x.GcsOutputDirectory
	}
	return ""
}

func (x *PipelineJob_RuntimeConfig) GetParameterValues() map[string]*structpb.Value {
	if x != nil {
		return x.ParameterValues
	}
	return nil
}

func (x *PipelineJob_RuntimeConfig) GetFailurePolicy() PipelineFailurePolicy {
	if x != nil {
		return x.FailurePolicy
	}
	return PipelineFailurePolicy_PIPELINE_FAILURE_POLICY_UNSPECIFIED
}

func (x *PipelineJob_RuntimeConfig) GetInputArtifacts() map[string]*PipelineJob_RuntimeConfig_InputArtifact {
	if x != nil {
		return x.InputArtifacts
	}
	return nil
}

func (x *PipelineJob_RuntimeConfig) GetDefaultRuntime() *PipelineJob_RuntimeConfig_DefaultRuntime {
	if x != nil {
		return x.DefaultRuntime
	}
	return nil
}

// The type of an input artifact.
type PipelineJob_RuntimeConfig_InputArtifact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Kind:
	//
	//	*PipelineJob_RuntimeConfig_InputArtifact_ArtifactId
	Kind isPipelineJob_RuntimeConfig_InputArtifact_Kind `protobuf_oneof:"kind"`
}

func (x *PipelineJob_RuntimeConfig_InputArtifact) Reset() {
	*x = PipelineJob_RuntimeConfig_InputArtifact{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineJob_RuntimeConfig_InputArtifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineJob_RuntimeConfig_InputArtifact) ProtoMessage() {}

func (x *PipelineJob_RuntimeConfig_InputArtifact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineJob_RuntimeConfig_InputArtifact.ProtoReflect.Descriptor instead.
func (*PipelineJob_RuntimeConfig_InputArtifact) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (m *PipelineJob_RuntimeConfig_InputArtifact) GetKind() isPipelineJob_RuntimeConfig_InputArtifact_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *PipelineJob_RuntimeConfig_InputArtifact) GetArtifactId() string {
	if x, ok := x.GetKind().(*PipelineJob_RuntimeConfig_InputArtifact_ArtifactId); ok {
		return x.ArtifactId
	}
	return ""
}

type isPipelineJob_RuntimeConfig_InputArtifact_Kind interface {
	isPipelineJob_RuntimeConfig_InputArtifact_Kind()
}

type PipelineJob_RuntimeConfig_InputArtifact_ArtifactId struct {
	// Artifact resource id from MLMD. Which is the last portion of an
	// artifact resource name:
	// `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
	// The artifact must stay within the same project, location and default
	// metadatastore as the pipeline.
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3,oneof"`
}

func (*PipelineJob_RuntimeConfig_InputArtifact_ArtifactId) isPipelineJob_RuntimeConfig_InputArtifact_Kind() {
}

// Persistent resource based runtime detail. For more information, refer to
// https://cloud.google.com/vertex-ai/docs/training/persistent-resource-overview
type PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Persistent resource name.
	// Format:
	// `projects/{project}/locations/{location}/persistentResources/{persistent_resource}`
	PersistentResourceName string `protobuf:"bytes,1,opt,name=persistent_resource_name,json=persistentResourceName,proto3" json:"persistent_resource_name,omitempty"`
	// The max time a pipeline task waits for the required CPU, memory, or
	// accelerator resource to become available from the specified persistent
	// resource. Default wait time is 0.
	TaskResourceUnavailableWaitTimeMs int64 `protobuf:"varint,2,opt,name=task_resource_unavailable_wait_time_ms,json=taskResourceUnavailableWaitTimeMs,proto3" json:"task_resource_unavailable_wait_time_ms,omitempty"`
	// Specifies the behavior to take if the timeout is reached.
	TaskResourceUnavailableTimeoutBehavior PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior `protobuf:"varint,3,opt,name=task_resource_unavailable_timeout_behavior,json=taskResourceUnavailableTimeoutBehavior,proto3,enum=google.cloud.aiplatform.v1beta1.PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior" json:"task_resource_unavailable_timeout_behavior,omitempty"`
}

func (x *PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail) Reset() {
	*x = PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail) ProtoMessage() {}

func (x *PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail.ProtoReflect.Descriptor instead.
func (*PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{0, 0, 1}
}

func (x *PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail) GetPersistentResourceName() string {
	if x != nil {
		return x.PersistentResourceName
	}
	return ""
}

func (x *PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail) GetTaskResourceUnavailableWaitTimeMs() int64 {
	if x != nil {
		return x.TaskResourceUnavailableWaitTimeMs
	}
	return 0
}

func (x *PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail) GetTaskResourceUnavailableTimeoutBehavior() PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior {
	if x != nil {
		return x.TaskResourceUnavailableTimeoutBehavior
	}
	return PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TASK_RESOURCE_UNAVAILABLE_TIMEOUT_BEHAVIOR_UNSPECIFIED
}

// The default runtime for the PipelineJob.
type PipelineJob_RuntimeConfig_DefaultRuntime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to RuntimeDetail:
	//
	//	*PipelineJob_RuntimeConfig_DefaultRuntime_PersistentResourceRuntimeDetail
	RuntimeDetail isPipelineJob_RuntimeConfig_DefaultRuntime_RuntimeDetail `protobuf_oneof:"runtime_detail"`
}

func (x *PipelineJob_RuntimeConfig_DefaultRuntime) Reset() {
	*x = PipelineJob_RuntimeConfig_DefaultRuntime{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineJob_RuntimeConfig_DefaultRuntime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineJob_RuntimeConfig_DefaultRuntime) ProtoMessage() {}

func (x *PipelineJob_RuntimeConfig_DefaultRuntime) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineJob_RuntimeConfig_DefaultRuntime.ProtoReflect.Descriptor instead.
func (*PipelineJob_RuntimeConfig_DefaultRuntime) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{0, 0, 2}
}

func (m *PipelineJob_RuntimeConfig_DefaultRuntime) GetRuntimeDetail() isPipelineJob_RuntimeConfig_DefaultRuntime_RuntimeDetail {
	if m != nil {
		return m.RuntimeDetail
	}
	return nil
}

func (x *PipelineJob_RuntimeConfig_DefaultRuntime) GetPersistentResourceRuntimeDetail() *PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail {
	if x, ok := x.GetRuntimeDetail().(*PipelineJob_RuntimeConfig_DefaultRuntime_PersistentResourceRuntimeDetail); ok {
		return x.PersistentResourceRuntimeDetail
	}
	return nil
}

type isPipelineJob_RuntimeConfig_DefaultRuntime_RuntimeDetail interface {
	isPipelineJob_RuntimeConfig_DefaultRuntime_RuntimeDetail()
}

type PipelineJob_RuntimeConfig_DefaultRuntime_PersistentResourceRuntimeDetail struct {
	// Persistent resource based runtime detail.
	PersistentResourceRuntimeDetail *PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail `protobuf:"bytes,1,opt,name=persistent_resource_runtime_detail,json=persistentResourceRuntimeDetail,proto3,oneof"`
}

func (*PipelineJob_RuntimeConfig_DefaultRuntime_PersistentResourceRuntimeDetail) isPipelineJob_RuntimeConfig_DefaultRuntime_RuntimeDetail() {
}

// A single record of the task status.
type PipelineTaskDetail_PipelineTaskStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Update time of this status.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The state of the task.
	State PipelineTaskDetail_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.aiplatform.v1beta1.PipelineTaskDetail_State" json:"state,omitempty"`
	// Output only. The error that occurred during the state. May be set when
	// the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or
	// FAILED state. If the state is FAILED, the error here is final and not
	// going to be retried. If the state is a non-final state, the error
	// indicates a system-error being retried.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *PipelineTaskDetail_PipelineTaskStatus) Reset() {
	*x = PipelineTaskDetail_PipelineTaskStatus{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineTaskDetail_PipelineTaskStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineTaskDetail_PipelineTaskStatus) ProtoMessage() {}

func (x *PipelineTaskDetail_PipelineTaskStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineTaskDetail_PipelineTaskStatus.ProtoReflect.Descriptor instead.
func (*PipelineTaskDetail_PipelineTaskStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{3, 0}
}

func (x *PipelineTaskDetail_PipelineTaskStatus) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PipelineTaskDetail_PipelineTaskStatus) GetState() PipelineTaskDetail_State {
	if x != nil {
		return x.State
	}
	return PipelineTaskDetail_STATE_UNSPECIFIED
}

func (x *PipelineTaskDetail_PipelineTaskStatus) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A list of artifact metadata.
type PipelineTaskDetail_ArtifactList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. A list of artifact metadata.
	Artifacts []*Artifact `protobuf:"bytes,1,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
}

func (x *PipelineTaskDetail_ArtifactList) Reset() {
	*x = PipelineTaskDetail_ArtifactList{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineTaskDetail_ArtifactList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineTaskDetail_ArtifactList) ProtoMessage() {}

func (x *PipelineTaskDetail_ArtifactList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineTaskDetail_ArtifactList.ProtoReflect.Descriptor instead.
func (*PipelineTaskDetail_ArtifactList) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{3, 1}
}

func (x *PipelineTaskDetail_ArtifactList) GetArtifacts() []*Artifact {
	if x != nil {
		return x.Artifacts
	}
	return nil
}

// The detail of a container execution. It contains the job names of the
// lifecycle of a container execution.
type PipelineTaskExecutorDetail_ContainerDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the
	// [CustomJob][google.cloud.aiplatform.v1beta1.CustomJob] for the main
	// container execution.
	MainJob string `protobuf:"bytes,1,opt,name=main_job,json=mainJob,proto3" json:"main_job,omitempty"`
	// Output only. The name of the
	// [CustomJob][google.cloud.aiplatform.v1beta1.CustomJob] for the
	// pre-caching-check container execution. This job will be available if the
	// [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
	// specifies the `pre_caching_check` hook in the lifecycle events.
	PreCachingCheckJob string `protobuf:"bytes,2,opt,name=pre_caching_check_job,json=preCachingCheckJob,proto3" json:"pre_caching_check_job,omitempty"`
	// Output only. The names of the previously failed
	// [CustomJob][google.cloud.aiplatform.v1beta1.CustomJob] for the main
	// container executions. The list includes the all attempts in chronological
	// order.
	FailedMainJobs []string `protobuf:"bytes,3,rep,name=failed_main_jobs,json=failedMainJobs,proto3" json:"failed_main_jobs,omitempty"`
	// Output only. The names of the previously failed
	// [CustomJob][google.cloud.aiplatform.v1beta1.CustomJob] for the
	// pre-caching-check container executions. This job will be available if the
	// [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec]
	// specifies the `pre_caching_check` hook in the lifecycle events. The list
	// includes the all attempts in chronological order.
	FailedPreCachingCheckJobs []string `protobuf:"bytes,4,rep,name=failed_pre_caching_check_jobs,json=failedPreCachingCheckJobs,proto3" json:"failed_pre_caching_check_jobs,omitempty"`
}

func (x *PipelineTaskExecutorDetail_ContainerDetail) Reset() {
	*x = PipelineTaskExecutorDetail_ContainerDetail{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineTaskExecutorDetail_ContainerDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineTaskExecutorDetail_ContainerDetail) ProtoMessage() {}

func (x *PipelineTaskExecutorDetail_ContainerDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineTaskExecutorDetail_ContainerDetail.ProtoReflect.Descriptor instead.
func (*PipelineTaskExecutorDetail_ContainerDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{4, 0}
}

func (x *PipelineTaskExecutorDetail_ContainerDetail) GetMainJob() string {
	if x != nil {
		return x.MainJob
	}
	return ""
}

func (x *PipelineTaskExecutorDetail_ContainerDetail) GetPreCachingCheckJob() string {
	if x != nil {
		return x.PreCachingCheckJob
	}
	return ""
}

func (x *PipelineTaskExecutorDetail_ContainerDetail) GetFailedMainJobs() []string {
	if x != nil {
		return x.FailedMainJobs
	}
	return nil
}

func (x *PipelineTaskExecutorDetail_ContainerDetail) GetFailedPreCachingCheckJobs() []string {
	if x != nil {
		return x.FailedPreCachingCheckJobs
	}
	return nil
}

// The detailed info for a custom job executor.
type PipelineTaskExecutorDetail_CustomJobDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the
	// [CustomJob][google.cloud.aiplatform.v1beta1.CustomJob].
	Job string `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
	// Output only. The names of the previously failed
	// [CustomJob][google.cloud.aiplatform.v1beta1.CustomJob]. The list includes
	// the all attempts in chronological order.
	FailedJobs []string `protobuf:"bytes,3,rep,name=failed_jobs,json=failedJobs,proto3" json:"failed_jobs,omitempty"`
}

func (x *PipelineTaskExecutorDetail_CustomJobDetail) Reset() {
	*x = PipelineTaskExecutorDetail_CustomJobDetail{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineTaskExecutorDetail_CustomJobDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineTaskExecutorDetail_CustomJobDetail) ProtoMessage() {}

func (x *PipelineTaskExecutorDetail_CustomJobDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineTaskExecutorDetail_CustomJobDetail.ProtoReflect.Descriptor instead.
func (*PipelineTaskExecutorDetail_CustomJobDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{4, 1}
}

func (x *PipelineTaskExecutorDetail_CustomJobDetail) GetJob() string {
	if x != nil {
		return x.Job
	}
	return ""
}

func (x *PipelineTaskExecutorDetail_CustomJobDetail) GetFailedJobs() []string {
	if x != nil {
		return x.FailedJobs
	}
	return nil
}

// A list of artifact metadata.
type PipelineTaskRerunConfig_ArtifactList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list of artifact metadata.
	Artifacts []*RuntimeArtifact `protobuf:"bytes,1,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
}

func (x *PipelineTaskRerunConfig_ArtifactList) Reset() {
	*x = PipelineTaskRerunConfig_ArtifactList{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineTaskRerunConfig_ArtifactList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineTaskRerunConfig_ArtifactList) ProtoMessage() {}

func (x *PipelineTaskRerunConfig_ArtifactList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineTaskRerunConfig_ArtifactList.ProtoReflect.Descriptor instead.
func (*PipelineTaskRerunConfig_ArtifactList) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{5, 0}
}

func (x *PipelineTaskRerunConfig_ArtifactList) GetArtifacts() []*RuntimeArtifact {
	if x != nil {
		return x.Artifacts
	}
	return nil
}

// Runtime inputs data of the task.
type PipelineTaskRerunConfig_Inputs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Input artifacts.
	Artifacts map[string]*PipelineTaskRerunConfig_ArtifactList `protobuf:"bytes,1,rep,name=artifacts,proto3" json:"artifacts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Input parameters.
	ParameterValues map[string]*structpb.Value `protobuf:"bytes,2,rep,name=parameter_values,json=parameterValues,proto3" json:"parameter_values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *PipelineTaskRerunConfig_Inputs) Reset() {
	*x = PipelineTaskRerunConfig_Inputs{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PipelineTaskRerunConfig_Inputs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineTaskRerunConfig_Inputs) ProtoMessage() {}

func (x *PipelineTaskRerunConfig_Inputs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineTaskRerunConfig_Inputs.ProtoReflect.Descriptor instead.
func (*PipelineTaskRerunConfig_Inputs) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP(), []int{5, 1}
}

func (x *PipelineTaskRerunConfig_Inputs) GetArtifacts() map[string]*PipelineTaskRerunConfig_ArtifactList {
	if x != nil {
		return x.Artifacts
	}
	return nil
}

func (x *PipelineTaskRerunConfig_Inputs) GetParameterValues() map[string]*structpb.Value {
	if x != nil {
		return x.ParameterValues
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_pipeline_job_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e,
	0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x75, 0x69, 0x5f, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9d, 0x1c, 0x0a, 0x0b, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x3c, 0x0a, 0x0d, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x52, 0x0c, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x49,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x56, 0x0a, 0x0a, 0x6a, 0x6f, 0x62,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x12, 0x50, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x61, 0x0a, 0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x58, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x64, 0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x19, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x10, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x49, 0x70, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x6a, 0x0a, 0x14, 0x70, 0x73, 0x63, 0x5f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1f, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x73, 0x63, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x70,
	0x73, 0x63, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x55, 0x72, 0x69, 0x12, 0x6b, 0x0a, 0x11, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x10, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x15, 0x70,
	0x72, 0x65, 0x66, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x14, 0x70, 0x72, 0x65, 0x66, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69,
	0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x12,
	0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69,
	0x18, 0x1c, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74,
	0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x12, 0x3c, 0x0a, 0x18, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6a,
	0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x15, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x7c, 0x0a, 0x1b, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x72, 0x65, 0x72, 0x75, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x1e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x72, 0x75, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x72, 0x75, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x1a, 0x80, 0x0e, 0x0a, 0x0d, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6e, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x35, 0x0a, 0x14, 0x67, 0x63, 0x73, 0x5f, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x67, 0x63, 0x73, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x7a,
	0x0a, 0x10, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x5d, 0x0a, 0x0e, 0x66, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x46, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0d, 0x66, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x77, 0x0a, 0x0f, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62,
	0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0e, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x73, 0x12, 0x77, 0x0a, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x1a, 0x3a, 0x0a, 0x0d, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x21, 0x0a, 0x0b,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x49, 0x64, 0x42,
	0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x1a, 0x9c, 0x04, 0x0a, 0x1f, 0x50, 0x65, 0x72, 0x73,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x38, 0x0a, 0x18, 0x70,
	0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x70,
	0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x26, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x77, 0x61, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6d, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x21, 0x74, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x55, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x61,
	0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x4d, 0x73, 0x12, 0xde, 0x01, 0x0a, 0x2a, 0x74, 0x61, 0x73,
	0x6b, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x6e, 0x61, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x81, 0x01,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x2e, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x52, 0x26, 0x74, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55,
	0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x22, 0x8a, 0x01, 0x0a, 0x26, 0x54, 0x61,
	0x73, 0x6b, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x6e, 0x61, 0x76, 0x61, 0x69,
	0x6c, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x42, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x12, 0x3a, 0x0a, 0x36, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x52, 0x45, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c,
	0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x5f, 0x42, 0x45, 0x48, 0x41, 0x56, 0x49,
	0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x08, 0x0a, 0x04, 0x46, 0x41, 0x49, 0x4c, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x46, 0x41,
	0x4c, 0x4c, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x54, 0x4f, 0x5f, 0x4f, 0x4e, 0x5f, 0x44, 0x45,
	0x4d, 0x41, 0x4e, 0x44, 0x10, 0x02, 0x1a, 0xce, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0xa9, 0x01, 0x0a, 0x22, 0x70, 0x65,
	0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x48, 0x00, 0x52, 0x1f, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x42, 0x10, 0x0a, 0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x1a, 0x65, 0x0a, 0x0f, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3c, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x5a,
	0x0a, 0x14, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x8b, 0x01, 0x0a, 0x13, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x5e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f,
	0x62, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x3a, 0x6f, 0xea, 0x41, 0x6c, 0x0a, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x12,
	0x43, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f,
	0x6a, 0x6f, 0x62, 0x7d, 0x22, 0x34, 0x0a, 0x18, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xab, 0x02, 0x0a, 0x11, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x12, 0x58, 0x0a, 0x10, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x5f, 0x0a, 0x14, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x52, 0x75, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x5b, 0x0a, 0x0c, 0x74,
	0x61, 0x73, 0x6b, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x74, 0x61, 0x73,
	0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xc9, 0x0d, 0x0a, 0x12, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12,
	0x1c, 0x0a, 0x07, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x29, 0x0a,
	0x0e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x61, 0x73, 0x6b,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x08, 0x74, 0x61, 0x73, 0x6b, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x69, 0x0a, 0x0f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x12, 0x54, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73,
	0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4d, 0x0a, 0x09, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x7d, 0x0a, 0x14, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x54, 0x61, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x12, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x5c, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x54, 0x61, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x73, 0x12, 0x5f, 0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18,
	0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x54, 0x61, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x75, 0x6e,
	0x69, 0x71, 0x75, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x74, 0x61, 0x73, 0x6b, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x1a, 0xdb, 0x01, 0x0a, 0x12, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x54, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x1a, 0x5c, 0x0a, 0x0c, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4c, 0x69,
	0x73, 0x74, 0x12, 0x4c, 0x0a, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73,
	0x1a, 0x7b, 0x0a, 0x0b, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x56, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x7c, 0x0a,
	0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x56, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa6, 0x01, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e,
	0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45,
	0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x5f,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e,
	0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e,
	0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x07, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x4b, 0x49, 0x50, 0x50, 0x45, 0x44, 0x10,
	0x08, 0x12, 0x11, 0x0a, 0x0d, 0x4e, 0x4f, 0x54, 0x5f, 0x54, 0x52, 0x49, 0x47, 0x47, 0x45, 0x52,
	0x45, 0x44, 0x10, 0x09, 0x22, 0xd0, 0x05, 0x0a, 0x1a, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x54, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x12, 0x7d, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x12, 0x7e, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6a, 0x6f, 0x62,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x1a, 0xaf, 0x02, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x46, 0x0a, 0x08, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6a,
	0x6f, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x25,
	0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4a, 0x6f, 0x62, 0x52, 0x07, 0x6d, 0x61, 0x69, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x5e,
	0x0a, 0x15, 0x70, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68,
	0x65, 0x63, 0x6b, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0,
	0x41, 0x03, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4a, 0x6f, 0x62, 0x52, 0x12, 0x70, 0x72, 0x65, 0x43,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x4a, 0x6f, 0x62, 0x12, 0x2d,
	0x0a, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6a, 0x6f,
	0x62, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x66,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x4d, 0x61, 0x69, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x45, 0x0a,
	0x1d, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x66, 0x61, 0x69, 0x6c, 0x65,
	0x64, 0x50, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x4a, 0x6f, 0x62, 0x73, 0x1a, 0x76, 0x0a, 0x0f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4a, 0x6f,
	0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x3d, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4a, 0x6f,
	0x62, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x12, 0x24, 0x0a, 0x0b, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x4a, 0x6f, 0x62, 0x73, 0x42, 0x09, 0x0a, 0x07,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xde, 0x06, 0x0a, 0x17, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x72, 0x75, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x1c, 0x0a, 0x07, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x74, 0x61, 0x73, 0x6b, 0x49,
	0x64, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x74, 0x61, 0x73, 0x6b, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61,
	0x73, 0x6b, 0x52, 0x65, 0x72, 0x75, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x73, 0x12, 0x20, 0x0a, 0x09, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x6b, 0x69, 0x70, 0x54,
	0x61, 0x73, 0x6b, 0x12, 0x37, 0x0a, 0x15, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x64, 0x6f, 0x77, 0x6e,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x73, 0x6b, 0x69, 0x70, 0x44, 0x6f, 0x77,
	0x6e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x1a, 0x63, 0x0a, 0x0c,
	0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x09,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x73, 0x1a, 0xe4, 0x03, 0x0a, 0x06, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x71, 0x0a, 0x09,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65,
	0x72, 0x75, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73,
	0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12,
	0x84, 0x01, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x72, 0x75, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x83, 0x01, 0x0a, 0x0e, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x5b, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x72, 0x75, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x5a, 0x0a, 0x14,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0xb0, 0x02, 0xea, 0x41, 0x4e, 0x0a, 0x1e,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x2c,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x7d, 0x0a, 0x23, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x42, 0x08, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x01, 0x5a, 0x43, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42,
	0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes = make([]protoimpl.MessageInfo, 24)
var file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_goTypes = []any{
	(PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail_TaskResourceUnavailableTimeoutBehavior)(0), // 0: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior
	(PipelineTaskDetail_State)(0),                   // 1: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State
	(*PipelineJob)(nil),                             // 2: google.cloud.aiplatform.v1beta1.PipelineJob
	(*PipelineTemplateMetadata)(nil),                // 3: google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata
	(*PipelineJobDetail)(nil),                       // 4: google.cloud.aiplatform.v1beta1.PipelineJobDetail
	(*PipelineTaskDetail)(nil),                      // 5: google.cloud.aiplatform.v1beta1.PipelineTaskDetail
	(*PipelineTaskExecutorDetail)(nil),              // 6: google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail
	(*PipelineTaskRerunConfig)(nil),                 // 7: google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig
	(*PipelineJob_RuntimeConfig)(nil),               // 8: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
	nil,                                             // 9: google.cloud.aiplatform.v1beta1.PipelineJob.LabelsEntry
	(*PipelineJob_RuntimeConfig_InputArtifact)(nil), // 10: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
	(*PipelineJob_RuntimeConfig_PersistentResourceRuntimeDetail)(nil), // 11: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail
	(*PipelineJob_RuntimeConfig_DefaultRuntime)(nil),                  // 12: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
	nil, // 13: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.ParametersEntry
	nil, // 14: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.ParameterValuesEntry
	nil, // 15: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifactsEntry
	(*PipelineTaskDetail_PipelineTaskStatus)(nil), // 16: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
	(*PipelineTaskDetail_ArtifactList)(nil),       // 17: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
	nil,                                           // 18: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.InputsEntry
	nil,                                           // 19: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.OutputsEntry
	(*PipelineTaskExecutorDetail_ContainerDetail)(nil), // 20: google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail.ContainerDetail
	(*PipelineTaskExecutorDetail_CustomJobDetail)(nil), // 21: google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail.CustomJobDetail
	(*PipelineTaskRerunConfig_ArtifactList)(nil),       // 22: google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
	(*PipelineTaskRerunConfig_Inputs)(nil),             // 23: google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs
	nil,                                                // 24: google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.ArtifactsEntry
	nil,                                                // 25: google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.ParameterValuesEntry
	(*timestamppb.Timestamp)(nil),                      // 26: google.protobuf.Timestamp
	(*structpb.Struct)(nil),                            // 27: google.protobuf.Struct
	(PipelineState)(0),                                 // 28: google.cloud.aiplatform.v1beta1.PipelineState
	(*status.Status)(nil),                              // 29: google.rpc.Status
	(*EncryptionSpec)(nil),                             // 30: google.cloud.aiplatform.v1beta1.EncryptionSpec
	(*PscInterfaceConfig)(nil),                         // 31: google.cloud.aiplatform.v1beta1.PscInterfaceConfig
	(*Context)(nil),                                    // 32: google.cloud.aiplatform.v1beta1.Context
	(*Execution)(nil),                                  // 33: google.cloud.aiplatform.v1beta1.Execution
	(PipelineFailurePolicy)(0),                         // 34: google.cloud.aiplatform.v1beta1.PipelineFailurePolicy
	(*Value)(nil),                                      // 35: google.cloud.aiplatform.v1beta1.Value
	(*structpb.Value)(nil),                             // 36: google.protobuf.Value
	(*Artifact)(nil),                                   // 37: google.cloud.aiplatform.v1beta1.Artifact
	(*RuntimeArtifact)(nil),                            // 38: google.cloud.aiplatform.v1beta1.RuntimeArtifact
}
var file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_depIdxs = []int32{
	26, // 0: google.cloud.aiplatform.v1beta1.PipelineJob.create_time:type_name -> google.protobuf.Timestamp
	26, // 1: google.cloud.aiplatform.v1beta1.PipelineJob.start_time:type_name -> google.protobuf.Timestamp
	26, // 2: google.cloud.aiplatform.v1beta1.PipelineJob.end_time:type_name -> google.protobuf.Timestamp
	26, // 3: google.cloud.aiplatform.v1beta1.PipelineJob.update_time:type_name -> google.protobuf.Timestamp
	27, // 4: google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_spec:type_name -> google.protobuf.Struct
	28, // 5: google.cloud.aiplatform.v1beta1.PipelineJob.state:type_name -> google.cloud.aiplatform.v1beta1.PipelineState
	4,  // 6: google.cloud.aiplatform.v1beta1.PipelineJob.job_detail:type_name -> google.cloud.aiplatform.v1beta1.PipelineJobDetail
	29, // 7: google.cloud.aiplatform.v1beta1.PipelineJob.error:type_name -> google.rpc.Status
	9,  // 8: google.cloud.aiplatform.v1beta1.PipelineJob.labels:type_name -> google.cloud.aiplatform.v1beta1.PipelineJob.LabelsEntry
	8,  // 9: google.cloud.aiplatform.v1beta1.PipelineJob.runtime_config:type_name -> google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig
	30, // 10: google.cloud.aiplatform.v1beta1.PipelineJob.encryption_spec:type_name -> google.cloud.aiplatform.v1beta1.EncryptionSpec
	31, // 11: google.cloud.aiplatform.v1beta1.PipelineJob.psc_interface_config:type_name -> google.cloud.aiplatform.v1beta1.PscInterfaceConfig
	3,  // 12: google.cloud.aiplatform.v1beta1.PipelineJob.template_metadata:type_name -> google.cloud.aiplatform.v1beta1.PipelineTemplateMetadata
	7,  // 13: google.cloud.aiplatform.v1beta1.PipelineJob.pipeline_task_rerun_configs:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig
	32, // 14: google.cloud.aiplatform.v1beta1.PipelineJobDetail.pipeline_context:type_name -> google.cloud.aiplatform.v1beta1.Context
	32, // 15: google.cloud.aiplatform.v1beta1.PipelineJobDetail.pipeline_run_context:type_name -> google.cloud.aiplatform.v1beta1.Context
	5,  // 16: google.cloud.aiplatform.v1beta1.PipelineJobDetail.task_details:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskDetail
	26, // 17: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.create_time:type_name -> google.protobuf.Timestamp
	26, // 18: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.start_time:type_name -> google.protobuf.Timestamp
	26, // 19: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.end_time:type_name -> google.protobuf.Timestamp
	6,  // 20: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.executor_detail:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail
	1,  // 21: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.state:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State
	33, // 22: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.execution:type_name -> google.cloud.aiplatform.v1beta1.Execution
	29, // 23: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.error:type_name -> google.rpc.Status
	16, // 24: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.pipeline_task_status:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus
	18, // 25: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.inputs:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskDetail.InputsEntry
	19, // 26: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.outputs:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskDetail.OutputsEntry
	20, // 27: google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail.container_detail:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail.ContainerDetail
	21, // 28: google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail.custom_job_detail:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskExecutorDetail.CustomJobDetail
	23, // 29: google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.inputs:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs
	13, // 30: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameters:type_name -> google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.ParametersEntry
	14, // 31: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.parameter_values:type_name -> google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.ParameterValuesEntry
	34, // 32: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.failure_policy:type_name -> google.cloud.aiplatform.v1beta1.PipelineFailurePolicy
	15, // 33: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.input_artifacts:type_name -> google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifactsEntry
	12, // 34: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.default_runtime:type_name -> google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime
	0,  // 35: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail.task_resource_unavailable_timeout_behavior:type_name -> google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail.TaskResourceUnavailableTimeoutBehavior
	11, // 36: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.DefaultRuntime.persistent_resource_runtime_detail:type_name -> google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.PersistentResourceRuntimeDetail
	35, // 37: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.ParametersEntry.value:type_name -> google.cloud.aiplatform.v1beta1.Value
	36, // 38: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.ParameterValuesEntry.value:type_name -> google.protobuf.Value
	10, // 39: google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifactsEntry.value:type_name -> google.cloud.aiplatform.v1beta1.PipelineJob.RuntimeConfig.InputArtifact
	26, // 40: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.update_time:type_name -> google.protobuf.Timestamp
	1,  // 41: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.state:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskDetail.State
	29, // 42: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.PipelineTaskStatus.error:type_name -> google.rpc.Status
	37, // 43: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList.artifacts:type_name -> google.cloud.aiplatform.v1beta1.Artifact
	17, // 44: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.InputsEntry.value:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
	17, // 45: google.cloud.aiplatform.v1beta1.PipelineTaskDetail.OutputsEntry.value:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskDetail.ArtifactList
	38, // 46: google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList.artifacts:type_name -> google.cloud.aiplatform.v1beta1.RuntimeArtifact
	24, // 47: google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.artifacts:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.ArtifactsEntry
	25, // 48: google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.parameter_values:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.ParameterValuesEntry
	22, // 49: google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.ArtifactsEntry.value:type_name -> google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
	36, // 50: google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.ParameterValuesEntry.value:type_name -> google.protobuf.Value
	51, // [51:51] is the sub-list for method output_type
	51, // [51:51] is the sub-list for method input_type
	51, // [51:51] is the sub-list for extension type_name
	51, // [51:51] is the sub-list for extension extendee
	0,  // [0:51] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_init() }
func file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_pipeline_job_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_artifact_proto_init()
	file_google_cloud_aiplatform_v1beta1_context_proto_init()
	file_google_cloud_aiplatform_v1beta1_encryption_spec_proto_init()
	file_google_cloud_aiplatform_v1beta1_execution_proto_init()
	file_google_cloud_aiplatform_v1beta1_pipeline_failure_policy_proto_init()
	file_google_cloud_aiplatform_v1beta1_pipeline_state_proto_init()
	file_google_cloud_aiplatform_v1beta1_service_networking_proto_init()
	file_google_cloud_aiplatform_v1beta1_ui_pipeline_spec_proto_init()
	file_google_cloud_aiplatform_v1beta1_value_proto_init()
	file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[4].OneofWrappers = []any{
		(*PipelineTaskExecutorDetail_ContainerDetail_)(nil),
		(*PipelineTaskExecutorDetail_CustomJobDetail_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[8].OneofWrappers = []any{
		(*PipelineJob_RuntimeConfig_InputArtifact_ArtifactId)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes[10].OneofWrappers = []any{
		(*PipelineJob_RuntimeConfig_DefaultRuntime_PersistentResourceRuntimeDetail)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   24,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_pipeline_job_proto = out.File
	file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_depIdxs = nil
}
