// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package appconfigdataiface provides an interface to enable mocking the AWS AppConfig Data service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package appconfigdataiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/appconfigdata"
)

// AppConfigDataAPI provides an interface to enable mocking the
// appconfigdata.AppConfigData service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS AppConfig Data.
//    func myFunc(svc appconfigdataiface.AppConfigDataAPI) bool {
//        // Make svc.GetLatestConfiguration request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := appconfigdata.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockAppConfigDataClient struct {
//        appconfigdataiface.AppConfigDataAPI
//    }
//    func (m *mockAppConfigDataClient) GetLatestConfiguration(input *appconfigdata.GetLatestConfigurationInput) (*appconfigdata.GetLatestConfigurationOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockAppConfigDataClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type AppConfigDataAPI interface {
	GetLatestConfiguration(*appconfigdata.GetLatestConfigurationInput) (*appconfigdata.GetLatestConfigurationOutput, error)
	GetLatestConfigurationWithContext(aws.Context, *appconfigdata.GetLatestConfigurationInput, ...request.Option) (*appconfigdata.GetLatestConfigurationOutput, error)
	GetLatestConfigurationRequest(*appconfigdata.GetLatestConfigurationInput) (*request.Request, *appconfigdata.GetLatestConfigurationOutput)

	StartConfigurationSession(*appconfigdata.StartConfigurationSessionInput) (*appconfigdata.StartConfigurationSessionOutput, error)
	StartConfigurationSessionWithContext(aws.Context, *appconfigdata.StartConfigurationSessionInput, ...request.Option) (*appconfigdata.StartConfigurationSessionOutput, error)
	StartConfigurationSessionRequest(*appconfigdata.StartConfigurationSessionInput) (*request.Request, *appconfigdata.StartConfigurationSessionOutput)
}

var _ AppConfigDataAPI = (*appconfigdata.AppConfigData)(nil)
