// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/recommender/v1beta1/recommender_service.proto

package recommenderpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Recommender_ListInsights_FullMethodName                = "/google.cloud.recommender.v1beta1.Recommender/ListInsights"
	Recommender_GetInsight_FullMethodName                  = "/google.cloud.recommender.v1beta1.Recommender/GetInsight"
	Recommender_MarkInsightAccepted_FullMethodName         = "/google.cloud.recommender.v1beta1.Recommender/MarkInsightAccepted"
	Recommender_ListRecommendations_FullMethodName         = "/google.cloud.recommender.v1beta1.Recommender/ListRecommendations"
	Recommender_GetRecommendation_FullMethodName           = "/google.cloud.recommender.v1beta1.Recommender/GetRecommendation"
	Recommender_MarkRecommendationClaimed_FullMethodName   = "/google.cloud.recommender.v1beta1.Recommender/MarkRecommendationClaimed"
	Recommender_MarkRecommendationSucceeded_FullMethodName = "/google.cloud.recommender.v1beta1.Recommender/MarkRecommendationSucceeded"
	Recommender_MarkRecommendationFailed_FullMethodName    = "/google.cloud.recommender.v1beta1.Recommender/MarkRecommendationFailed"
	Recommender_GetRecommenderConfig_FullMethodName        = "/google.cloud.recommender.v1beta1.Recommender/GetRecommenderConfig"
	Recommender_UpdateRecommenderConfig_FullMethodName     = "/google.cloud.recommender.v1beta1.Recommender/UpdateRecommenderConfig"
	Recommender_GetInsightTypeConfig_FullMethodName        = "/google.cloud.recommender.v1beta1.Recommender/GetInsightTypeConfig"
	Recommender_UpdateInsightTypeConfig_FullMethodName     = "/google.cloud.recommender.v1beta1.Recommender/UpdateInsightTypeConfig"
	Recommender_ListRecommenders_FullMethodName            = "/google.cloud.recommender.v1beta1.Recommender/ListRecommenders"
	Recommender_ListInsightTypes_FullMethodName            = "/google.cloud.recommender.v1beta1.Recommender/ListInsightTypes"
)

// RecommenderClient is the client API for Recommender service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RecommenderClient interface {
	// Lists insights for the specified Cloud Resource. Requires the
	// recommender.*.list IAM permission for the specified insight type.
	ListInsights(ctx context.Context, in *ListInsightsRequest, opts ...grpc.CallOption) (*ListInsightsResponse, error)
	// Gets the requested insight. Requires the recommender.*.get IAM permission
	// for the specified insight type.
	GetInsight(ctx context.Context, in *GetInsightRequest, opts ...grpc.CallOption) (*Insight, error)
	// Marks the Insight State as Accepted. Users can use this method to
	// indicate to the Recommender API that they have applied some action based
	// on the insight. This stops the insight content from being updated.
	//
	// MarkInsightAccepted can be applied to insights in ACTIVE state. Requires
	// the recommender.*.update IAM permission for the specified insight.
	MarkInsightAccepted(ctx context.Context, in *MarkInsightAcceptedRequest, opts ...grpc.CallOption) (*Insight, error)
	// Lists recommendations for the specified Cloud Resource. Requires the
	// recommender.*.list IAM permission for the specified recommender.
	ListRecommendations(ctx context.Context, in *ListRecommendationsRequest, opts ...grpc.CallOption) (*ListRecommendationsResponse, error)
	// Gets the requested recommendation. Requires the recommender.*.get
	// IAM permission for the specified recommender.
	GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*Recommendation, error)
	// Marks the Recommendation State as Claimed. Users can use this method to
	// indicate to the Recommender API that they are starting to apply the
	// recommendation themselves. This stops the recommendation content from being
	// updated. Associated insights are frozen and placed in the ACCEPTED state.
	//
	// MarkRecommendationClaimed can be applied to recommendations in CLAIMED or
	// ACTIVE state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationClaimed(ctx context.Context, in *MarkRecommendationClaimedRequest, opts ...grpc.CallOption) (*Recommendation, error)
	// Marks the Recommendation State as Succeeded. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation was successful. This stops the recommendation
	// content from being updated. Associated insights are frozen and placed in
	// the ACCEPTED state.
	//
	// MarkRecommendationSucceeded can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationSucceeded(ctx context.Context, in *MarkRecommendationSucceededRequest, opts ...grpc.CallOption) (*Recommendation, error)
	// Marks the Recommendation State as Failed. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation failed. This stops the recommendation content
	// from being updated. Associated insights are frozen and placed in the
	// ACCEPTED state.
	//
	// MarkRecommendationFailed can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationFailed(ctx context.Context, in *MarkRecommendationFailedRequest, opts ...grpc.CallOption) (*Recommendation, error)
	// Gets the requested Recommender Config. There is only one instance of the
	// config for each Recommender.
	GetRecommenderConfig(ctx context.Context, in *GetRecommenderConfigRequest, opts ...grpc.CallOption) (*RecommenderConfig, error)
	// Updates a Recommender Config. This will create a new revision of the
	// config.
	UpdateRecommenderConfig(ctx context.Context, in *UpdateRecommenderConfigRequest, opts ...grpc.CallOption) (*RecommenderConfig, error)
	// Gets the requested InsightTypeConfig. There is only one instance of the
	// config for each InsightType.
	GetInsightTypeConfig(ctx context.Context, in *GetInsightTypeConfigRequest, opts ...grpc.CallOption) (*InsightTypeConfig, error)
	// Updates an InsightTypeConfig change. This will create a new revision of the
	// config.
	UpdateInsightTypeConfig(ctx context.Context, in *UpdateInsightTypeConfigRequest, opts ...grpc.CallOption) (*InsightTypeConfig, error)
	// Lists all available Recommenders.
	// No IAM permissions are required.
	ListRecommenders(ctx context.Context, in *ListRecommendersRequest, opts ...grpc.CallOption) (*ListRecommendersResponse, error)
	// Lists available InsightTypes.
	// No IAM permissions are required.
	ListInsightTypes(ctx context.Context, in *ListInsightTypesRequest, opts ...grpc.CallOption) (*ListInsightTypesResponse, error)
}

type recommenderClient struct {
	cc grpc.ClientConnInterface
}

func NewRecommenderClient(cc grpc.ClientConnInterface) RecommenderClient {
	return &recommenderClient{cc}
}

func (c *recommenderClient) ListInsights(ctx context.Context, in *ListInsightsRequest, opts ...grpc.CallOption) (*ListInsightsResponse, error) {
	out := new(ListInsightsResponse)
	err := c.cc.Invoke(ctx, Recommender_ListInsights_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) GetInsight(ctx context.Context, in *GetInsightRequest, opts ...grpc.CallOption) (*Insight, error) {
	out := new(Insight)
	err := c.cc.Invoke(ctx, Recommender_GetInsight_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) MarkInsightAccepted(ctx context.Context, in *MarkInsightAcceptedRequest, opts ...grpc.CallOption) (*Insight, error) {
	out := new(Insight)
	err := c.cc.Invoke(ctx, Recommender_MarkInsightAccepted_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) ListRecommendations(ctx context.Context, in *ListRecommendationsRequest, opts ...grpc.CallOption) (*ListRecommendationsResponse, error) {
	out := new(ListRecommendationsResponse)
	err := c.cc.Invoke(ctx, Recommender_ListRecommendations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, Recommender_GetRecommendation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) MarkRecommendationClaimed(ctx context.Context, in *MarkRecommendationClaimedRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, Recommender_MarkRecommendationClaimed_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) MarkRecommendationSucceeded(ctx context.Context, in *MarkRecommendationSucceededRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, Recommender_MarkRecommendationSucceeded_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) MarkRecommendationFailed(ctx context.Context, in *MarkRecommendationFailedRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, Recommender_MarkRecommendationFailed_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) GetRecommenderConfig(ctx context.Context, in *GetRecommenderConfigRequest, opts ...grpc.CallOption) (*RecommenderConfig, error) {
	out := new(RecommenderConfig)
	err := c.cc.Invoke(ctx, Recommender_GetRecommenderConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) UpdateRecommenderConfig(ctx context.Context, in *UpdateRecommenderConfigRequest, opts ...grpc.CallOption) (*RecommenderConfig, error) {
	out := new(RecommenderConfig)
	err := c.cc.Invoke(ctx, Recommender_UpdateRecommenderConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) GetInsightTypeConfig(ctx context.Context, in *GetInsightTypeConfigRequest, opts ...grpc.CallOption) (*InsightTypeConfig, error) {
	out := new(InsightTypeConfig)
	err := c.cc.Invoke(ctx, Recommender_GetInsightTypeConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) UpdateInsightTypeConfig(ctx context.Context, in *UpdateInsightTypeConfigRequest, opts ...grpc.CallOption) (*InsightTypeConfig, error) {
	out := new(InsightTypeConfig)
	err := c.cc.Invoke(ctx, Recommender_UpdateInsightTypeConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) ListRecommenders(ctx context.Context, in *ListRecommendersRequest, opts ...grpc.CallOption) (*ListRecommendersResponse, error) {
	out := new(ListRecommendersResponse)
	err := c.cc.Invoke(ctx, Recommender_ListRecommenders_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) ListInsightTypes(ctx context.Context, in *ListInsightTypesRequest, opts ...grpc.CallOption) (*ListInsightTypesResponse, error) {
	out := new(ListInsightTypesResponse)
	err := c.cc.Invoke(ctx, Recommender_ListInsightTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RecommenderServer is the server API for Recommender service.
// All implementations should embed UnimplementedRecommenderServer
// for forward compatibility
type RecommenderServer interface {
	// Lists insights for the specified Cloud Resource. Requires the
	// recommender.*.list IAM permission for the specified insight type.
	ListInsights(context.Context, *ListInsightsRequest) (*ListInsightsResponse, error)
	// Gets the requested insight. Requires the recommender.*.get IAM permission
	// for the specified insight type.
	GetInsight(context.Context, *GetInsightRequest) (*Insight, error)
	// Marks the Insight State as Accepted. Users can use this method to
	// indicate to the Recommender API that they have applied some action based
	// on the insight. This stops the insight content from being updated.
	//
	// MarkInsightAccepted can be applied to insights in ACTIVE state. Requires
	// the recommender.*.update IAM permission for the specified insight.
	MarkInsightAccepted(context.Context, *MarkInsightAcceptedRequest) (*Insight, error)
	// Lists recommendations for the specified Cloud Resource. Requires the
	// recommender.*.list IAM permission for the specified recommender.
	ListRecommendations(context.Context, *ListRecommendationsRequest) (*ListRecommendationsResponse, error)
	// Gets the requested recommendation. Requires the recommender.*.get
	// IAM permission for the specified recommender.
	GetRecommendation(context.Context, *GetRecommendationRequest) (*Recommendation, error)
	// Marks the Recommendation State as Claimed. Users can use this method to
	// indicate to the Recommender API that they are starting to apply the
	// recommendation themselves. This stops the recommendation content from being
	// updated. Associated insights are frozen and placed in the ACCEPTED state.
	//
	// MarkRecommendationClaimed can be applied to recommendations in CLAIMED or
	// ACTIVE state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationClaimed(context.Context, *MarkRecommendationClaimedRequest) (*Recommendation, error)
	// Marks the Recommendation State as Succeeded. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation was successful. This stops the recommendation
	// content from being updated. Associated insights are frozen and placed in
	// the ACCEPTED state.
	//
	// MarkRecommendationSucceeded can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationSucceeded(context.Context, *MarkRecommendationSucceededRequest) (*Recommendation, error)
	// Marks the Recommendation State as Failed. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation failed. This stops the recommendation content
	// from being updated. Associated insights are frozen and placed in the
	// ACCEPTED state.
	//
	// MarkRecommendationFailed can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationFailed(context.Context, *MarkRecommendationFailedRequest) (*Recommendation, error)
	// Gets the requested Recommender Config. There is only one instance of the
	// config for each Recommender.
	GetRecommenderConfig(context.Context, *GetRecommenderConfigRequest) (*RecommenderConfig, error)
	// Updates a Recommender Config. This will create a new revision of the
	// config.
	UpdateRecommenderConfig(context.Context, *UpdateRecommenderConfigRequest) (*RecommenderConfig, error)
	// Gets the requested InsightTypeConfig. There is only one instance of the
	// config for each InsightType.
	GetInsightTypeConfig(context.Context, *GetInsightTypeConfigRequest) (*InsightTypeConfig, error)
	// Updates an InsightTypeConfig change. This will create a new revision of the
	// config.
	UpdateInsightTypeConfig(context.Context, *UpdateInsightTypeConfigRequest) (*InsightTypeConfig, error)
	// Lists all available Recommenders.
	// No IAM permissions are required.
	ListRecommenders(context.Context, *ListRecommendersRequest) (*ListRecommendersResponse, error)
	// Lists available InsightTypes.
	// No IAM permissions are required.
	ListInsightTypes(context.Context, *ListInsightTypesRequest) (*ListInsightTypesResponse, error)
}

// UnimplementedRecommenderServer should be embedded to have forward compatible implementations.
type UnimplementedRecommenderServer struct {
}

func (UnimplementedRecommenderServer) ListInsights(context.Context, *ListInsightsRequest) (*ListInsightsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInsights not implemented")
}
func (UnimplementedRecommenderServer) GetInsight(context.Context, *GetInsightRequest) (*Insight, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInsight not implemented")
}
func (UnimplementedRecommenderServer) MarkInsightAccepted(context.Context, *MarkInsightAcceptedRequest) (*Insight, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MarkInsightAccepted not implemented")
}
func (UnimplementedRecommenderServer) ListRecommendations(context.Context, *ListRecommendationsRequest) (*ListRecommendationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRecommendations not implemented")
}
func (UnimplementedRecommenderServer) GetRecommendation(context.Context, *GetRecommendationRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRecommendation not implemented")
}
func (UnimplementedRecommenderServer) MarkRecommendationClaimed(context.Context, *MarkRecommendationClaimedRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MarkRecommendationClaimed not implemented")
}
func (UnimplementedRecommenderServer) MarkRecommendationSucceeded(context.Context, *MarkRecommendationSucceededRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MarkRecommendationSucceeded not implemented")
}
func (UnimplementedRecommenderServer) MarkRecommendationFailed(context.Context, *MarkRecommendationFailedRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MarkRecommendationFailed not implemented")
}
func (UnimplementedRecommenderServer) GetRecommenderConfig(context.Context, *GetRecommenderConfigRequest) (*RecommenderConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRecommenderConfig not implemented")
}
func (UnimplementedRecommenderServer) UpdateRecommenderConfig(context.Context, *UpdateRecommenderConfigRequest) (*RecommenderConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRecommenderConfig not implemented")
}
func (UnimplementedRecommenderServer) GetInsightTypeConfig(context.Context, *GetInsightTypeConfigRequest) (*InsightTypeConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInsightTypeConfig not implemented")
}
func (UnimplementedRecommenderServer) UpdateInsightTypeConfig(context.Context, *UpdateInsightTypeConfigRequest) (*InsightTypeConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInsightTypeConfig not implemented")
}
func (UnimplementedRecommenderServer) ListRecommenders(context.Context, *ListRecommendersRequest) (*ListRecommendersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRecommenders not implemented")
}
func (UnimplementedRecommenderServer) ListInsightTypes(context.Context, *ListInsightTypesRequest) (*ListInsightTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInsightTypes not implemented")
}

// UnsafeRecommenderServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RecommenderServer will
// result in compilation errors.
type UnsafeRecommenderServer interface {
	mustEmbedUnimplementedRecommenderServer()
}

func RegisterRecommenderServer(s grpc.ServiceRegistrar, srv RecommenderServer) {
	s.RegisterService(&Recommender_ServiceDesc, srv)
}

func _Recommender_ListInsights_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInsightsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).ListInsights(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Recommender_ListInsights_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).ListInsights(ctx, req.(*ListInsightsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_GetInsight_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInsightRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).GetInsight(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Recommender_GetInsight_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).GetInsight(ctx, req.(*GetInsightRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_MarkInsightAccepted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkInsightAcceptedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).MarkInsightAccepted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Recommender_MarkInsightAccepted_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).MarkInsightAccepted(ctx, req.(*MarkInsightAcceptedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_ListRecommendations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRecommendationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).ListRecommendations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Recommender_ListRecommendations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).ListRecommendations(ctx, req.(*ListRecommendationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_GetRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).GetRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Recommender_GetRecommendation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).GetRecommendation(ctx, req.(*GetRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_MarkRecommendationClaimed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkRecommendationClaimedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).MarkRecommendationClaimed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Recommender_MarkRecommendationClaimed_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).MarkRecommendationClaimed(ctx, req.(*MarkRecommendationClaimedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_MarkRecommendationSucceeded_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkRecommendationSucceededRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).MarkRecommendationSucceeded(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Recommender_MarkRecommendationSucceeded_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).MarkRecommendationSucceeded(ctx, req.(*MarkRecommendationSucceededRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_MarkRecommendationFailed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkRecommendationFailedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).MarkRecommendationFailed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Recommender_MarkRecommendationFailed_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).MarkRecommendationFailed(ctx, req.(*MarkRecommendationFailedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_GetRecommenderConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRecommenderConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).GetRecommenderConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Recommender_GetRecommenderConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).GetRecommenderConfig(ctx, req.(*GetRecommenderConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_UpdateRecommenderConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRecommenderConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).UpdateRecommenderConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Recommender_UpdateRecommenderConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).UpdateRecommenderConfig(ctx, req.(*UpdateRecommenderConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_GetInsightTypeConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInsightTypeConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).GetInsightTypeConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Recommender_GetInsightTypeConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).GetInsightTypeConfig(ctx, req.(*GetInsightTypeConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_UpdateInsightTypeConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInsightTypeConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).UpdateInsightTypeConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Recommender_UpdateInsightTypeConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).UpdateInsightTypeConfig(ctx, req.(*UpdateInsightTypeConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_ListRecommenders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRecommendersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).ListRecommenders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Recommender_ListRecommenders_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).ListRecommenders(ctx, req.(*ListRecommendersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_ListInsightTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInsightTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).ListInsightTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Recommender_ListInsightTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).ListInsightTypes(ctx, req.(*ListInsightTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Recommender_ServiceDesc is the grpc.ServiceDesc for Recommender service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Recommender_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recommender.v1beta1.Recommender",
	HandlerType: (*RecommenderServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInsights",
			Handler:    _Recommender_ListInsights_Handler,
		},
		{
			MethodName: "GetInsight",
			Handler:    _Recommender_GetInsight_Handler,
		},
		{
			MethodName: "MarkInsightAccepted",
			Handler:    _Recommender_MarkInsightAccepted_Handler,
		},
		{
			MethodName: "ListRecommendations",
			Handler:    _Recommender_ListRecommendations_Handler,
		},
		{
			MethodName: "GetRecommendation",
			Handler:    _Recommender_GetRecommendation_Handler,
		},
		{
			MethodName: "MarkRecommendationClaimed",
			Handler:    _Recommender_MarkRecommendationClaimed_Handler,
		},
		{
			MethodName: "MarkRecommendationSucceeded",
			Handler:    _Recommender_MarkRecommendationSucceeded_Handler,
		},
		{
			MethodName: "MarkRecommendationFailed",
			Handler:    _Recommender_MarkRecommendationFailed_Handler,
		},
		{
			MethodName: "GetRecommenderConfig",
			Handler:    _Recommender_GetRecommenderConfig_Handler,
		},
		{
			MethodName: "UpdateRecommenderConfig",
			Handler:    _Recommender_UpdateRecommenderConfig_Handler,
		},
		{
			MethodName: "GetInsightTypeConfig",
			Handler:    _Recommender_GetInsightTypeConfig_Handler,
		},
		{
			MethodName: "UpdateInsightTypeConfig",
			Handler:    _Recommender_UpdateInsightTypeConfig_Handler,
		},
		{
			MethodName: "ListRecommenders",
			Handler:    _Recommender_ListRecommenders_Handler,
		},
		{
			MethodName: "ListInsightTypes",
			Handler:    _Recommender_ListInsightTypes_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recommender/v1beta1/recommender_service.proto",
}
