/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.websocket.jakarta.common.messages;

import jakarta.websocket.CloseReason;
import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.WrongMethodTypeException;
import java.util.List;
import org.eclipse.jetty.ee10.websocket.jakarta.common.decoders.RegisteredDecoder;
import org.eclipse.jetty.ee10.websocket.jakarta.common.messages.AbstractDecodedMessageSink;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.exception.CloseException;
import org.eclipse.jetty.websocket.core.messages.InputStreamMessageSink;
import org.eclipse.jetty.websocket.core.messages.MessageSink;
import org.eclipse.jetty.websocket.core.util.MethodHolder;

public class DecodedBinaryStreamMessageSink<T>
extends AbstractDecodedMessageSink.Stream<Decoder.BinaryStream<T>> {
    public DecodedBinaryStreamMessageSink(CoreSession session, MethodHolder methodHolder, List<RegisteredDecoder> decoders) {
        super(session, methodHolder, decoders);
    }

    @Override
    MessageSink newMessageSink(CoreSession coreSession) {
        MethodHolder methodHolder = args -> {
            if (args.length != 1) {
                throw new WrongMethodTypeException(String.format("Expected %s params but had %s", 1, args.length));
            }
            this.onStreamStart((InputStream)args[0]);
            return null;
        };
        return new InputStreamMessageSink(coreSession, methodHolder, true);
    }

    public void onStreamStart(InputStream stream) {
        try {
            Object obj = ((Decoder.BinaryStream)this._decoder).decode(stream);
            this.invoke(obj);
        }
        catch (DecodeException | IOException e) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Unable to decode", e);
        }
    }
}

