/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.command;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.command.CommandSender;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Command;
import org.traccar.model.Device;

@Singleton
public class TraccarCommandSender
implements CommandSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraccarCommandSender.class);
    private final Client client;
    private final String url;
    private final String key;

    @Inject
    public TraccarCommandSender(Config config, Client client) throws IOException {
        this.client = client;
        this.url = "https://www.traccar.org/push/";
        this.key = config.getString(Keys.NOTIFICATOR_TRACCAR_KEY);
    }

    @Override
    public Collection<String> getSupportedCommands() {
        return List.of("positionSingle", "positionPeriodic", "positionStop", "factoryReset");
    }

    @Override
    public void sendCommand(Device device, Command command) throws Exception {
        if (!device.hasAttribute("notificationTokens")) {
            throw new RuntimeException("Missing device notification tokens");
        }
        Message message = new Message();
        message.type = "client";
        message.tokens = device.getString("notificationTokens").split("[, ]");
        message.data = Map.of("command", command.getType());
        Invocation.Builder request = this.client.target(this.url).request().header("Authorization", (Object)("key=" + this.key));
        try {
            request.post(Entity.json((Object)message));
        }
        catch (Exception e) {
            LOGGER.warn("Command push error", (Throwable)e);
        }
    }

    public static class Message {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="registration_ids")
        private String[] tokens;
        @JsonProperty(value="data")
        private Map<String, String> data;
    }
}

