/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.remoteconfig.MicroPercentRange;
import com.google.firebase.remoteconfig.PercentConditionOperator;
import com.google.firebase.remoteconfig.internal.ServerTemplateResponse;

public final class PercentCondition {
    private int microPercent;
    private MicroPercentRange microPercentRange;
    private final PercentConditionOperator percentConditionOperator;
    private final String seed;

    PercentCondition(@Nullable Integer microPercent, @NonNull PercentConditionOperator percentConditionOperator, @NonNull String seed) {
        Preconditions.checkNotNull((Object)((Object)percentConditionOperator), (Object)"Percentage operator must not be null.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)seed) ? 1 : 0) != 0, (Object)"Seed must not be null or empty.");
        this.microPercent = microPercent != null ? microPercent : 0;
        this.percentConditionOperator = percentConditionOperator;
        this.seed = seed;
    }

    PercentCondition(@NonNull MicroPercentRange microPercentRange, @NonNull PercentConditionOperator percentConditionOperator, String seed) {
        Preconditions.checkNotNull((Object)microPercentRange, (Object)"Percent range must not be null.");
        Preconditions.checkNotNull((Object)((Object)percentConditionOperator), (Object)"Percentage operator must not be null.");
        this.microPercentRange = microPercentRange;
        this.percentConditionOperator = percentConditionOperator;
        this.seed = seed;
    }

    PercentCondition(ServerTemplateResponse.PercentConditionResponse percentCondition) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)percentCondition.getSeed()) ? 1 : 0) != 0, (Object)"Seed must not be empty or null");
        this.microPercent = percentCondition.getMicroPercent();
        this.seed = percentCondition.getSeed();
        switch (percentCondition.getPercentOperator()) {
            case "BETWEEN": {
                this.percentConditionOperator = PercentConditionOperator.BETWEEN;
                break;
            }
            case "GREATER_THAN": {
                this.percentConditionOperator = PercentConditionOperator.GREATER_THAN;
                break;
            }
            case "LESS_OR_EQUAL": {
                this.percentConditionOperator = PercentConditionOperator.LESS_OR_EQUAL;
                break;
            }
            default: {
                this.percentConditionOperator = PercentConditionOperator.UNSPECIFIED;
            }
        }
        Preconditions.checkArgument((this.percentConditionOperator != PercentConditionOperator.UNSPECIFIED ? 1 : 0) != 0, (Object)"Percentage operator is invalid");
        if (percentCondition.getMicroPercentRange() != null) {
            this.microPercentRange = new MicroPercentRange(percentCondition.getMicroPercentRange().getMicroPercentLowerBound(), percentCondition.getMicroPercentRange().getMicroPercentUpperBound());
        }
    }

    @Nullable
    public int getMicroPercent() {
        return this.microPercent;
    }

    @Nullable
    public MicroPercentRange getMicroPercentRange() {
        return this.microPercentRange;
    }

    @NonNull
    public PercentConditionOperator getPercentConditionOperator() {
        return this.percentConditionOperator;
    }

    @NonNull
    public String getSeed() {
        return this.seed;
    }

    ServerTemplateResponse.PercentConditionResponse toPercentConditionResponse() {
        ServerTemplateResponse.PercentConditionResponse percentConditionResponse = new ServerTemplateResponse.PercentConditionResponse();
        percentConditionResponse.setMicroPercent(this.microPercent);
        percentConditionResponse.setMicroPercentRange(this.microPercentRange.toMicroPercentRangeResponse());
        percentConditionResponse.setPercentOperator(this.percentConditionOperator.getOperator());
        percentConditionResponse.setSeed(this.seed);
        return percentConditionResponse;
    }
}

