/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.BetaApi;
import io.opentelemetry.api.OpenTelemetry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@BetaApi
public class FirestoreOpenTelemetryOptions {
    private final boolean exportBuiltinMetricsToGoogleCloudMonitoring;
    @Nullable
    private final OpenTelemetry openTelemetry;

    FirestoreOpenTelemetryOptions(Builder builder) {
        this.exportBuiltinMetricsToGoogleCloudMonitoring = builder.exportBuiltinMetricsToGoogleCloudMonitoring;
        this.openTelemetry = builder.openTelemetry;
    }

    public boolean exportBuiltinMetricsToGoogleCloudMonitoring() {
        return this.exportBuiltinMetricsToGoogleCloudMonitoring;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private boolean exportBuiltinMetricsToGoogleCloudMonitoring;
        @Nullable
        private OpenTelemetry openTelemetry;

        private Builder() {
            this.exportBuiltinMetricsToGoogleCloudMonitoring = false;
            this.openTelemetry = null;
        }

        private Builder(FirestoreOpenTelemetryOptions options) {
            this.exportBuiltinMetricsToGoogleCloudMonitoring = options.exportBuiltinMetricsToGoogleCloudMonitoring;
            this.openTelemetry = options.openTelemetry;
        }

        @Nonnull
        public FirestoreOpenTelemetryOptions build() {
            return new FirestoreOpenTelemetryOptions(this);
        }

        @Nonnull
        private Builder exportBuiltinMetricsToGoogleCloudMonitoring(boolean exportBuiltinMetrics) {
            this.exportBuiltinMetricsToGoogleCloudMonitoring = exportBuiltinMetrics;
            return this;
        }

        @Nonnull
        public Builder setOpenTelemetry(@Nonnull OpenTelemetry openTelemetry) {
            this.openTelemetry = openTelemetry;
            return this;
        }
    }
}

