/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.command;

import org.jxls.area.Area;
import org.jxls.command.AbstractCommand;
import org.jxls.command.CellDataUpdater;
import org.jxls.command.Command;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCellCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "updateCell";
    private static Logger logger = LoggerFactory.getLogger(UpdateCellCommand.class);
    private Area area;
    private String updater;
    private CellDataUpdater cellDataUpdater;

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    public String getUpdater() {
        return this.updater;
    }

    public void setUpdater(String updater) {
        this.updater = updater;
    }

    public CellDataUpdater getCellDataUpdater() {
        return this.cellDataUpdater;
    }

    public void setCellDataUpdater(CellDataUpdater cellDataUpdater) {
        this.cellDataUpdater = cellDataUpdater;
    }

    @Override
    public Command addArea(Area area) {
        String message = "You can only add a single cell area to 'updateCell' command!";
        if (this.areaList.size() >= 1) {
            throw new IllegalArgumentException(message);
        }
        if (area != null && area.getSize().getHeight() != 1 && area.getSize().getWidth() != 1) {
            throw new IllegalArgumentException(message);
        }
        this.area = area;
        return super.addArea(area);
    }

    @Override
    public Size applyAt(CellRef cellRef, Context context) {
        CellDataUpdater cellDataUpdater = this.createCellDataUpdater(context);
        if (cellDataUpdater != null) {
            CellRef srcCell = this.area.getStartCellRef();
            CellData cellData = this.area.getTransformer().getCellData(srcCell);
            cellDataUpdater.updateCellData(cellData, cellRef, context);
        }
        return this.area.applyAt(cellRef, context);
    }

    private CellDataUpdater createCellDataUpdater(Context context) {
        if (this.updater == null) {
            logger.warn("Attribute 'updater' is not set!");
            return null;
        }
        Object updaterInstance = context.getVar(this.updater);
        if (updaterInstance instanceof CellDataUpdater) {
            return (CellDataUpdater)updaterInstance;
        }
        logger.warn("CellDataUpdater is null or does not implement CellDataUpdater! Attribute 'updater': {}", (Object)this.updater);
        return null;
    }
}

