/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.expression;

import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.jxls.expression.EvaluationException;
import org.jxls.expression.ExpressionEvaluator;

public class ExpressionEvaluator4JSR223Impl
implements ExpressionEvaluator {
    private final String expression;
    private final ScriptEngine scriptEngine;
    private static final ThreadLocal<BindingCacheHolder> threadLocalCache = new ThreadLocal<BindingCacheHolder>(){

        @Override
        protected BindingCacheHolder initialValue() {
            return new BindingCacheHolder();
        }
    };

    public ExpressionEvaluator4JSR223Impl(ScriptEngine scriptEngine, String expression) {
        this.scriptEngine = scriptEngine;
        this.expression = expression;
    }

    @Override
    public Object evaluate(String expression, Map<String, Object> context) {
        if (expression == null || context == null) {
            return null;
        }
        BindingCacheHolder holder = threadLocalCache.get();
        if (holder.binding == null) {
            holder.binding = new SimpleBindings(context);
        }
        if (holder.context == null || holder.context != context) {
            holder.context = context;
            holder.binding.putAll((Map<? extends String, ? extends Object>)context);
        }
        try {
            return this.scriptEngine.eval(expression, holder.binding);
        }
        catch (ScriptException e) {
            throw new EvaluationException("Evaluate error on: " + expression, e);
        }
    }

    @Override
    public Object evaluate(Map<String, Object> context) {
        return this.evaluate(this.expression, context);
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public void clear() {
        BindingCacheHolder holder = threadLocalCache.get();
        holder.binding = null;
        holder.context = null;
    }

    private static class BindingCacheHolder {
        Bindings binding;
        Map<String, Object> context;

        private BindingCacheHolder() {
        }
    }
}

