/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.util.Map;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.tools.config.ConfigurationUtils;
import org.apache.velocity.tools.generic.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeConfig {
    public static final String LOCK_CONFIG_KEY = "lockConfig";
    public static final String SAFE_MODE_KEY = "safeMode";
    public static final String LOGGER_NAME_KEY = "loggerName";
    public static final String USE_CLASS_LOGGER_KEY = "useClassLogger";
    private boolean configLocked = false;
    private boolean safeMode = false;
    protected Logger log = null;

    protected void setLockConfig(boolean lock) {
        this.configLocked = lock;
    }

    protected void setSafeMode(boolean safe) {
        this.safeMode = safe;
    }

    public boolean isConfigLocked() {
        return this.configLocked;
    }

    public boolean isSafeMode() {
        return this.safeMode;
    }

    public void configure(Map<String, Object> params) {
        if (!this.isConfigLocked()) {
            ValueParser values = new ValueParser(params);
            this.initLogger(values);
            this.configure(values);
            this.setSafeMode(values.getBoolean(SAFE_MODE_KEY, true));
            Boolean lock = values.getBoolean(LOCK_CONFIG_KEY, Boolean.TRUE);
            this.setLockConfig(lock);
        }
    }

    protected void configure(ValueParser values) {
    }

    protected void initLogger(ValueParser params) {
        String loggerName = params.getString(LOGGER_NAME_KEY);
        if (loggerName != null) {
            this.log = LoggerFactory.getLogger((String)loggerName);
        } else {
            boolean useClassLogger = params.getBoolean(USE_CLASS_LOGGER_KEY, false);
            if (!useClassLogger) {
                VelocityEngine engine = (VelocityEngine)params.get("velocityEngine");
                String key = (String)params.get("key");
                if (engine != null && key != null) {
                    this.log = ConfigurationUtils.getLog(engine, "tools." + key);
                }
            }
            if (this.log == null) {
                this.log = LoggerFactory.getLogger(this.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Logger getLog() {
        if (this.log == null) {
            SafeConfig safeConfig = this;
            synchronized (safeConfig) {
                if (this.log == null) {
                    this.log = LoggerFactory.getLogger(this.getClass());
                }
            }
        }
        return this.log;
    }
}

