/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.forward;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.core.Response;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.forward.EventData;
import org.traccar.forward.EventForwarder;
import org.traccar.forward.ResultHandler;

public class EventForwarderJson
implements EventForwarder {
    private final String url;
    private final String header;
    private final Client client;

    public EventForwarderJson(Config config, Client client) {
        this.client = client;
        this.url = config.getString(Keys.EVENT_FORWARD_URL);
        this.header = config.getString(Keys.EVENT_FORWARD_HEADERS);
    }

    @Override
    public void forward(EventData eventData, final ResultHandler resultHandler) {
        Invocation.Builder requestBuilder = this.client.target(this.url).request();
        if (this.header != null && !this.header.isEmpty()) {
            for (String line : this.header.split("\\r?\\n")) {
                String[] values = line.split(":", 2);
                requestBuilder.header(values[0].trim(), (Object)values[1].trim());
            }
        }
        requestBuilder.async().post(Entity.json((Object)eventData), (InvocationCallback)new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    resultHandler.onResult(true, null);
                } else {
                    int code = response.getStatusInfo().getStatusCode();
                    resultHandler.onResult(false, new RuntimeException("HTTP code " + code));
                }
            }

            public void failed(Throwable throwable) {
                resultHandler.onResult(false, throwable);
            }
        });
    }
}

