/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.forward;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.forward.EventData;
import org.traccar.forward.EventForwarder;
import org.traccar.forward.MqttClient;
import org.traccar.forward.ResultHandler;

public class EventForwarderMqtt
implements EventForwarder {
    private final MqttClient mqttClient;
    private final ObjectMapper objectMapper;
    private final String topic;

    public EventForwarderMqtt(Config config, ObjectMapper objectMapper) {
        this.topic = config.getString(Keys.EVENT_FORWARD_TOPIC);
        this.mqttClient = new MqttClient(config.getString(Keys.EVENT_FORWARD_URL));
        this.objectMapper = objectMapper;
    }

    @Override
    public void forward(EventData eventData, ResultHandler resultHandler) {
        try {
            String payload = this.objectMapper.writeValueAsString((Object)eventData);
            this.mqttClient.publish(this.topic, payload, (message, e) -> resultHandler.onResult(e == null, (Throwable)e));
        }
        catch (JsonProcessingException e2) {
            resultHandler.onResult(false, e2);
        }
    }
}

