/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notification.NotificationMessage;
import org.traccar.notificators.Notificator;

@Singleton
public class NotificatorTelegram
extends Notificator {
    private final Client client;
    private final String urlSendText;
    private final String urlSendLocation;
    private final String chatId;
    private final boolean sendLocation;

    @Inject
    public NotificatorTelegram(Config config, NotificationFormatter notificationFormatter, Client client) {
        super(notificationFormatter);
        this.client = client;
        this.urlSendText = String.format("https://api.telegram.org/bot%s/sendMessage", config.getString(Keys.NOTIFICATOR_TELEGRAM_KEY));
        this.urlSendLocation = String.format("https://api.telegram.org/bot%s/sendLocation", config.getString(Keys.NOTIFICATOR_TELEGRAM_KEY));
        this.chatId = config.getString(Keys.NOTIFICATOR_TELEGRAM_CHAT_ID);
        this.sendLocation = config.getBoolean(Keys.NOTIFICATOR_TELEGRAM_SEND_LOCATION);
    }

    private LocationMessage createLocationMessage(String messageChatId, Position position) {
        LocationMessage locationMessage = new LocationMessage();
        locationMessage.chatId = messageChatId;
        locationMessage.latitude = position.getLatitude();
        locationMessage.longitude = position.getLongitude();
        locationMessage.bearing = (int)Math.ceil(position.getCourse());
        locationMessage.accuracy = position.getAccuracy();
        return locationMessage;
    }

    @Override
    public void send(User user, NotificationMessage shortMessage, Event event, Position position) {
        TextMessage message = new TextMessage();
        message.chatId = user.getString("telegramChatId");
        if (message.chatId == null) {
            message.chatId = this.chatId;
        }
        message.text = shortMessage.digest();
        this.client.target(this.urlSendText).request().post(Entity.json((Object)message)).close();
        if (this.sendLocation && position != null) {
            this.client.target(this.urlSendLocation).request().post(Entity.json((Object)this.createLocationMessage(message.chatId, position))).close();
        }
    }

    public static class LocationMessage {
        @JsonProperty(value="chat_id")
        private String chatId;
        @JsonProperty(value="latitude")
        private double latitude;
        @JsonProperty(value="longitude")
        private double longitude;
        @JsonProperty(value="horizontal_accuracy")
        private double accuracy;
        @JsonProperty(value="bearing")
        private int bearing;
    }

    public static class TextMessage {
        @JsonProperty(value="chat_id")
        private String chatId;
        @JsonProperty(value="text")
        private String text;
        @JsonProperty(value="parse_mode")
        private String parseMode = "html";
    }
}

