/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class LaipacProtocolEncoder
extends StringProtocolEncoder {
    public LaipacProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected String formatCommand(Command command, String format, String ... keys) {
        Object sentence = super.formatCommand(command, "$" + format, keys);
        sentence = (String)sentence + Checksum.nmea(((String)sentence).substring(1)) + "\r\n";
        return sentence;
    }

    @Override
    protected Object encodeCommand(Command command) {
        this.initDevicePassword(command, "00000000");
        return switch (command.getType()) {
            case "custom" -> this.formatCommand(command, "%s", "data");
            case "positionSingle" -> this.formatCommand(command, "AVREQ,%s,1", "devicePassword");
            case "rebootDevice" -> this.formatCommand(command, "AVRESET,%s,%s", "uniqueId", "devicePassword");
            default -> null;
        };
    }
}

