/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.TimeZone;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.Checksum;
import org.traccar.helper.DataConverter;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.Command;

public class MeiligaoProtocolEncoder
extends BaseProtocolEncoder {
    public MeiligaoProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeContent(long deviceId, int type, ByteBuf content) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(64);
        buf.writeByte(64);
        buf.writeShort(13 + content.readableBytes() + 2 + 2);
        buf.writeBytes(DataConverter.parseHex((this.getUniqueId(deviceId) + "FFFFFFFFFFFFFF").substring(0, 14)));
        buf.writeShort(type);
        buf.writeBytes(content);
        buf.writeShort(Checksum.crc16(Checksum.CRC16_CCITT_FALSE, buf.nioBuffer()));
        buf.writeByte(13);
        buf.writeByte(10);
        return buf;
    }

    private ByteBuf encodeOutputCommand(long deviceId, int index, int value) {
        int outputType;
        int outputCount;
        String model = this.getDeviceModel(deviceId);
        if (model != null && Set.of("TK510", "GT08", "TK208", "TK228", "MT05").contains(model)) {
            outputCount = 5;
            outputType = 16660;
        } else {
            outputCount = 1;
            boolean alternative = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_ALTERNATIVE.withPrefix(this.getProtocolName()), deviceId);
            outputType = alternative ? 16660 : 16661;
        }
        ByteBuf content = Unpooled.buffer();
        for (int i = 1; i <= outputCount; ++i) {
            content.writeByte(i == index ? value : 2);
        }
        return this.encodeContent(deviceId, outputType, content);
    }

    @Override
    protected Object encodeCommand(Command command) {
        ByteBuf content = Unpooled.buffer();
        switch (command.getType()) {
            case "positionSingle": {
                return this.encodeContent(command.getDeviceId(), 16641, content);
            }
            case "positionPeriodic": {
                content.writeShort(command.getInteger("frequency") / 10);
                return this.encodeContent(command.getDeviceId(), 16642, content);
            }
            case "outputControl": {
                int index = command.getInteger("index") - 1;
                int value = command.getInteger("data");
                return this.encodeOutputCommand(command.getDeviceId(), index, value);
            }
            case "engineStop": {
                return this.encodeOutputCommand(command.getDeviceId(), 1, 1);
            }
            case "engineResume": {
                return this.encodeOutputCommand(command.getDeviceId(), 1, 0);
            }
            case "alarmGeofence": {
                content.writeShort(command.getInteger("radius"));
                return this.encodeContent(command.getDeviceId(), 16646, content);
            }
            case "setTimezone": {
                int offset = TimeZone.getTimeZone(command.getString("timezone")).getRawOffset() / 60000;
                content.writeBytes(String.valueOf(offset).getBytes(StandardCharsets.US_ASCII));
                return this.encodeContent(command.getDeviceId(), 16690, content);
            }
            case "requestPhoto": {
                return this.encodeContent(command.getDeviceId(), 16721, content);
            }
            case "rebootDevice": {
                return this.encodeContent(command.getDeviceId(), 18690, content);
            }
        }
        return null;
    }
}

