/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class PretraceProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("(").number("(d{15})").number("Uddd").number("d").expression("([AV])").number("(dd)(dd)(dd)").number("(dd)(dd)(dd)").number("(dd)(dd.dddd)").expression("([NS])").number("(ddd)(dd.dddd)").expression("([EW])").number("(ddd)").number("(ddd)").number("(xxx)").number("(x{8})").number("(x)").number("(dd)").number("(dd)").expression("(.{8}),&").expression("(.+)?").text("^").number("xx").compile();

    public PretraceProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(parser.next().equals("A"));
        position.setTime(parser.nextDateTime());
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt(0)));
        position.setCourse(parser.nextInt(0));
        position.setAltitude(parser.nextHexInt(0));
        position.set("odometer", parser.nextHexInt(0));
        position.set("sat", parser.nextHexInt(0));
        position.set("hdop", parser.nextInt(0));
        position.set("rssi", parser.nextInt(0));
        parser.next();
        if (parser.hasNext()) {
            block6: for (String value : parser.next().split(",")) {
                switch (value.charAt(0)) {
                    case 'P': {
                        if (value.charAt(1) == '1') {
                            if (value.charAt(4) == '%') {
                                position.set("batteryLevel", Integer.parseInt(value.substring(2, 4)));
                                continue block6;
                            }
                            position.set("battery", (double)Integer.parseInt(value.substring(2), 16) * 0.01);
                            continue block6;
                        }
                        position.set("power", (double)Integer.parseInt(value.substring(2), 16) * 0.01);
                        continue block6;
                    }
                    case 'T': {
                        double temperature = (double)Integer.parseInt(value.substring(2), 16) * 0.25;
                        if (value.charAt(1) == '1') {
                            position.set("deviceTemp", temperature);
                            continue block6;
                        }
                        position.set("temp" + (value.charAt(1) - 48), temperature);
                        continue block6;
                    }
                    case 'F': {
                        position.set("fuel" + (value.charAt(1) - 48), (double)Integer.parseInt(value.substring(2), 16) * 0.01);
                        continue block6;
                    }
                    case 'R': {
                        position.set("driverUniqueId", value.substring(3));
                        continue block6;
                    }
                }
            }
        }
        return position;
    }
}

