/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;
import org.traccar.NetworkMessage;
import org.traccar.helper.BufferUtil;

public class WondexFrameDecoder
extends BaseFrameDecoder {
    private static final int KEEP_ALIVE_LENGTH = 8;

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        if (buf.readableBytes() < 8) {
            return null;
        }
        if (buf.getUnsignedByte(buf.readerIndex()) == 208) {
            ByteBuf frame = buf.readRetainedSlice(8);
            if (channel != null) {
                frame.retain();
                channel.writeAndFlush((Object)new NetworkMessage(frame, channel.remoteAddress()));
            }
            return frame;
        }
        int index = BufferUtil.indexOf("\r\n", buf);
        if (index != -1) {
            ByteBuf frame = buf.readRetainedSlice(index - buf.readerIndex());
            buf.skipBytes(2);
            return frame;
        }
        return null;
    }
}

