/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.json;

import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.McpJsonMapperSupplier;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

final class McpJsonInternal {
    private static McpJsonMapper defaultJsonMapper = null;

    McpJsonInternal() {
    }

    static McpJsonMapper getDefaultMapper() {
        if (defaultJsonMapper == null) {
            defaultJsonMapper = McpJsonInternal.createDefaultMapper();
        }
        return defaultJsonMapper;
    }

    static McpJsonMapper createDefaultMapper() {
        AtomicReference ex = new AtomicReference();
        return (McpJsonMapper)ServiceLoader.load(McpJsonMapperSupplier.class).stream().flatMap(p -> {
            try {
                McpJsonMapperSupplier supplier = (McpJsonMapperSupplier)p.get();
                return Stream.ofNullable(supplier);
            }
            catch (Exception e) {
                McpJsonInternal.addException(ex, e);
                return Stream.empty();
            }
        }).flatMap(jsonMapperSupplier -> {
            try {
                return Stream.ofNullable((McpJsonMapper)jsonMapperSupplier.get());
            }
            catch (Exception e) {
                McpJsonInternal.addException(ex, e);
                return Stream.empty();
            }
        }).findFirst().orElseThrow(() -> {
            if (ex.get() != null) {
                return (IllegalStateException)ex.get();
            }
            return new IllegalStateException("No default McpJsonMapper implementation found");
        });
    }

    private static void addException(AtomicReference<IllegalStateException> ref, Exception toAdd) {
        ref.updateAndGet(existing -> {
            if (existing == null) {
                return new IllegalStateException("Failed to initialize default McpJsonMapper", toAdd);
            }
            existing.addSuppressed(toAdd);
            return existing;
        });
    }
}

