/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.xds.PriorityLoadBalancer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Internal
public final class PriorityLoadBalancerProvider
extends LoadBalancerProvider {
    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "priority_experimental";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new PriorityLoadBalancer(helper);
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription(this.getPolicyName() + " cannot be used from service config"));
    }

    static final class PriorityLbConfig {
        final Map<String, PriorityChildConfig> childConfigs;
        final List<String> priorities;

        PriorityLbConfig(Map<String, PriorityChildConfig> childConfigs, List<String> priorities) {
            this.childConfigs = Collections.unmodifiableMap((Map)Preconditions.checkNotNull(childConfigs, (Object)"childConfigs"));
            this.priorities = Collections.unmodifiableList((List)Preconditions.checkNotNull(priorities, (Object)"priorities"));
            Preconditions.checkArgument((!priorities.isEmpty() ? 1 : 0) != 0, (Object)"priority list is empty");
            Preconditions.checkArgument((boolean)childConfigs.keySet().containsAll(priorities), (Object)"missing child config for at lease one of the priorities");
            Preconditions.checkArgument((priorities.size() == new HashSet<String>(priorities).size() ? 1 : 0) != 0, (Object)"duplicate names in priorities");
            Preconditions.checkArgument((priorities.size() == childConfigs.keySet().size() ? 1 : 0) != 0, (Object)"some names in childConfigs are not referenced by priorities");
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("childConfigs", this.childConfigs).add("priorities", this.priorities).toString();
        }

        static final class PriorityChildConfig {
            final Object childConfig;
            final boolean ignoreReresolution;

            PriorityChildConfig(Object childConfig, boolean ignoreReresolution) {
                this.childConfig = Preconditions.checkNotNull((Object)childConfig, (Object)"childConfig");
                this.ignoreReresolution = ignoreReresolution;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("childConfig", this.childConfig).add("ignoreReresolution", this.ignoreReresolution).toString();
            }
        }
    }
}

