/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.SdkChecksum;
import software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding.ChunkExtensionProvider;
import software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding.ChunkedEncodedPayload;
import software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding.ChunkedEncodedPublisher;
import software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding.TrailerProvider;
import software.amazon.awssdk.http.auth.aws.internal.signer.io.UnbufferedChecksumSubscriber;

@SdkInternalApi
public class AsyncChunkEncodedPayload
implements ChunkedEncodedPayload {
    private final ChunkedEncodedPublisher.Builder publisherBuilder;

    public AsyncChunkEncodedPayload(ChunkedEncodedPublisher.Builder publisherBuilder) {
        this.publisherBuilder = publisherBuilder;
    }

    @Override
    public void addTrailer(TrailerProvider trailerProvider) {
        this.publisherBuilder.addTrailer(trailerProvider);
    }

    @Override
    public List<TrailerProvider> trailers() {
        return this.publisherBuilder.trailers();
    }

    @Override
    public void addExtension(ChunkExtensionProvider chunkExtensionProvider) {
        this.publisherBuilder.addExtension(chunkExtensionProvider);
    }

    @Override
    public void checksumPayload(SdkChecksum checksum) {
        Publisher<ByteBuffer> checksumPayload = this.computeChecksum(this.publisherBuilder.publisher(), checksum);
        this.publisherBuilder.publisher(checksumPayload);
    }

    @Override
    public void decodedContentLength(long contentLength) {
        this.publisherBuilder.contentLength(contentLength);
    }

    private Publisher<ByteBuffer> computeChecksum(Publisher<ByteBuffer> publisher, SdkChecksum checksum) {
        return subscriber -> publisher.subscribe((Subscriber)new UnbufferedChecksumSubscriber(Collections.singletonList(checksum), (Subscriber<? super ByteBuffer>)subscriber));
    }
}

