/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import java.util.Optional;

public enum SpecificationVersion {
    DRAFT_4(4, "http://json-schema.org/draft-04/schema#"),
    DRAFT_6(6, "http://json-schema.org/draft-06/schema#"),
    DRAFT_7(7, "http://json-schema.org/draft-07/schema#"),
    DRAFT_2019_09(8, "https://json-schema.org/draft/2019-09/schema"),
    DRAFT_2020_12(9, "https://json-schema.org/draft/2020-12/schema");

    private final int order;
    private final String dialectId;

    private SpecificationVersion(int order, String dialectId) {
        this.order = order;
        this.dialectId = dialectId;
    }

    public String getDialectId() {
        return this.dialectId;
    }

    public int getOrder() {
        return this.order;
    }

    public static Optional<SpecificationVersion> fromDialectId(String dialectId) {
        for (SpecificationVersion version : SpecificationVersion.values()) {
            if (!version.dialectId.equals(dialectId)) continue;
            return Optional.of(version);
        }
        return Optional.empty();
    }
}

