# Contribute to CDI

Want to contribute to the Container Device Interface Project? Awesome!
We welcome contributions. In addition to signing your work as described in
the section below we ask that the following guidelines be considered when
opening, reviewing, and merging pull requests.

* No one should merge their own code or code from their own organization
* Reviewers should include people from an organization that is not your own
* If no changes have been requested by other reviewers the (last) reviewer
merges the pull request on approval
* The CNCF [#tag-runtime](https://cloud-native.slack.com/archives/CPBE97SMU)
Slack channel should be used for discussion

## Community Meetings

We have regular community meetings in place to discuss CDI-related topics.
The current cadence of the meetings is bi-weekly. You can find the meeting
details in the [CNCF Community Meetings Calendar](https://www.cncf.io/calendar)
by looking for `CNCF TAG Runtime Container Device Interface (COD) Working Group`.
The calendar entry has an up-to-date link to our meeting agenda. The agenda has
a summary of past meeting topics and discussions and it can be freely edited by
anyone to propose topics for upcoming meetings.

You can [search the calendar for our community meetings](https://tockify.com/cncf.public.events/monthly?search=Container%20Device%20Interface).

## Sign your work

The sign-off is a simple line at the end of the explanation for the patch. Your
signature certifies that you wrote the patch or otherwise have the right to pass
it on as an open-source patch. The rules are pretty simple: if you can certify
the below (from [developercertificate.org](http://developercertificate.org/)):

```
Developer Certificate of Origin
Version 1.1

Copyright (C) 2004, 2006 The Linux Foundation and its contributors.
1 Letterman Drive
Suite D4700
San Francisco, CA, 94129

Everyone is permitted to copy and distribute verbatim copies of this
license document, but changing it is not allowed.

Developer's Certificate of Origin 1.1

By making a contribution to this project, I certify that:

(a) The contribution was created in whole or in part by me and I
    have the right to submit it under the open source license
    indicated in the file; or

(b) The contribution is based upon previous work that, to the best
    of my knowledge, is covered under an appropriate open source
    license and I have the right under that license to submit that
    work with modifications, whether created in whole or in part
    by me, under the same open source license (unless I am
    permitted to submit under a different license), as indicated
    in the file; or

(c) The contribution was provided directly to me by some other
    person who certified (a), (b) or (c) and I have not modified
    it.

(d) I understand and agree that this project and the contribution
    are public and that a record of the contribution (including all
    personal information I submit with it, including my sign-off) is
    maintained indefinitely and may be redistributed consistent with
    this project or the open source license(s) involved.
```

Then you just add a line to every git commit message:

    Signed-off-by: Joe Smith <joe.smith@email.com>

Use your real name (sorry, no pseudonyms or anonymous contributions.)

If you set your `user.name` and `user.email` in your git config, you can
sign your commit automatically with `git commit -s`.
