// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/actions/sdk/v2/conversation/prompt/content/image.proto

package conversation

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible image display options for affecting the presentation of the image.
// This should be used for when the image's aspect ratio does not match the
// image container's aspect ratio.
type Image_ImageFill int32

const (
	// Unspecified image fill.
	Image_UNSPECIFIED Image_ImageFill = 0
	// Fill the gaps between the image and the image container with gray bars.
	Image_GRAY Image_ImageFill = 1
	// Fill the gaps between the image and the image container with white bars.
	Image_WHITE Image_ImageFill = 2
	// Image is scaled such that the image width and height match or exceed the
	// container dimensions. This may crop the top and bottom of the image if
	// the scaled image height is greater than the container height, or crop the
	// left and right of the image if the scaled image width is greater than the
	// container width. This is similar to "Zoom Mode" on a widescreen TV when
	// playing a 4:3 video.
	Image_CROPPED Image_ImageFill = 3
)

// Enum value maps for Image_ImageFill.
var (
	Image_ImageFill_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "GRAY",
		2: "WHITE",
		3: "CROPPED",
	}
	Image_ImageFill_value = map[string]int32{
		"UNSPECIFIED": 0,
		"GRAY":        1,
		"WHITE":       2,
		"CROPPED":     3,
	}
)

func (x Image_ImageFill) Enum() *Image_ImageFill {
	p := new(Image_ImageFill)
	*p = x
	return p
}

func (x Image_ImageFill) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Image_ImageFill) Descriptor() protoreflect.EnumDescriptor {
	return file_google_actions_sdk_v2_conversation_prompt_content_image_proto_enumTypes[0].Descriptor()
}

func (Image_ImageFill) Type() protoreflect.EnumType {
	return &file_google_actions_sdk_v2_conversation_prompt_content_image_proto_enumTypes[0]
}

func (x Image_ImageFill) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Image_ImageFill.Descriptor instead.
func (Image_ImageFill) EnumDescriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_conversation_prompt_content_image_proto_rawDescGZIP(), []int{0, 0}
}

// An image displayed in the card.
type Image struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source url of the image. Images can be JPG, PNG and GIF (animated and
	// non-animated). For example,`https://www.agentx.com/logo.png`. Required.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// A text description of the image to be used for accessibility, e.g. screen
	// readers.
	// Required.
	Alt string `protobuf:"bytes,2,opt,name=alt,proto3" json:"alt,omitempty"`
	// The height of the image in pixels.
	// Optional.
	Height int32 `protobuf:"varint,3,opt,name=height,proto3" json:"height,omitempty"`
	// The width of the image in pixels.
	// Optional.
	Width int32 `protobuf:"varint,4,opt,name=width,proto3" json:"width,omitempty"`
}

func (x *Image) Reset() {
	*x = Image{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_conversation_prompt_content_image_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Image) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Image) ProtoMessage() {}

func (x *Image) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_conversation_prompt_content_image_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Image.ProtoReflect.Descriptor instead.
func (*Image) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_conversation_prompt_content_image_proto_rawDescGZIP(), []int{0}
}

func (x *Image) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Image) GetAlt() string {
	if x != nil {
		return x.Alt
	}
	return ""
}

func (x *Image) GetHeight() int32 {
	if x != nil {
		return x.Height
	}
	return 0
}

func (x *Image) GetWidth() int32 {
	if x != nil {
		return x.Width
	}
	return 0
}

var File_google_actions_sdk_v2_conversation_prompt_content_image_proto protoreflect.FileDescriptor

var file_google_actions_sdk_v2_conversation_prompt_content_image_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x2f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x99, 0x01, 0x0a, 0x05, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x10, 0x0a,
	0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12,
	0x10, 0x0a, 0x03, 0x61, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x61, 0x6c,
	0x74, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x77, 0x69, 0x64,
	0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x22,
	0x3e, 0x0a, 0x09, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x46, 0x69, 0x6c, 0x6c, 0x12, 0x0f, 0x0a, 0x0b,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x47, 0x52, 0x41, 0x59, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x57, 0x48, 0x49, 0x54, 0x45,
	0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x52, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x03, 0x42,
	0x86, 0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0a, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3b, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_actions_sdk_v2_conversation_prompt_content_image_proto_rawDescOnce sync.Once
	file_google_actions_sdk_v2_conversation_prompt_content_image_proto_rawDescData = file_google_actions_sdk_v2_conversation_prompt_content_image_proto_rawDesc
)

func file_google_actions_sdk_v2_conversation_prompt_content_image_proto_rawDescGZIP() []byte {
	file_google_actions_sdk_v2_conversation_prompt_content_image_proto_rawDescOnce.Do(func() {
		file_google_actions_sdk_v2_conversation_prompt_content_image_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_sdk_v2_conversation_prompt_content_image_proto_rawDescData)
	})
	return file_google_actions_sdk_v2_conversation_prompt_content_image_proto_rawDescData
}

var file_google_actions_sdk_v2_conversation_prompt_content_image_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_actions_sdk_v2_conversation_prompt_content_image_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_actions_sdk_v2_conversation_prompt_content_image_proto_goTypes = []interface{}{
	(Image_ImageFill)(0), // 0: google.actions.sdk.v2.conversation.Image.ImageFill
	(*Image)(nil),        // 1: google.actions.sdk.v2.conversation.Image
}
var file_google_actions_sdk_v2_conversation_prompt_content_image_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_google_actions_sdk_v2_conversation_prompt_content_image_proto_init() }
func file_google_actions_sdk_v2_conversation_prompt_content_image_proto_init() {
	if File_google_actions_sdk_v2_conversation_prompt_content_image_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_actions_sdk_v2_conversation_prompt_content_image_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Image); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_sdk_v2_conversation_prompt_content_image_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_actions_sdk_v2_conversation_prompt_content_image_proto_goTypes,
		DependencyIndexes: file_google_actions_sdk_v2_conversation_prompt_content_image_proto_depIdxs,
		EnumInfos:         file_google_actions_sdk_v2_conversation_prompt_content_image_proto_enumTypes,
		MessageInfos:      file_google_actions_sdk_v2_conversation_prompt_content_image_proto_msgTypes,
	}.Build()
	File_google_actions_sdk_v2_conversation_prompt_content_image_proto = out.File
	file_google_actions_sdk_v2_conversation_prompt_content_image_proto_rawDesc = nil
	file_google_actions_sdk_v2_conversation_prompt_content_image_proto_goTypes = nil
	file_google_actions_sdk_v2_conversation_prompt_content_image_proto_depIdxs = nil
}
