// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func TestCopyOrigSummaryDataPointSlice(t *testing.T) {
	src := []*otlpmetrics.SummaryDataPoint{}
	dest := []*otlpmetrics.SummaryDataPoint{}
	// Test CopyTo empty
	dest = CopyOrigSummaryDataPointSlice(dest, src)
	assert.Equal(t, []*otlpmetrics.SummaryDataPoint{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestSummaryDataPointSlice()
	dest = CopyOrigSummaryDataPointSlice(dest, src)
	assert.Equal(t, GenerateOrigTestSummaryDataPointSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigSummaryDataPointSlice(dest, src)
	assert.Equal(t, GenerateOrigTestSummaryDataPointSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigSummaryDataPointSlice(dest, []*otlpmetrics.SummaryDataPoint{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigSummaryDataPointSlice(dest, src)
	assert.Equal(t, GenerateOrigTestSummaryDataPointSlice(), dest)
}
