// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pcommon

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
)

func TestSlice(t *testing.T) {
	es := NewSlice()
	assert.Equal(t, 0, es.Len())
	es = newSlice(&[]otlpcommon.AnyValue{}, internal.NewState())
	assert.Equal(t, 0, es.Len())

	emptyVal := NewValueEmpty()
	testVal := Value(internal.NewValue(internal.GenTestOrigAnyValue(), internal.NewState()))
	for i := 0; i < 7; i++ {
		es.AppendEmpty()
		assert.Equal(t, emptyVal, es.At(i))
		(*es.getOrig())[i] = *internal.GenTestOrigAnyValue()
		assert.Equal(t, testVal, es.At(i))
	}
	assert.Equal(t, 7, es.Len())
}

func TestSliceReadOnly(t *testing.T) {
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	es := newSlice(&[]otlpcommon.AnyValue{}, sharedState)
	assert.Equal(t, 0, es.Len())
	assert.Panics(t, func() { es.AppendEmpty() })
	assert.Panics(t, func() { es.EnsureCapacity(2) })
	es2 := NewSlice()
	es.CopyTo(es2)
	assert.Panics(t, func() { es2.CopyTo(es) })
	assert.Panics(t, func() { es.MoveAndAppendTo(es2) })
	assert.Panics(t, func() { es2.MoveAndAppendTo(es) })
}

func TestSlice_CopyTo(t *testing.T) {
	dest := NewSlice()
	src := generateTestSlice()
	src.CopyTo(dest)
	assert.Equal(t, generateTestSlice(), dest)
	dest.CopyTo(dest)
	assert.Equal(t, generateTestSlice(), dest)
}

func TestSlice_EnsureCapacity(t *testing.T) {
	es := generateTestSlice()

	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	assert.Equal(t, es.Len(), cap(*es.getOrig()))
	assert.Equal(t, generateTestSlice(), es)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	es.EnsureCapacity(ensureLargeLen)
	assert.Less(t, generateTestSlice().Len(), ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.getOrig()))
	assert.Equal(t, generateTestSlice(), es)
}

func TestSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestSlice()
	dest := NewSlice()
	src := generateTestSlice()
	src.MoveAndAppendTo(dest)
	assert.Equal(t, generateTestSlice(), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.Equal(t, generateTestSlice(), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestSlice().MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}

	dest.MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewSlice()
	emptySlice.RemoveIf(func(el Value) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestSlice()
	pos := 0
	filtered.RemoveIf(func(el Value) bool {
		pos++
		return pos%2 == 1
	})
	assert.Equal(t, 2, filtered.Len())
}

func TestSlice_RemoveIfAll(t *testing.T) {
	got := generateTestSlice()
	got.RemoveIf(func(el Value) bool {
		return true
	})
	assert.Equal(t, 0, got.Len())
}

func TestSliceAll(t *testing.T) {
	ms := generateTestSlice()
	assert.NotEmpty(t, ms.Len())

	var c int
	for i, v := range ms.All() {
		assert.Equal(t, ms.At(i), v, "element should match")
		c++
	}
	assert.Equal(t, ms.Len(), c, "All elements should have been visited")
}

func generateTestSlice() Slice {
	ms := NewSlice()
	*ms.getOrig() = internal.GenerateOrigTestAnyValueSlice()
	return ms
}
