// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestExponentialHistogramDataPoint_MoveTo(t *testing.T) {
	ms := generateTestExponentialHistogramDataPoint()
	dest := NewExponentialHistogramDataPoint()
	ms.MoveTo(dest)
	assert.Equal(t, NewExponentialHistogramDataPoint(), ms)
	assert.Equal(t, generateTestExponentialHistogramDataPoint(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestExponentialHistogramDataPoint(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		ms.MoveTo(newExponentialHistogramDataPoint(internal.NewOrigExponentialHistogramDataPoint(), sharedState))
	})
	assert.Panics(t, func() {
		newExponentialHistogramDataPoint(internal.NewOrigExponentialHistogramDataPoint(), sharedState).MoveTo(dest)
	})
}

func TestExponentialHistogramDataPoint_CopyTo(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	orig := NewExponentialHistogramDataPoint()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestExponentialHistogramDataPoint()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		ms.CopyTo(newExponentialHistogramDataPoint(internal.NewOrigExponentialHistogramDataPoint(), sharedState))
	})
}

func TestExponentialHistogramDataPoint_Attributes(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, pcommon.NewMap(), ms.Attributes())
	ms.orig.Attributes = internal.GenerateOrigTestKeyValueSlice()
	assert.Equal(t, pcommon.Map(internal.GenerateTestMap()), ms.Attributes())
}

func TestExponentialHistogramDataPoint_StartTimestamp(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, pcommon.Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := pcommon.Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.Equal(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestExponentialHistogramDataPoint_Timestamp(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, pcommon.Timestamp(0), ms.Timestamp())
	testValTimestamp := pcommon.Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.Equal(t, testValTimestamp, ms.Timestamp())
}

func TestExponentialHistogramDataPoint_Count(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, uint64(0), ms.Count())
	ms.SetCount(uint64(13))
	assert.Equal(t, uint64(13), ms.Count())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		newExponentialHistogramDataPoint(&otlpmetrics.ExponentialHistogramDataPoint{}, sharedState).SetCount(uint64(13))
	})
}

func TestExponentialHistogramDataPoint_Sum(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.InDelta(t, float64(0), ms.Sum(), 0.01)
	ms.SetSum(float64(3.1415926))
	assert.True(t, ms.HasSum())
	assert.InDelta(t, float64(3.1415926), ms.Sum(), 0.01)
	ms.RemoveSum()
	assert.False(t, ms.HasSum())
	dest := NewExponentialHistogramDataPoint()
	dest.SetSum(float64(3.1415926))
	ms.CopyTo(dest)
	assert.False(t, dest.HasSum())
}

func TestExponentialHistogramDataPoint_Scale(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, int32(0), ms.Scale())
	ms.SetScale(int32(13))
	assert.Equal(t, int32(13), ms.Scale())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		newExponentialHistogramDataPoint(&otlpmetrics.ExponentialHistogramDataPoint{}, sharedState).SetScale(int32(13))
	})
}

func TestExponentialHistogramDataPoint_ZeroCount(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, uint64(0), ms.ZeroCount())
	ms.SetZeroCount(uint64(13))
	assert.Equal(t, uint64(13), ms.ZeroCount())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		newExponentialHistogramDataPoint(&otlpmetrics.ExponentialHistogramDataPoint{}, sharedState).SetZeroCount(uint64(13))
	})
}

func TestExponentialHistogramDataPoint_Positive(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, NewExponentialHistogramDataPointBuckets(), ms.Positive())
	ms.orig.Positive = *internal.GenTestOrigExponentialHistogramDataPoint_Buckets()
	assert.Equal(t, generateTestExponentialHistogramDataPointBuckets(), ms.Positive())
}

func TestExponentialHistogramDataPoint_Negative(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, NewExponentialHistogramDataPointBuckets(), ms.Negative())
	ms.orig.Negative = *internal.GenTestOrigExponentialHistogramDataPoint_Buckets()
	assert.Equal(t, generateTestExponentialHistogramDataPointBuckets(), ms.Negative())
}

func TestExponentialHistogramDataPoint_Flags(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, DataPointFlags(0), ms.Flags())
	testValFlags := DataPointFlags(1)
	ms.SetFlags(testValFlags)
	assert.Equal(t, testValFlags, ms.Flags())
}

func TestExponentialHistogramDataPoint_Exemplars(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, NewExemplarSlice(), ms.Exemplars())
	ms.orig.Exemplars = internal.GenerateOrigTestExemplarSlice()
	assert.Equal(t, generateTestExemplarSlice(), ms.Exemplars())
}

func TestExponentialHistogramDataPoint_Min(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.InDelta(t, float64(0), ms.Min(), 0.01)
	ms.SetMin(float64(3.1415926))
	assert.True(t, ms.HasMin())
	assert.InDelta(t, float64(3.1415926), ms.Min(), 0.01)
	ms.RemoveMin()
	assert.False(t, ms.HasMin())
	dest := NewExponentialHistogramDataPoint()
	dest.SetMin(float64(3.1415926))
	ms.CopyTo(dest)
	assert.False(t, dest.HasMin())
}

func TestExponentialHistogramDataPoint_Max(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.InDelta(t, float64(0), ms.Max(), 0.01)
	ms.SetMax(float64(3.1415926))
	assert.True(t, ms.HasMax())
	assert.InDelta(t, float64(3.1415926), ms.Max(), 0.01)
	ms.RemoveMax()
	assert.False(t, ms.HasMax())
	dest := NewExponentialHistogramDataPoint()
	dest.SetMax(float64(3.1415926))
	ms.CopyTo(dest)
	assert.False(t, dest.HasMax())
}

func TestExponentialHistogramDataPoint_ZeroThreshold(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.InDelta(t, float64(0), ms.ZeroThreshold(), 0.01)
	ms.SetZeroThreshold(float64(3.1415926))
	assert.InDelta(t, float64(3.1415926), ms.ZeroThreshold(), 0.01)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		newExponentialHistogramDataPoint(&otlpmetrics.ExponentialHistogramDataPoint{}, sharedState).SetZeroThreshold(float64(3.1415926))
	})
}

func generateTestExponentialHistogramDataPoint() ExponentialHistogramDataPoint {
	ms := newExponentialHistogramDataPoint(internal.GenTestOrigExponentialHistogramDataPoint(), internal.NewState())
	return ms
}
