/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.completion;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.aesh.readline.Buffer;
import org.aesh.readline.InputProcessor;
import org.aesh.readline.action.mappings.ActionMapper;
import org.aesh.readline.completion.CompleteOperation;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.aesh.readline.util.Parser;
import org.aesh.utils.Config;

public abstract class CompletionHandler<C extends CompleteOperation> {
    private CompletionStatus status = CompletionStatus.COMPLETE;
    private int displayCompletionSize = 100;
    private final List<Completion> completionList = new ArrayList<Completion>();
    private Function<Buffer, C> aliasHandler;

    public void addCompletion(Completion completion) {
        this.completionList.add(completion);
    }

    public void removeCompletion(Completion completion) {
        this.completionList.remove(completion);
    }

    public void clear() {
        this.completionList.clear();
    }

    public CompletionStatus completionStatus() {
        return this.status;
    }

    public void setCompletionStatus(CompletionStatus status) {
        this.status = status;
    }

    public void setAskCompletionSize(int size) {
        this.displayCompletionSize = size;
    }

    public int getAskCompletionSize() {
        return this.displayCompletionSize;
    }

    public void setAliasHandler(Function<Buffer, C> aliasHandler) {
        this.aliasHandler = aliasHandler;
    }

    public void addCompletions(List<Completion> completions) {
        if (completions != null && completions.size() > 0) {
            this.completionList.addAll(completions);
        }
    }

    public abstract C createCompleteOperation(String var1, int var2);

    public void complete(InputProcessor inputProcessor) {
        if (this.completionList.size() == 0) {
            return;
        }
        Buffer buffer = inputProcessor.buffer().buffer();
        if (this.completionList.size() < 1) {
            return;
        }
        List<C> possibleCompletions = this.createCompletionList(buffer);
        if (possibleCompletions.size() != 0) {
            if (possibleCompletions.size() == 1 && ((CompleteOperation)possibleCompletions.get(0)).getCompletionCandidates().size() == 1) {
                this.displayCompletion(((CompleteOperation)possibleCompletions.get(0)).getFormattedCompletionCandidatesTerminalString().get(0), buffer, inputProcessor, ((CompleteOperation)possibleCompletions.get(0)).hasAppendSeparator(), ((CompleteOperation)possibleCompletions.get(0)).getSeparator());
            } else {
                this.processMultipleCompletions(possibleCompletions, buffer, inputProcessor);
            }
        }
    }

    private List<C> createCompletionList(Buffer buffer) {
        ArrayList<CompleteOperation> possibleCompletions = new ArrayList<CompleteOperation>();
        for (int i = 0; i < this.completionList.size(); ++i) {
            CompleteOperation co = this.aliasHandler == null ? this.createCompleteOperation(buffer.asString(), buffer.multiCursor()) : (CompleteOperation)this.aliasHandler.apply(buffer);
            this.completionList.get(i).complete(co);
            if (co.getCompletionCandidates() == null || co.getCompletionCandidates().size() <= 0) continue;
            possibleCompletions.add(co);
        }
        return possibleCompletions;
    }

    private void processMultipleCompletions(List<C> possibleCompletions, Buffer buffer, InputProcessor inputProcessor) {
        String startsWith = "";
        if (!((CompleteOperation)possibleCompletions.get(0)).isIgnoreStartsWith()) {
            startsWith = Parser.findStartsWithOperation(possibleCompletions);
        }
        if (startsWith.length() > 0) {
            if (startsWith.contains(" ") && !((CompleteOperation)possibleCompletions.get(0)).doIgnoreNonEscapedSpace()) {
                this.displayCompletion(new TerminalString(Parser.switchSpacesToEscapedSpacesInWord(startsWith), true), buffer, inputProcessor, false, ((CompleteOperation)possibleCompletions.get(0)).getSeparator());
            } else {
                this.displayCompletion(new TerminalString(startsWith, true), buffer, inputProcessor, false, ((CompleteOperation)possibleCompletions.get(0)).getSeparator());
            }
        } else {
            ArrayList<TerminalString> completions = new ArrayList<TerminalString>();
            for (int i = 0; i < possibleCompletions.size(); ++i) {
                completions.addAll(((CompleteOperation)possibleCompletions.get(i)).getCompletionCandidates());
            }
            if (completions.size() > 100) {
                if (this.status == CompletionStatus.ASKING_FOR_COMPLETIONS) {
                    this.displayCompletions(completions, buffer, inputProcessor);
                    this.status = CompletionStatus.COMPLETE;
                } else {
                    this.status = CompletionStatus.ASKING_FOR_COMPLETIONS;
                    inputProcessor.buffer().writeOut(Config.CR);
                    inputProcessor.buffer().writeOut("Display all " + completions.size() + " possibilities? (y or n)");
                }
            } else {
                this.displayCompletions(completions, buffer, inputProcessor);
            }
        }
    }

    private void displayCompletion(TerminalString completion, Buffer buffer, InputProcessor inputProcessor, boolean appendSpace, char separator) {
        if (completion.getCharacters().startsWith(buffer.asString())) {
            ActionMapper.mapToAction("backward-kill-word").accept(inputProcessor);
            inputProcessor.buffer().writeString(completion.toString());
        } else {
            inputProcessor.buffer().writeString(completion.toString());
        }
        if (appendSpace) {
            inputProcessor.buffer().writeChar(separator);
        }
    }

    private void displayCompletions(List<TerminalString> completions, Buffer buffer, InputProcessor inputProcessor) {
        completions.sort(new CaseInsensitiveComparator());
        if (inputProcessor.buffer().buffer().length() > inputProcessor.buffer().size().getWidth()) {
            int numRows = inputProcessor.buffer().buffer().length() / inputProcessor.buffer().size().getWidth();
            for (int cursorRow = inputProcessor.buffer().buffer().cursor() / inputProcessor.buffer().size().getWidth(); cursorRow < numRows; ++cursorRow) {
                inputProcessor.buffer().writeOut(new int[]{27, 91, 66});
            }
        }
        inputProcessor.buffer().writeOut(Config.CR);
        inputProcessor.buffer().writeOut(Parser.formatDisplayListTerminalString(completions, inputProcessor.buffer().size().getHeight(), inputProcessor.buffer().size().getWidth()));
        inputProcessor.buffer().drawLineForceDisplay();
    }

    private static class CaseInsensitiveComparator
    implements Comparator<TerminalString> {
        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(TerminalString s1, TerminalString s2) {
            int n1 = s1.getCharacters().length();
            int n2 = s2.getCharacters().length();
            int min = Math.min(n1, n2);
            for (int i = 0; i < min; ++i) {
                char c2;
                char c1 = s1.getCharacters().charAt(i);
                if (c1 == (c2 = s2.getCharacters().charAt(i)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                return c1 - c2;
            }
            return n1 - n2;
        }
    }

    public static enum CompletionStatus {
        ASKING_FOR_COMPLETIONS,
        COMPLETE;

    }
}

