---
title: glab cluster agent token-cache
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

Manage cached GitLab Agent tokens.

## Synopsis

Manage cached GitLab Agent tokens created by 'glab cluster agent get-token'.

This command group allows you to list and clear tokens that are cached locally
in the keyring and filesystem cache.

## Cache Storage

The GitLab CLI caches agent tokens in two locations:

1. Keyring - Uses the system keyring (Windows Credential Manager, macOS Keychain, Linux Secret Service)
2. Filesystem - Stores tokens in the user's cache directory as encrypted files

The cache improves performance by avoiding the need to create new tokens for each kubectl operation when using 'glab cluster agent update-kubeconfig'.

## Cache Key Format

Cached tokens are stored using a key format that includes:

- Base64-encoded GitLab instance URL
- Agent ID

This ensures tokens are properly isolated by GitLab instance and agent.

## Options inherited from parent commands

```plaintext
  -h, --help              Show help for this command.
  -R, --repo OWNER/REPO   Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
```

## Subcommands

- [`clear`](clear.md)
- [`list`](list.md)
