// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/storage/v2/storage.proto

package storagepb

import (
	context "context"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Storage_DeleteBucket_FullMethodName              = "/google.storage.v2.Storage/DeleteBucket"
	Storage_GetBucket_FullMethodName                 = "/google.storage.v2.Storage/GetBucket"
	Storage_CreateBucket_FullMethodName              = "/google.storage.v2.Storage/CreateBucket"
	Storage_ListBuckets_FullMethodName               = "/google.storage.v2.Storage/ListBuckets"
	Storage_LockBucketRetentionPolicy_FullMethodName = "/google.storage.v2.Storage/LockBucketRetentionPolicy"
	Storage_GetIamPolicy_FullMethodName              = "/google.storage.v2.Storage/GetIamPolicy"
	Storage_SetIamPolicy_FullMethodName              = "/google.storage.v2.Storage/SetIamPolicy"
	Storage_TestIamPermissions_FullMethodName        = "/google.storage.v2.Storage/TestIamPermissions"
	Storage_UpdateBucket_FullMethodName              = "/google.storage.v2.Storage/UpdateBucket"
	Storage_ComposeObject_FullMethodName             = "/google.storage.v2.Storage/ComposeObject"
	Storage_DeleteObject_FullMethodName              = "/google.storage.v2.Storage/DeleteObject"
	Storage_RestoreObject_FullMethodName             = "/google.storage.v2.Storage/RestoreObject"
	Storage_CancelResumableWrite_FullMethodName      = "/google.storage.v2.Storage/CancelResumableWrite"
	Storage_GetObject_FullMethodName                 = "/google.storage.v2.Storage/GetObject"
	Storage_ReadObject_FullMethodName                = "/google.storage.v2.Storage/ReadObject"
	Storage_BidiReadObject_FullMethodName            = "/google.storage.v2.Storage/BidiReadObject"
	Storage_UpdateObject_FullMethodName              = "/google.storage.v2.Storage/UpdateObject"
	Storage_WriteObject_FullMethodName               = "/google.storage.v2.Storage/WriteObject"
	Storage_BidiWriteObject_FullMethodName           = "/google.storage.v2.Storage/BidiWriteObject"
	Storage_ListObjects_FullMethodName               = "/google.storage.v2.Storage/ListObjects"
	Storage_RewriteObject_FullMethodName             = "/google.storage.v2.Storage/RewriteObject"
	Storage_StartResumableWrite_FullMethodName       = "/google.storage.v2.Storage/StartResumableWrite"
	Storage_QueryWriteStatus_FullMethodName          = "/google.storage.v2.Storage/QueryWriteStatus"
	Storage_MoveObject_FullMethodName                = "/google.storage.v2.Storage/MoveObject"
)

// StorageClient is the client API for Storage service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type StorageClient interface {
	// Permanently deletes an empty bucket.
	// The request fails if there are any live or
	// noncurrent objects in the bucket, but the request succeeds if the
	// bucket only contains soft-deleted objects or incomplete uploads, such
	// as ongoing XML API multipart uploads. Does not permanently delete
	// soft-deleted objects.
	//
	// When this API is used to delete a bucket containing an object that has a
	// soft delete policy
	// enabled, the object becomes soft deleted, and the
	// `softDeleteTime` and `hardDeleteTime` properties are set on the
	// object.
	//
	// Objects and multipart uploads that were in the bucket at the time of
	// deletion are also retained for the specified retention duration. When
	// a soft-deleted bucket reaches the end of its retention duration, it
	// is permanently deleted. The `hardDeleteTime` of the bucket always
	// equals
	// or exceeds the expiration time of the last soft-deleted object in the
	// bucket.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.buckets.delete` IAM permission on the bucket.
	DeleteBucket(ctx context.Context, in *DeleteBucketRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns metadata for the specified bucket.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.buckets.get`
	// IAM permission on
	// the bucket. Additionally, to return specific bucket metadata, the
	// authenticated user must have the following permissions:
	//
	// - To return the IAM policies: `storage.buckets.getIamPolicy`
	// - To return the bucket IP filtering rules: `storage.buckets.getIpFilter`
	GetBucket(ctx context.Context, in *GetBucketRequest, opts ...grpc.CallOption) (*Bucket, error)
	// Creates a new bucket.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.buckets.create` IAM permission on the bucket.
	// Additionally, to enable specific bucket features, the authenticated user
	// must have the following permissions:
	//
	// - To enable object retention using the `enableObjectRetention` query
	// parameter: `storage.buckets.enableObjectRetention`
	// - To set the bucket IP filtering rules: `storage.buckets.setIpFilter`
	CreateBucket(ctx context.Context, in *CreateBucketRequest, opts ...grpc.CallOption) (*Bucket, error)
	// Retrieves a list of buckets for a given project, ordered
	// lexicographically by name.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.buckets.list` IAM permission on the bucket.
	// Additionally, to enable specific bucket features, the authenticated
	// user must have the following permissions:
	//
	// - To list the IAM policies: `storage.buckets.getIamPolicy`
	// - To list the bucket IP filtering rules: `storage.buckets.getIpFilter`
	ListBuckets(ctx context.Context, in *ListBucketsRequest, opts ...grpc.CallOption) (*ListBucketsResponse, error)
	// Permanently locks the retention
	// policy that is
	// currently applied to the specified bucket.
	//
	// Caution: Locking a bucket is an
	// irreversible action. Once you lock a bucket:
	//
	// - You cannot remove the retention policy from the bucket.
	// - You cannot decrease the retention period for the policy.
	//
	// Once locked, you must delete the entire bucket in order to remove the
	// bucket's retention policy. However, before you can delete the bucket, you
	// must delete all the objects in the bucket, which is only
	// possible if all the objects have reached the retention period set by the
	// retention policy.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.buckets.update` IAM permission on the bucket.
	LockBucketRetentionPolicy(ctx context.Context, in *LockBucketRetentionPolicyRequest, opts ...grpc.CallOption) (*Bucket, error)
	// Gets the IAM policy for a specified bucket or managed folder.
	// The `resource` field in the request should be
	// `projects/_/buckets/{bucket}` for a bucket, or
	// `projects/_/buckets/{bucket}/managedFolders/{managedFolder}`
	// for a managed folder.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.buckets.getIamPolicy` on the bucket or
	// `storage.managedFolders.getIamPolicy` IAM permission on the
	// managed folder.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Updates an IAM policy for the specified bucket or managed folder.
	// The `resource` field in the request should be
	// `projects/_/buckets/{bucket}` for a bucket, or
	// `projects/_/buckets/{bucket}/managedFolders/{managedFolder}`
	// for a managed folder.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Tests a set of permissions on the given bucket, object, or managed folder
	// to see which, if any, are held by the caller. The `resource` field in the
	// request should be `projects/_/buckets/{bucket}` for a bucket,
	// `projects/_/buckets/{bucket}/objects/{object}` for an object, or
	// `projects/_/buckets/{bucket}/managedFolders/{managedFolder}`
	// for a managed folder.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Updates a bucket. Changes to the bucket are readable immediately after
	// writing, but configuration changes might take time to propagate. This
	// method supports `patch` semantics.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.buckets.update` IAM permission on the bucket.
	// Additionally, to enable specific bucket features, the authenticated user
	// must have the following permissions:
	//
	// - To set bucket IP filtering rules: `storage.buckets.setIpFilter`
	// - To update public access prevention policies or access control lists
	// (ACLs): `storage.buckets.setIamPolicy`
	UpdateBucket(ctx context.Context, in *UpdateBucketRequest, opts ...grpc.CallOption) (*Bucket, error)
	// Concatenates a list of existing objects into a new object in the same
	// bucket. The existing source objects are unaffected by this operation.
	//
	// **IAM Permissions**:
	//
	// Requires the `storage.objects.create` and `storage.objects.get` IAM
	// permissions to use this method. If the new composite object
	// overwrites an existing object, the authenticated user must also have
	// the `storage.objects.delete` permission. If the request body includes
	// the retention property, the authenticated user must also have the
	// `storage.objects.setRetention` IAM permission.
	ComposeObject(ctx context.Context, in *ComposeObjectRequest, opts ...grpc.CallOption) (*Object, error)
	// Deletes an object and its metadata. Deletions are permanent if versioning
	// is not enabled for the bucket, or if the generation parameter is used, or
	// if soft delete is not
	// enabled for the bucket.
	// When this API is used to delete an object from a bucket that has soft
	// delete policy enabled, the object becomes soft deleted, and the
	// `softDeleteTime` and `hardDeleteTime` properties are set on the object.
	// This API cannot be used to permanently delete soft-deleted objects.
	// Soft-deleted objects are permanently deleted according to their
	// `hardDeleteTime`.
	//
	// You can use the [`RestoreObject`][google.storage.v2.Storage.RestoreObject]
	// API to restore soft-deleted objects until the soft delete retention period
	// has passed.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.objects.delete` IAM permission on the bucket.
	DeleteObject(ctx context.Context, in *DeleteObjectRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Restores a
	// soft-deleted object.
	// When a soft-deleted object is restored, a new copy of that object is
	// created in the same bucket and inherits the same metadata as the
	// soft-deleted object. The inherited metadata is the metadata that existed
	// when the original object became soft deleted, with the following
	// exceptions:
	//
	//   - The `createTime` of the new object is set to the time at which the
	//     soft-deleted object was restored.
	//   - The `softDeleteTime` and `hardDeleteTime` values are cleared.
	//   - A new generation is assigned and the metageneration is reset to 1.
	//   - If the soft-deleted object was in a bucket that had Autoclass enabled,
	//     the new object is
	//     restored to Standard storage.
	//   - The restored object inherits the bucket's default object ACL, unless
	//     `copySourceAcl` is `true`.
	//
	// If a live object using the same name already exists in the bucket and
	// becomes overwritten, the live object becomes a noncurrent object if Object
	// Versioning is enabled on the bucket. If Object Versioning is not enabled,
	// the live object becomes soft deleted.
	//
	// **IAM Permissions**:
	//
	// Requires the following IAM permissions to use this method:
	//
	//   - `storage.objects.restore`
	//   - `storage.objects.create`
	//   - `storage.objects.delete` (only required if overwriting an existing
	//     object)
	//   - `storage.objects.getIamPolicy` (only required if `projection` is `full`
	//     and the relevant bucket
	//     has uniform bucket-level access disabled)
	//   - `storage.objects.setIamPolicy` (only required if `copySourceAcl` is
	//     `true` and the relevant
	//     bucket has uniform bucket-level access disabled)
	RestoreObject(ctx context.Context, in *RestoreObjectRequest, opts ...grpc.CallOption) (*Object, error)
	// Cancels an in-progress resumable upload.
	//
	// Any attempts to write to the resumable upload after cancelling the upload
	// fail.
	//
	// The behavior for any in-progress write operations is not guaranteed;
	// they could either complete before the cancellation or fail if the
	// cancellation completes first.
	CancelResumableWrite(ctx context.Context, in *CancelResumableWriteRequest, opts ...grpc.CallOption) (*CancelResumableWriteResponse, error)
	// Retrieves object metadata.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.objects.get` IAM permission on the bucket.
	// To return object ACLs, the authenticated user must also have
	// the `storage.objects.getIamPolicy` permission.
	GetObject(ctx context.Context, in *GetObjectRequest, opts ...grpc.CallOption) (*Object, error)
	// Retrieves object data.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.objects.get` IAM permission on the bucket.
	ReadObject(ctx context.Context, in *ReadObjectRequest, opts ...grpc.CallOption) (Storage_ReadObjectClient, error)
	// Reads an object's data.
	//
	// This bi-directional API reads data from an object, allowing you to
	// request multiple data ranges within a single stream, even across
	// several messages. If an error occurs with any request, the stream
	// closes with a relevant error code. Since you can have multiple
	// outstanding requests, the error response includes a
	// `BidiReadObjectRangesError` field detailing the specific error for
	// each pending `read_id`.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.objects.get` IAM permission on the bucket.
	BidiReadObject(ctx context.Context, opts ...grpc.CallOption) (Storage_BidiReadObjectClient, error)
	// Updates an object's metadata.
	// Equivalent to JSON API's `storage.objects.patch` method.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.objects.update` IAM permission on the bucket.
	UpdateObject(ctx context.Context, in *UpdateObjectRequest, opts ...grpc.CallOption) (*Object, error)
	// Stores a new object and metadata.
	//
	// An object can be written either in a single message stream or in a
	// resumable sequence of message streams. To write using a single stream,
	// the client should include in the first message of the stream an
	// `WriteObjectSpec` describing the destination bucket, object, and any
	// preconditions. Additionally, the final message must set 'finish_write' to
	// true, or else it is an error.
	//
	// For a resumable write, the client should instead call
	// `StartResumableWrite()`, populating a `WriteObjectSpec` into that request.
	// They should then attach the returned `upload_id` to the first message of
	// each following call to `WriteObject`. If the stream is closed before
	// finishing the upload (either explicitly by the client or due to a network
	// error or an error response from the server), the client should do as
	// follows:
	//
	//   - Check the result Status of the stream, to determine if writing can be
	//     resumed on this stream or must be restarted from scratch (by calling
	//     `StartResumableWrite()`). The resumable errors are `DEADLINE_EXCEEDED`,
	//     `INTERNAL`, and `UNAVAILABLE`. For each case, the client should use
	//     binary exponential backoff before retrying.  Additionally, writes can
	//     be resumed after `RESOURCE_EXHAUSTED` errors, but only after taking
	//     appropriate measures, which might include reducing aggregate send rate
	//     across clients and/or requesting a quota increase for your project.
	//   - If the call to `WriteObject` returns `ABORTED`, that indicates
	//     concurrent attempts to update the resumable write, caused either by
	//     multiple racing clients or by a single client where the previous
	//     request was timed out on the client side but nonetheless reached the
	//     server. In this case the client should take steps to prevent further
	//     concurrent writes. For example, increase the timeouts and stop using
	//     more than one process to perform the upload. Follow the steps below for
	//     resuming the upload.
	//   - For resumable errors, the client should call `QueryWriteStatus()` and
	//     then continue writing from the returned `persisted_size`. This might be
	//     less than the amount of data the client previously sent. Note also that
	//     it is acceptable to send data starting at an offset earlier than the
	//     returned `persisted_size`; in this case, the service skips data at
	//     offsets that were already persisted (without checking that it matches
	//     the previously written data), and write only the data starting from the
	//     persisted offset. Even though the data isn't written, it might still
	//     incur a performance cost over resuming at the correct write offset.
	//     This behavior can make client-side handling simpler in some cases.
	//   - Clients must only send data that is a multiple of 256 KiB per message,
	//     unless the object is being finished with `finish_write` set to `true`.
	//
	// The service does not view the object as complete until the client has
	// sent a `WriteObjectRequest` with `finish_write` set to `true`. Sending any
	// requests on a stream after sending a request with `finish_write` set to
	// `true` causes an error. The client must check the response it
	// receives to determine how much data the service is able to commit and
	// whether the service views the object as complete.
	//
	// Attempting to resume an already finalized object results in an `OK`
	// status, with a `WriteObjectResponse` containing the finalized object's
	// metadata.
	//
	// Alternatively, you can use the `BidiWriteObject` operation to write an
	// object with controls over flushing and the ability to fetch the ability to
	// determine the current persisted size.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.objects.create`
	// IAM permission on
	// the bucket.
	WriteObject(ctx context.Context, opts ...grpc.CallOption) (Storage_WriteObjectClient, error)
	// Stores a new object and metadata.
	//
	// This is similar to the `WriteObject` call with the added support for
	// manual flushing of persisted state, and the ability to determine current
	// persisted size without closing the stream.
	//
	// The client might specify one or both of the `state_lookup` and `flush`
	// fields in each `BidiWriteObjectRequest`. If `flush` is specified, the data
	// written so far is persisted to storage. If `state_lookup` is specified, the
	// service responds with a `BidiWriteObjectResponse` that contains the
	// persisted size. If both `flush` and `state_lookup` are specified, the flush
	// always occurs before a `state_lookup`, so that both might be set in the
	// same request and the returned state is the state of the object
	// post-flush. When the stream is closed, a `BidiWriteObjectResponse`
	// is always sent to the client, regardless of the value of `state_lookup`.
	BidiWriteObject(ctx context.Context, opts ...grpc.CallOption) (Storage_BidiWriteObjectClient, error)
	// Retrieves a list of objects matching the criteria.
	//
	// **IAM Permissions**:
	//
	// The authenticated user requires `storage.objects.list`
	// IAM permission to use this method. To return object ACLs, the
	// authenticated user must also
	// have the `storage.objects.getIamPolicy` permission.
	ListObjects(ctx context.Context, in *ListObjectsRequest, opts ...grpc.CallOption) (*ListObjectsResponse, error)
	// Rewrites a source object to a destination object. Optionally overrides
	// metadata.
	RewriteObject(ctx context.Context, in *RewriteObjectRequest, opts ...grpc.CallOption) (*RewriteResponse, error)
	// Starts a resumable write operation. This
	// method is part of the Resumable
	// upload feature.
	// This allows you to upload large objects in multiple chunks, which is more
	// resilient to network interruptions than a single upload. The validity
	// duration of the write operation, and the consequences of it becoming
	// invalid, are service-dependent.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.objects.create` IAM permission on the bucket.
	StartResumableWrite(ctx context.Context, in *StartResumableWriteRequest, opts ...grpc.CallOption) (*StartResumableWriteResponse, error)
	// Determines the `persisted_size` of an object that is being written. This
	// method is part of the resumable
	// upload feature.
	// The returned value is the size of the object that has been persisted so
	// far. The value can be used as the `write_offset` for the next `Write()`
	// call.
	//
	// If the object does not exist, meaning if it was deleted, or the
	// first `Write()` has not yet reached the service, this method returns the
	// error `NOT_FOUND`.
	//
	// This method is useful for clients that buffer data and need to know which
	// data can be safely evicted. The client can call `QueryWriteStatus()` at any
	// time to determine how much data has been logged for this object.
	// For any sequence of `QueryWriteStatus()` calls for a given
	// object name, the sequence of returned `persisted_size` values are
	// non-decreasing.
	QueryWriteStatus(ctx context.Context, in *QueryWriteStatusRequest, opts ...grpc.CallOption) (*QueryWriteStatusResponse, error)
	// Moves the source object to the destination object in the same bucket.
	// This operation moves a source object to a destination object in the
	// same bucket by renaming the object. The move itself is an atomic
	// transaction, ensuring all steps either complete successfully or no
	// changes are made.
	//
	// **IAM Permissions**:
	//
	// Requires the following IAM permissions to use this method:
	//
	//   - `storage.objects.move`
	//   - `storage.objects.create`
	//   - `storage.objects.delete` (only required if overwriting an existing
	//     object)
	MoveObject(ctx context.Context, in *MoveObjectRequest, opts ...grpc.CallOption) (*Object, error)
}

type storageClient struct {
	cc grpc.ClientConnInterface
}

func NewStorageClient(cc grpc.ClientConnInterface) StorageClient {
	return &storageClient{cc}
}

func (c *storageClient) DeleteBucket(ctx context.Context, in *DeleteBucketRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Storage_DeleteBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetBucket(ctx context.Context, in *GetBucketRequest, opts ...grpc.CallOption) (*Bucket, error) {
	out := new(Bucket)
	err := c.cc.Invoke(ctx, Storage_GetBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) CreateBucket(ctx context.Context, in *CreateBucketRequest, opts ...grpc.CallOption) (*Bucket, error) {
	out := new(Bucket)
	err := c.cc.Invoke(ctx, Storage_CreateBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListBuckets(ctx context.Context, in *ListBucketsRequest, opts ...grpc.CallOption) (*ListBucketsResponse, error) {
	out := new(ListBucketsResponse)
	err := c.cc.Invoke(ctx, Storage_ListBuckets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) LockBucketRetentionPolicy(ctx context.Context, in *LockBucketRetentionPolicyRequest, opts ...grpc.CallOption) (*Bucket, error) {
	out := new(Bucket)
	err := c.cc.Invoke(ctx, Storage_LockBucketRetentionPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, Storage_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, Storage_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, Storage_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) UpdateBucket(ctx context.Context, in *UpdateBucketRequest, opts ...grpc.CallOption) (*Bucket, error) {
	out := new(Bucket)
	err := c.cc.Invoke(ctx, Storage_UpdateBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ComposeObject(ctx context.Context, in *ComposeObjectRequest, opts ...grpc.CallOption) (*Object, error) {
	out := new(Object)
	err := c.cc.Invoke(ctx, Storage_ComposeObject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) DeleteObject(ctx context.Context, in *DeleteObjectRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Storage_DeleteObject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) RestoreObject(ctx context.Context, in *RestoreObjectRequest, opts ...grpc.CallOption) (*Object, error) {
	out := new(Object)
	err := c.cc.Invoke(ctx, Storage_RestoreObject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) CancelResumableWrite(ctx context.Context, in *CancelResumableWriteRequest, opts ...grpc.CallOption) (*CancelResumableWriteResponse, error) {
	out := new(CancelResumableWriteResponse)
	err := c.cc.Invoke(ctx, Storage_CancelResumableWrite_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetObject(ctx context.Context, in *GetObjectRequest, opts ...grpc.CallOption) (*Object, error) {
	out := new(Object)
	err := c.cc.Invoke(ctx, Storage_GetObject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ReadObject(ctx context.Context, in *ReadObjectRequest, opts ...grpc.CallOption) (Storage_ReadObjectClient, error) {
	stream, err := c.cc.NewStream(ctx, &Storage_ServiceDesc.Streams[0], Storage_ReadObject_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &storageReadObjectClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Storage_ReadObjectClient interface {
	Recv() (*ReadObjectResponse, error)
	grpc.ClientStream
}

type storageReadObjectClient struct {
	grpc.ClientStream
}

func (x *storageReadObjectClient) Recv() (*ReadObjectResponse, error) {
	m := new(ReadObjectResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *storageClient) BidiReadObject(ctx context.Context, opts ...grpc.CallOption) (Storage_BidiReadObjectClient, error) {
	stream, err := c.cc.NewStream(ctx, &Storage_ServiceDesc.Streams[1], Storage_BidiReadObject_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &storageBidiReadObjectClient{stream}
	return x, nil
}

type Storage_BidiReadObjectClient interface {
	Send(*BidiReadObjectRequest) error
	Recv() (*BidiReadObjectResponse, error)
	grpc.ClientStream
}

type storageBidiReadObjectClient struct {
	grpc.ClientStream
}

func (x *storageBidiReadObjectClient) Send(m *BidiReadObjectRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *storageBidiReadObjectClient) Recv() (*BidiReadObjectResponse, error) {
	m := new(BidiReadObjectResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *storageClient) UpdateObject(ctx context.Context, in *UpdateObjectRequest, opts ...grpc.CallOption) (*Object, error) {
	out := new(Object)
	err := c.cc.Invoke(ctx, Storage_UpdateObject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) WriteObject(ctx context.Context, opts ...grpc.CallOption) (Storage_WriteObjectClient, error) {
	stream, err := c.cc.NewStream(ctx, &Storage_ServiceDesc.Streams[2], Storage_WriteObject_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &storageWriteObjectClient{stream}
	return x, nil
}

type Storage_WriteObjectClient interface {
	Send(*WriteObjectRequest) error
	CloseAndRecv() (*WriteObjectResponse, error)
	grpc.ClientStream
}

type storageWriteObjectClient struct {
	grpc.ClientStream
}

func (x *storageWriteObjectClient) Send(m *WriteObjectRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *storageWriteObjectClient) CloseAndRecv() (*WriteObjectResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(WriteObjectResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *storageClient) BidiWriteObject(ctx context.Context, opts ...grpc.CallOption) (Storage_BidiWriteObjectClient, error) {
	stream, err := c.cc.NewStream(ctx, &Storage_ServiceDesc.Streams[3], Storage_BidiWriteObject_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &storageBidiWriteObjectClient{stream}
	return x, nil
}

type Storage_BidiWriteObjectClient interface {
	Send(*BidiWriteObjectRequest) error
	Recv() (*BidiWriteObjectResponse, error)
	grpc.ClientStream
}

type storageBidiWriteObjectClient struct {
	grpc.ClientStream
}

func (x *storageBidiWriteObjectClient) Send(m *BidiWriteObjectRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *storageBidiWriteObjectClient) Recv() (*BidiWriteObjectResponse, error) {
	m := new(BidiWriteObjectResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *storageClient) ListObjects(ctx context.Context, in *ListObjectsRequest, opts ...grpc.CallOption) (*ListObjectsResponse, error) {
	out := new(ListObjectsResponse)
	err := c.cc.Invoke(ctx, Storage_ListObjects_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) RewriteObject(ctx context.Context, in *RewriteObjectRequest, opts ...grpc.CallOption) (*RewriteResponse, error) {
	out := new(RewriteResponse)
	err := c.cc.Invoke(ctx, Storage_RewriteObject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) StartResumableWrite(ctx context.Context, in *StartResumableWriteRequest, opts ...grpc.CallOption) (*StartResumableWriteResponse, error) {
	out := new(StartResumableWriteResponse)
	err := c.cc.Invoke(ctx, Storage_StartResumableWrite_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) QueryWriteStatus(ctx context.Context, in *QueryWriteStatusRequest, opts ...grpc.CallOption) (*QueryWriteStatusResponse, error) {
	out := new(QueryWriteStatusResponse)
	err := c.cc.Invoke(ctx, Storage_QueryWriteStatus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) MoveObject(ctx context.Context, in *MoveObjectRequest, opts ...grpc.CallOption) (*Object, error) {
	out := new(Object)
	err := c.cc.Invoke(ctx, Storage_MoveObject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StorageServer is the server API for Storage service.
// All implementations should embed UnimplementedStorageServer
// for forward compatibility
type StorageServer interface {
	// Permanently deletes an empty bucket.
	// The request fails if there are any live or
	// noncurrent objects in the bucket, but the request succeeds if the
	// bucket only contains soft-deleted objects or incomplete uploads, such
	// as ongoing XML API multipart uploads. Does not permanently delete
	// soft-deleted objects.
	//
	// When this API is used to delete a bucket containing an object that has a
	// soft delete policy
	// enabled, the object becomes soft deleted, and the
	// `softDeleteTime` and `hardDeleteTime` properties are set on the
	// object.
	//
	// Objects and multipart uploads that were in the bucket at the time of
	// deletion are also retained for the specified retention duration. When
	// a soft-deleted bucket reaches the end of its retention duration, it
	// is permanently deleted. The `hardDeleteTime` of the bucket always
	// equals
	// or exceeds the expiration time of the last soft-deleted object in the
	// bucket.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.buckets.delete` IAM permission on the bucket.
	DeleteBucket(context.Context, *DeleteBucketRequest) (*emptypb.Empty, error)
	// Returns metadata for the specified bucket.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.buckets.get`
	// IAM permission on
	// the bucket. Additionally, to return specific bucket metadata, the
	// authenticated user must have the following permissions:
	//
	// - To return the IAM policies: `storage.buckets.getIamPolicy`
	// - To return the bucket IP filtering rules: `storage.buckets.getIpFilter`
	GetBucket(context.Context, *GetBucketRequest) (*Bucket, error)
	// Creates a new bucket.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.buckets.create` IAM permission on the bucket.
	// Additionally, to enable specific bucket features, the authenticated user
	// must have the following permissions:
	//
	// - To enable object retention using the `enableObjectRetention` query
	// parameter: `storage.buckets.enableObjectRetention`
	// - To set the bucket IP filtering rules: `storage.buckets.setIpFilter`
	CreateBucket(context.Context, *CreateBucketRequest) (*Bucket, error)
	// Retrieves a list of buckets for a given project, ordered
	// lexicographically by name.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.buckets.list` IAM permission on the bucket.
	// Additionally, to enable specific bucket features, the authenticated
	// user must have the following permissions:
	//
	// - To list the IAM policies: `storage.buckets.getIamPolicy`
	// - To list the bucket IP filtering rules: `storage.buckets.getIpFilter`
	ListBuckets(context.Context, *ListBucketsRequest) (*ListBucketsResponse, error)
	// Permanently locks the retention
	// policy that is
	// currently applied to the specified bucket.
	//
	// Caution: Locking a bucket is an
	// irreversible action. Once you lock a bucket:
	//
	// - You cannot remove the retention policy from the bucket.
	// - You cannot decrease the retention period for the policy.
	//
	// Once locked, you must delete the entire bucket in order to remove the
	// bucket's retention policy. However, before you can delete the bucket, you
	// must delete all the objects in the bucket, which is only
	// possible if all the objects have reached the retention period set by the
	// retention policy.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.buckets.update` IAM permission on the bucket.
	LockBucketRetentionPolicy(context.Context, *LockBucketRetentionPolicyRequest) (*Bucket, error)
	// Gets the IAM policy for a specified bucket or managed folder.
	// The `resource` field in the request should be
	// `projects/_/buckets/{bucket}` for a bucket, or
	// `projects/_/buckets/{bucket}/managedFolders/{managedFolder}`
	// for a managed folder.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.buckets.getIamPolicy` on the bucket or
	// `storage.managedFolders.getIamPolicy` IAM permission on the
	// managed folder.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Updates an IAM policy for the specified bucket or managed folder.
	// The `resource` field in the request should be
	// `projects/_/buckets/{bucket}` for a bucket, or
	// `projects/_/buckets/{bucket}/managedFolders/{managedFolder}`
	// for a managed folder.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Tests a set of permissions on the given bucket, object, or managed folder
	// to see which, if any, are held by the caller. The `resource` field in the
	// request should be `projects/_/buckets/{bucket}` for a bucket,
	// `projects/_/buckets/{bucket}/objects/{object}` for an object, or
	// `projects/_/buckets/{bucket}/managedFolders/{managedFolder}`
	// for a managed folder.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Updates a bucket. Changes to the bucket are readable immediately after
	// writing, but configuration changes might take time to propagate. This
	// method supports `patch` semantics.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.buckets.update` IAM permission on the bucket.
	// Additionally, to enable specific bucket features, the authenticated user
	// must have the following permissions:
	//
	// - To set bucket IP filtering rules: `storage.buckets.setIpFilter`
	// - To update public access prevention policies or access control lists
	// (ACLs): `storage.buckets.setIamPolicy`
	UpdateBucket(context.Context, *UpdateBucketRequest) (*Bucket, error)
	// Concatenates a list of existing objects into a new object in the same
	// bucket. The existing source objects are unaffected by this operation.
	//
	// **IAM Permissions**:
	//
	// Requires the `storage.objects.create` and `storage.objects.get` IAM
	// permissions to use this method. If the new composite object
	// overwrites an existing object, the authenticated user must also have
	// the `storage.objects.delete` permission. If the request body includes
	// the retention property, the authenticated user must also have the
	// `storage.objects.setRetention` IAM permission.
	ComposeObject(context.Context, *ComposeObjectRequest) (*Object, error)
	// Deletes an object and its metadata. Deletions are permanent if versioning
	// is not enabled for the bucket, or if the generation parameter is used, or
	// if soft delete is not
	// enabled for the bucket.
	// When this API is used to delete an object from a bucket that has soft
	// delete policy enabled, the object becomes soft deleted, and the
	// `softDeleteTime` and `hardDeleteTime` properties are set on the object.
	// This API cannot be used to permanently delete soft-deleted objects.
	// Soft-deleted objects are permanently deleted according to their
	// `hardDeleteTime`.
	//
	// You can use the [`RestoreObject`][google.storage.v2.Storage.RestoreObject]
	// API to restore soft-deleted objects until the soft delete retention period
	// has passed.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.objects.delete` IAM permission on the bucket.
	DeleteObject(context.Context, *DeleteObjectRequest) (*emptypb.Empty, error)
	// Restores a
	// soft-deleted object.
	// When a soft-deleted object is restored, a new copy of that object is
	// created in the same bucket and inherits the same metadata as the
	// soft-deleted object. The inherited metadata is the metadata that existed
	// when the original object became soft deleted, with the following
	// exceptions:
	//
	//   - The `createTime` of the new object is set to the time at which the
	//     soft-deleted object was restored.
	//   - The `softDeleteTime` and `hardDeleteTime` values are cleared.
	//   - A new generation is assigned and the metageneration is reset to 1.
	//   - If the soft-deleted object was in a bucket that had Autoclass enabled,
	//     the new object is
	//     restored to Standard storage.
	//   - The restored object inherits the bucket's default object ACL, unless
	//     `copySourceAcl` is `true`.
	//
	// If a live object using the same name already exists in the bucket and
	// becomes overwritten, the live object becomes a noncurrent object if Object
	// Versioning is enabled on the bucket. If Object Versioning is not enabled,
	// the live object becomes soft deleted.
	//
	// **IAM Permissions**:
	//
	// Requires the following IAM permissions to use this method:
	//
	//   - `storage.objects.restore`
	//   - `storage.objects.create`
	//   - `storage.objects.delete` (only required if overwriting an existing
	//     object)
	//   - `storage.objects.getIamPolicy` (only required if `projection` is `full`
	//     and the relevant bucket
	//     has uniform bucket-level access disabled)
	//   - `storage.objects.setIamPolicy` (only required if `copySourceAcl` is
	//     `true` and the relevant
	//     bucket has uniform bucket-level access disabled)
	RestoreObject(context.Context, *RestoreObjectRequest) (*Object, error)
	// Cancels an in-progress resumable upload.
	//
	// Any attempts to write to the resumable upload after cancelling the upload
	// fail.
	//
	// The behavior for any in-progress write operations is not guaranteed;
	// they could either complete before the cancellation or fail if the
	// cancellation completes first.
	CancelResumableWrite(context.Context, *CancelResumableWriteRequest) (*CancelResumableWriteResponse, error)
	// Retrieves object metadata.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.objects.get` IAM permission on the bucket.
	// To return object ACLs, the authenticated user must also have
	// the `storage.objects.getIamPolicy` permission.
	GetObject(context.Context, *GetObjectRequest) (*Object, error)
	// Retrieves object data.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.objects.get` IAM permission on the bucket.
	ReadObject(*ReadObjectRequest, Storage_ReadObjectServer) error
	// Reads an object's data.
	//
	// This bi-directional API reads data from an object, allowing you to
	// request multiple data ranges within a single stream, even across
	// several messages. If an error occurs with any request, the stream
	// closes with a relevant error code. Since you can have multiple
	// outstanding requests, the error response includes a
	// `BidiReadObjectRangesError` field detailing the specific error for
	// each pending `read_id`.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.objects.get` IAM permission on the bucket.
	BidiReadObject(Storage_BidiReadObjectServer) error
	// Updates an object's metadata.
	// Equivalent to JSON API's `storage.objects.patch` method.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.objects.update` IAM permission on the bucket.
	UpdateObject(context.Context, *UpdateObjectRequest) (*Object, error)
	// Stores a new object and metadata.
	//
	// An object can be written either in a single message stream or in a
	// resumable sequence of message streams. To write using a single stream,
	// the client should include in the first message of the stream an
	// `WriteObjectSpec` describing the destination bucket, object, and any
	// preconditions. Additionally, the final message must set 'finish_write' to
	// true, or else it is an error.
	//
	// For a resumable write, the client should instead call
	// `StartResumableWrite()`, populating a `WriteObjectSpec` into that request.
	// They should then attach the returned `upload_id` to the first message of
	// each following call to `WriteObject`. If the stream is closed before
	// finishing the upload (either explicitly by the client or due to a network
	// error or an error response from the server), the client should do as
	// follows:
	//
	//   - Check the result Status of the stream, to determine if writing can be
	//     resumed on this stream or must be restarted from scratch (by calling
	//     `StartResumableWrite()`). The resumable errors are `DEADLINE_EXCEEDED`,
	//     `INTERNAL`, and `UNAVAILABLE`. For each case, the client should use
	//     binary exponential backoff before retrying.  Additionally, writes can
	//     be resumed after `RESOURCE_EXHAUSTED` errors, but only after taking
	//     appropriate measures, which might include reducing aggregate send rate
	//     across clients and/or requesting a quota increase for your project.
	//   - If the call to `WriteObject` returns `ABORTED`, that indicates
	//     concurrent attempts to update the resumable write, caused either by
	//     multiple racing clients or by a single client where the previous
	//     request was timed out on the client side but nonetheless reached the
	//     server. In this case the client should take steps to prevent further
	//     concurrent writes. For example, increase the timeouts and stop using
	//     more than one process to perform the upload. Follow the steps below for
	//     resuming the upload.
	//   - For resumable errors, the client should call `QueryWriteStatus()` and
	//     then continue writing from the returned `persisted_size`. This might be
	//     less than the amount of data the client previously sent. Note also that
	//     it is acceptable to send data starting at an offset earlier than the
	//     returned `persisted_size`; in this case, the service skips data at
	//     offsets that were already persisted (without checking that it matches
	//     the previously written data), and write only the data starting from the
	//     persisted offset. Even though the data isn't written, it might still
	//     incur a performance cost over resuming at the correct write offset.
	//     This behavior can make client-side handling simpler in some cases.
	//   - Clients must only send data that is a multiple of 256 KiB per message,
	//     unless the object is being finished with `finish_write` set to `true`.
	//
	// The service does not view the object as complete until the client has
	// sent a `WriteObjectRequest` with `finish_write` set to `true`. Sending any
	// requests on a stream after sending a request with `finish_write` set to
	// `true` causes an error. The client must check the response it
	// receives to determine how much data the service is able to commit and
	// whether the service views the object as complete.
	//
	// Attempting to resume an already finalized object results in an `OK`
	// status, with a `WriteObjectResponse` containing the finalized object's
	// metadata.
	//
	// Alternatively, you can use the `BidiWriteObject` operation to write an
	// object with controls over flushing and the ability to fetch the ability to
	// determine the current persisted size.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.objects.create`
	// IAM permission on
	// the bucket.
	WriteObject(Storage_WriteObjectServer) error
	// Stores a new object and metadata.
	//
	// This is similar to the `WriteObject` call with the added support for
	// manual flushing of persisted state, and the ability to determine current
	// persisted size without closing the stream.
	//
	// The client might specify one or both of the `state_lookup` and `flush`
	// fields in each `BidiWriteObjectRequest`. If `flush` is specified, the data
	// written so far is persisted to storage. If `state_lookup` is specified, the
	// service responds with a `BidiWriteObjectResponse` that contains the
	// persisted size. If both `flush` and `state_lookup` are specified, the flush
	// always occurs before a `state_lookup`, so that both might be set in the
	// same request and the returned state is the state of the object
	// post-flush. When the stream is closed, a `BidiWriteObjectResponse`
	// is always sent to the client, regardless of the value of `state_lookup`.
	BidiWriteObject(Storage_BidiWriteObjectServer) error
	// Retrieves a list of objects matching the criteria.
	//
	// **IAM Permissions**:
	//
	// The authenticated user requires `storage.objects.list`
	// IAM permission to use this method. To return object ACLs, the
	// authenticated user must also
	// have the `storage.objects.getIamPolicy` permission.
	ListObjects(context.Context, *ListObjectsRequest) (*ListObjectsResponse, error)
	// Rewrites a source object to a destination object. Optionally overrides
	// metadata.
	RewriteObject(context.Context, *RewriteObjectRequest) (*RewriteResponse, error)
	// Starts a resumable write operation. This
	// method is part of the Resumable
	// upload feature.
	// This allows you to upload large objects in multiple chunks, which is more
	// resilient to network interruptions than a single upload. The validity
	// duration of the write operation, and the consequences of it becoming
	// invalid, are service-dependent.
	//
	// **IAM Permissions**:
	//
	// Requires `storage.objects.create` IAM permission on the bucket.
	StartResumableWrite(context.Context, *StartResumableWriteRequest) (*StartResumableWriteResponse, error)
	// Determines the `persisted_size` of an object that is being written. This
	// method is part of the resumable
	// upload feature.
	// The returned value is the size of the object that has been persisted so
	// far. The value can be used as the `write_offset` for the next `Write()`
	// call.
	//
	// If the object does not exist, meaning if it was deleted, or the
	// first `Write()` has not yet reached the service, this method returns the
	// error `NOT_FOUND`.
	//
	// This method is useful for clients that buffer data and need to know which
	// data can be safely evicted. The client can call `QueryWriteStatus()` at any
	// time to determine how much data has been logged for this object.
	// For any sequence of `QueryWriteStatus()` calls for a given
	// object name, the sequence of returned `persisted_size` values are
	// non-decreasing.
	QueryWriteStatus(context.Context, *QueryWriteStatusRequest) (*QueryWriteStatusResponse, error)
	// Moves the source object to the destination object in the same bucket.
	// This operation moves a source object to a destination object in the
	// same bucket by renaming the object. The move itself is an atomic
	// transaction, ensuring all steps either complete successfully or no
	// changes are made.
	//
	// **IAM Permissions**:
	//
	// Requires the following IAM permissions to use this method:
	//
	//   - `storage.objects.move`
	//   - `storage.objects.create`
	//   - `storage.objects.delete` (only required if overwriting an existing
	//     object)
	MoveObject(context.Context, *MoveObjectRequest) (*Object, error)
}

// UnimplementedStorageServer should be embedded to have forward compatible implementations.
type UnimplementedStorageServer struct {
}

func (UnimplementedStorageServer) DeleteBucket(context.Context, *DeleteBucketRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBucket not implemented")
}
func (UnimplementedStorageServer) GetBucket(context.Context, *GetBucketRequest) (*Bucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBucket not implemented")
}
func (UnimplementedStorageServer) CreateBucket(context.Context, *CreateBucketRequest) (*Bucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBucket not implemented")
}
func (UnimplementedStorageServer) ListBuckets(context.Context, *ListBucketsRequest) (*ListBucketsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBuckets not implemented")
}
func (UnimplementedStorageServer) LockBucketRetentionPolicy(context.Context, *LockBucketRetentionPolicyRequest) (*Bucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LockBucketRetentionPolicy not implemented")
}
func (UnimplementedStorageServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedStorageServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedStorageServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedStorageServer) UpdateBucket(context.Context, *UpdateBucketRequest) (*Bucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBucket not implemented")
}
func (UnimplementedStorageServer) ComposeObject(context.Context, *ComposeObjectRequest) (*Object, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ComposeObject not implemented")
}
func (UnimplementedStorageServer) DeleteObject(context.Context, *DeleteObjectRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteObject not implemented")
}
func (UnimplementedStorageServer) RestoreObject(context.Context, *RestoreObjectRequest) (*Object, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreObject not implemented")
}
func (UnimplementedStorageServer) CancelResumableWrite(context.Context, *CancelResumableWriteRequest) (*CancelResumableWriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelResumableWrite not implemented")
}
func (UnimplementedStorageServer) GetObject(context.Context, *GetObjectRequest) (*Object, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetObject not implemented")
}
func (UnimplementedStorageServer) ReadObject(*ReadObjectRequest, Storage_ReadObjectServer) error {
	return status.Errorf(codes.Unimplemented, "method ReadObject not implemented")
}
func (UnimplementedStorageServer) BidiReadObject(Storage_BidiReadObjectServer) error {
	return status.Errorf(codes.Unimplemented, "method BidiReadObject not implemented")
}
func (UnimplementedStorageServer) UpdateObject(context.Context, *UpdateObjectRequest) (*Object, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateObject not implemented")
}
func (UnimplementedStorageServer) WriteObject(Storage_WriteObjectServer) error {
	return status.Errorf(codes.Unimplemented, "method WriteObject not implemented")
}
func (UnimplementedStorageServer) BidiWriteObject(Storage_BidiWriteObjectServer) error {
	return status.Errorf(codes.Unimplemented, "method BidiWriteObject not implemented")
}
func (UnimplementedStorageServer) ListObjects(context.Context, *ListObjectsRequest) (*ListObjectsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListObjects not implemented")
}
func (UnimplementedStorageServer) RewriteObject(context.Context, *RewriteObjectRequest) (*RewriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RewriteObject not implemented")
}
func (UnimplementedStorageServer) StartResumableWrite(context.Context, *StartResumableWriteRequest) (*StartResumableWriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartResumableWrite not implemented")
}
func (UnimplementedStorageServer) QueryWriteStatus(context.Context, *QueryWriteStatusRequest) (*QueryWriteStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryWriteStatus not implemented")
}
func (UnimplementedStorageServer) MoveObject(context.Context, *MoveObjectRequest) (*Object, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MoveObject not implemented")
}

// UnsafeStorageServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to StorageServer will
// result in compilation errors.
type UnsafeStorageServer interface {
	mustEmbedUnimplementedStorageServer()
}

func RegisterStorageServer(s grpc.ServiceRegistrar, srv StorageServer) {
	s.RegisterService(&Storage_ServiceDesc, srv)
}

func _Storage_DeleteBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_DeleteBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteBucket(ctx, req.(*DeleteBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_GetBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetBucket(ctx, req.(*GetBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_CreateBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).CreateBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_CreateBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).CreateBucket(ctx, req.(*CreateBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListBuckets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBucketsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListBuckets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_ListBuckets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListBuckets(ctx, req.(*ListBucketsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_LockBucketRetentionPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LockBucketRetentionPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).LockBucketRetentionPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_LockBucketRetentionPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).LockBucketRetentionPolicy(ctx, req.(*LockBucketRetentionPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_UpdateBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).UpdateBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_UpdateBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).UpdateBucket(ctx, req.(*UpdateBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ComposeObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComposeObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ComposeObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_ComposeObject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ComposeObject(ctx, req.(*ComposeObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_DeleteObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_DeleteObject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteObject(ctx, req.(*DeleteObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_RestoreObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).RestoreObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_RestoreObject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).RestoreObject(ctx, req.(*RestoreObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_CancelResumableWrite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelResumableWriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).CancelResumableWrite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_CancelResumableWrite_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).CancelResumableWrite(ctx, req.(*CancelResumableWriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_GetObject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetObject(ctx, req.(*GetObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ReadObject_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadObjectRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StorageServer).ReadObject(m, &storageReadObjectServer{stream})
}

type Storage_ReadObjectServer interface {
	Send(*ReadObjectResponse) error
	grpc.ServerStream
}

type storageReadObjectServer struct {
	grpc.ServerStream
}

func (x *storageReadObjectServer) Send(m *ReadObjectResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Storage_BidiReadObject_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(StorageServer).BidiReadObject(&storageBidiReadObjectServer{stream})
}

type Storage_BidiReadObjectServer interface {
	Send(*BidiReadObjectResponse) error
	Recv() (*BidiReadObjectRequest, error)
	grpc.ServerStream
}

type storageBidiReadObjectServer struct {
	grpc.ServerStream
}

func (x *storageBidiReadObjectServer) Send(m *BidiReadObjectResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *storageBidiReadObjectServer) Recv() (*BidiReadObjectRequest, error) {
	m := new(BidiReadObjectRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Storage_UpdateObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).UpdateObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_UpdateObject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).UpdateObject(ctx, req.(*UpdateObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_WriteObject_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(StorageServer).WriteObject(&storageWriteObjectServer{stream})
}

type Storage_WriteObjectServer interface {
	SendAndClose(*WriteObjectResponse) error
	Recv() (*WriteObjectRequest, error)
	grpc.ServerStream
}

type storageWriteObjectServer struct {
	grpc.ServerStream
}

func (x *storageWriteObjectServer) SendAndClose(m *WriteObjectResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *storageWriteObjectServer) Recv() (*WriteObjectRequest, error) {
	m := new(WriteObjectRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Storage_BidiWriteObject_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(StorageServer).BidiWriteObject(&storageBidiWriteObjectServer{stream})
}

type Storage_BidiWriteObjectServer interface {
	Send(*BidiWriteObjectResponse) error
	Recv() (*BidiWriteObjectRequest, error)
	grpc.ServerStream
}

type storageBidiWriteObjectServer struct {
	grpc.ServerStream
}

func (x *storageBidiWriteObjectServer) Send(m *BidiWriteObjectResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *storageBidiWriteObjectServer) Recv() (*BidiWriteObjectRequest, error) {
	m := new(BidiWriteObjectRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Storage_ListObjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListObjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListObjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_ListObjects_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListObjects(ctx, req.(*ListObjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_RewriteObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RewriteObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).RewriteObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_RewriteObject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).RewriteObject(ctx, req.(*RewriteObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_StartResumableWrite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartResumableWriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).StartResumableWrite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_StartResumableWrite_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).StartResumableWrite(ctx, req.(*StartResumableWriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_QueryWriteStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryWriteStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).QueryWriteStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_QueryWriteStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).QueryWriteStatus(ctx, req.(*QueryWriteStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_MoveObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).MoveObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_MoveObject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).MoveObject(ctx, req.(*MoveObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Storage_ServiceDesc is the grpc.ServiceDesc for Storage service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Storage_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.storage.v2.Storage",
	HandlerType: (*StorageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DeleteBucket",
			Handler:    _Storage_DeleteBucket_Handler,
		},
		{
			MethodName: "GetBucket",
			Handler:    _Storage_GetBucket_Handler,
		},
		{
			MethodName: "CreateBucket",
			Handler:    _Storage_CreateBucket_Handler,
		},
		{
			MethodName: "ListBuckets",
			Handler:    _Storage_ListBuckets_Handler,
		},
		{
			MethodName: "LockBucketRetentionPolicy",
			Handler:    _Storage_LockBucketRetentionPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _Storage_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _Storage_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Storage_TestIamPermissions_Handler,
		},
		{
			MethodName: "UpdateBucket",
			Handler:    _Storage_UpdateBucket_Handler,
		},
		{
			MethodName: "ComposeObject",
			Handler:    _Storage_ComposeObject_Handler,
		},
		{
			MethodName: "DeleteObject",
			Handler:    _Storage_DeleteObject_Handler,
		},
		{
			MethodName: "RestoreObject",
			Handler:    _Storage_RestoreObject_Handler,
		},
		{
			MethodName: "CancelResumableWrite",
			Handler:    _Storage_CancelResumableWrite_Handler,
		},
		{
			MethodName: "GetObject",
			Handler:    _Storage_GetObject_Handler,
		},
		{
			MethodName: "UpdateObject",
			Handler:    _Storage_UpdateObject_Handler,
		},
		{
			MethodName: "ListObjects",
			Handler:    _Storage_ListObjects_Handler,
		},
		{
			MethodName: "RewriteObject",
			Handler:    _Storage_RewriteObject_Handler,
		},
		{
			MethodName: "StartResumableWrite",
			Handler:    _Storage_StartResumableWrite_Handler,
		},
		{
			MethodName: "QueryWriteStatus",
			Handler:    _Storage_QueryWriteStatus_Handler,
		},
		{
			MethodName: "MoveObject",
			Handler:    _Storage_MoveObject_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReadObject",
			Handler:       _Storage_ReadObject_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "BidiReadObject",
			Handler:       _Storage_BidiReadObject_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "WriteObject",
			Handler:       _Storage_WriteObject_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "BidiWriteObject",
			Handler:       _Storage_BidiWriteObject_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/storage/v2/storage.proto",
}
