// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

package instancepb

import (
	context "context"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	InstanceAdmin_ListInstanceConfigs_FullMethodName             = "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstanceConfigs"
	InstanceAdmin_GetInstanceConfig_FullMethodName               = "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstanceConfig"
	InstanceAdmin_CreateInstanceConfig_FullMethodName            = "/google.spanner.admin.instance.v1.InstanceAdmin/CreateInstanceConfig"
	InstanceAdmin_UpdateInstanceConfig_FullMethodName            = "/google.spanner.admin.instance.v1.InstanceAdmin/UpdateInstanceConfig"
	InstanceAdmin_DeleteInstanceConfig_FullMethodName            = "/google.spanner.admin.instance.v1.InstanceAdmin/DeleteInstanceConfig"
	InstanceAdmin_ListInstanceConfigOperations_FullMethodName    = "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstanceConfigOperations"
	InstanceAdmin_ListInstances_FullMethodName                   = "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstances"
	InstanceAdmin_ListInstancePartitions_FullMethodName          = "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstancePartitions"
	InstanceAdmin_GetInstance_FullMethodName                     = "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstance"
	InstanceAdmin_CreateInstance_FullMethodName                  = "/google.spanner.admin.instance.v1.InstanceAdmin/CreateInstance"
	InstanceAdmin_UpdateInstance_FullMethodName                  = "/google.spanner.admin.instance.v1.InstanceAdmin/UpdateInstance"
	InstanceAdmin_DeleteInstance_FullMethodName                  = "/google.spanner.admin.instance.v1.InstanceAdmin/DeleteInstance"
	InstanceAdmin_SetIamPolicy_FullMethodName                    = "/google.spanner.admin.instance.v1.InstanceAdmin/SetIamPolicy"
	InstanceAdmin_GetIamPolicy_FullMethodName                    = "/google.spanner.admin.instance.v1.InstanceAdmin/GetIamPolicy"
	InstanceAdmin_TestIamPermissions_FullMethodName              = "/google.spanner.admin.instance.v1.InstanceAdmin/TestIamPermissions"
	InstanceAdmin_GetInstancePartition_FullMethodName            = "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstancePartition"
	InstanceAdmin_CreateInstancePartition_FullMethodName         = "/google.spanner.admin.instance.v1.InstanceAdmin/CreateInstancePartition"
	InstanceAdmin_DeleteInstancePartition_FullMethodName         = "/google.spanner.admin.instance.v1.InstanceAdmin/DeleteInstancePartition"
	InstanceAdmin_UpdateInstancePartition_FullMethodName         = "/google.spanner.admin.instance.v1.InstanceAdmin/UpdateInstancePartition"
	InstanceAdmin_ListInstancePartitionOperations_FullMethodName = "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstancePartitionOperations"
	InstanceAdmin_MoveInstance_FullMethodName                    = "/google.spanner.admin.instance.v1.InstanceAdmin/MoveInstance"
)

// InstanceAdminClient is the client API for InstanceAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InstanceAdminClient interface {
	// Lists the supported instance configurations for a given project.
	//
	// Returns both Google-managed configurations and user-managed
	// configurations.
	ListInstanceConfigs(ctx context.Context, in *ListInstanceConfigsRequest, opts ...grpc.CallOption) (*ListInstanceConfigsResponse, error)
	// Gets information about a particular instance configuration.
	GetInstanceConfig(ctx context.Context, in *GetInstanceConfigRequest, opts ...grpc.CallOption) (*InstanceConfig, error)
	// Creates an instance configuration and begins preparing it to be used. The
	// returned long-running operation
	// can be used to track the progress of preparing the new
	// instance configuration. The instance configuration name is assigned by the
	// caller. If the named instance configuration already exists,
	// `CreateInstanceConfig` returns `ALREADY_EXISTS`.
	//
	// Immediately after the request returns:
	//
	//   - The instance configuration is readable via the API, with all requested
	//     attributes. The instance configuration's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field is set to true. Its state is `CREATING`.
	//
	// While the operation is pending:
	//
	//   - Cancelling the operation renders the instance configuration immediately
	//     unreadable via the API.
	//   - Except for deleting the creating resource, all other attempts to modify
	//     the instance configuration are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   - Instances can be created using the instance configuration.
	//   - The instance configuration's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field becomes false. Its state becomes `READY`.
	//
	// The returned long-running operation will
	// have a name of the format
	// `<instance_config_name>/operations/<operation_id>` and can be used to track
	// creation of the instance configuration. The
	// metadata field type is
	// [CreateInstanceConfigMetadata][google.spanner.admin.instance.v1.CreateInstanceConfigMetadata].
	// The response field type is
	// [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig], if
	// successful.
	//
	// Authorization requires `spanner.instanceConfigs.create` permission on
	// the resource
	// [parent][google.spanner.admin.instance.v1.CreateInstanceConfigRequest.parent].
	CreateInstanceConfig(ctx context.Context, in *CreateInstanceConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an instance configuration. The returned
	// long-running operation can be used to track
	// the progress of updating the instance. If the named instance configuration
	// does not exist, returns `NOT_FOUND`.
	//
	// Only user-managed configurations can be updated.
	//
	// Immediately after the request returns:
	//
	//   - The instance configuration's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field is set to true.
	//
	// While the operation is pending:
	//
	//   - Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata.cancel_time].
	//     The operation is guaranteed to succeed at undoing all changes, after
	//     which point it terminates with a `CANCELLED` status.
	//   - All other attempts to modify the instance configuration are rejected.
	//   - Reading the instance configuration via the API continues to give the
	//     pre-request values.
	//
	// Upon completion of the returned operation:
	//
	//   - Creating instances using the instance configuration uses the new
	//     values.
	//   - The new values of the instance configuration are readable via the API.
	//   - The instance configuration's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field becomes false.
	//
	// The returned long-running operation will
	// have a name of the format
	// `<instance_config_name>/operations/<operation_id>` and can be used to track
	// the instance configuration modification.  The
	// metadata field type is
	// [UpdateInstanceConfigMetadata][google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata].
	// The response field type is
	// [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig], if
	// successful.
	//
	// Authorization requires `spanner.instanceConfigs.update` permission on
	// the resource [name][google.spanner.admin.instance.v1.InstanceConfig.name].
	UpdateInstanceConfig(ctx context.Context, in *UpdateInstanceConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the instance configuration. Deletion is only allowed when no
	// instances are using the configuration. If any instances are using
	// the configuration, returns `FAILED_PRECONDITION`.
	//
	// Only user-managed configurations can be deleted.
	//
	// Authorization requires `spanner.instanceConfigs.delete` permission on
	// the resource [name][google.spanner.admin.instance.v1.InstanceConfig.name].
	DeleteInstanceConfig(ctx context.Context, in *DeleteInstanceConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists the user-managed instance configuration long-running
	// operations in the given project. An instance
	// configuration operation has a name of the form
	// `projects/<project>/instanceConfigs/<instance_config>/operations/<operation>`.
	// The long-running operation
	// metadata field type
	// `metadata.type_url` describes the type of the metadata. Operations returned
	// include those that have completed/failed/canceled within the last 7 days,
	// and pending operations. Operations returned are ordered by
	// `operation.metadata.value.start_time` in descending order starting
	// from the most recently started operation.
	ListInstanceConfigOperations(ctx context.Context, in *ListInstanceConfigOperationsRequest, opts ...grpc.CallOption) (*ListInstanceConfigOperationsResponse, error)
	// Lists all instances in the given project.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Lists all instance partitions for the given instance.
	ListInstancePartitions(ctx context.Context, in *ListInstancePartitionsRequest, opts ...grpc.CallOption) (*ListInstancePartitionsResponse, error)
	// Gets information about a particular instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates an instance and begins preparing it to begin serving. The
	// returned long-running operation
	// can be used to track the progress of preparing the new
	// instance. The instance name is assigned by the caller. If the
	// named instance already exists, `CreateInstance` returns
	// `ALREADY_EXISTS`.
	//
	// Immediately upon completion of this request:
	//
	//   - The instance is readable via the API, with all requested attributes
	//     but no allocated resources. Its state is `CREATING`.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation renders the instance immediately unreadable
	//     via the API.
	//   - The instance can be deleted.
	//   - All other attempts to modify the instance are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing for all successfully-allocated resources begins (some types
	//     may have lower than the requested levels).
	//   - Databases can be created in the instance.
	//   - The instance's allocated resource levels are readable via the API.
	//   - The instance's state becomes `READY`.
	//
	// The returned long-running operation will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track creation of the instance.  The
	// metadata field type is
	// [CreateInstanceMetadata][google.spanner.admin.instance.v1.CreateInstanceMetadata].
	// The response field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an instance, and begins allocating or releasing resources
	// as requested. The returned long-running operation can be used to track the
	// progress of updating the instance. If the named instance does not
	// exist, returns `NOT_FOUND`.
	//
	// Immediately upon completion of this request:
	//
	//   - For resource types for which a decrease in the instance's allocation
	//     has been requested, billing is based on the newly-requested level.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstanceMetadata.cancel_time],
	//     and begins restoring resources to their pre-request values. The
	//     operation is guaranteed to succeed at undoing all resource changes,
	//     after which point it terminates with a `CANCELLED` status.
	//   - All other attempts to modify the instance are rejected.
	//   - Reading the instance via the API continues to give the pre-request
	//     resource levels.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing begins for all successfully-allocated resources (some types
	//     may have lower than the requested levels).
	//   - All newly-reserved resources are available for serving the instance's
	//     tables.
	//   - The instance's new resource levels are readable via the API.
	//
	// The returned long-running operation will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track the instance modification.  The
	// metadata field type is
	// [UpdateInstanceMetadata][google.spanner.admin.instance.v1.UpdateInstanceMetadata].
	// The response field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	//
	// Authorization requires `spanner.instances.update` permission on
	// the resource [name][google.spanner.admin.instance.v1.Instance.name].
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an instance.
	//
	// Immediately upon completion of the request:
	//
	//   - Billing ceases for all of the instance's reserved resources.
	//
	// Soon afterward:
	//
	//   - The instance and *all of its databases* immediately and
	//     irrevocably disappear from the API. All data in the databases
	//     is permanently deleted.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Sets the access control policy on an instance resource. Replaces any
	// existing policy.
	//
	// Authorization requires `spanner.instances.setIamPolicy` on
	// [resource][google.iam.v1.SetIamPolicyRequest.resource].
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets the access control policy for an instance resource. Returns an empty
	// policy if an instance exists but does not have a policy set.
	//
	// Authorization requires `spanner.instances.getIamPolicy` on
	// [resource][google.iam.v1.GetIamPolicyRequest.resource].
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns permissions that the caller has on the specified instance resource.
	//
	// Attempting this RPC on a non-existent Cloud Spanner instance resource will
	// result in a NOT_FOUND error if the user has `spanner.instances.list`
	// permission on the containing Google Cloud Project. Otherwise returns an
	// empty set of permissions.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Gets information about a particular instance partition.
	GetInstancePartition(ctx context.Context, in *GetInstancePartitionRequest, opts ...grpc.CallOption) (*InstancePartition, error)
	// Creates an instance partition and begins preparing it to be used. The
	// returned long-running operation
	// can be used to track the progress of preparing the new instance partition.
	// The instance partition name is assigned by the caller. If the named
	// instance partition already exists, `CreateInstancePartition` returns
	// `ALREADY_EXISTS`.
	//
	// Immediately upon completion of this request:
	//
	//   - The instance partition is readable via the API, with all requested
	//     attributes but no allocated resources. Its state is `CREATING`.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation renders the instance partition immediately
	//     unreadable via the API.
	//   - The instance partition can be deleted.
	//   - All other attempts to modify the instance partition are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing for all successfully-allocated resources begins (some types
	//     may have lower than the requested levels).
	//   - Databases can start using this instance partition.
	//   - The instance partition's allocated resource levels are readable via the
	//     API.
	//   - The instance partition's state becomes `READY`.
	//
	// The returned long-running operation will
	// have a name of the format
	// `<instance_partition_name>/operations/<operation_id>` and can be used to
	// track creation of the instance partition.  The
	// metadata field type is
	// [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata].
	// The response field type is
	// [InstancePartition][google.spanner.admin.instance.v1.InstancePartition], if
	// successful.
	CreateInstancePartition(ctx context.Context, in *CreateInstancePartitionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing instance partition. Requires that the
	// instance partition is not used by any database or backup and is not the
	// default instance partition of an instance.
	//
	// Authorization requires `spanner.instancePartitions.delete` permission on
	// the resource
	// [name][google.spanner.admin.instance.v1.InstancePartition.name].
	DeleteInstancePartition(ctx context.Context, in *DeleteInstancePartitionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an instance partition, and begins allocating or releasing resources
	// as requested. The returned long-running operation can be used to track the
	// progress of updating the instance partition. If the named instance
	// partition does not exist, returns `NOT_FOUND`.
	//
	// Immediately upon completion of this request:
	//
	//   - For resource types for which a decrease in the instance partition's
	//     allocation has been requested, billing is based on the newly-requested
	//     level.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata.cancel_time],
	//     and begins restoring resources to their pre-request values. The
	//     operation is guaranteed to succeed at undoing all resource changes,
	//     after which point it terminates with a `CANCELLED` status.
	//   - All other attempts to modify the instance partition are rejected.
	//   - Reading the instance partition via the API continues to give the
	//     pre-request resource levels.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing begins for all successfully-allocated resources (some types
	//     may have lower than the requested levels).
	//   - All newly-reserved resources are available for serving the instance
	//     partition's tables.
	//   - The instance partition's new resource levels are readable via the API.
	//
	// The returned long-running operation will
	// have a name of the format
	// `<instance_partition_name>/operations/<operation_id>` and can be used to
	// track the instance partition modification. The
	// metadata field type is
	// [UpdateInstancePartitionMetadata][google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata].
	// The response field type is
	// [InstancePartition][google.spanner.admin.instance.v1.InstancePartition], if
	// successful.
	//
	// Authorization requires `spanner.instancePartitions.update` permission on
	// the resource
	// [name][google.spanner.admin.instance.v1.InstancePartition.name].
	UpdateInstancePartition(ctx context.Context, in *UpdateInstancePartitionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists instance partition long-running operations in the given instance.
	// An instance partition operation has a name of the form
	// `projects/<project>/instances/<instance>/instancePartitions/<instance_partition>/operations/<operation>`.
	// The long-running operation
	// metadata field type
	// `metadata.type_url` describes the type of the metadata. Operations returned
	// include those that have completed/failed/canceled within the last 7 days,
	// and pending operations. Operations returned are ordered by
	// `operation.metadata.value.start_time` in descending order starting from the
	// most recently started operation.
	//
	// Authorization requires `spanner.instancePartitionOperations.list`
	// permission on the resource
	// [parent][google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest.parent].
	ListInstancePartitionOperations(ctx context.Context, in *ListInstancePartitionOperationsRequest, opts ...grpc.CallOption) (*ListInstancePartitionOperationsResponse, error)
	// Moves an instance to the target instance configuration. You can use the
	// returned long-running operation to track
	// the progress of moving the instance.
	//
	// `MoveInstance` returns `FAILED_PRECONDITION` if the instance meets any of
	// the following criteria:
	//
	//   - Is undergoing a move to a different instance configuration
	//   - Has backups
	//   - Has an ongoing update
	//   - Contains any CMEK-enabled databases
	//   - Is a free trial instance
	//
	// While the operation is pending:
	//
	//   - All other attempts to modify the instance, including changes to its
	//     compute capacity, are rejected.
	//
	//   - The following database and backup admin operations are rejected:
	//
	//   - `DatabaseAdmin.CreateDatabase`
	//
	//   - `DatabaseAdmin.UpdateDatabaseDdl` (disabled if default_leader is
	//     specified in the request.)
	//
	//   - `DatabaseAdmin.RestoreDatabase`
	//
	//   - `DatabaseAdmin.CreateBackup`
	//
	//   - `DatabaseAdmin.CopyBackup`
	//
	//   - Both the source and target instance configurations are subject to
	//     hourly compute and storage charges.
	//
	//   - The instance might experience higher read-write latencies and a higher
	//     transaction abort rate. However, moving an instance doesn't cause any
	//     downtime.
	//
	// The returned long-running operation has
	// a name of the format
	// `<instance_name>/operations/<operation_id>` and can be used to track
	// the move instance operation. The
	// metadata field type is
	// [MoveInstanceMetadata][google.spanner.admin.instance.v1.MoveInstanceMetadata].
	// The response field type is
	// [Instance][google.spanner.admin.instance.v1.Instance],
	// if successful.
	// Cancelling the operation sets its metadata's
	// [cancel_time][google.spanner.admin.instance.v1.MoveInstanceMetadata.cancel_time].
	// Cancellation is not immediate because it involves moving any data
	// previously moved to the target instance configuration back to the original
	// instance configuration. You can use this operation to track the progress of
	// the cancellation. Upon successful completion of the cancellation, the
	// operation terminates with `CANCELLED` status.
	//
	// If not cancelled, upon completion of the returned operation:
	//
	//   - The instance successfully moves to the target instance
	//     configuration.
	//   - You are billed for compute and storage in target instance
	//     configuration.
	//
	// Authorization requires the `spanner.instances.update` permission on
	// the resource [instance][google.spanner.admin.instance.v1.Instance].
	//
	// For more details, see
	// [Move an instance](https://cloud.google.com/spanner/docs/move-instance).
	MoveInstance(ctx context.Context, in *MoveInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type instanceAdminClient struct {
	cc grpc.ClientConnInterface
}

func NewInstanceAdminClient(cc grpc.ClientConnInterface) InstanceAdminClient {
	return &instanceAdminClient{cc}
}

func (c *instanceAdminClient) ListInstanceConfigs(ctx context.Context, in *ListInstanceConfigsRequest, opts ...grpc.CallOption) (*ListInstanceConfigsResponse, error) {
	out := new(ListInstanceConfigsResponse)
	err := c.cc.Invoke(ctx, InstanceAdmin_ListInstanceConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) GetInstanceConfig(ctx context.Context, in *GetInstanceConfigRequest, opts ...grpc.CallOption) (*InstanceConfig, error) {
	out := new(InstanceConfig)
	err := c.cc.Invoke(ctx, InstanceAdmin_GetInstanceConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) CreateInstanceConfig(ctx context.Context, in *CreateInstanceConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, InstanceAdmin_CreateInstanceConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) UpdateInstanceConfig(ctx context.Context, in *UpdateInstanceConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, InstanceAdmin_UpdateInstanceConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) DeleteInstanceConfig(ctx context.Context, in *DeleteInstanceConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, InstanceAdmin_DeleteInstanceConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) ListInstanceConfigOperations(ctx context.Context, in *ListInstanceConfigOperationsRequest, opts ...grpc.CallOption) (*ListInstanceConfigOperationsResponse, error) {
	out := new(ListInstanceConfigOperationsResponse)
	err := c.cc.Invoke(ctx, InstanceAdmin_ListInstanceConfigOperations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, InstanceAdmin_ListInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) ListInstancePartitions(ctx context.Context, in *ListInstancePartitionsRequest, opts ...grpc.CallOption) (*ListInstancePartitionsResponse, error) {
	out := new(ListInstancePartitionsResponse)
	err := c.cc.Invoke(ctx, InstanceAdmin_ListInstancePartitions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, InstanceAdmin_GetInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, InstanceAdmin_CreateInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, InstanceAdmin_UpdateInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, InstanceAdmin_DeleteInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, InstanceAdmin_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, InstanceAdmin_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, InstanceAdmin_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) GetInstancePartition(ctx context.Context, in *GetInstancePartitionRequest, opts ...grpc.CallOption) (*InstancePartition, error) {
	out := new(InstancePartition)
	err := c.cc.Invoke(ctx, InstanceAdmin_GetInstancePartition_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) CreateInstancePartition(ctx context.Context, in *CreateInstancePartitionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, InstanceAdmin_CreateInstancePartition_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) DeleteInstancePartition(ctx context.Context, in *DeleteInstancePartitionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, InstanceAdmin_DeleteInstancePartition_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) UpdateInstancePartition(ctx context.Context, in *UpdateInstancePartitionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, InstanceAdmin_UpdateInstancePartition_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) ListInstancePartitionOperations(ctx context.Context, in *ListInstancePartitionOperationsRequest, opts ...grpc.CallOption) (*ListInstancePartitionOperationsResponse, error) {
	out := new(ListInstancePartitionOperationsResponse)
	err := c.cc.Invoke(ctx, InstanceAdmin_ListInstancePartitionOperations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) MoveInstance(ctx context.Context, in *MoveInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, InstanceAdmin_MoveInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InstanceAdminServer is the server API for InstanceAdmin service.
// All implementations should embed UnimplementedInstanceAdminServer
// for forward compatibility
type InstanceAdminServer interface {
	// Lists the supported instance configurations for a given project.
	//
	// Returns both Google-managed configurations and user-managed
	// configurations.
	ListInstanceConfigs(context.Context, *ListInstanceConfigsRequest) (*ListInstanceConfigsResponse, error)
	// Gets information about a particular instance configuration.
	GetInstanceConfig(context.Context, *GetInstanceConfigRequest) (*InstanceConfig, error)
	// Creates an instance configuration and begins preparing it to be used. The
	// returned long-running operation
	// can be used to track the progress of preparing the new
	// instance configuration. The instance configuration name is assigned by the
	// caller. If the named instance configuration already exists,
	// `CreateInstanceConfig` returns `ALREADY_EXISTS`.
	//
	// Immediately after the request returns:
	//
	//   - The instance configuration is readable via the API, with all requested
	//     attributes. The instance configuration's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field is set to true. Its state is `CREATING`.
	//
	// While the operation is pending:
	//
	//   - Cancelling the operation renders the instance configuration immediately
	//     unreadable via the API.
	//   - Except for deleting the creating resource, all other attempts to modify
	//     the instance configuration are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   - Instances can be created using the instance configuration.
	//   - The instance configuration's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field becomes false. Its state becomes `READY`.
	//
	// The returned long-running operation will
	// have a name of the format
	// `<instance_config_name>/operations/<operation_id>` and can be used to track
	// creation of the instance configuration. The
	// metadata field type is
	// [CreateInstanceConfigMetadata][google.spanner.admin.instance.v1.CreateInstanceConfigMetadata].
	// The response field type is
	// [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig], if
	// successful.
	//
	// Authorization requires `spanner.instanceConfigs.create` permission on
	// the resource
	// [parent][google.spanner.admin.instance.v1.CreateInstanceConfigRequest.parent].
	CreateInstanceConfig(context.Context, *CreateInstanceConfigRequest) (*longrunningpb.Operation, error)
	// Updates an instance configuration. The returned
	// long-running operation can be used to track
	// the progress of updating the instance. If the named instance configuration
	// does not exist, returns `NOT_FOUND`.
	//
	// Only user-managed configurations can be updated.
	//
	// Immediately after the request returns:
	//
	//   - The instance configuration's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field is set to true.
	//
	// While the operation is pending:
	//
	//   - Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata.cancel_time].
	//     The operation is guaranteed to succeed at undoing all changes, after
	//     which point it terminates with a `CANCELLED` status.
	//   - All other attempts to modify the instance configuration are rejected.
	//   - Reading the instance configuration via the API continues to give the
	//     pre-request values.
	//
	// Upon completion of the returned operation:
	//
	//   - Creating instances using the instance configuration uses the new
	//     values.
	//   - The new values of the instance configuration are readable via the API.
	//   - The instance configuration's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field becomes false.
	//
	// The returned long-running operation will
	// have a name of the format
	// `<instance_config_name>/operations/<operation_id>` and can be used to track
	// the instance configuration modification.  The
	// metadata field type is
	// [UpdateInstanceConfigMetadata][google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata].
	// The response field type is
	// [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig], if
	// successful.
	//
	// Authorization requires `spanner.instanceConfigs.update` permission on
	// the resource [name][google.spanner.admin.instance.v1.InstanceConfig.name].
	UpdateInstanceConfig(context.Context, *UpdateInstanceConfigRequest) (*longrunningpb.Operation, error)
	// Deletes the instance configuration. Deletion is only allowed when no
	// instances are using the configuration. If any instances are using
	// the configuration, returns `FAILED_PRECONDITION`.
	//
	// Only user-managed configurations can be deleted.
	//
	// Authorization requires `spanner.instanceConfigs.delete` permission on
	// the resource [name][google.spanner.admin.instance.v1.InstanceConfig.name].
	DeleteInstanceConfig(context.Context, *DeleteInstanceConfigRequest) (*emptypb.Empty, error)
	// Lists the user-managed instance configuration long-running
	// operations in the given project. An instance
	// configuration operation has a name of the form
	// `projects/<project>/instanceConfigs/<instance_config>/operations/<operation>`.
	// The long-running operation
	// metadata field type
	// `metadata.type_url` describes the type of the metadata. Operations returned
	// include those that have completed/failed/canceled within the last 7 days,
	// and pending operations. Operations returned are ordered by
	// `operation.metadata.value.start_time` in descending order starting
	// from the most recently started operation.
	ListInstanceConfigOperations(context.Context, *ListInstanceConfigOperationsRequest) (*ListInstanceConfigOperationsResponse, error)
	// Lists all instances in the given project.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Lists all instance partitions for the given instance.
	ListInstancePartitions(context.Context, *ListInstancePartitionsRequest) (*ListInstancePartitionsResponse, error)
	// Gets information about a particular instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates an instance and begins preparing it to begin serving. The
	// returned long-running operation
	// can be used to track the progress of preparing the new
	// instance. The instance name is assigned by the caller. If the
	// named instance already exists, `CreateInstance` returns
	// `ALREADY_EXISTS`.
	//
	// Immediately upon completion of this request:
	//
	//   - The instance is readable via the API, with all requested attributes
	//     but no allocated resources. Its state is `CREATING`.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation renders the instance immediately unreadable
	//     via the API.
	//   - The instance can be deleted.
	//   - All other attempts to modify the instance are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing for all successfully-allocated resources begins (some types
	//     may have lower than the requested levels).
	//   - Databases can be created in the instance.
	//   - The instance's allocated resource levels are readable via the API.
	//   - The instance's state becomes `READY`.
	//
	// The returned long-running operation will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track creation of the instance.  The
	// metadata field type is
	// [CreateInstanceMetadata][google.spanner.admin.instance.v1.CreateInstanceMetadata].
	// The response field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error)
	// Updates an instance, and begins allocating or releasing resources
	// as requested. The returned long-running operation can be used to track the
	// progress of updating the instance. If the named instance does not
	// exist, returns `NOT_FOUND`.
	//
	// Immediately upon completion of this request:
	//
	//   - For resource types for which a decrease in the instance's allocation
	//     has been requested, billing is based on the newly-requested level.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstanceMetadata.cancel_time],
	//     and begins restoring resources to their pre-request values. The
	//     operation is guaranteed to succeed at undoing all resource changes,
	//     after which point it terminates with a `CANCELLED` status.
	//   - All other attempts to modify the instance are rejected.
	//   - Reading the instance via the API continues to give the pre-request
	//     resource levels.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing begins for all successfully-allocated resources (some types
	//     may have lower than the requested levels).
	//   - All newly-reserved resources are available for serving the instance's
	//     tables.
	//   - The instance's new resource levels are readable via the API.
	//
	// The returned long-running operation will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track the instance modification.  The
	// metadata field type is
	// [UpdateInstanceMetadata][google.spanner.admin.instance.v1.UpdateInstanceMetadata].
	// The response field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	//
	// Authorization requires `spanner.instances.update` permission on
	// the resource [name][google.spanner.admin.instance.v1.Instance.name].
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error)
	// Deletes an instance.
	//
	// Immediately upon completion of the request:
	//
	//   - Billing ceases for all of the instance's reserved resources.
	//
	// Soon afterward:
	//
	//   - The instance and *all of its databases* immediately and
	//     irrevocably disappear from the API. All data in the databases
	//     is permanently deleted.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*emptypb.Empty, error)
	// Sets the access control policy on an instance resource. Replaces any
	// existing policy.
	//
	// Authorization requires `spanner.instances.setIamPolicy` on
	// [resource][google.iam.v1.SetIamPolicyRequest.resource].
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Gets the access control policy for an instance resource. Returns an empty
	// policy if an instance exists but does not have a policy set.
	//
	// Authorization requires `spanner.instances.getIamPolicy` on
	// [resource][google.iam.v1.GetIamPolicyRequest.resource].
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Returns permissions that the caller has on the specified instance resource.
	//
	// Attempting this RPC on a non-existent Cloud Spanner instance resource will
	// result in a NOT_FOUND error if the user has `spanner.instances.list`
	// permission on the containing Google Cloud Project. Otherwise returns an
	// empty set of permissions.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Gets information about a particular instance partition.
	GetInstancePartition(context.Context, *GetInstancePartitionRequest) (*InstancePartition, error)
	// Creates an instance partition and begins preparing it to be used. The
	// returned long-running operation
	// can be used to track the progress of preparing the new instance partition.
	// The instance partition name is assigned by the caller. If the named
	// instance partition already exists, `CreateInstancePartition` returns
	// `ALREADY_EXISTS`.
	//
	// Immediately upon completion of this request:
	//
	//   - The instance partition is readable via the API, with all requested
	//     attributes but no allocated resources. Its state is `CREATING`.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation renders the instance partition immediately
	//     unreadable via the API.
	//   - The instance partition can be deleted.
	//   - All other attempts to modify the instance partition are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing for all successfully-allocated resources begins (some types
	//     may have lower than the requested levels).
	//   - Databases can start using this instance partition.
	//   - The instance partition's allocated resource levels are readable via the
	//     API.
	//   - The instance partition's state becomes `READY`.
	//
	// The returned long-running operation will
	// have a name of the format
	// `<instance_partition_name>/operations/<operation_id>` and can be used to
	// track creation of the instance partition.  The
	// metadata field type is
	// [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata].
	// The response field type is
	// [InstancePartition][google.spanner.admin.instance.v1.InstancePartition], if
	// successful.
	CreateInstancePartition(context.Context, *CreateInstancePartitionRequest) (*longrunningpb.Operation, error)
	// Deletes an existing instance partition. Requires that the
	// instance partition is not used by any database or backup and is not the
	// default instance partition of an instance.
	//
	// Authorization requires `spanner.instancePartitions.delete` permission on
	// the resource
	// [name][google.spanner.admin.instance.v1.InstancePartition.name].
	DeleteInstancePartition(context.Context, *DeleteInstancePartitionRequest) (*emptypb.Empty, error)
	// Updates an instance partition, and begins allocating or releasing resources
	// as requested. The returned long-running operation can be used to track the
	// progress of updating the instance partition. If the named instance
	// partition does not exist, returns `NOT_FOUND`.
	//
	// Immediately upon completion of this request:
	//
	//   - For resource types for which a decrease in the instance partition's
	//     allocation has been requested, billing is based on the newly-requested
	//     level.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata.cancel_time],
	//     and begins restoring resources to their pre-request values. The
	//     operation is guaranteed to succeed at undoing all resource changes,
	//     after which point it terminates with a `CANCELLED` status.
	//   - All other attempts to modify the instance partition are rejected.
	//   - Reading the instance partition via the API continues to give the
	//     pre-request resource levels.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing begins for all successfully-allocated resources (some types
	//     may have lower than the requested levels).
	//   - All newly-reserved resources are available for serving the instance
	//     partition's tables.
	//   - The instance partition's new resource levels are readable via the API.
	//
	// The returned long-running operation will
	// have a name of the format
	// `<instance_partition_name>/operations/<operation_id>` and can be used to
	// track the instance partition modification. The
	// metadata field type is
	// [UpdateInstancePartitionMetadata][google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata].
	// The response field type is
	// [InstancePartition][google.spanner.admin.instance.v1.InstancePartition], if
	// successful.
	//
	// Authorization requires `spanner.instancePartitions.update` permission on
	// the resource
	// [name][google.spanner.admin.instance.v1.InstancePartition.name].
	UpdateInstancePartition(context.Context, *UpdateInstancePartitionRequest) (*longrunningpb.Operation, error)
	// Lists instance partition long-running operations in the given instance.
	// An instance partition operation has a name of the form
	// `projects/<project>/instances/<instance>/instancePartitions/<instance_partition>/operations/<operation>`.
	// The long-running operation
	// metadata field type
	// `metadata.type_url` describes the type of the metadata. Operations returned
	// include those that have completed/failed/canceled within the last 7 days,
	// and pending operations. Operations returned are ordered by
	// `operation.metadata.value.start_time` in descending order starting from the
	// most recently started operation.
	//
	// Authorization requires `spanner.instancePartitionOperations.list`
	// permission on the resource
	// [parent][google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest.parent].
	ListInstancePartitionOperations(context.Context, *ListInstancePartitionOperationsRequest) (*ListInstancePartitionOperationsResponse, error)
	// Moves an instance to the target instance configuration. You can use the
	// returned long-running operation to track
	// the progress of moving the instance.
	//
	// `MoveInstance` returns `FAILED_PRECONDITION` if the instance meets any of
	// the following criteria:
	//
	//   - Is undergoing a move to a different instance configuration
	//   - Has backups
	//   - Has an ongoing update
	//   - Contains any CMEK-enabled databases
	//   - Is a free trial instance
	//
	// While the operation is pending:
	//
	//   - All other attempts to modify the instance, including changes to its
	//     compute capacity, are rejected.
	//
	//   - The following database and backup admin operations are rejected:
	//
	//   - `DatabaseAdmin.CreateDatabase`
	//
	//   - `DatabaseAdmin.UpdateDatabaseDdl` (disabled if default_leader is
	//     specified in the request.)
	//
	//   - `DatabaseAdmin.RestoreDatabase`
	//
	//   - `DatabaseAdmin.CreateBackup`
	//
	//   - `DatabaseAdmin.CopyBackup`
	//
	//   - Both the source and target instance configurations are subject to
	//     hourly compute and storage charges.
	//
	//   - The instance might experience higher read-write latencies and a higher
	//     transaction abort rate. However, moving an instance doesn't cause any
	//     downtime.
	//
	// The returned long-running operation has
	// a name of the format
	// `<instance_name>/operations/<operation_id>` and can be used to track
	// the move instance operation. The
	// metadata field type is
	// [MoveInstanceMetadata][google.spanner.admin.instance.v1.MoveInstanceMetadata].
	// The response field type is
	// [Instance][google.spanner.admin.instance.v1.Instance],
	// if successful.
	// Cancelling the operation sets its metadata's
	// [cancel_time][google.spanner.admin.instance.v1.MoveInstanceMetadata.cancel_time].
	// Cancellation is not immediate because it involves moving any data
	// previously moved to the target instance configuration back to the original
	// instance configuration. You can use this operation to track the progress of
	// the cancellation. Upon successful completion of the cancellation, the
	// operation terminates with `CANCELLED` status.
	//
	// If not cancelled, upon completion of the returned operation:
	//
	//   - The instance successfully moves to the target instance
	//     configuration.
	//   - You are billed for compute and storage in target instance
	//     configuration.
	//
	// Authorization requires the `spanner.instances.update` permission on
	// the resource [instance][google.spanner.admin.instance.v1.Instance].
	//
	// For more details, see
	// [Move an instance](https://cloud.google.com/spanner/docs/move-instance).
	MoveInstance(context.Context, *MoveInstanceRequest) (*longrunningpb.Operation, error)
}

// UnimplementedInstanceAdminServer should be embedded to have forward compatible implementations.
type UnimplementedInstanceAdminServer struct {
}

func (UnimplementedInstanceAdminServer) ListInstanceConfigs(context.Context, *ListInstanceConfigsRequest) (*ListInstanceConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstanceConfigs not implemented")
}
func (UnimplementedInstanceAdminServer) GetInstanceConfig(context.Context, *GetInstanceConfigRequest) (*InstanceConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstanceConfig not implemented")
}
func (UnimplementedInstanceAdminServer) CreateInstanceConfig(context.Context, *CreateInstanceConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstanceConfig not implemented")
}
func (UnimplementedInstanceAdminServer) UpdateInstanceConfig(context.Context, *UpdateInstanceConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstanceConfig not implemented")
}
func (UnimplementedInstanceAdminServer) DeleteInstanceConfig(context.Context, *DeleteInstanceConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstanceConfig not implemented")
}
func (UnimplementedInstanceAdminServer) ListInstanceConfigOperations(context.Context, *ListInstanceConfigOperationsRequest) (*ListInstanceConfigOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstanceConfigOperations not implemented")
}
func (UnimplementedInstanceAdminServer) ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (UnimplementedInstanceAdminServer) ListInstancePartitions(context.Context, *ListInstancePartitionsRequest) (*ListInstancePartitionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstancePartitions not implemented")
}
func (UnimplementedInstanceAdminServer) GetInstance(context.Context, *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (UnimplementedInstanceAdminServer) CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstance not implemented")
}
func (UnimplementedInstanceAdminServer) UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstance not implemented")
}
func (UnimplementedInstanceAdminServer) DeleteInstance(context.Context, *DeleteInstanceRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstance not implemented")
}
func (UnimplementedInstanceAdminServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedInstanceAdminServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedInstanceAdminServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedInstanceAdminServer) GetInstancePartition(context.Context, *GetInstancePartitionRequest) (*InstancePartition, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstancePartition not implemented")
}
func (UnimplementedInstanceAdminServer) CreateInstancePartition(context.Context, *CreateInstancePartitionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstancePartition not implemented")
}
func (UnimplementedInstanceAdminServer) DeleteInstancePartition(context.Context, *DeleteInstancePartitionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstancePartition not implemented")
}
func (UnimplementedInstanceAdminServer) UpdateInstancePartition(context.Context, *UpdateInstancePartitionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstancePartition not implemented")
}
func (UnimplementedInstanceAdminServer) ListInstancePartitionOperations(context.Context, *ListInstancePartitionOperationsRequest) (*ListInstancePartitionOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstancePartitionOperations not implemented")
}
func (UnimplementedInstanceAdminServer) MoveInstance(context.Context, *MoveInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MoveInstance not implemented")
}

// UnsafeInstanceAdminServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InstanceAdminServer will
// result in compilation errors.
type UnsafeInstanceAdminServer interface {
	mustEmbedUnimplementedInstanceAdminServer()
}

func RegisterInstanceAdminServer(s grpc.ServiceRegistrar, srv InstanceAdminServer) {
	s.RegisterService(&InstanceAdmin_ServiceDesc, srv)
}

func _InstanceAdmin_ListInstanceConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstanceConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).ListInstanceConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_ListInstanceConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).ListInstanceConfigs(ctx, req.(*ListInstanceConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_GetInstanceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).GetInstanceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_GetInstanceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).GetInstanceConfig(ctx, req.(*GetInstanceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_CreateInstanceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).CreateInstanceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_CreateInstanceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).CreateInstanceConfig(ctx, req.(*CreateInstanceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_UpdateInstanceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).UpdateInstanceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_UpdateInstanceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).UpdateInstanceConfig(ctx, req.(*UpdateInstanceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_DeleteInstanceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).DeleteInstanceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_DeleteInstanceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).DeleteInstanceConfig(ctx, req.(*DeleteInstanceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_ListInstanceConfigOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstanceConfigOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).ListInstanceConfigOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_ListInstanceConfigOperations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).ListInstanceConfigOperations(ctx, req.(*ListInstanceConfigOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_ListInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_ListInstancePartitions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancePartitionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).ListInstancePartitions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_ListInstancePartitions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).ListInstancePartitions(ctx, req.(*ListInstancePartitionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_GetInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_CreateInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_UpdateInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_DeleteInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_GetInstancePartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstancePartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).GetInstancePartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_GetInstancePartition_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).GetInstancePartition(ctx, req.(*GetInstancePartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_CreateInstancePartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstancePartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).CreateInstancePartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_CreateInstancePartition_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).CreateInstancePartition(ctx, req.(*CreateInstancePartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_DeleteInstancePartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstancePartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).DeleteInstancePartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_DeleteInstancePartition_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).DeleteInstancePartition(ctx, req.(*DeleteInstancePartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_UpdateInstancePartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstancePartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).UpdateInstancePartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_UpdateInstancePartition_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).UpdateInstancePartition(ctx, req.(*UpdateInstancePartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_ListInstancePartitionOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancePartitionOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).ListInstancePartitionOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_ListInstancePartitionOperations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).ListInstancePartitionOperations(ctx, req.(*ListInstancePartitionOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_MoveInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).MoveInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceAdmin_MoveInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).MoveInstance(ctx, req.(*MoveInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// InstanceAdmin_ServiceDesc is the grpc.ServiceDesc for InstanceAdmin service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var InstanceAdmin_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.spanner.admin.instance.v1.InstanceAdmin",
	HandlerType: (*InstanceAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstanceConfigs",
			Handler:    _InstanceAdmin_ListInstanceConfigs_Handler,
		},
		{
			MethodName: "GetInstanceConfig",
			Handler:    _InstanceAdmin_GetInstanceConfig_Handler,
		},
		{
			MethodName: "CreateInstanceConfig",
			Handler:    _InstanceAdmin_CreateInstanceConfig_Handler,
		},
		{
			MethodName: "UpdateInstanceConfig",
			Handler:    _InstanceAdmin_UpdateInstanceConfig_Handler,
		},
		{
			MethodName: "DeleteInstanceConfig",
			Handler:    _InstanceAdmin_DeleteInstanceConfig_Handler,
		},
		{
			MethodName: "ListInstanceConfigOperations",
			Handler:    _InstanceAdmin_ListInstanceConfigOperations_Handler,
		},
		{
			MethodName: "ListInstances",
			Handler:    _InstanceAdmin_ListInstances_Handler,
		},
		{
			MethodName: "ListInstancePartitions",
			Handler:    _InstanceAdmin_ListInstancePartitions_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _InstanceAdmin_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _InstanceAdmin_CreateInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _InstanceAdmin_UpdateInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _InstanceAdmin_DeleteInstance_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _InstanceAdmin_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _InstanceAdmin_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _InstanceAdmin_TestIamPermissions_Handler,
		},
		{
			MethodName: "GetInstancePartition",
			Handler:    _InstanceAdmin_GetInstancePartition_Handler,
		},
		{
			MethodName: "CreateInstancePartition",
			Handler:    _InstanceAdmin_CreateInstancePartition_Handler,
		},
		{
			MethodName: "DeleteInstancePartition",
			Handler:    _InstanceAdmin_DeleteInstancePartition_Handler,
		},
		{
			MethodName: "UpdateInstancePartition",
			Handler:    _InstanceAdmin_UpdateInstancePartition_Handler,
		},
		{
			MethodName: "ListInstancePartitionOperations",
			Handler:    _InstanceAdmin_ListInstancePartitionOperations_Handler,
		},
		{
			MethodName: "MoveInstance",
			Handler:    _InstanceAdmin_MoveInstance_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/spanner/admin/instance/v1/spanner_instance_admin.proto",
}
