// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/spanner/v1/location.proto

package spannerpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicates the role of the tablet.
type Tablet_Role int32

const (
	// Not specified.
	Tablet_ROLE_UNSPECIFIED Tablet_Role = 0
	// The tablet can perform reads and (if elected leader) writes.
	Tablet_READ_WRITE Tablet_Role = 1
	// The tablet can only perform reads.
	Tablet_READ_ONLY Tablet_Role = 2
)

// Enum value maps for Tablet_Role.
var (
	Tablet_Role_name = map[int32]string{
		0: "ROLE_UNSPECIFIED",
		1: "READ_WRITE",
		2: "READ_ONLY",
	}
	Tablet_Role_value = map[string]int32{
		"ROLE_UNSPECIFIED": 0,
		"READ_WRITE":       1,
		"READ_ONLY":        2,
	}
)

func (x Tablet_Role) Enum() *Tablet_Role {
	p := new(Tablet_Role)
	*p = x
	return p
}

func (x Tablet_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tablet_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_v1_location_proto_enumTypes[0].Descriptor()
}

func (Tablet_Role) Type() protoreflect.EnumType {
	return &file_google_spanner_v1_location_proto_enumTypes[0]
}

func (x Tablet_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tablet_Role.Descriptor instead.
func (Tablet_Role) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_v1_location_proto_rawDescGZIP(), []int{1, 0}
}

// The remaining fields encode column values.
type KeyRecipe_Part_Order int32

const (
	// Default value, equivalent to `ASCENDING`.
	KeyRecipe_Part_ORDER_UNSPECIFIED KeyRecipe_Part_Order = 0
	// The key is ascending - corresponds to `ASC` in the schema definition.
	KeyRecipe_Part_ASCENDING KeyRecipe_Part_Order = 1
	// The key is descending - corresponds to `DESC` in the schema definition.
	KeyRecipe_Part_DESCENDING KeyRecipe_Part_Order = 2
)

// Enum value maps for KeyRecipe_Part_Order.
var (
	KeyRecipe_Part_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ASCENDING",
		2: "DESCENDING",
	}
	KeyRecipe_Part_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED": 0,
		"ASCENDING":         1,
		"DESCENDING":        2,
	}
)

func (x KeyRecipe_Part_Order) Enum() *KeyRecipe_Part_Order {
	p := new(KeyRecipe_Part_Order)
	*p = x
	return p
}

func (x KeyRecipe_Part_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KeyRecipe_Part_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_v1_location_proto_enumTypes[1].Descriptor()
}

func (KeyRecipe_Part_Order) Type() protoreflect.EnumType {
	return &file_google_spanner_v1_location_proto_enumTypes[1]
}

func (x KeyRecipe_Part_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KeyRecipe_Part_Order.Descriptor instead.
func (KeyRecipe_Part_Order) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_v1_location_proto_rawDescGZIP(), []int{3, 0, 0}
}

// The null order of the key column. This dictates where NULL values sort
// in the sorted order. Note that columns which are `NOT NULL` can have a
// special encoding.
type KeyRecipe_Part_NullOrder int32

const (
	// Default value. This value is unused.
	KeyRecipe_Part_NULL_ORDER_UNSPECIFIED KeyRecipe_Part_NullOrder = 0
	// NULL values sort before any non-NULL values.
	KeyRecipe_Part_NULLS_FIRST KeyRecipe_Part_NullOrder = 1
	// NULL values sort after any non-NULL values.
	KeyRecipe_Part_NULLS_LAST KeyRecipe_Part_NullOrder = 2
	// The column does not support NULL values.
	KeyRecipe_Part_NOT_NULL KeyRecipe_Part_NullOrder = 3
)

// Enum value maps for KeyRecipe_Part_NullOrder.
var (
	KeyRecipe_Part_NullOrder_name = map[int32]string{
		0: "NULL_ORDER_UNSPECIFIED",
		1: "NULLS_FIRST",
		2: "NULLS_LAST",
		3: "NOT_NULL",
	}
	KeyRecipe_Part_NullOrder_value = map[string]int32{
		"NULL_ORDER_UNSPECIFIED": 0,
		"NULLS_FIRST":            1,
		"NULLS_LAST":             2,
		"NOT_NULL":               3,
	}
)

func (x KeyRecipe_Part_NullOrder) Enum() *KeyRecipe_Part_NullOrder {
	p := new(KeyRecipe_Part_NullOrder)
	*p = x
	return p
}

func (x KeyRecipe_Part_NullOrder) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KeyRecipe_Part_NullOrder) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_v1_location_proto_enumTypes[2].Descriptor()
}

func (KeyRecipe_Part_NullOrder) Type() protoreflect.EnumType {
	return &file_google_spanner_v1_location_proto_enumTypes[2]
}

func (x KeyRecipe_Part_NullOrder) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KeyRecipe_Part_NullOrder.Descriptor instead.
func (KeyRecipe_Part_NullOrder) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_v1_location_proto_rawDescGZIP(), []int{3, 0, 1}
}

// A `Range` represents a range of keys in a database. The keys themselves
// are encoded in "sortable string format", also known as ssformat. Consult
// Spanner's open source client libraries for details on the encoding.
//
// Each range represents a contiguous range of rows, possibly from multiple
// tables/indexes. Each range is associated with a single paxos group (known as
// a "group" throughout this API), a split (which names the exact range within
// the group), and a generation that can be used to determine whether a given
// `Range` represents a newer or older location for the key range.
type Range struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start key of the range, inclusive. Encoded in "sortable string format"
	// (ssformat).
	StartKey []byte `protobuf:"bytes,1,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	// The limit key of the range, exclusive. Encoded in "sortable string format"
	// (ssformat).
	LimitKey []byte `protobuf:"bytes,2,opt,name=limit_key,json=limitKey,proto3" json:"limit_key,omitempty"`
	// The UID of the paxos group where this range is stored. UIDs are unique
	// within the database. References `Group.group_uid`.
	GroupUid uint64 `protobuf:"varint,3,opt,name=group_uid,json=groupUid,proto3" json:"group_uid,omitempty"`
	// A group can store multiple ranges of keys. Each key range is named by an
	// ID (the split ID). Within a group, split IDs are unique. The `split_id`
	// names the exact split in `group_uid` where this range is stored.
	SplitId uint64 `protobuf:"varint,4,opt,name=split_id,json=splitId,proto3" json:"split_id,omitempty"`
	// `generation` indicates the freshness of the range information contained
	// in this proto. Generations can be compared lexicographically; if generation
	// A is greater than generation B, then the `Range` corresponding to A is
	// newer than the `Range` corresponding to B, and should be used
	// preferentially.
	Generation []byte `protobuf:"bytes,5,opt,name=generation,proto3" json:"generation,omitempty"`
}

func (x *Range) Reset() {
	*x = Range{}
	mi := &file_google_spanner_v1_location_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Range) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Range) ProtoMessage() {}

func (x *Range) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_location_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Range.ProtoReflect.Descriptor instead.
func (*Range) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_location_proto_rawDescGZIP(), []int{0}
}

func (x *Range) GetStartKey() []byte {
	if x != nil {
		return x.StartKey
	}
	return nil
}

func (x *Range) GetLimitKey() []byte {
	if x != nil {
		return x.LimitKey
	}
	return nil
}

func (x *Range) GetGroupUid() uint64 {
	if x != nil {
		return x.GroupUid
	}
	return 0
}

func (x *Range) GetSplitId() uint64 {
	if x != nil {
		return x.SplitId
	}
	return 0
}

func (x *Range) GetGeneration() []byte {
	if x != nil {
		return x.Generation
	}
	return nil
}

// A `Tablet` represents a single replica of a `Group`. A tablet is served by a
// single server at a time, and can move between servers due to server death or
// simply load balancing.
type Tablet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The UID of the tablet, unique within the database. Matches the
	// `tablet_uids` and `leader_tablet_uid` fields in `Group`.
	TabletUid uint64 `protobuf:"varint,1,opt,name=tablet_uid,json=tabletUid,proto3" json:"tablet_uid,omitempty"`
	// The address of the server that is serving this tablet -- either an IP
	// address or DNS hostname and a port number.
	ServerAddress string `protobuf:"bytes,2,opt,name=server_address,json=serverAddress,proto3" json:"server_address,omitempty"`
	// Where this tablet is located. This is the name of a Google Cloud region,
	// such as "us-central1".
	Location string `protobuf:"bytes,3,opt,name=location,proto3" json:"location,omitempty"`
	// The role of the tablet.
	Role Tablet_Role `protobuf:"varint,4,opt,name=role,proto3,enum=google.spanner.v1.Tablet_Role" json:"role,omitempty"`
	// `incarnation` indicates the freshness of the tablet information contained
	// in this proto. Incarnations can be compared lexicographically; if
	// incarnation A is greater than incarnation B, then the `Tablet`
	// corresponding to A is newer than the `Tablet` corresponding to B, and
	// should be used preferentially.
	Incarnation []byte `protobuf:"bytes,5,opt,name=incarnation,proto3" json:"incarnation,omitempty"`
	// Distances help the client pick the closest tablet out of the list of
	// tablets for a given request. Tablets with lower distances should generally
	// be preferred. Tablets with the same distance are approximately equally
	// close; the client can choose arbitrarily.
	//
	// Distances do not correspond precisely to expected latency, geographical
	// distance, or anything else. Distances should be compared only between
	// tablets of the same group; they are not meaningful between different
	// groups.
	//
	// A value of zero indicates that the tablet may be in the same zone as
	// the client, and have minimum network latency. A value less than or equal to
	// five indicates that the tablet is thought to be in the same region as the
	// client, and may have a few milliseconds of network latency. Values greater
	// than five are most likely in a different region, with non-trivial network
	// latency.
	//
	// Clients should use the following algorithm:
	//   - If the request is using a directed read, eliminate any tablets that
	//     do not match the directed read's target zone and/or replica type.
	//   - (Read-write transactions only) Choose leader tablet if it has an
	//     distance <=5.
	//   - Group and sort tablets by distance. Choose a random
	//     tablet with the lowest distance. If the request
	//     is not a directed read, only consider replicas with distances <=5.
	//   - Send the request to the fallback endpoint.
	//
	// The tablet picked by this algorithm may be skipped, either because it is
	// marked as `skip` by the server or because the corresponding server is
	// unreachable, flow controlled, etc. Skipped tablets should be added to the
	// `skipped_tablet_uid` field in `RoutingHint`; the algorithm above should
	// then be re-run without including the skipped tablet(s) to pick the next
	// best tablet.
	Distance uint32 `protobuf:"varint,6,opt,name=distance,proto3" json:"distance,omitempty"`
	// If true, the tablet should not be chosen by the client. Typically, this
	// signals that the tablet is unhealthy in some way. Tablets with `skip`
	// set to true should be reported back to the server in
	// `RoutingHint.skipped_tablet_uid`; this cues the server to send updated
	// information for this tablet should it become usable again.
	Skip bool `protobuf:"varint,7,opt,name=skip,proto3" json:"skip,omitempty"`
}

func (x *Tablet) Reset() {
	*x = Tablet{}
	mi := &file_google_spanner_v1_location_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tablet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tablet) ProtoMessage() {}

func (x *Tablet) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_location_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tablet.ProtoReflect.Descriptor instead.
func (*Tablet) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_location_proto_rawDescGZIP(), []int{1}
}

func (x *Tablet) GetTabletUid() uint64 {
	if x != nil {
		return x.TabletUid
	}
	return 0
}

func (x *Tablet) GetServerAddress() string {
	if x != nil {
		return x.ServerAddress
	}
	return ""
}

func (x *Tablet) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Tablet) GetRole() Tablet_Role {
	if x != nil {
		return x.Role
	}
	return Tablet_ROLE_UNSPECIFIED
}

func (x *Tablet) GetIncarnation() []byte {
	if x != nil {
		return x.Incarnation
	}
	return nil
}

func (x *Tablet) GetDistance() uint32 {
	if x != nil {
		return x.Distance
	}
	return 0
}

func (x *Tablet) GetSkip() bool {
	if x != nil {
		return x.Skip
	}
	return false
}

// A `Group` represents a paxos group in a database. A group is a set of
// tablets that are replicated across multiple servers. Groups may have a leader
// tablet. Groups store one (or sometimes more) ranges of keys.
type Group struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The UID of the paxos group, unique within the database. Matches the
	// `group_uid` field in `Range`.
	GroupUid uint64 `protobuf:"varint,1,opt,name=group_uid,json=groupUid,proto3" json:"group_uid,omitempty"`
	// A list of tablets that are part of the group. Note that this list may not
	// be exhaustive; it will only include tablets the server considers useful
	// to the client. The returned list is ordered ascending by distance.
	//
	// Tablet UIDs reference `Tablet.tablet_uid`.
	Tablets []*Tablet `protobuf:"bytes,2,rep,name=tablets,proto3" json:"tablets,omitempty"`
	// The last known leader tablet of the group as an index into `tablets`. May
	// be negative if the group has no known leader.
	LeaderIndex int32 `protobuf:"varint,3,opt,name=leader_index,json=leaderIndex,proto3" json:"leader_index,omitempty"`
	// `generation` indicates the freshness of the group information (including
	// leader information) contained in this proto. Generations can be compared
	// lexicographically; if generation A is greater than generation B, then the
	// `Group` corresponding to A is newer than the `Group` corresponding to B,
	// and should be used preferentially.
	Generation []byte `protobuf:"bytes,4,opt,name=generation,proto3" json:"generation,omitempty"`
}

func (x *Group) Reset() {
	*x = Group{}
	mi := &file_google_spanner_v1_location_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Group) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Group) ProtoMessage() {}

func (x *Group) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_location_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Group.ProtoReflect.Descriptor instead.
func (*Group) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_location_proto_rawDescGZIP(), []int{2}
}

func (x *Group) GetGroupUid() uint64 {
	if x != nil {
		return x.GroupUid
	}
	return 0
}

func (x *Group) GetTablets() []*Tablet {
	if x != nil {
		return x.Tablets
	}
	return nil
}

func (x *Group) GetLeaderIndex() int32 {
	if x != nil {
		return x.LeaderIndex
	}
	return 0
}

func (x *Group) GetGeneration() []byte {
	if x != nil {
		return x.Generation
	}
	return nil
}

// A `KeyRecipe` provides the metadata required to translate reads, mutations,
// and queries into a byte array in "sortable string format" (ssformat)that can
// be used with `Range`s to route requests. Note that the client *must* tolerate
// `KeyRecipe`s that appear to be invalid, since the `KeyRecipe` format may
// change over time. Requests with invalid `KeyRecipe`s should be routed to a
// default server.
type KeyRecipe struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A recipe can be associated with a table, index, or query. Tables recipes
	// are used to encode read and write keys; index recipes are used for index
	// reads, and query recipes are used only for SQL queries.
	//
	// Types that are assignable to Target:
	//
	//	*KeyRecipe_TableName
	//	*KeyRecipe_IndexName
	//	*KeyRecipe_OperationUid
	Target isKeyRecipe_Target `protobuf_oneof:"target"`
	// Parts are in the order they should appear in the encoded key.
	Part []*KeyRecipe_Part `protobuf:"bytes,4,rep,name=part,proto3" json:"part,omitempty"`
}

func (x *KeyRecipe) Reset() {
	*x = KeyRecipe{}
	mi := &file_google_spanner_v1_location_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KeyRecipe) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyRecipe) ProtoMessage() {}

func (x *KeyRecipe) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_location_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyRecipe.ProtoReflect.Descriptor instead.
func (*KeyRecipe) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_location_proto_rawDescGZIP(), []int{3}
}

func (m *KeyRecipe) GetTarget() isKeyRecipe_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *KeyRecipe) GetTableName() string {
	if x, ok := x.GetTarget().(*KeyRecipe_TableName); ok {
		return x.TableName
	}
	return ""
}

func (x *KeyRecipe) GetIndexName() string {
	if x, ok := x.GetTarget().(*KeyRecipe_IndexName); ok {
		return x.IndexName
	}
	return ""
}

func (x *KeyRecipe) GetOperationUid() uint64 {
	if x, ok := x.GetTarget().(*KeyRecipe_OperationUid); ok {
		return x.OperationUid
	}
	return 0
}

func (x *KeyRecipe) GetPart() []*KeyRecipe_Part {
	if x != nil {
		return x.Part
	}
	return nil
}

type isKeyRecipe_Target interface {
	isKeyRecipe_Target()
}

type KeyRecipe_TableName struct {
	// A table name, matching the name from the database schema.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3,oneof"`
}

type KeyRecipe_IndexName struct {
	// An index name, matching the name from the database schema.
	IndexName string `protobuf:"bytes,2,opt,name=index_name,json=indexName,proto3,oneof"`
}

type KeyRecipe_OperationUid struct {
	// The UID of a query, matching the UID from `RoutingHint`.
	OperationUid uint64 `protobuf:"varint,3,opt,name=operation_uid,json=operationUid,proto3,oneof"`
}

func (*KeyRecipe_TableName) isKeyRecipe_Target() {}

func (*KeyRecipe_IndexName) isKeyRecipe_Target() {}

func (*KeyRecipe_OperationUid) isKeyRecipe_Target() {}

// A `RecipeList` contains a list of `KeyRecipe`s, which share the same
// schema generation.
type RecipeList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The schema generation of the recipes. To be sent to the server in
	// `RoutingHint.schema_generation` whenever one of the recipes is used.
	// `schema_generation` values are comparable with each other; if generation A
	// compares greater than generation B, then A is a more recent schema than B.
	// Clients should in general aim to cache only the latest schema generation,
	// and discard more stale recipes.
	SchemaGeneration []byte `protobuf:"bytes,1,opt,name=schema_generation,json=schemaGeneration,proto3" json:"schema_generation,omitempty"`
	// A list of recipes to be cached.
	Recipe []*KeyRecipe `protobuf:"bytes,3,rep,name=recipe,proto3" json:"recipe,omitempty"`
}

func (x *RecipeList) Reset() {
	*x = RecipeList{}
	mi := &file_google_spanner_v1_location_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecipeList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecipeList) ProtoMessage() {}

func (x *RecipeList) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_location_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecipeList.ProtoReflect.Descriptor instead.
func (*RecipeList) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_location_proto_rawDescGZIP(), []int{4}
}

func (x *RecipeList) GetSchemaGeneration() []byte {
	if x != nil {
		return x.SchemaGeneration
	}
	return nil
}

func (x *RecipeList) GetRecipe() []*KeyRecipe {
	if x != nil {
		return x.Recipe
	}
	return nil
}

// A `CacheUpdate` expresses a set of changes the client should incorporate into
// its location cache. These changes may or may not be newer than what the
// client has in its cache, and should be discarded if necessary. `CacheUpdate`s
// can be obtained in response to requests that included a `RoutingHint`
// field, but may also be obtained by explicit location-fetching RPCs which may
// be added in the future.
type CacheUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An internal ID for the database. Database names can be reused if a database
	// is deleted and re-created. Each time the database is re-created, it will
	// get a new database ID, which will never be re-used for any other database.
	DatabaseId uint64 `protobuf:"varint,1,opt,name=database_id,json=databaseId,proto3" json:"database_id,omitempty"`
	// A list of ranges to be cached.
	Range []*Range `protobuf:"bytes,2,rep,name=range,proto3" json:"range,omitempty"`
	// A list of groups to be cached.
	Group []*Group `protobuf:"bytes,3,rep,name=group,proto3" json:"group,omitempty"`
	// A list of recipes to be cached.
	KeyRecipes *RecipeList `protobuf:"bytes,5,opt,name=key_recipes,json=keyRecipes,proto3" json:"key_recipes,omitempty"`
}

func (x *CacheUpdate) Reset() {
	*x = CacheUpdate{}
	mi := &file_google_spanner_v1_location_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CacheUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CacheUpdate) ProtoMessage() {}

func (x *CacheUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_location_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CacheUpdate.ProtoReflect.Descriptor instead.
func (*CacheUpdate) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_location_proto_rawDescGZIP(), []int{5}
}

func (x *CacheUpdate) GetDatabaseId() uint64 {
	if x != nil {
		return x.DatabaseId
	}
	return 0
}

func (x *CacheUpdate) GetRange() []*Range {
	if x != nil {
		return x.Range
	}
	return nil
}

func (x *CacheUpdate) GetGroup() []*Group {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *CacheUpdate) GetKeyRecipes() *RecipeList {
	if x != nil {
		return x.KeyRecipes
	}
	return nil
}

// `RoutingHint` can be optionally added to location-aware Spanner
// requests. It gives the server hints that can be used to route the request to
// an appropriate server, potentially significantly decreasing latency and
// improving throughput. To achieve improved performance, most fields must be
// filled in with accurate values.
//
// The presence of a valid `RoutingHint` tells the server that the client
// is location-aware.
//
// `RoutingHint` does not change the semantics of the request; it is
// purely a performance hint; the request will perform the same actions on the
// database's data as if `RoutingHint` were not present. However, if
// the `RoutingHint` is incomplete or incorrect, the response may include
// a `CacheUpdate` the client can use to correct its location cache.
type RoutingHint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A session-scoped unique ID for the operation, computed client-side.
	// Requests with the same `operation_uid` should have a shared 'shape',
	// meaning that some fields are expected to be the same, such as the SQL
	// query, the target table/columns (for reads) etc. Requests with the same
	// `operation_uid` are meant to differ only in fields like keys/key
	// ranges/query parameters, transaction IDs, etc.
	//
	// `operation_uid` must be non-zero for `RoutingHint` to be valid.
	OperationUid uint64 `protobuf:"varint,1,opt,name=operation_uid,json=operationUid,proto3" json:"operation_uid,omitempty"`
	// The database ID of the database being accessed, see
	// `CacheUpdate.database_id`. Should match the cache entries that were used
	// to generate the rest of the fields in this `RoutingHint`.
	DatabaseId uint64 `protobuf:"varint,2,opt,name=database_id,json=databaseId,proto3" json:"database_id,omitempty"`
	// The schema generation of the recipe that was used to generate `key` and
	// `limit_key`. See also `RecipeList.schema_generation`.
	SchemaGeneration []byte `protobuf:"bytes,3,opt,name=schema_generation,json=schemaGeneration,proto3" json:"schema_generation,omitempty"`
	// The key / key range that this request accesses. For operations that
	// access a single key, `key` should be set and `limit_key` should be empty.
	// For operations that access a key range, `key` and `limit_key` should both
	// be set, to the inclusive start and exclusive end of the range respectively.
	//
	// The keys are encoded in "sortable string format" (ssformat), using a
	// `KeyRecipe` that is appropriate for the request. See `KeyRecipe` for more
	// details.
	Key []byte `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	// If this request targets a key range, this is the exclusive end of the
	// range. See `key` for more details.
	LimitKey []byte `protobuf:"bytes,5,opt,name=limit_key,json=limitKey,proto3" json:"limit_key,omitempty"`
	// The group UID of the group that the client believes serves the range
	// defined by `key` and `limit_key`. See `Range.group_uid` for more details.
	GroupUid uint64 `protobuf:"varint,6,opt,name=group_uid,json=groupUid,proto3" json:"group_uid,omitempty"`
	// The split ID of the split that the client believes contains the range
	// defined by `key` and `limit_key`. See `Range.split_id` for more details.
	SplitId uint64 `protobuf:"varint,7,opt,name=split_id,json=splitId,proto3" json:"split_id,omitempty"`
	// The tablet UID of the tablet from group `group_uid` that the client
	// believes is best to serve this request. See `Group.local_tablet_uids` and
	// `Group.leader_tablet_uid`.
	TabletUid uint64 `protobuf:"varint,8,opt,name=tablet_uid,json=tabletUid,proto3" json:"tablet_uid,omitempty"`
	// If the client had multiple options for tablet selection, and some of its
	// first choices were unhealthy (e.g., the server is unreachable, or
	// `Tablet.skip` is true), this field will contain the tablet UIDs of those
	// tablets, with their incarnations. The server may include a `CacheUpdate`
	// with new locations for those tablets.
	SkippedTabletUid []*RoutingHint_SkippedTablet `protobuf:"bytes,9,rep,name=skipped_tablet_uid,json=skippedTabletUid,proto3" json:"skipped_tablet_uid,omitempty"`
	// If present, the client's current location. This should be the name of a
	// Google Cloud zone or region, such as "us-central1".
	//
	// If absent, the client's location will be assumed to be the same as the
	// location of the server the client ends up connected to.
	//
	// Locations are primarily valuable for clients that connect from regions
	// other than the ones that contain the Spanner database.
	ClientLocation string `protobuf:"bytes,10,opt,name=client_location,json=clientLocation,proto3" json:"client_location,omitempty"`
}

func (x *RoutingHint) Reset() {
	*x = RoutingHint{}
	mi := &file_google_spanner_v1_location_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RoutingHint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoutingHint) ProtoMessage() {}

func (x *RoutingHint) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_location_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoutingHint.ProtoReflect.Descriptor instead.
func (*RoutingHint) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_location_proto_rawDescGZIP(), []int{6}
}

func (x *RoutingHint) GetOperationUid() uint64 {
	if x != nil {
		return x.OperationUid
	}
	return 0
}

func (x *RoutingHint) GetDatabaseId() uint64 {
	if x != nil {
		return x.DatabaseId
	}
	return 0
}

func (x *RoutingHint) GetSchemaGeneration() []byte {
	if x != nil {
		return x.SchemaGeneration
	}
	return nil
}

func (x *RoutingHint) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *RoutingHint) GetLimitKey() []byte {
	if x != nil {
		return x.LimitKey
	}
	return nil
}

func (x *RoutingHint) GetGroupUid() uint64 {
	if x != nil {
		return x.GroupUid
	}
	return 0
}

func (x *RoutingHint) GetSplitId() uint64 {
	if x != nil {
		return x.SplitId
	}
	return 0
}

func (x *RoutingHint) GetTabletUid() uint64 {
	if x != nil {
		return x.TabletUid
	}
	return 0
}

func (x *RoutingHint) GetSkippedTabletUid() []*RoutingHint_SkippedTablet {
	if x != nil {
		return x.SkippedTabletUid
	}
	return nil
}

func (x *RoutingHint) GetClientLocation() string {
	if x != nil {
		return x.ClientLocation
	}
	return ""
}

// An ssformat key is composed of a sequence of tag numbers and key column
// values. `Part` represents a single tag or key column value.
type KeyRecipe_Part struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If non-zero, `tag` is the only field present in this `Part`. The part
	// is encoded by appending `tag` to the ssformat key.
	Tag uint32 `protobuf:"varint,1,opt,name=tag,proto3" json:"tag,omitempty"`
	// Whether the key column is sorted ascending or descending. Only present
	// if `tag` is zero.
	Order KeyRecipe_Part_Order `protobuf:"varint,2,opt,name=order,proto3,enum=google.spanner.v1.KeyRecipe_Part_Order" json:"order,omitempty"`
	// How NULLs are represented in the encoded key part. Only present if `tag`
	// is zero.
	NullOrder KeyRecipe_Part_NullOrder `protobuf:"varint,3,opt,name=null_order,json=nullOrder,proto3,enum=google.spanner.v1.KeyRecipe_Part_NullOrder" json:"null_order,omitempty"`
	// The type of the key part. Only present if `tag` is zero.
	Type *Type `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	// Only present if `tag` is zero.
	//
	// Types that are assignable to ValueType:
	//
	//	*KeyRecipe_Part_Identifier
	//	*KeyRecipe_Part_Value
	//	*KeyRecipe_Part_Random
	ValueType isKeyRecipe_Part_ValueType `protobuf_oneof:"value_type"`
	// It is a repeated field to support fetching key columns from nested
	// structs, such as `STRUCT` query parameters.
	StructIdentifiers []int32 `protobuf:"varint,7,rep,packed,name=struct_identifiers,json=structIdentifiers,proto3" json:"struct_identifiers,omitempty"`
}

func (x *KeyRecipe_Part) Reset() {
	*x = KeyRecipe_Part{}
	mi := &file_google_spanner_v1_location_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KeyRecipe_Part) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyRecipe_Part) ProtoMessage() {}

func (x *KeyRecipe_Part) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_location_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyRecipe_Part.ProtoReflect.Descriptor instead.
func (*KeyRecipe_Part) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_location_proto_rawDescGZIP(), []int{3, 0}
}

func (x *KeyRecipe_Part) GetTag() uint32 {
	if x != nil {
		return x.Tag
	}
	return 0
}

func (x *KeyRecipe_Part) GetOrder() KeyRecipe_Part_Order {
	if x != nil {
		return x.Order
	}
	return KeyRecipe_Part_ORDER_UNSPECIFIED
}

func (x *KeyRecipe_Part) GetNullOrder() KeyRecipe_Part_NullOrder {
	if x != nil {
		return x.NullOrder
	}
	return KeyRecipe_Part_NULL_ORDER_UNSPECIFIED
}

func (x *KeyRecipe_Part) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (m *KeyRecipe_Part) GetValueType() isKeyRecipe_Part_ValueType {
	if m != nil {
		return m.ValueType
	}
	return nil
}

func (x *KeyRecipe_Part) GetIdentifier() string {
	if x, ok := x.GetValueType().(*KeyRecipe_Part_Identifier); ok {
		return x.Identifier
	}
	return ""
}

func (x *KeyRecipe_Part) GetValue() *structpb.Value {
	if x, ok := x.GetValueType().(*KeyRecipe_Part_Value); ok {
		return x.Value
	}
	return nil
}

func (x *KeyRecipe_Part) GetRandom() bool {
	if x, ok := x.GetValueType().(*KeyRecipe_Part_Random); ok {
		return x.Random
	}
	return false
}

func (x *KeyRecipe_Part) GetStructIdentifiers() []int32 {
	if x != nil {
		return x.StructIdentifiers
	}
	return nil
}

type isKeyRecipe_Part_ValueType interface {
	isKeyRecipe_Part_ValueType()
}

type KeyRecipe_Part_Identifier struct {
	// `identifier` is the name of the column or query parameter.
	Identifier string `protobuf:"bytes,5,opt,name=identifier,proto3,oneof"`
}

type KeyRecipe_Part_Value struct {
	// The constant value of the key part.
	// It is present when query uses a constant as a part of the key.
	Value *structpb.Value `protobuf:"bytes,6,opt,name=value,proto3,oneof"`
}

type KeyRecipe_Part_Random struct {
	// If true, the client is responsible to fill in the value randomly.
	// It's relevant only for the INT64 type.
	Random bool `protobuf:"varint,8,opt,name=random,proto3,oneof"`
}

func (*KeyRecipe_Part_Identifier) isKeyRecipe_Part_ValueType() {}

func (*KeyRecipe_Part_Value) isKeyRecipe_Part_ValueType() {}

func (*KeyRecipe_Part_Random) isKeyRecipe_Part_ValueType() {}

// A tablet that was skipped by the client. See `Tablet.tablet_uid` and
// `Tablet.incarnation`.
type RoutingHint_SkippedTablet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The tablet UID of the tablet that was skipped. See `Tablet.tablet_uid`.
	TabletUid uint64 `protobuf:"varint,1,opt,name=tablet_uid,json=tabletUid,proto3" json:"tablet_uid,omitempty"`
	// The incarnation of the tablet that was skipped. See `Tablet.incarnation`.
	Incarnation []byte `protobuf:"bytes,2,opt,name=incarnation,proto3" json:"incarnation,omitempty"`
}

func (x *RoutingHint_SkippedTablet) Reset() {
	*x = RoutingHint_SkippedTablet{}
	mi := &file_google_spanner_v1_location_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RoutingHint_SkippedTablet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoutingHint_SkippedTablet) ProtoMessage() {}

func (x *RoutingHint_SkippedTablet) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_location_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoutingHint_SkippedTablet.ProtoReflect.Descriptor instead.
func (*RoutingHint_SkippedTablet) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_location_proto_rawDescGZIP(), []int{6, 0}
}

func (x *RoutingHint_SkippedTablet) GetTabletUid() uint64 {
	if x != nil {
		return x.TabletUid
	}
	return 0
}

func (x *RoutingHint_SkippedTablet) GetIncarnation() []byte {
	if x != nil {
		return x.Incarnation
	}
	return nil
}

var File_google_spanner_v1_location_proto protoreflect.FileDescriptor

var file_google_spanner_v1_location_proto_rawDesc = []byte{
	0x0a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x99, 0x01, 0x0a, 0x05, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x75,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x55,
	0x69, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x49, 0x64, 0x12, 0x1e, 0x0a,
	0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xad, 0x02,
	0x0a, 0x06, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x74, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x74, 0x55, 0x69, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1a,
	0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x04, 0x72, 0x6f,
	0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x69, 0x6e, 0x63, 0x61, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x0b, 0x69, 0x6e, 0x63, 0x61, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x08, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x73, 0x6b, 0x69, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x73, 0x6b, 0x69, 0x70,
	0x22, 0x3b, 0x0a, 0x04, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x4f, 0x4c, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x22, 0x9c, 0x01,
	0x0a, 0x05, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1b, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x75, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x55, 0x69, 0x64, 0x12, 0x33, 0x0a, 0x07, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74,
	0x52, 0x07, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6c, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0b, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1e, 0x0a, 0x0a,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc8, 0x05, 0x0a,
	0x09, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x09, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0d,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x04, 0x48, 0x00, 0x52, 0x0c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x55, 0x69, 0x64, 0x12, 0x35, 0x0a, 0x04, 0x70, 0x61, 0x72, 0x74, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x52, 0x04, 0x70, 0x61, 0x72, 0x74, 0x1a, 0x90, 0x04, 0x0a, 0x04, 0x50,
	0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x03, 0x74, 0x61, 0x67, 0x12, 0x3d, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x63, 0x69,
	0x70, 0x65, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x05, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x12, 0x4a, 0x0a, 0x0a, 0x6e, 0x75, 0x6c, 0x6c, 0x5f, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79,
	0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x2e, 0x4e, 0x75, 0x6c, 0x6c,
	0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x09, 0x6e, 0x75, 0x6c, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72,
	0x12, 0x2b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a,
	0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12,
	0x2e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x18, 0x0a, 0x06, 0x72, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x00, 0x52, 0x06, 0x72, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x12, 0x2d, 0x0a, 0x12, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x05, 0x52, 0x11, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x22, 0x3d, 0x0a, 0x05, 0x4f, 0x72, 0x64, 0x65,
	0x72, 0x12, 0x15, 0x0a, 0x11, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x53, 0x43, 0x45,
	0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45, 0x53, 0x43, 0x45,
	0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x22, 0x56, 0x0a, 0x09, 0x4e, 0x75, 0x6c, 0x6c, 0x4f,
	0x72, 0x64, 0x65, 0x72, 0x12, 0x1a, 0x0a, 0x16, 0x4e, 0x55, 0x4c, 0x4c, 0x5f, 0x4f, 0x52, 0x44,
	0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x55, 0x4c, 0x4c, 0x53, 0x5f, 0x46, 0x49, 0x52, 0x53, 0x54, 0x10,
	0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x55, 0x4c, 0x4c, 0x53, 0x5f, 0x4c, 0x41, 0x53, 0x54, 0x10,
	0x02, 0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x4f, 0x54, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x03, 0x42,
	0x0c, 0x0a, 0x0a, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x08, 0x0a,
	0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x6f, 0x0a, 0x0a, 0x52, 0x65, 0x63, 0x69, 0x70,
	0x65, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x10, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x06, 0x72, 0x65, 0x63, 0x69, 0x70, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65,
	0x52, 0x06, 0x72, 0x65, 0x63, 0x69, 0x70, 0x65, 0x22, 0xce, 0x01, 0x0a, 0x0b, 0x43, 0x61, 0x63,
	0x68, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x05, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x52, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x2e, 0x0a, 0x05, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x3e, 0x0a, 0x0b, 0x6b, 0x65, 0x79,
	0x5f, 0x72, 0x65, 0x63, 0x69, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x0a, 0x6b,
	0x65, 0x79, 0x52, 0x65, 0x63, 0x69, 0x70, 0x65, 0x73, 0x22, 0xdd, 0x03, 0x0a, 0x0b, 0x52, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x48, 0x69, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x69, 0x64, 0x12, 0x1f,
	0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12,
	0x2b, 0x0a, 0x11, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x10, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x1b,
	0x0a, 0x09, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x08, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x55, 0x69, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x70, 0x6c, 0x69,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x73, 0x70, 0x6c, 0x69,
	0x74, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x75, 0x69,
	0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x55,
	0x69, 0x64, 0x12, 0x5a, 0x0a, 0x12, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x74, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x48, 0x69, 0x6e, 0x74, 0x2e, 0x53,
	0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x52, 0x10, 0x73, 0x6b,
	0x69, 0x70, 0x70, 0x65, 0x64, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x55, 0x69, 0x64, 0x12, 0x27,
	0x0a, 0x0f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x50, 0x0a, 0x0d, 0x53, 0x6b, 0x69, 0x70, 0x70,
	0x65, 0x64, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x74, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x74, 0x55, 0x69, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x69, 0x6e, 0x63, 0x61, 0x72,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x69, 0x6e,
	0x63, 0x61, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0xb0, 0x01, 0x0a, 0x15, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x42, 0x0d, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x35, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x70,
	0x62, 0x3b, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x17, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_spanner_v1_location_proto_rawDescOnce sync.Once
	file_google_spanner_v1_location_proto_rawDescData = file_google_spanner_v1_location_proto_rawDesc
)

func file_google_spanner_v1_location_proto_rawDescGZIP() []byte {
	file_google_spanner_v1_location_proto_rawDescOnce.Do(func() {
		file_google_spanner_v1_location_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_spanner_v1_location_proto_rawDescData)
	})
	return file_google_spanner_v1_location_proto_rawDescData
}

var file_google_spanner_v1_location_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_spanner_v1_location_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_spanner_v1_location_proto_goTypes = []any{
	(Tablet_Role)(0),                  // 0: google.spanner.v1.Tablet.Role
	(KeyRecipe_Part_Order)(0),         // 1: google.spanner.v1.KeyRecipe.Part.Order
	(KeyRecipe_Part_NullOrder)(0),     // 2: google.spanner.v1.KeyRecipe.Part.NullOrder
	(*Range)(nil),                     // 3: google.spanner.v1.Range
	(*Tablet)(nil),                    // 4: google.spanner.v1.Tablet
	(*Group)(nil),                     // 5: google.spanner.v1.Group
	(*KeyRecipe)(nil),                 // 6: google.spanner.v1.KeyRecipe
	(*RecipeList)(nil),                // 7: google.spanner.v1.RecipeList
	(*CacheUpdate)(nil),               // 8: google.spanner.v1.CacheUpdate
	(*RoutingHint)(nil),               // 9: google.spanner.v1.RoutingHint
	(*KeyRecipe_Part)(nil),            // 10: google.spanner.v1.KeyRecipe.Part
	(*RoutingHint_SkippedTablet)(nil), // 11: google.spanner.v1.RoutingHint.SkippedTablet
	(*Type)(nil),                      // 12: google.spanner.v1.Type
	(*structpb.Value)(nil),            // 13: google.protobuf.Value
}
var file_google_spanner_v1_location_proto_depIdxs = []int32{
	0,  // 0: google.spanner.v1.Tablet.role:type_name -> google.spanner.v1.Tablet.Role
	4,  // 1: google.spanner.v1.Group.tablets:type_name -> google.spanner.v1.Tablet
	10, // 2: google.spanner.v1.KeyRecipe.part:type_name -> google.spanner.v1.KeyRecipe.Part
	6,  // 3: google.spanner.v1.RecipeList.recipe:type_name -> google.spanner.v1.KeyRecipe
	3,  // 4: google.spanner.v1.CacheUpdate.range:type_name -> google.spanner.v1.Range
	5,  // 5: google.spanner.v1.CacheUpdate.group:type_name -> google.spanner.v1.Group
	7,  // 6: google.spanner.v1.CacheUpdate.key_recipes:type_name -> google.spanner.v1.RecipeList
	11, // 7: google.spanner.v1.RoutingHint.skipped_tablet_uid:type_name -> google.spanner.v1.RoutingHint.SkippedTablet
	1,  // 8: google.spanner.v1.KeyRecipe.Part.order:type_name -> google.spanner.v1.KeyRecipe.Part.Order
	2,  // 9: google.spanner.v1.KeyRecipe.Part.null_order:type_name -> google.spanner.v1.KeyRecipe.Part.NullOrder
	12, // 10: google.spanner.v1.KeyRecipe.Part.type:type_name -> google.spanner.v1.Type
	13, // 11: google.spanner.v1.KeyRecipe.Part.value:type_name -> google.protobuf.Value
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_spanner_v1_location_proto_init() }
func file_google_spanner_v1_location_proto_init() {
	if File_google_spanner_v1_location_proto != nil {
		return
	}
	file_google_spanner_v1_type_proto_init()
	file_google_spanner_v1_location_proto_msgTypes[3].OneofWrappers = []any{
		(*KeyRecipe_TableName)(nil),
		(*KeyRecipe_IndexName)(nil),
		(*KeyRecipe_OperationUid)(nil),
	}
	file_google_spanner_v1_location_proto_msgTypes[7].OneofWrappers = []any{
		(*KeyRecipe_Part_Identifier)(nil),
		(*KeyRecipe_Part_Value)(nil),
		(*KeyRecipe_Part_Random)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_spanner_v1_location_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_spanner_v1_location_proto_goTypes,
		DependencyIndexes: file_google_spanner_v1_location_proto_depIdxs,
		EnumInfos:         file_google_spanner_v1_location_proto_enumTypes,
		MessageInfos:      file_google_spanner_v1_location_proto_msgTypes,
	}.Build()
	File_google_spanner_v1_location_proto = out.File
	file_google_spanner_v1_location_proto_rawDesc = nil
	file_google_spanner_v1_location_proto_goTypes = nil
	file_google_spanner_v1_location_proto_depIdxs = nil
}
