//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstorage_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storage/armstorage"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/97ee23a6db6078abcbec7b75bf9af8c503e9bb8b/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/BlobServicesList.json
func ExampleBlobServicesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewBlobServicesClient().NewListPager("res4410", "sto8607", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.BlobServiceItems = armstorage.BlobServiceItems{
		// 	Value: []*armstorage.BlobServiceProperties{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.Storage/storageAccounts/blobServices"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res4410/providers/Microsoft.Storage/storageAccounts/sto8607/blobServices/default"),
		// 			BlobServiceProperties: &armstorage.BlobServicePropertiesProperties{
		// 				ChangeFeed: &armstorage.ChangeFeed{
		// 					Enabled: to.Ptr(true),
		// 					RetentionInDays: to.Ptr[int32](7),
		// 				},
		// 				Cors: &armstorage.CorsRules{
		// 					CorsRules: []*armstorage.CorsRule{
		// 						{
		// 							AllowedHeaders: []*string{
		// 								to.Ptr("x-ms-meta-abc"),
		// 								to.Ptr("x-ms-meta-data*"),
		// 								to.Ptr("x-ms-meta-target*")},
		// 								AllowedMethods: []*armstorage.CorsRuleAllowedMethodsItem{
		// 									to.Ptr(armstorage.CorsRuleAllowedMethodsItemGET),
		// 									to.Ptr(armstorage.CorsRuleAllowedMethodsItemHEAD),
		// 									to.Ptr(armstorage.CorsRuleAllowedMethodsItemPOST),
		// 									to.Ptr(armstorage.CorsRuleAllowedMethodsItemOPTIONS),
		// 									to.Ptr(armstorage.CorsRuleAllowedMethodsItemMERGE),
		// 									to.Ptr(armstorage.CorsRuleAllowedMethodsItemPUT)},
		// 									AllowedOrigins: []*string{
		// 										to.Ptr("http://www.contoso.com"),
		// 										to.Ptr("http://www.fabrikam.com")},
		// 										ExposedHeaders: []*string{
		// 											to.Ptr("x-ms-meta-*")},
		// 											MaxAgeInSeconds: to.Ptr[int32](100),
		// 										},
		// 										{
		// 											AllowedHeaders: []*string{
		// 												to.Ptr("*")},
		// 												AllowedMethods: []*armstorage.CorsRuleAllowedMethodsItem{
		// 													to.Ptr(armstorage.CorsRuleAllowedMethodsItemGET)},
		// 													AllowedOrigins: []*string{
		// 														to.Ptr("*")},
		// 														ExposedHeaders: []*string{
		// 															to.Ptr("*")},
		// 															MaxAgeInSeconds: to.Ptr[int32](2),
		// 														},
		// 														{
		// 															AllowedHeaders: []*string{
		// 																to.Ptr("x-ms-meta-12345675754564*")},
		// 																AllowedMethods: []*armstorage.CorsRuleAllowedMethodsItem{
		// 																	to.Ptr(armstorage.CorsRuleAllowedMethodsItemGET),
		// 																	to.Ptr(armstorage.CorsRuleAllowedMethodsItemPUT)},
		// 																	AllowedOrigins: []*string{
		// 																		to.Ptr("http://www.abc23.com"),
		// 																		to.Ptr("https://www.fabrikam.com/*")},
		// 																		ExposedHeaders: []*string{
		// 																			to.Ptr("x-ms-meta-abc"),
		// 																			to.Ptr("x-ms-meta-data*"),
		// 																			to.Ptr("x -ms-meta-target*")},
		// 																			MaxAgeInSeconds: to.Ptr[int32](2000),
		// 																	}},
		// 																},
		// 																DefaultServiceVersion: to.Ptr("2017-07-29"),
		// 																DeleteRetentionPolicy: &armstorage.DeleteRetentionPolicy{
		// 																	Days: to.Ptr[int32](300),
		// 																	Enabled: to.Ptr(true),
		// 																},
		// 																IsVersioningEnabled: to.Ptr(true),
		// 															},
		// 															SKU: &armstorage.SKU{
		// 																Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																Tier: to.Ptr(armstorage.SKUTierStandard),
		// 															},
		// 													}},
		// 												}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/97ee23a6db6078abcbec7b75bf9af8c503e9bb8b/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/BlobServicesPutAllowPermanentDelete.json
func ExampleBlobServicesClient_SetServiceProperties_blobServicesPutAllowPermanentDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewBlobServicesClient().SetServiceProperties(ctx, "res4410", "sto8607", armstorage.BlobServiceProperties{
		BlobServiceProperties: &armstorage.BlobServicePropertiesProperties{
			DeleteRetentionPolicy: &armstorage.DeleteRetentionPolicy{
				AllowPermanentDelete: to.Ptr(true),
				Days:                 to.Ptr[int32](300),
				Enabled:              to.Ptr(true),
			},
			IsVersioningEnabled: to.Ptr(true),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BlobServiceProperties = armstorage.BlobServiceProperties{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts/blobServices"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res4410/providers/Microsoft.Storage/storageAccounts/sto8607/blobServices/default"),
	// 	BlobServiceProperties: &armstorage.BlobServicePropertiesProperties{
	// 		DeleteRetentionPolicy: &armstorage.DeleteRetentionPolicy{
	// 			AllowPermanentDelete: to.Ptr(true),
	// 			Days: to.Ptr[int32](300),
	// 			Enabled: to.Ptr(true),
	// 		},
	// 		IsVersioningEnabled: to.Ptr(true),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/97ee23a6db6078abcbec7b75bf9af8c503e9bb8b/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/BlobServicesPutLastAccessTimeBasedTracking.json
func ExampleBlobServicesClient_SetServiceProperties_blobServicesPutLastAccessTimeBasedTracking() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewBlobServicesClient().SetServiceProperties(ctx, "res4410", "sto8607", armstorage.BlobServiceProperties{
		BlobServiceProperties: &armstorage.BlobServicePropertiesProperties{
			LastAccessTimeTrackingPolicy: &armstorage.LastAccessTimeTrackingPolicy{
				Name: to.Ptr(armstorage.NameAccessTimeTracking),
				BlobType: []*string{
					to.Ptr("blockBlob")},
				Enable:                    to.Ptr(true),
				TrackingGranularityInDays: to.Ptr[int32](1),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BlobServiceProperties = armstorage.BlobServiceProperties{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts/blobServices"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res4410/providers/Microsoft.Storage/storageAccounts/sto8607/blobServices/default"),
	// 	BlobServiceProperties: &armstorage.BlobServicePropertiesProperties{
	// 		LastAccessTimeTrackingPolicy: &armstorage.LastAccessTimeTrackingPolicy{
	// 			Name: to.Ptr(armstorage.NameAccessTimeTracking),
	// 			BlobType: []*string{
	// 				to.Ptr("blockBlob")},
	// 				Enable: to.Ptr(true),
	// 				TrackingGranularityInDays: to.Ptr[int32](1),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/97ee23a6db6078abcbec7b75bf9af8c503e9bb8b/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/BlobServicesPut.json
func ExampleBlobServicesClient_SetServiceProperties_putBlobServices() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewBlobServicesClient().SetServiceProperties(ctx, "res4410", "sto8607", armstorage.BlobServiceProperties{
		BlobServiceProperties: &armstorage.BlobServicePropertiesProperties{
			ChangeFeed: &armstorage.ChangeFeed{
				Enabled:         to.Ptr(true),
				RetentionInDays: to.Ptr[int32](7),
			},
			Cors: &armstorage.CorsRules{
				CorsRules: []*armstorage.CorsRule{
					{
						AllowedHeaders: []*string{
							to.Ptr("x-ms-meta-abc"),
							to.Ptr("x-ms-meta-data*"),
							to.Ptr("x-ms-meta-target*")},
						AllowedMethods: []*armstorage.CorsRuleAllowedMethodsItem{
							to.Ptr(armstorage.CorsRuleAllowedMethodsItemGET),
							to.Ptr(armstorage.CorsRuleAllowedMethodsItemHEAD),
							to.Ptr(armstorage.CorsRuleAllowedMethodsItemPOST),
							to.Ptr(armstorage.CorsRuleAllowedMethodsItemOPTIONS),
							to.Ptr(armstorage.CorsRuleAllowedMethodsItemMERGE),
							to.Ptr(armstorage.CorsRuleAllowedMethodsItemPUT)},
						AllowedOrigins: []*string{
							to.Ptr("http://www.contoso.com"),
							to.Ptr("http://www.fabrikam.com")},
						ExposedHeaders: []*string{
							to.Ptr("x-ms-meta-*")},
						MaxAgeInSeconds: to.Ptr[int32](100),
					},
					{
						AllowedHeaders: []*string{
							to.Ptr("*")},
						AllowedMethods: []*armstorage.CorsRuleAllowedMethodsItem{
							to.Ptr(armstorage.CorsRuleAllowedMethodsItemGET)},
						AllowedOrigins: []*string{
							to.Ptr("*")},
						ExposedHeaders: []*string{
							to.Ptr("*")},
						MaxAgeInSeconds: to.Ptr[int32](2),
					},
					{
						AllowedHeaders: []*string{
							to.Ptr("x-ms-meta-12345675754564*")},
						AllowedMethods: []*armstorage.CorsRuleAllowedMethodsItem{
							to.Ptr(armstorage.CorsRuleAllowedMethodsItemGET),
							to.Ptr(armstorage.CorsRuleAllowedMethodsItemPUT)},
						AllowedOrigins: []*string{
							to.Ptr("http://www.abc23.com"),
							to.Ptr("https://www.fabrikam.com/*")},
						ExposedHeaders: []*string{
							to.Ptr("x-ms-meta-abc"),
							to.Ptr("x-ms-meta-data*"),
							to.Ptr("x -ms-meta-target*")},
						MaxAgeInSeconds: to.Ptr[int32](2000),
					}},
			},
			DefaultServiceVersion: to.Ptr("2017-07-29"),
			DeleteRetentionPolicy: &armstorage.DeleteRetentionPolicy{
				Days:    to.Ptr[int32](300),
				Enabled: to.Ptr(true),
			},
			IsVersioningEnabled: to.Ptr(true),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BlobServiceProperties = armstorage.BlobServiceProperties{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts/blobServices"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res4410/providers/Microsoft.Storage/storageAccounts/sto8607/blobServices/default"),
	// 	BlobServiceProperties: &armstorage.BlobServicePropertiesProperties{
	// 		ChangeFeed: &armstorage.ChangeFeed{
	// 			Enabled: to.Ptr(true),
	// 			RetentionInDays: to.Ptr[int32](7),
	// 		},
	// 		Cors: &armstorage.CorsRules{
	// 			CorsRules: []*armstorage.CorsRule{
	// 				{
	// 					AllowedHeaders: []*string{
	// 						to.Ptr("x-ms-meta-abc"),
	// 						to.Ptr("x-ms-meta-data*"),
	// 						to.Ptr("x-ms-meta-target*")},
	// 						AllowedMethods: []*armstorage.CorsRuleAllowedMethodsItem{
	// 							to.Ptr(armstorage.CorsRuleAllowedMethodsItemGET),
	// 							to.Ptr(armstorage.CorsRuleAllowedMethodsItemHEAD),
	// 							to.Ptr(armstorage.CorsRuleAllowedMethodsItemPOST),
	// 							to.Ptr(armstorage.CorsRuleAllowedMethodsItemOPTIONS),
	// 							to.Ptr(armstorage.CorsRuleAllowedMethodsItemMERGE),
	// 							to.Ptr(armstorage.CorsRuleAllowedMethodsItemPUT)},
	// 							AllowedOrigins: []*string{
	// 								to.Ptr("http://www.contoso.com"),
	// 								to.Ptr("http://www.fabrikam.com")},
	// 								ExposedHeaders: []*string{
	// 									to.Ptr("x-ms-meta-*")},
	// 									MaxAgeInSeconds: to.Ptr[int32](100),
	// 								},
	// 								{
	// 									AllowedHeaders: []*string{
	// 										to.Ptr("*")},
	// 										AllowedMethods: []*armstorage.CorsRuleAllowedMethodsItem{
	// 											to.Ptr(armstorage.CorsRuleAllowedMethodsItemGET)},
	// 											AllowedOrigins: []*string{
	// 												to.Ptr("*")},
	// 												ExposedHeaders: []*string{
	// 													to.Ptr("*")},
	// 													MaxAgeInSeconds: to.Ptr[int32](2),
	// 												},
	// 												{
	// 													AllowedHeaders: []*string{
	// 														to.Ptr("x-ms-meta-12345675754564*")},
	// 														AllowedMethods: []*armstorage.CorsRuleAllowedMethodsItem{
	// 															to.Ptr(armstorage.CorsRuleAllowedMethodsItemGET),
	// 															to.Ptr(armstorage.CorsRuleAllowedMethodsItemPUT)},
	// 															AllowedOrigins: []*string{
	// 																to.Ptr("http://www.abc23.com"),
	// 																to.Ptr("https://www.fabrikam.com/*")},
	// 																ExposedHeaders: []*string{
	// 																	to.Ptr("x-ms-meta-abc"),
	// 																	to.Ptr("x-ms-meta-data*"),
	// 																	to.Ptr("x -ms-meta-target*")},
	// 																	MaxAgeInSeconds: to.Ptr[int32](2000),
	// 															}},
	// 														},
	// 														DefaultServiceVersion: to.Ptr("2017-07-29"),
	// 														DeleteRetentionPolicy: &armstorage.DeleteRetentionPolicy{
	// 															Days: to.Ptr[int32](300),
	// 															Enabled: to.Ptr(true),
	// 														},
	// 														IsVersioningEnabled: to.Ptr(true),
	// 													},
	// 													SKU: &armstorage.SKU{
	// 														Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 														Tier: to.Ptr(armstorage.SKUTierStandard),
	// 													},
	// 												}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/97ee23a6db6078abcbec7b75bf9af8c503e9bb8b/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/BlobServicesGet.json
func ExampleBlobServicesClient_GetServiceProperties() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewBlobServicesClient().GetServiceProperties(ctx, "res4410", "sto8607", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BlobServiceProperties = armstorage.BlobServiceProperties{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts/blobServices"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res4410/providers/Microsoft.Storage/storageAccounts/sto8607/blobServices/default"),
	// 	BlobServiceProperties: &armstorage.BlobServicePropertiesProperties{
	// 		ChangeFeed: &armstorage.ChangeFeed{
	// 			Enabled: to.Ptr(true),
	// 			RetentionInDays: to.Ptr[int32](7),
	// 		},
	// 		Cors: &armstorage.CorsRules{
	// 			CorsRules: []*armstorage.CorsRule{
	// 				{
	// 					AllowedHeaders: []*string{
	// 						to.Ptr("x-ms-meta-abc"),
	// 						to.Ptr("x-ms-meta-data*"),
	// 						to.Ptr("x-ms-meta-target*")},
	// 						AllowedMethods: []*armstorage.CorsRuleAllowedMethodsItem{
	// 							to.Ptr(armstorage.CorsRuleAllowedMethodsItemGET),
	// 							to.Ptr(armstorage.CorsRuleAllowedMethodsItemHEAD),
	// 							to.Ptr(armstorage.CorsRuleAllowedMethodsItemPOST),
	// 							to.Ptr(armstorage.CorsRuleAllowedMethodsItemOPTIONS),
	// 							to.Ptr(armstorage.CorsRuleAllowedMethodsItemMERGE),
	// 							to.Ptr(armstorage.CorsRuleAllowedMethodsItemPUT)},
	// 							AllowedOrigins: []*string{
	// 								to.Ptr("http://www.contoso.com"),
	// 								to.Ptr("http://www.fabrikam.com")},
	// 								ExposedHeaders: []*string{
	// 									to.Ptr("x-ms-meta-*")},
	// 									MaxAgeInSeconds: to.Ptr[int32](100),
	// 								},
	// 								{
	// 									AllowedHeaders: []*string{
	// 										to.Ptr("*")},
	// 										AllowedMethods: []*armstorage.CorsRuleAllowedMethodsItem{
	// 											to.Ptr(armstorage.CorsRuleAllowedMethodsItemGET)},
	// 											AllowedOrigins: []*string{
	// 												to.Ptr("*")},
	// 												ExposedHeaders: []*string{
	// 													to.Ptr("*")},
	// 													MaxAgeInSeconds: to.Ptr[int32](2),
	// 												},
	// 												{
	// 													AllowedHeaders: []*string{
	// 														to.Ptr("x-ms-meta-12345675754564*")},
	// 														AllowedMethods: []*armstorage.CorsRuleAllowedMethodsItem{
	// 															to.Ptr(armstorage.CorsRuleAllowedMethodsItemGET),
	// 															to.Ptr(armstorage.CorsRuleAllowedMethodsItemPUT)},
	// 															AllowedOrigins: []*string{
	// 																to.Ptr("http://www.abc23.com"),
	// 																to.Ptr("https://www.fabrikam.com/*")},
	// 																ExposedHeaders: []*string{
	// 																	to.Ptr("x-ms-meta-abc"),
	// 																	to.Ptr("x-ms-meta-data*"),
	// 																	to.Ptr("x -ms-meta-target*")},
	// 																	MaxAgeInSeconds: to.Ptr[int32](2000),
	// 															}},
	// 														},
	// 														DefaultServiceVersion: to.Ptr("2017-07-29"),
	// 														DeleteRetentionPolicy: &armstorage.DeleteRetentionPolicy{
	// 															Days: to.Ptr[int32](300),
	// 															Enabled: to.Ptr(true),
	// 														},
	// 														IsVersioningEnabled: to.Ptr(true),
	// 													},
	// 													SKU: &armstorage.SKU{
	// 														Name: to.Ptr(armstorage.SKUNameStandardGRS),
	// 														Tier: to.Ptr(armstorage.SKUTierStandard),
	// 													},
	// 												}
}
