// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storage/armstorage"
	"net/http"
	"net/url"
	"regexp"
)

// TableServicesServer is a fake server for instances of the armstorage.TableServicesClient type.
type TableServicesServer struct {
	// GetServiceProperties is the fake for method TableServicesClient.GetServiceProperties
	// HTTP status codes to indicate success: http.StatusOK
	GetServiceProperties func(ctx context.Context, resourceGroupName string, accountName string, options *armstorage.TableServicesClientGetServicePropertiesOptions) (resp azfake.Responder[armstorage.TableServicesClientGetServicePropertiesResponse], errResp azfake.ErrorResponder)

	// List is the fake for method TableServicesClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceGroupName string, accountName string, options *armstorage.TableServicesClientListOptions) (resp azfake.Responder[armstorage.TableServicesClientListResponse], errResp azfake.ErrorResponder)

	// SetServiceProperties is the fake for method TableServicesClient.SetServiceProperties
	// HTTP status codes to indicate success: http.StatusOK
	SetServiceProperties func(ctx context.Context, resourceGroupName string, accountName string, parameters armstorage.TableServiceProperties, options *armstorage.TableServicesClientSetServicePropertiesOptions) (resp azfake.Responder[armstorage.TableServicesClientSetServicePropertiesResponse], errResp azfake.ErrorResponder)
}

// NewTableServicesServerTransport creates a new instance of TableServicesServerTransport with the provided implementation.
// The returned TableServicesServerTransport instance is connected to an instance of armstorage.TableServicesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTableServicesServerTransport(srv *TableServicesServer) *TableServicesServerTransport {
	return &TableServicesServerTransport{srv: srv}
}

// TableServicesServerTransport connects instances of armstorage.TableServicesClient to instances of TableServicesServer.
// Don't use this type directly, use NewTableServicesServerTransport instead.
type TableServicesServerTransport struct {
	srv *TableServicesServer
}

// Do implements the policy.Transporter interface for TableServicesServerTransport.
func (t *TableServicesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	return t.dispatchToMethodFake(req, method)
}

func (t *TableServicesServerTransport) dispatchToMethodFake(req *http.Request, method string) (*http.Response, error) {
	resultChan := make(chan result)
	defer close(resultChan)

	go func() {
		var intercepted bool
		var res result
		if tableServicesServerTransportInterceptor != nil {
			res.resp, res.err, intercepted = tableServicesServerTransportInterceptor.Do(req)
		}
		if !intercepted {
			switch method {
			case "TableServicesClient.GetServiceProperties":
				res.resp, res.err = t.dispatchGetServiceProperties(req)
			case "TableServicesClient.List":
				res.resp, res.err = t.dispatchList(req)
			case "TableServicesClient.SetServiceProperties":
				res.resp, res.err = t.dispatchSetServiceProperties(req)
			default:
				res.err = fmt.Errorf("unhandled API %s", method)
			}

		}
		select {
		case resultChan <- res:
		case <-req.Context().Done():
		}
	}()

	select {
	case <-req.Context().Done():
		return nil, req.Context().Err()
	case res := <-resultChan:
		return res.resp, res.err
	}
}

func (t *TableServicesServerTransport) dispatchGetServiceProperties(req *http.Request) (*http.Response, error) {
	if t.srv.GetServiceProperties == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetServiceProperties not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tableServices/(?P<tableServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.GetServiceProperties(req.Context(), resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TableServiceProperties, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TableServicesServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if t.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tableServices`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.List(req.Context(), resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ListTableServices, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TableServicesServerTransport) dispatchSetServiceProperties(req *http.Request) (*http.Response, error) {
	if t.srv.SetServiceProperties == nil {
		return nil, &nonRetriableError{errors.New("fake for method SetServiceProperties not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tableServices/(?P<tableServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorage.TableServiceProperties](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.SetServiceProperties(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TableServiceProperties, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// set this to conditionally intercept incoming requests to TableServicesServerTransport
var tableServicesServerTransportInterceptor interface {
	// Do returns true if the server transport should use the returned response/error
	Do(*http.Request) (*http.Response, error, bool)
}
