//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstorage_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storage/armstorage"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/97ee23a6db6078abcbec7b75bf9af8c503e9bb8b/specification/storage/resource-manager/Microsoft.Storage/stable/2024-01-01/examples/SKUList.json
func ExampleSKUsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSKUsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SKUListResult = armstorage.SKUListResult{
		// 	Value: []*armstorage.SKUInformation{
		// 		{
		// 			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 			Capabilities: []*armstorage.SKUCapability{
		// 				{
		// 					Name: to.Ptr("supportsfileencryption"),
		// 					Value: to.Ptr("true"),
		// 				},
		// 				{
		// 					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 					Value: to.Ptr("true"),
		// 				},
		// 				{
		// 					Name: to.Ptr("supportsnetworkacls"),
		// 					Value: to.Ptr("false"),
		// 			}},
		// 			Kind: to.Ptr(armstorage.KindStorage),
		// 			Locations: []*string{
		// 				to.Ptr("eastus")},
		// 				ResourceType: to.Ptr("storageAccounts"),
		// 				Restrictions: []*armstorage.Restriction{
		// 				},
		// 				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 			},
		// 			{
		// 				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 				Capabilities: []*armstorage.SKUCapability{
		// 					{
		// 						Name: to.Ptr("supportsfileencryption"),
		// 						Value: to.Ptr("true"),
		// 					},
		// 					{
		// 						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 						Value: to.Ptr("true"),
		// 					},
		// 					{
		// 						Name: to.Ptr("supportsnetworkacls"),
		// 						Value: to.Ptr("false"),
		// 				}},
		// 				Kind: to.Ptr(armstorage.KindStorage),
		// 				Locations: []*string{
		// 					to.Ptr("eastus")},
		// 					ResourceType: to.Ptr("storageAccounts"),
		// 					Restrictions: []*armstorage.Restriction{
		// 					},
		// 					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 				},
		// 				{
		// 					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 					Capabilities: []*armstorage.SKUCapability{
		// 						{
		// 							Name: to.Ptr("supportsfileencryption"),
		// 							Value: to.Ptr("true"),
		// 						},
		// 						{
		// 							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 							Value: to.Ptr("true"),
		// 						},
		// 						{
		// 							Name: to.Ptr("supportsnetworkacls"),
		// 							Value: to.Ptr("false"),
		// 					}},
		// 					Kind: to.Ptr(armstorage.KindStorage),
		// 					Locations: []*string{
		// 						to.Ptr("eastus")},
		// 						ResourceType: to.Ptr("storageAccounts"),
		// 						Restrictions: []*armstorage.Restriction{
		// 						},
		// 						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 					},
		// 					{
		// 						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 						Capabilities: []*armstorage.SKUCapability{
		// 							{
		// 								Name: to.Ptr("supportsfileencryption"),
		// 								Value: to.Ptr("true"),
		// 							},
		// 							{
		// 								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 								Value: to.Ptr("true"),
		// 							},
		// 							{
		// 								Name: to.Ptr("supportsnetworkacls"),
		// 								Value: to.Ptr("false"),
		// 						}},
		// 						Kind: to.Ptr(armstorage.KindStorage),
		// 						Locations: []*string{
		// 							to.Ptr("eastus")},
		// 							ResourceType: to.Ptr("storageAccounts"),
		// 							Restrictions: []*armstorage.Restriction{
		// 							},
		// 							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 						},
		// 						{
		// 							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 							Capabilities: []*armstorage.SKUCapability{
		// 								{
		// 									Name: to.Ptr("supportsfileencryption"),
		// 									Value: to.Ptr("false"),
		// 								},
		// 								{
		// 									Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 									Value: to.Ptr("true"),
		// 								},
		// 								{
		// 									Name: to.Ptr("supportsnetworkacls"),
		// 									Value: to.Ptr("false"),
		// 							}},
		// 							Kind: to.Ptr(armstorage.KindStorage),
		// 							Locations: []*string{
		// 								to.Ptr("eastus")},
		// 								ResourceType: to.Ptr("storageAccounts"),
		// 								Restrictions: []*armstorage.Restriction{
		// 								},
		// 								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 							},
		// 							{
		// 								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 								Capabilities: []*armstorage.SKUCapability{
		// 									{
		// 										Name: to.Ptr("supportsarchivepreview"),
		// 										Value: to.Ptr("false"),
		// 									},
		// 									{
		// 										Name: to.Ptr("supportschangenotification"),
		// 										Value: to.Ptr("false"),
		// 									},
		// 									{
		// 										Name: to.Ptr("supportsfileencryption"),
		// 										Value: to.Ptr("false"),
		// 									},
		// 									{
		// 										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 										Value: to.Ptr("true"),
		// 									},
		// 									{
		// 										Name: to.Ptr("supportsnetworkacls"),
		// 										Value: to.Ptr("false"),
		// 								}},
		// 								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 								Locations: []*string{
		// 									to.Ptr("eastus")},
		// 									ResourceType: to.Ptr("storageAccounts"),
		// 									Restrictions: []*armstorage.Restriction{
		// 									},
		// 									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 								},
		// 								{
		// 									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 									Capabilities: []*armstorage.SKUCapability{
		// 										{
		// 											Name: to.Ptr("supportschangenotification"),
		// 											Value: to.Ptr("false"),
		// 										},
		// 										{
		// 											Name: to.Ptr("supportsfileencryption"),
		// 											Value: to.Ptr("false"),
		// 										},
		// 										{
		// 											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 											Value: to.Ptr("true"),
		// 										},
		// 										{
		// 											Name: to.Ptr("supportsnetworkacls"),
		// 											Value: to.Ptr("false"),
		// 									}},
		// 									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 									Locations: []*string{
		// 										to.Ptr("eastus")},
		// 										ResourceType: to.Ptr("storageAccounts"),
		// 										Restrictions: []*armstorage.Restriction{
		// 										},
		// 										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 									},
		// 									{
		// 										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 										Capabilities: []*armstorage.SKUCapability{
		// 											{
		// 												Name: to.Ptr("supportschangenotification"),
		// 												Value: to.Ptr("false"),
		// 											},
		// 											{
		// 												Name: to.Ptr("supportsfileencryption"),
		// 												Value: to.Ptr("false"),
		// 											},
		// 											{
		// 												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 												Value: to.Ptr("true"),
		// 											},
		// 											{
		// 												Name: to.Ptr("supportsnetworkacls"),
		// 												Value: to.Ptr("false"),
		// 										}},
		// 										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 										Locations: []*string{
		// 											to.Ptr("eastus")},
		// 											ResourceType: to.Ptr("storageAccounts"),
		// 											Restrictions: []*armstorage.Restriction{
		// 											},
		// 											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 										},
		// 										{
		// 											Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 											Capabilities: []*armstorage.SKUCapability{
		// 												{
		// 													Name: to.Ptr("supportsfileencryption"),
		// 													Value: to.Ptr("true"),
		// 												},
		// 												{
		// 													Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 													Value: to.Ptr("true"),
		// 												},
		// 												{
		// 													Name: to.Ptr("supportsnetworkacls"),
		// 													Value: to.Ptr("false"),
		// 											}},
		// 											Kind: to.Ptr(armstorage.KindStorage),
		// 											Locations: []*string{
		// 												to.Ptr("eastus2")},
		// 												ResourceType: to.Ptr("storageAccounts"),
		// 												Restrictions: []*armstorage.Restriction{
		// 												},
		// 												Tier: to.Ptr(armstorage.SKUTierStandard),
		// 											},
		// 											{
		// 												Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 												Capabilities: []*armstorage.SKUCapability{
		// 													{
		// 														Name: to.Ptr("supportsfileencryption"),
		// 														Value: to.Ptr("true"),
		// 													},
		// 													{
		// 														Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 														Value: to.Ptr("true"),
		// 													},
		// 													{
		// 														Name: to.Ptr("supportsnetworkacls"),
		// 														Value: to.Ptr("false"),
		// 												}},
		// 												Kind: to.Ptr(armstorage.KindStorage),
		// 												Locations: []*string{
		// 													to.Ptr("eastus2")},
		// 													ResourceType: to.Ptr("storageAccounts"),
		// 													Restrictions: []*armstorage.Restriction{
		// 													},
		// 													Tier: to.Ptr(armstorage.SKUTierStandard),
		// 												},
		// 												{
		// 													Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 													Capabilities: []*armstorage.SKUCapability{
		// 														{
		// 															Name: to.Ptr("supportsfileencryption"),
		// 															Value: to.Ptr("true"),
		// 														},
		// 														{
		// 															Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 															Value: to.Ptr("true"),
		// 														},
		// 														{
		// 															Name: to.Ptr("supportsnetworkacls"),
		// 															Value: to.Ptr("false"),
		// 													}},
		// 													Kind: to.Ptr(armstorage.KindStorage),
		// 													Locations: []*string{
		// 														to.Ptr("eastus2")},
		// 														ResourceType: to.Ptr("storageAccounts"),
		// 														Restrictions: []*armstorage.Restriction{
		// 														},
		// 														Tier: to.Ptr(armstorage.SKUTierStandard),
		// 													},
		// 													{
		// 														Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 														Capabilities: []*armstorage.SKUCapability{
		// 															{
		// 																Name: to.Ptr("supportsfileencryption"),
		// 																Value: to.Ptr("true"),
		// 															},
		// 															{
		// 																Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																Value: to.Ptr("true"),
		// 															},
		// 															{
		// 																Name: to.Ptr("supportsnetworkacls"),
		// 																Value: to.Ptr("false"),
		// 														}},
		// 														Kind: to.Ptr(armstorage.KindStorage),
		// 														Locations: []*string{
		// 															to.Ptr("eastus2")},
		// 															ResourceType: to.Ptr("storageAccounts"),
		// 															Restrictions: []*armstorage.Restriction{
		// 															},
		// 															Tier: to.Ptr(armstorage.SKUTierStandard),
		// 														},
		// 														{
		// 															Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 															Capabilities: []*armstorage.SKUCapability{
		// 																{
		// 																	Name: to.Ptr("supportsfileencryption"),
		// 																	Value: to.Ptr("false"),
		// 																},
		// 																{
		// 																	Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																	Value: to.Ptr("true"),
		// 																},
		// 																{
		// 																	Name: to.Ptr("supportsnetworkacls"),
		// 																	Value: to.Ptr("false"),
		// 															}},
		// 															Kind: to.Ptr(armstorage.KindStorage),
		// 															Locations: []*string{
		// 																to.Ptr("eastus2")},
		// 																ResourceType: to.Ptr("storageAccounts"),
		// 																Restrictions: []*armstorage.Restriction{
		// 																},
		// 																Tier: to.Ptr(armstorage.SKUTierPremium),
		// 															},
		// 															{
		// 																Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																Capabilities: []*armstorage.SKUCapability{
		// 																	{
		// 																		Name: to.Ptr("supportsarchivepreview"),
		// 																		Value: to.Ptr("true"),
		// 																	},
		// 																	{
		// 																		Name: to.Ptr("supportschangenotification"),
		// 																		Value: to.Ptr("false"),
		// 																	},
		// 																	{
		// 																		Name: to.Ptr("supportsfileencryption"),
		// 																		Value: to.Ptr("false"),
		// 																	},
		// 																	{
		// 																		Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																		Value: to.Ptr("true"),
		// 																	},
		// 																	{
		// 																		Name: to.Ptr("supportsnetworkacls"),
		// 																		Value: to.Ptr("false"),
		// 																}},
		// 																Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																Locations: []*string{
		// 																	to.Ptr("eastus2")},
		// 																	ResourceType: to.Ptr("storageAccounts"),
		// 																	Restrictions: []*armstorage.Restriction{
		// 																	},
		// 																	Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																},
		// 																{
		// 																	Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																	Capabilities: []*armstorage.SKUCapability{
		// 																		{
		// 																			Name: to.Ptr("supportschangenotification"),
		// 																			Value: to.Ptr("false"),
		// 																		},
		// 																		{
		// 																			Name: to.Ptr("supportsfileencryption"),
		// 																			Value: to.Ptr("false"),
		// 																		},
		// 																		{
		// 																			Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																			Value: to.Ptr("true"),
		// 																		},
		// 																		{
		// 																			Name: to.Ptr("supportsnetworkacls"),
		// 																			Value: to.Ptr("false"),
		// 																	}},
		// 																	Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																	Locations: []*string{
		// 																		to.Ptr("eastus2")},
		// 																		ResourceType: to.Ptr("storageAccounts"),
		// 																		Restrictions: []*armstorage.Restriction{
		// 																		},
		// 																		Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																	},
		// 																	{
		// 																		Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																		Capabilities: []*armstorage.SKUCapability{
		// 																			{
		// 																				Name: to.Ptr("supportschangenotification"),
		// 																				Value: to.Ptr("false"),
		// 																			},
		// 																			{
		// 																				Name: to.Ptr("supportsfileencryption"),
		// 																				Value: to.Ptr("false"),
		// 																			},
		// 																			{
		// 																				Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																				Value: to.Ptr("true"),
		// 																			},
		// 																			{
		// 																				Name: to.Ptr("supportsnetworkacls"),
		// 																				Value: to.Ptr("false"),
		// 																		}},
		// 																		Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																		Locations: []*string{
		// 																			to.Ptr("eastus2")},
		// 																			ResourceType: to.Ptr("storageAccounts"),
		// 																			Restrictions: []*armstorage.Restriction{
		// 																			},
		// 																			Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																		},
		// 																		{
		// 																			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																			Capabilities: []*armstorage.SKUCapability{
		// 																				{
		// 																					Name: to.Ptr("supportsfileencryption"),
		// 																					Value: to.Ptr("true"),
		// 																				},
		// 																				{
		// 																					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																					Value: to.Ptr("false"),
		// 																				},
		// 																				{
		// 																					Name: to.Ptr("supportsnetworkacls"),
		// 																					Value: to.Ptr("true"),
		// 																			}},
		// 																			Kind: to.Ptr(armstorage.KindStorage),
		// 																			Locations: []*string{
		// 																				to.Ptr("eastus2(stage)")},
		// 																				ResourceType: to.Ptr("storageAccounts"),
		// 																				Restrictions: []*armstorage.Restriction{
		// 																				},
		// 																				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																			},
		// 																			{
		// 																				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																				Capabilities: []*armstorage.SKUCapability{
		// 																					{
		// 																						Name: to.Ptr("supportsfileencryption"),
		// 																						Value: to.Ptr("true"),
		// 																					},
		// 																					{
		// 																						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																						Value: to.Ptr("false"),
		// 																					},
		// 																					{
		// 																						Name: to.Ptr("supportsnetworkacls"),
		// 																						Value: to.Ptr("true"),
		// 																				}},
		// 																				Kind: to.Ptr(armstorage.KindStorage),
		// 																				Locations: []*string{
		// 																					to.Ptr("eastus2(stage)")},
		// 																					ResourceType: to.Ptr("storageAccounts"),
		// 																					Restrictions: []*armstorage.Restriction{
		// 																					},
		// 																					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																				},
		// 																				{
		// 																					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																					Capabilities: []*armstorage.SKUCapability{
		// 																						{
		// 																							Name: to.Ptr("supportsfileencryption"),
		// 																							Value: to.Ptr("true"),
		// 																						},
		// 																						{
		// 																							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																							Value: to.Ptr("false"),
		// 																						},
		// 																						{
		// 																							Name: to.Ptr("supportsnetworkacls"),
		// 																							Value: to.Ptr("true"),
		// 																					}},
		// 																					Kind: to.Ptr(armstorage.KindStorage),
		// 																					Locations: []*string{
		// 																						to.Ptr("eastus2(stage)")},
		// 																						ResourceType: to.Ptr("storageAccounts"),
		// 																						Restrictions: []*armstorage.Restriction{
		// 																						},
		// 																						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																					},
		// 																					{
		// 																						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																						Capabilities: []*armstorage.SKUCapability{
		// 																							{
		// 																								Name: to.Ptr("supportsfileencryption"),
		// 																								Value: to.Ptr("true"),
		// 																							},
		// 																							{
		// 																								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																								Value: to.Ptr("false"),
		// 																							},
		// 																							{
		// 																								Name: to.Ptr("supportsnetworkacls"),
		// 																								Value: to.Ptr("false"),
		// 																						}},
		// 																						Kind: to.Ptr(armstorage.KindStorage),
		// 																						Locations: []*string{
		// 																							to.Ptr("eastus2(stage)")},
		// 																							ResourceType: to.Ptr("storageAccounts"),
		// 																							Restrictions: []*armstorage.Restriction{
		// 																							},
		// 																							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																						},
		// 																						{
		// 																							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																							Capabilities: []*armstorage.SKUCapability{
		// 																								{
		// 																									Name: to.Ptr("supportsnetworkacls"),
		// 																									Value: to.Ptr("true"),
		// 																							}},
		// 																							Kind: to.Ptr(armstorage.KindStorage),
		// 																							Locations: []*string{
		// 																								to.Ptr("eastus2(stage)")},
		// 																								ResourceType: to.Ptr("storageAccounts"),
		// 																								Restrictions: []*armstorage.Restriction{
		// 																								},
		// 																								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																							},
		// 																							{
		// 																								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																								Capabilities: []*armstorage.SKUCapability{
		// 																									{
		// 																										Name: to.Ptr("supportsarchivepreview"),
		// 																										Value: to.Ptr("false"),
		// 																									},
		// 																									{
		// 																										Name: to.Ptr("supportschangenotification"),
		// 																										Value: to.Ptr("true"),
		// 																									},
		// 																									{
		// 																										Name: to.Ptr("supportsfileencryption"),
		// 																										Value: to.Ptr("false"),
		// 																									},
		// 																									{
		// 																										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																										Value: to.Ptr("false"),
		// 																									},
		// 																									{
		// 																										Name: to.Ptr("supportsnetworkacls"),
		// 																										Value: to.Ptr("true"),
		// 																								}},
		// 																								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																								Locations: []*string{
		// 																									to.Ptr("eastus2(stage)")},
		// 																									ResourceType: to.Ptr("storageAccounts"),
		// 																									Restrictions: []*armstorage.Restriction{
		// 																									},
		// 																									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																								},
		// 																								{
		// 																									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																									Capabilities: []*armstorage.SKUCapability{
		// 																										{
		// 																											Name: to.Ptr("supportschangenotification"),
		// 																											Value: to.Ptr("true"),
		// 																										},
		// 																										{
		// 																											Name: to.Ptr("supportsfileencryption"),
		// 																											Value: to.Ptr("false"),
		// 																										},
		// 																										{
		// 																											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																											Value: to.Ptr("false"),
		// 																										},
		// 																										{
		// 																											Name: to.Ptr("supportsnetworkacls"),
		// 																											Value: to.Ptr("true"),
		// 																									}},
		// 																									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																									Locations: []*string{
		// 																										to.Ptr("eastus2(stage)")},
		// 																										ResourceType: to.Ptr("storageAccounts"),
		// 																										Restrictions: []*armstorage.Restriction{
		// 																										},
		// 																										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																									},
		// 																									{
		// 																										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																										Capabilities: []*armstorage.SKUCapability{
		// 																											{
		// 																												Name: to.Ptr("supportschangenotification"),
		// 																												Value: to.Ptr("true"),
		// 																											},
		// 																											{
		// 																												Name: to.Ptr("supportsfileencryption"),
		// 																												Value: to.Ptr("false"),
		// 																											},
		// 																											{
		// 																												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																												Value: to.Ptr("false"),
		// 																											},
		// 																											{
		// 																												Name: to.Ptr("supportsnetworkacls"),
		// 																												Value: to.Ptr("false"),
		// 																										}},
		// 																										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																										Locations: []*string{
		// 																											to.Ptr("eastus2(stage)")},
		// 																											ResourceType: to.Ptr("storageAccounts"),
		// 																											Restrictions: []*armstorage.Restriction{
		// 																											},
		// 																											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																										},
		// 																										{
		// 																											Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																											Capabilities: []*armstorage.SKUCapability{
		// 																												{
		// 																													Name: to.Ptr("supportsfileencryption"),
		// 																													Value: to.Ptr("true"),
		// 																												},
		// 																												{
		// 																													Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																													Value: to.Ptr("true"),
		// 																												},
		// 																												{
		// 																													Name: to.Ptr("supportsnetworkacls"),
		// 																													Value: to.Ptr("false"),
		// 																											}},
		// 																											Kind: to.Ptr(armstorage.KindStorage),
		// 																											Locations: []*string{
		// 																												to.Ptr("westus")},
		// 																												ResourceType: to.Ptr("storageAccounts"),
		// 																												Restrictions: []*armstorage.Restriction{
		// 																												},
		// 																												Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																											},
		// 																											{
		// 																												Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																												Capabilities: []*armstorage.SKUCapability{
		// 																													{
		// 																														Name: to.Ptr("supportsfileencryption"),
		// 																														Value: to.Ptr("true"),
		// 																													},
		// 																													{
		// 																														Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																														Value: to.Ptr("true"),
		// 																													},
		// 																													{
		// 																														Name: to.Ptr("supportsnetworkacls"),
		// 																														Value: to.Ptr("false"),
		// 																												}},
		// 																												Kind: to.Ptr(armstorage.KindStorage),
		// 																												Locations: []*string{
		// 																													to.Ptr("westus")},
		// 																													ResourceType: to.Ptr("storageAccounts"),
		// 																													Restrictions: []*armstorage.Restriction{
		// 																													},
		// 																													Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																												},
		// 																												{
		// 																													Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																													Capabilities: []*armstorage.SKUCapability{
		// 																														{
		// 																															Name: to.Ptr("supportsfileencryption"),
		// 																															Value: to.Ptr("true"),
		// 																														},
		// 																														{
		// 																															Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																															Value: to.Ptr("true"),
		// 																														},
		// 																														{
		// 																															Name: to.Ptr("supportsnetworkacls"),
		// 																															Value: to.Ptr("false"),
		// 																													}},
		// 																													Kind: to.Ptr(armstorage.KindStorage),
		// 																													Locations: []*string{
		// 																														to.Ptr("westus")},
		// 																														ResourceType: to.Ptr("storageAccounts"),
		// 																														Restrictions: []*armstorage.Restriction{
		// 																														},
		// 																														Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																													},
		// 																													{
		// 																														Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																														Capabilities: []*armstorage.SKUCapability{
		// 																															{
		// 																																Name: to.Ptr("supportsfileencryption"),
		// 																																Value: to.Ptr("true"),
		// 																															},
		// 																															{
		// 																																Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																Value: to.Ptr("true"),
		// 																															},
		// 																															{
		// 																																Name: to.Ptr("supportsnetworkacls"),
		// 																																Value: to.Ptr("false"),
		// 																														}},
		// 																														Kind: to.Ptr(armstorage.KindStorage),
		// 																														Locations: []*string{
		// 																															to.Ptr("westus")},
		// 																															ResourceType: to.Ptr("storageAccounts"),
		// 																															Restrictions: []*armstorage.Restriction{
		// 																															},
		// 																															Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																														},
		// 																														{
		// 																															Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																															Capabilities: []*armstorage.SKUCapability{
		// 																																{
		// 																																	Name: to.Ptr("supportsfileencryption"),
		// 																																	Value: to.Ptr("false"),
		// 																																},
		// 																																{
		// 																																	Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																	Value: to.Ptr("true"),
		// 																																},
		// 																																{
		// 																																	Name: to.Ptr("supportsnetworkacls"),
		// 																																	Value: to.Ptr("false"),
		// 																															}},
		// 																															Kind: to.Ptr(armstorage.KindStorage),
		// 																															Locations: []*string{
		// 																																to.Ptr("westus")},
		// 																																ResourceType: to.Ptr("storageAccounts"),
		// 																																Restrictions: []*armstorage.Restriction{
		// 																																},
		// 																																Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																															},
		// 																															{
		// 																																Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																Capabilities: []*armstorage.SKUCapability{
		// 																																	{
		// 																																		Name: to.Ptr("supportsarchivepreview"),
		// 																																		Value: to.Ptr("false"),
		// 																																	},
		// 																																	{
		// 																																		Name: to.Ptr("supportschangenotification"),
		// 																																		Value: to.Ptr("false"),
		// 																																	},
		// 																																	{
		// 																																		Name: to.Ptr("supportsfileencryption"),
		// 																																		Value: to.Ptr("false"),
		// 																																	},
		// 																																	{
		// 																																		Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																		Value: to.Ptr("true"),
		// 																																	},
		// 																																	{
		// 																																		Name: to.Ptr("supportsnetworkacls"),
		// 																																		Value: to.Ptr("false"),
		// 																																}},
		// 																																Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																Locations: []*string{
		// 																																	to.Ptr("westus")},
		// 																																	ResourceType: to.Ptr("storageAccounts"),
		// 																																	Restrictions: []*armstorage.Restriction{
		// 																																	},
		// 																																	Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																},
		// 																																{
		// 																																	Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																	Capabilities: []*armstorage.SKUCapability{
		// 																																		{
		// 																																			Name: to.Ptr("supportschangenotification"),
		// 																																			Value: to.Ptr("false"),
		// 																																		},
		// 																																		{
		// 																																			Name: to.Ptr("supportsfileencryption"),
		// 																																			Value: to.Ptr("false"),
		// 																																		},
		// 																																		{
		// 																																			Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																			Value: to.Ptr("true"),
		// 																																		},
		// 																																		{
		// 																																			Name: to.Ptr("supportsnetworkacls"),
		// 																																			Value: to.Ptr("false"),
		// 																																	}},
		// 																																	Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																	Locations: []*string{
		// 																																		to.Ptr("westus")},
		// 																																		ResourceType: to.Ptr("storageAccounts"),
		// 																																		Restrictions: []*armstorage.Restriction{
		// 																																		},
		// 																																		Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																	},
		// 																																	{
		// 																																		Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																		Capabilities: []*armstorage.SKUCapability{
		// 																																			{
		// 																																				Name: to.Ptr("supportschangenotification"),
		// 																																				Value: to.Ptr("false"),
		// 																																			},
		// 																																			{
		// 																																				Name: to.Ptr("supportsfileencryption"),
		// 																																				Value: to.Ptr("false"),
		// 																																			},
		// 																																			{
		// 																																				Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																				Value: to.Ptr("true"),
		// 																																			},
		// 																																			{
		// 																																				Name: to.Ptr("supportsnetworkacls"),
		// 																																				Value: to.Ptr("false"),
		// 																																		}},
		// 																																		Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																		Locations: []*string{
		// 																																			to.Ptr("westus")},
		// 																																			ResourceType: to.Ptr("storageAccounts"),
		// 																																			Restrictions: []*armstorage.Restriction{
		// 																																			},
		// 																																			Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																		},
		// 																																		{
		// 																																			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																			Capabilities: []*armstorage.SKUCapability{
		// 																																				{
		// 																																					Name: to.Ptr("supportsfileencryption"),
		// 																																					Value: to.Ptr("true"),
		// 																																				},
		// 																																				{
		// 																																					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																					Value: to.Ptr("false"),
		// 																																				},
		// 																																				{
		// 																																					Name: to.Ptr("supportsnetworkacls"),
		// 																																					Value: to.Ptr("false"),
		// 																																			}},
		// 																																			Kind: to.Ptr(armstorage.KindStorage),
		// 																																			Locations: []*string{
		// 																																				to.Ptr("westeurope")},
		// 																																				ResourceType: to.Ptr("storageAccounts"),
		// 																																				Restrictions: []*armstorage.Restriction{
		// 																																				},
		// 																																				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																			},
		// 																																			{
		// 																																				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																				Capabilities: []*armstorage.SKUCapability{
		// 																																					{
		// 																																						Name: to.Ptr("supportsfileencryption"),
		// 																																						Value: to.Ptr("true"),
		// 																																					},
		// 																																					{
		// 																																						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																						Value: to.Ptr("false"),
		// 																																					},
		// 																																					{
		// 																																						Name: to.Ptr("supportsnetworkacls"),
		// 																																						Value: to.Ptr("false"),
		// 																																				}},
		// 																																				Kind: to.Ptr(armstorage.KindStorage),
		// 																																				Locations: []*string{
		// 																																					to.Ptr("westeurope")},
		// 																																					ResourceType: to.Ptr("storageAccounts"),
		// 																																					Restrictions: []*armstorage.Restriction{
		// 																																					},
		// 																																					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																				},
		// 																																				{
		// 																																					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																					Capabilities: []*armstorage.SKUCapability{
		// 																																						{
		// 																																							Name: to.Ptr("supportsfileencryption"),
		// 																																							Value: to.Ptr("true"),
		// 																																						},
		// 																																						{
		// 																																							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																							Value: to.Ptr("false"),
		// 																																						},
		// 																																						{
		// 																																							Name: to.Ptr("supportsnetworkacls"),
		// 																																							Value: to.Ptr("false"),
		// 																																					}},
		// 																																					Kind: to.Ptr(armstorage.KindStorage),
		// 																																					Locations: []*string{
		// 																																						to.Ptr("westeurope")},
		// 																																						ResourceType: to.Ptr("storageAccounts"),
		// 																																						Restrictions: []*armstorage.Restriction{
		// 																																						},
		// 																																						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																					},
		// 																																					{
		// 																																						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																						Capabilities: []*armstorage.SKUCapability{
		// 																																							{
		// 																																								Name: to.Ptr("supportsfileencryption"),
		// 																																								Value: to.Ptr("true"),
		// 																																							},
		// 																																							{
		// 																																								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																								Value: to.Ptr("false"),
		// 																																							},
		// 																																							{
		// 																																								Name: to.Ptr("supportsnetworkacls"),
		// 																																								Value: to.Ptr("false"),
		// 																																						}},
		// 																																						Kind: to.Ptr(armstorage.KindStorage),
		// 																																						Locations: []*string{
		// 																																							to.Ptr("westeurope")},
		// 																																							ResourceType: to.Ptr("storageAccounts"),
		// 																																							Restrictions: []*armstorage.Restriction{
		// 																																							},
		// 																																							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																						},
		// 																																						{
		// 																																							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																							Capabilities: []*armstorage.SKUCapability{
		// 																																								{
		// 																																									Name: to.Ptr("supportsfileencryption"),
		// 																																									Value: to.Ptr("false"),
		// 																																								},
		// 																																								{
		// 																																									Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																									Value: to.Ptr("false"),
		// 																																								},
		// 																																								{
		// 																																									Name: to.Ptr("supportsnetworkacls"),
		// 																																									Value: to.Ptr("false"),
		// 																																							}},
		// 																																							Kind: to.Ptr(armstorage.KindStorage),
		// 																																							Locations: []*string{
		// 																																								to.Ptr("westeurope")},
		// 																																								ResourceType: to.Ptr("storageAccounts"),
		// 																																								Restrictions: []*armstorage.Restriction{
		// 																																								},
		// 																																								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																							},
		// 																																							{
		// 																																								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																								Capabilities: []*armstorage.SKUCapability{
		// 																																									{
		// 																																										Name: to.Ptr("supportsarchivepreview"),
		// 																																										Value: to.Ptr("false"),
		// 																																									},
		// 																																									{
		// 																																										Name: to.Ptr("supportschangenotification"),
		// 																																										Value: to.Ptr("false"),
		// 																																									},
		// 																																									{
		// 																																										Name: to.Ptr("supportsfileencryption"),
		// 																																										Value: to.Ptr("false"),
		// 																																									},
		// 																																									{
		// 																																										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																										Value: to.Ptr("false"),
		// 																																									},
		// 																																									{
		// 																																										Name: to.Ptr("supportsnetworkacls"),
		// 																																										Value: to.Ptr("false"),
		// 																																								}},
		// 																																								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																								Locations: []*string{
		// 																																									to.Ptr("westeurope")},
		// 																																									ResourceType: to.Ptr("storageAccounts"),
		// 																																									Restrictions: []*armstorage.Restriction{
		// 																																									},
		// 																																									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																								},
		// 																																								{
		// 																																									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																									Capabilities: []*armstorage.SKUCapability{
		// 																																										{
		// 																																											Name: to.Ptr("supportschangenotification"),
		// 																																											Value: to.Ptr("false"),
		// 																																										},
		// 																																										{
		// 																																											Name: to.Ptr("supportsfileencryption"),
		// 																																											Value: to.Ptr("false"),
		// 																																										},
		// 																																										{
		// 																																											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																											Value: to.Ptr("false"),
		// 																																										},
		// 																																										{
		// 																																											Name: to.Ptr("supportsnetworkacls"),
		// 																																											Value: to.Ptr("false"),
		// 																																									}},
		// 																																									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																									Locations: []*string{
		// 																																										to.Ptr("westeurope")},
		// 																																										ResourceType: to.Ptr("storageAccounts"),
		// 																																										Restrictions: []*armstorage.Restriction{
		// 																																										},
		// 																																										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																									},
		// 																																									{
		// 																																										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																										Capabilities: []*armstorage.SKUCapability{
		// 																																											{
		// 																																												Name: to.Ptr("supportschangenotification"),
		// 																																												Value: to.Ptr("false"),
		// 																																											},
		// 																																											{
		// 																																												Name: to.Ptr("supportsfileencryption"),
		// 																																												Value: to.Ptr("false"),
		// 																																											},
		// 																																											{
		// 																																												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																												Value: to.Ptr("false"),
		// 																																											},
		// 																																											{
		// 																																												Name: to.Ptr("supportsnetworkacls"),
		// 																																												Value: to.Ptr("false"),
		// 																																										}},
		// 																																										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																										Locations: []*string{
		// 																																											to.Ptr("westeurope")},
		// 																																											ResourceType: to.Ptr("storageAccounts"),
		// 																																											Restrictions: []*armstorage.Restriction{
		// 																																											},
		// 																																											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																										},
		// 																																										{
		// 																																											Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																											Capabilities: []*armstorage.SKUCapability{
		// 																																												{
		// 																																													Name: to.Ptr("supportsfileencryption"),
		// 																																													Value: to.Ptr("true"),
		// 																																												},
		// 																																												{
		// 																																													Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																													Value: to.Ptr("false"),
		// 																																												},
		// 																																												{
		// 																																													Name: to.Ptr("supportsnetworkacls"),
		// 																																													Value: to.Ptr("false"),
		// 																																											}},
		// 																																											Kind: to.Ptr(armstorage.KindStorage),
		// 																																											Locations: []*string{
		// 																																												to.Ptr("eastasia")},
		// 																																												ResourceType: to.Ptr("storageAccounts"),
		// 																																												Restrictions: []*armstorage.Restriction{
		// 																																												},
		// 																																												Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																											},
		// 																																											{
		// 																																												Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																												Capabilities: []*armstorage.SKUCapability{
		// 																																													{
		// 																																														Name: to.Ptr("supportsfileencryption"),
		// 																																														Value: to.Ptr("true"),
		// 																																													},
		// 																																													{
		// 																																														Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																														Value: to.Ptr("false"),
		// 																																													},
		// 																																													{
		// 																																														Name: to.Ptr("supportsnetworkacls"),
		// 																																														Value: to.Ptr("false"),
		// 																																												}},
		// 																																												Kind: to.Ptr(armstorage.KindStorage),
		// 																																												Locations: []*string{
		// 																																													to.Ptr("eastasia")},
		// 																																													ResourceType: to.Ptr("storageAccounts"),
		// 																																													Restrictions: []*armstorage.Restriction{
		// 																																													},
		// 																																													Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																												},
		// 																																												{
		// 																																													Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																													Capabilities: []*armstorage.SKUCapability{
		// 																																														{
		// 																																															Name: to.Ptr("supportsfileencryption"),
		// 																																															Value: to.Ptr("true"),
		// 																																														},
		// 																																														{
		// 																																															Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																															Value: to.Ptr("false"),
		// 																																														},
		// 																																														{
		// 																																															Name: to.Ptr("supportsnetworkacls"),
		// 																																															Value: to.Ptr("false"),
		// 																																													}},
		// 																																													Kind: to.Ptr(armstorage.KindStorage),
		// 																																													Locations: []*string{
		// 																																														to.Ptr("eastasia")},
		// 																																														ResourceType: to.Ptr("storageAccounts"),
		// 																																														Restrictions: []*armstorage.Restriction{
		// 																																														},
		// 																																														Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																													},
		// 																																													{
		// 																																														Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																														Capabilities: []*armstorage.SKUCapability{
		// 																																															{
		// 																																																Name: to.Ptr("supportsfileencryption"),
		// 																																																Value: to.Ptr("true"),
		// 																																															},
		// 																																															{
		// 																																																Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																Value: to.Ptr("false"),
		// 																																															},
		// 																																															{
		// 																																																Name: to.Ptr("supportsnetworkacls"),
		// 																																																Value: to.Ptr("false"),
		// 																																														}},
		// 																																														Kind: to.Ptr(armstorage.KindStorage),
		// 																																														Locations: []*string{
		// 																																															to.Ptr("eastasia")},
		// 																																															ResourceType: to.Ptr("storageAccounts"),
		// 																																															Restrictions: []*armstorage.Restriction{
		// 																																															},
		// 																																															Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																														},
		// 																																														{
		// 																																															Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																															Capabilities: []*armstorage.SKUCapability{
		// 																																																{
		// 																																																	Name: to.Ptr("supportsfileencryption"),
		// 																																																	Value: to.Ptr("false"),
		// 																																																},
		// 																																																{
		// 																																																	Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																	Value: to.Ptr("false"),
		// 																																																},
		// 																																																{
		// 																																																	Name: to.Ptr("supportsnetworkacls"),
		// 																																																	Value: to.Ptr("false"),
		// 																																															}},
		// 																																															Kind: to.Ptr(armstorage.KindStorage),
		// 																																															Locations: []*string{
		// 																																																to.Ptr("eastasia")},
		// 																																																ResourceType: to.Ptr("storageAccounts"),
		// 																																																Restrictions: []*armstorage.Restriction{
		// 																																																},
		// 																																																Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																															},
		// 																																															{
		// 																																																Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																Capabilities: []*armstorage.SKUCapability{
		// 																																																	{
		// 																																																		Name: to.Ptr("supportsarchivepreview"),
		// 																																																		Value: to.Ptr("false"),
		// 																																																	},
		// 																																																	{
		// 																																																		Name: to.Ptr("supportschangenotification"),
		// 																																																		Value: to.Ptr("false"),
		// 																																																	},
		// 																																																	{
		// 																																																		Name: to.Ptr("supportsfileencryption"),
		// 																																																		Value: to.Ptr("false"),
		// 																																																	},
		// 																																																	{
		// 																																																		Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																		Value: to.Ptr("false"),
		// 																																																	},
		// 																																																	{
		// 																																																		Name: to.Ptr("supportsnetworkacls"),
		// 																																																		Value: to.Ptr("false"),
		// 																																																}},
		// 																																																Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																Locations: []*string{
		// 																																																	to.Ptr("eastasia")},
		// 																																																	ResourceType: to.Ptr("storageAccounts"),
		// 																																																	Restrictions: []*armstorage.Restriction{
		// 																																																	},
		// 																																																	Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																},
		// 																																																{
		// 																																																	Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																	Capabilities: []*armstorage.SKUCapability{
		// 																																																		{
		// 																																																			Name: to.Ptr("supportschangenotification"),
		// 																																																			Value: to.Ptr("false"),
		// 																																																		},
		// 																																																		{
		// 																																																			Name: to.Ptr("supportsfileencryption"),
		// 																																																			Value: to.Ptr("false"),
		// 																																																		},
		// 																																																		{
		// 																																																			Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																			Value: to.Ptr("false"),
		// 																																																		},
		// 																																																		{
		// 																																																			Name: to.Ptr("supportsnetworkacls"),
		// 																																																			Value: to.Ptr("false"),
		// 																																																	}},
		// 																																																	Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																	Locations: []*string{
		// 																																																		to.Ptr("eastasia")},
		// 																																																		ResourceType: to.Ptr("storageAccounts"),
		// 																																																		Restrictions: []*armstorage.Restriction{
		// 																																																		},
		// 																																																		Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																	},
		// 																																																	{
		// 																																																		Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																		Capabilities: []*armstorage.SKUCapability{
		// 																																																			{
		// 																																																				Name: to.Ptr("supportschangenotification"),
		// 																																																				Value: to.Ptr("false"),
		// 																																																			},
		// 																																																			{
		// 																																																				Name: to.Ptr("supportsfileencryption"),
		// 																																																				Value: to.Ptr("false"),
		// 																																																			},
		// 																																																			{
		// 																																																				Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																				Value: to.Ptr("false"),
		// 																																																			},
		// 																																																			{
		// 																																																				Name: to.Ptr("supportsnetworkacls"),
		// 																																																				Value: to.Ptr("false"),
		// 																																																		}},
		// 																																																		Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																		Locations: []*string{
		// 																																																			to.Ptr("eastasia")},
		// 																																																			ResourceType: to.Ptr("storageAccounts"),
		// 																																																			Restrictions: []*armstorage.Restriction{
		// 																																																			},
		// 																																																			Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																		},
		// 																																																		{
		// 																																																			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																			Capabilities: []*armstorage.SKUCapability{
		// 																																																				{
		// 																																																					Name: to.Ptr("supportsfileencryption"),
		// 																																																					Value: to.Ptr("true"),
		// 																																																				},
		// 																																																				{
		// 																																																					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																					Value: to.Ptr("false"),
		// 																																																				},
		// 																																																				{
		// 																																																					Name: to.Ptr("supportsnetworkacls"),
		// 																																																					Value: to.Ptr("false"),
		// 																																																			}},
		// 																																																			Kind: to.Ptr(armstorage.KindStorage),
		// 																																																			Locations: []*string{
		// 																																																				to.Ptr("southeastasia")},
		// 																																																				ResourceType: to.Ptr("storageAccounts"),
		// 																																																				Restrictions: []*armstorage.Restriction{
		// 																																																				},
		// 																																																				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																			},
		// 																																																			{
		// 																																																				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																				Capabilities: []*armstorage.SKUCapability{
		// 																																																					{
		// 																																																						Name: to.Ptr("supportsfileencryption"),
		// 																																																						Value: to.Ptr("true"),
		// 																																																					},
		// 																																																					{
		// 																																																						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																						Value: to.Ptr("false"),
		// 																																																					},
		// 																																																					{
		// 																																																						Name: to.Ptr("supportsnetworkacls"),
		// 																																																						Value: to.Ptr("false"),
		// 																																																				}},
		// 																																																				Kind: to.Ptr(armstorage.KindStorage),
		// 																																																				Locations: []*string{
		// 																																																					to.Ptr("southeastasia")},
		// 																																																					ResourceType: to.Ptr("storageAccounts"),
		// 																																																					Restrictions: []*armstorage.Restriction{
		// 																																																					},
		// 																																																					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																				},
		// 																																																				{
		// 																																																					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																					Capabilities: []*armstorage.SKUCapability{
		// 																																																						{
		// 																																																							Name: to.Ptr("supportsfileencryption"),
		// 																																																							Value: to.Ptr("true"),
		// 																																																						},
		// 																																																						{
		// 																																																							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																							Value: to.Ptr("false"),
		// 																																																						},
		// 																																																						{
		// 																																																							Name: to.Ptr("supportsnetworkacls"),
		// 																																																							Value: to.Ptr("false"),
		// 																																																					}},
		// 																																																					Kind: to.Ptr(armstorage.KindStorage),
		// 																																																					Locations: []*string{
		// 																																																						to.Ptr("southeastasia")},
		// 																																																						ResourceType: to.Ptr("storageAccounts"),
		// 																																																						Restrictions: []*armstorage.Restriction{
		// 																																																						},
		// 																																																						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																					},
		// 																																																					{
		// 																																																						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																						Capabilities: []*armstorage.SKUCapability{
		// 																																																							{
		// 																																																								Name: to.Ptr("supportsfileencryption"),
		// 																																																								Value: to.Ptr("true"),
		// 																																																							},
		// 																																																							{
		// 																																																								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																								Value: to.Ptr("false"),
		// 																																																							},
		// 																																																							{
		// 																																																								Name: to.Ptr("supportsnetworkacls"),
		// 																																																								Value: to.Ptr("false"),
		// 																																																						}},
		// 																																																						Kind: to.Ptr(armstorage.KindStorage),
		// 																																																						Locations: []*string{
		// 																																																							to.Ptr("southeastasia")},
		// 																																																							ResourceType: to.Ptr("storageAccounts"),
		// 																																																							Restrictions: []*armstorage.Restriction{
		// 																																																							},
		// 																																																							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																						},
		// 																																																						{
		// 																																																							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																							Capabilities: []*armstorage.SKUCapability{
		// 																																																								{
		// 																																																									Name: to.Ptr("supportsfileencryption"),
		// 																																																									Value: to.Ptr("false"),
		// 																																																								},
		// 																																																								{
		// 																																																									Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																									Value: to.Ptr("false"),
		// 																																																								},
		// 																																																								{
		// 																																																									Name: to.Ptr("supportsnetworkacls"),
		// 																																																									Value: to.Ptr("false"),
		// 																																																							}},
		// 																																																							Kind: to.Ptr(armstorage.KindStorage),
		// 																																																							Locations: []*string{
		// 																																																								to.Ptr("southeastasia")},
		// 																																																								ResourceType: to.Ptr("storageAccounts"),
		// 																																																								Restrictions: []*armstorage.Restriction{
		// 																																																								},
		// 																																																								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																							},
		// 																																																							{
		// 																																																								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																								Capabilities: []*armstorage.SKUCapability{
		// 																																																									{
		// 																																																										Name: to.Ptr("supportsarchivepreview"),
		// 																																																										Value: to.Ptr("false"),
		// 																																																									},
		// 																																																									{
		// 																																																										Name: to.Ptr("supportschangenotification"),
		// 																																																										Value: to.Ptr("false"),
		// 																																																									},
		// 																																																									{
		// 																																																										Name: to.Ptr("supportsfileencryption"),
		// 																																																										Value: to.Ptr("false"),
		// 																																																									},
		// 																																																									{
		// 																																																										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																										Value: to.Ptr("false"),
		// 																																																									},
		// 																																																									{
		// 																																																										Name: to.Ptr("supportsnetworkacls"),
		// 																																																										Value: to.Ptr("false"),
		// 																																																								}},
		// 																																																								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																								Locations: []*string{
		// 																																																									to.Ptr("southeastasia")},
		// 																																																									ResourceType: to.Ptr("storageAccounts"),
		// 																																																									Restrictions: []*armstorage.Restriction{
		// 																																																									},
		// 																																																									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																								},
		// 																																																								{
		// 																																																									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																									Capabilities: []*armstorage.SKUCapability{
		// 																																																										{
		// 																																																											Name: to.Ptr("supportschangenotification"),
		// 																																																											Value: to.Ptr("false"),
		// 																																																										},
		// 																																																										{
		// 																																																											Name: to.Ptr("supportsfileencryption"),
		// 																																																											Value: to.Ptr("false"),
		// 																																																										},
		// 																																																										{
		// 																																																											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																											Value: to.Ptr("false"),
		// 																																																										},
		// 																																																										{
		// 																																																											Name: to.Ptr("supportsnetworkacls"),
		// 																																																											Value: to.Ptr("false"),
		// 																																																									}},
		// 																																																									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																									Locations: []*string{
		// 																																																										to.Ptr("southeastasia")},
		// 																																																										ResourceType: to.Ptr("storageAccounts"),
		// 																																																										Restrictions: []*armstorage.Restriction{
		// 																																																										},
		// 																																																										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																									},
		// 																																																									{
		// 																																																										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																										Capabilities: []*armstorage.SKUCapability{
		// 																																																											{
		// 																																																												Name: to.Ptr("supportschangenotification"),
		// 																																																												Value: to.Ptr("false"),
		// 																																																											},
		// 																																																											{
		// 																																																												Name: to.Ptr("supportsfileencryption"),
		// 																																																												Value: to.Ptr("false"),
		// 																																																											},
		// 																																																											{
		// 																																																												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																												Value: to.Ptr("false"),
		// 																																																											},
		// 																																																											{
		// 																																																												Name: to.Ptr("supportsnetworkacls"),
		// 																																																												Value: to.Ptr("false"),
		// 																																																										}},
		// 																																																										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																										Locations: []*string{
		// 																																																											to.Ptr("southeastasia")},
		// 																																																											ResourceType: to.Ptr("storageAccounts"),
		// 																																																											Restrictions: []*armstorage.Restriction{
		// 																																																											},
		// 																																																											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																										},
		// 																																																										{
		// 																																																											Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																											Capabilities: []*armstorage.SKUCapability{
		// 																																																												{
		// 																																																													Name: to.Ptr("supportsfileencryption"),
		// 																																																													Value: to.Ptr("true"),
		// 																																																												},
		// 																																																												{
		// 																																																													Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																													Value: to.Ptr("false"),
		// 																																																												},
		// 																																																												{
		// 																																																													Name: to.Ptr("supportsnetworkacls"),
		// 																																																													Value: to.Ptr("false"),
		// 																																																											}},
		// 																																																											Kind: to.Ptr(armstorage.KindStorage),
		// 																																																											Locations: []*string{
		// 																																																												to.Ptr("japaneast")},
		// 																																																												ResourceType: to.Ptr("storageAccounts"),
		// 																																																												Restrictions: []*armstorage.Restriction{
		// 																																																												},
		// 																																																												Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																											},
		// 																																																											{
		// 																																																												Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																												Capabilities: []*armstorage.SKUCapability{
		// 																																																													{
		// 																																																														Name: to.Ptr("supportsfileencryption"),
		// 																																																														Value: to.Ptr("true"),
		// 																																																													},
		// 																																																													{
		// 																																																														Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																														Value: to.Ptr("false"),
		// 																																																													},
		// 																																																													{
		// 																																																														Name: to.Ptr("supportsnetworkacls"),
		// 																																																														Value: to.Ptr("false"),
		// 																																																												}},
		// 																																																												Kind: to.Ptr(armstorage.KindStorage),
		// 																																																												Locations: []*string{
		// 																																																													to.Ptr("japaneast")},
		// 																																																													ResourceType: to.Ptr("storageAccounts"),
		// 																																																													Restrictions: []*armstorage.Restriction{
		// 																																																													},
		// 																																																													Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																												},
		// 																																																												{
		// 																																																													Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																													Capabilities: []*armstorage.SKUCapability{
		// 																																																														{
		// 																																																															Name: to.Ptr("supportsfileencryption"),
		// 																																																															Value: to.Ptr("true"),
		// 																																																														},
		// 																																																														{
		// 																																																															Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																															Value: to.Ptr("false"),
		// 																																																														},
		// 																																																														{
		// 																																																															Name: to.Ptr("supportsnetworkacls"),
		// 																																																															Value: to.Ptr("false"),
		// 																																																													}},
		// 																																																													Kind: to.Ptr(armstorage.KindStorage),
		// 																																																													Locations: []*string{
		// 																																																														to.Ptr("japaneast")},
		// 																																																														ResourceType: to.Ptr("storageAccounts"),
		// 																																																														Restrictions: []*armstorage.Restriction{
		// 																																																														},
		// 																																																														Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																													},
		// 																																																													{
		// 																																																														Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																														Capabilities: []*armstorage.SKUCapability{
		// 																																																															{
		// 																																																																Name: to.Ptr("supportsfileencryption"),
		// 																																																																Value: to.Ptr("true"),
		// 																																																															},
		// 																																																															{
		// 																																																																Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																Value: to.Ptr("false"),
		// 																																																															},
		// 																																																															{
		// 																																																																Name: to.Ptr("supportsnetworkacls"),
		// 																																																																Value: to.Ptr("false"),
		// 																																																														}},
		// 																																																														Kind: to.Ptr(armstorage.KindStorage),
		// 																																																														Locations: []*string{
		// 																																																															to.Ptr("japaneast")},
		// 																																																															ResourceType: to.Ptr("storageAccounts"),
		// 																																																															Restrictions: []*armstorage.Restriction{
		// 																																																															},
		// 																																																															Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																														},
		// 																																																														{
		// 																																																															Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																															Capabilities: []*armstorage.SKUCapability{
		// 																																																																{
		// 																																																																	Name: to.Ptr("supportsfileencryption"),
		// 																																																																	Value: to.Ptr("false"),
		// 																																																																},
		// 																																																																{
		// 																																																																	Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																	Value: to.Ptr("false"),
		// 																																																																},
		// 																																																																{
		// 																																																																	Name: to.Ptr("supportsnetworkacls"),
		// 																																																																	Value: to.Ptr("false"),
		// 																																																															}},
		// 																																																															Kind: to.Ptr(armstorage.KindStorage),
		// 																																																															Locations: []*string{
		// 																																																																to.Ptr("japaneast")},
		// 																																																																ResourceType: to.Ptr("storageAccounts"),
		// 																																																																Restrictions: []*armstorage.Restriction{
		// 																																																																},
		// 																																																																Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																															},
		// 																																																															{
		// 																																																																Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																Capabilities: []*armstorage.SKUCapability{
		// 																																																																	{
		// 																																																																		Name: to.Ptr("supportsarchivepreview"),
		// 																																																																		Value: to.Ptr("false"),
		// 																																																																	},
		// 																																																																	{
		// 																																																																		Name: to.Ptr("supportschangenotification"),
		// 																																																																		Value: to.Ptr("false"),
		// 																																																																	},
		// 																																																																	{
		// 																																																																		Name: to.Ptr("supportsfileencryption"),
		// 																																																																		Value: to.Ptr("false"),
		// 																																																																	},
		// 																																																																	{
		// 																																																																		Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																		Value: to.Ptr("false"),
		// 																																																																	},
		// 																																																																	{
		// 																																																																		Name: to.Ptr("supportsnetworkacls"),
		// 																																																																		Value: to.Ptr("false"),
		// 																																																																}},
		// 																																																																Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																Locations: []*string{
		// 																																																																	to.Ptr("japaneast")},
		// 																																																																	ResourceType: to.Ptr("storageAccounts"),
		// 																																																																	Restrictions: []*armstorage.Restriction{
		// 																																																																	},
		// 																																																																	Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																},
		// 																																																																{
		// 																																																																	Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																	Capabilities: []*armstorage.SKUCapability{
		// 																																																																		{
		// 																																																																			Name: to.Ptr("supportschangenotification"),
		// 																																																																			Value: to.Ptr("false"),
		// 																																																																		},
		// 																																																																		{
		// 																																																																			Name: to.Ptr("supportsfileencryption"),
		// 																																																																			Value: to.Ptr("false"),
		// 																																																																		},
		// 																																																																		{
		// 																																																																			Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																			Value: to.Ptr("false"),
		// 																																																																		},
		// 																																																																		{
		// 																																																																			Name: to.Ptr("supportsnetworkacls"),
		// 																																																																			Value: to.Ptr("false"),
		// 																																																																	}},
		// 																																																																	Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																	Locations: []*string{
		// 																																																																		to.Ptr("japaneast")},
		// 																																																																		ResourceType: to.Ptr("storageAccounts"),
		// 																																																																		Restrictions: []*armstorage.Restriction{
		// 																																																																		},
		// 																																																																		Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																	},
		// 																																																																	{
		// 																																																																		Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																		Capabilities: []*armstorage.SKUCapability{
		// 																																																																			{
		// 																																																																				Name: to.Ptr("supportschangenotification"),
		// 																																																																				Value: to.Ptr("false"),
		// 																																																																			},
		// 																																																																			{
		// 																																																																				Name: to.Ptr("supportsfileencryption"),
		// 																																																																				Value: to.Ptr("false"),
		// 																																																																			},
		// 																																																																			{
		// 																																																																				Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																				Value: to.Ptr("false"),
		// 																																																																			},
		// 																																																																			{
		// 																																																																				Name: to.Ptr("supportsnetworkacls"),
		// 																																																																				Value: to.Ptr("false"),
		// 																																																																		}},
		// 																																																																		Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																		Locations: []*string{
		// 																																																																			to.Ptr("japaneast")},
		// 																																																																			ResourceType: to.Ptr("storageAccounts"),
		// 																																																																			Restrictions: []*armstorage.Restriction{
		// 																																																																			},
		// 																																																																			Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																		},
		// 																																																																		{
		// 																																																																			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																			Capabilities: []*armstorage.SKUCapability{
		// 																																																																				{
		// 																																																																					Name: to.Ptr("supportsfileencryption"),
		// 																																																																					Value: to.Ptr("true"),
		// 																																																																				},
		// 																																																																				{
		// 																																																																					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																					Value: to.Ptr("false"),
		// 																																																																				},
		// 																																																																				{
		// 																																																																					Name: to.Ptr("supportsnetworkacls"),
		// 																																																																					Value: to.Ptr("false"),
		// 																																																																			}},
		// 																																																																			Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																			Locations: []*string{
		// 																																																																				to.Ptr("japanwest")},
		// 																																																																				ResourceType: to.Ptr("storageAccounts"),
		// 																																																																				Restrictions: []*armstorage.Restriction{
		// 																																																																				},
		// 																																																																				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																			},
		// 																																																																			{
		// 																																																																				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																				Capabilities: []*armstorage.SKUCapability{
		// 																																																																					{
		// 																																																																						Name: to.Ptr("supportsfileencryption"),
		// 																																																																						Value: to.Ptr("true"),
		// 																																																																					},
		// 																																																																					{
		// 																																																																						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																						Value: to.Ptr("false"),
		// 																																																																					},
		// 																																																																					{
		// 																																																																						Name: to.Ptr("supportsnetworkacls"),
		// 																																																																						Value: to.Ptr("false"),
		// 																																																																				}},
		// 																																																																				Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																				Locations: []*string{
		// 																																																																					to.Ptr("japanwest")},
		// 																																																																					ResourceType: to.Ptr("storageAccounts"),
		// 																																																																					Restrictions: []*armstorage.Restriction{
		// 																																																																					},
		// 																																																																					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																				},
		// 																																																																				{
		// 																																																																					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																					Capabilities: []*armstorage.SKUCapability{
		// 																																																																						{
		// 																																																																							Name: to.Ptr("supportsfileencryption"),
		// 																																																																							Value: to.Ptr("true"),
		// 																																																																						},
		// 																																																																						{
		// 																																																																							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																							Value: to.Ptr("false"),
		// 																																																																						},
		// 																																																																						{
		// 																																																																							Name: to.Ptr("supportsnetworkacls"),
		// 																																																																							Value: to.Ptr("false"),
		// 																																																																					}},
		// 																																																																					Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																					Locations: []*string{
		// 																																																																						to.Ptr("japanwest")},
		// 																																																																						ResourceType: to.Ptr("storageAccounts"),
		// 																																																																						Restrictions: []*armstorage.Restriction{
		// 																																																																						},
		// 																																																																						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																					},
		// 																																																																					{
		// 																																																																						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																						Capabilities: []*armstorage.SKUCapability{
		// 																																																																							{
		// 																																																																								Name: to.Ptr("supportsfileencryption"),
		// 																																																																								Value: to.Ptr("true"),
		// 																																																																							},
		// 																																																																							{
		// 																																																																								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																								Value: to.Ptr("false"),
		// 																																																																							},
		// 																																																																							{
		// 																																																																								Name: to.Ptr("supportsnetworkacls"),
		// 																																																																								Value: to.Ptr("false"),
		// 																																																																						}},
		// 																																																																						Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																						Locations: []*string{
		// 																																																																							to.Ptr("japanwest")},
		// 																																																																							ResourceType: to.Ptr("storageAccounts"),
		// 																																																																							Restrictions: []*armstorage.Restriction{
		// 																																																																							},
		// 																																																																							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																						},
		// 																																																																						{
		// 																																																																							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																							Capabilities: []*armstorage.SKUCapability{
		// 																																																																								{
		// 																																																																									Name: to.Ptr("supportsfileencryption"),
		// 																																																																									Value: to.Ptr("false"),
		// 																																																																								},
		// 																																																																								{
		// 																																																																									Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																									Value: to.Ptr("false"),
		// 																																																																								},
		// 																																																																								{
		// 																																																																									Name: to.Ptr("supportsnetworkacls"),
		// 																																																																									Value: to.Ptr("false"),
		// 																																																																							}},
		// 																																																																							Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																							Locations: []*string{
		// 																																																																								to.Ptr("japanwest")},
		// 																																																																								ResourceType: to.Ptr("storageAccounts"),
		// 																																																																								Restrictions: []*armstorage.Restriction{
		// 																																																																								},
		// 																																																																								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																							},
		// 																																																																							{
		// 																																																																								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																								Capabilities: []*armstorage.SKUCapability{
		// 																																																																									{
		// 																																																																										Name: to.Ptr("supportsarchivepreview"),
		// 																																																																										Value: to.Ptr("false"),
		// 																																																																									},
		// 																																																																									{
		// 																																																																										Name: to.Ptr("supportschangenotification"),
		// 																																																																										Value: to.Ptr("false"),
		// 																																																																									},
		// 																																																																									{
		// 																																																																										Name: to.Ptr("supportsfileencryption"),
		// 																																																																										Value: to.Ptr("false"),
		// 																																																																									},
		// 																																																																									{
		// 																																																																										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																										Value: to.Ptr("false"),
		// 																																																																									},
		// 																																																																									{
		// 																																																																										Name: to.Ptr("supportsnetworkacls"),
		// 																																																																										Value: to.Ptr("false"),
		// 																																																																								}},
		// 																																																																								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																								Locations: []*string{
		// 																																																																									to.Ptr("japanwest")},
		// 																																																																									ResourceType: to.Ptr("storageAccounts"),
		// 																																																																									Restrictions: []*armstorage.Restriction{
		// 																																																																									},
		// 																																																																									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																								},
		// 																																																																								{
		// 																																																																									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																									Capabilities: []*armstorage.SKUCapability{
		// 																																																																										{
		// 																																																																											Name: to.Ptr("supportschangenotification"),
		// 																																																																											Value: to.Ptr("false"),
		// 																																																																										},
		// 																																																																										{
		// 																																																																											Name: to.Ptr("supportsfileencryption"),
		// 																																																																											Value: to.Ptr("false"),
		// 																																																																										},
		// 																																																																										{
		// 																																																																											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																											Value: to.Ptr("false"),
		// 																																																																										},
		// 																																																																										{
		// 																																																																											Name: to.Ptr("supportsnetworkacls"),
		// 																																																																											Value: to.Ptr("false"),
		// 																																																																									}},
		// 																																																																									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																									Locations: []*string{
		// 																																																																										to.Ptr("japanwest")},
		// 																																																																										ResourceType: to.Ptr("storageAccounts"),
		// 																																																																										Restrictions: []*armstorage.Restriction{
		// 																																																																										},
		// 																																																																										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																									},
		// 																																																																									{
		// 																																																																										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																										Capabilities: []*armstorage.SKUCapability{
		// 																																																																											{
		// 																																																																												Name: to.Ptr("supportschangenotification"),
		// 																																																																												Value: to.Ptr("false"),
		// 																																																																											},
		// 																																																																											{
		// 																																																																												Name: to.Ptr("supportsfileencryption"),
		// 																																																																												Value: to.Ptr("false"),
		// 																																																																											},
		// 																																																																											{
		// 																																																																												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																												Value: to.Ptr("false"),
		// 																																																																											},
		// 																																																																											{
		// 																																																																												Name: to.Ptr("supportsnetworkacls"),
		// 																																																																												Value: to.Ptr("false"),
		// 																																																																										}},
		// 																																																																										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																										Locations: []*string{
		// 																																																																											to.Ptr("japanwest")},
		// 																																																																											ResourceType: to.Ptr("storageAccounts"),
		// 																																																																											Restrictions: []*armstorage.Restriction{
		// 																																																																											},
		// 																																																																											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																										},
		// 																																																																										{
		// 																																																																											Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																											Capabilities: []*armstorage.SKUCapability{
		// 																																																																												{
		// 																																																																													Name: to.Ptr("supportsfileencryption"),
		// 																																																																													Value: to.Ptr("true"),
		// 																																																																												},
		// 																																																																												{
		// 																																																																													Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																													Value: to.Ptr("true"),
		// 																																																																												},
		// 																																																																												{
		// 																																																																													Name: to.Ptr("supportsnetworkacls"),
		// 																																																																													Value: to.Ptr("false"),
		// 																																																																											}},
		// 																																																																											Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																											Locations: []*string{
		// 																																																																												to.Ptr("northcentralus")},
		// 																																																																												ResourceType: to.Ptr("storageAccounts"),
		// 																																																																												Restrictions: []*armstorage.Restriction{
		// 																																																																												},
		// 																																																																												Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																											},
		// 																																																																											{
		// 																																																																												Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																												Capabilities: []*armstorage.SKUCapability{
		// 																																																																													{
		// 																																																																														Name: to.Ptr("supportsfileencryption"),
		// 																																																																														Value: to.Ptr("true"),
		// 																																																																													},
		// 																																																																													{
		// 																																																																														Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																														Value: to.Ptr("true"),
		// 																																																																													},
		// 																																																																													{
		// 																																																																														Name: to.Ptr("supportsnetworkacls"),
		// 																																																																														Value: to.Ptr("false"),
		// 																																																																												}},
		// 																																																																												Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																												Locations: []*string{
		// 																																																																													to.Ptr("northcentralus")},
		// 																																																																													ResourceType: to.Ptr("storageAccounts"),
		// 																																																																													Restrictions: []*armstorage.Restriction{
		// 																																																																													},
		// 																																																																													Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																												},
		// 																																																																												{
		// 																																																																													Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																													Capabilities: []*armstorage.SKUCapability{
		// 																																																																														{
		// 																																																																															Name: to.Ptr("supportsfileencryption"),
		// 																																																																															Value: to.Ptr("true"),
		// 																																																																														},
		// 																																																																														{
		// 																																																																															Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																															Value: to.Ptr("true"),
		// 																																																																														},
		// 																																																																														{
		// 																																																																															Name: to.Ptr("supportsnetworkacls"),
		// 																																																																															Value: to.Ptr("false"),
		// 																																																																													}},
		// 																																																																													Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																													Locations: []*string{
		// 																																																																														to.Ptr("northcentralus")},
		// 																																																																														ResourceType: to.Ptr("storageAccounts"),
		// 																																																																														Restrictions: []*armstorage.Restriction{
		// 																																																																														},
		// 																																																																														Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																													},
		// 																																																																													{
		// 																																																																														Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																														Capabilities: []*armstorage.SKUCapability{
		// 																																																																															{
		// 																																																																																Name: to.Ptr("supportsfileencryption"),
		// 																																																																																Value: to.Ptr("true"),
		// 																																																																															},
		// 																																																																															{
		// 																																																																																Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																Value: to.Ptr("true"),
		// 																																																																															},
		// 																																																																															{
		// 																																																																																Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																Value: to.Ptr("false"),
		// 																																																																														}},
		// 																																																																														Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																														Locations: []*string{
		// 																																																																															to.Ptr("northcentralus")},
		// 																																																																															ResourceType: to.Ptr("storageAccounts"),
		// 																																																																															Restrictions: []*armstorage.Restriction{
		// 																																																																															},
		// 																																																																															Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																														},
		// 																																																																														{
		// 																																																																															Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																															Capabilities: []*armstorage.SKUCapability{
		// 																																																																																{
		// 																																																																																	Name: to.Ptr("supportsfileencryption"),
		// 																																																																																	Value: to.Ptr("false"),
		// 																																																																																},
		// 																																																																																{
		// 																																																																																	Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																	Value: to.Ptr("true"),
		// 																																																																																},
		// 																																																																																{
		// 																																																																																	Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																	Value: to.Ptr("false"),
		// 																																																																															}},
		// 																																																																															Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																															Locations: []*string{
		// 																																																																																to.Ptr("northcentralus")},
		// 																																																																																ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																Restrictions: []*armstorage.Restriction{
		// 																																																																																},
		// 																																																																																Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																															},
		// 																																																																															{
		// 																																																																																Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																Capabilities: []*armstorage.SKUCapability{
		// 																																																																																	{
		// 																																																																																		Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																		Value: to.Ptr("false"),
		// 																																																																																	},
		// 																																																																																	{
		// 																																																																																		Name: to.Ptr("supportschangenotification"),
		// 																																																																																		Value: to.Ptr("false"),
		// 																																																																																	},
		// 																																																																																	{
		// 																																																																																		Name: to.Ptr("supportsfileencryption"),
		// 																																																																																		Value: to.Ptr("false"),
		// 																																																																																	},
		// 																																																																																	{
		// 																																																																																		Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																		Value: to.Ptr("true"),
		// 																																																																																	},
		// 																																																																																	{
		// 																																																																																		Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																		Value: to.Ptr("false"),
		// 																																																																																}},
		// 																																																																																Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																Locations: []*string{
		// 																																																																																	to.Ptr("northcentralus")},
		// 																																																																																	ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																	Restrictions: []*armstorage.Restriction{
		// 																																																																																	},
		// 																																																																																	Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																},
		// 																																																																																{
		// 																																																																																	Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																	Capabilities: []*armstorage.SKUCapability{
		// 																																																																																		{
		// 																																																																																			Name: to.Ptr("supportschangenotification"),
		// 																																																																																			Value: to.Ptr("false"),
		// 																																																																																		},
		// 																																																																																		{
		// 																																																																																			Name: to.Ptr("supportsfileencryption"),
		// 																																																																																			Value: to.Ptr("false"),
		// 																																																																																		},
		// 																																																																																		{
		// 																																																																																			Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																			Value: to.Ptr("true"),
		// 																																																																																		},
		// 																																																																																		{
		// 																																																																																			Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																			Value: to.Ptr("false"),
		// 																																																																																	}},
		// 																																																																																	Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																	Locations: []*string{
		// 																																																																																		to.Ptr("northcentralus")},
		// 																																																																																		ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																		Restrictions: []*armstorage.Restriction{
		// 																																																																																		},
		// 																																																																																		Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																	},
		// 																																																																																	{
		// 																																																																																		Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																		Capabilities: []*armstorage.SKUCapability{
		// 																																																																																			{
		// 																																																																																				Name: to.Ptr("supportschangenotification"),
		// 																																																																																				Value: to.Ptr("false"),
		// 																																																																																			},
		// 																																																																																			{
		// 																																																																																				Name: to.Ptr("supportsfileencryption"),
		// 																																																																																				Value: to.Ptr("false"),
		// 																																																																																			},
		// 																																																																																			{
		// 																																																																																				Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																				Value: to.Ptr("true"),
		// 																																																																																			},
		// 																																																																																			{
		// 																																																																																				Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																				Value: to.Ptr("false"),
		// 																																																																																		}},
		// 																																																																																		Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																		Locations: []*string{
		// 																																																																																			to.Ptr("northcentralus")},
		// 																																																																																			ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																			Restrictions: []*armstorage.Restriction{
		// 																																																																																			},
		// 																																																																																			Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																		},
		// 																																																																																		{
		// 																																																																																			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																			Capabilities: []*armstorage.SKUCapability{
		// 																																																																																				{
		// 																																																																																					Name: to.Ptr("supportsfileencryption"),
		// 																																																																																					Value: to.Ptr("true"),
		// 																																																																																				},
		// 																																																																																				{
		// 																																																																																					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																					Value: to.Ptr("true"),
		// 																																																																																				},
		// 																																																																																				{
		// 																																																																																					Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																					Value: to.Ptr("false"),
		// 																																																																																			}},
		// 																																																																																			Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																			Locations: []*string{
		// 																																																																																				to.Ptr("southcentralus")},
		// 																																																																																				ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																				Restrictions: []*armstorage.Restriction{
		// 																																																																																				},
		// 																																																																																				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																			},
		// 																																																																																			{
		// 																																																																																				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																				Capabilities: []*armstorage.SKUCapability{
		// 																																																																																					{
		// 																																																																																						Name: to.Ptr("supportsfileencryption"),
		// 																																																																																						Value: to.Ptr("true"),
		// 																																																																																					},
		// 																																																																																					{
		// 																																																																																						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																						Value: to.Ptr("true"),
		// 																																																																																					},
		// 																																																																																					{
		// 																																																																																						Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																						Value: to.Ptr("false"),
		// 																																																																																				}},
		// 																																																																																				Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																				Locations: []*string{
		// 																																																																																					to.Ptr("southcentralus")},
		// 																																																																																					ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																					Restrictions: []*armstorage.Restriction{
		// 																																																																																					},
		// 																																																																																					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																				},
		// 																																																																																				{
		// 																																																																																					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																					Capabilities: []*armstorage.SKUCapability{
		// 																																																																																						{
		// 																																																																																							Name: to.Ptr("supportsfileencryption"),
		// 																																																																																							Value: to.Ptr("true"),
		// 																																																																																						},
		// 																																																																																						{
		// 																																																																																							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																							Value: to.Ptr("true"),
		// 																																																																																						},
		// 																																																																																						{
		// 																																																																																							Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																							Value: to.Ptr("false"),
		// 																																																																																					}},
		// 																																																																																					Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																					Locations: []*string{
		// 																																																																																						to.Ptr("southcentralus")},
		// 																																																																																						ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																						Restrictions: []*armstorage.Restriction{
		// 																																																																																						},
		// 																																																																																						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																					},
		// 																																																																																					{
		// 																																																																																						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																						Capabilities: []*armstorage.SKUCapability{
		// 																																																																																							{
		// 																																																																																								Name: to.Ptr("supportsfileencryption"),
		// 																																																																																								Value: to.Ptr("true"),
		// 																																																																																							},
		// 																																																																																							{
		// 																																																																																								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																								Value: to.Ptr("true"),
		// 																																																																																							},
		// 																																																																																							{
		// 																																																																																								Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																								Value: to.Ptr("false"),
		// 																																																																																						}},
		// 																																																																																						Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																						Locations: []*string{
		// 																																																																																							to.Ptr("southcentralus")},
		// 																																																																																							ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																							Restrictions: []*armstorage.Restriction{
		// 																																																																																							},
		// 																																																																																							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																						},
		// 																																																																																						{
		// 																																																																																							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																							Capabilities: []*armstorage.SKUCapability{
		// 																																																																																								{
		// 																																																																																									Name: to.Ptr("supportsfileencryption"),
		// 																																																																																									Value: to.Ptr("false"),
		// 																																																																																								},
		// 																																																																																								{
		// 																																																																																									Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																									Value: to.Ptr("true"),
		// 																																																																																								},
		// 																																																																																								{
		// 																																																																																									Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																									Value: to.Ptr("false"),
		// 																																																																																							}},
		// 																																																																																							Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																							Locations: []*string{
		// 																																																																																								to.Ptr("southcentralus")},
		// 																																																																																								ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																								Restrictions: []*armstorage.Restriction{
		// 																																																																																								},
		// 																																																																																								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																							},
		// 																																																																																							{
		// 																																																																																								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																								Capabilities: []*armstorage.SKUCapability{
		// 																																																																																									{
		// 																																																																																										Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																										Value: to.Ptr("false"),
		// 																																																																																									},
		// 																																																																																									{
		// 																																																																																										Name: to.Ptr("supportschangenotification"),
		// 																																																																																										Value: to.Ptr("false"),
		// 																																																																																									},
		// 																																																																																									{
		// 																																																																																										Name: to.Ptr("supportsfileencryption"),
		// 																																																																																										Value: to.Ptr("false"),
		// 																																																																																									},
		// 																																																																																									{
		// 																																																																																										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																										Value: to.Ptr("true"),
		// 																																																																																									},
		// 																																																																																									{
		// 																																																																																										Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																										Value: to.Ptr("false"),
		// 																																																																																								}},
		// 																																																																																								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																								Locations: []*string{
		// 																																																																																									to.Ptr("southcentralus")},
		// 																																																																																									ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																									Restrictions: []*armstorage.Restriction{
		// 																																																																																									},
		// 																																																																																									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																								},
		// 																																																																																								{
		// 																																																																																									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																									Capabilities: []*armstorage.SKUCapability{
		// 																																																																																										{
		// 																																																																																											Name: to.Ptr("supportschangenotification"),
		// 																																																																																											Value: to.Ptr("false"),
		// 																																																																																										},
		// 																																																																																										{
		// 																																																																																											Name: to.Ptr("supportsfileencryption"),
		// 																																																																																											Value: to.Ptr("false"),
		// 																																																																																										},
		// 																																																																																										{
		// 																																																																																											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																											Value: to.Ptr("true"),
		// 																																																																																										},
		// 																																																																																										{
		// 																																																																																											Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																											Value: to.Ptr("false"),
		// 																																																																																									}},
		// 																																																																																									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																									Locations: []*string{
		// 																																																																																										to.Ptr("southcentralus")},
		// 																																																																																										ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																										Restrictions: []*armstorage.Restriction{
		// 																																																																																										},
		// 																																																																																										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																									},
		// 																																																																																									{
		// 																																																																																										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																										Capabilities: []*armstorage.SKUCapability{
		// 																																																																																											{
		// 																																																																																												Name: to.Ptr("supportschangenotification"),
		// 																																																																																												Value: to.Ptr("false"),
		// 																																																																																											},
		// 																																																																																											{
		// 																																																																																												Name: to.Ptr("supportsfileencryption"),
		// 																																																																																												Value: to.Ptr("false"),
		// 																																																																																											},
		// 																																																																																											{
		// 																																																																																												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																												Value: to.Ptr("true"),
		// 																																																																																											},
		// 																																																																																											{
		// 																																																																																												Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																												Value: to.Ptr("false"),
		// 																																																																																										}},
		// 																																																																																										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																										Locations: []*string{
		// 																																																																																											to.Ptr("southcentralus")},
		// 																																																																																											ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																											Restrictions: []*armstorage.Restriction{
		// 																																																																																											},
		// 																																																																																											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																										},
		// 																																																																																										{
		// 																																																																																											Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																											Capabilities: []*armstorage.SKUCapability{
		// 																																																																																												{
		// 																																																																																													Name: to.Ptr("supportsfileencryption"),
		// 																																																																																													Value: to.Ptr("true"),
		// 																																																																																												},
		// 																																																																																												{
		// 																																																																																													Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																													Value: to.Ptr("true"),
		// 																																																																																												},
		// 																																																																																												{
		// 																																																																																													Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																													Value: to.Ptr("false"),
		// 																																																																																											}},
		// 																																																																																											Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																											Locations: []*string{
		// 																																																																																												to.Ptr("centralus")},
		// 																																																																																												ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																												Restrictions: []*armstorage.Restriction{
		// 																																																																																												},
		// 																																																																																												Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																											},
		// 																																																																																											{
		// 																																																																																												Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																												Capabilities: []*armstorage.SKUCapability{
		// 																																																																																													{
		// 																																																																																														Name: to.Ptr("supportsfileencryption"),
		// 																																																																																														Value: to.Ptr("true"),
		// 																																																																																													},
		// 																																																																																													{
		// 																																																																																														Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																														Value: to.Ptr("true"),
		// 																																																																																													},
		// 																																																																																													{
		// 																																																																																														Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																														Value: to.Ptr("false"),
		// 																																																																																												}},
		// 																																																																																												Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																												Locations: []*string{
		// 																																																																																													to.Ptr("centralus")},
		// 																																																																																													ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																													Restrictions: []*armstorage.Restriction{
		// 																																																																																													},
		// 																																																																																													Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																												},
		// 																																																																																												{
		// 																																																																																													Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																													Capabilities: []*armstorage.SKUCapability{
		// 																																																																																														{
		// 																																																																																															Name: to.Ptr("supportsfileencryption"),
		// 																																																																																															Value: to.Ptr("true"),
		// 																																																																																														},
		// 																																																																																														{
		// 																																																																																															Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																															Value: to.Ptr("true"),
		// 																																																																																														},
		// 																																																																																														{
		// 																																																																																															Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																															Value: to.Ptr("false"),
		// 																																																																																													}},
		// 																																																																																													Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																													Locations: []*string{
		// 																																																																																														to.Ptr("centralus")},
		// 																																																																																														ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																														Restrictions: []*armstorage.Restriction{
		// 																																																																																														},
		// 																																																																																														Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																													},
		// 																																																																																													{
		// 																																																																																														Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																														Capabilities: []*armstorage.SKUCapability{
		// 																																																																																															{
		// 																																																																																																Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																Value: to.Ptr("true"),
		// 																																																																																															},
		// 																																																																																															{
		// 																																																																																																Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																Value: to.Ptr("true"),
		// 																																																																																															},
		// 																																																																																															{
		// 																																																																																																Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																Value: to.Ptr("false"),
		// 																																																																																														}},
		// 																																																																																														Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																														Locations: []*string{
		// 																																																																																															to.Ptr("centralus")},
		// 																																																																																															ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																															Restrictions: []*armstorage.Restriction{
		// 																																																																																															},
		// 																																																																																															Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																														},
		// 																																																																																														{
		// 																																																																																															Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																															Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																{
		// 																																																																																																	Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																},
		// 																																																																																																{
		// 																																																																																																	Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																	Value: to.Ptr("true"),
		// 																																																																																																},
		// 																																																																																																{
		// 																																																																																																	Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																	Value: to.Ptr("false"),
		// 																																																																																															}},
		// 																																																																																															Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																															Locations: []*string{
		// 																																																																																																to.Ptr("centralus")},
		// 																																																																																																ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																Restrictions: []*armstorage.Restriction{
		// 																																																																																																},
		// 																																																																																																Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																															},
		// 																																																																																															{
		// 																																																																																																Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																	{
		// 																																																																																																		Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																	},
		// 																																																																																																	{
		// 																																																																																																		Name: to.Ptr("supportschangenotification"),
		// 																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																	},
		// 																																																																																																	{
		// 																																																																																																		Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																	},
		// 																																																																																																	{
		// 																																																																																																		Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																		Value: to.Ptr("true"),
		// 																																																																																																	},
		// 																																																																																																	{
		// 																																																																																																		Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																}},
		// 																																																																																																Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																Locations: []*string{
		// 																																																																																																	to.Ptr("centralus")},
		// 																																																																																																	ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																	Restrictions: []*armstorage.Restriction{
		// 																																																																																																	},
		// 																																																																																																	Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																},
		// 																																																																																																{
		// 																																																																																																	Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																	Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																		{
		// 																																																																																																			Name: to.Ptr("supportschangenotification"),
		// 																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																		},
		// 																																																																																																		{
		// 																																																																																																			Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																		},
		// 																																																																																																		{
		// 																																																																																																			Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																			Value: to.Ptr("true"),
		// 																																																																																																		},
		// 																																																																																																		{
		// 																																																																																																			Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																	}},
		// 																																																																																																	Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																	Locations: []*string{
		// 																																																																																																		to.Ptr("centralus")},
		// 																																																																																																		ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																		Restrictions: []*armstorage.Restriction{
		// 																																																																																																		},
		// 																																																																																																		Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																	},
		// 																																																																																																	{
		// 																																																																																																		Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																		Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																			{
		// 																																																																																																				Name: to.Ptr("supportschangenotification"),
		// 																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																			},
		// 																																																																																																			{
		// 																																																																																																				Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																			},
		// 																																																																																																			{
		// 																																																																																																				Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																				Value: to.Ptr("true"),
		// 																																																																																																			},
		// 																																																																																																			{
		// 																																																																																																				Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																		}},
		// 																																																																																																		Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																		Locations: []*string{
		// 																																																																																																			to.Ptr("centralus")},
		// 																																																																																																			ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																			Restrictions: []*armstorage.Restriction{
		// 																																																																																																			},
		// 																																																																																																			Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																		},
		// 																																																																																																		{
		// 																																																																																																			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																			Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																				{
		// 																																																																																																					Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																					Value: to.Ptr("true"),
		// 																																																																																																				},
		// 																																																																																																				{
		// 																																																																																																					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																				},
		// 																																																																																																				{
		// 																																																																																																					Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																			}},
		// 																																																																																																			Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																			Locations: []*string{
		// 																																																																																																				to.Ptr("northeurope")},
		// 																																																																																																				ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																				Restrictions: []*armstorage.Restriction{
		// 																																																																																																				},
		// 																																																																																																				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																			},
		// 																																																																																																			{
		// 																																																																																																				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																				Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																					{
		// 																																																																																																						Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																						Value: to.Ptr("true"),
		// 																																																																																																					},
		// 																																																																																																					{
		// 																																																																																																						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																					},
		// 																																																																																																					{
		// 																																																																																																						Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																				}},
		// 																																																																																																				Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																				Locations: []*string{
		// 																																																																																																					to.Ptr("northeurope")},
		// 																																																																																																					ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																					Restrictions: []*armstorage.Restriction{
		// 																																																																																																					},
		// 																																																																																																					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																				},
		// 																																																																																																				{
		// 																																																																																																					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																					Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																						{
		// 																																																																																																							Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																							Value: to.Ptr("true"),
		// 																																																																																																						},
		// 																																																																																																						{
		// 																																																																																																							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																						},
		// 																																																																																																						{
		// 																																																																																																							Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																					}},
		// 																																																																																																					Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																					Locations: []*string{
		// 																																																																																																						to.Ptr("northeurope")},
		// 																																																																																																						ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																						Restrictions: []*armstorage.Restriction{
		// 																																																																																																						},
		// 																																																																																																						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																					},
		// 																																																																																																					{
		// 																																																																																																						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																						Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																							{
		// 																																																																																																								Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																								Value: to.Ptr("true"),
		// 																																																																																																							},
		// 																																																																																																							{
		// 																																																																																																								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																							},
		// 																																																																																																							{
		// 																																																																																																								Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																						}},
		// 																																																																																																						Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																						Locations: []*string{
		// 																																																																																																							to.Ptr("northeurope")},
		// 																																																																																																							ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																							Restrictions: []*armstorage.Restriction{
		// 																																																																																																							},
		// 																																																																																																							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																						},
		// 																																																																																																						{
		// 																																																																																																							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																							Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																								{
		// 																																																																																																									Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																								},
		// 																																																																																																								{
		// 																																																																																																									Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																								},
		// 																																																																																																								{
		// 																																																																																																									Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																							}},
		// 																																																																																																							Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																							Locations: []*string{
		// 																																																																																																								to.Ptr("northeurope")},
		// 																																																																																																								ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																								Restrictions: []*armstorage.Restriction{
		// 																																																																																																								},
		// 																																																																																																								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																							},
		// 																																																																																																							{
		// 																																																																																																								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																								Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																									{
		// 																																																																																																										Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																									},
		// 																																																																																																									{
		// 																																																																																																										Name: to.Ptr("supportschangenotification"),
		// 																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																									},
		// 																																																																																																									{
		// 																																																																																																										Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																									},
		// 																																																																																																									{
		// 																																																																																																										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																									},
		// 																																																																																																									{
		// 																																																																																																										Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																								}},
		// 																																																																																																								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																								Locations: []*string{
		// 																																																																																																									to.Ptr("northeurope")},
		// 																																																																																																									ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																									Restrictions: []*armstorage.Restriction{
		// 																																																																																																									},
		// 																																																																																																									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																								},
		// 																																																																																																								{
		// 																																																																																																									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																									Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																										{
		// 																																																																																																											Name: to.Ptr("supportschangenotification"),
		// 																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																										},
		// 																																																																																																										{
		// 																																																																																																											Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																										},
		// 																																																																																																										{
		// 																																																																																																											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																										},
		// 																																																																																																										{
		// 																																																																																																											Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																									}},
		// 																																																																																																									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																									Locations: []*string{
		// 																																																																																																										to.Ptr("northeurope")},
		// 																																																																																																										ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																										Restrictions: []*armstorage.Restriction{
		// 																																																																																																										},
		// 																																																																																																										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																									},
		// 																																																																																																									{
		// 																																																																																																										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																										Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																											{
		// 																																																																																																												Name: to.Ptr("supportschangenotification"),
		// 																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																											},
		// 																																																																																																											{
		// 																																																																																																												Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																											},
		// 																																																																																																											{
		// 																																																																																																												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																											},
		// 																																																																																																											{
		// 																																																																																																												Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																										}},
		// 																																																																																																										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																										Locations: []*string{
		// 																																																																																																											to.Ptr("northeurope")},
		// 																																																																																																											ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																											Restrictions: []*armstorage.Restriction{
		// 																																																																																																											},
		// 																																																																																																											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																										},
		// 																																																																																																										{
		// 																																																																																																											Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																											Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																												{
		// 																																																																																																													Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																													Value: to.Ptr("true"),
		// 																																																																																																												},
		// 																																																																																																												{
		// 																																																																																																													Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																												},
		// 																																																																																																												{
		// 																																																																																																													Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																											}},
		// 																																																																																																											Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																											Locations: []*string{
		// 																																																																																																												to.Ptr("brazilsouth")},
		// 																																																																																																												ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																												Restrictions: []*armstorage.Restriction{
		// 																																																																																																												},
		// 																																																																																																												Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																											},
		// 																																																																																																											{
		// 																																																																																																												Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																												Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																													{
		// 																																																																																																														Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																														Value: to.Ptr("true"),
		// 																																																																																																													},
		// 																																																																																																													{
		// 																																																																																																														Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																													},
		// 																																																																																																													{
		// 																																																																																																														Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																												}},
		// 																																																																																																												Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																												Locations: []*string{
		// 																																																																																																													to.Ptr("brazilsouth")},
		// 																																																																																																													ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																													Restrictions: []*armstorage.Restriction{
		// 																																																																																																													},
		// 																																																																																																													Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																												},
		// 																																																																																																												{
		// 																																																																																																													Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																													Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																														{
		// 																																																																																																															Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																															Value: to.Ptr("true"),
		// 																																																																																																														},
		// 																																																																																																														{
		// 																																																																																																															Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																														},
		// 																																																																																																														{
		// 																																																																																																															Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																													}},
		// 																																																																																																													Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																													Locations: []*string{
		// 																																																																																																														to.Ptr("brazilsouth")},
		// 																																																																																																														ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																														Restrictions: []*armstorage.Restriction{
		// 																																																																																																														},
		// 																																																																																																														Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																													},
		// 																																																																																																													{
		// 																																																																																																														Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																														Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																															{
		// 																																																																																																																Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																Value: to.Ptr("true"),
		// 																																																																																																															},
		// 																																																																																																															{
		// 																																																																																																																Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																															},
		// 																																																																																																															{
		// 																																																																																																																Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																														}},
		// 																																																																																																														Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																														Locations: []*string{
		// 																																																																																																															to.Ptr("brazilsouth")},
		// 																																																																																																															ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																															Restrictions: []*armstorage.Restriction{
		// 																																																																																																															},
		// 																																																																																																															Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																														},
		// 																																																																																																														{
		// 																																																																																																															Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																															Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																{
		// 																																																																																																																	Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																},
		// 																																																																																																																{
		// 																																																																																																																	Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																},
		// 																																																																																																																{
		// 																																																																																																																	Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																															}},
		// 																																																																																																															Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																															Locations: []*string{
		// 																																																																																																																to.Ptr("brazilsouth")},
		// 																																																																																																																ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																Restrictions: []*armstorage.Restriction{
		// 																																																																																																																},
		// 																																																																																																																Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																															},
		// 																																																																																																															{
		// 																																																																																																																Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																	{
		// 																																																																																																																		Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																	},
		// 																																																																																																																	{
		// 																																																																																																																		Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																	},
		// 																																																																																																																	{
		// 																																																																																																																		Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																	},
		// 																																																																																																																	{
		// 																																																																																																																		Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																	},
		// 																																																																																																																	{
		// 																																																																																																																		Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																}},
		// 																																																																																																																Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																Locations: []*string{
		// 																																																																																																																	to.Ptr("brazilsouth")},
		// 																																																																																																																	ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																	Restrictions: []*armstorage.Restriction{
		// 																																																																																																																	},
		// 																																																																																																																	Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																},
		// 																																																																																																																{
		// 																																																																																																																	Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																	Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																		{
		// 																																																																																																																			Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																		},
		// 																																																																																																																		{
		// 																																																																																																																			Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																		},
		// 																																																																																																																		{
		// 																																																																																																																			Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																		},
		// 																																																																																																																		{
		// 																																																																																																																			Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																	}},
		// 																																																																																																																	Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																	Locations: []*string{
		// 																																																																																																																		to.Ptr("brazilsouth")},
		// 																																																																																																																		ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																		Restrictions: []*armstorage.Restriction{
		// 																																																																																																																		},
		// 																																																																																																																		Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																	},
		// 																																																																																																																	{
		// 																																																																																																																		Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																		Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																			{
		// 																																																																																																																				Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																			},
		// 																																																																																																																			{
		// 																																																																																																																				Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																			},
		// 																																																																																																																			{
		// 																																																																																																																				Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																			},
		// 																																																																																																																			{
		// 																																																																																																																				Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																		}},
		// 																																																																																																																		Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																		Locations: []*string{
		// 																																																																																																																			to.Ptr("brazilsouth")},
		// 																																																																																																																			ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																			Restrictions: []*armstorage.Restriction{
		// 																																																																																																																			},
		// 																																																																																																																			Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																		},
		// 																																																																																																																		{
		// 																																																																																																																			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																			Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																				{
		// 																																																																																																																					Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																					Value: to.Ptr("true"),
		// 																																																																																																																				},
		// 																																																																																																																				{
		// 																																																																																																																					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																																				},
		// 																																																																																																																				{
		// 																																																																																																																					Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																																			}},
		// 																																																																																																																			Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																			Locations: []*string{
		// 																																																																																																																				to.Ptr("australiaeast")},
		// 																																																																																																																				ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																				Restrictions: []*armstorage.Restriction{
		// 																																																																																																																				},
		// 																																																																																																																				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																			},
		// 																																																																																																																			{
		// 																																																																																																																				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																				Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																					{
		// 																																																																																																																						Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																						Value: to.Ptr("true"),
		// 																																																																																																																					},
		// 																																																																																																																					{
		// 																																																																																																																						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																																					},
		// 																																																																																																																					{
		// 																																																																																																																						Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																																				}},
		// 																																																																																																																				Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																				Locations: []*string{
		// 																																																																																																																					to.Ptr("australiaeast")},
		// 																																																																																																																					ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																					Restrictions: []*armstorage.Restriction{
		// 																																																																																																																					},
		// 																																																																																																																					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																				},
		// 																																																																																																																				{
		// 																																																																																																																					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																					Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																						{
		// 																																																																																																																							Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																							Value: to.Ptr("true"),
		// 																																																																																																																						},
		// 																																																																																																																						{
		// 																																																																																																																							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																																						},
		// 																																																																																																																						{
		// 																																																																																																																							Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																																					}},
		// 																																																																																																																					Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																					Locations: []*string{
		// 																																																																																																																						to.Ptr("australiaeast")},
		// 																																																																																																																						ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																						Restrictions: []*armstorage.Restriction{
		// 																																																																																																																						},
		// 																																																																																																																						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																					},
		// 																																																																																																																					{
		// 																																																																																																																						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																						Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																							{
		// 																																																																																																																								Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																								Value: to.Ptr("true"),
		// 																																																																																																																							},
		// 																																																																																																																							{
		// 																																																																																																																								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																							},
		// 																																																																																																																							{
		// 																																																																																																																								Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																						}},
		// 																																																																																																																						Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																						Locations: []*string{
		// 																																																																																																																							to.Ptr("australiaeast")},
		// 																																																																																																																							ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																							Restrictions: []*armstorage.Restriction{
		// 																																																																																																																							},
		// 																																																																																																																							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																						},
		// 																																																																																																																						{
		// 																																																																																																																							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																							Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																								{
		// 																																																																																																																									Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																								},
		// 																																																																																																																								{
		// 																																																																																																																									Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																								},
		// 																																																																																																																								{
		// 																																																																																																																									Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																							}},
		// 																																																																																																																							Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																							Locations: []*string{
		// 																																																																																																																								to.Ptr("australiaeast")},
		// 																																																																																																																								ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																								Restrictions: []*armstorage.Restriction{
		// 																																																																																																																								},
		// 																																																																																																																								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																							},
		// 																																																																																																																							{
		// 																																																																																																																								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																								Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																									{
		// 																																																																																																																										Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																									},
		// 																																																																																																																									{
		// 																																																																																																																										Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																									},
		// 																																																																																																																									{
		// 																																																																																																																										Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																									},
		// 																																																																																																																									{
		// 																																																																																																																										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																									},
		// 																																																																																																																									{
		// 																																																																																																																										Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																								}},
		// 																																																																																																																								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																								Locations: []*string{
		// 																																																																																																																									to.Ptr("australiaeast")},
		// 																																																																																																																									ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																									Restrictions: []*armstorage.Restriction{
		// 																																																																																																																									},
		// 																																																																																																																									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																								},
		// 																																																																																																																								{
		// 																																																																																																																									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																									Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																										{
		// 																																																																																																																											Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																										},
		// 																																																																																																																										{
		// 																																																																																																																											Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																										},
		// 																																																																																																																										{
		// 																																																																																																																											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																										},
		// 																																																																																																																										{
		// 																																																																																																																											Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																									}},
		// 																																																																																																																									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																									Locations: []*string{
		// 																																																																																																																										to.Ptr("australiaeast")},
		// 																																																																																																																										ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																										Restrictions: []*armstorage.Restriction{
		// 																																																																																																																										},
		// 																																																																																																																										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																									},
		// 																																																																																																																									{
		// 																																																																																																																										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																										Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																											{
		// 																																																																																																																												Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																											},
		// 																																																																																																																											{
		// 																																																																																																																												Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																											},
		// 																																																																																																																											{
		// 																																																																																																																												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																											},
		// 																																																																																																																											{
		// 																																																																																																																												Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																										}},
		// 																																																																																																																										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																										Locations: []*string{
		// 																																																																																																																											to.Ptr("australiaeast")},
		// 																																																																																																																											ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																											Restrictions: []*armstorage.Restriction{
		// 																																																																																																																											},
		// 																																																																																																																											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																										},
		// 																																																																																																																										{
		// 																																																																																																																											Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																											Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																												{
		// 																																																																																																																													Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																													Value: to.Ptr("true"),
		// 																																																																																																																												},
		// 																																																																																																																												{
		// 																																																																																																																													Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																																												},
		// 																																																																																																																												{
		// 																																																																																																																													Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																																											}},
		// 																																																																																																																											Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																											Locations: []*string{
		// 																																																																																																																												to.Ptr("australiasoutheast")},
		// 																																																																																																																												ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																												Restrictions: []*armstorage.Restriction{
		// 																																																																																																																												},
		// 																																																																																																																												Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																											},
		// 																																																																																																																											{
		// 																																																																																																																												Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																												Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																													{
		// 																																																																																																																														Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																														Value: to.Ptr("true"),
		// 																																																																																																																													},
		// 																																																																																																																													{
		// 																																																																																																																														Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																																													},
		// 																																																																																																																													{
		// 																																																																																																																														Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																																												}},
		// 																																																																																																																												Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																												Locations: []*string{
		// 																																																																																																																													to.Ptr("australiasoutheast")},
		// 																																																																																																																													ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																													Restrictions: []*armstorage.Restriction{
		// 																																																																																																																													},
		// 																																																																																																																													Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																												},
		// 																																																																																																																												{
		// 																																																																																																																													Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																													Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																														{
		// 																																																																																																																															Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																															Value: to.Ptr("true"),
		// 																																																																																																																														},
		// 																																																																																																																														{
		// 																																																																																																																															Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																																														},
		// 																																																																																																																														{
		// 																																																																																																																															Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																																													}},
		// 																																																																																																																													Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																													Locations: []*string{
		// 																																																																																																																														to.Ptr("australiasoutheast")},
		// 																																																																																																																														ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																														Restrictions: []*armstorage.Restriction{
		// 																																																																																																																														},
		// 																																																																																																																														Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																													},
		// 																																																																																																																													{
		// 																																																																																																																														Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																														Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																															{
		// 																																																																																																																																Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																Value: to.Ptr("true"),
		// 																																																																																																																															},
		// 																																																																																																																															{
		// 																																																																																																																																Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																																															},
		// 																																																																																																																															{
		// 																																																																																																																																Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																																														}},
		// 																																																																																																																														Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																														Locations: []*string{
		// 																																																																																																																															to.Ptr("australiasoutheast")},
		// 																																																																																																																															ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																															Restrictions: []*armstorage.Restriction{
		// 																																																																																																																															},
		// 																																																																																																																															Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																														},
		// 																																																																																																																														{
		// 																																																																																																																															Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																															Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																{
		// 																																																																																																																																	Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																},
		// 																																																																																																																																{
		// 																																																																																																																																	Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																},
		// 																																																																																																																																{
		// 																																																																																																																																	Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																															}},
		// 																																																																																																																															Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																															Locations: []*string{
		// 																																																																																																																																to.Ptr("australiasoutheast")},
		// 																																																																																																																																ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																},
		// 																																																																																																																																Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																															},
		// 																																																																																																																															{
		// 																																																																																																																																Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																	{
		// 																																																																																																																																		Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																	},
		// 																																																																																																																																	{
		// 																																																																																																																																		Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																	},
		// 																																																																																																																																	{
		// 																																																																																																																																		Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																	},
		// 																																																																																																																																	{
		// 																																																																																																																																		Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																	},
		// 																																																																																																																																	{
		// 																																																																																																																																		Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																}},
		// 																																																																																																																																Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																Locations: []*string{
		// 																																																																																																																																	to.Ptr("australiasoutheast")},
		// 																																																																																																																																	ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																	Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																	},
		// 																																																																																																																																	Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																},
		// 																																																																																																																																{
		// 																																																																																																																																	Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																	Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																		{
		// 																																																																																																																																			Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																		},
		// 																																																																																																																																		{
		// 																																																																																																																																			Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																		},
		// 																																																																																																																																		{
		// 																																																																																																																																			Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																		},
		// 																																																																																																																																		{
		// 																																																																																																																																			Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																	}},
		// 																																																																																																																																	Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																	Locations: []*string{
		// 																																																																																																																																		to.Ptr("australiasoutheast")},
		// 																																																																																																																																		ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																		Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																		},
		// 																																																																																																																																		Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																	},
		// 																																																																																																																																	{
		// 																																																																																																																																		Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																		Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																			{
		// 																																																																																																																																				Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																			},
		// 																																																																																																																																			{
		// 																																																																																																																																				Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																			},
		// 																																																																																																																																			{
		// 																																																																																																																																				Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																			},
		// 																																																																																																																																			{
		// 																																																																																																																																				Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																		}},
		// 																																																																																																																																		Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																		Locations: []*string{
		// 																																																																																																																																			to.Ptr("australiasoutheast")},
		// 																																																																																																																																			ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																			Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																			},
		// 																																																																																																																																			Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																		},
		// 																																																																																																																																		{
		// 																																																																																																																																			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																			Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																				{
		// 																																																																																																																																					Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																					Value: to.Ptr("true"),
		// 																																																																																																																																				},
		// 																																																																																																																																				{
		// 																																																																																																																																					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																																																				},
		// 																																																																																																																																				{
		// 																																																																																																																																					Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																																																			}},
		// 																																																																																																																																			Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																			Locations: []*string{
		// 																																																																																																																																				to.Ptr("southindia")},
		// 																																																																																																																																				ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																				Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																				},
		// 																																																																																																																																				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																			},
		// 																																																																																																																																			{
		// 																																																																																																																																				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																																				Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																					{
		// 																																																																																																																																						Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																						Value: to.Ptr("true"),
		// 																																																																																																																																					},
		// 																																																																																																																																					{
		// 																																																																																																																																						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																																																					},
		// 																																																																																																																																					{
		// 																																																																																																																																						Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																																																				}},
		// 																																																																																																																																				Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																				Locations: []*string{
		// 																																																																																																																																					to.Ptr("southindia")},
		// 																																																																																																																																					ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																					Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																					},
		// 																																																																																																																																					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																				},
		// 																																																																																																																																				{
		// 																																																																																																																																					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																					Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																						{
		// 																																																																																																																																							Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																							Value: to.Ptr("true"),
		// 																																																																																																																																						},
		// 																																																																																																																																						{
		// 																																																																																																																																							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																																																						},
		// 																																																																																																																																						{
		// 																																																																																																																																							Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																																																					}},
		// 																																																																																																																																					Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																					Locations: []*string{
		// 																																																																																																																																						to.Ptr("southindia")},
		// 																																																																																																																																						ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																						Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																						},
		// 																																																																																																																																						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																					},
		// 																																																																																																																																					{
		// 																																																																																																																																						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																						Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																							{
		// 																																																																																																																																								Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																								Value: to.Ptr("true"),
		// 																																																																																																																																							},
		// 																																																																																																																																							{
		// 																																																																																																																																								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																																							},
		// 																																																																																																																																							{
		// 																																																																																																																																								Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																																						}},
		// 																																																																																																																																						Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																						Locations: []*string{
		// 																																																																																																																																							to.Ptr("southindia")},
		// 																																																																																																																																							ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																							Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																							},
		// 																																																																																																																																							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																						},
		// 																																																																																																																																						{
		// 																																																																																																																																							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																																							Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																								{
		// 																																																																																																																																									Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																								},
		// 																																																																																																																																								{
		// 																																																																																																																																									Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																								},
		// 																																																																																																																																								{
		// 																																																																																																																																									Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																							}},
		// 																																																																																																																																							Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																							Locations: []*string{
		// 																																																																																																																																								to.Ptr("southindia")},
		// 																																																																																																																																								ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																								Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																								},
		// 																																																																																																																																								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																																							},
		// 																																																																																																																																							{
		// 																																																																																																																																								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																								Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																									{
		// 																																																																																																																																										Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																									},
		// 																																																																																																																																									{
		// 																																																																																																																																										Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																									},
		// 																																																																																																																																									{
		// 																																																																																																																																										Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																									},
		// 																																																																																																																																									{
		// 																																																																																																																																										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																									},
		// 																																																																																																																																									{
		// 																																																																																																																																										Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																								}},
		// 																																																																																																																																								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																								Locations: []*string{
		// 																																																																																																																																									to.Ptr("southindia")},
		// 																																																																																																																																									ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																									Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																									},
		// 																																																																																																																																									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																								},
		// 																																																																																																																																								{
		// 																																																																																																																																									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																									Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																										{
		// 																																																																																																																																											Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																										},
		// 																																																																																																																																										{
		// 																																																																																																																																											Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																										},
		// 																																																																																																																																										{
		// 																																																																																																																																											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																										},
		// 																																																																																																																																										{
		// 																																																																																																																																											Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																									}},
		// 																																																																																																																																									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																									Locations: []*string{
		// 																																																																																																																																										to.Ptr("southindia")},
		// 																																																																																																																																										ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																										Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																										},
		// 																																																																																																																																										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																									},
		// 																																																																																																																																									{
		// 																																																																																																																																										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																										Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																											{
		// 																																																																																																																																												Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																											},
		// 																																																																																																																																											{
		// 																																																																																																																																												Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																											},
		// 																																																																																																																																											{
		// 																																																																																																																																												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																											},
		// 																																																																																																																																											{
		// 																																																																																																																																												Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																										}},
		// 																																																																																																																																										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																										Locations: []*string{
		// 																																																																																																																																											to.Ptr("southindia")},
		// 																																																																																																																																											ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																											Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																											},
		// 																																																																																																																																											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																										},
		// 																																																																																																																																										{
		// 																																																																																																																																											Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																											Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																												{
		// 																																																																																																																																													Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																													Value: to.Ptr("true"),
		// 																																																																																																																																												},
		// 																																																																																																																																												{
		// 																																																																																																																																													Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																																																												},
		// 																																																																																																																																												{
		// 																																																																																																																																													Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																																																											}},
		// 																																																																																																																																											Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																											Locations: []*string{
		// 																																																																																																																																												to.Ptr("centralindia")},
		// 																																																																																																																																												ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																												Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																												},
		// 																																																																																																																																												Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																											},
		// 																																																																																																																																											{
		// 																																																																																																																																												Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																																												Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																													{
		// 																																																																																																																																														Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																														Value: to.Ptr("true"),
		// 																																																																																																																																													},
		// 																																																																																																																																													{
		// 																																																																																																																																														Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																																																													},
		// 																																																																																																																																													{
		// 																																																																																																																																														Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																																																												}},
		// 																																																																																																																																												Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																												Locations: []*string{
		// 																																																																																																																																													to.Ptr("centralindia")},
		// 																																																																																																																																													ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																													Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																													},
		// 																																																																																																																																													Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																												},
		// 																																																																																																																																												{
		// 																																																																																																																																													Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																													Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																														{
		// 																																																																																																																																															Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																															Value: to.Ptr("true"),
		// 																																																																																																																																														},
		// 																																																																																																																																														{
		// 																																																																																																																																															Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																																																														},
		// 																																																																																																																																														{
		// 																																																																																																																																															Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																																																													}},
		// 																																																																																																																																													Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																													Locations: []*string{
		// 																																																																																																																																														to.Ptr("centralindia")},
		// 																																																																																																																																														ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																														Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																														},
		// 																																																																																																																																														Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																													},
		// 																																																																																																																																													{
		// 																																																																																																																																														Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																														Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																															{
		// 																																																																																																																																																Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																Value: to.Ptr("true"),
		// 																																																																																																																																															},
		// 																																																																																																																																															{
		// 																																																																																																																																																Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																																																															},
		// 																																																																																																																																															{
		// 																																																																																																																																																Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																																																														}},
		// 																																																																																																																																														Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																														Locations: []*string{
		// 																																																																																																																																															to.Ptr("centralindia")},
		// 																																																																																																																																															ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																															Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																															},
		// 																																																																																																																																															Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																														},
		// 																																																																																																																																														{
		// 																																																																																																																																															Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																																															Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																{
		// 																																																																																																																																																	Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																},
		// 																																																																																																																																																{
		// 																																																																																																																																																	Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																},
		// 																																																																																																																																																{
		// 																																																																																																																																																	Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																															}},
		// 																																																																																																																																															Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																															Locations: []*string{
		// 																																																																																																																																																to.Ptr("centralindia")},
		// 																																																																																																																																																ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																},
		// 																																																																																																																																																Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																																															},
		// 																																																																																																																																															{
		// 																																																																																																																																																Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																	{
		// 																																																																																																																																																		Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																	},
		// 																																																																																																																																																	{
		// 																																																																																																																																																		Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																	},
		// 																																																																																																																																																	{
		// 																																																																																																																																																		Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																	},
		// 																																																																																																																																																	{
		// 																																																																																																																																																		Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																	},
		// 																																																																																																																																																	{
		// 																																																																																																																																																		Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																}},
		// 																																																																																																																																																Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																Locations: []*string{
		// 																																																																																																																																																	to.Ptr("centralindia")},
		// 																																																																																																																																																	ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																	Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																	},
		// 																																																																																																																																																	Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																},
		// 																																																																																																																																																{
		// 																																																																																																																																																	Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																	Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																		{
		// 																																																																																																																																																			Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																		},
		// 																																																																																																																																																		{
		// 																																																																																																																																																			Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																		},
		// 																																																																																																																																																		{
		// 																																																																																																																																																			Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																		},
		// 																																																																																																																																																		{
		// 																																																																																																																																																			Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																	}},
		// 																																																																																																																																																	Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																	Locations: []*string{
		// 																																																																																																																																																		to.Ptr("centralindia")},
		// 																																																																																																																																																		ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																		Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																		},
		// 																																																																																																																																																		Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																	},
		// 																																																																																																																																																	{
		// 																																																																																																																																																		Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																		Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																			{
		// 																																																																																																																																																				Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																			},
		// 																																																																																																																																																			{
		// 																																																																																																																																																				Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																			},
		// 																																																																																																																																																			{
		// 																																																																																																																																																				Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																			},
		// 																																																																																																																																																			{
		// 																																																																																																																																																				Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																		}},
		// 																																																																																																																																																		Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																		Locations: []*string{
		// 																																																																																																																																																			to.Ptr("centralindia")},
		// 																																																																																																																																																			ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																			Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																			},
		// 																																																																																																																																																			Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																		},
		// 																																																																																																																																																		{
		// 																																																																																																																																																			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																			Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																				{
		// 																																																																																																																																																					Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																					Value: to.Ptr("true"),
		// 																																																																																																																																																				},
		// 																																																																																																																																																				{
		// 																																																																																																																																																					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																																																																				},
		// 																																																																																																																																																				{
		// 																																																																																																																																																					Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																																																																			}},
		// 																																																																																																																																																			Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																			Locations: []*string{
		// 																																																																																																																																																				to.Ptr("westindia")},
		// 																																																																																																																																																				ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																				Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																				},
		// 																																																																																																																																																				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																			},
		// 																																																																																																																																																			{
		// 																																																																																																																																																				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																																																				Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																					{
		// 																																																																																																																																																						Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																						Value: to.Ptr("true"),
		// 																																																																																																																																																					},
		// 																																																																																																																																																					{
		// 																																																																																																																																																						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																																																																					},
		// 																																																																																																																																																					{
		// 																																																																																																																																																						Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																																																																				}},
		// 																																																																																																																																																				Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																				Locations: []*string{
		// 																																																																																																																																																					to.Ptr("westindia")},
		// 																																																																																																																																																					ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																					Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																					},
		// 																																																																																																																																																					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																				},
		// 																																																																																																																																																				{
		// 																																																																																																																																																					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																					Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																						{
		// 																																																																																																																																																							Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																							Value: to.Ptr("true"),
		// 																																																																																																																																																						},
		// 																																																																																																																																																						{
		// 																																																																																																																																																							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																																																																						},
		// 																																																																																																																																																						{
		// 																																																																																																																																																							Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																																																																					}},
		// 																																																																																																																																																					Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																					Locations: []*string{
		// 																																																																																																																																																						to.Ptr("westindia")},
		// 																																																																																																																																																						ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																						Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																						},
		// 																																																																																																																																																						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																					},
		// 																																																																																																																																																					{
		// 																																																																																																																																																						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																						Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																							{
		// 																																																																																																																																																								Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																								Value: to.Ptr("true"),
		// 																																																																																																																																																							},
		// 																																																																																																																																																							{
		// 																																																																																																																																																								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																																																							},
		// 																																																																																																																																																							{
		// 																																																																																																																																																								Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																																																						}},
		// 																																																																																																																																																						Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																						Locations: []*string{
		// 																																																																																																																																																							to.Ptr("westindia")},
		// 																																																																																																																																																							ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																							Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																							},
		// 																																																																																																																																																							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																						},
		// 																																																																																																																																																						{
		// 																																																																																																																																																							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																																																							Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																								{
		// 																																																																																																																																																									Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																								},
		// 																																																																																																																																																								{
		// 																																																																																																																																																									Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																								},
		// 																																																																																																																																																								{
		// 																																																																																																																																																									Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																							}},
		// 																																																																																																																																																							Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																							Locations: []*string{
		// 																																																																																																																																																								to.Ptr("westindia")},
		// 																																																																																																																																																								ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																								Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																								},
		// 																																																																																																																																																								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																																																							},
		// 																																																																																																																																																							{
		// 																																																																																																																																																								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																								Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																									{
		// 																																																																																																																																																										Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																									},
		// 																																																																																																																																																									{
		// 																																																																																																																																																										Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																									},
		// 																																																																																																																																																									{
		// 																																																																																																																																																										Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																									},
		// 																																																																																																																																																									{
		// 																																																																																																																																																										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																									},
		// 																																																																																																																																																									{
		// 																																																																																																																																																										Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																								}},
		// 																																																																																																																																																								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																								Locations: []*string{
		// 																																																																																																																																																									to.Ptr("westindia")},
		// 																																																																																																																																																									ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																									Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																									},
		// 																																																																																																																																																									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																								},
		// 																																																																																																																																																								{
		// 																																																																																																																																																									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																									Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																										{
		// 																																																																																																																																																											Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																										},
		// 																																																																																																																																																										{
		// 																																																																																																																																																											Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																										},
		// 																																																																																																																																																										{
		// 																																																																																																																																																											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																										},
		// 																																																																																																																																																										{
		// 																																																																																																																																																											Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																									}},
		// 																																																																																																																																																									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																									Locations: []*string{
		// 																																																																																																																																																										to.Ptr("westindia")},
		// 																																																																																																																																																										ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																										Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																										},
		// 																																																																																																																																																										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																									},
		// 																																																																																																																																																									{
		// 																																																																																																																																																										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																										Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																											{
		// 																																																																																																																																																												Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																											},
		// 																																																																																																																																																											{
		// 																																																																																																																																																												Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																											},
		// 																																																																																																																																																											{
		// 																																																																																																																																																												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																											},
		// 																																																																																																																																																											{
		// 																																																																																																																																																												Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																										}},
		// 																																																																																																																																																										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																										Locations: []*string{
		// 																																																																																																																																																											to.Ptr("westindia")},
		// 																																																																																																																																																											ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																											Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																											},
		// 																																																																																																																																																											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																										},
		// 																																																																																																																																																										{
		// 																																																																																																																																																											Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																											Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																												{
		// 																																																																																																																																																													Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																													Value: to.Ptr("true"),
		// 																																																																																																																																																												},
		// 																																																																																																																																																												{
		// 																																																																																																																																																													Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																																																																												},
		// 																																																																																																																																																												{
		// 																																																																																																																																																													Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																																																																											}},
		// 																																																																																																																																																											Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																											Locations: []*string{
		// 																																																																																																																																																												to.Ptr("canadaeast")},
		// 																																																																																																																																																												ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																												Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																												},
		// 																																																																																																																																																												Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																											},
		// 																																																																																																																																																											{
		// 																																																																																																																																																												Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																																																												Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																													{
		// 																																																																																																																																																														Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																														Value: to.Ptr("true"),
		// 																																																																																																																																																													},
		// 																																																																																																																																																													{
		// 																																																																																																																																																														Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																																																																													},
		// 																																																																																																																																																													{
		// 																																																																																																																																																														Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																																																																												}},
		// 																																																																																																																																																												Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																												Locations: []*string{
		// 																																																																																																																																																													to.Ptr("canadaeast")},
		// 																																																																																																																																																													ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																													Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																													},
		// 																																																																																																																																																													Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																												},
		// 																																																																																																																																																												{
		// 																																																																																																																																																													Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																													Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																														{
		// 																																																																																																																																																															Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																															Value: to.Ptr("true"),
		// 																																																																																																																																																														},
		// 																																																																																																																																																														{
		// 																																																																																																																																																															Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																																																																														},
		// 																																																																																																																																																														{
		// 																																																																																																																																																															Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																																																																													}},
		// 																																																																																																																																																													Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																													Locations: []*string{
		// 																																																																																																																																																														to.Ptr("canadaeast")},
		// 																																																																																																																																																														ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																														Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																														},
		// 																																																																																																																																																														Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																													},
		// 																																																																																																																																																													{
		// 																																																																																																																																																														Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																														Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																															{
		// 																																																																																																																																																																Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																Value: to.Ptr("true"),
		// 																																																																																																																																																															},
		// 																																																																																																																																																															{
		// 																																																																																																																																																																Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																																																																															},
		// 																																																																																																																																																															{
		// 																																																																																																																																																																Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																																																																														}},
		// 																																																																																																																																																														Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																														Locations: []*string{
		// 																																																																																																																																																															to.Ptr("canadaeast")},
		// 																																																																																																																																																															ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																															Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																															},
		// 																																																																																																																																																															Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																														},
		// 																																																																																																																																																														{
		// 																																																																																																																																																															Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																																																															Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																{
		// 																																																																																																																																																																	Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																																},
		// 																																																																																																																																																																{
		// 																																																																																																																																																																	Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																																},
		// 																																																																																																																																																																{
		// 																																																																																																																																																																	Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																															}},
		// 																																																																																																																																																															Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																															Locations: []*string{
		// 																																																																																																																																																																to.Ptr("canadaeast")},
		// 																																																																																																																																																																ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																},
		// 																																																																																																																																																																Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																																																															},
		// 																																																																																																																																																															{
		// 																																																																																																																																																																Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																	{
		// 																																																																																																																																																																		Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																	},
		// 																																																																																																																																																																	{
		// 																																																																																																																																																																		Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																	},
		// 																																																																																																																																																																	{
		// 																																																																																																																																																																		Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																	},
		// 																																																																																																																																																																	{
		// 																																																																																																																																																																		Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																	},
		// 																																																																																																																																																																	{
		// 																																																																																																																																																																		Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																}},
		// 																																																																																																																																																																Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																Locations: []*string{
		// 																																																																																																																																																																	to.Ptr("canadaeast")},
		// 																																																																																																																																																																	ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																	Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																	},
		// 																																																																																																																																																																	Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																},
		// 																																																																																																																																																																{
		// 																																																																																																																																																																	Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																	Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																		{
		// 																																																																																																																																																																			Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																		},
		// 																																																																																																																																																																		{
		// 																																																																																																																																																																			Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																		},
		// 																																																																																																																																																																		{
		// 																																																																																																																																																																			Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																		},
		// 																																																																																																																																																																		{
		// 																																																																																																																																																																			Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																	}},
		// 																																																																																																																																																																	Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																	Locations: []*string{
		// 																																																																																																																																																																		to.Ptr("canadaeast")},
		// 																																																																																																																																																																		ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																		Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																		},
		// 																																																																																																																																																																		Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																	},
		// 																																																																																																																																																																	{
		// 																																																																																																																																																																		Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																		Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																			{
		// 																																																																																																																																																																				Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																			},
		// 																																																																																																																																																																			{
		// 																																																																																																																																																																				Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																			},
		// 																																																																																																																																																																			{
		// 																																																																																																																																																																				Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																			},
		// 																																																																																																																																																																			{
		// 																																																																																																																																																																				Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																		}},
		// 																																																																																																																																																																		Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																		Locations: []*string{
		// 																																																																																																																																																																			to.Ptr("canadaeast")},
		// 																																																																																																																																																																			ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																			Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																			},
		// 																																																																																																																																																																			Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																		},
		// 																																																																																																																																																																		{
		// 																																																																																																																																																																			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																			Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																				{
		// 																																																																																																																																																																					Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																					Value: to.Ptr("true"),
		// 																																																																																																																																																																				},
		// 																																																																																																																																																																				{
		// 																																																																																																																																																																					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																																																																																				},
		// 																																																																																																																																																																				{
		// 																																																																																																																																																																					Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																																																																																			}},
		// 																																																																																																																																																																			Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																			Locations: []*string{
		// 																																																																																																																																																																				to.Ptr("canadacentral")},
		// 																																																																																																																																																																				ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																				Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																				},
		// 																																																																																																																																																																				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																			},
		// 																																																																																																																																																																			{
		// 																																																																																																																																																																				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																																																																				Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																					{
		// 																																																																																																																																																																						Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																						Value: to.Ptr("true"),
		// 																																																																																																																																																																					},
		// 																																																																																																																																																																					{
		// 																																																																																																																																																																						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																																																																																					},
		// 																																																																																																																																																																					{
		// 																																																																																																																																																																						Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																																																																																				}},
		// 																																																																																																																																																																				Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																				Locations: []*string{
		// 																																																																																																																																																																					to.Ptr("canadacentral")},
		// 																																																																																																																																																																					ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																					Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																					},
		// 																																																																																																																																																																					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																				},
		// 																																																																																																																																																																				{
		// 																																																																																																																																																																					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																					Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																						{
		// 																																																																																																																																																																							Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																							Value: to.Ptr("true"),
		// 																																																																																																																																																																						},
		// 																																																																																																																																																																						{
		// 																																																																																																																																																																							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																																																																																						},
		// 																																																																																																																																																																						{
		// 																																																																																																																																																																							Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																																																																																					}},
		// 																																																																																																																																																																					Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																					Locations: []*string{
		// 																																																																																																																																																																						to.Ptr("canadacentral")},
		// 																																																																																																																																																																						ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																						Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																						},
		// 																																																																																																																																																																						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																					},
		// 																																																																																																																																																																					{
		// 																																																																																																																																																																						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																						Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																							{
		// 																																																																																																																																																																								Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																								Value: to.Ptr("true"),
		// 																																																																																																																																																																							},
		// 																																																																																																																																																																							{
		// 																																																																																																																																																																								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																																																																							},
		// 																																																																																																																																																																							{
		// 																																																																																																																																																																								Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																																																																						}},
		// 																																																																																																																																																																						Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																						Locations: []*string{
		// 																																																																																																																																																																							to.Ptr("canadacentral")},
		// 																																																																																																																																																																							ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																							Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																							},
		// 																																																																																																																																																																							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																						},
		// 																																																																																																																																																																						{
		// 																																																																																																																																																																							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																																																																							Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																								{
		// 																																																																																																																																																																									Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																																								},
		// 																																																																																																																																																																								{
		// 																																																																																																																																																																									Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																																								},
		// 																																																																																																																																																																								{
		// 																																																																																																																																																																									Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																																							}},
		// 																																																																																																																																																																							Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																							Locations: []*string{
		// 																																																																																																																																																																								to.Ptr("canadacentral")},
		// 																																																																																																																																																																								ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																								Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																								},
		// 																																																																																																																																																																								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																																																																							},
		// 																																																																																																																																																																							{
		// 																																																																																																																																																																								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																								Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																									{
		// 																																																																																																																																																																										Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																									},
		// 																																																																																																																																																																									{
		// 																																																																																																																																																																										Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																									},
		// 																																																																																																																																																																									{
		// 																																																																																																																																																																										Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																									},
		// 																																																																																																																																																																									{
		// 																																																																																																																																																																										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																									},
		// 																																																																																																																																																																									{
		// 																																																																																																																																																																										Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																								}},
		// 																																																																																																																																																																								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																								Locations: []*string{
		// 																																																																																																																																																																									to.Ptr("canadacentral")},
		// 																																																																																																																																																																									ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																									Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																									},
		// 																																																																																																																																																																									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																								},
		// 																																																																																																																																																																								{
		// 																																																																																																																																																																									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																									Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																										{
		// 																																																																																																																																																																											Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																										},
		// 																																																																																																																																																																										{
		// 																																																																																																																																																																											Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																										},
		// 																																																																																																																																																																										{
		// 																																																																																																																																																																											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																										},
		// 																																																																																																																																																																										{
		// 																																																																																																																																																																											Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																									}},
		// 																																																																																																																																																																									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																									Locations: []*string{
		// 																																																																																																																																																																										to.Ptr("canadacentral")},
		// 																																																																																																																																																																										ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																										Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																										},
		// 																																																																																																																																																																										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																									},
		// 																																																																																																																																																																									{
		// 																																																																																																																																																																										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																										Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																											{
		// 																																																																																																																																																																												Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																											},
		// 																																																																																																																																																																											{
		// 																																																																																																																																																																												Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																											},
		// 																																																																																																																																																																											{
		// 																																																																																																																																																																												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																											},
		// 																																																																																																																																																																											{
		// 																																																																																																																																																																												Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																										}},
		// 																																																																																																																																																																										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																										Locations: []*string{
		// 																																																																																																																																																																											to.Ptr("canadacentral")},
		// 																																																																																																																																																																											ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																											Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																											},
		// 																																																																																																																																																																											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																										},
		// 																																																																																																																																																																										{
		// 																																																																																																																																																																											Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																											Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																												{
		// 																																																																																																																																																																													Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																													Value: to.Ptr("true"),
		// 																																																																																																																																																																												},
		// 																																																																																																																																																																												{
		// 																																																																																																																																																																													Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																													Value: to.Ptr("true"),
		// 																																																																																																																																																																												},
		// 																																																																																																																																																																												{
		// 																																																																																																																																																																													Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																																																																																											}},
		// 																																																																																																																																																																											Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																											Locations: []*string{
		// 																																																																																																																																																																												to.Ptr("westus2")},
		// 																																																																																																																																																																												ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																												Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																												},
		// 																																																																																																																																																																												Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																											},
		// 																																																																																																																																																																											{
		// 																																																																																																																																																																												Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																																																																												Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																													{
		// 																																																																																																																																																																														Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																														Value: to.Ptr("true"),
		// 																																																																																																																																																																													},
		// 																																																																																																																																																																													{
		// 																																																																																																																																																																														Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																														Value: to.Ptr("true"),
		// 																																																																																																																																																																													},
		// 																																																																																																																																																																													{
		// 																																																																																																																																																																														Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																																																																																												}},
		// 																																																																																																																																																																												Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																												Locations: []*string{
		// 																																																																																																																																																																													to.Ptr("westus2")},
		// 																																																																																																																																																																													ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																													Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																													},
		// 																																																																																																																																																																													Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																												},
		// 																																																																																																																																																																												{
		// 																																																																																																																																																																													Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																													Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																														{
		// 																																																																																																																																																																															Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																															Value: to.Ptr("true"),
		// 																																																																																																																																																																														},
		// 																																																																																																																																																																														{
		// 																																																																																																																																																																															Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																															Value: to.Ptr("true"),
		// 																																																																																																																																																																														},
		// 																																																																																																																																																																														{
		// 																																																																																																																																																																															Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																																																																																													}},
		// 																																																																																																																																																																													Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																													Locations: []*string{
		// 																																																																																																																																																																														to.Ptr("westus2")},
		// 																																																																																																																																																																														ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																														Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																														},
		// 																																																																																																																																																																														Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																													},
		// 																																																																																																																																																																													{
		// 																																																																																																																																																																														Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																														Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																															{
		// 																																																																																																																																																																																Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																Value: to.Ptr("true"),
		// 																																																																																																																																																																															},
		// 																																																																																																																																																																															{
		// 																																																																																																																																																																																Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																Value: to.Ptr("true"),
		// 																																																																																																																																																																															},
		// 																																																																																																																																																																															{
		// 																																																																																																																																																																																Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																																																																																														}},
		// 																																																																																																																																																																														Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																														Locations: []*string{
		// 																																																																																																																																																																															to.Ptr("westus2")},
		// 																																																																																																																																																																															ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																															Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																															},
		// 																																																																																																																																																																															Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																														},
		// 																																																																																																																																																																														{
		// 																																																																																																																																																																															Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																																																																															Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																{
		// 																																																																																																																																																																																	Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																																																},
		// 																																																																																																																																																																																{
		// 																																																																																																																																																																																	Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																	Value: to.Ptr("true"),
		// 																																																																																																																																																																																},
		// 																																																																																																																																																																																{
		// 																																																																																																																																																																																	Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																																															}},
		// 																																																																																																																																																																															Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																															Locations: []*string{
		// 																																																																																																																																																																																to.Ptr("westus2")},
		// 																																																																																																																																																																																ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																},
		// 																																																																																																																																																																																Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																																																																															},
		// 																																																																																																																																																																															{
		// 																																																																																																																																																																																Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																	{
		// 																																																																																																																																																																																		Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																	},
		// 																																																																																																																																																																																	{
		// 																																																																																																																																																																																		Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																	},
		// 																																																																																																																																																																																	{
		// 																																																																																																																																																																																		Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																	},
		// 																																																																																																																																																																																	{
		// 																																																																																																																																																																																		Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																		Value: to.Ptr("true"),
		// 																																																																																																																																																																																	},
		// 																																																																																																																																																																																	{
		// 																																																																																																																																																																																		Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																}},
		// 																																																																																																																																																																																Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																Locations: []*string{
		// 																																																																																																																																																																																	to.Ptr("westus2")},
		// 																																																																																																																																																																																	ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																	Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																	},
		// 																																																																																																																																																																																	Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																},
		// 																																																																																																																																																																																{
		// 																																																																																																																																																																																	Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																	Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																		{
		// 																																																																																																																																																																																			Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																		},
		// 																																																																																																																																																																																		{
		// 																																																																																																																																																																																			Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																		},
		// 																																																																																																																																																																																		{
		// 																																																																																																																																																																																			Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																			Value: to.Ptr("true"),
		// 																																																																																																																																																																																		},
		// 																																																																																																																																																																																		{
		// 																																																																																																																																																																																			Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																	}},
		// 																																																																																																																																																																																	Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																	Locations: []*string{
		// 																																																																																																																																																																																		to.Ptr("westus2")},
		// 																																																																																																																																																																																		ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																		Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																		},
		// 																																																																																																																																																																																		Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																	},
		// 																																																																																																																																																																																	{
		// 																																																																																																																																																																																		Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																		Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																			{
		// 																																																																																																																																																																																				Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																			},
		// 																																																																																																																																																																																			{
		// 																																																																																																																																																																																				Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																			},
		// 																																																																																																																																																																																			{
		// 																																																																																																																																																																																				Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																				Value: to.Ptr("true"),
		// 																																																																																																																																																																																			},
		// 																																																																																																																																																																																			{
		// 																																																																																																																																																																																				Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																		}},
		// 																																																																																																																																																																																		Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																		Locations: []*string{
		// 																																																																																																																																																																																			to.Ptr("westus2")},
		// 																																																																																																																																																																																			ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																			Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																			},
		// 																																																																																																																																																																																			Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																		},
		// 																																																																																																																																																																																		{
		// 																																																																																																																																																																																			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																			Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																				{
		// 																																																																																																																																																																																					Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																					Value: to.Ptr("true"),
		// 																																																																																																																																																																																				},
		// 																																																																																																																																																																																				{
		// 																																																																																																																																																																																					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																					Value: to.Ptr("true"),
		// 																																																																																																																																																																																				},
		// 																																																																																																																																																																																				{
		// 																																																																																																																																																																																					Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																					Value: to.Ptr("true"),
		// 																																																																																																																																																																																			}},
		// 																																																																																																																																																																																			Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																			Locations: []*string{
		// 																																																																																																																																																																																				to.Ptr("westcentralus")},
		// 																																																																																																																																																																																				ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																				Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																				},
		// 																																																																																																																																																																																				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																			},
		// 																																																																																																																																																																																			{
		// 																																																																																																																																																																																				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																																																																																				Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																					{
		// 																																																																																																																																																																																						Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																						Value: to.Ptr("true"),
		// 																																																																																																																																																																																					},
		// 																																																																																																																																																																																					{
		// 																																																																																																																																																																																						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																						Value: to.Ptr("true"),
		// 																																																																																																																																																																																					},
		// 																																																																																																																																																																																					{
		// 																																																																																																																																																																																						Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																						Value: to.Ptr("true"),
		// 																																																																																																																																																																																				}},
		// 																																																																																																																																																																																				Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																				Locations: []*string{
		// 																																																																																																																																																																																					to.Ptr("westcentralus")},
		// 																																																																																																																																																																																					ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																					Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																					},
		// 																																																																																																																																																																																					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																				},
		// 																																																																																																																																																																																				{
		// 																																																																																																																																																																																					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																					Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																						{
		// 																																																																																																																																																																																							Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																							Value: to.Ptr("true"),
		// 																																																																																																																																																																																						},
		// 																																																																																																																																																																																						{
		// 																																																																																																																																																																																							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																							Value: to.Ptr("true"),
		// 																																																																																																																																																																																						},
		// 																																																																																																																																																																																						{
		// 																																																																																																																																																																																							Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																							Value: to.Ptr("true"),
		// 																																																																																																																																																																																					}},
		// 																																																																																																																																																																																					Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																					Locations: []*string{
		// 																																																																																																																																																																																						to.Ptr("westcentralus")},
		// 																																																																																																																																																																																						ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																						Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																						},
		// 																																																																																																																																																																																						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																					},
		// 																																																																																																																																																																																					{
		// 																																																																																																																																																																																						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																						Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																							{
		// 																																																																																																																																																																																								Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																								Value: to.Ptr("true"),
		// 																																																																																																																																																																																							},
		// 																																																																																																																																																																																							{
		// 																																																																																																																																																																																								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																								Value: to.Ptr("true"),
		// 																																																																																																																																																																																							},
		// 																																																																																																																																																																																							{
		// 																																																																																																																																																																																								Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																																																																																						}},
		// 																																																																																																																																																																																						Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																						Locations: []*string{
		// 																																																																																																																																																																																							to.Ptr("westcentralus")},
		// 																																																																																																																																																																																							ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																							Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																							},
		// 																																																																																																																																																																																							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																						},
		// 																																																																																																																																																																																						{
		// 																																																																																																																																																																																							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																																																																																							Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																								{
		// 																																																																																																																																																																																									Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																																																								},
		// 																																																																																																																																																																																								{
		// 																																																																																																																																																																																									Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																									Value: to.Ptr("true"),
		// 																																																																																																																																																																																								},
		// 																																																																																																																																																																																								{
		// 																																																																																																																																																																																									Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																									Value: to.Ptr("true"),
		// 																																																																																																																																																																																							}},
		// 																																																																																																																																																																																							Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																							Locations: []*string{
		// 																																																																																																																																																																																								to.Ptr("westcentralus")},
		// 																																																																																																																																																																																								ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																								Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																								},
		// 																																																																																																																																																																																								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																																																																																							},
		// 																																																																																																																																																																																							{
		// 																																																																																																																																																																																								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																								Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																									{
		// 																																																																																																																																																																																										Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																									},
		// 																																																																																																																																																																																									{
		// 																																																																																																																																																																																										Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																									},
		// 																																																																																																																																																																																									{
		// 																																																																																																																																																																																										Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																									},
		// 																																																																																																																																																																																									{
		// 																																																																																																																																																																																										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																										Value: to.Ptr("true"),
		// 																																																																																																																																																																																									},
		// 																																																																																																																																																																																									{
		// 																																																																																																																																																																																										Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																										Value: to.Ptr("true"),
		// 																																																																																																																																																																																								}},
		// 																																																																																																																																																																																								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																								Locations: []*string{
		// 																																																																																																																																																																																									to.Ptr("westcentralus")},
		// 																																																																																																																																																																																									ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																									Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																									},
		// 																																																																																																																																																																																									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																								},
		// 																																																																																																																																																																																								{
		// 																																																																																																																																																																																									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																									Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																										{
		// 																																																																																																																																																																																											Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																										},
		// 																																																																																																																																																																																										{
		// 																																																																																																																																																																																											Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																										},
		// 																																																																																																																																																																																										{
		// 																																																																																																																																																																																											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																											Value: to.Ptr("true"),
		// 																																																																																																																																																																																										},
		// 																																																																																																																																																																																										{
		// 																																																																																																																																																																																											Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																											Value: to.Ptr("true"),
		// 																																																																																																																																																																																									}},
		// 																																																																																																																																																																																									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																									Locations: []*string{
		// 																																																																																																																																																																																										to.Ptr("westcentralus")},
		// 																																																																																																																																																																																										ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																										Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																										},
		// 																																																																																																																																																																																										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																									},
		// 																																																																																																																																																																																									{
		// 																																																																																																																																																																																										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																										Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																											{
		// 																																																																																																																																																																																												Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																											},
		// 																																																																																																																																																																																											{
		// 																																																																																																																																																																																												Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																											},
		// 																																																																																																																																																																																											{
		// 																																																																																																																																																																																												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																												Value: to.Ptr("true"),
		// 																																																																																																																																																																																											},
		// 																																																																																																																																																																																											{
		// 																																																																																																																																																																																												Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																										}},
		// 																																																																																																																																																																																										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																										Locations: []*string{
		// 																																																																																																																																																																																											to.Ptr("westcentralus")},
		// 																																																																																																																																																																																											ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																											Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																											},
		// 																																																																																																																																																																																											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																										},
		// 																																																																																																																																																																																										{
		// 																																																																																																																																																																																											Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																											Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																												{
		// 																																																																																																																																																																																													Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																													Value: to.Ptr("true"),
		// 																																																																																																																																																																																												},
		// 																																																																																																																																																																																												{
		// 																																																																																																																																																																																													Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																																																																																																												},
		// 																																																																																																																																																																																												{
		// 																																																																																																																																																																																													Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																																																																																																											}},
		// 																																																																																																																																																																																											Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																											Locations: []*string{
		// 																																																																																																																																																																																												to.Ptr("uksouth")},
		// 																																																																																																																																																																																												ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																												Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																												},
		// 																																																																																																																																																																																												Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																											},
		// 																																																																																																																																																																																											{
		// 																																																																																																																																																																																												Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																																																																																												Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																													{
		// 																																																																																																																																																																																														Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																														Value: to.Ptr("true"),
		// 																																																																																																																																																																																													},
		// 																																																																																																																																																																																													{
		// 																																																																																																																																																																																														Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																																																																																																													},
		// 																																																																																																																																																																																													{
		// 																																																																																																																																																																																														Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																																																																																																												}},
		// 																																																																																																																																																																																												Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																												Locations: []*string{
		// 																																																																																																																																																																																													to.Ptr("uksouth")},
		// 																																																																																																																																																																																													ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																													Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																													},
		// 																																																																																																																																																																																													Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																												},
		// 																																																																																																																																																																																												{
		// 																																																																																																																																																																																													Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																													Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																														{
		// 																																																																																																																																																																																															Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																															Value: to.Ptr("true"),
		// 																																																																																																																																																																																														},
		// 																																																																																																																																																																																														{
		// 																																																																																																																																																																																															Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																																																																																																														},
		// 																																																																																																																																																																																														{
		// 																																																																																																																																																																																															Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																																																																																																													}},
		// 																																																																																																																																																																																													Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																													Locations: []*string{
		// 																																																																																																																																																																																														to.Ptr("uksouth")},
		// 																																																																																																																																																																																														ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																														Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																														},
		// 																																																																																																																																																																																														Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																													},
		// 																																																																																																																																																																																													{
		// 																																																																																																																																																																																														Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																														Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																															{
		// 																																																																																																																																																																																																Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																Value: to.Ptr("true"),
		// 																																																																																																																																																																																															},
		// 																																																																																																																																																																																															{
		// 																																																																																																																																																																																																Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																																																																																																															},
		// 																																																																																																																																																																																															{
		// 																																																																																																																																																																																																Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																																																																																																														}},
		// 																																																																																																																																																																																														Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																														Locations: []*string{
		// 																																																																																																																																																																																															to.Ptr("uksouth")},
		// 																																																																																																																																																																																															ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																															Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																															},
		// 																																																																																																																																																																																															Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																														},
		// 																																																																																																																																																																																														{
		// 																																																																																																																																																																																															Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																																																																																															Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																{
		// 																																																																																																																																																																																																	Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																																																																},
		// 																																																																																																																																																																																																{
		// 																																																																																																																																																																																																	Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																																																																},
		// 																																																																																																																																																																																																{
		// 																																																																																																																																																																																																	Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																																																															}},
		// 																																																																																																																																																																																															Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																															Locations: []*string{
		// 																																																																																																																																																																																																to.Ptr("uksouth")},
		// 																																																																																																																																																																																																ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																},
		// 																																																																																																																																																																																																Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																																																																																															},
		// 																																																																																																																																																																																															{
		// 																																																																																																																																																																																																Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																																Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																		Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																		Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																		Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																		Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																		Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																}},
		// 																																																																																																																																																																																																Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																Locations: []*string{
		// 																																																																																																																																																																																																	to.Ptr("uksouth")},
		// 																																																																																																																																																																																																	ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																	Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																	Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																},
		// 																																																																																																																																																																																																{
		// 																																																																																																																																																																																																	Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																																	Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																			Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																			Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																			Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																			Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																																	}},
		// 																																																																																																																																																																																																	Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																	Locations: []*string{
		// 																																																																																																																																																																																																		to.Ptr("uksouth")},
		// 																																																																																																																																																																																																		ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																		Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																		Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																		Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																																		Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																				Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																				Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																				Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																				Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																																		}},
		// 																																																																																																																																																																																																		Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																		Locations: []*string{
		// 																																																																																																																																																																																																			to.Ptr("uksouth")},
		// 																																																																																																																																																																																																			ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																			Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																			Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																																			Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																					Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																					Value: to.Ptr("true"),
		// 																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																					Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																																																																																																																			}},
		// 																																																																																																																																																																																																			Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																			Locations: []*string{
		// 																																																																																																																																																																																																				to.Ptr("ukwest")},
		// 																																																																																																																																																																																																				ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																				Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																																																																																																				Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																						Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																						Value: to.Ptr("true"),
		// 																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																						Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																																																																																																																				}},
		// 																																																																																																																																																																																																				Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																				Locations: []*string{
		// 																																																																																																																																																																																																					to.Ptr("ukwest")},
		// 																																																																																																																																																																																																					ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																					Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																																					Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																							Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																							Value: to.Ptr("true"),
		// 																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																							Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																																																																																																																					}},
		// 																																																																																																																																																																																																					Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																					Locations: []*string{
		// 																																																																																																																																																																																																						to.Ptr("ukwest")},
		// 																																																																																																																																																																																																						ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																						Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																																						Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																								Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																								Value: to.Ptr("true"),
		// 																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																								Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																																																																																																						}},
		// 																																																																																																																																																																																																						Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																						Locations: []*string{
		// 																																																																																																																																																																																																							to.Ptr("ukwest")},
		// 																																																																																																																																																																																																							ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																							Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																																																																																																							Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																									Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																									Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																									Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																																																																							}},
		// 																																																																																																																																																																																																							Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																							Locations: []*string{
		// 																																																																																																																																																																																																								to.Ptr("ukwest")},
		// 																																																																																																																																																																																																								ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																								Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																																								Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																										Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																										Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																										Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																										Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																								}},
		// 																																																																																																																																																																																																								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																								Locations: []*string{
		// 																																																																																																																																																																																																									to.Ptr("ukwest")},
		// 																																																																																																																																																																																																									ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																									Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																																									Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																											Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																											Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																											Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																																									}},
		// 																																																																																																																																																																																																									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																									Locations: []*string{
		// 																																																																																																																																																																																																										to.Ptr("ukwest")},
		// 																																																																																																																																																																																																										ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																										Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																																										Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																												Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																												Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																												Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																																										}},
		// 																																																																																																																																																																																																										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																										Locations: []*string{
		// 																																																																																																																																																																																																											to.Ptr("ukwest")},
		// 																																																																																																																																																																																																											ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																											Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																											Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																																											Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																												{
		// 																																																																																																																																																																																																													Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																													Value: to.Ptr("true"),
		// 																																																																																																																																																																																																												},
		// 																																																																																																																																																																																																												{
		// 																																																																																																																																																																																																													Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																																																																																																																												},
		// 																																																																																																																																																																																																												{
		// 																																																																																																																																																																																																													Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																																																																																																																											}},
		// 																																																																																																																																																																																																											Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																											Locations: []*string{
		// 																																																																																																																																																																																																												to.Ptr("koreacentral")},
		// 																																																																																																																																																																																																												ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																												Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																												},
		// 																																																																																																																																																																																																												Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																												Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																																																																																																												Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																													{
		// 																																																																																																																																																																																																														Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																														Value: to.Ptr("true"),
		// 																																																																																																																																																																																																													},
		// 																																																																																																																																																																																																													{
		// 																																																																																																																																																																																																														Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																																																																																																																													},
		// 																																																																																																																																																																																																													{
		// 																																																																																																																																																																																																														Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																																																																																																																												}},
		// 																																																																																																																																																																																																												Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																												Locations: []*string{
		// 																																																																																																																																																																																																													to.Ptr("koreacentral")},
		// 																																																																																																																																																																																																													ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																													Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																													},
		// 																																																																																																																																																																																																													Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																												},
		// 																																																																																																																																																																																																												{
		// 																																																																																																																																																																																																													Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																																													Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																														{
		// 																																																																																																																																																																																																															Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																															Value: to.Ptr("true"),
		// 																																																																																																																																																																																																														},
		// 																																																																																																																																																																																																														{
		// 																																																																																																																																																																																																															Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																																																																																																																														},
		// 																																																																																																																																																																																																														{
		// 																																																																																																																																																																																																															Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																																																																																																																													}},
		// 																																																																																																																																																																																																													Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																													Locations: []*string{
		// 																																																																																																																																																																																																														to.Ptr("koreacentral")},
		// 																																																																																																																																																																																																														ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																														Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																														},
		// 																																																																																																																																																																																																														Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																													},
		// 																																																																																																																																																																																																													{
		// 																																																																																																																																																																																																														Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																																														Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																															{
		// 																																																																																																																																																																																																																Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																Value: to.Ptr("true"),
		// 																																																																																																																																																																																																															},
		// 																																																																																																																																																																																																															{
		// 																																																																																																																																																																																																																Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																																																																																																																															},
		// 																																																																																																																																																																																																															{
		// 																																																																																																																																																																																																																Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																																																																																																																														}},
		// 																																																																																																																																																																																																														Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																														Locations: []*string{
		// 																																																																																																																																																																																																															to.Ptr("koreacentral")},
		// 																																																																																																																																																																																																															ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																															Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																															},
		// 																																																																																																																																																																																																															Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																														},
		// 																																																																																																																																																																																																														{
		// 																																																																																																																																																																																																															Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																																																																																																															Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																{
		// 																																																																																																																																																																																																																	Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																},
		// 																																																																																																																																																																																																																{
		// 																																																																																																																																																																																																																	Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																},
		// 																																																																																																																																																																																																																{
		// 																																																																																																																																																																																																																	Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																																																																															}},
		// 																																																																																																																																																																																																															Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																															Locations: []*string{
		// 																																																																																																																																																																																																																to.Ptr("koreacentral")},
		// 																																																																																																																																																																																																																ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																},
		// 																																																																																																																																																																																																																Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																																																																																																															},
		// 																																																																																																																																																																																																															{
		// 																																																																																																																																																																																																																Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																																																Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																		Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																		Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																		Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																		Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																		Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																}},
		// 																																																																																																																																																																																																																Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																Locations: []*string{
		// 																																																																																																																																																																																																																	to.Ptr("koreacentral")},
		// 																																																																																																																																																																																																																	ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																	Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																	Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																},
		// 																																																																																																																																																																																																																{
		// 																																																																																																																																																																																																																	Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																																																	Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																																			Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																																			Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																																			Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																																			Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																	}},
		// 																																																																																																																																																																																																																	Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																	Locations: []*string{
		// 																																																																																																																																																																																																																		to.Ptr("koreacentral")},
		// 																																																																																																																																																																																																																		ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																		Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																																		Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																		Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																																																		Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																																				Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																																				Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																																				Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																																				Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																		}},
		// 																																																																																																																																																																																																																		Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																		Locations: []*string{
		// 																																																																																																																																																																																																																			to.Ptr("koreacentral")},
		// 																																																																																																																																																																																																																			ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																			Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																																			Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																																			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																																																			Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																																					Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																					Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																																					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																																					Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																			}},
		// 																																																																																																																																																																																																																			Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																			Locations: []*string{
		// 																																																																																																																																																																																																																				to.Ptr("koreasouth")},
		// 																																																																																																																																																																																																																				ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																				Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																																				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																																				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																																																																																																																				Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																																						Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																						Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																																						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																																						Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																				}},
		// 																																																																																																																																																																																																																				Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																				Locations: []*string{
		// 																																																																																																																																																																																																																					to.Ptr("koreasouth")},
		// 																																																																																																																																																																																																																					ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																					Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																																					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																																					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																																																					Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																																							Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																							Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																																							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																																							Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																					}},
		// 																																																																																																																																																																																																																					Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																					Locations: []*string{
		// 																																																																																																																																																																																																																						to.Ptr("koreasouth")},
		// 																																																																																																																																																																																																																						ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																						Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																																						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																																						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																																																						Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																																								Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																								Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																																								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																																								Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																						}},
		// 																																																																																																																																																																																																																						Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																						Locations: []*string{
		// 																																																																																																																																																																																																																							to.Ptr("koreasouth")},
		// 																																																																																																																																																																																																																							ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																							Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																																							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																																							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																																																																																																																							Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																																									Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																																									Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																																									Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																							}},
		// 																																																																																																																																																																																																																							Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																							Locations: []*string{
		// 																																																																																																																																																																																																																								to.Ptr("koreasouth")},
		// 																																																																																																																																																																																																																								ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																								Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																																								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																																								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																																																								Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																										Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																										Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																										Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																										Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																								}},
		// 																																																																																																																																																																																																																								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																								Locations: []*string{
		// 																																																																																																																																																																																																																									to.Ptr("koreasouth")},
		// 																																																																																																																																																																																																																									ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																									Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																																									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																																																									Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																																											Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																																											Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																																											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																																											Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																									}},
		// 																																																																																																																																																																																																																									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																									Locations: []*string{
		// 																																																																																																																																																																																																																										to.Ptr("koreasouth")},
		// 																																																																																																																																																																																																																										ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																										Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																																										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																																																										Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																																												Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																																												Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																																												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																																												Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																										}},
		// 																																																																																																																																																																																																																										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																										Locations: []*string{
		// 																																																																																																																																																																																																																											to.Ptr("koreasouth")},
		// 																																																																																																																																																																																																																											ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																											Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																																											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																																											Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																																																											Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																												{
		// 																																																																																																																																																																																																																													Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																													Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																												},
		// 																																																																																																																																																																																																																												{
		// 																																																																																																																																																																																																																													Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																												},
		// 																																																																																																																																																																																																																												{
		// 																																																																																																																																																																																																																													Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																											}},
		// 																																																																																																																																																																																																																											Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																											Locations: []*string{
		// 																																																																																																																																																																																																																												to.Ptr("uknorth")},
		// 																																																																																																																																																																																																																												ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																												Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																												},
		// 																																																																																																																																																																																																																												Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																																												Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																																																																																																																												Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																													{
		// 																																																																																																																																																																																																																														Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																														Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																													},
		// 																																																																																																																																																																																																																													{
		// 																																																																																																																																																																																																																														Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																													},
		// 																																																																																																																																																																																																																													{
		// 																																																																																																																																																																																																																														Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																												}},
		// 																																																																																																																																																																																																																												Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																												Locations: []*string{
		// 																																																																																																																																																																																																																													to.Ptr("uknorth")},
		// 																																																																																																																																																																																																																													ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																													Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																													},
		// 																																																																																																																																																																																																																													Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																												},
		// 																																																																																																																																																																																																																												{
		// 																																																																																																																																																																																																																													Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																																																													Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																														{
		// 																																																																																																																																																																																																																															Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																															Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																														},
		// 																																																																																																																																																																																																																														{
		// 																																																																																																																																																																																																																															Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																														},
		// 																																																																																																																																																																																																																														{
		// 																																																																																																																																																																																																																															Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																													}},
		// 																																																																																																																																																																																																																													Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																													Locations: []*string{
		// 																																																																																																																																																																																																																														to.Ptr("uknorth")},
		// 																																																																																																																																																																																																																														ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																														Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																														},
		// 																																																																																																																																																																																																																														Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																													},
		// 																																																																																																																																																																																																																													{
		// 																																																																																																																																																																																																																														Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																																																														Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																															{
		// 																																																																																																																																																																																																																																Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																															},
		// 																																																																																																																																																																																																																															{
		// 																																																																																																																																																																																																																																Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																															},
		// 																																																																																																																																																																																																																															{
		// 																																																																																																																																																																																																																																Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																														}},
		// 																																																																																																																																																																																																																														Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																														Locations: []*string{
		// 																																																																																																																																																																																																																															to.Ptr("uknorth")},
		// 																																																																																																																																																																																																																															ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																															Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																															},
		// 																																																																																																																																																																																																																															Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																														},
		// 																																																																																																																																																																																																																														{
		// 																																																																																																																																																																																																																															Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																																																																																																																															Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																{
		// 																																																																																																																																																																																																																																	Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																},
		// 																																																																																																																																																																																																																																{
		// 																																																																																																																																																																																																																																	Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																},
		// 																																																																																																																																																																																																																																{
		// 																																																																																																																																																																																																																																	Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																															}},
		// 																																																																																																																																																																																																																															Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																															Locations: []*string{
		// 																																																																																																																																																																																																																																to.Ptr("uknorth")},
		// 																																																																																																																																																																																																																																ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																},
		// 																																																																																																																																																																																																																																Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																																																																																																																															},
		// 																																																																																																																																																																																																																															{
		// 																																																																																																																																																																																																																																Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																																																																Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																																		Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																																		Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																																		Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																																		Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																																		Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																}},
		// 																																																																																																																																																																																																																																Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																																Locations: []*string{
		// 																																																																																																																																																																																																																																	to.Ptr("uknorth")},
		// 																																																																																																																																																																																																																																	ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																	Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																																	Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																},
		// 																																																																																																																																																																																																																																{
		// 																																																																																																																																																																																																																																	Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																																																																	Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																																																			Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																																																			Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																																																			Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																																																			Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																	}},
		// 																																																																																																																																																																																																																																	Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																																	Locations: []*string{
		// 																																																																																																																																																																																																																																		to.Ptr("uknorth")},
		// 																																																																																																																																																																																																																																		ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																		Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																																																		Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																																		Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																																																																		Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																																																				Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																																																				Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																																																				Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																																																				Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																		}},
		// 																																																																																																																																																																																																																																		Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																																		Locations: []*string{
		// 																																																																																																																																																																																																																																			to.Ptr("uknorth")},
		// 																																																																																																																																																																																																																																			ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																			Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																																																			Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																																																			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																																																																			Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																																																					Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																					Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																																																					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																																																					Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																			}},
		// 																																																																																																																																																																																																																																			Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																																			Locations: []*string{
		// 																																																																																																																																																																																																																																				to.Ptr("uksouth2")},
		// 																																																																																																																																																																																																																																				ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																				Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																																																				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																																																				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																																																																																																																																				Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																																																						Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																						Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																																																						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																																																						Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																				}},
		// 																																																																																																																																																																																																																																				Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																																				Locations: []*string{
		// 																																																																																																																																																																																																																																					to.Ptr("uksouth2")},
		// 																																																																																																																																																																																																																																					ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																					Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																																																					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																																																					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																																																																					Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																																																							Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																							Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																																																							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																																																							Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																					}},
		// 																																																																																																																																																																																																																																					Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																																					Locations: []*string{
		// 																																																																																																																																																																																																																																						to.Ptr("uksouth2")},
		// 																																																																																																																																																																																																																																						ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																						Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																																																						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																																																						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																																																																						Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																																																								Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																								Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																																																								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																																																								Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																						}},
		// 																																																																																																																																																																																																																																						Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																																						Locations: []*string{
		// 																																																																																																																																																																																																																																							to.Ptr("uksouth2")},
		// 																																																																																																																																																																																																																																							ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																							Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																																																							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																																																							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																																																																																																																																							Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																																																									Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																																																									Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																																																									Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																							}},
		// 																																																																																																																																																																																																																																							Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																																							Locations: []*string{
		// 																																																																																																																																																																																																																																								to.Ptr("uksouth2")},
		// 																																																																																																																																																																																																																																								ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																								Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																																																								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																																																								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																																																																								Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																																										Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																																										Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																																										Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																																										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																																										Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																								}},
		// 																																																																																																																																																																																																																																								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																																								Locations: []*string{
		// 																																																																																																																																																																																																																																									to.Ptr("uksouth2")},
		// 																																																																																																																																																																																																																																									ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																									Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																																									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																																																									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																																																																									Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																																																											Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																																																											Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																																																											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																																																											Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																									}},
		// 																																																																																																																																																																																																																																									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																																									Locations: []*string{
		// 																																																																																																																																																																																																																																										to.Ptr("uksouth2")},
		// 																																																																																																																																																																																																																																										ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																										Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																																																										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																																										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																																																																										Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																																																												Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																																																												Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																																																												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																																																												Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																										}},
		// 																																																																																																																																																																																																																																										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																																										Locations: []*string{
		// 																																																																																																																																																																																																																																											to.Ptr("uksouth2")},
		// 																																																																																																																																																																																																																																											ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																											Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																																																											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																																																											Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																																																																											Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																												{
		// 																																																																																																																																																																																																																																													Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																													Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																												},
		// 																																																																																																																																																																																																																																												{
		// 																																																																																																																																																																																																																																													Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																													Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																												},
		// 																																																																																																																																																																																																																																												{
		// 																																																																																																																																																																																																																																													Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																													Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																											}},
		// 																																																																																																																																																																																																																																											Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																																											Locations: []*string{
		// 																																																																																																																																																																																																																																												to.Ptr("eastus2euap")},
		// 																																																																																																																																																																																																																																												ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																												Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																												},
		// 																																																																																																																																																																																																																																												Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																																																												Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																																																																																																																																												Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																													{
		// 																																																																																																																																																																																																																																														Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																														Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																													},
		// 																																																																																																																																																																																																																																													{
		// 																																																																																																																																																																																																																																														Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																														Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																													},
		// 																																																																																																																																																																																																																																													{
		// 																																																																																																																																																																																																																																														Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																														Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																												}},
		// 																																																																																																																																																																																																																																												Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																																												Locations: []*string{
		// 																																																																																																																																																																																																																																													to.Ptr("eastus2euap")},
		// 																																																																																																																																																																																																																																													ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																													Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																													},
		// 																																																																																																																																																																																																																																													Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																												},
		// 																																																																																																																																																																																																																																												{
		// 																																																																																																																																																																																																																																													Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																																																																													Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																														{
		// 																																																																																																																																																																																																																																															Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																															Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																														},
		// 																																																																																																																																																																																																																																														{
		// 																																																																																																																																																																																																																																															Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																															Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																														},
		// 																																																																																																																																																																																																																																														{
		// 																																																																																																																																																																																																																																															Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																															Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																													}},
		// 																																																																																																																																																																																																																																													Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																																													Locations: []*string{
		// 																																																																																																																																																																																																																																														to.Ptr("eastus2euap")},
		// 																																																																																																																																																																																																																																														ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																														Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																														},
		// 																																																																																																																																																																																																																																														Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																													},
		// 																																																																																																																																																																																																																																													{
		// 																																																																																																																																																																																																																																														Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																																																																														Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																															{
		// 																																																																																																																																																																																																																																																Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																																Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																															},
		// 																																																																																																																																																																																																																																															{
		// 																																																																																																																																																																																																																																																Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																															},
		// 																																																																																																																																																																																																																																															{
		// 																																																																																																																																																																																																																																																Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																																Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																														}},
		// 																																																																																																																																																																																																																																														Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																																														Locations: []*string{
		// 																																																																																																																																																																																																																																															to.Ptr("eastus2euap")},
		// 																																																																																																																																																																																																																																															ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																															Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																															},
		// 																																																																																																																																																																																																																																															Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																														},
		// 																																																																																																																																																																																																																																														{
		// 																																																																																																																																																																																																																																															Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																																																																																																																																															Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																																{
		// 																																																																																																																																																																																																																																																	Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																},
		// 																																																																																																																																																																																																																																																{
		// 																																																																																																																																																																																																																																																	Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																																	Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																},
		// 																																																																																																																																																																																																																																																{
		// 																																																																																																																																																																																																																																																	Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																																	Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																															}},
		// 																																																																																																																																																																																																																																															Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																																															Locations: []*string{
		// 																																																																																																																																																																																																																																																to.Ptr("eastus2euap")},
		// 																																																																																																																																																																																																																																																ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																																Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																																},
		// 																																																																																																																																																																																																																																																Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																																																																																																																																															},
		// 																																																																																																																																																																																																																																															{
		// 																																																																																																																																																																																																																																																Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																																																																																Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																																																		Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																																																		Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																																																		Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																																																		Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																																																		Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																																		Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																																																		Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																																		Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																}},
		// 																																																																																																																																																																																																																																																Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																																																Locations: []*string{
		// 																																																																																																																																																																																																																																																	to.Ptr("eastus2euap")},
		// 																																																																																																																																																																																																																																																	ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																																	Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																																																	Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																																},
		// 																																																																																																																																																																																																																																																{
		// 																																																																																																																																																																																																																																																	Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																																																																																	Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																																																																			Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																																																			Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																																																																			Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																																																																			Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																																			Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																																																																			Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																																			Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																	}},
		// 																																																																																																																																																																																																																																																	Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																																																	Locations: []*string{
		// 																																																																																																																																																																																																																																																		to.Ptr("eastus2euap")},
		// 																																																																																																																																																																																																																																																		ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																																		Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																																																																		Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																																	},
		// 																																																																																																																																																																																																																																																	{
		// 																																																																																																																																																																																																																																																		Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																																																																																		Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																																																																				Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																																																				Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																																																																				Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																																																																				Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																																																																				Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																																				Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																		}},
		// 																																																																																																																																																																																																																																																		Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																																																		Locations: []*string{
		// 																																																																																																																																																																																																																																																			to.Ptr("eastus2euap")},
		// 																																																																																																																																																																																																																																																			ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																																			Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																																																																			Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																																		},
		// 																																																																																																																																																																																																																																																		{
		// 																																																																																																																																																																																																																																																			Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																																																																																			Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																																																																					Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																																					Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																																																																					Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																																					Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																																																																					Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																																					Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																			}},
		// 																																																																																																																																																																																																																																																			Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																																																			Locations: []*string{
		// 																																																																																																																																																																																																																																																				to.Ptr("centraluseuap")},
		// 																																																																																																																																																																																																																																																				ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																																				Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																																																																				Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																																			},
		// 																																																																																																																																																																																																																																																			{
		// 																																																																																																																																																																																																																																																				Name: to.Ptr(armstorage.SKUNameStandardZRS),
		// 																																																																																																																																																																																																																																																				Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																																																																						Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																																						Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																																																																						Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																																						Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																																																																						Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																																						Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																				}},
		// 																																																																																																																																																																																																																																																				Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																																																				Locations: []*string{
		// 																																																																																																																																																																																																																																																					to.Ptr("centraluseuap")},
		// 																																																																																																																																																																																																																																																					ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																																					Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																																																																					Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																																				},
		// 																																																																																																																																																																																																																																																				{
		// 																																																																																																																																																																																																																																																					Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																																																																																					Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																																																																							Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																																							Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																																																																							Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																																							Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																																																																							Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																																							Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																					}},
		// 																																																																																																																																																																																																																																																					Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																																																					Locations: []*string{
		// 																																																																																																																																																																																																																																																						to.Ptr("centraluseuap")},
		// 																																																																																																																																																																																																																																																						ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																																						Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																																																																						Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																																					},
		// 																																																																																																																																																																																																																																																					{
		// 																																																																																																																																																																																																																																																						Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																																																																																						Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																																																																								Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																																								Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																																																																								Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																																																																								Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																																								Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																						}},
		// 																																																																																																																																																																																																																																																						Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																																																						Locations: []*string{
		// 																																																																																																																																																																																																																																																							to.Ptr("centraluseuap")},
		// 																																																																																																																																																																																																																																																							ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																																							Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																																																																							Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																																						},
		// 																																																																																																																																																																																																																																																						{
		// 																																																																																																																																																																																																																																																							Name: to.Ptr(armstorage.SKUNamePremiumLRS),
		// 																																																																																																																																																																																																																																																							Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																																																																									Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																																																																									Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																																									Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																																																																									Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																																									Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																							}},
		// 																																																																																																																																																																																																																																																							Kind: to.Ptr(armstorage.KindStorage),
		// 																																																																																																																																																																																																																																																							Locations: []*string{
		// 																																																																																																																																																																																																																																																								to.Ptr("centraluseuap")},
		// 																																																																																																																																																																																																																																																								ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																																								Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																																																																								Tier: to.Ptr(armstorage.SKUTierPremium),
		// 																																																																																																																																																																																																																																																							},
		// 																																																																																																																																																																																																																																																							{
		// 																																																																																																																																																																																																																																																								Name: to.Ptr(armstorage.SKUNameStandardLRS),
		// 																																																																																																																																																																																																																																																								Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																																																										Name: to.Ptr("supportsarchivepreview"),
		// 																																																																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																																																										Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																																																										Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																																																										Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																																																										Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																																										Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																																																										Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																																										Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																								}},
		// 																																																																																																																																																																																																																																																								Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																																																								Locations: []*string{
		// 																																																																																																																																																																																																																																																									to.Ptr("centraluseuap")},
		// 																																																																																																																																																																																																																																																									ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																																									Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																																																									Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																																								},
		// 																																																																																																																																																																																																																																																								{
		// 																																																																																																																																																																																																																																																									Name: to.Ptr(armstorage.SKUNameStandardGRS),
		// 																																																																																																																																																																																																																																																									Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																																																																											Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																																																											Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																																																																											Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																																																																											Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																																											Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																																																																										{
		// 																																																																																																																																																																																																																																																											Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																																											Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																									}},
		// 																																																																																																																																																																																																																																																									Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																																																									Locations: []*string{
		// 																																																																																																																																																																																																																																																										to.Ptr("centraluseuap")},
		// 																																																																																																																																																																																																																																																										ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																																										Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																																										},
		// 																																																																																																																																																																																																																																																										Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																																									},
		// 																																																																																																																																																																																																																																																									{
		// 																																																																																																																																																																																																																																																										Name: to.Ptr(armstorage.SKUNameStandardRAGRS),
		// 																																																																																																																																																																																																																																																										Capabilities: []*armstorage.SKUCapability{
		// 																																																																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																																																																												Name: to.Ptr("supportschangenotification"),
		// 																																																																																																																																																																																																																																																												Value: to.Ptr("true"),
		// 																																																																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																																																																												Name: to.Ptr("supportsfileencryption"),
		// 																																																																																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																																																																												Name: to.Ptr("supportshoeboxcapacitymetrics"),
		// 																																																																																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																																																																											{
		// 																																																																																																																																																																																																																																																												Name: to.Ptr("supportsnetworkacls"),
		// 																																																																																																																																																																																																																																																												Value: to.Ptr("false"),
		// 																																																																																																																																																																																																																																																										}},
		// 																																																																																																																																																																																																																																																										Kind: to.Ptr(armstorage.KindBlobStorage),
		// 																																																																																																																																																																																																																																																										Locations: []*string{
		// 																																																																																																																																																																																																																																																											to.Ptr("centraluseuap")},
		// 																																																																																																																																																																																																																																																											ResourceType: to.Ptr("storageAccounts"),
		// 																																																																																																																																																																																																																																																											Restrictions: []*armstorage.Restriction{
		// 																																																																																																																																																																																																																																																											},
		// 																																																																																																																																																																																																																																																											Tier: to.Ptr(armstorage.SKUTierStandard),
		// 																																																																																																																																																																																																																																																									}},
		// 																																																																																																																																																																																																																																																								}
	}
}
