// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1/vertex_rag_service.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A query to retrieve relevant contexts.
type RagQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The query to retrieve contexts.
	// Currently only text query is supported.
	//
	// Types that are assignable to Query:
	//
	//	*RagQuery_Text
	Query isRagQuery_Query `protobuf_oneof:"query"`
	// Optional. The retrieval config for the query.
	RagRetrievalConfig *RagRetrievalConfig `protobuf:"bytes,6,opt,name=rag_retrieval_config,json=ragRetrievalConfig,proto3" json:"rag_retrieval_config,omitempty"`
}

func (x *RagQuery) Reset() {
	*x = RagQuery{}
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagQuery) ProtoMessage() {}

func (x *RagQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagQuery.ProtoReflect.Descriptor instead.
func (*RagQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP(), []int{0}
}

func (m *RagQuery) GetQuery() isRagQuery_Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (x *RagQuery) GetText() string {
	if x, ok := x.GetQuery().(*RagQuery_Text); ok {
		return x.Text
	}
	return ""
}

func (x *RagQuery) GetRagRetrievalConfig() *RagRetrievalConfig {
	if x != nil {
		return x.RagRetrievalConfig
	}
	return nil
}

type isRagQuery_Query interface {
	isRagQuery_Query()
}

type RagQuery_Text struct {
	// Optional. The query in text format to get relevant contexts.
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

func (*RagQuery_Text) isRagQuery_Query() {}

// Request message for
// [VertexRagService.RetrieveContexts][google.cloud.aiplatform.v1.VertexRagService.RetrieveContexts].
type RetrieveContextsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data Source to retrieve contexts.
	//
	// Types that are assignable to DataSource:
	//
	//	*RetrieveContextsRequest_VertexRagStore_
	DataSource isRetrieveContextsRequest_DataSource `protobuf_oneof:"data_source"`
	// Required. The resource name of the Location from which to retrieve
	// RagContexts. The users must have permission to make a call in the project.
	// Format:
	// `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Single RAG retrieve query.
	Query *RagQuery `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
}

func (x *RetrieveContextsRequest) Reset() {
	*x = RetrieveContextsRequest{}
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetrieveContextsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveContextsRequest) ProtoMessage() {}

func (x *RetrieveContextsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveContextsRequest.ProtoReflect.Descriptor instead.
func (*RetrieveContextsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP(), []int{1}
}

func (m *RetrieveContextsRequest) GetDataSource() isRetrieveContextsRequest_DataSource {
	if m != nil {
		return m.DataSource
	}
	return nil
}

func (x *RetrieveContextsRequest) GetVertexRagStore() *RetrieveContextsRequest_VertexRagStore {
	if x, ok := x.GetDataSource().(*RetrieveContextsRequest_VertexRagStore_); ok {
		return x.VertexRagStore
	}
	return nil
}

func (x *RetrieveContextsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *RetrieveContextsRequest) GetQuery() *RagQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

type isRetrieveContextsRequest_DataSource interface {
	isRetrieveContextsRequest_DataSource()
}

type RetrieveContextsRequest_VertexRagStore_ struct {
	// The data source for Vertex RagStore.
	VertexRagStore *RetrieveContextsRequest_VertexRagStore `protobuf:"bytes,2,opt,name=vertex_rag_store,json=vertexRagStore,proto3,oneof"`
}

func (*RetrieveContextsRequest_VertexRagStore_) isRetrieveContextsRequest_DataSource() {}

// Relevant contexts for one query.
type RagContexts struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All its contexts.
	Contexts []*RagContexts_Context `protobuf:"bytes,1,rep,name=contexts,proto3" json:"contexts,omitempty"`
}

func (x *RagContexts) Reset() {
	*x = RagContexts{}
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagContexts) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagContexts) ProtoMessage() {}

func (x *RagContexts) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagContexts.ProtoReflect.Descriptor instead.
func (*RagContexts) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP(), []int{2}
}

func (x *RagContexts) GetContexts() []*RagContexts_Context {
	if x != nil {
		return x.Contexts
	}
	return nil
}

// Response message for
// [VertexRagService.RetrieveContexts][google.cloud.aiplatform.v1.VertexRagService.RetrieveContexts].
type RetrieveContextsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The contexts of the query.
	Contexts *RagContexts `protobuf:"bytes,1,opt,name=contexts,proto3" json:"contexts,omitempty"`
}

func (x *RetrieveContextsResponse) Reset() {
	*x = RetrieveContextsResponse{}
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetrieveContextsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveContextsResponse) ProtoMessage() {}

func (x *RetrieveContextsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveContextsResponse.ProtoReflect.Descriptor instead.
func (*RetrieveContextsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP(), []int{3}
}

func (x *RetrieveContextsResponse) GetContexts() *RagContexts {
	if x != nil {
		return x.Contexts
	}
	return nil
}

// Request message for AugmentPrompt.
type AugmentPromptRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data source for retrieving contexts.
	//
	// Types that are assignable to DataSource:
	//
	//	*AugmentPromptRequest_VertexRagStore
	DataSource isAugmentPromptRequest_DataSource `protobuf_oneof:"data_source"`
	// Required. The resource name of the Location from which to augment prompt.
	// The users must have permission to make a call in the project.
	// Format:
	// `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Input content to augment, only text format is supported for now.
	Contents []*Content `protobuf:"bytes,2,rep,name=contents,proto3" json:"contents,omitempty"`
	// Optional. Metadata of the backend deployed model.
	Model *AugmentPromptRequest_Model `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *AugmentPromptRequest) Reset() {
	*x = AugmentPromptRequest{}
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AugmentPromptRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AugmentPromptRequest) ProtoMessage() {}

func (x *AugmentPromptRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AugmentPromptRequest.ProtoReflect.Descriptor instead.
func (*AugmentPromptRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP(), []int{4}
}

func (m *AugmentPromptRequest) GetDataSource() isAugmentPromptRequest_DataSource {
	if m != nil {
		return m.DataSource
	}
	return nil
}

func (x *AugmentPromptRequest) GetVertexRagStore() *VertexRagStore {
	if x, ok := x.GetDataSource().(*AugmentPromptRequest_VertexRagStore); ok {
		return x.VertexRagStore
	}
	return nil
}

func (x *AugmentPromptRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *AugmentPromptRequest) GetContents() []*Content {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *AugmentPromptRequest) GetModel() *AugmentPromptRequest_Model {
	if x != nil {
		return x.Model
	}
	return nil
}

type isAugmentPromptRequest_DataSource interface {
	isAugmentPromptRequest_DataSource()
}

type AugmentPromptRequest_VertexRagStore struct {
	// Optional. Retrieves contexts from the Vertex RagStore.
	VertexRagStore *VertexRagStore `protobuf:"bytes,4,opt,name=vertex_rag_store,json=vertexRagStore,proto3,oneof"`
}

func (*AugmentPromptRequest_VertexRagStore) isAugmentPromptRequest_DataSource() {}

// Response message for AugmentPrompt.
type AugmentPromptResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Augmented prompt, only text format is supported for now.
	AugmentedPrompt []*Content `protobuf:"bytes,1,rep,name=augmented_prompt,json=augmentedPrompt,proto3" json:"augmented_prompt,omitempty"`
	// Retrieved facts from RAG data sources.
	Facts []*Fact `protobuf:"bytes,2,rep,name=facts,proto3" json:"facts,omitempty"`
}

func (x *AugmentPromptResponse) Reset() {
	*x = AugmentPromptResponse{}
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AugmentPromptResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AugmentPromptResponse) ProtoMessage() {}

func (x *AugmentPromptResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AugmentPromptResponse.ProtoReflect.Descriptor instead.
func (*AugmentPromptResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP(), []int{5}
}

func (x *AugmentPromptResponse) GetAugmentedPrompt() []*Content {
	if x != nil {
		return x.AugmentedPrompt
	}
	return nil
}

func (x *AugmentPromptResponse) GetFacts() []*Fact {
	if x != nil {
		return x.Facts
	}
	return nil
}

// Request message for CorroborateContent.
type CorroborateContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location from which to corroborate text.
	// The users must have permission to make a call in the project.
	// Format:
	// `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Input content to corroborate, only text format is supported for
	// now.
	Content *Content `protobuf:"bytes,2,opt,name=content,proto3,oneof" json:"content,omitempty"`
	// Optional. Facts used to generate the text can also be used to corroborate
	// the text.
	Facts []*Fact `protobuf:"bytes,3,rep,name=facts,proto3" json:"facts,omitempty"`
	// Optional. Parameters that can be set to override default settings per
	// request.
	Parameters *CorroborateContentRequest_Parameters `protobuf:"bytes,4,opt,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *CorroborateContentRequest) Reset() {
	*x = CorroborateContentRequest{}
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CorroborateContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CorroborateContentRequest) ProtoMessage() {}

func (x *CorroborateContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CorroborateContentRequest.ProtoReflect.Descriptor instead.
func (*CorroborateContentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP(), []int{6}
}

func (x *CorroborateContentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CorroborateContentRequest) GetContent() *Content {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *CorroborateContentRequest) GetFacts() []*Fact {
	if x != nil {
		return x.Facts
	}
	return nil
}

func (x *CorroborateContentRequest) GetParameters() *CorroborateContentRequest_Parameters {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Response message for CorroborateContent.
type CorroborateContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Confidence score of corroborating content. Value is [0,1] with 1 is the
	// most confidence.
	CorroborationScore *float32 `protobuf:"fixed32,1,opt,name=corroboration_score,json=corroborationScore,proto3,oneof" json:"corroboration_score,omitempty"`
	// Claims that are extracted from the input content and facts that support the
	// claims.
	Claims []*Claim `protobuf:"bytes,2,rep,name=claims,proto3" json:"claims,omitempty"`
}

func (x *CorroborateContentResponse) Reset() {
	*x = CorroborateContentResponse{}
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CorroborateContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CorroborateContentResponse) ProtoMessage() {}

func (x *CorroborateContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CorroborateContentResponse.ProtoReflect.Descriptor instead.
func (*CorroborateContentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP(), []int{7}
}

func (x *CorroborateContentResponse) GetCorroborationScore() float32 {
	if x != nil && x.CorroborationScore != nil {
		return *x.CorroborationScore
	}
	return 0
}

func (x *CorroborateContentResponse) GetClaims() []*Claim {
	if x != nil {
		return x.Claims
	}
	return nil
}

// The fact used in grounding.
type Fact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Query that is used to retrieve this fact.
	Query *string `protobuf:"bytes,1,opt,name=query,proto3,oneof" json:"query,omitempty"`
	// If present, it refers to the title of this fact.
	Title *string `protobuf:"bytes,2,opt,name=title,proto3,oneof" json:"title,omitempty"`
	// If present, this uri links to the source of the fact.
	Uri *string `protobuf:"bytes,3,opt,name=uri,proto3,oneof" json:"uri,omitempty"`
	// If present, the summary/snippet of the fact.
	Summary *string `protobuf:"bytes,4,opt,name=summary,proto3,oneof" json:"summary,omitempty"`
	// If present, the distance between the query vector and this fact vector.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1/vertex_rag_service.proto.
	VectorDistance *float64 `protobuf:"fixed64,5,opt,name=vector_distance,json=vectorDistance,proto3,oneof" json:"vector_distance,omitempty"`
	// If present, according to the underlying Vector DB and the selected metric
	// type, the score can be either the distance or the similarity between the
	// query and the fact and its range depends on the metric type.
	//
	// For example, if the metric type is COSINE_DISTANCE, it represents the
	// distance between the query and the fact. The larger the distance, the less
	// relevant the fact is to the query. The range is [0, 2], while 0 means the
	// most relevant and 2 means the least relevant.
	Score *float64 `protobuf:"fixed64,6,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// If present, chunk properties.
	Chunk *RagChunk `protobuf:"bytes,7,opt,name=chunk,proto3,oneof" json:"chunk,omitempty"`
}

func (x *Fact) Reset() {
	*x = Fact{}
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Fact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Fact) ProtoMessage() {}

func (x *Fact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Fact.ProtoReflect.Descriptor instead.
func (*Fact) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP(), []int{8}
}

func (x *Fact) GetQuery() string {
	if x != nil && x.Query != nil {
		return *x.Query
	}
	return ""
}

func (x *Fact) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

func (x *Fact) GetUri() string {
	if x != nil && x.Uri != nil {
		return *x.Uri
	}
	return ""
}

func (x *Fact) GetSummary() string {
	if x != nil && x.Summary != nil {
		return *x.Summary
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1/vertex_rag_service.proto.
func (x *Fact) GetVectorDistance() float64 {
	if x != nil && x.VectorDistance != nil {
		return *x.VectorDistance
	}
	return 0
}

func (x *Fact) GetScore() float64 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *Fact) GetChunk() *RagChunk {
	if x != nil {
		return x.Chunk
	}
	return nil
}

// Claim that is extracted from the input text and facts that support it.
type Claim struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index in the input text where the claim starts (inclusive).
	StartIndex *int32 `protobuf:"varint,1,opt,name=start_index,json=startIndex,proto3,oneof" json:"start_index,omitempty"`
	// Index in the input text where the claim ends (exclusive).
	EndIndex *int32 `protobuf:"varint,2,opt,name=end_index,json=endIndex,proto3,oneof" json:"end_index,omitempty"`
	// Indexes of the facts supporting this claim.
	FactIndexes []int32 `protobuf:"varint,3,rep,packed,name=fact_indexes,json=factIndexes,proto3" json:"fact_indexes,omitempty"`
	// Confidence score of this corroboration.
	Score *float32 `protobuf:"fixed32,4,opt,name=score,proto3,oneof" json:"score,omitempty"`
}

func (x *Claim) Reset() {
	*x = Claim{}
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Claim) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Claim) ProtoMessage() {}

func (x *Claim) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Claim.ProtoReflect.Descriptor instead.
func (*Claim) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP(), []int{9}
}

func (x *Claim) GetStartIndex() int32 {
	if x != nil && x.StartIndex != nil {
		return *x.StartIndex
	}
	return 0
}

func (x *Claim) GetEndIndex() int32 {
	if x != nil && x.EndIndex != nil {
		return *x.EndIndex
	}
	return 0
}

func (x *Claim) GetFactIndexes() []int32 {
	if x != nil {
		return x.FactIndexes
	}
	return nil
}

func (x *Claim) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

// The data source for Vertex RagStore.
type RetrieveContextsRequest_VertexRagStore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The representation of the rag source. It can be used to specify
	// corpus only or ragfiles. Currently only support one corpus or multiple
	// files from one corpus. In the future we may open up multiple corpora
	// support.
	RagResources []*RetrieveContextsRequest_VertexRagStore_RagResource `protobuf:"bytes,3,rep,name=rag_resources,json=ragResources,proto3" json:"rag_resources,omitempty"`
	// Optional. Only return contexts with vector distance smaller than the
	// threshold.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1/vertex_rag_service.proto.
	VectorDistanceThreshold *float64 `protobuf:"fixed64,2,opt,name=vector_distance_threshold,json=vectorDistanceThreshold,proto3,oneof" json:"vector_distance_threshold,omitempty"`
}

func (x *RetrieveContextsRequest_VertexRagStore) Reset() {
	*x = RetrieveContextsRequest_VertexRagStore{}
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetrieveContextsRequest_VertexRagStore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveContextsRequest_VertexRagStore) ProtoMessage() {}

func (x *RetrieveContextsRequest_VertexRagStore) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveContextsRequest_VertexRagStore.ProtoReflect.Descriptor instead.
func (*RetrieveContextsRequest_VertexRagStore) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP(), []int{1, 0}
}

func (x *RetrieveContextsRequest_VertexRagStore) GetRagResources() []*RetrieveContextsRequest_VertexRagStore_RagResource {
	if x != nil {
		return x.RagResources
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1/vertex_rag_service.proto.
func (x *RetrieveContextsRequest_VertexRagStore) GetVectorDistanceThreshold() float64 {
	if x != nil && x.VectorDistanceThreshold != nil {
		return *x.VectorDistanceThreshold
	}
	return 0
}

// The definition of the Rag resource.
type RetrieveContextsRequest_VertexRagStore_RagResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. RagCorpora resource name.
	// Format:
	// `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
	RagCorpus string `protobuf:"bytes,1,opt,name=rag_corpus,json=ragCorpus,proto3" json:"rag_corpus,omitempty"`
	// Optional. rag_file_id. The files should be in the same rag_corpus set
	// in rag_corpus field.
	RagFileIds []string `protobuf:"bytes,2,rep,name=rag_file_ids,json=ragFileIds,proto3" json:"rag_file_ids,omitempty"`
}

func (x *RetrieveContextsRequest_VertexRagStore_RagResource) Reset() {
	*x = RetrieveContextsRequest_VertexRagStore_RagResource{}
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetrieveContextsRequest_VertexRagStore_RagResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveContextsRequest_VertexRagStore_RagResource) ProtoMessage() {}

func (x *RetrieveContextsRequest_VertexRagStore_RagResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveContextsRequest_VertexRagStore_RagResource.ProtoReflect.Descriptor instead.
func (*RetrieveContextsRequest_VertexRagStore_RagResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *RetrieveContextsRequest_VertexRagStore_RagResource) GetRagCorpus() string {
	if x != nil {
		return x.RagCorpus
	}
	return ""
}

func (x *RetrieveContextsRequest_VertexRagStore_RagResource) GetRagFileIds() []string {
	if x != nil {
		return x.RagFileIds
	}
	return nil
}

// A context of the query.
type RagContexts_Context struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If the file is imported from Cloud Storage or Google Drive, source_uri
	// will be original file URI in Cloud Storage or Google Drive; if file is
	// uploaded, source_uri will be file display name.
	SourceUri string `protobuf:"bytes,1,opt,name=source_uri,json=sourceUri,proto3" json:"source_uri,omitempty"`
	// The file display name.
	SourceDisplayName string `protobuf:"bytes,5,opt,name=source_display_name,json=sourceDisplayName,proto3" json:"source_display_name,omitempty"`
	// The text chunk.
	Text string `protobuf:"bytes,2,opt,name=text,proto3" json:"text,omitempty"`
	// According to the underlying Vector DB and the selected metric type, the
	// score can be either the distance or the similarity between the query and
	// the context and its range depends on the metric type.
	//
	// For example, if the metric type is COSINE_DISTANCE, it represents the
	// distance between the query and the context. The larger the distance, the
	// less relevant the context is to the query. The range is [0, 2], while 0
	// means the most relevant and 2 means the least relevant.
	Score *float64 `protobuf:"fixed64,6,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Context of the retrieved chunk.
	Chunk *RagChunk `protobuf:"bytes,7,opt,name=chunk,proto3" json:"chunk,omitempty"`
}

func (x *RagContexts_Context) Reset() {
	*x = RagContexts_Context{}
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagContexts_Context) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagContexts_Context) ProtoMessage() {}

func (x *RagContexts_Context) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagContexts_Context.ProtoReflect.Descriptor instead.
func (*RagContexts_Context) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP(), []int{2, 0}
}

func (x *RagContexts_Context) GetSourceUri() string {
	if x != nil {
		return x.SourceUri
	}
	return ""
}

func (x *RagContexts_Context) GetSourceDisplayName() string {
	if x != nil {
		return x.SourceDisplayName
	}
	return ""
}

func (x *RagContexts_Context) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *RagContexts_Context) GetScore() float64 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *RagContexts_Context) GetChunk() *RagChunk {
	if x != nil {
		return x.Chunk
	}
	return nil
}

// Metadata of the backend deployed model.
type AugmentPromptRequest_Model struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The model that the user will send the augmented prompt for
	// content generation.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Optional. The model version of the backend deployed model.
	ModelVersion string `protobuf:"bytes,2,opt,name=model_version,json=modelVersion,proto3" json:"model_version,omitempty"`
}

func (x *AugmentPromptRequest_Model) Reset() {
	*x = AugmentPromptRequest_Model{}
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AugmentPromptRequest_Model) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AugmentPromptRequest_Model) ProtoMessage() {}

func (x *AugmentPromptRequest_Model) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AugmentPromptRequest_Model.ProtoReflect.Descriptor instead.
func (*AugmentPromptRequest_Model) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP(), []int{4, 0}
}

func (x *AugmentPromptRequest_Model) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *AugmentPromptRequest_Model) GetModelVersion() string {
	if x != nil {
		return x.ModelVersion
	}
	return ""
}

// Parameters that can be overrided per request.
type CorroborateContentRequest_Parameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Only return claims with citation score larger than the
	// threshold.
	CitationThreshold float64 `protobuf:"fixed64,1,opt,name=citation_threshold,json=citationThreshold,proto3" json:"citation_threshold,omitempty"`
}

func (x *CorroborateContentRequest_Parameters) Reset() {
	*x = CorroborateContentRequest_Parameters{}
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CorroborateContentRequest_Parameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CorroborateContentRequest_Parameters) ProtoMessage() {}

func (x *CorroborateContentRequest_Parameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CorroborateContentRequest_Parameters.ProtoReflect.Descriptor instead.
func (*CorroborateContentRequest_Parameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP(), []int{6, 0}
}

func (x *CorroborateContentRequest_Parameters) GetCitationThreshold() float64 {
	if x != nil {
		return x.CitationThreshold
	}
	return 0
}

var File_google_cloud_aiplatform_v1_vertex_rag_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x65, 0x72,
	0x74, 0x65, 0x78, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76,
	0x31, 0x2f, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x95, 0x01, 0x0a, 0x08, 0x52, 0x61, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x12, 0x19, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12,
	0x65, 0x0a, 0x14, 0x72, 0x61, 0x67, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x52, 0x65,
	0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x12, 0x72, 0x61, 0x67, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x07, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x22,
	0x92, 0x05, 0x0a, 0x17, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6e, 0x0a, 0x10, 0x76,
	0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65,
	0x78, 0x52, 0x61, 0x67, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x76, 0x65, 0x72,
	0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x41, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3f,
	0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x1a,
	0xf3, 0x02, 0x0a, 0x0e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x12, 0x78, 0x0a, 0x0d, 0x72, 0x61, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x56,
	0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x52, 0x61,
	0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x72, 0x61, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x46, 0x0a, 0x19,
	0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42,
	0x05, 0xe0, 0x41, 0x01, 0x18, 0x01, 0x48, 0x00, 0x52, 0x17, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x88, 0x01, 0x01, 0x1a, 0x80, 0x01, 0x0a, 0x0b, 0x52, 0x61, 0x67, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x4a, 0x0a, 0x0a, 0x72, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x25,
	0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x61, 0x67, 0x43,
	0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x09, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x12, 0x25, 0x0a, 0x0c, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x72, 0x61, 0x67,
	0x46, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x73, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x76, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x22, 0xaa, 0x02, 0x0a, 0x0b, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x73, 0x12, 0x4b, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x73, 0x1a, 0xcd, 0x01, 0x0a, 0x07, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x1d, 0x0a,
	0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x12, 0x2e, 0x0a, 0x13,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x48,
	0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x3a, 0x0a, 0x05, 0x63,
	0x68, 0x75, 0x6e, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x43, 0x68, 0x75, 0x6e, 0x6b,
	0x52, 0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x22, 0x5f, 0x0a, 0x18, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a,
	0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x67,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x73, 0x22, 0xac, 0x03, 0x0a, 0x14, 0x41, 0x75, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72,
	0x6f, 0x6d, 0x70, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x10, 0x76,
	0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78,
	0x52, 0x61, 0x67, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x08, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x51, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x1a, 0x4c, 0x0a, 0x05, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x19, 0x0a,
	0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x28, 0x0a, 0x0d, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0x9f, 0x01, 0x0a, 0x15, 0x41, 0x75, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x6d, 0x70, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x10, 0x61,
	0x75, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x0f, 0x61, 0x75, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x12, 0x36, 0x0a, 0x05, 0x66,
	0x61, 0x63, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x74, 0x52, 0x05, 0x66, 0x61,
	0x63, 0x74, 0x73, 0x22, 0x99, 0x03, 0x0a, 0x19, 0x43, 0x6f, 0x72, 0x72, 0x6f, 0x62, 0x6f, 0x72,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x3b, 0x0a,
	0x05, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0x65, 0x0a, 0x0a, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x72, 0x72,
	0x6f, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x1a, 0x40, 0x0a, 0x0a, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x32, 0x0a, 0x12, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x11, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22,
	0xa5, 0x01, 0x0a, 0x1a, 0x43, 0x6f, 0x72, 0x72, 0x6f, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34,
	0x0a, 0x13, 0x63, 0x6f, 0x72, 0x72, 0x6f, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x12, 0x63,
	0x6f, 0x72, 0x72, 0x6f, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x39, 0x0a, 0x06, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x52, 0x06, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x42,
	0x16, 0x0a, 0x14, 0x5f, 0x63, 0x6f, 0x72, 0x72, 0x6f, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x22, 0xd0, 0x02, 0x0a, 0x04, 0x46, 0x61, 0x63, 0x74,
	0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x05, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x03, 0x75, 0x72, 0x69, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a,
	0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03,
	0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x88, 0x01, 0x01, 0x12, 0x30, 0x0a, 0x0f,
	0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x01, 0x42, 0x02, 0x18, 0x01, 0x48, 0x04, 0x52, 0x0e, 0x76, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x19,
	0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x48, 0x05, 0x52,
	0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x3f, 0x0a, 0x05, 0x63, 0x68, 0x75,
	0x6e, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x48, 0x06,
	0x52, 0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x42, 0x06,
	0x0a, 0x04, 0x5f, 0x75, 0x72, 0x69, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x42, 0x08, 0x0a, 0x06, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x22, 0xb5, 0x01, 0x0a, 0x05, 0x43,
	0x6c, 0x61, 0x69, 0x6d, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x65, 0x6e,
	0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52,
	0x08, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x88, 0x01, 0x01, 0x12, 0x21, 0x0a, 0x0c,
	0x66, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x05, 0x52, 0x0b, 0x66, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x12,
	0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x48, 0x02,
	0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x65,
	0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x32, 0xe6, 0x05, 0x0a, 0x10, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xcd, 0x01, 0x0a, 0x10, 0x52, 0x65, 0x74, 0x72,
	0x69, 0x65, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x12, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65,
	0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x01,
	0x2a, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x12, 0xd2, 0x01, 0x0a, 0x0d, 0x41, 0x75, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72,
	0x6f, 0x6d, 0x70, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5c,
	0xda, 0x41, 0x1d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c,
	0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x3a, 0x01, 0x2a, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61,
	0x75, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x12, 0xdd, 0x01, 0x0a,
	0x12, 0x43, 0x6f, 0x72, 0x72, 0x6f, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x72, 0x72, 0x6f, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x72, 0x72, 0x6f, 0x62, 0x6f, 0x72,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x58, 0xda, 0x41, 0x14, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x61, 0x63, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3b, 0x3a, 0x01, 0x2a, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x72, 0x72, 0x6f, 0x62,
	0x6f, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x1a, 0x4d, 0xca, 0x41,
	0x19, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xd3, 0x01, 0x0a, 0x1e,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x15,
	0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56,
	0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescData = file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_cloud_aiplatform_v1_vertex_rag_service_proto_goTypes = []any{
	(*RagQuery)(nil),                                           // 0: google.cloud.aiplatform.v1.RagQuery
	(*RetrieveContextsRequest)(nil),                            // 1: google.cloud.aiplatform.v1.RetrieveContextsRequest
	(*RagContexts)(nil),                                        // 2: google.cloud.aiplatform.v1.RagContexts
	(*RetrieveContextsResponse)(nil),                           // 3: google.cloud.aiplatform.v1.RetrieveContextsResponse
	(*AugmentPromptRequest)(nil),                               // 4: google.cloud.aiplatform.v1.AugmentPromptRequest
	(*AugmentPromptResponse)(nil),                              // 5: google.cloud.aiplatform.v1.AugmentPromptResponse
	(*CorroborateContentRequest)(nil),                          // 6: google.cloud.aiplatform.v1.CorroborateContentRequest
	(*CorroborateContentResponse)(nil),                         // 7: google.cloud.aiplatform.v1.CorroborateContentResponse
	(*Fact)(nil),                                               // 8: google.cloud.aiplatform.v1.Fact
	(*Claim)(nil),                                              // 9: google.cloud.aiplatform.v1.Claim
	(*RetrieveContextsRequest_VertexRagStore)(nil),             // 10: google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
	(*RetrieveContextsRequest_VertexRagStore_RagResource)(nil), // 11: google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
	(*RagContexts_Context)(nil),                                // 12: google.cloud.aiplatform.v1.RagContexts.Context
	(*AugmentPromptRequest_Model)(nil),                         // 13: google.cloud.aiplatform.v1.AugmentPromptRequest.Model
	(*CorroborateContentRequest_Parameters)(nil),               // 14: google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters
	(*RagRetrievalConfig)(nil),                                 // 15: google.cloud.aiplatform.v1.RagRetrievalConfig
	(*VertexRagStore)(nil),                                     // 16: google.cloud.aiplatform.v1.VertexRagStore
	(*Content)(nil),                                            // 17: google.cloud.aiplatform.v1.Content
	(*RagChunk)(nil),                                           // 18: google.cloud.aiplatform.v1.RagChunk
}
var file_google_cloud_aiplatform_v1_vertex_rag_service_proto_depIdxs = []int32{
	15, // 0: google.cloud.aiplatform.v1.RagQuery.rag_retrieval_config:type_name -> google.cloud.aiplatform.v1.RagRetrievalConfig
	10, // 1: google.cloud.aiplatform.v1.RetrieveContextsRequest.vertex_rag_store:type_name -> google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore
	0,  // 2: google.cloud.aiplatform.v1.RetrieveContextsRequest.query:type_name -> google.cloud.aiplatform.v1.RagQuery
	12, // 3: google.cloud.aiplatform.v1.RagContexts.contexts:type_name -> google.cloud.aiplatform.v1.RagContexts.Context
	2,  // 4: google.cloud.aiplatform.v1.RetrieveContextsResponse.contexts:type_name -> google.cloud.aiplatform.v1.RagContexts
	16, // 5: google.cloud.aiplatform.v1.AugmentPromptRequest.vertex_rag_store:type_name -> google.cloud.aiplatform.v1.VertexRagStore
	17, // 6: google.cloud.aiplatform.v1.AugmentPromptRequest.contents:type_name -> google.cloud.aiplatform.v1.Content
	13, // 7: google.cloud.aiplatform.v1.AugmentPromptRequest.model:type_name -> google.cloud.aiplatform.v1.AugmentPromptRequest.Model
	17, // 8: google.cloud.aiplatform.v1.AugmentPromptResponse.augmented_prompt:type_name -> google.cloud.aiplatform.v1.Content
	8,  // 9: google.cloud.aiplatform.v1.AugmentPromptResponse.facts:type_name -> google.cloud.aiplatform.v1.Fact
	17, // 10: google.cloud.aiplatform.v1.CorroborateContentRequest.content:type_name -> google.cloud.aiplatform.v1.Content
	8,  // 11: google.cloud.aiplatform.v1.CorroborateContentRequest.facts:type_name -> google.cloud.aiplatform.v1.Fact
	14, // 12: google.cloud.aiplatform.v1.CorroborateContentRequest.parameters:type_name -> google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters
	9,  // 13: google.cloud.aiplatform.v1.CorroborateContentResponse.claims:type_name -> google.cloud.aiplatform.v1.Claim
	18, // 14: google.cloud.aiplatform.v1.Fact.chunk:type_name -> google.cloud.aiplatform.v1.RagChunk
	11, // 15: google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.rag_resources:type_name -> google.cloud.aiplatform.v1.RetrieveContextsRequest.VertexRagStore.RagResource
	18, // 16: google.cloud.aiplatform.v1.RagContexts.Context.chunk:type_name -> google.cloud.aiplatform.v1.RagChunk
	1,  // 17: google.cloud.aiplatform.v1.VertexRagService.RetrieveContexts:input_type -> google.cloud.aiplatform.v1.RetrieveContextsRequest
	4,  // 18: google.cloud.aiplatform.v1.VertexRagService.AugmentPrompt:input_type -> google.cloud.aiplatform.v1.AugmentPromptRequest
	6,  // 19: google.cloud.aiplatform.v1.VertexRagService.CorroborateContent:input_type -> google.cloud.aiplatform.v1.CorroborateContentRequest
	3,  // 20: google.cloud.aiplatform.v1.VertexRagService.RetrieveContexts:output_type -> google.cloud.aiplatform.v1.RetrieveContextsResponse
	5,  // 21: google.cloud.aiplatform.v1.VertexRagService.AugmentPrompt:output_type -> google.cloud.aiplatform.v1.AugmentPromptResponse
	7,  // 22: google.cloud.aiplatform.v1.VertexRagService.CorroborateContent:output_type -> google.cloud.aiplatform.v1.CorroborateContentResponse
	20, // [20:23] is the sub-list for method output_type
	17, // [17:20] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_vertex_rag_service_proto_init() }
func file_google_cloud_aiplatform_v1_vertex_rag_service_proto_init() {
	if File_google_cloud_aiplatform_v1_vertex_rag_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_content_proto_init()
	file_google_cloud_aiplatform_v1_tool_proto_init()
	file_google_cloud_aiplatform_v1_vertex_rag_data_proto_init()
	file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[0].OneofWrappers = []any{
		(*RagQuery_Text)(nil),
	}
	file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[1].OneofWrappers = []any{
		(*RetrieveContextsRequest_VertexRagStore_)(nil),
	}
	file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[4].OneofWrappers = []any{
		(*AugmentPromptRequest_VertexRagStore)(nil),
	}
	file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[6].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[7].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[8].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[9].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[10].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes[12].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_vertex_rag_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_vertex_rag_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1_vertex_rag_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_vertex_rag_service_proto = out.File
	file_google_cloud_aiplatform_v1_vertex_rag_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_vertex_rag_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_vertex_rag_service_proto_depIdxs = nil
}
