// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/translate/v3/translation_service.proto

package translatepb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	TranslationService_TranslateText_FullMethodName           = "/google.cloud.translation.v3.TranslationService/TranslateText"
	TranslationService_RomanizeText_FullMethodName            = "/google.cloud.translation.v3.TranslationService/RomanizeText"
	TranslationService_DetectLanguage_FullMethodName          = "/google.cloud.translation.v3.TranslationService/DetectLanguage"
	TranslationService_GetSupportedLanguages_FullMethodName   = "/google.cloud.translation.v3.TranslationService/GetSupportedLanguages"
	TranslationService_TranslateDocument_FullMethodName       = "/google.cloud.translation.v3.TranslationService/TranslateDocument"
	TranslationService_BatchTranslateText_FullMethodName      = "/google.cloud.translation.v3.TranslationService/BatchTranslateText"
	TranslationService_BatchTranslateDocument_FullMethodName  = "/google.cloud.translation.v3.TranslationService/BatchTranslateDocument"
	TranslationService_CreateGlossary_FullMethodName          = "/google.cloud.translation.v3.TranslationService/CreateGlossary"
	TranslationService_UpdateGlossary_FullMethodName          = "/google.cloud.translation.v3.TranslationService/UpdateGlossary"
	TranslationService_ListGlossaries_FullMethodName          = "/google.cloud.translation.v3.TranslationService/ListGlossaries"
	TranslationService_GetGlossary_FullMethodName             = "/google.cloud.translation.v3.TranslationService/GetGlossary"
	TranslationService_DeleteGlossary_FullMethodName          = "/google.cloud.translation.v3.TranslationService/DeleteGlossary"
	TranslationService_GetGlossaryEntry_FullMethodName        = "/google.cloud.translation.v3.TranslationService/GetGlossaryEntry"
	TranslationService_ListGlossaryEntries_FullMethodName     = "/google.cloud.translation.v3.TranslationService/ListGlossaryEntries"
	TranslationService_CreateGlossaryEntry_FullMethodName     = "/google.cloud.translation.v3.TranslationService/CreateGlossaryEntry"
	TranslationService_UpdateGlossaryEntry_FullMethodName     = "/google.cloud.translation.v3.TranslationService/UpdateGlossaryEntry"
	TranslationService_DeleteGlossaryEntry_FullMethodName     = "/google.cloud.translation.v3.TranslationService/DeleteGlossaryEntry"
	TranslationService_CreateDataset_FullMethodName           = "/google.cloud.translation.v3.TranslationService/CreateDataset"
	TranslationService_GetDataset_FullMethodName              = "/google.cloud.translation.v3.TranslationService/GetDataset"
	TranslationService_ListDatasets_FullMethodName            = "/google.cloud.translation.v3.TranslationService/ListDatasets"
	TranslationService_DeleteDataset_FullMethodName           = "/google.cloud.translation.v3.TranslationService/DeleteDataset"
	TranslationService_CreateAdaptiveMtDataset_FullMethodName = "/google.cloud.translation.v3.TranslationService/CreateAdaptiveMtDataset"
	TranslationService_DeleteAdaptiveMtDataset_FullMethodName = "/google.cloud.translation.v3.TranslationService/DeleteAdaptiveMtDataset"
	TranslationService_GetAdaptiveMtDataset_FullMethodName    = "/google.cloud.translation.v3.TranslationService/GetAdaptiveMtDataset"
	TranslationService_ListAdaptiveMtDatasets_FullMethodName  = "/google.cloud.translation.v3.TranslationService/ListAdaptiveMtDatasets"
	TranslationService_AdaptiveMtTranslate_FullMethodName     = "/google.cloud.translation.v3.TranslationService/AdaptiveMtTranslate"
	TranslationService_GetAdaptiveMtFile_FullMethodName       = "/google.cloud.translation.v3.TranslationService/GetAdaptiveMtFile"
	TranslationService_DeleteAdaptiveMtFile_FullMethodName    = "/google.cloud.translation.v3.TranslationService/DeleteAdaptiveMtFile"
	TranslationService_ImportAdaptiveMtFile_FullMethodName    = "/google.cloud.translation.v3.TranslationService/ImportAdaptiveMtFile"
	TranslationService_ListAdaptiveMtFiles_FullMethodName     = "/google.cloud.translation.v3.TranslationService/ListAdaptiveMtFiles"
	TranslationService_ListAdaptiveMtSentences_FullMethodName = "/google.cloud.translation.v3.TranslationService/ListAdaptiveMtSentences"
	TranslationService_ImportData_FullMethodName              = "/google.cloud.translation.v3.TranslationService/ImportData"
	TranslationService_ExportData_FullMethodName              = "/google.cloud.translation.v3.TranslationService/ExportData"
	TranslationService_ListExamples_FullMethodName            = "/google.cloud.translation.v3.TranslationService/ListExamples"
	TranslationService_CreateModel_FullMethodName             = "/google.cloud.translation.v3.TranslationService/CreateModel"
	TranslationService_ListModels_FullMethodName              = "/google.cloud.translation.v3.TranslationService/ListModels"
	TranslationService_GetModel_FullMethodName                = "/google.cloud.translation.v3.TranslationService/GetModel"
	TranslationService_DeleteModel_FullMethodName             = "/google.cloud.translation.v3.TranslationService/DeleteModel"
)

// TranslationServiceClient is the client API for TranslationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TranslationServiceClient interface {
	// Translates input text and returns translated text.
	TranslateText(ctx context.Context, in *TranslateTextRequest, opts ...grpc.CallOption) (*TranslateTextResponse, error)
	// Romanize input text written in non-Latin scripts to Latin text.
	RomanizeText(ctx context.Context, in *RomanizeTextRequest, opts ...grpc.CallOption) (*RomanizeTextResponse, error)
	// Detects the language of text within a request.
	DetectLanguage(ctx context.Context, in *DetectLanguageRequest, opts ...grpc.CallOption) (*DetectLanguageResponse, error)
	// Returns a list of supported languages for translation.
	GetSupportedLanguages(ctx context.Context, in *GetSupportedLanguagesRequest, opts ...grpc.CallOption) (*SupportedLanguages, error)
	// Translates documents in synchronous mode.
	TranslateDocument(ctx context.Context, in *TranslateDocumentRequest, opts ...grpc.CallOption) (*TranslateDocumentResponse, error)
	// Translates a large volume of text in asynchronous batch mode.
	// This function provides real-time output as the inputs are being processed.
	// If caller cancels a request, the partial results (for an input file, it's
	// all or nothing) may still be available on the specified output location.
	//
	// This call returns immediately and you can
	// use google.longrunning.Operation.name to poll the status of the call.
	BatchTranslateText(ctx context.Context, in *BatchTranslateTextRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Translates a large volume of document in asynchronous batch mode.
	// This function provides real-time output as the inputs are being processed.
	// If caller cancels a request, the partial results (for an input file, it's
	// all or nothing) may still be available on the specified output location.
	//
	// This call returns immediately and you can use
	// google.longrunning.Operation.name to poll the status of the call.
	BatchTranslateDocument(ctx context.Context, in *BatchTranslateDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a glossary and returns the long-running operation. Returns
	// NOT_FOUND, if the project doesn't exist.
	CreateGlossary(ctx context.Context, in *CreateGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a glossary. A LRO is used since the update can be async if the
	// glossary's entry file is updated.
	UpdateGlossary(ctx context.Context, in *UpdateGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't
	// exist.
	ListGlossaries(ctx context.Context, in *ListGlossariesRequest, opts ...grpc.CallOption) (*ListGlossariesResponse, error)
	// Gets a glossary. Returns NOT_FOUND, if the glossary doesn't
	// exist.
	GetGlossary(ctx context.Context, in *GetGlossaryRequest, opts ...grpc.CallOption) (*Glossary, error)
	// Deletes a glossary, or cancels glossary construction
	// if the glossary isn't created yet.
	// Returns NOT_FOUND, if the glossary doesn't exist.
	DeleteGlossary(ctx context.Context, in *DeleteGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a single glossary entry by the given id.
	GetGlossaryEntry(ctx context.Context, in *GetGlossaryEntryRequest, opts ...grpc.CallOption) (*GlossaryEntry, error)
	// List the entries for the glossary.
	ListGlossaryEntries(ctx context.Context, in *ListGlossaryEntriesRequest, opts ...grpc.CallOption) (*ListGlossaryEntriesResponse, error)
	// Creates a glossary entry.
	CreateGlossaryEntry(ctx context.Context, in *CreateGlossaryEntryRequest, opts ...grpc.CallOption) (*GlossaryEntry, error)
	// Updates a glossary entry.
	UpdateGlossaryEntry(ctx context.Context, in *UpdateGlossaryEntryRequest, opts ...grpc.CallOption) (*GlossaryEntry, error)
	// Deletes a single entry from the glossary
	DeleteGlossaryEntry(ctx context.Context, in *DeleteGlossaryEntryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a Dataset.
	CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a Dataset.
	GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Lists datasets.
	ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error)
	// Deletes a dataset and all of its contents.
	DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates an Adaptive MT dataset.
	CreateAdaptiveMtDataset(ctx context.Context, in *CreateAdaptiveMtDatasetRequest, opts ...grpc.CallOption) (*AdaptiveMtDataset, error)
	// Deletes an Adaptive MT dataset, including all its entries and associated
	// metadata.
	DeleteAdaptiveMtDataset(ctx context.Context, in *DeleteAdaptiveMtDatasetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets the Adaptive MT dataset.
	GetAdaptiveMtDataset(ctx context.Context, in *GetAdaptiveMtDatasetRequest, opts ...grpc.CallOption) (*AdaptiveMtDataset, error)
	// Lists all Adaptive MT datasets for which the caller has read permission.
	ListAdaptiveMtDatasets(ctx context.Context, in *ListAdaptiveMtDatasetsRequest, opts ...grpc.CallOption) (*ListAdaptiveMtDatasetsResponse, error)
	// Translate text using Adaptive MT.
	AdaptiveMtTranslate(ctx context.Context, in *AdaptiveMtTranslateRequest, opts ...grpc.CallOption) (*AdaptiveMtTranslateResponse, error)
	// Gets and AdaptiveMtFile
	GetAdaptiveMtFile(ctx context.Context, in *GetAdaptiveMtFileRequest, opts ...grpc.CallOption) (*AdaptiveMtFile, error)
	// Deletes an AdaptiveMtFile along with its sentences.
	DeleteAdaptiveMtFile(ctx context.Context, in *DeleteAdaptiveMtFileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Imports an AdaptiveMtFile and adds all of its sentences into the
	// AdaptiveMtDataset.
	ImportAdaptiveMtFile(ctx context.Context, in *ImportAdaptiveMtFileRequest, opts ...grpc.CallOption) (*ImportAdaptiveMtFileResponse, error)
	// Lists all AdaptiveMtFiles associated to an AdaptiveMtDataset.
	ListAdaptiveMtFiles(ctx context.Context, in *ListAdaptiveMtFilesRequest, opts ...grpc.CallOption) (*ListAdaptiveMtFilesResponse, error)
	// Lists all AdaptiveMtSentences under a given file/dataset.
	ListAdaptiveMtSentences(ctx context.Context, in *ListAdaptiveMtSentencesRequest, opts ...grpc.CallOption) (*ListAdaptiveMtSentencesResponse, error)
	// Import sentence pairs into translation Dataset.
	ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports dataset's data to the provided output location.
	ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists sentence pairs in the dataset.
	ListExamples(ctx context.Context, in *ListExamplesRequest, opts ...grpc.CallOption) (*ListExamplesResponse, error)
	// Creates a Model.
	CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists models.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Gets a model.
	GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Deletes a model.
	DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type translationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTranslationServiceClient(cc grpc.ClientConnInterface) TranslationServiceClient {
	return &translationServiceClient{cc}
}

func (c *translationServiceClient) TranslateText(ctx context.Context, in *TranslateTextRequest, opts ...grpc.CallOption) (*TranslateTextResponse, error) {
	out := new(TranslateTextResponse)
	err := c.cc.Invoke(ctx, TranslationService_TranslateText_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) RomanizeText(ctx context.Context, in *RomanizeTextRequest, opts ...grpc.CallOption) (*RomanizeTextResponse, error) {
	out := new(RomanizeTextResponse)
	err := c.cc.Invoke(ctx, TranslationService_RomanizeText_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) DetectLanguage(ctx context.Context, in *DetectLanguageRequest, opts ...grpc.CallOption) (*DetectLanguageResponse, error) {
	out := new(DetectLanguageResponse)
	err := c.cc.Invoke(ctx, TranslationService_DetectLanguage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) GetSupportedLanguages(ctx context.Context, in *GetSupportedLanguagesRequest, opts ...grpc.CallOption) (*SupportedLanguages, error) {
	out := new(SupportedLanguages)
	err := c.cc.Invoke(ctx, TranslationService_GetSupportedLanguages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) TranslateDocument(ctx context.Context, in *TranslateDocumentRequest, opts ...grpc.CallOption) (*TranslateDocumentResponse, error) {
	out := new(TranslateDocumentResponse)
	err := c.cc.Invoke(ctx, TranslationService_TranslateDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) BatchTranslateText(ctx context.Context, in *BatchTranslateTextRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TranslationService_BatchTranslateText_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) BatchTranslateDocument(ctx context.Context, in *BatchTranslateDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TranslationService_BatchTranslateDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) CreateGlossary(ctx context.Context, in *CreateGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TranslationService_CreateGlossary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) UpdateGlossary(ctx context.Context, in *UpdateGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TranslationService_UpdateGlossary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ListGlossaries(ctx context.Context, in *ListGlossariesRequest, opts ...grpc.CallOption) (*ListGlossariesResponse, error) {
	out := new(ListGlossariesResponse)
	err := c.cc.Invoke(ctx, TranslationService_ListGlossaries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) GetGlossary(ctx context.Context, in *GetGlossaryRequest, opts ...grpc.CallOption) (*Glossary, error) {
	out := new(Glossary)
	err := c.cc.Invoke(ctx, TranslationService_GetGlossary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) DeleteGlossary(ctx context.Context, in *DeleteGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TranslationService_DeleteGlossary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) GetGlossaryEntry(ctx context.Context, in *GetGlossaryEntryRequest, opts ...grpc.CallOption) (*GlossaryEntry, error) {
	out := new(GlossaryEntry)
	err := c.cc.Invoke(ctx, TranslationService_GetGlossaryEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ListGlossaryEntries(ctx context.Context, in *ListGlossaryEntriesRequest, opts ...grpc.CallOption) (*ListGlossaryEntriesResponse, error) {
	out := new(ListGlossaryEntriesResponse)
	err := c.cc.Invoke(ctx, TranslationService_ListGlossaryEntries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) CreateGlossaryEntry(ctx context.Context, in *CreateGlossaryEntryRequest, opts ...grpc.CallOption) (*GlossaryEntry, error) {
	out := new(GlossaryEntry)
	err := c.cc.Invoke(ctx, TranslationService_CreateGlossaryEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) UpdateGlossaryEntry(ctx context.Context, in *UpdateGlossaryEntryRequest, opts ...grpc.CallOption) (*GlossaryEntry, error) {
	out := new(GlossaryEntry)
	err := c.cc.Invoke(ctx, TranslationService_UpdateGlossaryEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) DeleteGlossaryEntry(ctx context.Context, in *DeleteGlossaryEntryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, TranslationService_DeleteGlossaryEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TranslationService_CreateDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, TranslationService_GetDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error) {
	out := new(ListDatasetsResponse)
	err := c.cc.Invoke(ctx, TranslationService_ListDatasets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TranslationService_DeleteDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) CreateAdaptiveMtDataset(ctx context.Context, in *CreateAdaptiveMtDatasetRequest, opts ...grpc.CallOption) (*AdaptiveMtDataset, error) {
	out := new(AdaptiveMtDataset)
	err := c.cc.Invoke(ctx, TranslationService_CreateAdaptiveMtDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) DeleteAdaptiveMtDataset(ctx context.Context, in *DeleteAdaptiveMtDatasetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, TranslationService_DeleteAdaptiveMtDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) GetAdaptiveMtDataset(ctx context.Context, in *GetAdaptiveMtDatasetRequest, opts ...grpc.CallOption) (*AdaptiveMtDataset, error) {
	out := new(AdaptiveMtDataset)
	err := c.cc.Invoke(ctx, TranslationService_GetAdaptiveMtDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ListAdaptiveMtDatasets(ctx context.Context, in *ListAdaptiveMtDatasetsRequest, opts ...grpc.CallOption) (*ListAdaptiveMtDatasetsResponse, error) {
	out := new(ListAdaptiveMtDatasetsResponse)
	err := c.cc.Invoke(ctx, TranslationService_ListAdaptiveMtDatasets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) AdaptiveMtTranslate(ctx context.Context, in *AdaptiveMtTranslateRequest, opts ...grpc.CallOption) (*AdaptiveMtTranslateResponse, error) {
	out := new(AdaptiveMtTranslateResponse)
	err := c.cc.Invoke(ctx, TranslationService_AdaptiveMtTranslate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) GetAdaptiveMtFile(ctx context.Context, in *GetAdaptiveMtFileRequest, opts ...grpc.CallOption) (*AdaptiveMtFile, error) {
	out := new(AdaptiveMtFile)
	err := c.cc.Invoke(ctx, TranslationService_GetAdaptiveMtFile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) DeleteAdaptiveMtFile(ctx context.Context, in *DeleteAdaptiveMtFileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, TranslationService_DeleteAdaptiveMtFile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ImportAdaptiveMtFile(ctx context.Context, in *ImportAdaptiveMtFileRequest, opts ...grpc.CallOption) (*ImportAdaptiveMtFileResponse, error) {
	out := new(ImportAdaptiveMtFileResponse)
	err := c.cc.Invoke(ctx, TranslationService_ImportAdaptiveMtFile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ListAdaptiveMtFiles(ctx context.Context, in *ListAdaptiveMtFilesRequest, opts ...grpc.CallOption) (*ListAdaptiveMtFilesResponse, error) {
	out := new(ListAdaptiveMtFilesResponse)
	err := c.cc.Invoke(ctx, TranslationService_ListAdaptiveMtFiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ListAdaptiveMtSentences(ctx context.Context, in *ListAdaptiveMtSentencesRequest, opts ...grpc.CallOption) (*ListAdaptiveMtSentencesResponse, error) {
	out := new(ListAdaptiveMtSentencesResponse)
	err := c.cc.Invoke(ctx, TranslationService_ListAdaptiveMtSentences_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TranslationService_ImportData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TranslationService_ExportData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ListExamples(ctx context.Context, in *ListExamplesRequest, opts ...grpc.CallOption) (*ListExamplesResponse, error) {
	out := new(ListExamplesResponse)
	err := c.cc.Invoke(ctx, TranslationService_ListExamples_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TranslationService_CreateModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := c.cc.Invoke(ctx, TranslationService_ListModels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, TranslationService_GetModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TranslationService_DeleteModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TranslationServiceServer is the server API for TranslationService service.
// All implementations should embed UnimplementedTranslationServiceServer
// for forward compatibility
type TranslationServiceServer interface {
	// Translates input text and returns translated text.
	TranslateText(context.Context, *TranslateTextRequest) (*TranslateTextResponse, error)
	// Romanize input text written in non-Latin scripts to Latin text.
	RomanizeText(context.Context, *RomanizeTextRequest) (*RomanizeTextResponse, error)
	// Detects the language of text within a request.
	DetectLanguage(context.Context, *DetectLanguageRequest) (*DetectLanguageResponse, error)
	// Returns a list of supported languages for translation.
	GetSupportedLanguages(context.Context, *GetSupportedLanguagesRequest) (*SupportedLanguages, error)
	// Translates documents in synchronous mode.
	TranslateDocument(context.Context, *TranslateDocumentRequest) (*TranslateDocumentResponse, error)
	// Translates a large volume of text in asynchronous batch mode.
	// This function provides real-time output as the inputs are being processed.
	// If caller cancels a request, the partial results (for an input file, it's
	// all or nothing) may still be available on the specified output location.
	//
	// This call returns immediately and you can
	// use google.longrunning.Operation.name to poll the status of the call.
	BatchTranslateText(context.Context, *BatchTranslateTextRequest) (*longrunningpb.Operation, error)
	// Translates a large volume of document in asynchronous batch mode.
	// This function provides real-time output as the inputs are being processed.
	// If caller cancels a request, the partial results (for an input file, it's
	// all or nothing) may still be available on the specified output location.
	//
	// This call returns immediately and you can use
	// google.longrunning.Operation.name to poll the status of the call.
	BatchTranslateDocument(context.Context, *BatchTranslateDocumentRequest) (*longrunningpb.Operation, error)
	// Creates a glossary and returns the long-running operation. Returns
	// NOT_FOUND, if the project doesn't exist.
	CreateGlossary(context.Context, *CreateGlossaryRequest) (*longrunningpb.Operation, error)
	// Updates a glossary. A LRO is used since the update can be async if the
	// glossary's entry file is updated.
	UpdateGlossary(context.Context, *UpdateGlossaryRequest) (*longrunningpb.Operation, error)
	// Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't
	// exist.
	ListGlossaries(context.Context, *ListGlossariesRequest) (*ListGlossariesResponse, error)
	// Gets a glossary. Returns NOT_FOUND, if the glossary doesn't
	// exist.
	GetGlossary(context.Context, *GetGlossaryRequest) (*Glossary, error)
	// Deletes a glossary, or cancels glossary construction
	// if the glossary isn't created yet.
	// Returns NOT_FOUND, if the glossary doesn't exist.
	DeleteGlossary(context.Context, *DeleteGlossaryRequest) (*longrunningpb.Operation, error)
	// Gets a single glossary entry by the given id.
	GetGlossaryEntry(context.Context, *GetGlossaryEntryRequest) (*GlossaryEntry, error)
	// List the entries for the glossary.
	ListGlossaryEntries(context.Context, *ListGlossaryEntriesRequest) (*ListGlossaryEntriesResponse, error)
	// Creates a glossary entry.
	CreateGlossaryEntry(context.Context, *CreateGlossaryEntryRequest) (*GlossaryEntry, error)
	// Updates a glossary entry.
	UpdateGlossaryEntry(context.Context, *UpdateGlossaryEntryRequest) (*GlossaryEntry, error)
	// Deletes a single entry from the glossary
	DeleteGlossaryEntry(context.Context, *DeleteGlossaryEntryRequest) (*emptypb.Empty, error)
	// Creates a Dataset.
	CreateDataset(context.Context, *CreateDatasetRequest) (*longrunningpb.Operation, error)
	// Gets a Dataset.
	GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error)
	// Lists datasets.
	ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error)
	// Deletes a dataset and all of its contents.
	DeleteDataset(context.Context, *DeleteDatasetRequest) (*longrunningpb.Operation, error)
	// Creates an Adaptive MT dataset.
	CreateAdaptiveMtDataset(context.Context, *CreateAdaptiveMtDatasetRequest) (*AdaptiveMtDataset, error)
	// Deletes an Adaptive MT dataset, including all its entries and associated
	// metadata.
	DeleteAdaptiveMtDataset(context.Context, *DeleteAdaptiveMtDatasetRequest) (*emptypb.Empty, error)
	// Gets the Adaptive MT dataset.
	GetAdaptiveMtDataset(context.Context, *GetAdaptiveMtDatasetRequest) (*AdaptiveMtDataset, error)
	// Lists all Adaptive MT datasets for which the caller has read permission.
	ListAdaptiveMtDatasets(context.Context, *ListAdaptiveMtDatasetsRequest) (*ListAdaptiveMtDatasetsResponse, error)
	// Translate text using Adaptive MT.
	AdaptiveMtTranslate(context.Context, *AdaptiveMtTranslateRequest) (*AdaptiveMtTranslateResponse, error)
	// Gets and AdaptiveMtFile
	GetAdaptiveMtFile(context.Context, *GetAdaptiveMtFileRequest) (*AdaptiveMtFile, error)
	// Deletes an AdaptiveMtFile along with its sentences.
	DeleteAdaptiveMtFile(context.Context, *DeleteAdaptiveMtFileRequest) (*emptypb.Empty, error)
	// Imports an AdaptiveMtFile and adds all of its sentences into the
	// AdaptiveMtDataset.
	ImportAdaptiveMtFile(context.Context, *ImportAdaptiveMtFileRequest) (*ImportAdaptiveMtFileResponse, error)
	// Lists all AdaptiveMtFiles associated to an AdaptiveMtDataset.
	ListAdaptiveMtFiles(context.Context, *ListAdaptiveMtFilesRequest) (*ListAdaptiveMtFilesResponse, error)
	// Lists all AdaptiveMtSentences under a given file/dataset.
	ListAdaptiveMtSentences(context.Context, *ListAdaptiveMtSentencesRequest) (*ListAdaptiveMtSentencesResponse, error)
	// Import sentence pairs into translation Dataset.
	ImportData(context.Context, *ImportDataRequest) (*longrunningpb.Operation, error)
	// Exports dataset's data to the provided output location.
	ExportData(context.Context, *ExportDataRequest) (*longrunningpb.Operation, error)
	// Lists sentence pairs in the dataset.
	ListExamples(context.Context, *ListExamplesRequest) (*ListExamplesResponse, error)
	// Creates a Model.
	CreateModel(context.Context, *CreateModelRequest) (*longrunningpb.Operation, error)
	// Lists models.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Gets a model.
	GetModel(context.Context, *GetModelRequest) (*Model, error)
	// Deletes a model.
	DeleteModel(context.Context, *DeleteModelRequest) (*longrunningpb.Operation, error)
}

// UnimplementedTranslationServiceServer should be embedded to have forward compatible implementations.
type UnimplementedTranslationServiceServer struct {
}

func (UnimplementedTranslationServiceServer) TranslateText(context.Context, *TranslateTextRequest) (*TranslateTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TranslateText not implemented")
}
func (UnimplementedTranslationServiceServer) RomanizeText(context.Context, *RomanizeTextRequest) (*RomanizeTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RomanizeText not implemented")
}
func (UnimplementedTranslationServiceServer) DetectLanguage(context.Context, *DetectLanguageRequest) (*DetectLanguageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetectLanguage not implemented")
}
func (UnimplementedTranslationServiceServer) GetSupportedLanguages(context.Context, *GetSupportedLanguagesRequest) (*SupportedLanguages, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSupportedLanguages not implemented")
}
func (UnimplementedTranslationServiceServer) TranslateDocument(context.Context, *TranslateDocumentRequest) (*TranslateDocumentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TranslateDocument not implemented")
}
func (UnimplementedTranslationServiceServer) BatchTranslateText(context.Context, *BatchTranslateTextRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchTranslateText not implemented")
}
func (UnimplementedTranslationServiceServer) BatchTranslateDocument(context.Context, *BatchTranslateDocumentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchTranslateDocument not implemented")
}
func (UnimplementedTranslationServiceServer) CreateGlossary(context.Context, *CreateGlossaryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGlossary not implemented")
}
func (UnimplementedTranslationServiceServer) UpdateGlossary(context.Context, *UpdateGlossaryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGlossary not implemented")
}
func (UnimplementedTranslationServiceServer) ListGlossaries(context.Context, *ListGlossariesRequest) (*ListGlossariesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGlossaries not implemented")
}
func (UnimplementedTranslationServiceServer) GetGlossary(context.Context, *GetGlossaryRequest) (*Glossary, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGlossary not implemented")
}
func (UnimplementedTranslationServiceServer) DeleteGlossary(context.Context, *DeleteGlossaryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGlossary not implemented")
}
func (UnimplementedTranslationServiceServer) GetGlossaryEntry(context.Context, *GetGlossaryEntryRequest) (*GlossaryEntry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGlossaryEntry not implemented")
}
func (UnimplementedTranslationServiceServer) ListGlossaryEntries(context.Context, *ListGlossaryEntriesRequest) (*ListGlossaryEntriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGlossaryEntries not implemented")
}
func (UnimplementedTranslationServiceServer) CreateGlossaryEntry(context.Context, *CreateGlossaryEntryRequest) (*GlossaryEntry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGlossaryEntry not implemented")
}
func (UnimplementedTranslationServiceServer) UpdateGlossaryEntry(context.Context, *UpdateGlossaryEntryRequest) (*GlossaryEntry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGlossaryEntry not implemented")
}
func (UnimplementedTranslationServiceServer) DeleteGlossaryEntry(context.Context, *DeleteGlossaryEntryRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGlossaryEntry not implemented")
}
func (UnimplementedTranslationServiceServer) CreateDataset(context.Context, *CreateDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataset not implemented")
}
func (UnimplementedTranslationServiceServer) GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataset not implemented")
}
func (UnimplementedTranslationServiceServer) ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatasets not implemented")
}
func (UnimplementedTranslationServiceServer) DeleteDataset(context.Context, *DeleteDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataset not implemented")
}
func (UnimplementedTranslationServiceServer) CreateAdaptiveMtDataset(context.Context, *CreateAdaptiveMtDatasetRequest) (*AdaptiveMtDataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAdaptiveMtDataset not implemented")
}
func (UnimplementedTranslationServiceServer) DeleteAdaptiveMtDataset(context.Context, *DeleteAdaptiveMtDatasetRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAdaptiveMtDataset not implemented")
}
func (UnimplementedTranslationServiceServer) GetAdaptiveMtDataset(context.Context, *GetAdaptiveMtDatasetRequest) (*AdaptiveMtDataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAdaptiveMtDataset not implemented")
}
func (UnimplementedTranslationServiceServer) ListAdaptiveMtDatasets(context.Context, *ListAdaptiveMtDatasetsRequest) (*ListAdaptiveMtDatasetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAdaptiveMtDatasets not implemented")
}
func (UnimplementedTranslationServiceServer) AdaptiveMtTranslate(context.Context, *AdaptiveMtTranslateRequest) (*AdaptiveMtTranslateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AdaptiveMtTranslate not implemented")
}
func (UnimplementedTranslationServiceServer) GetAdaptiveMtFile(context.Context, *GetAdaptiveMtFileRequest) (*AdaptiveMtFile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAdaptiveMtFile not implemented")
}
func (UnimplementedTranslationServiceServer) DeleteAdaptiveMtFile(context.Context, *DeleteAdaptiveMtFileRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAdaptiveMtFile not implemented")
}
func (UnimplementedTranslationServiceServer) ImportAdaptiveMtFile(context.Context, *ImportAdaptiveMtFileRequest) (*ImportAdaptiveMtFileResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportAdaptiveMtFile not implemented")
}
func (UnimplementedTranslationServiceServer) ListAdaptiveMtFiles(context.Context, *ListAdaptiveMtFilesRequest) (*ListAdaptiveMtFilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAdaptiveMtFiles not implemented")
}
func (UnimplementedTranslationServiceServer) ListAdaptiveMtSentences(context.Context, *ListAdaptiveMtSentencesRequest) (*ListAdaptiveMtSentencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAdaptiveMtSentences not implemented")
}
func (UnimplementedTranslationServiceServer) ImportData(context.Context, *ImportDataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportData not implemented")
}
func (UnimplementedTranslationServiceServer) ExportData(context.Context, *ExportDataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportData not implemented")
}
func (UnimplementedTranslationServiceServer) ListExamples(context.Context, *ListExamplesRequest) (*ListExamplesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExamples not implemented")
}
func (UnimplementedTranslationServiceServer) CreateModel(context.Context, *CreateModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateModel not implemented")
}
func (UnimplementedTranslationServiceServer) ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModels not implemented")
}
func (UnimplementedTranslationServiceServer) GetModel(context.Context, *GetModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModel not implemented")
}
func (UnimplementedTranslationServiceServer) DeleteModel(context.Context, *DeleteModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteModel not implemented")
}

// UnsafeTranslationServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TranslationServiceServer will
// result in compilation errors.
type UnsafeTranslationServiceServer interface {
	mustEmbedUnimplementedTranslationServiceServer()
}

func RegisterTranslationServiceServer(s grpc.ServiceRegistrar, srv TranslationServiceServer) {
	s.RegisterService(&TranslationService_ServiceDesc, srv)
}

func _TranslationService_TranslateText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TranslateTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).TranslateText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_TranslateText_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).TranslateText(ctx, req.(*TranslateTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_RomanizeText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RomanizeTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).RomanizeText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_RomanizeText_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).RomanizeText(ctx, req.(*RomanizeTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_DetectLanguage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetectLanguageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).DetectLanguage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_DetectLanguage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).DetectLanguage(ctx, req.(*DetectLanguageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_GetSupportedLanguages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSupportedLanguagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).GetSupportedLanguages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_GetSupportedLanguages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).GetSupportedLanguages(ctx, req.(*GetSupportedLanguagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_TranslateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TranslateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).TranslateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_TranslateDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).TranslateDocument(ctx, req.(*TranslateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_BatchTranslateText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchTranslateTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).BatchTranslateText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_BatchTranslateText_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).BatchTranslateText(ctx, req.(*BatchTranslateTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_BatchTranslateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchTranslateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).BatchTranslateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_BatchTranslateDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).BatchTranslateDocument(ctx, req.(*BatchTranslateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_CreateGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).CreateGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_CreateGlossary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).CreateGlossary(ctx, req.(*CreateGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_UpdateGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).UpdateGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_UpdateGlossary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).UpdateGlossary(ctx, req.(*UpdateGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ListGlossaries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGlossariesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ListGlossaries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_ListGlossaries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ListGlossaries(ctx, req.(*ListGlossariesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_GetGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).GetGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_GetGlossary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).GetGlossary(ctx, req.(*GetGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_DeleteGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).DeleteGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_DeleteGlossary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).DeleteGlossary(ctx, req.(*DeleteGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_GetGlossaryEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlossaryEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).GetGlossaryEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_GetGlossaryEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).GetGlossaryEntry(ctx, req.(*GetGlossaryEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ListGlossaryEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGlossaryEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ListGlossaryEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_ListGlossaryEntries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ListGlossaryEntries(ctx, req.(*ListGlossaryEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_CreateGlossaryEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGlossaryEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).CreateGlossaryEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_CreateGlossaryEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).CreateGlossaryEntry(ctx, req.(*CreateGlossaryEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_UpdateGlossaryEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGlossaryEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).UpdateGlossaryEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_UpdateGlossaryEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).UpdateGlossaryEntry(ctx, req.(*UpdateGlossaryEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_DeleteGlossaryEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGlossaryEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).DeleteGlossaryEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_DeleteGlossaryEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).DeleteGlossaryEntry(ctx, req.(*DeleteGlossaryEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_CreateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).CreateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_CreateDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).CreateDataset(ctx, req.(*CreateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_GetDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).GetDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_GetDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).GetDataset(ctx, req.(*GetDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ListDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ListDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_ListDatasets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ListDatasets(ctx, req.(*ListDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_DeleteDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).DeleteDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_DeleteDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).DeleteDataset(ctx, req.(*DeleteDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_CreateAdaptiveMtDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAdaptiveMtDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).CreateAdaptiveMtDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_CreateAdaptiveMtDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).CreateAdaptiveMtDataset(ctx, req.(*CreateAdaptiveMtDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_DeleteAdaptiveMtDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAdaptiveMtDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).DeleteAdaptiveMtDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_DeleteAdaptiveMtDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).DeleteAdaptiveMtDataset(ctx, req.(*DeleteAdaptiveMtDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_GetAdaptiveMtDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAdaptiveMtDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).GetAdaptiveMtDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_GetAdaptiveMtDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).GetAdaptiveMtDataset(ctx, req.(*GetAdaptiveMtDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ListAdaptiveMtDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAdaptiveMtDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ListAdaptiveMtDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_ListAdaptiveMtDatasets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ListAdaptiveMtDatasets(ctx, req.(*ListAdaptiveMtDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_AdaptiveMtTranslate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AdaptiveMtTranslateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).AdaptiveMtTranslate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_AdaptiveMtTranslate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).AdaptiveMtTranslate(ctx, req.(*AdaptiveMtTranslateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_GetAdaptiveMtFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAdaptiveMtFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).GetAdaptiveMtFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_GetAdaptiveMtFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).GetAdaptiveMtFile(ctx, req.(*GetAdaptiveMtFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_DeleteAdaptiveMtFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAdaptiveMtFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).DeleteAdaptiveMtFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_DeleteAdaptiveMtFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).DeleteAdaptiveMtFile(ctx, req.(*DeleteAdaptiveMtFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ImportAdaptiveMtFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportAdaptiveMtFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ImportAdaptiveMtFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_ImportAdaptiveMtFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ImportAdaptiveMtFile(ctx, req.(*ImportAdaptiveMtFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ListAdaptiveMtFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAdaptiveMtFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ListAdaptiveMtFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_ListAdaptiveMtFiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ListAdaptiveMtFiles(ctx, req.(*ListAdaptiveMtFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ListAdaptiveMtSentences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAdaptiveMtSentencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ListAdaptiveMtSentences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_ListAdaptiveMtSentences_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ListAdaptiveMtSentences(ctx, req.(*ListAdaptiveMtSentencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ImportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ImportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_ImportData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ImportData(ctx, req.(*ImportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ExportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ExportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_ExportData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ExportData(ctx, req.(*ExportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ListExamples_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExamplesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ListExamples(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_ListExamples_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ListExamples(ctx, req.(*ListExamplesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_CreateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).CreateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_CreateModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).CreateModel(ctx, req.(*CreateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_ListModels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_GetModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).GetModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_GetModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).GetModel(ctx, req.(*GetModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_DeleteModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).DeleteModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranslationService_DeleteModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).DeleteModel(ctx, req.(*DeleteModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// TranslationService_ServiceDesc is the grpc.ServiceDesc for TranslationService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var TranslationService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.translation.v3.TranslationService",
	HandlerType: (*TranslationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "TranslateText",
			Handler:    _TranslationService_TranslateText_Handler,
		},
		{
			MethodName: "RomanizeText",
			Handler:    _TranslationService_RomanizeText_Handler,
		},
		{
			MethodName: "DetectLanguage",
			Handler:    _TranslationService_DetectLanguage_Handler,
		},
		{
			MethodName: "GetSupportedLanguages",
			Handler:    _TranslationService_GetSupportedLanguages_Handler,
		},
		{
			MethodName: "TranslateDocument",
			Handler:    _TranslationService_TranslateDocument_Handler,
		},
		{
			MethodName: "BatchTranslateText",
			Handler:    _TranslationService_BatchTranslateText_Handler,
		},
		{
			MethodName: "BatchTranslateDocument",
			Handler:    _TranslationService_BatchTranslateDocument_Handler,
		},
		{
			MethodName: "CreateGlossary",
			Handler:    _TranslationService_CreateGlossary_Handler,
		},
		{
			MethodName: "UpdateGlossary",
			Handler:    _TranslationService_UpdateGlossary_Handler,
		},
		{
			MethodName: "ListGlossaries",
			Handler:    _TranslationService_ListGlossaries_Handler,
		},
		{
			MethodName: "GetGlossary",
			Handler:    _TranslationService_GetGlossary_Handler,
		},
		{
			MethodName: "DeleteGlossary",
			Handler:    _TranslationService_DeleteGlossary_Handler,
		},
		{
			MethodName: "GetGlossaryEntry",
			Handler:    _TranslationService_GetGlossaryEntry_Handler,
		},
		{
			MethodName: "ListGlossaryEntries",
			Handler:    _TranslationService_ListGlossaryEntries_Handler,
		},
		{
			MethodName: "CreateGlossaryEntry",
			Handler:    _TranslationService_CreateGlossaryEntry_Handler,
		},
		{
			MethodName: "UpdateGlossaryEntry",
			Handler:    _TranslationService_UpdateGlossaryEntry_Handler,
		},
		{
			MethodName: "DeleteGlossaryEntry",
			Handler:    _TranslationService_DeleteGlossaryEntry_Handler,
		},
		{
			MethodName: "CreateDataset",
			Handler:    _TranslationService_CreateDataset_Handler,
		},
		{
			MethodName: "GetDataset",
			Handler:    _TranslationService_GetDataset_Handler,
		},
		{
			MethodName: "ListDatasets",
			Handler:    _TranslationService_ListDatasets_Handler,
		},
		{
			MethodName: "DeleteDataset",
			Handler:    _TranslationService_DeleteDataset_Handler,
		},
		{
			MethodName: "CreateAdaptiveMtDataset",
			Handler:    _TranslationService_CreateAdaptiveMtDataset_Handler,
		},
		{
			MethodName: "DeleteAdaptiveMtDataset",
			Handler:    _TranslationService_DeleteAdaptiveMtDataset_Handler,
		},
		{
			MethodName: "GetAdaptiveMtDataset",
			Handler:    _TranslationService_GetAdaptiveMtDataset_Handler,
		},
		{
			MethodName: "ListAdaptiveMtDatasets",
			Handler:    _TranslationService_ListAdaptiveMtDatasets_Handler,
		},
		{
			MethodName: "AdaptiveMtTranslate",
			Handler:    _TranslationService_AdaptiveMtTranslate_Handler,
		},
		{
			MethodName: "GetAdaptiveMtFile",
			Handler:    _TranslationService_GetAdaptiveMtFile_Handler,
		},
		{
			MethodName: "DeleteAdaptiveMtFile",
			Handler:    _TranslationService_DeleteAdaptiveMtFile_Handler,
		},
		{
			MethodName: "ImportAdaptiveMtFile",
			Handler:    _TranslationService_ImportAdaptiveMtFile_Handler,
		},
		{
			MethodName: "ListAdaptiveMtFiles",
			Handler:    _TranslationService_ListAdaptiveMtFiles_Handler,
		},
		{
			MethodName: "ListAdaptiveMtSentences",
			Handler:    _TranslationService_ListAdaptiveMtSentences_Handler,
		},
		{
			MethodName: "ImportData",
			Handler:    _TranslationService_ImportData_Handler,
		},
		{
			MethodName: "ExportData",
			Handler:    _TranslationService_ExportData_Handler,
		},
		{
			MethodName: "ListExamples",
			Handler:    _TranslationService_ListExamples_Handler,
		},
		{
			MethodName: "CreateModel",
			Handler:    _TranslationService_CreateModel_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _TranslationService_ListModels_Handler,
		},
		{
			MethodName: "GetModel",
			Handler:    _TranslationService_GetModel_Handler,
		},
		{
			MethodName: "DeleteModel",
			Handler:    _TranslationService_DeleteModel_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/translate/v3/translation_service.proto",
}
