// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/accessapproval/v1/accessapproval.proto

package accessapproval

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents the type of enrollment for a given service to Access Approval.
type EnrollmentLevel int32

const (
	// Default value for proto, shouldn't be used.
	EnrollmentLevel_ENROLLMENT_LEVEL_UNSPECIFIED EnrollmentLevel = 0
	// Service is enrolled in Access Approval for all requests
	EnrollmentLevel_BLOCK_ALL EnrollmentLevel = 1
)

var EnrollmentLevel_name = map[int32]string{
	0: "ENROLLMENT_LEVEL_UNSPECIFIED",
	1: "BLOCK_ALL",
}

var EnrollmentLevel_value = map[string]int32{
	"ENROLLMENT_LEVEL_UNSPECIFIED": 0,
	"BLOCK_ALL":                    1,
}

func (x EnrollmentLevel) String() string {
	return proto.EnumName(EnrollmentLevel_name, int32(x))
}

func (EnrollmentLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{0}
}

// Type of access justification.
type AccessReason_Type int32

const (
	// Default value for proto, shouldn't be used.
	AccessReason_TYPE_UNSPECIFIED AccessReason_Type = 0
	// Customer made a request or raised an issue that required the principal to
	// access customer data. `detail` is of the form ("#####" is the issue ID):
	// <ol>
	//   <li>"Feedback Report: #####"</li>
	//   <li>"Case Number: #####"</li>
	//   <li>"Case ID: #####"</li>
	//   <li>"E-PIN Reference: #####"</li>
	//   <li>"Google-#####"</li>
	//   <li>"T-#####"</li>
	// </ol>
	AccessReason_CUSTOMER_INITIATED_SUPPORT AccessReason_Type = 1
	// The principal accessed customer data in order to diagnose or resolve a
	// suspected issue in services or a known outage. Often this access is used
	// to confirm that customers are not affected by a suspected service issue
	// or to remediate a reversible system issue.
	AccessReason_GOOGLE_INITIATED_SERVICE AccessReason_Type = 2
	// Google initiated service for security, fraud, abuse, or compliance
	// purposes.
	AccessReason_GOOGLE_INITIATED_REVIEW AccessReason_Type = 3
)

var AccessReason_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "CUSTOMER_INITIATED_SUPPORT",
	2: "GOOGLE_INITIATED_SERVICE",
	3: "GOOGLE_INITIATED_REVIEW",
}

var AccessReason_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":           0,
	"CUSTOMER_INITIATED_SUPPORT": 1,
	"GOOGLE_INITIATED_SERVICE":   2,
	"GOOGLE_INITIATED_REVIEW":    3,
}

func (x AccessReason_Type) String() string {
	return proto.EnumName(AccessReason_Type_name, int32(x))
}

func (AccessReason_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{1, 0}
}

// Home office and physical location of the principal.
type AccessLocations struct {
	// The "home office" location of the principal. A two-letter country code
	// (ISO 3166-1 alpha-2), such as "US", "DE" or "GB" or a region code. In some
	// limited situations Google systems may refer refer to a region code instead
	// of a country code.
	// Possible Region Codes:
	// <ol>
	//   <li>ASI: Asia</li>
	//   <li>EUR: Europe</li>
	//   <li>OCE: Oceania</li>
	//   <li>AFR: Africa</li>
	//   <li>NAM: North America</li>
	//   <li>SAM: South America</li>
	//   <li>ANT: Antarctica</li>
	//   <li>ANY: Any location</li>
	// </ol>
	PrincipalOfficeCountry string `protobuf:"bytes,1,opt,name=principal_office_country,json=principalOfficeCountry,proto3" json:"principal_office_country,omitempty"`
	// Physical location of the principal at the time of the access. A
	// two-letter country code (ISO 3166-1 alpha-2), such as "US", "DE" or "GB" or
	// a region code. In some limited situations Google systems may refer refer to
	// a region code instead of a country code.
	// Possible Region Codes:
	// <ol>
	//   <li>ASI: Asia</li>
	//   <li>EUR: Europe</li>
	//   <li>OCE: Oceania</li>
	//   <li>AFR: Africa</li>
	//   <li>NAM: North America</li>
	//   <li>SAM: South America</li>
	//   <li>ANT: Antarctica</li>
	//   <li>ANY: Any location</li>
	// </ol>
	PrincipalPhysicalLocationCountry string   `protobuf:"bytes,2,opt,name=principal_physical_location_country,json=principalPhysicalLocationCountry,proto3" json:"principal_physical_location_country,omitempty"`
	XXX_NoUnkeyedLiteral             struct{} `json:"-"`
	XXX_unrecognized                 []byte   `json:"-"`
	XXX_sizecache                    int32    `json:"-"`
}

func (m *AccessLocations) Reset()         { *m = AccessLocations{} }
func (m *AccessLocations) String() string { return proto.CompactTextString(m) }
func (*AccessLocations) ProtoMessage()    {}
func (*AccessLocations) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{0}
}

func (m *AccessLocations) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccessLocations.Unmarshal(m, b)
}
func (m *AccessLocations) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccessLocations.Marshal(b, m, deterministic)
}
func (m *AccessLocations) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessLocations.Merge(m, src)
}
func (m *AccessLocations) XXX_Size() int {
	return xxx_messageInfo_AccessLocations.Size(m)
}
func (m *AccessLocations) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessLocations.DiscardUnknown(m)
}

var xxx_messageInfo_AccessLocations proto.InternalMessageInfo

func (m *AccessLocations) GetPrincipalOfficeCountry() string {
	if m != nil {
		return m.PrincipalOfficeCountry
	}
	return ""
}

func (m *AccessLocations) GetPrincipalPhysicalLocationCountry() string {
	if m != nil {
		return m.PrincipalPhysicalLocationCountry
	}
	return ""
}

type AccessReason struct {
	// Type of access justification.
	Type AccessReason_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.accessapproval.v1.AccessReason_Type" json:"type,omitempty"`
	// More detail about certain reason types. See comments for each type above.
	Detail               string   `protobuf:"bytes,2,opt,name=detail,proto3" json:"detail,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccessReason) Reset()         { *m = AccessReason{} }
func (m *AccessReason) String() string { return proto.CompactTextString(m) }
func (*AccessReason) ProtoMessage()    {}
func (*AccessReason) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{1}
}

func (m *AccessReason) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccessReason.Unmarshal(m, b)
}
func (m *AccessReason) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccessReason.Marshal(b, m, deterministic)
}
func (m *AccessReason) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessReason.Merge(m, src)
}
func (m *AccessReason) XXX_Size() int {
	return xxx_messageInfo_AccessReason.Size(m)
}
func (m *AccessReason) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessReason.DiscardUnknown(m)
}

var xxx_messageInfo_AccessReason proto.InternalMessageInfo

func (m *AccessReason) GetType() AccessReason_Type {
	if m != nil {
		return m.Type
	}
	return AccessReason_TYPE_UNSPECIFIED
}

func (m *AccessReason) GetDetail() string {
	if m != nil {
		return m.Detail
	}
	return ""
}

// A decision that has been made to approve access to a resource.
type ApproveDecision struct {
	// The time at which approval was granted.
	ApproveTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=approve_time,json=approveTime,proto3" json:"approve_time,omitempty"`
	// The time at which the approval expires.
	ExpireTime           *timestamp.Timestamp `protobuf:"bytes,2,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ApproveDecision) Reset()         { *m = ApproveDecision{} }
func (m *ApproveDecision) String() string { return proto.CompactTextString(m) }
func (*ApproveDecision) ProtoMessage()    {}
func (*ApproveDecision) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{2}
}

func (m *ApproveDecision) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApproveDecision.Unmarshal(m, b)
}
func (m *ApproveDecision) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApproveDecision.Marshal(b, m, deterministic)
}
func (m *ApproveDecision) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApproveDecision.Merge(m, src)
}
func (m *ApproveDecision) XXX_Size() int {
	return xxx_messageInfo_ApproveDecision.Size(m)
}
func (m *ApproveDecision) XXX_DiscardUnknown() {
	xxx_messageInfo_ApproveDecision.DiscardUnknown(m)
}

var xxx_messageInfo_ApproveDecision proto.InternalMessageInfo

func (m *ApproveDecision) GetApproveTime() *timestamp.Timestamp {
	if m != nil {
		return m.ApproveTime
	}
	return nil
}

func (m *ApproveDecision) GetExpireTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpireTime
	}
	return nil
}

// A decision that has been made to dismiss an approval request.
type DismissDecision struct {
	// The time at which the approval request was dismissed.
	DismissTime          *timestamp.Timestamp `protobuf:"bytes,1,opt,name=dismiss_time,json=dismissTime,proto3" json:"dismiss_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *DismissDecision) Reset()         { *m = DismissDecision{} }
func (m *DismissDecision) String() string { return proto.CompactTextString(m) }
func (*DismissDecision) ProtoMessage()    {}
func (*DismissDecision) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{3}
}

func (m *DismissDecision) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismissDecision.Unmarshal(m, b)
}
func (m *DismissDecision) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismissDecision.Marshal(b, m, deterministic)
}
func (m *DismissDecision) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismissDecision.Merge(m, src)
}
func (m *DismissDecision) XXX_Size() int {
	return xxx_messageInfo_DismissDecision.Size(m)
}
func (m *DismissDecision) XXX_DiscardUnknown() {
	xxx_messageInfo_DismissDecision.DiscardUnknown(m)
}

var xxx_messageInfo_DismissDecision proto.InternalMessageInfo

func (m *DismissDecision) GetDismissTime() *timestamp.Timestamp {
	if m != nil {
		return m.DismissTime
	}
	return nil
}

// The properties associated with the resource of the request.
type ResourceProperties struct {
	// Whether an approval will exclude the descendants of the resource being
	// requested.
	ExcludesDescendants  bool     `protobuf:"varint,1,opt,name=excludes_descendants,json=excludesDescendants,proto3" json:"excludes_descendants,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResourceProperties) Reset()         { *m = ResourceProperties{} }
func (m *ResourceProperties) String() string { return proto.CompactTextString(m) }
func (*ResourceProperties) ProtoMessage()    {}
func (*ResourceProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{4}
}

func (m *ResourceProperties) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResourceProperties.Unmarshal(m, b)
}
func (m *ResourceProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResourceProperties.Marshal(b, m, deterministic)
}
func (m *ResourceProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceProperties.Merge(m, src)
}
func (m *ResourceProperties) XXX_Size() int {
	return xxx_messageInfo_ResourceProperties.Size(m)
}
func (m *ResourceProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceProperties.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceProperties proto.InternalMessageInfo

func (m *ResourceProperties) GetExcludesDescendants() bool {
	if m != nil {
		return m.ExcludesDescendants
	}
	return false
}

// A request for the customer to approve access to a resource.
type ApprovalRequest struct {
	// The resource name of the request. Format is
	// "{projects|folders|organizations}/{id}/approvalRequests/{approval_request_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource for which approval is being requested. The format of the
	// resource name is defined at
	// https://cloud.google.com/apis/design/resource_names. The resource name here
	// may either be a "full" resource name (e.g.
	// "//library.googleapis.com/shelves/shelf1/books/book2") or a "relative"
	// resource name (e.g. "shelves/shelf1/books/book2") as described in the
	// resource name specification.
	RequestedResourceName string `protobuf:"bytes,2,opt,name=requested_resource_name,json=requestedResourceName,proto3" json:"requested_resource_name,omitempty"`
	// Properties related to the resource represented by requested_resource_name.
	RequestedResourceProperties *ResourceProperties `protobuf:"bytes,9,opt,name=requested_resource_properties,json=requestedResourceProperties,proto3" json:"requested_resource_properties,omitempty"`
	// The justification for which approval is being requested.
	RequestedReason *AccessReason `protobuf:"bytes,3,opt,name=requested_reason,json=requestedReason,proto3" json:"requested_reason,omitempty"`
	// The locations for which approval is being requested.
	RequestedLocations *AccessLocations `protobuf:"bytes,4,opt,name=requested_locations,json=requestedLocations,proto3" json:"requested_locations,omitempty"`
	// The time at which approval was requested.
	RequestTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=request_time,json=requestTime,proto3" json:"request_time,omitempty"`
	// The requested expiration for the approval. If the request is approved,
	// access will be granted from the time of approval until the expiration time.
	RequestedExpiration *timestamp.Timestamp `protobuf:"bytes,6,opt,name=requested_expiration,json=requestedExpiration,proto3" json:"requested_expiration,omitempty"`
	// The current decision on the approval request.
	//
	// Types that are valid to be assigned to Decision:
	//	*ApprovalRequest_Approve
	//	*ApprovalRequest_Dismiss
	Decision             isApprovalRequest_Decision `protobuf_oneof:"decision"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ApprovalRequest) Reset()         { *m = ApprovalRequest{} }
func (m *ApprovalRequest) String() string { return proto.CompactTextString(m) }
func (*ApprovalRequest) ProtoMessage()    {}
func (*ApprovalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{5}
}

func (m *ApprovalRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApprovalRequest.Unmarshal(m, b)
}
func (m *ApprovalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApprovalRequest.Marshal(b, m, deterministic)
}
func (m *ApprovalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApprovalRequest.Merge(m, src)
}
func (m *ApprovalRequest) XXX_Size() int {
	return xxx_messageInfo_ApprovalRequest.Size(m)
}
func (m *ApprovalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApprovalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApprovalRequest proto.InternalMessageInfo

func (m *ApprovalRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ApprovalRequest) GetRequestedResourceName() string {
	if m != nil {
		return m.RequestedResourceName
	}
	return ""
}

func (m *ApprovalRequest) GetRequestedResourceProperties() *ResourceProperties {
	if m != nil {
		return m.RequestedResourceProperties
	}
	return nil
}

func (m *ApprovalRequest) GetRequestedReason() *AccessReason {
	if m != nil {
		return m.RequestedReason
	}
	return nil
}

func (m *ApprovalRequest) GetRequestedLocations() *AccessLocations {
	if m != nil {
		return m.RequestedLocations
	}
	return nil
}

func (m *ApprovalRequest) GetRequestTime() *timestamp.Timestamp {
	if m != nil {
		return m.RequestTime
	}
	return nil
}

func (m *ApprovalRequest) GetRequestedExpiration() *timestamp.Timestamp {
	if m != nil {
		return m.RequestedExpiration
	}
	return nil
}

type isApprovalRequest_Decision interface {
	isApprovalRequest_Decision()
}

type ApprovalRequest_Approve struct {
	Approve *ApproveDecision `protobuf:"bytes,7,opt,name=approve,proto3,oneof"`
}

type ApprovalRequest_Dismiss struct {
	Dismiss *DismissDecision `protobuf:"bytes,8,opt,name=dismiss,proto3,oneof"`
}

func (*ApprovalRequest_Approve) isApprovalRequest_Decision() {}

func (*ApprovalRequest_Dismiss) isApprovalRequest_Decision() {}

func (m *ApprovalRequest) GetDecision() isApprovalRequest_Decision {
	if m != nil {
		return m.Decision
	}
	return nil
}

func (m *ApprovalRequest) GetApprove() *ApproveDecision {
	if x, ok := m.GetDecision().(*ApprovalRequest_Approve); ok {
		return x.Approve
	}
	return nil
}

func (m *ApprovalRequest) GetDismiss() *DismissDecision {
	if x, ok := m.GetDecision().(*ApprovalRequest_Dismiss); ok {
		return x.Dismiss
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ApprovalRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ApprovalRequest_Approve)(nil),
		(*ApprovalRequest_Dismiss)(nil),
	}
}

// Represents the enrollment of a cloud resource into a specific service.
type EnrolledService struct {
	// The product for which Access Approval will be enrolled. Allowed values are
	// listed below (case-sensitive):
	// <ol>
	//   <li>all</li>
	//   <li>appengine.googleapis.com</li>
	//   <li>bigquery.googleapis.com</li>
	//   <li>bigtable.googleapis.com</li>
	//   <li>cloudkms.googleapis.com</li>
	//   <li>compute.googleapis.com</li>
	//   <li>dataflow.googleapis.com</li>
	//   <li>iam.googleapis.com</li>
	//   <li>pubsub.googleapis.com</li>
	//   <li>storage.googleapis.com</li>
	// <ol>
	CloudProduct string `protobuf:"bytes,1,opt,name=cloud_product,json=cloudProduct,proto3" json:"cloud_product,omitempty"`
	// The enrollment level of the service.
	EnrollmentLevel      EnrollmentLevel `protobuf:"varint,2,opt,name=enrollment_level,json=enrollmentLevel,proto3,enum=google.cloud.accessapproval.v1.EnrollmentLevel" json:"enrollment_level,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *EnrolledService) Reset()         { *m = EnrolledService{} }
func (m *EnrolledService) String() string { return proto.CompactTextString(m) }
func (*EnrolledService) ProtoMessage()    {}
func (*EnrolledService) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{6}
}

func (m *EnrolledService) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnrolledService.Unmarshal(m, b)
}
func (m *EnrolledService) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnrolledService.Marshal(b, m, deterministic)
}
func (m *EnrolledService) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnrolledService.Merge(m, src)
}
func (m *EnrolledService) XXX_Size() int {
	return xxx_messageInfo_EnrolledService.Size(m)
}
func (m *EnrolledService) XXX_DiscardUnknown() {
	xxx_messageInfo_EnrolledService.DiscardUnknown(m)
}

var xxx_messageInfo_EnrolledService proto.InternalMessageInfo

func (m *EnrolledService) GetCloudProduct() string {
	if m != nil {
		return m.CloudProduct
	}
	return ""
}

func (m *EnrolledService) GetEnrollmentLevel() EnrollmentLevel {
	if m != nil {
		return m.EnrollmentLevel
	}
	return EnrollmentLevel_ENROLLMENT_LEVEL_UNSPECIFIED
}

// Settings on a Project/Folder/Organization related to Access Approval.
type AccessApprovalSettings struct {
	// The resource name of the settings. Format is one of:
	// <ol>
	//   <li>"projects/{project_id}/accessApprovalSettings"</li>
	//   <li>"folders/{folder_id}/accessApprovalSettings"</li>
	//   <li>"organizations/{organization_id}/accessApprovalSettings"</li>
	// <ol>
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of email addresses to which notifications relating to approval
	// requests should be sent. Notifications relating to a resource will be sent
	// to all emails in the settings of ancestor resources of that resource. A
	// maximum of 50 email addresses are allowed.
	NotificationEmails []string `protobuf:"bytes,2,rep,name=notification_emails,json=notificationEmails,proto3" json:"notification_emails,omitempty"`
	// A list of Google Cloud Services for which the given resource has Access
	// Approval enrolled. Access requests for the resource given by name against
	// any of these services contained here will be required to have explicit
	// approval. If name refers to an organization, enrollment can be done for
	// individual services. If name refers to a folder or project, enrollment can
	// only be done on an all or nothing basis.
	//
	// If a cloud_product is repeated in this list, the first entry will be
	// honored and all following entries will be discarded. A maximum of 10
	// enrolled services will be enforced, to be expanded as the set of supported
	// services is expanded.
	EnrolledServices []*EnrolledService `protobuf:"bytes,3,rep,name=enrolled_services,json=enrolledServices,proto3" json:"enrolled_services,omitempty"`
	// Output only. This field is read only (not settable via
	// UpdateAccessAccessApprovalSettings method). If the field is true, that
	// indicates that at least one service is enrolled for Access Approval in one
	// or more ancestors of the Project or Folder (this field will always be
	// unset for the organization since organizations do not have ancestors).
	EnrolledAncestor     bool     `protobuf:"varint,4,opt,name=enrolled_ancestor,json=enrolledAncestor,proto3" json:"enrolled_ancestor,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccessApprovalSettings) Reset()         { *m = AccessApprovalSettings{} }
func (m *AccessApprovalSettings) String() string { return proto.CompactTextString(m) }
func (*AccessApprovalSettings) ProtoMessage()    {}
func (*AccessApprovalSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{7}
}

func (m *AccessApprovalSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccessApprovalSettings.Unmarshal(m, b)
}
func (m *AccessApprovalSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccessApprovalSettings.Marshal(b, m, deterministic)
}
func (m *AccessApprovalSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessApprovalSettings.Merge(m, src)
}
func (m *AccessApprovalSettings) XXX_Size() int {
	return xxx_messageInfo_AccessApprovalSettings.Size(m)
}
func (m *AccessApprovalSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessApprovalSettings.DiscardUnknown(m)
}

var xxx_messageInfo_AccessApprovalSettings proto.InternalMessageInfo

func (m *AccessApprovalSettings) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AccessApprovalSettings) GetNotificationEmails() []string {
	if m != nil {
		return m.NotificationEmails
	}
	return nil
}

func (m *AccessApprovalSettings) GetEnrolledServices() []*EnrolledService {
	if m != nil {
		return m.EnrolledServices
	}
	return nil
}

func (m *AccessApprovalSettings) GetEnrolledAncestor() bool {
	if m != nil {
		return m.EnrolledAncestor
	}
	return false
}

// Request to list approval requests.
type ListApprovalRequestsMessage struct {
	// The parent resource. This may be "projects/{project_id}",
	// "folders/{folder_id}", or "organizations/{organization_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A filter on the type of approval requests to retrieve. Must be one of the
	// following values:
	// <ol>
	//   <li>[not set]: Requests that are pending or have active approvals.</li>
	//   <li>ALL: All requests.</li>
	//   <li>PENDING: Only pending requests.</li>
	//   <li>ACTIVE: Only active (i.e. currently approved) requests.</li>
	//   <li>DISMISSED: Only dismissed (including expired) requests.</li>
	// </ol>
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying the page of results to return.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListApprovalRequestsMessage) Reset()         { *m = ListApprovalRequestsMessage{} }
func (m *ListApprovalRequestsMessage) String() string { return proto.CompactTextString(m) }
func (*ListApprovalRequestsMessage) ProtoMessage()    {}
func (*ListApprovalRequestsMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{8}
}

func (m *ListApprovalRequestsMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListApprovalRequestsMessage.Unmarshal(m, b)
}
func (m *ListApprovalRequestsMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListApprovalRequestsMessage.Marshal(b, m, deterministic)
}
func (m *ListApprovalRequestsMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListApprovalRequestsMessage.Merge(m, src)
}
func (m *ListApprovalRequestsMessage) XXX_Size() int {
	return xxx_messageInfo_ListApprovalRequestsMessage.Size(m)
}
func (m *ListApprovalRequestsMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_ListApprovalRequestsMessage.DiscardUnknown(m)
}

var xxx_messageInfo_ListApprovalRequestsMessage proto.InternalMessageInfo

func (m *ListApprovalRequestsMessage) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListApprovalRequestsMessage) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListApprovalRequestsMessage) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListApprovalRequestsMessage) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response to listing of ApprovalRequest objects.
type ListApprovalRequestsResponse struct {
	// Approval request details.
	ApprovalRequests []*ApprovalRequest `protobuf:"bytes,1,rep,name=approval_requests,json=approvalRequests,proto3" json:"approval_requests,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListApprovalRequestsResponse) Reset()         { *m = ListApprovalRequestsResponse{} }
func (m *ListApprovalRequestsResponse) String() string { return proto.CompactTextString(m) }
func (*ListApprovalRequestsResponse) ProtoMessage()    {}
func (*ListApprovalRequestsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{9}
}

func (m *ListApprovalRequestsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListApprovalRequestsResponse.Unmarshal(m, b)
}
func (m *ListApprovalRequestsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListApprovalRequestsResponse.Marshal(b, m, deterministic)
}
func (m *ListApprovalRequestsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListApprovalRequestsResponse.Merge(m, src)
}
func (m *ListApprovalRequestsResponse) XXX_Size() int {
	return xxx_messageInfo_ListApprovalRequestsResponse.Size(m)
}
func (m *ListApprovalRequestsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListApprovalRequestsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListApprovalRequestsResponse proto.InternalMessageInfo

func (m *ListApprovalRequestsResponse) GetApprovalRequests() []*ApprovalRequest {
	if m != nil {
		return m.ApprovalRequests
	}
	return nil
}

func (m *ListApprovalRequestsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to get an approval request.
type GetApprovalRequestMessage struct {
	// Name of the approval request to retrieve.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetApprovalRequestMessage) Reset()         { *m = GetApprovalRequestMessage{} }
func (m *GetApprovalRequestMessage) String() string { return proto.CompactTextString(m) }
func (*GetApprovalRequestMessage) ProtoMessage()    {}
func (*GetApprovalRequestMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{10}
}

func (m *GetApprovalRequestMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetApprovalRequestMessage.Unmarshal(m, b)
}
func (m *GetApprovalRequestMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetApprovalRequestMessage.Marshal(b, m, deterministic)
}
func (m *GetApprovalRequestMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetApprovalRequestMessage.Merge(m, src)
}
func (m *GetApprovalRequestMessage) XXX_Size() int {
	return xxx_messageInfo_GetApprovalRequestMessage.Size(m)
}
func (m *GetApprovalRequestMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_GetApprovalRequestMessage.DiscardUnknown(m)
}

var xxx_messageInfo_GetApprovalRequestMessage proto.InternalMessageInfo

func (m *GetApprovalRequestMessage) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to approve an ApprovalRequest.
type ApproveApprovalRequestMessage struct {
	// Name of the approval request to approve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The expiration time of this approval.
	ExpireTime           *timestamp.Timestamp `protobuf:"bytes,2,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ApproveApprovalRequestMessage) Reset()         { *m = ApproveApprovalRequestMessage{} }
func (m *ApproveApprovalRequestMessage) String() string { return proto.CompactTextString(m) }
func (*ApproveApprovalRequestMessage) ProtoMessage()    {}
func (*ApproveApprovalRequestMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{11}
}

func (m *ApproveApprovalRequestMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApproveApprovalRequestMessage.Unmarshal(m, b)
}
func (m *ApproveApprovalRequestMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApproveApprovalRequestMessage.Marshal(b, m, deterministic)
}
func (m *ApproveApprovalRequestMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApproveApprovalRequestMessage.Merge(m, src)
}
func (m *ApproveApprovalRequestMessage) XXX_Size() int {
	return xxx_messageInfo_ApproveApprovalRequestMessage.Size(m)
}
func (m *ApproveApprovalRequestMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_ApproveApprovalRequestMessage.DiscardUnknown(m)
}

var xxx_messageInfo_ApproveApprovalRequestMessage proto.InternalMessageInfo

func (m *ApproveApprovalRequestMessage) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ApproveApprovalRequestMessage) GetExpireTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpireTime
	}
	return nil
}

// Request to dismiss an approval request.
type DismissApprovalRequestMessage struct {
	// Name of the ApprovalRequest to dismiss.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DismissApprovalRequestMessage) Reset()         { *m = DismissApprovalRequestMessage{} }
func (m *DismissApprovalRequestMessage) String() string { return proto.CompactTextString(m) }
func (*DismissApprovalRequestMessage) ProtoMessage()    {}
func (*DismissApprovalRequestMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{12}
}

func (m *DismissApprovalRequestMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismissApprovalRequestMessage.Unmarshal(m, b)
}
func (m *DismissApprovalRequestMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismissApprovalRequestMessage.Marshal(b, m, deterministic)
}
func (m *DismissApprovalRequestMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismissApprovalRequestMessage.Merge(m, src)
}
func (m *DismissApprovalRequestMessage) XXX_Size() int {
	return xxx_messageInfo_DismissApprovalRequestMessage.Size(m)
}
func (m *DismissApprovalRequestMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_DismissApprovalRequestMessage.DiscardUnknown(m)
}

var xxx_messageInfo_DismissApprovalRequestMessage proto.InternalMessageInfo

func (m *DismissApprovalRequestMessage) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to get access approval settings.
type GetAccessApprovalSettingsMessage struct {
	// Name of the AccessApprovalSettings to retrieve.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAccessApprovalSettingsMessage) Reset()         { *m = GetAccessApprovalSettingsMessage{} }
func (m *GetAccessApprovalSettingsMessage) String() string { return proto.CompactTextString(m) }
func (*GetAccessApprovalSettingsMessage) ProtoMessage()    {}
func (*GetAccessApprovalSettingsMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{13}
}

func (m *GetAccessApprovalSettingsMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAccessApprovalSettingsMessage.Unmarshal(m, b)
}
func (m *GetAccessApprovalSettingsMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAccessApprovalSettingsMessage.Marshal(b, m, deterministic)
}
func (m *GetAccessApprovalSettingsMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAccessApprovalSettingsMessage.Merge(m, src)
}
func (m *GetAccessApprovalSettingsMessage) XXX_Size() int {
	return xxx_messageInfo_GetAccessApprovalSettingsMessage.Size(m)
}
func (m *GetAccessApprovalSettingsMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAccessApprovalSettingsMessage.DiscardUnknown(m)
}

var xxx_messageInfo_GetAccessApprovalSettingsMessage proto.InternalMessageInfo

func (m *GetAccessApprovalSettingsMessage) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to update access approval settings.
type UpdateAccessApprovalSettingsMessage struct {
	// The new AccessApprovalSettings.
	Settings *AccessApprovalSettings `protobuf:"bytes,1,opt,name=settings,proto3" json:"settings,omitempty"`
	// The update mask applies to the settings. Only the top level fields of
	// AccessApprovalSettings (notification_emails & enrolled_services) are
	// supported. For each field, if it is included, the currently stored value
	// will be entirely overwritten with the value of the field passed in this
	// request.
	//
	// For the `FieldMask` definition, see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	// If this field is left unset, only the notification_emails field will be
	// updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateAccessApprovalSettingsMessage) Reset()         { *m = UpdateAccessApprovalSettingsMessage{} }
func (m *UpdateAccessApprovalSettingsMessage) String() string { return proto.CompactTextString(m) }
func (*UpdateAccessApprovalSettingsMessage) ProtoMessage()    {}
func (*UpdateAccessApprovalSettingsMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{14}
}

func (m *UpdateAccessApprovalSettingsMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateAccessApprovalSettingsMessage.Unmarshal(m, b)
}
func (m *UpdateAccessApprovalSettingsMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateAccessApprovalSettingsMessage.Marshal(b, m, deterministic)
}
func (m *UpdateAccessApprovalSettingsMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateAccessApprovalSettingsMessage.Merge(m, src)
}
func (m *UpdateAccessApprovalSettingsMessage) XXX_Size() int {
	return xxx_messageInfo_UpdateAccessApprovalSettingsMessage.Size(m)
}
func (m *UpdateAccessApprovalSettingsMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateAccessApprovalSettingsMessage.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateAccessApprovalSettingsMessage proto.InternalMessageInfo

func (m *UpdateAccessApprovalSettingsMessage) GetSettings() *AccessApprovalSettings {
	if m != nil {
		return m.Settings
	}
	return nil
}

func (m *UpdateAccessApprovalSettingsMessage) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request to delete access approval settings.
type DeleteAccessApprovalSettingsMessage struct {
	// Name of the AccessApprovalSettings to delete.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAccessApprovalSettingsMessage) Reset()         { *m = DeleteAccessApprovalSettingsMessage{} }
func (m *DeleteAccessApprovalSettingsMessage) String() string { return proto.CompactTextString(m) }
func (*DeleteAccessApprovalSettingsMessage) ProtoMessage()    {}
func (*DeleteAccessApprovalSettingsMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_b766c7add582ab6f, []int{15}
}

func (m *DeleteAccessApprovalSettingsMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAccessApprovalSettingsMessage.Unmarshal(m, b)
}
func (m *DeleteAccessApprovalSettingsMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAccessApprovalSettingsMessage.Marshal(b, m, deterministic)
}
func (m *DeleteAccessApprovalSettingsMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAccessApprovalSettingsMessage.Merge(m, src)
}
func (m *DeleteAccessApprovalSettingsMessage) XXX_Size() int {
	return xxx_messageInfo_DeleteAccessApprovalSettingsMessage.Size(m)
}
func (m *DeleteAccessApprovalSettingsMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAccessApprovalSettingsMessage.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAccessApprovalSettingsMessage proto.InternalMessageInfo

func (m *DeleteAccessApprovalSettingsMessage) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.accessapproval.v1.EnrollmentLevel", EnrollmentLevel_name, EnrollmentLevel_value)
	proto.RegisterEnum("google.cloud.accessapproval.v1.AccessReason_Type", AccessReason_Type_name, AccessReason_Type_value)
	proto.RegisterType((*AccessLocations)(nil), "google.cloud.accessapproval.v1.AccessLocations")
	proto.RegisterType((*AccessReason)(nil), "google.cloud.accessapproval.v1.AccessReason")
	proto.RegisterType((*ApproveDecision)(nil), "google.cloud.accessapproval.v1.ApproveDecision")
	proto.RegisterType((*DismissDecision)(nil), "google.cloud.accessapproval.v1.DismissDecision")
	proto.RegisterType((*ResourceProperties)(nil), "google.cloud.accessapproval.v1.ResourceProperties")
	proto.RegisterType((*ApprovalRequest)(nil), "google.cloud.accessapproval.v1.ApprovalRequest")
	proto.RegisterType((*EnrolledService)(nil), "google.cloud.accessapproval.v1.EnrolledService")
	proto.RegisterType((*AccessApprovalSettings)(nil), "google.cloud.accessapproval.v1.AccessApprovalSettings")
	proto.RegisterType((*ListApprovalRequestsMessage)(nil), "google.cloud.accessapproval.v1.ListApprovalRequestsMessage")
	proto.RegisterType((*ListApprovalRequestsResponse)(nil), "google.cloud.accessapproval.v1.ListApprovalRequestsResponse")
	proto.RegisterType((*GetApprovalRequestMessage)(nil), "google.cloud.accessapproval.v1.GetApprovalRequestMessage")
	proto.RegisterType((*ApproveApprovalRequestMessage)(nil), "google.cloud.accessapproval.v1.ApproveApprovalRequestMessage")
	proto.RegisterType((*DismissApprovalRequestMessage)(nil), "google.cloud.accessapproval.v1.DismissApprovalRequestMessage")
	proto.RegisterType((*GetAccessApprovalSettingsMessage)(nil), "google.cloud.accessapproval.v1.GetAccessApprovalSettingsMessage")
	proto.RegisterType((*UpdateAccessApprovalSettingsMessage)(nil), "google.cloud.accessapproval.v1.UpdateAccessApprovalSettingsMessage")
	proto.RegisterType((*DeleteAccessApprovalSettingsMessage)(nil), "google.cloud.accessapproval.v1.DeleteAccessApprovalSettingsMessage")
}

func init() {
	proto.RegisterFile("google/cloud/accessapproval/v1/accessapproval.proto", fileDescriptor_b766c7add582ab6f)
}

var fileDescriptor_b766c7add582ab6f = []byte{
	// 1590 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xc1, 0x6f, 0xdc, 0x44,
	0x17, 0xaf, 0x77, 0xd3, 0x36, 0x79, 0x4d, 0x9b, 0xfd, 0x26, 0xf9, 0xd2, 0xfd, 0x36, 0x49, 0xbf,
	0xc8, 0x91, 0xa0, 0x84, 0x76, 0xdd, 0x24, 0xa5, 0xa2, 0x29, 0x91, 0xba, 0x49, 0xdc, 0x10, 0x75,
	0x93, 0x2c, 0xce, 0xa6, 0x15, 0x11, 0x92, 0x71, 0xbd, 0xb3, 0x1b, 0x53, 0xaf, 0x6d, 0x3c, 0xb3,
	0x49, 0x53, 0xd4, 0x0b, 0x07, 0xa0, 0x07, 0x2e, 0x05, 0x81, 0xc4, 0x01, 0x71, 0x40, 0x42, 0xe2,
	0xc0, 0x11, 0xc1, 0x9d, 0x13, 0xdc, 0xe0, 0xd6, 0x13, 0x07, 0x84, 0xc4, 0x81, 0xff, 0x01, 0x79,
	0x3c, 0xf6, 0x7a, 0x1d, 0x67, 0xd7, 0x5b, 0x10, 0xb7, 0xf8, 0xbd, 0xf7, 0xfb, 0xcd, 0x7b, 0xbf,
	0x79, 0x6f, 0x66, 0xb2, 0xb0, 0xd0, 0xb0, 0xed, 0x86, 0x89, 0x25, 0xdd, 0xb4, 0x5b, 0x35, 0x49,
	0xd3, 0x75, 0x4c, 0x88, 0xe6, 0x38, 0xae, 0xbd, 0xaf, 0x99, 0xd2, 0xfe, 0x5c, 0xcc, 0x52, 0x74,
	0x5c, 0x9b, 0xda, 0xe8, 0x82, 0x0f, 0x2a, 0x32, 0x50, 0x31, 0x16, 0xb2, 0x3f, 0x57, 0x98, 0xe4,
	0xa4, 0x9a, 0x63, 0x48, 0x9a, 0x65, 0xd9, 0x54, 0xa3, 0x86, 0x6d, 0x11, 0x1f, 0x5d, 0x38, 0x1f,
	0xf1, 0xea, 0xa6, 0x81, 0x2d, 0xca, 0x1d, 0xff, 0x8f, 0x38, 0xea, 0x06, 0x36, 0x6b, 0xea, 0x3d,
	0xbc, 0xa7, 0xed, 0x1b, 0xb6, 0xcb, 0x03, 0x26, 0x78, 0x00, 0xfb, 0xba, 0xd7, 0xaa, 0x4b, 0xb8,
	0xe9, 0xd0, 0x43, 0xee, 0x9c, 0x8e, 0x3b, 0x7d, 0x8a, 0xa6, 0x46, 0xee, 0xc7, 0xf8, 0xc3, 0x08,
	0x6a, 0x34, 0x31, 0xa1, 0x5a, 0xd3, 0xf1, 0x03, 0xc4, 0xcf, 0x04, 0x18, 0x29, 0xb1, 0x6a, 0xca,
	0xb6, 0xee, 0xe7, 0x8c, 0x5e, 0x86, 0xbc, 0xe3, 0x1a, 0x96, 0x6e, 0x38, 0x9a, 0xa9, 0xda, 0xf5,
	0xba, 0xa1, 0x63, 0x55, 0xb7, 0x5b, 0x16, 0x75, 0x0f, 0xf3, 0xc2, 0xb4, 0x70, 0x71, 0x48, 0x19,
	0x0f, 0xfd, 0x5b, 0xcc, 0xbd, 0xe2, 0x7b, 0xd1, 0x06, 0xcc, 0xb4, 0x91, 0xce, 0xde, 0x21, 0x31,
	0x74, 0xcd, 0x54, 0x4d, 0xce, 0x1c, 0x92, 0x64, 0x18, 0xc9, 0x74, 0x18, 0x5a, 0xe1, 0x91, 0x41,
	0x0a, 0x9c, 0x4e, 0xfc, 0x5d, 0x80, 0x61, 0x3f, 0x39, 0x05, 0x6b, 0xc4, 0xb6, 0x90, 0x0c, 0x03,
	0xf4, 0xd0, 0xc1, 0x2c, 0x8b, 0x73, 0xf3, 0x73, 0xc5, 0xee, 0x9b, 0x52, 0x8c, 0x62, 0x8b, 0xd5,
	0x43, 0x07, 0x2b, 0x0c, 0x8e, 0xc6, 0xe1, 0x54, 0x0d, 0x53, 0xcd, 0x30, 0x79, 0x26, 0xfc, 0x4b,
	0x3c, 0x80, 0x01, 0x2f, 0x0a, 0x8d, 0x41, 0xae, 0xfa, 0x7a, 0x45, 0x56, 0x77, 0x36, 0xb7, 0x2b,
	0xf2, 0xca, 0xfa, 0xad, 0x75, 0x79, 0x35, 0x77, 0x02, 0x5d, 0x80, 0xc2, 0xca, 0xce, 0x76, 0x75,
	0x6b, 0x43, 0x56, 0xd4, 0xf5, 0xcd, 0xf5, 0xea, 0x7a, 0xa9, 0x2a, 0xaf, 0xaa, 0xdb, 0x3b, 0x95,
	0xca, 0x96, 0x52, 0xcd, 0x09, 0x68, 0x12, 0xf2, 0x6b, 0x5b, 0x5b, 0x6b, 0x65, 0x39, 0xea, 0x95,
	0x95, 0x3b, 0xeb, 0x2b, 0x72, 0x2e, 0x83, 0x26, 0xe0, 0xfc, 0x11, 0xaf, 0x22, 0xdf, 0x59, 0x97,
	0xef, 0xe6, 0xb2, 0xe2, 0x87, 0xde, 0x2e, 0xb0, 0xc4, 0xf1, 0x2a, 0xd6, 0x0d, 0x62, 0xd8, 0x16,
	0x5a, 0x82, 0x61, 0xbf, 0x16, 0xac, 0x7a, 0x9b, 0xc6, 0x6a, 0x3e, 0x33, 0x5f, 0x08, 0x6a, 0x0e,
	0x76, 0xb4, 0x58, 0x0d, 0x76, 0x54, 0x39, 0xc3, 0xe3, 0x3d, 0x0b, 0xba, 0x01, 0x67, 0xf0, 0x03,
	0xc7, 0x70, 0x39, 0x3a, 0xd3, 0x13, 0x0d, 0x7e, 0xb8, 0x67, 0x10, 0x2b, 0x30, 0xb2, 0x6a, 0x90,
	0xa6, 0x41, 0x48, 0x34, 0x9d, 0x9a, 0x6f, 0x4a, 0x9d, 0x0e, 0x8f, 0x67, 0x8c, 0x6b, 0x80, 0x14,
	0x4c, 0xec, 0x96, 0xab, 0xe3, 0x8a, 0x6b, 0x3b, 0xd8, 0xa5, 0x06, 0x26, 0x68, 0x0e, 0xc6, 0xf0,
	0x03, 0xdd, 0x6c, 0xd5, 0x30, 0x51, 0x6b, 0x98, 0xe8, 0xd8, 0xaa, 0x69, 0x16, 0x25, 0x8c, 0x7c,
	0x50, 0x19, 0x0d, 0x7c, 0xab, 0x6d, 0x97, 0xf8, 0xc3, 0xc9, 0x40, 0x2a, 0xcd, 0x54, 0xf0, 0xdb,
	0x2d, 0x4c, 0x28, 0x42, 0x30, 0x60, 0x69, 0x3c, 0xa7, 0x21, 0x85, 0xfd, 0x8d, 0xae, 0xc1, 0x79,
	0xd7, 0x77, 0xe3, 0x9a, 0xea, 0xf2, 0xa5, 0x55, 0x16, 0xe6, 0x6f, 0xfa, 0x7f, 0x43, 0x77, 0x90,
	0xd8, 0xa6, 0x87, 0xdb, 0x87, 0xa9, 0x04, 0x9c, 0x13, 0xe6, 0x9c, 0x1f, 0x62, 0x85, 0xcf, 0xf7,
	0xea, 0xbd, 0xa3, 0xd5, 0x2a, 0x13, 0x47, 0x56, 0x8c, 0x48, 0x71, 0x17, 0x72, 0xd1, 0x75, 0xbd,
	0x96, 0xcd, 0x67, 0xd9, 0x52, 0x97, 0xfa, 0x69, 0x73, 0x65, 0x24, 0xb2, 0x08, 0x9b, 0x99, 0x37,
	0x61, 0xb4, 0x4d, 0x1c, 0x8c, 0x22, 0xc9, 0x0f, 0x30, 0x6e, 0x29, 0x1d, 0x77, 0x78, 0x36, 0x28,
	0x28, 0xe4, 0x6a, 0x9f, 0x17, 0x4b, 0x30, 0xcc, 0xad, 0x7e, 0x6b, 0x9c, 0xec, 0xdd, 0x1a, 0x3c,
	0x9e, 0x75, 0xea, 0x06, 0x8c, 0xb5, 0x13, 0x64, 0x4d, 0xc8, 0x78, 0xf3, 0xa7, 0x7a, 0xd2, 0xb4,
	0x0b, 0x93, 0x43, 0x18, 0xba, 0x0d, 0xa7, 0xf9, 0x1c, 0xe4, 0x4f, 0xa7, 0xac, 0xb1, 0x73, 0xf2,
	0x5e, 0x3d, 0xa1, 0x04, 0x0c, 0x1e, 0x19, 0xef, 0xe2, 0xfc, 0x60, 0x3a, 0xb2, 0xd8, 0xdc, 0x78,
	0x64, 0x9c, 0x61, 0x19, 0x60, 0xb0, 0xc6, 0xcd, 0xe2, 0x13, 0x01, 0x46, 0x64, 0xcb, 0xb5, 0x4d,
	0x13, 0xd7, 0xb6, 0xb1, 0xbb, 0x6f, 0xe8, 0x18, 0xcd, 0xc0, 0x59, 0xc6, 0xea, 0x75, 0x5b, 0xad,
	0xa5, 0x53, 0xde, 0xcf, 0xc3, 0xcc, 0x58, 0xf1, 0x6d, 0x68, 0x17, 0x72, 0x98, 0xe1, 0x9a, 0xd8,
	0xa2, 0xaa, 0x89, 0xf7, 0xb1, 0x7f, 0x8a, 0x9d, 0xeb, 0x9d, 0x9a, 0x1c, 0xe2, 0xca, 0x1e, 0x4c,
	0x19, 0xc1, 0x9d, 0x06, 0xf1, 0x4f, 0x01, 0xc6, 0xfd, 0x0d, 0x0f, 0x26, 0x6c, 0x1b, 0x53, 0x6a,
	0x58, 0x0d, 0x92, 0x38, 0x62, 0x12, 0x8c, 0x5a, 0x36, 0x35, 0xea, 0x06, 0x3f, 0xde, 0x71, 0x53,
	0x33, 0x4c, 0x92, 0xcf, 0x4c, 0x67, 0x2f, 0x0e, 0x29, 0x28, 0xea, 0x92, 0x99, 0x07, 0xbd, 0x01,
	0xff, 0xc1, 0xbc, 0x66, 0x95, 0xf8, 0x45, 0x93, 0x7c, 0x76, 0x3a, 0x9b, 0x46, 0xd7, 0x98, 0x58,
	0x4a, 0x0e, 0x77, 0x1a, 0x08, 0xba, 0x12, 0x61, 0xd7, 0x2c, 0x1d, 0x13, 0x6a, 0xbb, 0xac, 0xcd,
	0x07, 0x97, 0xb3, 0xbf, 0x96, 0xb2, 0x6d, 0x44, 0x89, 0x3b, 0xc5, 0xc7, 0x02, 0x4c, 0x94, 0x0d,
	0x42, 0x63, 0xe7, 0x09, 0xd9, 0xf0, 0xd6, 0x6e, 0xb0, 0x7b, 0xc2, 0xd1, 0x5c, 0x6c, 0x05, 0x3b,
	0xc1, 0xbf, 0x3c, 0x7b, 0xdd, 0x30, 0x29, 0x76, 0x83, 0xfb, 0xc3, 0xff, 0x42, 0x13, 0x30, 0xe4,
	0x68, 0x0d, 0xac, 0x12, 0xe3, 0x21, 0x66, 0xc3, 0x7b, 0x52, 0x19, 0xf4, 0x0c, 0xdb, 0xc6, 0x43,
	0x8c, 0xa6, 0x00, 0x98, 0x93, 0xda, 0xf7, 0xb1, 0xc5, 0xf2, 0x1a, 0x52, 0x58, 0x78, 0xd5, 0x33,
	0x88, 0x5f, 0x0a, 0x30, 0x99, 0x94, 0x8b, 0x82, 0x89, 0x63, 0x5b, 0x04, 0x7b, 0xe2, 0x05, 0x7a,
	0xa8, 0xbc, 0xef, 0xbd, 0x83, 0x32, 0x9b, 0xbe, 0xc3, 0x43, 0x52, 0x25, 0xa7, 0xc5, 0x56, 0x41,
	0xcf, 0xc1, 0x88, 0x85, 0x1f, 0x50, 0x35, 0x92, 0xa2, 0x5f, 0xdb, 0x59, 0xcf, 0x5c, 0x09, 0xd3,
	0x94, 0xe0, 0x7f, 0x6b, 0x38, 0x9e, 0x64, 0xa0, 0x57, 0x42, 0x93, 0x88, 0x0e, 0x4c, 0xf1, 0xf9,
	0x4a, 0x0f, 0xfa, 0x7b, 0x97, 0xd7, 0x02, 0x4c, 0xf1, 0x21, 0xec, 0x23, 0xcd, 0x6b, 0x30, 0xed,
	0xd5, 0x95, 0xd8, 0xfc, 0xdd, 0x70, 0xdf, 0x0a, 0x30, 0xb3, 0xe3, 0xd4, 0x34, 0x8a, 0xbb, 0x63,
	0x15, 0x18, 0x24, 0xdc, 0xc4, 0xaf, 0xce, 0x6b, 0xe9, 0x8e, 0xde, 0x38, 0xa1, 0x12, 0xf2, 0x78,
	0x2a, 0xb5, 0xd8, 0xd2, 0xec, 0xc5, 0x77, 0xac, 0x4a, 0xb7, 0xbc, 0x47, 0xe1, 0x86, 0x46, 0xee,
	0x2b, 0xe0, 0x87, 0x7b, 0x7f, 0x8b, 0xd7, 0x61, 0x66, 0x15, 0x9b, 0xb8, 0x57, 0xde, 0x09, 0x35,
	0xcf, 0x2e, 0x07, 0x47, 0x57, 0x78, 0x72, 0xa0, 0x69, 0x98, 0x94, 0x37, 0x95, 0xad, 0x72, 0x79,
	0x43, 0xde, 0xac, 0xaa, 0x65, 0xf9, 0x8e, 0x5c, 0x8e, 0xbd, 0x9e, 0xce, 0xc2, 0xd0, 0x72, 0x79,
	0x6b, 0xe5, 0xb6, 0x5a, 0x2a, 0x97, 0x73, 0xc2, 0xfc, 0x07, 0x08, 0xce, 0x75, 0xae, 0x8c, 0xbe,
	0xce, 0xc0, 0x58, 0xd2, 0x04, 0xa0, 0x1b, 0xbd, 0x94, 0xea, 0x32, 0xc3, 0x85, 0x57, 0x9e, 0x05,
	0x1c, 0x0c, 0x9d, 0xf8, 0x89, 0xf0, 0xb4, 0xc4, 0xa7, 0xfe, 0xdd, 0x5f, 0x7e, 0xfb, 0x28, 0xf3,
	0x9e, 0x80, 0x2e, 0x7a, 0xff, 0x23, 0xbc, 0xe3, 0xdb, 0x96, 0x1c, 0xd7, 0x7e, 0x0b, 0xeb, 0x94,
	0x48, 0xb3, 0x8f, 0xa4, 0xf8, 0x4c, 0xed, 0xbe, 0x80, 0x9e, 0x8f, 0xc6, 0xd6, 0x6d, 0xb3, 0x86,
	0xdd, 0xe4, 0x50, 0x09, 0x5d, 0x8e, 0x86, 0xda, 0x6e, 0x43, 0xb3, 0x8c, 0x87, 0xfe, 0xfd, 0x9a,
	0x04, 0x40, 0x9f, 0x66, 0x00, 0x1d, 0x1d, 0x44, 0x74, 0xbd, 0x57, 0xb5, 0xc7, 0x0e, 0x6f, 0xa1,
	0xdf, 0x43, 0x44, 0xfc, 0x58, 0x78, 0x5a, 0x62, 0x0d, 0xd1, 0xa9, 0x8c, 0x67, 0x89, 0xe8, 0x72,
	0x24, 0x75, 0x69, 0xf6, 0x51, 0xa8, 0x0c, 0x8b, 0x0d, 0x75, 0x49, 0x0c, 0x0d, 0x94, 0x61, 0xa1,
	0x31, 0x5d, 0x92, 0x00, 0xe8, 0xfb, 0x0c, 0x8c, 0x27, 0x9f, 0x38, 0x68, 0x29, 0xe5, 0x4b, 0xe0,
	0x9f, 0x52, 0xe8, 0x1b, 0x81, 0x49, 0xf3, 0x95, 0x20, 0x5e, 0x49, 0x2b, 0xcd, 0x22, 0x7f, 0x79,
	0x2c, 0x0a, 0xb3, 0xbb, 0x57, 0x45, 0x29, 0xa5, 0x4a, 0x51, 0xd4, 0xa2, 0xf8, 0x52, 0x5f, 0x82,
	0x45, 0xb0, 0x4c, 0xbb, 0xe4, 0xb3, 0xb3, 0xb7, 0x76, 0x5d, 0xcf, 0xdc, 0x7f, 0x47, 0x3b, 0xfe,
	0xd0, 0xea, 0x53, 0xbb, 0x08, 0xaa, 0x6f, 0xed, 0xda, 0x58, 0xf4, 0x5d, 0xc6, 0xbf, 0x1a, 0x93,
	0xdf, 0x4f, 0x37, 0xd3, 0x0c, 0x66, 0xb7, 0x93, 0xb8, 0xf0, 0x8c, 0xf7, 0x85, 0xf8, 0x45, 0xc7,
	0x98, 0x3e, 0x11, 0xd0, 0xa5, 0x64, 0x3d, 0x13, 0xd1, 0x8f, 0x76, 0x2f, 0xa3, 0x17, 0x13, 0x85,
	0x3c, 0x26, 0x7c, 0x01, 0xcd, 0x75, 0x51, 0x30, 0x19, 0x84, 0xde, 0xcf, 0xc2, 0x64, 0xb7, 0x4b,
	0x14, 0xad, 0xf4, 0xaa, 0x3d, 0xc5, 0x15, 0xfc, 0xcc, 0x02, 0xfe, 0x21, 0x3c, 0x2d, 0x8d, 0x05,
	0x97, 0xee, 0xa5, 0xc8, 0x8d, 0xcb, 0x04, 0xfd, 0x49, 0x98, 0xf7, 0x7b, 0x26, 0x88, 0x28, 0xa6,
	0x54, 0x76, 0x31, 0xbc, 0xc8, 0x77, 0x6f, 0xce, 0x5f, 0x4d, 0xa0, 0xe8, 0x29, 0x76, 0x84, 0xe1,
	0xd6, 0xfc, 0x62, 0x02, 0x43, 0x4a, 0xfd, 0xdb, 0x3c, 0xe8, 0xf3, 0x0c, 0x4c, 0x76, 0x7b, 0x16,
	0xf4, 0xde, 0x89, 0x14, 0x8f, 0x8a, 0xc2, 0xf8, 0x91, 0x37, 0x8a, 0xdc, 0x74, 0xe8, 0xe1, 0x91,
	0x56, 0x9d, 0xed, 0xb3, 0x55, 0x67, 0xfb, 0x6b, 0xd5, 0xd9, 0xfe, 0x5b, 0xb5, 0xf0, 0xda, 0x8f,
	0xa5, 0xa9, 0x58, 0xd1, 0x7e, 0x2d, 0x9a, 0x63, 0x90, 0xa2, 0x6e, 0x37, 0x7f, 0x2e, 0x15, 0xf7,
	0x28, 0x75, 0xc8, 0xa2, 0x24, 0x1d, 0x1c, 0x1c, 0xc4, 0x9c, 0x92, 0xd6, 0xa2, 0x7b, 0xfe, 0x0f,
	0x8f, 0x97, 0x1d, 0x53, 0xa3, 0x75, 0xdb, 0x6d, 0x2e, 0x3f, 0x16, 0x40, 0xd4, 0xed, 0x66, 0x0f,
	0x61, 0x97, 0x47, 0x3b, 0x35, 0xad, 0x78, 0xd2, 0x55, 0x84, 0xdd, 0x32, 0x87, 0x35, 0x6c, 0x53,
	0xb3, 0x1a, 0x45, 0xdb, 0x6d, 0x48, 0x0d, 0x6c, 0x31, 0x61, 0xa5, 0xf6, 0xe2, 0xc7, 0xfd, 0xd8,
	0x79, 0xa3, 0xd3, 0x72, 0xef, 0x14, 0x03, 0x2e, 0xfc, 0x15, 0x00, 0x00, 0xff, 0xff, 0x06, 0xb1,
	0x99, 0x4a, 0x24, 0x15, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AccessApprovalClient is the client API for AccessApproval service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AccessApprovalClient interface {
	// Lists approval requests associated with a project, folder, or organization.
	// Approval requests can be filtered by state (pending, active, dismissed).
	// The order is reverse chronological.
	ListApprovalRequests(ctx context.Context, in *ListApprovalRequestsMessage, opts ...grpc.CallOption) (*ListApprovalRequestsResponse, error)
	// Gets an approval request. Returns NOT_FOUND if the request does not exist.
	GetApprovalRequest(ctx context.Context, in *GetApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error)
	// Approves a request and returns the updated ApprovalRequest.
	//
	// Returns NOT_FOUND if the request does not exist. Returns
	// FAILED_PRECONDITION if the request exists but is not in a pending state.
	ApproveApprovalRequest(ctx context.Context, in *ApproveApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error)
	// Dismisses a request. Returns the updated ApprovalRequest.
	//
	// NOTE: This does not deny access to the resource if another request has been
	// made and approved. It is equivalent in effect to ignoring the request
	// altogether.
	//
	// Returns NOT_FOUND if the request does not exist.
	//
	// Returns FAILED_PRECONDITION if the request exists but is not in a pending
	// state.
	DismissApprovalRequest(ctx context.Context, in *DismissApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error)
	// Gets the settings associated with a project, folder, or organization.
	GetAccessApprovalSettings(ctx context.Context, in *GetAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*AccessApprovalSettings, error)
	// Updates the settings associated with a project, folder, or organization.
	// Settings to update are determined by the value of field_mask.
	UpdateAccessApprovalSettings(ctx context.Context, in *UpdateAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*AccessApprovalSettings, error)
	// Deletes the settings associated with a project, folder, or organization.
	// This will have the effect of disabling Access Approval for the project,
	// folder, or organization, but only if all ancestors also have Access
	// Approval disabled. If Access Approval is enabled at a higher level of the
	// hierarchy, then Access Approval will still be enabled at this level as
	// the settings are inherited.
	DeleteAccessApprovalSettings(ctx context.Context, in *DeleteAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*empty.Empty, error)
}

type accessApprovalClient struct {
	cc grpc.ClientConnInterface
}

func NewAccessApprovalClient(cc grpc.ClientConnInterface) AccessApprovalClient {
	return &accessApprovalClient{cc}
}

func (c *accessApprovalClient) ListApprovalRequests(ctx context.Context, in *ListApprovalRequestsMessage, opts ...grpc.CallOption) (*ListApprovalRequestsResponse, error) {
	out := new(ListApprovalRequestsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.accessapproval.v1.AccessApproval/ListApprovalRequests", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) GetApprovalRequest(ctx context.Context, in *GetApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error) {
	out := new(ApprovalRequest)
	err := c.cc.Invoke(ctx, "/google.cloud.accessapproval.v1.AccessApproval/GetApprovalRequest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) ApproveApprovalRequest(ctx context.Context, in *ApproveApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error) {
	out := new(ApprovalRequest)
	err := c.cc.Invoke(ctx, "/google.cloud.accessapproval.v1.AccessApproval/ApproveApprovalRequest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) DismissApprovalRequest(ctx context.Context, in *DismissApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error) {
	out := new(ApprovalRequest)
	err := c.cc.Invoke(ctx, "/google.cloud.accessapproval.v1.AccessApproval/DismissApprovalRequest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) GetAccessApprovalSettings(ctx context.Context, in *GetAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*AccessApprovalSettings, error) {
	out := new(AccessApprovalSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.accessapproval.v1.AccessApproval/GetAccessApprovalSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) UpdateAccessApprovalSettings(ctx context.Context, in *UpdateAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*AccessApprovalSettings, error) {
	out := new(AccessApprovalSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.accessapproval.v1.AccessApproval/UpdateAccessApprovalSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) DeleteAccessApprovalSettings(ctx context.Context, in *DeleteAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.accessapproval.v1.AccessApproval/DeleteAccessApprovalSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AccessApprovalServer is the server API for AccessApproval service.
type AccessApprovalServer interface {
	// Lists approval requests associated with a project, folder, or organization.
	// Approval requests can be filtered by state (pending, active, dismissed).
	// The order is reverse chronological.
	ListApprovalRequests(context.Context, *ListApprovalRequestsMessage) (*ListApprovalRequestsResponse, error)
	// Gets an approval request. Returns NOT_FOUND if the request does not exist.
	GetApprovalRequest(context.Context, *GetApprovalRequestMessage) (*ApprovalRequest, error)
	// Approves a request and returns the updated ApprovalRequest.
	//
	// Returns NOT_FOUND if the request does not exist. Returns
	// FAILED_PRECONDITION if the request exists but is not in a pending state.
	ApproveApprovalRequest(context.Context, *ApproveApprovalRequestMessage) (*ApprovalRequest, error)
	// Dismisses a request. Returns the updated ApprovalRequest.
	//
	// NOTE: This does not deny access to the resource if another request has been
	// made and approved. It is equivalent in effect to ignoring the request
	// altogether.
	//
	// Returns NOT_FOUND if the request does not exist.
	//
	// Returns FAILED_PRECONDITION if the request exists but is not in a pending
	// state.
	DismissApprovalRequest(context.Context, *DismissApprovalRequestMessage) (*ApprovalRequest, error)
	// Gets the settings associated with a project, folder, or organization.
	GetAccessApprovalSettings(context.Context, *GetAccessApprovalSettingsMessage) (*AccessApprovalSettings, error)
	// Updates the settings associated with a project, folder, or organization.
	// Settings to update are determined by the value of field_mask.
	UpdateAccessApprovalSettings(context.Context, *UpdateAccessApprovalSettingsMessage) (*AccessApprovalSettings, error)
	// Deletes the settings associated with a project, folder, or organization.
	// This will have the effect of disabling Access Approval for the project,
	// folder, or organization, but only if all ancestors also have Access
	// Approval disabled. If Access Approval is enabled at a higher level of the
	// hierarchy, then Access Approval will still be enabled at this level as
	// the settings are inherited.
	DeleteAccessApprovalSettings(context.Context, *DeleteAccessApprovalSettingsMessage) (*empty.Empty, error)
}

// UnimplementedAccessApprovalServer can be embedded to have forward compatible implementations.
type UnimplementedAccessApprovalServer struct {
}

func (*UnimplementedAccessApprovalServer) ListApprovalRequests(ctx context.Context, req *ListApprovalRequestsMessage) (*ListApprovalRequestsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListApprovalRequests not implemented")
}
func (*UnimplementedAccessApprovalServer) GetApprovalRequest(ctx context.Context, req *GetApprovalRequestMessage) (*ApprovalRequest, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApprovalRequest not implemented")
}
func (*UnimplementedAccessApprovalServer) ApproveApprovalRequest(ctx context.Context, req *ApproveApprovalRequestMessage) (*ApprovalRequest, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApproveApprovalRequest not implemented")
}
func (*UnimplementedAccessApprovalServer) DismissApprovalRequest(ctx context.Context, req *DismissApprovalRequestMessage) (*ApprovalRequest, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DismissApprovalRequest not implemented")
}
func (*UnimplementedAccessApprovalServer) GetAccessApprovalSettings(ctx context.Context, req *GetAccessApprovalSettingsMessage) (*AccessApprovalSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccessApprovalSettings not implemented")
}
func (*UnimplementedAccessApprovalServer) UpdateAccessApprovalSettings(ctx context.Context, req *UpdateAccessApprovalSettingsMessage) (*AccessApprovalSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccessApprovalSettings not implemented")
}
func (*UnimplementedAccessApprovalServer) DeleteAccessApprovalSettings(ctx context.Context, req *DeleteAccessApprovalSettingsMessage) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAccessApprovalSettings not implemented")
}

func RegisterAccessApprovalServer(s *grpc.Server, srv AccessApprovalServer) {
	s.RegisterService(&_AccessApproval_serviceDesc, srv)
}

func _AccessApproval_ListApprovalRequests_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApprovalRequestsMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).ListApprovalRequests(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.accessapproval.v1.AccessApproval/ListApprovalRequests",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).ListApprovalRequests(ctx, req.(*ListApprovalRequestsMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_GetApprovalRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApprovalRequestMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).GetApprovalRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.accessapproval.v1.AccessApproval/GetApprovalRequest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).GetApprovalRequest(ctx, req.(*GetApprovalRequestMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_ApproveApprovalRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApproveApprovalRequestMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).ApproveApprovalRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.accessapproval.v1.AccessApproval/ApproveApprovalRequest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).ApproveApprovalRequest(ctx, req.(*ApproveApprovalRequestMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_DismissApprovalRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DismissApprovalRequestMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).DismissApprovalRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.accessapproval.v1.AccessApproval/DismissApprovalRequest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).DismissApprovalRequest(ctx, req.(*DismissApprovalRequestMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_GetAccessApprovalSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccessApprovalSettingsMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).GetAccessApprovalSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.accessapproval.v1.AccessApproval/GetAccessApprovalSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).GetAccessApprovalSettings(ctx, req.(*GetAccessApprovalSettingsMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_UpdateAccessApprovalSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccessApprovalSettingsMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).UpdateAccessApprovalSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.accessapproval.v1.AccessApproval/UpdateAccessApprovalSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).UpdateAccessApprovalSettings(ctx, req.(*UpdateAccessApprovalSettingsMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_DeleteAccessApprovalSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAccessApprovalSettingsMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).DeleteAccessApprovalSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.accessapproval.v1.AccessApproval/DeleteAccessApprovalSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).DeleteAccessApprovalSettings(ctx, req.(*DeleteAccessApprovalSettingsMessage))
	}
	return interceptor(ctx, in, info, handler)
}

var _AccessApproval_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.accessapproval.v1.AccessApproval",
	HandlerType: (*AccessApprovalServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListApprovalRequests",
			Handler:    _AccessApproval_ListApprovalRequests_Handler,
		},
		{
			MethodName: "GetApprovalRequest",
			Handler:    _AccessApproval_GetApprovalRequest_Handler,
		},
		{
			MethodName: "ApproveApprovalRequest",
			Handler:    _AccessApproval_ApproveApprovalRequest_Handler,
		},
		{
			MethodName: "DismissApprovalRequest",
			Handler:    _AccessApproval_DismissApprovalRequest_Handler,
		},
		{
			MethodName: "GetAccessApprovalSettings",
			Handler:    _AccessApproval_GetAccessApprovalSettings_Handler,
		},
		{
			MethodName: "UpdateAccessApprovalSettings",
			Handler:    _AccessApproval_UpdateAccessApprovalSettings_Handler,
		},
		{
			MethodName: "DeleteAccessApprovalSettings",
			Handler:    _AccessApproval_DeleteAccessApprovalSettings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/accessapproval/v1/accessapproval.proto",
}
