// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/event_service.proto

package talent

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The report event request.
type CreateClientEventRequest struct {
	// Required. Resource name of the tenant under which the event is created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
	// is created, for example, "projects/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Events issued when end user interacts with customer's application that
	// uses Cloud Talent Solution.
	ClientEvent          *ClientEvent `protobuf:"bytes,2,opt,name=client_event,json=clientEvent,proto3" json:"client_event,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CreateClientEventRequest) Reset()         { *m = CreateClientEventRequest{} }
func (m *CreateClientEventRequest) String() string { return proto.CompactTextString(m) }
func (*CreateClientEventRequest) ProtoMessage()    {}
func (*CreateClientEventRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fe732bea1e1e1bea, []int{0}
}

func (m *CreateClientEventRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClientEventRequest.Unmarshal(m, b)
}
func (m *CreateClientEventRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClientEventRequest.Marshal(b, m, deterministic)
}
func (m *CreateClientEventRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClientEventRequest.Merge(m, src)
}
func (m *CreateClientEventRequest) XXX_Size() int {
	return xxx_messageInfo_CreateClientEventRequest.Size(m)
}
func (m *CreateClientEventRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClientEventRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClientEventRequest proto.InternalMessageInfo

func (m *CreateClientEventRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateClientEventRequest) GetClientEvent() *ClientEvent {
	if m != nil {
		return m.ClientEvent
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateClientEventRequest)(nil), "google.cloud.talent.v4beta1.CreateClientEventRequest")
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/event_service.proto", fileDescriptor_fe732bea1e1e1bea)
}

var fileDescriptor_fe732bea1e1e1bea = []byte{
	// 451 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x92, 0xc1, 0x6e, 0xd3, 0x40,
	0x10, 0x86, 0xb5, 0xae, 0x54, 0x89, 0x6d, 0x2f, 0x75, 0x0f, 0x04, 0x83, 0xd4, 0x2a, 0x08, 0x11,
	0x42, 0xd9, 0x15, 0x2d, 0x5c, 0x8a, 0x38, 0x38, 0x11, 0x67, 0xa2, 0xa4, 0xa7, 0x5e, 0xa2, 0x8d,
	0x3b, 0x75, 0x5c, 0x6d, 0x76, 0xcc, 0xee, 0x24, 0x39, 0x20, 0x84, 0x84, 0x78, 0x03, 0xde, 0x80,
	0x37, 0xe0, 0x35, 0x38, 0xc2, 0x8d, 0x53, 0x0f, 0x3c, 0x45, 0xb9, 0x20, 0x7b, 0x0d, 0xb5, 0x68,
	0x71, 0x7a, 0xb3, 0x3d, 0xff, 0xe7, 0x7f, 0xfe, 0x99, 0xe1, 0x32, 0x45, 0x4c, 0x35, 0xc8, 0x44,
	0xe3, 0xfc, 0x44, 0x92, 0xd2, 0x60, 0x48, 0x2e, 0x9e, 0x4d, 0x80, 0xd4, 0x53, 0x09, 0x0b, 0x30,
	0x34, 0x76, 0x60, 0x17, 0x59, 0x02, 0x22, 0xb7, 0x48, 0x18, 0xde, 0xf5, 0x80, 0x28, 0x01, 0xe1,
	0x01, 0x51, 0x01, 0xd1, 0xbd, 0xea, 0x6f, 0x2a, 0xcf, 0xa4, 0x32, 0x06, 0x49, 0x51, 0x86, 0xc6,
	0x79, 0x34, 0xba, 0x5d, 0xab, 0x26, 0x3a, 0x2b, 0x40, 0x5f, 0xd8, 0xa9, 0x15, 0x4e, 0x33, 0xd0,
	0x27, 0xe3, 0x09, 0x4c, 0xd5, 0x22, 0x43, 0x5b, 0x09, 0xee, 0xd4, 0x04, 0x16, 0x1c, 0xce, 0xed,
	0x9f, 0x7e, 0xa2, 0x87, 0x2b, 0x03, 0x78, 0x61, 0xfb, 0x0b, 0xe3, 0xad, 0xbe, 0x05, 0x45, 0xd0,
	0x2f, 0xbd, 0x5f, 0x15, 0xb5, 0x21, 0xbc, 0x99, 0x83, 0xa3, 0xb0, 0xcf, 0xd7, 0x73, 0x65, 0xc1,
	0x50, 0x8b, 0xed, 0xb2, 0xce, 0xad, 0xde, 0xe3, 0xf3, 0x38, 0xb8, 0x88, 0x1f, 0xf0, 0xfb, 0x67,
	0x38, 0x71, 0xc2, 0x5b, 0xa8, 0x3c, 0x73, 0x22, 0xc1, 0x99, 0x3c, 0x02, 0xa3, 0x0c, 0xbd, 0xb6,
	0x03, 0x8b, 0x67, 0x90, 0xd0, 0xb0, 0x42, 0xc3, 0x01, 0xdf, 0xf4, 0xb1, 0xc6, 0xa5, 0x6f, 0x2b,
	0xd8, 0x65, 0x9d, 0x8d, 0xfd, 0x8e, 0x68, 0x98, 0x98, 0xa8, 0xf5, 0xd2, 0x5b, 0x3b, 0x8f, 0x83,
	0xe1, 0x46, 0x72, 0xf9, 0x65, 0xff, 0x22, 0xe0, 0x9b, 0xe5, 0xd3, 0xc8, 0xef, 0x20, 0xfc, 0xc5,
	0xf8, 0xd6, 0x95, 0x10, 0xe1, 0xf3, 0x66, 0x8b, 0xff, 0x84, 0x8e, 0x6e, 0xdc, 0x59, 0xfb, 0x23,
	0xfb, 0x11, 0x6f, 0xfb, 0x94, 0x7b, 0xf5, 0x88, 0x1f, 0xbe, 0xff, 0xfc, 0x14, 0x4c, 0xdb, 0x07,
	0x7f, 0x07, 0xfe, 0xd6, 0x8b, 0x5e, 0xe6, 0x7e, 0x34, 0x4e, 0x76, 0x25, 0x95, 0xd3, 0x72, 0xb2,
	0xfb, 0x4e, 0xd6, 0xa2, 0xb9, 0x43, 0xd6, 0x3d, 0x16, 0xed, 0x47, 0x0d, 0xe4, 0x15, 0x7d, 0xa4,
	0xbf, 0xc6, 0xdb, 0xd7, 0x2c, 0xe4, 0x5b, 0x3c, 0x9a, 0x12, 0xe5, 0xee, 0x50, 0xca, 0xe5, 0x72,
	0xf9, 0xef, 0xb6, 0xd4, 0x9c, 0xa6, 0xfe, 0x3a, 0x9e, 0xe4, 0x5a, 0xd1, 0x29, 0xda, 0xd9, 0xde,
	0x2a, 0x79, 0x61, 0xd2, 0x7b, 0xcf, 0x77, 0x12, 0x9c, 0x35, 0xcd, 0xa8, 0xb7, 0x55, 0x5f, 0xce,
	0xa0, 0x38, 0xb3, 0x01, 0x3b, 0x8e, 0x2b, 0x22, 0x45, 0xad, 0x4c, 0x2a, 0xd0, 0xa6, 0x32, 0x05,
	0x53, 0x1e, 0xa1, 0xbc, 0x34, 0xbb, 0xf6, 0x60, 0x5f, 0xf8, 0xd7, 0xcf, 0xc1, 0x5a, 0xff, 0x68,
	0x34, 0x59, 0x2f, 0x99, 0x83, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0xfa, 0x71, 0xf3, 0x56, 0xa4,
	0x03, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// EventServiceClient is the client API for EventService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EventServiceClient interface {
	// Report events issued when end user interacts with customer's application
	// that uses Cloud Talent Solution. You may inspect the created events in
	// [self service
	// tools](https://console.cloud.google.com/talent-solution/overview).
	// [Learn
	// more](https://cloud.google.com/talent-solution/docs/management-tools)
	// about self service tools.
	CreateClientEvent(ctx context.Context, in *CreateClientEventRequest, opts ...grpc.CallOption) (*ClientEvent, error)
}

type eventServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewEventServiceClient(cc grpc.ClientConnInterface) EventServiceClient {
	return &eventServiceClient{cc}
}

func (c *eventServiceClient) CreateClientEvent(ctx context.Context, in *CreateClientEventRequest, opts ...grpc.CallOption) (*ClientEvent, error) {
	out := new(ClientEvent)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.EventService/CreateClientEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EventServiceServer is the server API for EventService service.
type EventServiceServer interface {
	// Report events issued when end user interacts with customer's application
	// that uses Cloud Talent Solution. You may inspect the created events in
	// [self service
	// tools](https://console.cloud.google.com/talent-solution/overview).
	// [Learn
	// more](https://cloud.google.com/talent-solution/docs/management-tools)
	// about self service tools.
	CreateClientEvent(context.Context, *CreateClientEventRequest) (*ClientEvent, error)
}

// UnimplementedEventServiceServer can be embedded to have forward compatible implementations.
type UnimplementedEventServiceServer struct {
}

func (*UnimplementedEventServiceServer) CreateClientEvent(ctx context.Context, req *CreateClientEventRequest) (*ClientEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateClientEvent not implemented")
}

func RegisterEventServiceServer(s *grpc.Server, srv EventServiceServer) {
	s.RegisterService(&_EventService_serviceDesc, srv)
}

func _EventService_CreateClientEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClientEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventServiceServer).CreateClientEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.EventService/CreateClientEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventServiceServer).CreateClientEvent(ctx, req.(*CreateClientEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _EventService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.talent.v4beta1.EventService",
	HandlerType: (*EventServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateClientEvent",
			Handler:    _EventService_CreateClientEvent_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/talent/v4beta1/event_service.proto",
}
