// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/resources/ad_group_criterion.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v3/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An ad group criterion.
type AdGroupCriterion struct {
	// The resource name of the ad group criterion.
	// Ad group criterion resource names have the form:
	//
	// `customers/{customer_id}/adGroupCriteria/{ad_group_id}~{criterion_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the criterion.
	//
	// This field is ignored for mutates.
	CriterionId *wrappers.Int64Value `protobuf:"bytes,26,opt,name=criterion_id,json=criterionId,proto3" json:"criterion_id,omitempty"`
	// The status of the criterion.
	Status enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus `protobuf:"varint,3,opt,name=status,proto3,enum=google.ads.googleads.v3.enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus" json:"status,omitempty"`
	// Information regarding the quality of the criterion.
	QualityInfo *AdGroupCriterion_QualityInfo `protobuf:"bytes,4,opt,name=quality_info,json=qualityInfo,proto3" json:"quality_info,omitempty"`
	// The ad group to which the criterion belongs.
	AdGroup *wrappers.StringValue `protobuf:"bytes,5,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// The type of the criterion.
	Type enums.CriterionTypeEnum_CriterionType `protobuf:"varint,25,opt,name=type,proto3,enum=google.ads.googleads.v3.enums.CriterionTypeEnum_CriterionType" json:"type,omitempty"`
	// Whether to target (`false`) or exclude (`true`) the criterion.
	//
	// This field is immutable. To switch a criterion from positive to negative,
	// remove then re-add it.
	Negative *wrappers.BoolValue `protobuf:"bytes,31,opt,name=negative,proto3" json:"negative,omitempty"`
	// Serving status of the criterion.
	SystemServingStatus enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus `protobuf:"varint,52,opt,name=system_serving_status,json=systemServingStatus,proto3,enum=google.ads.googleads.v3.enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus" json:"system_serving_status,omitempty"`
	// Approval status of the criterion.
	ApprovalStatus enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus `protobuf:"varint,53,opt,name=approval_status,json=approvalStatus,proto3,enum=google.ads.googleads.v3.enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus" json:"approval_status,omitempty"`
	// The modifier for the bid when the criterion matches. The modifier must be
	// in the range: 0.1 - 10.0. Most targetable criteria types support modifiers.
	BidModifier *wrappers.DoubleValue `protobuf:"bytes,44,opt,name=bid_modifier,json=bidModifier,proto3" json:"bid_modifier,omitempty"`
	// The CPC (cost-per-click) bid.
	CpcBidMicros *wrappers.Int64Value `protobuf:"bytes,16,opt,name=cpc_bid_micros,json=cpcBidMicros,proto3" json:"cpc_bid_micros,omitempty"`
	// The CPM (cost-per-thousand viewable impressions) bid.
	CpmBidMicros *wrappers.Int64Value `protobuf:"bytes,17,opt,name=cpm_bid_micros,json=cpmBidMicros,proto3" json:"cpm_bid_micros,omitempty"`
	// The CPV (cost-per-view) bid.
	CpvBidMicros *wrappers.Int64Value `protobuf:"bytes,24,opt,name=cpv_bid_micros,json=cpvBidMicros,proto3" json:"cpv_bid_micros,omitempty"`
	// The CPC bid amount, expressed as a fraction of the advertised price
	// for some good or service. The valid range for the fraction is [0,1) and the
	// value stored here is 1,000,000 * [fraction].
	PercentCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,33,opt,name=percent_cpc_bid_micros,json=percentCpcBidMicros,proto3" json:"percent_cpc_bid_micros,omitempty"`
	// The effective CPC (cost-per-click) bid.
	EffectiveCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,18,opt,name=effective_cpc_bid_micros,json=effectiveCpcBidMicros,proto3" json:"effective_cpc_bid_micros,omitempty"`
	// The effective CPM (cost-per-thousand viewable impressions) bid.
	EffectiveCpmBidMicros *wrappers.Int64Value `protobuf:"bytes,19,opt,name=effective_cpm_bid_micros,json=effectiveCpmBidMicros,proto3" json:"effective_cpm_bid_micros,omitempty"`
	// The effective CPV (cost-per-view) bid.
	EffectiveCpvBidMicros *wrappers.Int64Value `protobuf:"bytes,20,opt,name=effective_cpv_bid_micros,json=effectiveCpvBidMicros,proto3" json:"effective_cpv_bid_micros,omitempty"`
	// The effective Percent CPC bid amount.
	EffectivePercentCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,34,opt,name=effective_percent_cpc_bid_micros,json=effectivePercentCpcBidMicros,proto3" json:"effective_percent_cpc_bid_micros,omitempty"`
	// Source of the effective CPC bid.
	EffectiveCpcBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,21,opt,name=effective_cpc_bid_source,json=effectiveCpcBidSource,proto3,enum=google.ads.googleads.v3.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpc_bid_source,omitempty"`
	// Source of the effective CPM bid.
	EffectiveCpmBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,22,opt,name=effective_cpm_bid_source,json=effectiveCpmBidSource,proto3,enum=google.ads.googleads.v3.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpm_bid_source,omitempty"`
	// Source of the effective CPV bid.
	EffectiveCpvBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,23,opt,name=effective_cpv_bid_source,json=effectiveCpvBidSource,proto3,enum=google.ads.googleads.v3.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpv_bid_source,omitempty"`
	// Source of the effective Percent CPC bid.
	EffectivePercentCpcBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,35,opt,name=effective_percent_cpc_bid_source,json=effectivePercentCpcBidSource,proto3,enum=google.ads.googleads.v3.enums.BiddingSourceEnum_BiddingSource" json:"effective_percent_cpc_bid_source,omitempty"`
	// Estimates for criterion bids at various positions.
	PositionEstimates *AdGroupCriterion_PositionEstimates `protobuf:"bytes,10,opt,name=position_estimates,json=positionEstimates,proto3" json:"position_estimates,omitempty"`
	// The list of possible final URLs after all cross-domain redirects for the
	// ad.
	FinalUrls []*wrappers.StringValue `protobuf:"bytes,11,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// The list of possible final mobile URLs after all cross-domain redirects.
	FinalMobileUrls []*wrappers.StringValue `protobuf:"bytes,51,rep,name=final_mobile_urls,json=finalMobileUrls,proto3" json:"final_mobile_urls,omitempty"`
	// URL template for appending params to final URL.
	FinalUrlSuffix *wrappers.StringValue `protobuf:"bytes,50,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,13,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The list of mappings used to substitute custom parameter tags in a
	// `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,14,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// The ad group criterion.
	//
	// Exactly one must be set.
	//
	// Types that are valid to be assigned to Criterion:
	//	*AdGroupCriterion_Keyword
	//	*AdGroupCriterion_Placement
	//	*AdGroupCriterion_MobileAppCategory
	//	*AdGroupCriterion_MobileApplication
	//	*AdGroupCriterion_ListingGroup
	//	*AdGroupCriterion_AgeRange
	//	*AdGroupCriterion_Gender
	//	*AdGroupCriterion_IncomeRange
	//	*AdGroupCriterion_ParentalStatus
	//	*AdGroupCriterion_UserList
	//	*AdGroupCriterion_YoutubeVideo
	//	*AdGroupCriterion_YoutubeChannel
	//	*AdGroupCriterion_Topic
	//	*AdGroupCriterion_UserInterest
	//	*AdGroupCriterion_Webpage
	//	*AdGroupCriterion_AppPaymentModel
	//	*AdGroupCriterion_CustomAffinity
	//	*AdGroupCriterion_CustomIntent
	Criterion            isAdGroupCriterion_Criterion `protobuf_oneof:"criterion"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *AdGroupCriterion) Reset()         { *m = AdGroupCriterion{} }
func (m *AdGroupCriterion) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterion) ProtoMessage()    {}
func (*AdGroupCriterion) Descriptor() ([]byte, []int) {
	return fileDescriptor_dbeea8b4a62ffe2f, []int{0}
}

func (m *AdGroupCriterion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterion.Unmarshal(m, b)
}
func (m *AdGroupCriterion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterion.Marshal(b, m, deterministic)
}
func (m *AdGroupCriterion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterion.Merge(m, src)
}
func (m *AdGroupCriterion) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterion.Size(m)
}
func (m *AdGroupCriterion) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterion.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterion proto.InternalMessageInfo

func (m *AdGroupCriterion) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AdGroupCriterion) GetCriterionId() *wrappers.Int64Value {
	if m != nil {
		return m.CriterionId
	}
	return nil
}

func (m *AdGroupCriterion) GetStatus() enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus {
	if m != nil {
		return m.Status
	}
	return enums.AdGroupCriterionStatusEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetQualityInfo() *AdGroupCriterion_QualityInfo {
	if m != nil {
		return m.QualityInfo
	}
	return nil
}

func (m *AdGroupCriterion) GetAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *AdGroupCriterion) GetType() enums.CriterionTypeEnum_CriterionType {
	if m != nil {
		return m.Type
	}
	return enums.CriterionTypeEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetNegative() *wrappers.BoolValue {
	if m != nil {
		return m.Negative
	}
	return nil
}

func (m *AdGroupCriterion) GetSystemServingStatus() enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus {
	if m != nil {
		return m.SystemServingStatus
	}
	return enums.CriterionSystemServingStatusEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetApprovalStatus() enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus {
	if m != nil {
		return m.ApprovalStatus
	}
	return enums.AdGroupCriterionApprovalStatusEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetBidModifier() *wrappers.DoubleValue {
	if m != nil {
		return m.BidModifier
	}
	return nil
}

func (m *AdGroupCriterion) GetCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetCpmBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpmBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetCpvBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpvBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetPercentCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.PercentCpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveCpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpmBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveCpmBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpvBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveCpvBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectivePercentCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectivePercentCpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpcBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveCpcBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetEffectiveCpmBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveCpmBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetEffectiveCpvBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveCpvBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetEffectivePercentCpcBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectivePercentCpcBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetPositionEstimates() *AdGroupCriterion_PositionEstimates {
	if m != nil {
		return m.PositionEstimates
	}
	return nil
}

func (m *AdGroupCriterion) GetFinalUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalUrls
	}
	return nil
}

func (m *AdGroupCriterion) GetFinalMobileUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalMobileUrls
	}
	return nil
}

func (m *AdGroupCriterion) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

func (m *AdGroupCriterion) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *AdGroupCriterion) GetUrlCustomParameters() []*common.CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

type isAdGroupCriterion_Criterion interface {
	isAdGroupCriterion_Criterion()
}

type AdGroupCriterion_Keyword struct {
	Keyword *common.KeywordInfo `protobuf:"bytes,27,opt,name=keyword,proto3,oneof"`
}

type AdGroupCriterion_Placement struct {
	Placement *common.PlacementInfo `protobuf:"bytes,28,opt,name=placement,proto3,oneof"`
}

type AdGroupCriterion_MobileAppCategory struct {
	MobileAppCategory *common.MobileAppCategoryInfo `protobuf:"bytes,29,opt,name=mobile_app_category,json=mobileAppCategory,proto3,oneof"`
}

type AdGroupCriterion_MobileApplication struct {
	MobileApplication *common.MobileApplicationInfo `protobuf:"bytes,30,opt,name=mobile_application,json=mobileApplication,proto3,oneof"`
}

type AdGroupCriterion_ListingGroup struct {
	ListingGroup *common.ListingGroupInfo `protobuf:"bytes,32,opt,name=listing_group,json=listingGroup,proto3,oneof"`
}

type AdGroupCriterion_AgeRange struct {
	AgeRange *common.AgeRangeInfo `protobuf:"bytes,36,opt,name=age_range,json=ageRange,proto3,oneof"`
}

type AdGroupCriterion_Gender struct {
	Gender *common.GenderInfo `protobuf:"bytes,37,opt,name=gender,proto3,oneof"`
}

type AdGroupCriterion_IncomeRange struct {
	IncomeRange *common.IncomeRangeInfo `protobuf:"bytes,38,opt,name=income_range,json=incomeRange,proto3,oneof"`
}

type AdGroupCriterion_ParentalStatus struct {
	ParentalStatus *common.ParentalStatusInfo `protobuf:"bytes,39,opt,name=parental_status,json=parentalStatus,proto3,oneof"`
}

type AdGroupCriterion_UserList struct {
	UserList *common.UserListInfo `protobuf:"bytes,42,opt,name=user_list,json=userList,proto3,oneof"`
}

type AdGroupCriterion_YoutubeVideo struct {
	YoutubeVideo *common.YouTubeVideoInfo `protobuf:"bytes,40,opt,name=youtube_video,json=youtubeVideo,proto3,oneof"`
}

type AdGroupCriterion_YoutubeChannel struct {
	YoutubeChannel *common.YouTubeChannelInfo `protobuf:"bytes,41,opt,name=youtube_channel,json=youtubeChannel,proto3,oneof"`
}

type AdGroupCriterion_Topic struct {
	Topic *common.TopicInfo `protobuf:"bytes,43,opt,name=topic,proto3,oneof"`
}

type AdGroupCriterion_UserInterest struct {
	UserInterest *common.UserInterestInfo `protobuf:"bytes,45,opt,name=user_interest,json=userInterest,proto3,oneof"`
}

type AdGroupCriterion_Webpage struct {
	Webpage *common.WebpageInfo `protobuf:"bytes,46,opt,name=webpage,proto3,oneof"`
}

type AdGroupCriterion_AppPaymentModel struct {
	AppPaymentModel *common.AppPaymentModelInfo `protobuf:"bytes,47,opt,name=app_payment_model,json=appPaymentModel,proto3,oneof"`
}

type AdGroupCriterion_CustomAffinity struct {
	CustomAffinity *common.CustomAffinityInfo `protobuf:"bytes,48,opt,name=custom_affinity,json=customAffinity,proto3,oneof"`
}

type AdGroupCriterion_CustomIntent struct {
	CustomIntent *common.CustomIntentInfo `protobuf:"bytes,49,opt,name=custom_intent,json=customIntent,proto3,oneof"`
}

func (*AdGroupCriterion_Keyword) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Placement) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_MobileAppCategory) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_MobileApplication) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_ListingGroup) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_AgeRange) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Gender) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_IncomeRange) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_ParentalStatus) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_UserList) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_YoutubeVideo) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_YoutubeChannel) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Topic) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_UserInterest) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Webpage) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_AppPaymentModel) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_CustomAffinity) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_CustomIntent) isAdGroupCriterion_Criterion() {}

func (m *AdGroupCriterion) GetCriterion() isAdGroupCriterion_Criterion {
	if m != nil {
		return m.Criterion
	}
	return nil
}

func (m *AdGroupCriterion) GetKeyword() *common.KeywordInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Keyword); ok {
		return x.Keyword
	}
	return nil
}

func (m *AdGroupCriterion) GetPlacement() *common.PlacementInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Placement); ok {
		return x.Placement
	}
	return nil
}

func (m *AdGroupCriterion) GetMobileAppCategory() *common.MobileAppCategoryInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_MobileAppCategory); ok {
		return x.MobileAppCategory
	}
	return nil
}

func (m *AdGroupCriterion) GetMobileApplication() *common.MobileApplicationInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_MobileApplication); ok {
		return x.MobileApplication
	}
	return nil
}

func (m *AdGroupCriterion) GetListingGroup() *common.ListingGroupInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_ListingGroup); ok {
		return x.ListingGroup
	}
	return nil
}

func (m *AdGroupCriterion) GetAgeRange() *common.AgeRangeInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_AgeRange); ok {
		return x.AgeRange
	}
	return nil
}

func (m *AdGroupCriterion) GetGender() *common.GenderInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Gender); ok {
		return x.Gender
	}
	return nil
}

func (m *AdGroupCriterion) GetIncomeRange() *common.IncomeRangeInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_IncomeRange); ok {
		return x.IncomeRange
	}
	return nil
}

func (m *AdGroupCriterion) GetParentalStatus() *common.ParentalStatusInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_ParentalStatus); ok {
		return x.ParentalStatus
	}
	return nil
}

func (m *AdGroupCriterion) GetUserList() *common.UserListInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_UserList); ok {
		return x.UserList
	}
	return nil
}

func (m *AdGroupCriterion) GetYoutubeVideo() *common.YouTubeVideoInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_YoutubeVideo); ok {
		return x.YoutubeVideo
	}
	return nil
}

func (m *AdGroupCriterion) GetYoutubeChannel() *common.YouTubeChannelInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_YoutubeChannel); ok {
		return x.YoutubeChannel
	}
	return nil
}

func (m *AdGroupCriterion) GetTopic() *common.TopicInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Topic); ok {
		return x.Topic
	}
	return nil
}

func (m *AdGroupCriterion) GetUserInterest() *common.UserInterestInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_UserInterest); ok {
		return x.UserInterest
	}
	return nil
}

func (m *AdGroupCriterion) GetWebpage() *common.WebpageInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Webpage); ok {
		return x.Webpage
	}
	return nil
}

func (m *AdGroupCriterion) GetAppPaymentModel() *common.AppPaymentModelInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_AppPaymentModel); ok {
		return x.AppPaymentModel
	}
	return nil
}

func (m *AdGroupCriterion) GetCustomAffinity() *common.CustomAffinityInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_CustomAffinity); ok {
		return x.CustomAffinity
	}
	return nil
}

func (m *AdGroupCriterion) GetCustomIntent() *common.CustomIntentInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_CustomIntent); ok {
		return x.CustomIntent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AdGroupCriterion) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AdGroupCriterion_Keyword)(nil),
		(*AdGroupCriterion_Placement)(nil),
		(*AdGroupCriterion_MobileAppCategory)(nil),
		(*AdGroupCriterion_MobileApplication)(nil),
		(*AdGroupCriterion_ListingGroup)(nil),
		(*AdGroupCriterion_AgeRange)(nil),
		(*AdGroupCriterion_Gender)(nil),
		(*AdGroupCriterion_IncomeRange)(nil),
		(*AdGroupCriterion_ParentalStatus)(nil),
		(*AdGroupCriterion_UserList)(nil),
		(*AdGroupCriterion_YoutubeVideo)(nil),
		(*AdGroupCriterion_YoutubeChannel)(nil),
		(*AdGroupCriterion_Topic)(nil),
		(*AdGroupCriterion_UserInterest)(nil),
		(*AdGroupCriterion_Webpage)(nil),
		(*AdGroupCriterion_AppPaymentModel)(nil),
		(*AdGroupCriterion_CustomAffinity)(nil),
		(*AdGroupCriterion_CustomIntent)(nil),
	}
}

// A container for ad group criterion quality information.
type AdGroupCriterion_QualityInfo struct {
	// The quality score.
	//
	// This field may not be populated if Google does not have enough
	// information to determine a value.
	QualityScore *wrappers.Int32Value `protobuf:"bytes,1,opt,name=quality_score,json=qualityScore,proto3" json:"quality_score,omitempty"`
	// The performance of the ad compared to other advertisers.
	CreativeQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,2,opt,name=creative_quality_score,json=creativeQualityScore,proto3,enum=google.ads.googleads.v3.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"creative_quality_score,omitempty"`
	// The quality score of the landing page.
	PostClickQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,3,opt,name=post_click_quality_score,json=postClickQualityScore,proto3,enum=google.ads.googleads.v3.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"post_click_quality_score,omitempty"`
	// The click-through rate compared to that of other advertisers.
	SearchPredictedCtr   enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,4,opt,name=search_predicted_ctr,json=searchPredictedCtr,proto3,enum=google.ads.googleads.v3.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"search_predicted_ctr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                        `json:"-"`
	XXX_unrecognized     []byte                                          `json:"-"`
	XXX_sizecache        int32                                           `json:"-"`
}

func (m *AdGroupCriterion_QualityInfo) Reset()         { *m = AdGroupCriterion_QualityInfo{} }
func (m *AdGroupCriterion_QualityInfo) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterion_QualityInfo) ProtoMessage()    {}
func (*AdGroupCriterion_QualityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_dbeea8b4a62ffe2f, []int{0, 0}
}

func (m *AdGroupCriterion_QualityInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterion_QualityInfo.Unmarshal(m, b)
}
func (m *AdGroupCriterion_QualityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterion_QualityInfo.Marshal(b, m, deterministic)
}
func (m *AdGroupCriterion_QualityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterion_QualityInfo.Merge(m, src)
}
func (m *AdGroupCriterion_QualityInfo) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterion_QualityInfo.Size(m)
}
func (m *AdGroupCriterion_QualityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterion_QualityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterion_QualityInfo proto.InternalMessageInfo

func (m *AdGroupCriterion_QualityInfo) GetQualityScore() *wrappers.Int32Value {
	if m != nil {
		return m.QualityScore
	}
	return nil
}

func (m *AdGroupCriterion_QualityInfo) GetCreativeQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.CreativeQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *AdGroupCriterion_QualityInfo) GetPostClickQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.PostClickQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *AdGroupCriterion_QualityInfo) GetSearchPredictedCtr() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.SearchPredictedCtr
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

// Estimates for criterion bids at various positions.
type AdGroupCriterion_PositionEstimates struct {
	// The estimate of the CPC bid required for ad to be shown on first
	// page of search results.
	FirstPageCpcMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=first_page_cpc_micros,json=firstPageCpcMicros,proto3" json:"first_page_cpc_micros,omitempty"`
	// The estimate of the CPC bid required for ad to be displayed in first
	// position, at the top of the first page of search results.
	FirstPositionCpcMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=first_position_cpc_micros,json=firstPositionCpcMicros,proto3" json:"first_position_cpc_micros,omitempty"`
	// The estimate of the CPC bid required for ad to be displayed at the top
	// of the first page of search results.
	TopOfPageCpcMicros *wrappers.Int64Value `protobuf:"bytes,3,opt,name=top_of_page_cpc_micros,json=topOfPageCpcMicros,proto3" json:"top_of_page_cpc_micros,omitempty"`
	// Estimate of how many clicks per week you might get by changing your
	// keyword bid to the value in first_position_cpc_micros.
	EstimatedAddClicksAtFirstPositionCpc *wrappers.Int64Value `protobuf:"bytes,4,opt,name=estimated_add_clicks_at_first_position_cpc,json=estimatedAddClicksAtFirstPositionCpc,proto3" json:"estimated_add_clicks_at_first_position_cpc,omitempty"`
	// Estimate of how your cost per week might change when changing your
	// keyword bid to the value in first_position_cpc_micros.
	EstimatedAddCostAtFirstPositionCpc *wrappers.Int64Value `protobuf:"bytes,5,opt,name=estimated_add_cost_at_first_position_cpc,json=estimatedAddCostAtFirstPositionCpc,proto3" json:"estimated_add_cost_at_first_position_cpc,omitempty"`
	XXX_NoUnkeyedLiteral               struct{}             `json:"-"`
	XXX_unrecognized                   []byte               `json:"-"`
	XXX_sizecache                      int32                `json:"-"`
}

func (m *AdGroupCriterion_PositionEstimates) Reset()         { *m = AdGroupCriterion_PositionEstimates{} }
func (m *AdGroupCriterion_PositionEstimates) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterion_PositionEstimates) ProtoMessage()    {}
func (*AdGroupCriterion_PositionEstimates) Descriptor() ([]byte, []int) {
	return fileDescriptor_dbeea8b4a62ffe2f, []int{0, 1}
}

func (m *AdGroupCriterion_PositionEstimates) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterion_PositionEstimates.Unmarshal(m, b)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterion_PositionEstimates.Marshal(b, m, deterministic)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterion_PositionEstimates.Merge(m, src)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterion_PositionEstimates.Size(m)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterion_PositionEstimates.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterion_PositionEstimates proto.InternalMessageInfo

func (m *AdGroupCriterion_PositionEstimates) GetFirstPageCpcMicros() *wrappers.Int64Value {
	if m != nil {
		return m.FirstPageCpcMicros
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetFirstPositionCpcMicros() *wrappers.Int64Value {
	if m != nil {
		return m.FirstPositionCpcMicros
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetTopOfPageCpcMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TopOfPageCpcMicros
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetEstimatedAddClicksAtFirstPositionCpc() *wrappers.Int64Value {
	if m != nil {
		return m.EstimatedAddClicksAtFirstPositionCpc
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetEstimatedAddCostAtFirstPositionCpc() *wrappers.Int64Value {
	if m != nil {
		return m.EstimatedAddCostAtFirstPositionCpc
	}
	return nil
}

func init() {
	proto.RegisterType((*AdGroupCriterion)(nil), "google.ads.googleads.v3.resources.AdGroupCriterion")
	proto.RegisterType((*AdGroupCriterion_QualityInfo)(nil), "google.ads.googleads.v3.resources.AdGroupCriterion.QualityInfo")
	proto.RegisterType((*AdGroupCriterion_PositionEstimates)(nil), "google.ads.googleads.v3.resources.AdGroupCriterion.PositionEstimates")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/resources/ad_group_criterion.proto", fileDescriptor_dbeea8b4a62ffe2f)
}

var fileDescriptor_dbeea8b4a62ffe2f = []byte{
	// 1749 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x98, 0xdd, 0x72, 0x1b, 0xb7,
	0x15, 0xc7, 0x4b, 0x29, 0x76, 0x2c, 0x48, 0x96, 0x2d, 0xc8, 0x52, 0x61, 0xc5, 0x4d, 0x65, 0x27,
	0x6e, 0x65, 0x27, 0x26, 0x53, 0x31, 0x4e, 0x5b, 0x66, 0x9a, 0x94, 0x52, 0x6c, 0x59, 0x4d, 0x95,
	0x30, 0x94, 0xac, 0x4c, 0x3b, 0xea, 0x6c, 0xc1, 0x5d, 0x70, 0x8d, 0xf1, 0xee, 0x02, 0x06, 0xb0,
	0x74, 0xd9, 0x4c, 0x3a, 0xd3, 0x5e, 0x74, 0xa6, 0x77, 0x7d, 0x86, 0x5e, 0xf6, 0xa2, 0x0f, 0xd2,
	0x9b, 0xbe, 0x47, 0x1e, 0xa0, 0xd7, 0x1d, 0x7c, 0x91, 0x4b, 0x52, 0xe4, 0x52, 0x1d, 0xdd, 0xed,
	0x62, 0xcf, 0xff, 0x77, 0x0e, 0x0e, 0xce, 0x62, 0x0f, 0x16, 0x34, 0x62, 0xc6, 0xe2, 0x84, 0xd4,
	0x70, 0x24, 0x6b, 0xf6, 0x52, 0x5f, 0xf5, 0xea, 0x35, 0x41, 0x24, 0xcb, 0x45, 0x48, 0x64, 0x0d,
	0x47, 0x41, 0x2c, 0x58, 0xce, 0x83, 0x50, 0x50, 0x45, 0x04, 0x65, 0x59, 0x95, 0x0b, 0xa6, 0x18,
	0xbc, 0x6b, 0x05, 0x55, 0x1c, 0xc9, 0xea, 0x40, 0x5b, 0xed, 0xd5, 0xab, 0x03, 0xed, 0xd6, 0xa3,
	0x69, 0xf8, 0x90, 0xa5, 0x29, 0xcb, 0x6a, 0x0e, 0x89, 0x2d, 0x71, 0xeb, 0x71, 0x99, 0x79, 0x2e,
	0x15, 0x4b, 0x03, 0x8e, 0x05, 0x4e, 0x89, 0x22, 0xc2, 0xc9, 0x9e, 0x4e, 0x93, 0x91, 0x2c, 0x4f,
	0xcf, 0x9b, 0x40, 0x80, 0x39, 0x17, 0xac, 0x87, 0x93, 0x40, 0x2a, 0xac, 0x72, 0xe9, 0x38, 0xbf,
	0xb8, 0x30, 0x67, 0x44, 0xbe, 0x3b, 0x5b, 0xde, 0xa1, 0x51, 0x44, 0xb3, 0x38, 0xb0, 0xb9, 0x71,
	0x9a, 0xfd, 0xd9, 0x9a, 0x82, 0xa7, 0xbe, 0x54, 0x24, 0x0d, 0x24, 0x11, 0x3d, 0x03, 0xb9, 0x80,
	0xe3, 0x21, 0x44, 0xf5, 0xb9, 0x77, 0xfc, 0xb3, 0xd9, 0x9a, 0x57, 0x39, 0x4e, 0xa8, 0xea, 0x07,
	0x32, 0x64, 0x82, 0x04, 0x9d, 0x3c, 0x7c, 0x49, 0x94, 0x53, 0xde, 0xf6, 0x4a, 0x4e, 0x07, 0x55,
	0xe2, 0x1e, 0xbd, 0xed, 0x1e, 0x99, 0xbb, 0x4e, 0xde, 0xad, 0xbd, 0x16, 0x98, 0x73, 0x22, 0x7c,
	0xa0, 0x77, 0x0a, 0x52, 0x9c, 0x65, 0x4c, 0x61, 0x45, 0x59, 0xe6, 0x9e, 0xde, 0xfb, 0xd7, 0x0e,
	0xb8, 0xd9, 0x8c, 0x0e, 0x74, 0x8a, 0xf7, 0x7d, 0xc8, 0xf0, 0x1d, 0x70, 0xdd, 0x3b, 0x09, 0x32,
	0x9c, 0x12, 0x54, 0xd9, 0xae, 0xec, 0x2c, 0xb5, 0x57, 0xfc, 0xe0, 0x17, 0x38, 0x25, 0xf0, 0x13,
	0xb0, 0x32, 0x9c, 0x24, 0x8d, 0xd0, 0xd6, 0x76, 0x65, 0x67, 0x79, 0xf7, 0x2d, 0x57, 0x95, 0x55,
	0x1f, 0x4e, 0xf5, 0x30, 0x53, 0x1f, 0x7d, 0x78, 0x8a, 0x93, 0x9c, 0xb4, 0x97, 0x07, 0x82, 0xc3,
	0x08, 0xbe, 0x00, 0x57, 0x6d, 0x42, 0xd1, 0xe2, 0x76, 0x65, 0x67, 0x75, 0xb7, 0x55, 0x9d, 0x56,
	0xda, 0x26, 0x3b, 0xd5, 0xf1, 0x28, 0x8f, 0x8d, 0xf8, 0x49, 0x96, 0xa7, 0x53, 0x1e, 0xb5, 0x1d,
	0x1f, 0x76, 0xc0, 0x8a, 0x4f, 0x2d, 0xcd, 0xba, 0x0c, 0xbd, 0x61, 0x22, 0xfd, 0xb4, 0x5a, 0xfa,
	0x2a, 0x4d, 0x80, 0xab, 0x5f, 0x59, 0xce, 0x61, 0xd6, 0x65, 0xed, 0xe5, 0x57, 0xc3, 0x1b, 0xf8,
	0x53, 0x70, 0xcd, 0x97, 0x2a, 0xba, 0x62, 0xf8, 0x77, 0x26, 0x32, 0x71, 0xac, 0x04, 0xcd, 0x62,
	0x9b, 0x8a, 0x37, 0xb1, 0x45, 0xc3, 0x36, 0x78, 0x43, 0x57, 0x08, 0xba, 0x6d, 0x92, 0xf0, 0x49,
	0x49, 0x12, 0x06, 0x91, 0x9c, 0xf4, 0x39, 0x31, 0x73, 0x1f, 0x19, 0x69, 0x1b, 0x16, 0xfc, 0x08,
	0x5c, 0xcb, 0x48, 0x8c, 0x15, 0xed, 0x11, 0xf4, 0x43, 0x13, 0xcc, 0xd6, 0x44, 0x30, 0x7b, 0x8c,
	0x25, 0x36, 0x94, 0x81, 0x2d, 0xfc, 0x7b, 0x05, 0x6c, 0x9c, 0x5b, 0xf3, 0xe8, 0x43, 0x13, 0xdd,
	0xd9, 0xbc, 0xd1, 0x1d, 0x1b, 0xc8, 0xb1, 0x65, 0x14, 0x16, 0x6a, 0x96, 0x41, 0x7b, 0x5d, 0x4e,
	0x0e, 0xc2, 0xbf, 0x55, 0xc0, 0x8d, 0xb1, 0x8d, 0x03, 0x3d, 0x36, 0xc1, 0xfc, 0xfe, 0x82, 0xf5,
	0xd2, 0x74, 0x94, 0x19, 0x75, 0x33, 0x6a, 0xd2, 0x5e, 0xc5, 0x23, 0xf7, 0xf0, 0x53, 0xb0, 0xd2,
	0xa1, 0x51, 0x90, 0xb2, 0x88, 0x76, 0x29, 0x11, 0xe8, 0xfd, 0x29, 0xeb, 0xfc, 0x19, 0xcb, 0x3b,
	0x09, 0x71, 0x25, 0xdf, 0xa1, 0xd1, 0x91, 0x13, 0xc0, 0x26, 0x58, 0x0d, 0x79, 0x18, 0x18, 0x08,
	0x0d, 0x05, 0x93, 0xe8, 0x66, 0xf9, 0x4b, 0xb3, 0x12, 0xf2, 0x70, 0x8f, 0x46, 0x47, 0x46, 0x60,
	0x11, 0x69, 0x11, 0xb1, 0x36, 0x17, 0x22, 0x1d, 0x43, 0xf4, 0x8a, 0x08, 0x34, 0x17, 0xa2, 0x37,
	0x44, 0xb4, 0xc0, 0x26, 0x27, 0x22, 0x24, 0x99, 0x0a, 0xc6, 0x26, 0x74, 0xb7, 0x1c, 0xb5, 0xee,
	0xa4, 0xfb, 0xc5, 0x79, 0x9d, 0x00, 0x44, 0xba, 0x5d, 0x12, 0xea, 0x3a, 0x1c, 0x67, 0xc2, 0x72,
	0xe6, 0xc6, 0x40, 0x3c, 0x8b, 0x3a, 0x92, 0xb7, 0xf5, 0x8b, 0x51, 0xd3, 0xa9, 0xd4, 0x91, 0x54,
	0xde, 0xba, 0x18, 0xb5, 0x90, 0xd3, 0x10, 0x6c, 0x0f, 0xa9, 0x53, 0xb2, 0x7b, 0xaf, 0x9c, 0x7e,
	0x67, 0x00, 0x69, 0x9d, 0x93, 0xe6, 0xd7, 0xe7, 0xa5, 0xd9, 0xee, 0x76, 0x68, 0x63, 0xae, 0x1d,
	0x68, 0xcf, 0x7e, 0x51, 0x8f, 0x8d, 0xc6, 0xbc, 0x45, 0x23, 0x23, 0x13, 0x2b, 0x61, 0x87, 0xc7,
	0x1d, 0xa7, 0x45, 0xc7, 0x9b, 0x97, 0xee, 0x38, 0x9d, 0xea, 0xb8, 0x57, 0x74, 0xfc, 0xfd, 0x4b,
	0x77, 0xdc, 0x1b, 0x3a, 0xfe, 0x6b, 0x65, 0xd6, 0x82, 0xba, 0x08, 0xde, 0xb9, 0x94, 0x08, 0xa6,
	0xac, 0xb9, 0x0b, 0x44, 0x01, 0xc8, 0x99, 0xa4, 0xfa, 0xab, 0x1f, 0x10, 0xa9, 0x68, 0x8a, 0x15,
	0x91, 0x08, 0x98, 0x52, 0x7a, 0xf2, 0xff, 0x7c, 0x04, 0x5b, 0x8e, 0xf6, 0xc4, 0xc3, 0xda, 0x6b,
	0x7c, 0x7c, 0x08, 0x7e, 0x0c, 0x40, 0x97, 0x66, 0x38, 0x09, 0x72, 0x91, 0x48, 0xb4, 0xbc, 0xbd,
	0x58, 0xfa, 0x49, 0x5c, 0x32, 0xf6, 0xcf, 0x45, 0x22, 0xe1, 0x33, 0xb0, 0x66, 0xc5, 0x29, 0xeb,
	0xd0, 0x84, 0x58, 0x46, 0x7d, 0x0e, 0xc6, 0x0d, 0x23, 0x3b, 0x32, 0x2a, 0x43, 0x7a, 0x0a, 0x6e,
	0x0e, 0xc2, 0x08, 0x64, 0xde, 0xed, 0xd2, 0x3f, 0xa0, 0xdd, 0x39, 0xbe, 0xcf, 0xab, 0x3e, 0x98,
	0x63, 0xa3, 0x81, 0x2d, 0xb0, 0xa1, 0x04, 0x0e, 0x5f, 0xea, 0x6f, 0xa2, 0x46, 0x29, 0x92, 0xf2,
	0x04, 0x2b, 0x82, 0xae, 0xcf, 0x01, 0x5b, 0xf7, 0xd2, 0xe7, 0x22, 0x39, 0x71, 0x42, 0x18, 0x82,
	0x0d, 0x0d, 0x1a, 0x6f, 0xaf, 0x25, 0x5a, 0x35, 0xf3, 0xac, 0x4d, 0x5d, 0x19, 0xdb, 0x97, 0x57,
	0xf7, 0x8d, 0xb0, 0xe5, 0x75, 0xed, 0xf5, 0x5c, 0x24, 0x63, 0x63, 0x12, 0x1e, 0x80, 0x37, 0x5f,
	0x92, 0xfe, 0x6b, 0x26, 0x22, 0xf4, 0x96, 0x09, 0xf4, 0xbd, 0x32, 0xec, 0xe7, 0xd6, 0x5c, 0x37,
	0x35, 0xcf, 0xbe, 0xd7, 0xf6, 0x6a, 0x78, 0x04, 0x96, 0x78, 0x82, 0x43, 0x92, 0x92, 0x4c, 0xa1,
	0x3b, 0x06, 0xf5, 0xa8, 0x0c, 0xd5, 0xf2, 0x02, 0x07, 0x1b, 0x12, 0x60, 0x0c, 0xd6, 0xdd, 0xd2,
	0x62, 0xce, 0x83, 0x10, 0x2b, 0x12, 0x33, 0xd1, 0x47, 0x3f, 0x30, 0xe0, 0xc7, 0x65, 0x60, 0xbb,
	0xbe, 0x4d, 0xce, 0xf7, 0x9d, 0xd0, 0x39, 0x58, 0x4b, 0xc7, 0x1f, 0xc0, 0x2e, 0x80, 0x43, 0x47,
	0x09, 0x0d, 0x4d, 0xf3, 0x8b, 0xde, 0xbe, 0xa0, 0x1f, 0x2f, 0x9c, 0xf0, 0xe3, 0x1f, 0xc0, 0xaf,
	0xc1, 0xf5, 0x84, 0x4a, 0xa5, 0xcb, 0xc3, 0x36, 0x81, 0xdb, 0xc6, 0xc5, 0x07, 0x65, 0x2e, 0x7e,
	0x6d, 0x45, 0xe6, 0x0d, 0x73, 0xf4, 0x95, 0xa4, 0x30, 0x06, 0x3f, 0x07, 0x4b, 0x38, 0x26, 0x81,
	0xc0, 0x59, 0x4c, 0xd0, 0xbb, 0x06, 0xfa, 0x7e, 0x19, 0xb4, 0x19, 0x93, 0xb6, 0xb6, 0x77, 0xc0,
	0x6b, 0xd8, 0xdd, 0xc3, 0xcf, 0xc0, 0xd5, 0x98, 0x64, 0x11, 0x11, 0xe8, 0xbe, 0x21, 0x3d, 0x2c,
	0x23, 0x1d, 0x18, 0x6b, 0xc7, 0x71, 0x5a, 0x78, 0x02, 0x56, 0x68, 0x16, 0xb2, 0xd4, 0x47, 0xf5,
	0x23, 0xc3, 0x2a, 0x2d, 0xd8, 0x43, 0xa3, 0x29, 0x06, 0xb6, 0x4c, 0x87, 0x43, 0xf0, 0x77, 0xe0,
	0x06, 0xc7, 0x82, 0x64, 0x6a, 0xd8, 0xe8, 0xfd, 0xd8, 0x80, 0x77, 0x4b, 0xeb, 0xcc, 0xc9, 0x6c,
	0x9b, 0xe6, 0xd8, 0xab, 0x7c, 0x64, 0x54, 0xe7, 0x31, 0x97, 0x44, 0x04, 0x3a, 0xb9, 0xe8, 0xe1,
	0x7c, 0x79, 0x7c, 0x2e, 0x89, 0xd0, 0x0b, 0xe4, 0xf3, 0x98, 0xbb, 0x7b, 0xbd, 0xda, 0x7d, 0x96,
	0xab, 0xbc, 0x43, 0x82, 0x1e, 0x8d, 0x08, 0x43, 0x3b, 0xf3, 0xad, 0xf6, 0x6f, 0x58, 0x7e, 0x92,
	0x77, 0xc8, 0xa9, 0xd6, 0xf8, 0xd5, 0x76, 0x20, 0x33, 0xa6, 0x93, 0xe0, 0xc1, 0xe1, 0x0b, 0x9c,
	0x65, 0x24, 0x41, 0x0f, 0xe6, 0x4b, 0x82, 0x43, 0xef, 0x5b, 0x95, 0x4f, 0x82, 0x83, 0xb9, 0x51,
	0xd8, 0x04, 0x57, 0x14, 0xe3, 0x34, 0x44, 0xef, 0x19, 0xe8, 0x83, 0x32, 0xe8, 0x89, 0x36, 0x76,
	0x2c, 0xab, 0xd4, 0x53, 0x37, 0x79, 0xa4, 0x99, 0x22, 0x82, 0x48, 0x85, 0x1e, 0xcd, 0x37, 0x75,
	0x9d, 0xcb, 0x43, 0xa7, 0xf1, 0x53, 0xcf, 0x0b, 0x63, 0x7a, 0xab, 0x7a, 0x4d, 0x3a, 0x1c, 0xc7,
	0x04, 0x55, 0xe7, 0xdb, 0xaa, 0xbe, 0xb6, 0xe6, 0x7e, 0xab, 0x72, 0x6a, 0x88, 0xc1, 0x9a, 0xde,
	0x54, 0x38, 0xee, 0xeb, 0xad, 0x46, 0xb7, 0xeb, 0x24, 0x41, 0x35, 0x83, 0xac, 0x97, 0xbe, 0x39,
	0x9c, 0xb7, 0xac, 0xee, 0x48, 0xcb, 0x1c, 0x5a, 0x9f, 0x40, 0x8a, 0xc3, 0x7a, 0x99, 0xdc, 0xbe,
	0x8d, 0xbb, 0x5d, 0x9a, 0x51, 0xd5, 0x47, 0x1f, 0xcc, 0xb7, 0x4c, 0x76, 0x87, 0x6e, 0x3a, 0x95,
	0x5f, 0xa6, 0x70, 0x64, 0x54, 0xe7, 0xd8, 0xe1, 0x75, 0x96, 0x33, 0x85, 0x7e, 0x32, 0x5f, 0x8e,
	0x2d, 0xfc, 0xd0, 0x68, 0x7c, 0x8e, 0xc3, 0xc2, 0xd8, 0xd6, 0x7f, 0x16, 0xc1, 0x72, 0xe1, 0x08,
	0x0b, 0x7f, 0x09, 0xae, 0x8f, 0xfc, 0x74, 0x30, 0x07, 0xfd, 0x29, 0x0d, 0x66, 0x7d, 0xd7, 0x9d,
	0x04, 0x9c, 0xe2, 0x58, 0x0b, 0xe0, 0x9f, 0xc0, 0x66, 0x28, 0x88, 0x39, 0x3e, 0x06, 0xa3, 0xa8,
	0x05, 0xd3, 0xda, 0x3c, 0x2b, 0x69, 0x6d, 0xbe, 0x2a, 0xc0, 0xf6, 0xcc, 0x1f, 0x0f, 0xd3, 0xdf,
	0x4c, 0x0e, 0xb7, 0x6f, 0x79, 0x3f, 0xc5, 0x67, 0xf0, 0xcf, 0x15, 0x80, 0x38, 0x93, 0x2a, 0x08,
	0x13, 0x1a, 0xbe, 0x1c, 0x0b, 0x61, 0xf1, 0x92, 0x43, 0xd8, 0xd0, 0x9e, 0xf6, 0xb5, 0xa3, 0x91,
	0x18, 0xfe, 0x08, 0x6e, 0x49, 0x82, 0x45, 0xf8, 0x22, 0xe0, 0x82, 0x44, 0x34, 0x54, 0x24, 0x0a,
	0x42, 0x25, 0xcc, 0x7f, 0x86, 0xcb, 0x74, 0x0f, 0xad, 0x97, 0x96, 0x77, 0xb2, 0xaf, 0xc4, 0xd6,
	0x7f, 0x17, 0xc1, 0xda, 0x44, 0x3f, 0x06, 0xbf, 0x00, 0x1b, 0x5d, 0x2a, 0xa4, 0x0a, 0xf4, 0x0b,
	0x61, 0x7a, 0x4e, 0x77, 0x80, 0xa8, 0x94, 0x1f, 0x20, 0xa0, 0x51, 0xb6, 0x70, 0xac, 0x1b, 0x78,
	0x77, 0x6c, 0x38, 0x05, 0xb7, 0x1d, 0xcf, 0x37, 0x92, 0x05, 0xe6, 0x42, 0x39, 0x73, 0xd3, 0x32,
	0x9d, 0x78, 0xc8, 0xfd, 0x12, 0x6c, 0x2a, 0xc6, 0x03, 0xd6, 0x9d, 0x08, 0x74, 0x71, 0x8e, 0x40,
	0x15, 0xe3, 0x5f, 0x76, 0x47, 0x03, 0xcd, 0xc1, 0x43, 0xdf, 0xe2, 0x46, 0x01, 0x8e, 0x22, 0x5b,
	0x16, 0x32, 0xc0, 0x2a, 0x98, 0x9c, 0x80, 0xfb, 0x11, 0x34, 0xd3, 0xc9, 0xbb, 0x03, 0x5c, 0x33,
	0x8a, 0xcc, 0xd2, 0xcb, 0xa6, 0x7a, 0x3a, 0x36, 0x1b, 0xf8, 0x0a, 0xec, 0x8c, 0xb9, 0xd5, 0x25,
	0x79, 0xbe, 0xd3, 0x2b, 0xe5, 0x4e, 0xef, 0x8d, 0x38, 0x65, 0x52, 0x4d, 0xba, 0x6c, 0xd0, 0xef,
	0x9a, 0x5d, 0xf0, 0x60, 0x58, 0x4f, 0xee, 0x8a, 0x53, 0xa9, 0x77, 0x83, 0xda, 0xc4, 0x3f, 0xbd,
	0x9f, 0xdb, 0x8d, 0x80, 0x08, 0x59, 0xfb, 0xc6, 0x5f, 0x7e, 0x5b, 0xc3, 0x23, 0x66, 0xb8, 0xf6,
	0xcd, 0xe4, 0xff, 0xd6, 0x6f, 0xf7, 0x96, 0xc1, 0xd2, 0xe0, 0x6e, 0xef, 0x2f, 0x0b, 0xe0, 0x7e,
	0xc8, 0xd2, 0xf2, 0x73, 0xc3, 0xde, 0xc6, 0x78, 0x0c, 0x2d, 0x3d, 0xd5, 0x56, 0xe5, 0xb7, 0xbf,
	0x72, 0xda, 0x98, 0x25, 0x38, 0x8b, 0xab, 0x4c, 0xc4, 0xb5, 0x98, 0x64, 0x26, 0x11, 0xb5, 0xe1,
	0x34, 0x66, 0xfc, 0x1e, 0xff, 0x78, 0x70, 0xf5, 0x8f, 0x85, 0xc5, 0x83, 0x66, 0xf3, 0x9f, 0x0b,
	0x77, 0x0f, 0x2c, 0xb2, 0x19, 0xc9, 0xaa, 0xbd, 0xd4, 0x57, 0xa7, 0xf5, 0x6a, 0xdb, 0x5b, 0xfe,
	0xdb, 0xdb, 0x9c, 0x35, 0x23, 0x79, 0x36, 0xb0, 0x39, 0x3b, 0xad, 0x9f, 0x0d, 0x6c, 0xbe, 0x5b,
	0xb8, 0x6f, 0x1f, 0x34, 0x1a, 0xcd, 0x48, 0x36, 0x1a, 0x03, 0xab, 0x46, 0xe3, 0xb4, 0xde, 0x68,
	0x0c, 0xec, 0x3a, 0x57, 0x4d, 0xb0, 0xf5, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0x85, 0xc4, 0x27,
	0x91, 0xca, 0x17, 0x00, 0x00,
}
