// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/resources/user_list.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v3/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A user list. This is a list of users a customer may target.
type UserList struct {
	// The resource name of the user list.
	// User list resource names have the form:
	//
	// `customers/{customer_id}/userLists/{user_list_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Id of the user list.
	Id *wrappers.Int64Value `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// A flag that indicates if a user may edit a list. Depends on the list
	// ownership and list type. For example, external remarketing user lists are
	// not editable.
	//
	// This field is read-only.
	ReadOnly *wrappers.BoolValue `protobuf:"bytes,3,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	// Name of this user list. Depending on its access_reason, the user list name
	// may not be unique (e.g. if access_reason=SHARED)
	Name *wrappers.StringValue `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of this user list.
	Description *wrappers.StringValue `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Membership status of this user list. Indicates whether a user list is open
	// or active. Only open user lists can accumulate more users and can be
	// targeted to.
	MembershipStatus enums.UserListMembershipStatusEnum_UserListMembershipStatus `protobuf:"varint,6,opt,name=membership_status,json=membershipStatus,proto3,enum=google.ads.googleads.v3.enums.UserListMembershipStatusEnum_UserListMembershipStatus" json:"membership_status,omitempty"`
	// An ID from external system. It is used by user list sellers to correlate
	// IDs on their systems.
	IntegrationCode *wrappers.StringValue `protobuf:"bytes,7,opt,name=integration_code,json=integrationCode,proto3" json:"integration_code,omitempty"`
	// Number of days a user's cookie stays on your list since its most recent
	// addition to the list. This field must be between 0 and 540 inclusive.
	// However, for CRM based userlists, this field can be set to 10000 which
	// means no expiration.
	//
	// It'll be ignored for logical_user_list.
	MembershipLifeSpan *wrappers.Int64Value `protobuf:"bytes,8,opt,name=membership_life_span,json=membershipLifeSpan,proto3" json:"membership_life_span,omitempty"`
	// Estimated number of users in this user list, on the Google Display Network.
	// This value is null if the number of users has not yet been determined.
	//
	// This field is read-only.
	SizeForDisplay *wrappers.Int64Value `protobuf:"bytes,9,opt,name=size_for_display,json=sizeForDisplay,proto3" json:"size_for_display,omitempty"`
	// Size range in terms of number of users of the UserList, on the Google
	// Display Network.
	//
	// This field is read-only.
	SizeRangeForDisplay enums.UserListSizeRangeEnum_UserListSizeRange `protobuf:"varint,10,opt,name=size_range_for_display,json=sizeRangeForDisplay,proto3,enum=google.ads.googleads.v3.enums.UserListSizeRangeEnum_UserListSizeRange" json:"size_range_for_display,omitempty"`
	// Estimated number of users in this user list in the google.com domain.
	// These are the users available for targeting in Search campaigns.
	// This value is null if the number of users has not yet been determined.
	//
	// This field is read-only.
	SizeForSearch *wrappers.Int64Value `protobuf:"bytes,11,opt,name=size_for_search,json=sizeForSearch,proto3" json:"size_for_search,omitempty"`
	// Size range in terms of number of users of the UserList, for Search ads.
	//
	// This field is read-only.
	SizeRangeForSearch enums.UserListSizeRangeEnum_UserListSizeRange `protobuf:"varint,12,opt,name=size_range_for_search,json=sizeRangeForSearch,proto3,enum=google.ads.googleads.v3.enums.UserListSizeRangeEnum_UserListSizeRange" json:"size_range_for_search,omitempty"`
	// Type of this list.
	//
	// This field is read-only.
	Type enums.UserListTypeEnum_UserListType `protobuf:"varint,13,opt,name=type,proto3,enum=google.ads.googleads.v3.enums.UserListTypeEnum_UserListType" json:"type,omitempty"`
	// Indicating the reason why this user list membership status is closed. It is
	// only populated on lists that were automatically closed due to inactivity,
	// and will be cleared once the list membership status becomes open.
	ClosingReason enums.UserListClosingReasonEnum_UserListClosingReason `protobuf:"varint,14,opt,name=closing_reason,json=closingReason,proto3,enum=google.ads.googleads.v3.enums.UserListClosingReasonEnum_UserListClosingReason" json:"closing_reason,omitempty"`
	// Indicates the reason this account has been granted access to the list.
	// The reason can be SHARED, OWNED, LICENSED or SUBSCRIBED.
	//
	// This field is read-only.
	AccessReason enums.AccessReasonEnum_AccessReason `protobuf:"varint,15,opt,name=access_reason,json=accessReason,proto3,enum=google.ads.googleads.v3.enums.AccessReasonEnum_AccessReason" json:"access_reason,omitempty"`
	// Indicates if this share is still enabled. When a UserList is shared with
	// the user this field is set to ENABLED. Later the userList owner can decide
	// to revoke the share and make it DISABLED.
	// The default value of this field is set to ENABLED.
	AccountUserListStatus enums.UserListAccessStatusEnum_UserListAccessStatus `protobuf:"varint,16,opt,name=account_user_list_status,json=accountUserListStatus,proto3,enum=google.ads.googleads.v3.enums.UserListAccessStatusEnum_UserListAccessStatus" json:"account_user_list_status,omitempty"`
	// Indicates if this user list is eligible for Google Search Network.
	EligibleForSearch *wrappers.BoolValue `protobuf:"bytes,17,opt,name=eligible_for_search,json=eligibleForSearch,proto3" json:"eligible_for_search,omitempty"`
	// Indicates this user list is eligible for Google Display Network.
	//
	// This field is read-only.
	EligibleForDisplay *wrappers.BoolValue `protobuf:"bytes,18,opt,name=eligible_for_display,json=eligibleForDisplay,proto3" json:"eligible_for_display,omitempty"`
	// The user list.
	//
	// Exactly one must be set.
	//
	// Types that are valid to be assigned to UserList:
	//	*UserList_CrmBasedUserList
	//	*UserList_SimilarUserList
	//	*UserList_RuleBasedUserList
	//	*UserList_LogicalUserList
	//	*UserList_BasicUserList
	UserList             isUserList_UserList `protobuf_oneof:"user_list"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *UserList) Reset()         { *m = UserList{} }
func (m *UserList) String() string { return proto.CompactTextString(m) }
func (*UserList) ProtoMessage()    {}
func (*UserList) Descriptor() ([]byte, []int) {
	return fileDescriptor_2efbaf923f128250, []int{0}
}

func (m *UserList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserList.Unmarshal(m, b)
}
func (m *UserList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserList.Marshal(b, m, deterministic)
}
func (m *UserList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserList.Merge(m, src)
}
func (m *UserList) XXX_Size() int {
	return xxx_messageInfo_UserList.Size(m)
}
func (m *UserList) XXX_DiscardUnknown() {
	xxx_messageInfo_UserList.DiscardUnknown(m)
}

var xxx_messageInfo_UserList proto.InternalMessageInfo

func (m *UserList) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *UserList) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *UserList) GetReadOnly() *wrappers.BoolValue {
	if m != nil {
		return m.ReadOnly
	}
	return nil
}

func (m *UserList) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *UserList) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *UserList) GetMembershipStatus() enums.UserListMembershipStatusEnum_UserListMembershipStatus {
	if m != nil {
		return m.MembershipStatus
	}
	return enums.UserListMembershipStatusEnum_UNSPECIFIED
}

func (m *UserList) GetIntegrationCode() *wrappers.StringValue {
	if m != nil {
		return m.IntegrationCode
	}
	return nil
}

func (m *UserList) GetMembershipLifeSpan() *wrappers.Int64Value {
	if m != nil {
		return m.MembershipLifeSpan
	}
	return nil
}

func (m *UserList) GetSizeForDisplay() *wrappers.Int64Value {
	if m != nil {
		return m.SizeForDisplay
	}
	return nil
}

func (m *UserList) GetSizeRangeForDisplay() enums.UserListSizeRangeEnum_UserListSizeRange {
	if m != nil {
		return m.SizeRangeForDisplay
	}
	return enums.UserListSizeRangeEnum_UNSPECIFIED
}

func (m *UserList) GetSizeForSearch() *wrappers.Int64Value {
	if m != nil {
		return m.SizeForSearch
	}
	return nil
}

func (m *UserList) GetSizeRangeForSearch() enums.UserListSizeRangeEnum_UserListSizeRange {
	if m != nil {
		return m.SizeRangeForSearch
	}
	return enums.UserListSizeRangeEnum_UNSPECIFIED
}

func (m *UserList) GetType() enums.UserListTypeEnum_UserListType {
	if m != nil {
		return m.Type
	}
	return enums.UserListTypeEnum_UNSPECIFIED
}

func (m *UserList) GetClosingReason() enums.UserListClosingReasonEnum_UserListClosingReason {
	if m != nil {
		return m.ClosingReason
	}
	return enums.UserListClosingReasonEnum_UNSPECIFIED
}

func (m *UserList) GetAccessReason() enums.AccessReasonEnum_AccessReason {
	if m != nil {
		return m.AccessReason
	}
	return enums.AccessReasonEnum_UNSPECIFIED
}

func (m *UserList) GetAccountUserListStatus() enums.UserListAccessStatusEnum_UserListAccessStatus {
	if m != nil {
		return m.AccountUserListStatus
	}
	return enums.UserListAccessStatusEnum_UNSPECIFIED
}

func (m *UserList) GetEligibleForSearch() *wrappers.BoolValue {
	if m != nil {
		return m.EligibleForSearch
	}
	return nil
}

func (m *UserList) GetEligibleForDisplay() *wrappers.BoolValue {
	if m != nil {
		return m.EligibleForDisplay
	}
	return nil
}

type isUserList_UserList interface {
	isUserList_UserList()
}

type UserList_CrmBasedUserList struct {
	CrmBasedUserList *common.CrmBasedUserListInfo `protobuf:"bytes,19,opt,name=crm_based_user_list,json=crmBasedUserList,proto3,oneof"`
}

type UserList_SimilarUserList struct {
	SimilarUserList *common.SimilarUserListInfo `protobuf:"bytes,20,opt,name=similar_user_list,json=similarUserList,proto3,oneof"`
}

type UserList_RuleBasedUserList struct {
	RuleBasedUserList *common.RuleBasedUserListInfo `protobuf:"bytes,21,opt,name=rule_based_user_list,json=ruleBasedUserList,proto3,oneof"`
}

type UserList_LogicalUserList struct {
	LogicalUserList *common.LogicalUserListInfo `protobuf:"bytes,22,opt,name=logical_user_list,json=logicalUserList,proto3,oneof"`
}

type UserList_BasicUserList struct {
	BasicUserList *common.BasicUserListInfo `protobuf:"bytes,23,opt,name=basic_user_list,json=basicUserList,proto3,oneof"`
}

func (*UserList_CrmBasedUserList) isUserList_UserList() {}

func (*UserList_SimilarUserList) isUserList_UserList() {}

func (*UserList_RuleBasedUserList) isUserList_UserList() {}

func (*UserList_LogicalUserList) isUserList_UserList() {}

func (*UserList_BasicUserList) isUserList_UserList() {}

func (m *UserList) GetUserList() isUserList_UserList {
	if m != nil {
		return m.UserList
	}
	return nil
}

func (m *UserList) GetCrmBasedUserList() *common.CrmBasedUserListInfo {
	if x, ok := m.GetUserList().(*UserList_CrmBasedUserList); ok {
		return x.CrmBasedUserList
	}
	return nil
}

func (m *UserList) GetSimilarUserList() *common.SimilarUserListInfo {
	if x, ok := m.GetUserList().(*UserList_SimilarUserList); ok {
		return x.SimilarUserList
	}
	return nil
}

func (m *UserList) GetRuleBasedUserList() *common.RuleBasedUserListInfo {
	if x, ok := m.GetUserList().(*UserList_RuleBasedUserList); ok {
		return x.RuleBasedUserList
	}
	return nil
}

func (m *UserList) GetLogicalUserList() *common.LogicalUserListInfo {
	if x, ok := m.GetUserList().(*UserList_LogicalUserList); ok {
		return x.LogicalUserList
	}
	return nil
}

func (m *UserList) GetBasicUserList() *common.BasicUserListInfo {
	if x, ok := m.GetUserList().(*UserList_BasicUserList); ok {
		return x.BasicUserList
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*UserList) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*UserList_CrmBasedUserList)(nil),
		(*UserList_SimilarUserList)(nil),
		(*UserList_RuleBasedUserList)(nil),
		(*UserList_LogicalUserList)(nil),
		(*UserList_BasicUserList)(nil),
	}
}

func init() {
	proto.RegisterType((*UserList)(nil), "google.ads.googleads.v3.resources.UserList")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/resources/user_list.proto", fileDescriptor_2efbaf923f128250)
}

var fileDescriptor_2efbaf923f128250 = []byte{
	// 969 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x96, 0xdd, 0x6e, 0xdb, 0x36,
	0x14, 0xc7, 0x67, 0x37, 0xeb, 0x12, 0x26, 0x8e, 0x6d, 0x26, 0xe9, 0xb4, 0xac, 0x18, 0x92, 0x0d,
	0x05, 0x82, 0x0d, 0x90, 0xd6, 0xb8, 0xfb, 0x80, 0x5a, 0x6c, 0xb0, 0xb3, 0x36, 0x6b, 0xe1, 0xb6,
	0x81, 0xdc, 0xe5, 0x62, 0x0b, 0x20, 0xd0, 0x12, 0xad, 0x10, 0xa0, 0x48, 0x81, 0x94, 0x3a, 0xb8,
	0x41, 0x2f, 0x76, 0xb1, 0x17, 0xd9, 0xe5, 0x1e, 0xa5, 0x8f, 0xd2, 0x47, 0xd8, 0xd5, 0x20, 0xea,
	0xc3, 0x94, 0x53, 0x57, 0xba, 0xe8, 0x1d, 0x75, 0xce, 0xf9, 0xfd, 0xff, 0x3c, 0xfc, 0x90, 0x04,
	0xee, 0x06, 0x9c, 0x07, 0x14, 0x5b, 0xc8, 0x97, 0x56, 0x36, 0x4c, 0x47, 0x2f, 0x07, 0x96, 0xc0,
	0x92, 0x27, 0xc2, 0xc3, 0xd2, 0x4a, 0x24, 0x16, 0x2e, 0x25, 0x32, 0x36, 0x23, 0xc1, 0x63, 0x0e,
	0x0f, 0xb3, 0x3a, 0x13, 0xf9, 0xd2, 0x2c, 0x11, 0xf3, 0xe5, 0xc0, 0x2c, 0x91, 0x7d, 0x6b, 0x95,
	0xaa, 0xc7, 0xc3, 0x90, 0xb3, 0x85, 0xa4, 0xcc, 0x34, 0xf7, 0x57, 0x4e, 0x03, 0xb3, 0x24, 0x94,
	0x16, 0xf2, 0x3c, 0x2c, 0xa5, 0x2b, 0x30, 0x92, 0x9c, 0xe5, 0xc8, 0xfd, 0xf7, 0x23, 0xa5, 0x85,
	0x9b, 0xc3, 0x32, 0x46, 0x71, 0x52, 0xf8, 0x3d, 0x68, 0x0a, 0x7b, 0x94, 0x4b, 0xc2, 0x82, 0xaa,
	0xf5, 0xcf, 0x4d, 0xe9, 0x10, 0x87, 0x53, 0x2c, 0xe4, 0x25, 0x89, 0xaa, 0xf6, 0x3f, 0x36, 0x15,
	0x90, 0xe4, 0x15, 0x76, 0x05, 0x62, 0x01, 0xce, 0xc9, 0xe3, 0xa6, 0x64, 0x3c, 0x8f, 0x0a, 0xe6,
	0xb3, 0x82, 0x89, 0x48, 0xb9, 0xad, 0x79, 0xea, 0x8b, 0x3c, 0xa5, 0x9e, 0xa6, 0xc9, 0xcc, 0xfa,
	0x53, 0xa0, 0x28, 0xc2, 0xa2, 0x98, 0xe8, 0x6d, 0x0d, 0x45, 0x8c, 0xf1, 0x18, 0xc5, 0x84, 0xb3,
	0x3c, 0xfb, 0xe5, 0x9b, 0x1e, 0x58, 0xff, 0x4d, 0x62, 0x31, 0x26, 0x32, 0x86, 0x5f, 0x81, 0x4e,
	0x21, 0xee, 0x32, 0x14, 0x62, 0xa3, 0x75, 0xd0, 0x3a, 0xda, 0x70, 0xb6, 0x8a, 0xe0, 0x33, 0x14,
	0x62, 0xf8, 0x0d, 0x68, 0x13, 0xdf, 0x68, 0x1f, 0xb4, 0x8e, 0x36, 0x8f, 0x3f, 0xcf, 0x4f, 0x8f,
	0x59, 0x98, 0x9b, 0x8f, 0x59, 0xfc, 0xfd, 0xbd, 0x73, 0x44, 0x13, 0xec, 0xb4, 0x89, 0x0f, 0x7f,
	0x00, 0x1b, 0x02, 0x23, 0xdf, 0xe5, 0x8c, 0xce, 0x8d, 0x1b, 0x8a, 0xd9, 0xbf, 0xc6, 0x8c, 0x38,
	0xa7, 0x19, 0xb2, 0x9e, 0x16, 0x3f, 0x67, 0x74, 0x0e, 0xbf, 0x05, 0x6b, 0x6a, 0x06, 0x6b, 0x8a,
	0xb9, 0x7d, 0x8d, 0x99, 0xc4, 0x82, 0xb0, 0x20, 0xa3, 0x54, 0x25, 0xfc, 0x09, 0x6c, 0xfa, 0x58,
	0x7a, 0x82, 0x44, 0x69, 0x7f, 0xc6, 0xc7, 0x0d, 0x40, 0x1d, 0x80, 0x7f, 0xb5, 0x40, 0xff, 0xda,
	0x66, 0x1b, 0x37, 0x0f, 0x5a, 0x47, 0xdb, 0xc7, 0x2f, 0xcc, 0x55, 0x17, 0x46, 0xed, 0x99, 0x59,
	0xac, 0xe0, 0xd3, 0x92, 0x9f, 0x28, 0xfc, 0x21, 0x4b, 0xc2, 0x95, 0x49, 0xa7, 0x17, 0x2e, 0x45,
	0xe0, 0x29, 0xe8, 0x11, 0x16, 0xe3, 0x40, 0xa8, 0x3d, 0x72, 0x3d, 0xee, 0x63, 0xe3, 0x93, 0x06,
	0x8d, 0x74, 0x35, 0xea, 0x84, 0xfb, 0x18, 0x3e, 0x05, 0xbb, 0x5a, 0x2f, 0x94, 0xcc, 0xb0, 0x2b,
	0x23, 0xc4, 0x8c, 0xf5, 0xfa, 0x6d, 0x83, 0x0b, 0x70, 0x4c, 0x66, 0x78, 0x12, 0x21, 0x06, 0x1f,
	0x82, 0x9e, 0x3a, 0xc6, 0x33, 0x2e, 0x5c, 0x9f, 0xc8, 0x88, 0xa2, 0xb9, 0xb1, 0x51, 0x2f, 0xb5,
	0x9d, 0x42, 0x8f, 0xb8, 0xf8, 0x25, 0x43, 0xe0, 0x15, 0xb8, 0xb5, 0xb8, 0x0d, 0x15, 0x31, 0xa0,
	0x96, 0xf9, 0x51, 0xc3, 0x65, 0x9e, 0x90, 0x57, 0xd8, 0x49, 0x35, 0x2a, 0xeb, 0x5b, 0x46, 0x9d,
	0x1d, 0x59, 0x0c, 0x35, 0xf3, 0x13, 0xd0, 0x2d, 0x7b, 0x90, 0x18, 0x09, 0xef, 0xd2, 0xd8, 0xac,
	0x6f, 0xa1, 0x93, 0xb7, 0x30, 0x51, 0x04, 0x9c, 0x83, 0xbd, 0xa5, 0x0e, 0x72, 0xa9, 0xad, 0x0f,
	0xda, 0x00, 0xd4, 0x1b, 0xc8, 0xad, 0xcf, 0xc0, 0x5a, 0xfa, 0x42, 0x30, 0x3a, 0xca, 0xe9, 0x41,
	0x43, 0xa7, 0x17, 0xf3, 0xa8, 0x6a, 0x92, 0x06, 0x1c, 0xa5, 0x04, 0x13, 0xb0, 0x5d, 0x7d, 0x37,
	0x1a, 0xdb, 0x4a, 0xfb, 0x59, 0x43, 0xed, 0x93, 0x0c, 0x76, 0x14, 0x5b, 0x31, 0xa9, 0x64, 0x9c,
	0x8e, 0xa7, 0x3f, 0x42, 0x04, 0x3a, 0x95, 0x8f, 0x81, 0xd1, 0x6d, 0xd4, 0xd1, 0x50, 0x31, 0x9a,
	0x99, 0x1e, 0x70, 0xb6, 0x90, 0xf6, 0x04, 0xff, 0x6e, 0x01, 0x03, 0x79, 0x1e, 0x4f, 0x58, 0xec,
	0x6a, 0x6f, 0xe2, 0xec, 0x4a, 0xf7, 0x94, 0xdd, 0xb8, 0x61, 0x93, 0x99, 0xcb, 0x3b, 0xae, 0xb3,
	0x9e, 0x70, 0xf6, 0x72, 0xb7, 0x72, 0x2b, 0xb3, 0xfb, 0xfc, 0x04, 0xec, 0x60, 0x4a, 0x02, 0x32,
	0xa5, 0x95, 0xc3, 0xd2, 0xaf, 0x7d, 0x11, 0xf6, 0x0b, 0x6c, 0xb1, 0xff, 0x63, 0xb0, 0x5b, 0xd1,
	0x2a, 0xae, 0x0e, 0xac, 0x15, 0x83, 0x9a, 0x58, 0x71, 0x1b, 0x30, 0xd8, 0xf1, 0x44, 0xe8, 0x4e,
	0x91, 0xc4, 0xfe, 0x62, 0x89, 0x8c, 0x1d, 0x25, 0x76, 0x6f, 0xe5, 0xda, 0x64, 0x1f, 0x7f, 0xf3,
	0x44, 0x84, 0xa3, 0x94, 0x2c, 0xda, 0x7d, 0xcc, 0x66, 0xfc, 0xd7, 0x8f, 0x9c, 0x9e, 0xb7, 0x14,
	0x87, 0x08, 0xf4, 0x25, 0x09, 0x09, 0x45, 0x42, 0x33, 0xd9, 0x55, 0x26, 0x83, 0x3a, 0x93, 0x49,
	0x06, 0x2e, 0x79, 0x74, 0x65, 0x35, 0x0c, 0x2f, 0xc1, 0xae, 0x48, 0x28, 0xbe, 0xd6, 0xca, 0x9e,
	0x72, 0xf9, 0xae, 0xce, 0xc5, 0x49, 0x28, 0x7e, 0x57, 0x2f, 0x7d, 0xb1, 0x9c, 0x48, 0x9b, 0xa1,
	0x3c, 0x20, 0x1e, 0xa2, 0x9a, 0xcd, 0xad, 0x66, 0xcd, 0x8c, 0x33, 0x70, 0xb9, 0x19, 0x5a, 0x0d,
	0xc3, 0x3f, 0x40, 0x77, 0x8a, 0x24, 0xf1, 0x34, 0x83, 0x4f, 0x95, 0xc1, 0xdd, 0x3a, 0x83, 0x51,
	0x8a, 0x2d, 0xc9, 0x77, 0xa6, 0x7a, 0xd0, 0x76, 0xde, 0x0e, 0x9f, 0x83, 0xc3, 0x05, 0x9c, 0x8f,
	0x22, 0x22, 0x53, 0x11, 0xab, 0x9c, 0xc4, 0xd7, 0x5e, 0x22, 0x63, 0x1e, 0x62, 0x21, 0xad, 0xab,
	0x62, 0xf8, 0x5a, 0xfd, 0x97, 0xa4, 0x69, 0x69, 0x5d, 0x95, 0x93, 0x7b, 0x3d, 0xda, 0x04, 0x1b,
	0xe5, 0xd3, 0xe8, 0xbf, 0x16, 0xb8, 0xe3, 0xf1, 0xd0, 0xac, 0xfd, 0xbb, 0x1c, 0x75, 0x0a, 0xb3,
	0xb3, 0xf4, 0xb8, 0x9e, 0xb5, 0x7e, 0x7f, 0x92, 0x33, 0x01, 0xa7, 0x88, 0x05, 0x26, 0x17, 0x81,
	0x15, 0x60, 0xa6, 0x0e, 0xb3, 0xb5, 0x98, 0xe7, 0x7b, 0xfe, 0x71, 0xef, 0x97, 0xa3, 0x7f, 0xda,
	0x37, 0x4e, 0x87, 0xc3, 0x7f, 0xdb, 0x87, 0xa7, 0x99, 0xe4, 0xd0, 0x97, 0x66, 0x36, 0x4c, 0x47,
	0xe7, 0x03, 0xd3, 0x29, 0x2a, 0xdf, 0x14, 0x35, 0x17, 0x43, 0x5f, 0x5e, 0x94, 0x35, 0x17, 0xe7,
	0x83, 0x8b, 0xb2, 0xe6, 0x6d, 0xfb, 0x4e, 0x96, 0xb0, 0xed, 0xa1, 0x2f, 0x6d, 0xbb, 0xac, 0xb2,
	0xed, 0xf3, 0x81, 0x6d, 0x97, 0x75, 0xd3, 0x9b, 0x6a, 0xb2, 0x83, 0xff, 0x03, 0x00, 0x00, 0xff,
	0xff, 0x60, 0x1d, 0x81, 0x7b, 0x8f, 0x0b, 0x00, 0x00,
}
