// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

package database

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Indicates the current state of the database.
type Database_State int32

const (
	// Not specified.
	Database_STATE_UNSPECIFIED Database_State = 0
	// The database is still being created. Operations on the database may fail
	// with `FAILED_PRECONDITION` in this state.
	Database_CREATING Database_State = 1
	// The database is fully created and ready for use.
	Database_READY Database_State = 2
)

var Database_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATING",
	2: "READY",
}

var Database_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATING":          1,
	"READY":             2,
}

func (x Database_State) String() string {
	return proto.EnumName(Database_State_name, int32(x))
}

func (Database_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9422939aee7fc2d7, []int{0, 0}
}

// A Cloud Spanner database.
type Database struct {
	// Required. The name of the database. Values are of the form
	// `projects/<project>/instances/<instance>/databases/<database>`,
	// where `<database>` is as specified in the `CREATE DATABASE`
	// statement. This name can be passed to other API methods to
	// identify the database.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The current database state.
	State                Database_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.spanner.admin.database.v1.Database_State" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Database) Reset()         { *m = Database{} }
func (m *Database) String() string { return proto.CompactTextString(m) }
func (*Database) ProtoMessage()    {}
func (*Database) Descriptor() ([]byte, []int) {
	return fileDescriptor_9422939aee7fc2d7, []int{0}
}

func (m *Database) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Database.Unmarshal(m, b)
}
func (m *Database) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Database.Marshal(b, m, deterministic)
}
func (m *Database) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Database.Merge(m, src)
}
func (m *Database) XXX_Size() int {
	return xxx_messageInfo_Database.Size(m)
}
func (m *Database) XXX_DiscardUnknown() {
	xxx_messageInfo_Database.DiscardUnknown(m)
}

var xxx_messageInfo_Database proto.InternalMessageInfo

func (m *Database) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Database) GetState() Database_State {
	if m != nil {
		return m.State
	}
	return Database_STATE_UNSPECIFIED
}

// The request for [ListDatabases][google.spanner.admin.database.v1.DatabaseAdmin.ListDatabases].
type ListDatabasesRequest struct {
	// Required. The instance whose databases should be listed.
	// Values are of the form `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of databases to be returned in the response. If 0 or less,
	// defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.database.v1.ListDatabasesResponse.next_page_token] from a
	// previous [ListDatabasesResponse][google.spanner.admin.database.v1.ListDatabasesResponse].
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatabasesRequest) Reset()         { *m = ListDatabasesRequest{} }
func (m *ListDatabasesRequest) String() string { return proto.CompactTextString(m) }
func (*ListDatabasesRequest) ProtoMessage()    {}
func (*ListDatabasesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9422939aee7fc2d7, []int{1}
}

func (m *ListDatabasesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatabasesRequest.Unmarshal(m, b)
}
func (m *ListDatabasesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatabasesRequest.Marshal(b, m, deterministic)
}
func (m *ListDatabasesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatabasesRequest.Merge(m, src)
}
func (m *ListDatabasesRequest) XXX_Size() int {
	return xxx_messageInfo_ListDatabasesRequest.Size(m)
}
func (m *ListDatabasesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatabasesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatabasesRequest proto.InternalMessageInfo

func (m *ListDatabasesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDatabasesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDatabasesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for [ListDatabases][google.spanner.admin.database.v1.DatabaseAdmin.ListDatabases].
type ListDatabasesResponse struct {
	// Databases that matched the request.
	Databases []*Database `protobuf:"bytes,1,rep,name=databases,proto3" json:"databases,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListDatabases][google.spanner.admin.database.v1.DatabaseAdmin.ListDatabases] call to fetch more
	// of the matching databases.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatabasesResponse) Reset()         { *m = ListDatabasesResponse{} }
func (m *ListDatabasesResponse) String() string { return proto.CompactTextString(m) }
func (*ListDatabasesResponse) ProtoMessage()    {}
func (*ListDatabasesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9422939aee7fc2d7, []int{2}
}

func (m *ListDatabasesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatabasesResponse.Unmarshal(m, b)
}
func (m *ListDatabasesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatabasesResponse.Marshal(b, m, deterministic)
}
func (m *ListDatabasesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatabasesResponse.Merge(m, src)
}
func (m *ListDatabasesResponse) XXX_Size() int {
	return xxx_messageInfo_ListDatabasesResponse.Size(m)
}
func (m *ListDatabasesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatabasesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatabasesResponse proto.InternalMessageInfo

func (m *ListDatabasesResponse) GetDatabases() []*Database {
	if m != nil {
		return m.Databases
	}
	return nil
}

func (m *ListDatabasesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for [CreateDatabase][google.spanner.admin.database.v1.DatabaseAdmin.CreateDatabase].
type CreateDatabaseRequest struct {
	// Required. The name of the instance that will serve the new database.
	// Values are of the form `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A `CREATE DATABASE` statement, which specifies the ID of the
	// new database.  The database ID must conform to the regular expression
	// `[a-z][a-z0-9_\-]*[a-z0-9]` and be between 2 and 30 characters in length.
	// If the database ID is a reserved word or if it contains a hyphen, the
	// database ID must be enclosed in backticks (`` ` ``).
	CreateStatement string `protobuf:"bytes,2,opt,name=create_statement,json=createStatement,proto3" json:"create_statement,omitempty"`
	// An optional list of DDL statements to run inside the newly created
	// database. Statements can create tables, indexes, etc. These
	// statements execute atomically with the creation of the database:
	// if there is an error in any statement, the database is not created.
	ExtraStatements      []string `protobuf:"bytes,3,rep,name=extra_statements,json=extraStatements,proto3" json:"extra_statements,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDatabaseRequest) Reset()         { *m = CreateDatabaseRequest{} }
func (m *CreateDatabaseRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDatabaseRequest) ProtoMessage()    {}
func (*CreateDatabaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9422939aee7fc2d7, []int{3}
}

func (m *CreateDatabaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDatabaseRequest.Unmarshal(m, b)
}
func (m *CreateDatabaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDatabaseRequest.Marshal(b, m, deterministic)
}
func (m *CreateDatabaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDatabaseRequest.Merge(m, src)
}
func (m *CreateDatabaseRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDatabaseRequest.Size(m)
}
func (m *CreateDatabaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDatabaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDatabaseRequest proto.InternalMessageInfo

func (m *CreateDatabaseRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDatabaseRequest) GetCreateStatement() string {
	if m != nil {
		return m.CreateStatement
	}
	return ""
}

func (m *CreateDatabaseRequest) GetExtraStatements() []string {
	if m != nil {
		return m.ExtraStatements
	}
	return nil
}

// Metadata type for the operation returned by
// [CreateDatabase][google.spanner.admin.database.v1.DatabaseAdmin.CreateDatabase].
type CreateDatabaseMetadata struct {
	// The database being created.
	Database             string   `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDatabaseMetadata) Reset()         { *m = CreateDatabaseMetadata{} }
func (m *CreateDatabaseMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateDatabaseMetadata) ProtoMessage()    {}
func (*CreateDatabaseMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_9422939aee7fc2d7, []int{4}
}

func (m *CreateDatabaseMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDatabaseMetadata.Unmarshal(m, b)
}
func (m *CreateDatabaseMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDatabaseMetadata.Marshal(b, m, deterministic)
}
func (m *CreateDatabaseMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDatabaseMetadata.Merge(m, src)
}
func (m *CreateDatabaseMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateDatabaseMetadata.Size(m)
}
func (m *CreateDatabaseMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDatabaseMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDatabaseMetadata proto.InternalMessageInfo

func (m *CreateDatabaseMetadata) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

// The request for [GetDatabase][google.spanner.admin.database.v1.DatabaseAdmin.GetDatabase].
type GetDatabaseRequest struct {
	// Required. The name of the requested database. Values are of the form
	// `projects/<project>/instances/<instance>/databases/<database>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDatabaseRequest) Reset()         { *m = GetDatabaseRequest{} }
func (m *GetDatabaseRequest) String() string { return proto.CompactTextString(m) }
func (*GetDatabaseRequest) ProtoMessage()    {}
func (*GetDatabaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9422939aee7fc2d7, []int{5}
}

func (m *GetDatabaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDatabaseRequest.Unmarshal(m, b)
}
func (m *GetDatabaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDatabaseRequest.Marshal(b, m, deterministic)
}
func (m *GetDatabaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDatabaseRequest.Merge(m, src)
}
func (m *GetDatabaseRequest) XXX_Size() int {
	return xxx_messageInfo_GetDatabaseRequest.Size(m)
}
func (m *GetDatabaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDatabaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDatabaseRequest proto.InternalMessageInfo

func (m *GetDatabaseRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Enqueues the given DDL statements to be applied, in order but not
// necessarily all at once, to the database schema at some point (or
// points) in the future. The server checks that the statements
// are executable (syntactically valid, name tables that exist, etc.)
// before enqueueing them, but they may still fail upon
// later execution (e.g., if a statement from another batch of
// statements is applied first and it conflicts in some way, or if
// there is some data-related problem like a `NULL` value in a column to
// which `NOT NULL` would be added). If a statement fails, all
// subsequent statements in the batch are automatically cancelled.
//
// Each batch of statements is assigned a name which can be used with
// the [Operations][google.longrunning.Operations] API to monitor
// progress. See the
// [operation_id][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.operation_id] field for more
// details.
type UpdateDatabaseDdlRequest struct {
	// Required. The database to update.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Required. DDL statements to be applied to the database.
	Statements []string `protobuf:"bytes,2,rep,name=statements,proto3" json:"statements,omitempty"`
	// If empty, the new update request is assigned an
	// automatically-generated operation ID. Otherwise, `operation_id`
	// is used to construct the name of the resulting
	// [Operation][google.longrunning.Operation].
	//
	// Specifying an explicit operation ID simplifies determining
	// whether the statements were executed in the event that the
	// [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] call is replayed,
	// or the return value is otherwise lost: the [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database] and
	// `operation_id` fields can be combined to form the
	// [name][google.longrunning.Operation.name] of the resulting
	// [longrunning.Operation][google.longrunning.Operation]: `<database>/operations/<operation_id>`.
	//
	// `operation_id` should be unique within the database, and must be
	// a valid identifier: `[a-z][a-z0-9_]*`. Note that
	// automatically-generated operation IDs always begin with an
	// underscore. If the named operation already exists,
	// [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] returns
	// `ALREADY_EXISTS`.
	OperationId          string   `protobuf:"bytes,3,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateDatabaseDdlRequest) Reset()         { *m = UpdateDatabaseDdlRequest{} }
func (m *UpdateDatabaseDdlRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDatabaseDdlRequest) ProtoMessage()    {}
func (*UpdateDatabaseDdlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9422939aee7fc2d7, []int{6}
}

func (m *UpdateDatabaseDdlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDatabaseDdlRequest.Unmarshal(m, b)
}
func (m *UpdateDatabaseDdlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDatabaseDdlRequest.Marshal(b, m, deterministic)
}
func (m *UpdateDatabaseDdlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDatabaseDdlRequest.Merge(m, src)
}
func (m *UpdateDatabaseDdlRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDatabaseDdlRequest.Size(m)
}
func (m *UpdateDatabaseDdlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDatabaseDdlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDatabaseDdlRequest proto.InternalMessageInfo

func (m *UpdateDatabaseDdlRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *UpdateDatabaseDdlRequest) GetStatements() []string {
	if m != nil {
		return m.Statements
	}
	return nil
}

func (m *UpdateDatabaseDdlRequest) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

// Metadata type for the operation returned by
// [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl].
type UpdateDatabaseDdlMetadata struct {
	// The database being modified.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// For an update this list contains all the statements. For an
	// individual statement, this list contains only that statement.
	Statements []string `protobuf:"bytes,2,rep,name=statements,proto3" json:"statements,omitempty"`
	// Reports the commit timestamps of all statements that have
	// succeeded so far, where `commit_timestamps[i]` is the commit
	// timestamp for the statement `statements[i]`.
	CommitTimestamps     []*timestamp.Timestamp `protobuf:"bytes,3,rep,name=commit_timestamps,json=commitTimestamps,proto3" json:"commit_timestamps,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *UpdateDatabaseDdlMetadata) Reset()         { *m = UpdateDatabaseDdlMetadata{} }
func (m *UpdateDatabaseDdlMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateDatabaseDdlMetadata) ProtoMessage()    {}
func (*UpdateDatabaseDdlMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_9422939aee7fc2d7, []int{7}
}

func (m *UpdateDatabaseDdlMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDatabaseDdlMetadata.Unmarshal(m, b)
}
func (m *UpdateDatabaseDdlMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDatabaseDdlMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateDatabaseDdlMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDatabaseDdlMetadata.Merge(m, src)
}
func (m *UpdateDatabaseDdlMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateDatabaseDdlMetadata.Size(m)
}
func (m *UpdateDatabaseDdlMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDatabaseDdlMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDatabaseDdlMetadata proto.InternalMessageInfo

func (m *UpdateDatabaseDdlMetadata) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *UpdateDatabaseDdlMetadata) GetStatements() []string {
	if m != nil {
		return m.Statements
	}
	return nil
}

func (m *UpdateDatabaseDdlMetadata) GetCommitTimestamps() []*timestamp.Timestamp {
	if m != nil {
		return m.CommitTimestamps
	}
	return nil
}

// The request for [DropDatabase][google.spanner.admin.database.v1.DatabaseAdmin.DropDatabase].
type DropDatabaseRequest struct {
	// Required. The database to be dropped.
	Database             string   `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DropDatabaseRequest) Reset()         { *m = DropDatabaseRequest{} }
func (m *DropDatabaseRequest) String() string { return proto.CompactTextString(m) }
func (*DropDatabaseRequest) ProtoMessage()    {}
func (*DropDatabaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9422939aee7fc2d7, []int{8}
}

func (m *DropDatabaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DropDatabaseRequest.Unmarshal(m, b)
}
func (m *DropDatabaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DropDatabaseRequest.Marshal(b, m, deterministic)
}
func (m *DropDatabaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DropDatabaseRequest.Merge(m, src)
}
func (m *DropDatabaseRequest) XXX_Size() int {
	return xxx_messageInfo_DropDatabaseRequest.Size(m)
}
func (m *DropDatabaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DropDatabaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DropDatabaseRequest proto.InternalMessageInfo

func (m *DropDatabaseRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

// The request for [GetDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.GetDatabaseDdl].
type GetDatabaseDdlRequest struct {
	// Required. The database whose schema we wish to get.
	Database             string   `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDatabaseDdlRequest) Reset()         { *m = GetDatabaseDdlRequest{} }
func (m *GetDatabaseDdlRequest) String() string { return proto.CompactTextString(m) }
func (*GetDatabaseDdlRequest) ProtoMessage()    {}
func (*GetDatabaseDdlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9422939aee7fc2d7, []int{9}
}

func (m *GetDatabaseDdlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDatabaseDdlRequest.Unmarshal(m, b)
}
func (m *GetDatabaseDdlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDatabaseDdlRequest.Marshal(b, m, deterministic)
}
func (m *GetDatabaseDdlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDatabaseDdlRequest.Merge(m, src)
}
func (m *GetDatabaseDdlRequest) XXX_Size() int {
	return xxx_messageInfo_GetDatabaseDdlRequest.Size(m)
}
func (m *GetDatabaseDdlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDatabaseDdlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDatabaseDdlRequest proto.InternalMessageInfo

func (m *GetDatabaseDdlRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

// The response for [GetDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.GetDatabaseDdl].
type GetDatabaseDdlResponse struct {
	// A list of formatted DDL statements defining the schema of the database
	// specified in the request.
	Statements           []string `protobuf:"bytes,1,rep,name=statements,proto3" json:"statements,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDatabaseDdlResponse) Reset()         { *m = GetDatabaseDdlResponse{} }
func (m *GetDatabaseDdlResponse) String() string { return proto.CompactTextString(m) }
func (*GetDatabaseDdlResponse) ProtoMessage()    {}
func (*GetDatabaseDdlResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9422939aee7fc2d7, []int{10}
}

func (m *GetDatabaseDdlResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDatabaseDdlResponse.Unmarshal(m, b)
}
func (m *GetDatabaseDdlResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDatabaseDdlResponse.Marshal(b, m, deterministic)
}
func (m *GetDatabaseDdlResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDatabaseDdlResponse.Merge(m, src)
}
func (m *GetDatabaseDdlResponse) XXX_Size() int {
	return xxx_messageInfo_GetDatabaseDdlResponse.Size(m)
}
func (m *GetDatabaseDdlResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDatabaseDdlResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDatabaseDdlResponse proto.InternalMessageInfo

func (m *GetDatabaseDdlResponse) GetStatements() []string {
	if m != nil {
		return m.Statements
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.spanner.admin.database.v1.Database_State", Database_State_name, Database_State_value)
	proto.RegisterType((*Database)(nil), "google.spanner.admin.database.v1.Database")
	proto.RegisterType((*ListDatabasesRequest)(nil), "google.spanner.admin.database.v1.ListDatabasesRequest")
	proto.RegisterType((*ListDatabasesResponse)(nil), "google.spanner.admin.database.v1.ListDatabasesResponse")
	proto.RegisterType((*CreateDatabaseRequest)(nil), "google.spanner.admin.database.v1.CreateDatabaseRequest")
	proto.RegisterType((*CreateDatabaseMetadata)(nil), "google.spanner.admin.database.v1.CreateDatabaseMetadata")
	proto.RegisterType((*GetDatabaseRequest)(nil), "google.spanner.admin.database.v1.GetDatabaseRequest")
	proto.RegisterType((*UpdateDatabaseDdlRequest)(nil), "google.spanner.admin.database.v1.UpdateDatabaseDdlRequest")
	proto.RegisterType((*UpdateDatabaseDdlMetadata)(nil), "google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata")
	proto.RegisterType((*DropDatabaseRequest)(nil), "google.spanner.admin.database.v1.DropDatabaseRequest")
	proto.RegisterType((*GetDatabaseDdlRequest)(nil), "google.spanner.admin.database.v1.GetDatabaseDdlRequest")
	proto.RegisterType((*GetDatabaseDdlResponse)(nil), "google.spanner.admin.database.v1.GetDatabaseDdlResponse")
}

func init() {
	proto.RegisterFile("google/spanner/admin/database/v1/spanner_database_admin.proto", fileDescriptor_9422939aee7fc2d7)
}

var fileDescriptor_9422939aee7fc2d7 = []byte{
	// 1341 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0xcf, 0x6f, 0x13, 0x47,
	0x14, 0xee, 0x6c, 0x08, 0x4a, 0x26, 0x81, 0x24, 0x03, 0x09, 0xc6, 0x14, 0x08, 0x0b, 0x82, 0x60,
	0x85, 0xdd, 0x26, 0x94, 0x06, 0x99, 0x1f, 0xed, 0x26, 0x0e, 0x26, 0x55, 0x4b, 0xd3, 0x75, 0x40,
	0x2a, 0xb2, 0x64, 0x8d, 0xed, 0xc1, 0x6c, 0xf1, 0xfe, 0xe8, 0xce, 0x98, 0x5f, 0x51, 0x2e, 0xad,
	0x54, 0xa9, 0xd7, 0x72, 0xe9, 0xa1, 0x55, 0x0f, 0xad, 0x54, 0xa9, 0x02, 0xa9, 0x52, 0x4f, 0xbd,
	0xf5, 0xd4, 0x43, 0xa4, 0x5e, 0xda, 0x9b, 0x4f, 0x1c, 0x38, 0xd1, 0xff, 0xa0, 0xa7, 0x6a, 0x67,
	0x77, 0xd6, 0xbb, 0x6b, 0x07, 0xaf, 0x4b, 0x6e, 0xeb, 0x79, 0xdf, 0x7b, 0xf3, 0xbd, 0x6f, 0x66,
	0xbe, 0x9d, 0x35, 0xbc, 0xd2, 0xb0, 0xed, 0x46, 0x93, 0xa8, 0xd4, 0xc1, 0x96, 0x45, 0x5c, 0x15,
	0xd7, 0x4d, 0xc3, 0x52, 0xeb, 0x98, 0xe1, 0x2a, 0xa6, 0x44, 0xbd, 0xbf, 0x20, 0x22, 0x15, 0x31,
	0x56, 0xe1, 0x10, 0xc5, 0x71, 0x6d, 0x66, 0xa3, 0x59, 0x3f, 0x5d, 0x09, 0x40, 0x8a, 0x1f, 0x13,
	0x50, 0xe5, 0xfe, 0x42, 0xf6, 0xcd, 0x60, 0x02, 0xec, 0x18, 0x2a, 0xb6, 0x2c, 0x9b, 0x61, 0x66,
	0xd8, 0x16, 0xf5, 0xf3, 0xb3, 0x87, 0x22, 0xd1, 0x5a, 0xd3, 0x20, 0x16, 0x0b, 0x02, 0xc7, 0x23,
	0x81, 0x3b, 0x06, 0x69, 0xd6, 0x2b, 0x55, 0x72, 0x17, 0xdf, 0x37, 0x6c, 0x37, 0x00, 0x1c, 0x8e,
	0x00, 0x5c, 0x42, 0xed, 0x96, 0x5b, 0x23, 0x41, 0xe8, 0x58, 0x10, 0x32, 0xb0, 0xe9, 0x35, 0x60,
	0x60, 0xb3, 0xe2, 0xd8, 0x4d, 0xa3, 0xf6, 0x28, 0x88, 0x67, 0xe3, 0xf1, 0x58, 0xec, 0x64, 0x10,
	0x6b, 0xda, 0x56, 0xc3, 0x6d, 0x59, 0x96, 0x61, 0x35, 0x54, 0xdb, 0x21, 0x6e, 0x8c, 0xf5, 0x91,
	0x00, 0xc4, 0x7f, 0x55, 0x5b, 0x77, 0x54, 0x62, 0x3a, 0xec, 0x51, 0x82, 0x79, 0x18, 0x64, 0x86,
	0x49, 0x28, 0xc3, 0xa6, 0xe3, 0x03, 0xe4, 0x2f, 0x24, 0x38, 0x52, 0x08, 0x14, 0x42, 0x08, 0xee,
	0xb1, 0xb0, 0x49, 0x32, 0x60, 0x16, 0xcc, 0x8d, 0xea, 0xfc, 0x19, 0x5d, 0x83, 0xc3, 0x94, 0x61,
	0x46, 0x32, 0xd2, 0x2c, 0x98, 0xdb, 0xbf, 0xf8, 0x96, 0xd2, 0x4f, 0x64, 0x45, 0x94, 0x53, 0x4a,
	0x5e, 0x9e, 0xee, 0xa7, 0xcb, 0x4b, 0x70, 0x98, 0xff, 0x46, 0xd3, 0x70, 0xaa, 0xb4, 0xa1, 0x6d,
	0xac, 0x56, 0x6e, 0xde, 0x28, 0xad, 0xaf, 0xae, 0xac, 0x5d, 0x5b, 0x5b, 0x2d, 0x4c, 0xbe, 0x81,
	0xc6, 0xe1, 0xc8, 0x8a, 0xbe, 0xaa, 0x6d, 0xac, 0xdd, 0x28, 0x4e, 0x02, 0x34, 0x0a, 0x87, 0xf5,
	0x55, 0xad, 0xf0, 0xc9, 0xa4, 0x94, 0xaf, 0xbe, 0xd4, 0x2a, 0xf0, 0xb8, 0x98, 0xce, 0x9f, 0x1d,
	0x3b, 0x06, 0x55, 0x6a, 0xb6, 0xa9, 0x86, 0xd4, 0x2f, 0x3b, 0xae, 0xfd, 0x29, 0xa9, 0x31, 0xaa,
	0x6e, 0x06, 0x4f, 0x5b, 0xaa, 0x61, 0x51, 0x86, 0xad, 0x1a, 0xa1, 0xea, 0xa6, 0x78, 0xdc, 0x0a,
	0x77, 0x13, 0x55, 0x37, 0xc5, 0xe3, 0x96, 0xfc, 0x04, 0xc0, 0x83, 0x1f, 0x18, 0x94, 0x89, 0x72,
	0x54, 0x27, 0x9f, 0xb5, 0x08, 0x65, 0xe8, 0x5d, 0xb8, 0xd7, 0xc1, 0x2e, 0xb1, 0x98, 0xaf, 0xc9,
	0xf2, 0x99, 0xe7, 0x9a, 0xf4, 0xaf, 0x76, 0x62, 0x47, 0x3e, 0x6b, 0xc1, 0x3c, 0x7a, 0x90, 0x86,
	0x8e, 0xc0, 0x51, 0x07, 0x37, 0x48, 0x85, 0x1a, 0x8f, 0x49, 0x66, 0x68, 0x16, 0xcc, 0x0d, 0xeb,
	0x23, 0xde, 0x40, 0xc9, 0x78, 0x4c, 0xd0, 0x51, 0x08, 0x79, 0x90, 0xd9, 0xf7, 0x88, 0x95, 0xd9,
	0xc3, 0x55, 0xe7, 0xf0, 0x0d, 0x6f, 0x40, 0xfe, 0x0a, 0xc0, 0xe9, 0x04, 0x2b, 0xea, 0xd8, 0x16,
	0x25, 0xe8, 0x3a, 0x1c, 0x0d, 0xfb, 0xc8, 0x80, 0xd9, 0xa1, 0xb9, 0xb1, 0xc5, 0x5c, 0xfa, 0x85,
	0xd1, 0x3b, 0xc9, 0xe8, 0x34, 0x9c, 0xb0, 0xc8, 0x43, 0x56, 0x89, 0xf0, 0x90, 0x38, 0x8f, 0x7d,
	0xde, 0xf0, 0x7a, 0xc8, 0xe5, 0x57, 0x00, 0xa7, 0x57, 0x5c, 0x82, 0x19, 0x09, 0xab, 0xec, 0x96,
	0x44, 0x0a, 0x9c, 0xac, 0xf1, 0xca, 0x15, 0xbe, 0x53, 0x4c, 0xaf, 0x14, 0xe7, 0xb0, 0x3c, 0xf4,
	0x5c, 0x93, 0xf4, 0x09, 0x3f, 0x58, 0x12, 0x31, 0x74, 0x16, 0x4e, 0x92, 0x87, 0xcc, 0xc5, 0x1d,
	0x38, 0xcd, 0x0c, 0xcd, 0x0e, 0xcd, 0x8d, 0xea, 0x13, 0x7c, 0x3c, 0x44, 0x52, 0xf9, 0x36, 0x9c,
	0x89, 0x93, 0xfe, 0x90, 0x30, 0xec, 0x35, 0x8f, 0xde, 0x83, 0x23, 0x42, 0x84, 0x80, 0xf7, 0xa9,
	0x57, 0x91, 0x0e, 0x9b, 0x0e, 0xb3, 0xe4, 0x8f, 0x21, 0x2a, 0x12, 0x96, 0x54, 0xe3, 0x52, 0xf4,
	0x08, 0xf5, 0xd5, 0x22, 0xcc, 0xe6, 0x49, 0xf2, 0x4f, 0x00, 0x66, 0x6e, 0x3a, 0xf5, 0x08, 0xdf,
	0x42, 0xbd, 0x29, 0x2a, 0xaf, 0x74, 0x31, 0x4e, 0x5d, 0x3d, 0x4c, 0x44, 0x27, 0x21, 0x8c, 0xa8,
	0x26, 0x79, 0xaa, 0xf9, 0x2a, 0x47, 0x86, 0xd1, 0x09, 0x38, 0x1e, 0xba, 0x4c, 0xc5, 0xa8, 0xf3,
	0x6d, 0x3b, 0xaa, 0x8f, 0x85, 0x63, 0x6b, 0x75, 0xf9, 0x0f, 0x00, 0x0f, 0x77, 0x31, 0xdd, 0x3d,
	0x71, 0xd1, 0xb1, 0x6e, 0x9e, 0x31, 0x8a, 0x45, 0x38, 0x55, 0xb3, 0x4d, 0xd3, 0x60, 0x95, 0xd0,
	0xd0, 0xfc, 0x4d, 0x30, 0xb6, 0x98, 0x15, 0x07, 0x41, 0x78, 0x9e, 0xb2, 0x21, 0x20, 0xfa, 0xa4,
	0x9f, 0x14, 0x0e, 0x78, 0x3b, 0xe4, 0x40, 0xc1, 0xb5, 0x9d, 0xe4, 0x32, 0xee, 0x86, 0xd8, 0x72,
	0x19, 0x4e, 0x47, 0x76, 0xc8, 0x2e, 0x2f, 0xa5, 0x7c, 0x11, 0xce, 0x24, 0xab, 0x07, 0xee, 0x10,
	0x17, 0x0f, 0x24, 0xc5, 0x5b, 0x7c, 0x36, 0x05, 0xf7, 0x89, 0x3c, 0xcd, 0x73, 0x09, 0xf4, 0x3b,
	0x80, 0xfb, 0x62, 0x4e, 0x83, 0xde, 0xe9, 0x6f, 0x27, 0xbd, 0x0c, 0x33, 0xbb, 0x34, 0x70, 0x9e,
	0x4f, 0x5a, 0xbe, 0xda, 0xd6, 0x02, 0x43, 0xf8, 0xfc, 0xef, 0x17, 0x4f, 0x24, 0x15, 0x9d, 0xf3,
	0x5e, 0x87, 0x9b, 0xfe, 0xd0, 0x95, 0xd0, 0xdd, 0x73, 0x11, 0x57, 0xcf, 0x45, 0xdc, 0x1c, 0xfd,
	0x28, 0xc1, 0xfd, 0xf1, 0xb3, 0x8e, 0x52, 0x70, 0xe9, 0x69, 0x69, 0xd9, 0xa3, 0x22, 0x31, 0xf2,
	0xe2, 0x55, 0x3e, 0x12, 0xdb, 0x5f, 0xfe, 0x0d, 0x6c, 0x6b, 0x75, 0x78, 0x36, 0xb5, 0xdf, 0xa2,
	0xa5, 0x01, 0x79, 0x88, 0x83, 0xd4, 0xd6, 0x0e, 0xf9, 0xfd, 0xcf, 0x27, 0x0d, 0x92, 0x6b, 0xb4,
	0x28, 0x0f, 0xa6, 0x51, 0x1e, 0xe4, 0xd0, 0x33, 0x00, 0xc7, 0x22, 0xdb, 0x06, 0xbd, 0xdd, 0x5f,
	0xa3, 0x6e, 0x97, 0xcb, 0x0e, 0xf0, 0xb2, 0x91, 0x2f, 0xb7, 0x35, 0xee, 0x6e, 0xb1, 0x65, 0xf5,
	0x06, 0x76, 0x20, 0x1c, 0x79, 0x43, 0xe7, 0xb6, 0xd0, 0x77, 0x12, 0x9c, 0xea, 0x32, 0x1a, 0x94,
	0xef, 0x3f, 0xff, 0x4e, 0x3e, 0xda, 0x6f, 0x71, 0x9f, 0x82, 0x6d, 0xad, 0x04, 0xa7, 0x93, 0x1e,
	0xb2, 0xea, 0x5d, 0xaa, 0x50, 0x7e, 0xf0, 0x69, 0x3b, 0x6b, 0x79, 0x40, 0xe0, 0xe6, 0x3b, 0x67,
	0x91, 0x8b, 0x92, 0x5f, 0xbc, 0xc0, 0x45, 0x11, 0xf1, 0x34, 0xc2, 0xa8, 0xf5, 0x7a, 0xd3, 0x5b,
	0xcf, 0x1f, 0x00, 0x1c, 0x8f, 0x1a, 0x18, 0xba, 0x90, 0x62, 0x69, 0xba, 0x0d, 0x2f, 0x3b, 0xa3,
	0xf4, 0xec, 0x58, 0x2e, 0xb4, 0xb5, 0xd0, 0x72, 0x38, 0xd9, 0xf3, 0xb9, 0x85, 0x81, 0xc9, 0xa2,
	0x3f, 0x01, 0xdc, 0x1f, 0x37, 0xab, 0x34, 0x87, 0xb3, 0xa7, 0x79, 0x66, 0x2f, 0x0e, 0x9e, 0x18,
	0x58, 0xcc, 0xf5, 0x64, 0x2f, 0x4b, 0xe8, 0xff, 0x09, 0x8f, 0xfe, 0x01, 0x70, 0xbc, 0x44, 0xd8,
	0x1a, 0x36, 0xd7, 0xf9, 0x7d, 0x1d, 0xc9, 0x82, 0x94, 0x81, 0x4d, 0x8f, 0x41, 0x34, 0x28, 0x88,
	0x4f, 0x27, 0x30, 0x7e, 0x54, 0xfe, 0x1e, 0xb4, 0xb5, 0x09, 0xf1, 0xd1, 0x30, 0xef, 0xdf, 0xff,
	0x39, 0xbb, 0x2f, 0x81, 0x7c, 0x95, 0xd3, 0x13, 0xc1, 0x34, 0xf4, 0xf2, 0x34, 0x32, 0x73, 0x1e,
	0xe4, 0x6e, 0x6b, 0xf2, 0xe5, 0x54, 0x45, 0xaa, 0xb8, 0x76, 0xaf, 0xe5, 0xf4, 0x2a, 0x81, 0x5e,
	0x00, 0x38, 0x5e, 0x7c, 0x55, 0xb7, 0xc5, 0xf4, 0xdd, 0x7e, 0x03, 0xda, 0xda, 0x88, 0xe0, 0xf2,
	0x1a, 0x6d, 0x36, 0x5e, 0xbf, 0xcd, 0x44, 0x09, 0xf4, 0xad, 0x04, 0xd1, 0x06, 0xa1, 0x7c, 0x90,
	0xb8, 0xa6, 0x41, 0xa9, 0xf7, 0x95, 0x85, 0xe6, 0x12, 0x8d, 0x74, 0x43, 0x44, 0xcb, 0x67, 0x53,
	0x20, 0x83, 0xad, 0xf8, 0x0b, 0x68, 0x6b, 0x07, 0x3b, 0x8b, 0xde, 0x41, 0x70, 0x49, 0xbe, 0x06,
	0x72, 0x61, 0x70, 0x49, 0x58, 0xd7, 0x74, 0x9e, 0x30, 0x45, 0x79, 0x79, 0x50, 0x61, 0x7a, 0x16,
	0xca, 0x3e, 0xdc, 0xd6, 0x66, 0x7a, 0xdf, 0x4e, 0xfe, 0xd2, 0xca, 0x77, 0x19, 0x73, 0x68, 0x5e,
	0x55, 0x1f, 0x3c, 0x78, 0x90, 0xbc, 0xba, 0xe0, 0x16, 0xbb, 0xab, 0xd6, 0x9a, 0x76, 0xab, 0x7e,
	0xce, 0x69, 0x62, 0x76, 0xc7, 0x76, 0xcd, 0xf9, 0x7e, 0xf0, 0xd8, 0xd1, 0x5e, 0x7e, 0x2a, 0xbd,
	0xd4, 0xde, 0xef, 0xfb, 0x3d, 0x81, 0xce, 0xa4, 0xfc, 0x04, 0x84, 0xa7, 0x6a, 0xb6, 0xd9, 0xd7,
	0x44, 0x96, 0x0f, 0x97, 0xfc, 0x50, 0xec, 0xa6, 0xb4, 0xee, 0xb9, 0xe3, 0x3a, 0xb8, 0x7d, 0x3d,
	0x48, 0x6f, 0xd8, 0x4d, 0x6c, 0x35, 0x14, 0xdb, 0x6d, 0xa8, 0x0d, 0x62, 0x71, 0xef, 0x54, 0x3b,
	0xfc, 0x76, 0xfe, 0x23, 0xe3, 0x92, 0x78, 0xfe, 0x59, 0x3a, 0x5d, 0xf4, 0x4b, 0xad, 0x78, 0x12,
	0x29, 0xc1, 0xa4, 0x0a, 0x9f, 0xad, 0xf3, 0x29, 0x7d, 0x6b, 0x61, 0x5b, 0x00, 0xcb, 0x1c, 0x58,
	0x0e, 0x80, 0x65, 0x0e, 0x2c, 0x0b, 0x60, 0xf9, 0xd6, 0x42, 0x75, 0x2f, 0xa7, 0x71, 0xfe, 0xbf,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xa6, 0x50, 0xe7, 0x0d, 0x4e, 0x11, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DatabaseAdminClient is the client API for DatabaseAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DatabaseAdminClient interface {
	// Lists Cloud Spanner databases.
	ListDatabases(ctx context.Context, in *ListDatabasesRequest, opts ...grpc.CallOption) (*ListDatabasesResponse, error)
	// Creates a new Cloud Spanner database and starts to prepare it for serving.
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<database_name>/operations/<operation_id>` and
	// can be used to track preparation of the database. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateDatabaseMetadata][google.spanner.admin.database.v1.CreateDatabaseMetadata]. The
	// [response][google.longrunning.Operation.response] field type is
	// [Database][google.spanner.admin.database.v1.Database], if successful.
	CreateDatabase(ctx context.Context, in *CreateDatabaseRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets the state of a Cloud Spanner database.
	GetDatabase(ctx context.Context, in *GetDatabaseRequest, opts ...grpc.CallOption) (*Database, error)
	// Updates the schema of a Cloud Spanner database by
	// creating/altering/dropping tables, columns, indexes, etc. The returned
	// [long-running operation][google.longrunning.Operation] will have a name of
	// the format `<database_name>/operations/<operation_id>` and can be used to
	// track execution of the schema change(s). The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateDatabaseDdlMetadata][google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata].  The operation has no response.
	UpdateDatabaseDdl(ctx context.Context, in *UpdateDatabaseDdlRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Drops (aka deletes) a Cloud Spanner database.
	DropDatabase(ctx context.Context, in *DropDatabaseRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns the schema of a Cloud Spanner database as a list of formatted
	// DDL statements. This method does not show pending schema updates, those may
	// be queried using the [Operations][google.longrunning.Operations] API.
	GetDatabaseDdl(ctx context.Context, in *GetDatabaseDdlRequest, opts ...grpc.CallOption) (*GetDatabaseDdlResponse, error)
	// Sets the access control policy on a database resource.
	// Replaces any existing policy.
	//
	// Authorization requires `spanner.databases.setIamPolicy`
	// permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets the access control policy for a database resource.
	// Returns an empty policy if a database exists but does
	// not have a policy set.
	//
	// Authorization requires `spanner.databases.getIamPolicy` permission on
	// [resource][google.iam.v1.GetIamPolicyRequest.resource].
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that the caller has on the specified database resource.
	//
	// Attempting this RPC on a non-existent Cloud Spanner database will
	// result in a NOT_FOUND error if the user has
	// `spanner.databases.list` permission on the containing Cloud
	// Spanner instance. Otherwise returns an empty set of permissions.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type databaseAdminClient struct {
	cc grpc.ClientConnInterface
}

func NewDatabaseAdminClient(cc grpc.ClientConnInterface) DatabaseAdminClient {
	return &databaseAdminClient{cc}
}

func (c *databaseAdminClient) ListDatabases(ctx context.Context, in *ListDatabasesRequest, opts ...grpc.CallOption) (*ListDatabasesResponse, error) {
	out := new(ListDatabasesResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/ListDatabases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) CreateDatabase(ctx context.Context, in *CreateDatabaseRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/CreateDatabase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) GetDatabase(ctx context.Context, in *GetDatabaseRequest, opts ...grpc.CallOption) (*Database, error) {
	out := new(Database)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/GetDatabase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) UpdateDatabaseDdl(ctx context.Context, in *UpdateDatabaseDdlRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/UpdateDatabaseDdl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) DropDatabase(ctx context.Context, in *DropDatabaseRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/DropDatabase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) GetDatabaseDdl(ctx context.Context, in *GetDatabaseDdlRequest, opts ...grpc.CallOption) (*GetDatabaseDdlResponse, error) {
	out := new(GetDatabaseDdlResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/GetDatabaseDdl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DatabaseAdminServer is the server API for DatabaseAdmin service.
type DatabaseAdminServer interface {
	// Lists Cloud Spanner databases.
	ListDatabases(context.Context, *ListDatabasesRequest) (*ListDatabasesResponse, error)
	// Creates a new Cloud Spanner database and starts to prepare it for serving.
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<database_name>/operations/<operation_id>` and
	// can be used to track preparation of the database. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateDatabaseMetadata][google.spanner.admin.database.v1.CreateDatabaseMetadata]. The
	// [response][google.longrunning.Operation.response] field type is
	// [Database][google.spanner.admin.database.v1.Database], if successful.
	CreateDatabase(context.Context, *CreateDatabaseRequest) (*longrunning.Operation, error)
	// Gets the state of a Cloud Spanner database.
	GetDatabase(context.Context, *GetDatabaseRequest) (*Database, error)
	// Updates the schema of a Cloud Spanner database by
	// creating/altering/dropping tables, columns, indexes, etc. The returned
	// [long-running operation][google.longrunning.Operation] will have a name of
	// the format `<database_name>/operations/<operation_id>` and can be used to
	// track execution of the schema change(s). The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateDatabaseDdlMetadata][google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata].  The operation has no response.
	UpdateDatabaseDdl(context.Context, *UpdateDatabaseDdlRequest) (*longrunning.Operation, error)
	// Drops (aka deletes) a Cloud Spanner database.
	DropDatabase(context.Context, *DropDatabaseRequest) (*empty.Empty, error)
	// Returns the schema of a Cloud Spanner database as a list of formatted
	// DDL statements. This method does not show pending schema updates, those may
	// be queried using the [Operations][google.longrunning.Operations] API.
	GetDatabaseDdl(context.Context, *GetDatabaseDdlRequest) (*GetDatabaseDdlResponse, error)
	// Sets the access control policy on a database resource.
	// Replaces any existing policy.
	//
	// Authorization requires `spanner.databases.setIamPolicy`
	// permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Gets the access control policy for a database resource.
	// Returns an empty policy if a database exists but does
	// not have a policy set.
	//
	// Authorization requires `spanner.databases.getIamPolicy` permission on
	// [resource][google.iam.v1.GetIamPolicyRequest.resource].
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that the caller has on the specified database resource.
	//
	// Attempting this RPC on a non-existent Cloud Spanner database will
	// result in a NOT_FOUND error if the user has
	// `spanner.databases.list` permission on the containing Cloud
	// Spanner instance. Otherwise returns an empty set of permissions.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedDatabaseAdminServer can be embedded to have forward compatible implementations.
type UnimplementedDatabaseAdminServer struct {
}

func (*UnimplementedDatabaseAdminServer) ListDatabases(ctx context.Context, req *ListDatabasesRequest) (*ListDatabasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatabases not implemented")
}
func (*UnimplementedDatabaseAdminServer) CreateDatabase(ctx context.Context, req *CreateDatabaseRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDatabase not implemented")
}
func (*UnimplementedDatabaseAdminServer) GetDatabase(ctx context.Context, req *GetDatabaseRequest) (*Database, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDatabase not implemented")
}
func (*UnimplementedDatabaseAdminServer) UpdateDatabaseDdl(ctx context.Context, req *UpdateDatabaseDdlRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDatabaseDdl not implemented")
}
func (*UnimplementedDatabaseAdminServer) DropDatabase(ctx context.Context, req *DropDatabaseRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DropDatabase not implemented")
}
func (*UnimplementedDatabaseAdminServer) GetDatabaseDdl(ctx context.Context, req *GetDatabaseDdlRequest) (*GetDatabaseDdlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDatabaseDdl not implemented")
}
func (*UnimplementedDatabaseAdminServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedDatabaseAdminServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedDatabaseAdminServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterDatabaseAdminServer(s *grpc.Server, srv DatabaseAdminServer) {
	s.RegisterService(&_DatabaseAdmin_serviceDesc, srv)
}

func _DatabaseAdmin_ListDatabases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatabasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).ListDatabases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/ListDatabases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).ListDatabases(ctx, req.(*ListDatabasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_CreateDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).CreateDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/CreateDatabase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).CreateDatabase(ctx, req.(*CreateDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_GetDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).GetDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/GetDatabase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).GetDatabase(ctx, req.(*GetDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_UpdateDatabaseDdl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatabaseDdlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).UpdateDatabaseDdl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/UpdateDatabaseDdl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).UpdateDatabaseDdl(ctx, req.(*UpdateDatabaseDdlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_DropDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DropDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).DropDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/DropDatabase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).DropDatabase(ctx, req.(*DropDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_GetDatabaseDdl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatabaseDdlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).GetDatabaseDdl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/GetDatabaseDdl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).GetDatabaseDdl(ctx, req.(*GetDatabaseDdlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DatabaseAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.spanner.admin.database.v1.DatabaseAdmin",
	HandlerType: (*DatabaseAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDatabases",
			Handler:    _DatabaseAdmin_ListDatabases_Handler,
		},
		{
			MethodName: "CreateDatabase",
			Handler:    _DatabaseAdmin_CreateDatabase_Handler,
		},
		{
			MethodName: "GetDatabase",
			Handler:    _DatabaseAdmin_GetDatabase_Handler,
		},
		{
			MethodName: "UpdateDatabaseDdl",
			Handler:    _DatabaseAdmin_UpdateDatabaseDdl_Handler,
		},
		{
			MethodName: "DropDatabase",
			Handler:    _DatabaseAdmin_DropDatabase_Handler,
		},
		{
			MethodName: "GetDatabaseDdl",
			Handler:    _DatabaseAdmin_GetDatabaseDdl_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DatabaseAdmin_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DatabaseAdmin_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DatabaseAdmin_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/spanner/admin/database/v1/spanner_database_admin.proto",
}
