// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/monitoring/dashboard/v1/piechart.proto

package dashboardpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Types for the pie chart.
type PieChart_PieChartType int32

const (
	// The zero value. No type specified. Do not use.
	PieChart_PIE_CHART_TYPE_UNSPECIFIED PieChart_PieChartType = 0
	// A Pie type PieChart.
	PieChart_PIE PieChart_PieChartType = 1
	// Similar to PIE, but the DONUT type PieChart has a hole in the middle.
	PieChart_DONUT PieChart_PieChartType = 2
)

// Enum value maps for PieChart_PieChartType.
var (
	PieChart_PieChartType_name = map[int32]string{
		0: "PIE_CHART_TYPE_UNSPECIFIED",
		1: "PIE",
		2: "DONUT",
	}
	PieChart_PieChartType_value = map[string]int32{
		"PIE_CHART_TYPE_UNSPECIFIED": 0,
		"PIE":                        1,
		"DONUT":                      2,
	}
)

func (x PieChart_PieChartType) Enum() *PieChart_PieChartType {
	p := new(PieChart_PieChartType)
	*p = x
	return p
}

func (x PieChart_PieChartType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PieChart_PieChartType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_piechart_proto_enumTypes[0].Descriptor()
}

func (PieChart_PieChartType) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_piechart_proto_enumTypes[0]
}

func (x PieChart_PieChartType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PieChart_PieChartType.Descriptor instead.
func (PieChart_PieChartType) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_piechart_proto_rawDescGZIP(), []int{0, 0}
}

// A widget that displays timeseries data as a pie or a donut.
type PieChart struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The queries for the chart's data.
	DataSets []*PieChart_PieChartDataSet `protobuf:"bytes,1,rep,name=data_sets,json=dataSets,proto3" json:"data_sets,omitempty"`
	// Required. Indicates the visualization type for the PieChart.
	ChartType PieChart_PieChartType `protobuf:"varint,2,opt,name=chart_type,json=chartType,proto3,enum=google.monitoring.dashboard.v1.PieChart_PieChartType" json:"chart_type,omitempty"`
	// Optional. Indicates whether or not the pie chart should show slices' labels
	ShowLabels bool `protobuf:"varint,4,opt,name=show_labels,json=showLabels,proto3" json:"show_labels,omitempty"`
}

func (x *PieChart) Reset() {
	*x = PieChart{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_dashboard_v1_piechart_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PieChart) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PieChart) ProtoMessage() {}

func (x *PieChart) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_dashboard_v1_piechart_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PieChart.ProtoReflect.Descriptor instead.
func (*PieChart) Descriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_piechart_proto_rawDescGZIP(), []int{0}
}

func (x *PieChart) GetDataSets() []*PieChart_PieChartDataSet {
	if x != nil {
		return x.DataSets
	}
	return nil
}

func (x *PieChart) GetChartType() PieChart_PieChartType {
	if x != nil {
		return x.ChartType
	}
	return PieChart_PIE_CHART_TYPE_UNSPECIFIED
}

func (x *PieChart) GetShowLabels() bool {
	if x != nil {
		return x.ShowLabels
	}
	return false
}

// Groups a time series query definition.
type PieChart_PieChartDataSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The query for the PieChart. See,
	// `google.monitoring.dashboard.v1.TimeSeriesQuery`.
	TimeSeriesQuery *TimeSeriesQuery `protobuf:"bytes,1,opt,name=time_series_query,json=timeSeriesQuery,proto3" json:"time_series_query,omitempty"`
	// Optional. A template for the name of the slice. This name will be
	// displayed in the legend and the tooltip of the pie chart. It replaces the
	// auto-generated names for the slices. For example, if the template is set
	// to
	// `${resource.labels.zone}`, the zone's value will be used for the name
	// instead of the default name.
	SliceNameTemplate string `protobuf:"bytes,2,opt,name=slice_name_template,json=sliceNameTemplate,proto3" json:"slice_name_template,omitempty"`
	// Optional. The lower bound on data point frequency for this data set,
	// implemented by specifying the minimum alignment period to use in a time
	// series query. For example, if the data is published once every 10
	// minutes, the `min_alignment_period` should be at least 10 minutes. It
	// would not make sense to fetch and align data at one minute intervals.
	MinAlignmentPeriod *durationpb.Duration `protobuf:"bytes,3,opt,name=min_alignment_period,json=minAlignmentPeriod,proto3" json:"min_alignment_period,omitempty"`
}

func (x *PieChart_PieChartDataSet) Reset() {
	*x = PieChart_PieChartDataSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_dashboard_v1_piechart_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PieChart_PieChartDataSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PieChart_PieChartDataSet) ProtoMessage() {}

func (x *PieChart_PieChartDataSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_dashboard_v1_piechart_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PieChart_PieChartDataSet.ProtoReflect.Descriptor instead.
func (*PieChart_PieChartDataSet) Descriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_piechart_proto_rawDescGZIP(), []int{0, 0}
}

func (x *PieChart_PieChartDataSet) GetTimeSeriesQuery() *TimeSeriesQuery {
	if x != nil {
		return x.TimeSeriesQuery
	}
	return nil
}

func (x *PieChart_PieChartDataSet) GetSliceNameTemplate() string {
	if x != nil {
		return x.SliceNameTemplate
	}
	return ""
}

func (x *PieChart_PieChartDataSet) GetMinAlignmentPeriod() *durationpb.Duration {
	if x != nil {
		return x.MinAlignmentPeriod
	}
	return nil
}

var File_google_monitoring_dashboard_v1_piechart_proto protoreflect.FileDescriptor

var file_google_monitoring_dashboard_v1_piechart_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2f, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2f, 0x76, 0x31,
	0x2f, 0x70, 0x69, 0x65, 0x63, 0x68, 0x61, 0x72, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2f, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2f, 0x76, 0x31,
	0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa8,
	0x04, 0x0a, 0x08, 0x50, 0x69, 0x65, 0x43, 0x68, 0x61, 0x72, 0x74, 0x12, 0x5a, 0x0a, 0x09, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x69, 0x65, 0x43, 0x68, 0x61, 0x72, 0x74, 0x2e, 0x50, 0x69, 0x65, 0x43, 0x68, 0x61, 0x72,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x73, 0x12, 0x59, 0x0a, 0x0a, 0x63, 0x68, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e,
	0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x65,
	0x43, 0x68, 0x61, 0x72, 0x74, 0x2e, 0x50, 0x69, 0x65, 0x43, 0x68, 0x61, 0x72, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x68, 0x61, 0x72, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x73, 0x68,
	0x6f, 0x77, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0xfa, 0x01, 0x0a, 0x0f, 0x50, 0x69, 0x65,
	0x43, 0x68, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65, 0x74, 0x12, 0x60, 0x0a, 0x11,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x74,
	0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x33,
	0x0a, 0x13, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x74, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x11, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x12, 0x50, 0x0a, 0x14, 0x6d, 0x69, 0x6e, 0x5f, 0x61, 0x6c, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x12, 0x6d, 0x69, 0x6e, 0x41, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x65, 0x72, 0x69, 0x6f, 0x64, 0x22, 0x42, 0x0a, 0x0c, 0x50, 0x69, 0x65, 0x43, 0x68, 0x61, 0x72,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x49, 0x45, 0x5f, 0x43, 0x48, 0x41,
	0x52, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x49, 0x45, 0x10, 0x01, 0x12, 0x09,
	0x0a, 0x05, 0x44, 0x4f, 0x4e, 0x55, 0x54, 0x10, 0x02, 0x42, 0xf6, 0x01, 0x0a, 0x22, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31,
	0x42, 0x0d, 0x50, 0x69, 0x65, 0x43, 0x68, 0x61, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x46, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x2f, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x70, 0x62, 0x3b, 0x64, 0x61,
	0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x70, 0x62, 0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5c, 0x44, 0x61, 0x73, 0x68, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_monitoring_dashboard_v1_piechart_proto_rawDescOnce sync.Once
	file_google_monitoring_dashboard_v1_piechart_proto_rawDescData = file_google_monitoring_dashboard_v1_piechart_proto_rawDesc
)

func file_google_monitoring_dashboard_v1_piechart_proto_rawDescGZIP() []byte {
	file_google_monitoring_dashboard_v1_piechart_proto_rawDescOnce.Do(func() {
		file_google_monitoring_dashboard_v1_piechart_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_monitoring_dashboard_v1_piechart_proto_rawDescData)
	})
	return file_google_monitoring_dashboard_v1_piechart_proto_rawDescData
}

var file_google_monitoring_dashboard_v1_piechart_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_monitoring_dashboard_v1_piechart_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_monitoring_dashboard_v1_piechart_proto_goTypes = []interface{}{
	(PieChart_PieChartType)(0),       // 0: google.monitoring.dashboard.v1.PieChart.PieChartType
	(*PieChart)(nil),                 // 1: google.monitoring.dashboard.v1.PieChart
	(*PieChart_PieChartDataSet)(nil), // 2: google.monitoring.dashboard.v1.PieChart.PieChartDataSet
	(*TimeSeriesQuery)(nil),          // 3: google.monitoring.dashboard.v1.TimeSeriesQuery
	(*durationpb.Duration)(nil),      // 4: google.protobuf.Duration
}
var file_google_monitoring_dashboard_v1_piechart_proto_depIdxs = []int32{
	2, // 0: google.monitoring.dashboard.v1.PieChart.data_sets:type_name -> google.monitoring.dashboard.v1.PieChart.PieChartDataSet
	0, // 1: google.monitoring.dashboard.v1.PieChart.chart_type:type_name -> google.monitoring.dashboard.v1.PieChart.PieChartType
	3, // 2: google.monitoring.dashboard.v1.PieChart.PieChartDataSet.time_series_query:type_name -> google.monitoring.dashboard.v1.TimeSeriesQuery
	4, // 3: google.monitoring.dashboard.v1.PieChart.PieChartDataSet.min_alignment_period:type_name -> google.protobuf.Duration
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_monitoring_dashboard_v1_piechart_proto_init() }
func file_google_monitoring_dashboard_v1_piechart_proto_init() {
	if File_google_monitoring_dashboard_v1_piechart_proto != nil {
		return
	}
	file_google_monitoring_dashboard_v1_metrics_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_monitoring_dashboard_v1_piechart_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PieChart); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_dashboard_v1_piechart_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PieChart_PieChartDataSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_monitoring_dashboard_v1_piechart_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_monitoring_dashboard_v1_piechart_proto_goTypes,
		DependencyIndexes: file_google_monitoring_dashboard_v1_piechart_proto_depIdxs,
		EnumInfos:         file_google_monitoring_dashboard_v1_piechart_proto_enumTypes,
		MessageInfos:      file_google_monitoring_dashboard_v1_piechart_proto_msgTypes,
	}.Build()
	File_google_monitoring_dashboard_v1_piechart_proto = out.File
	file_google_monitoring_dashboard_v1_piechart_proto_rawDesc = nil
	file_google_monitoring_dashboard_v1_piechart_proto_goTypes = nil
	file_google_monitoring_dashboard_v1_piechart_proto_depIdxs = nil
}
