// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/bigtable/admin/v2/bigtable_table_admin.proto

package adminpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	BigtableTableAdmin_CreateTable_FullMethodName              = "/google.bigtable.admin.v2.BigtableTableAdmin/CreateTable"
	BigtableTableAdmin_CreateTableFromSnapshot_FullMethodName  = "/google.bigtable.admin.v2.BigtableTableAdmin/CreateTableFromSnapshot"
	BigtableTableAdmin_ListTables_FullMethodName               = "/google.bigtable.admin.v2.BigtableTableAdmin/ListTables"
	BigtableTableAdmin_GetTable_FullMethodName                 = "/google.bigtable.admin.v2.BigtableTableAdmin/GetTable"
	BigtableTableAdmin_UpdateTable_FullMethodName              = "/google.bigtable.admin.v2.BigtableTableAdmin/UpdateTable"
	BigtableTableAdmin_DeleteTable_FullMethodName              = "/google.bigtable.admin.v2.BigtableTableAdmin/DeleteTable"
	BigtableTableAdmin_UndeleteTable_FullMethodName            = "/google.bigtable.admin.v2.BigtableTableAdmin/UndeleteTable"
	BigtableTableAdmin_CreateAuthorizedView_FullMethodName     = "/google.bigtable.admin.v2.BigtableTableAdmin/CreateAuthorizedView"
	BigtableTableAdmin_ListAuthorizedViews_FullMethodName      = "/google.bigtable.admin.v2.BigtableTableAdmin/ListAuthorizedViews"
	BigtableTableAdmin_GetAuthorizedView_FullMethodName        = "/google.bigtable.admin.v2.BigtableTableAdmin/GetAuthorizedView"
	BigtableTableAdmin_UpdateAuthorizedView_FullMethodName     = "/google.bigtable.admin.v2.BigtableTableAdmin/UpdateAuthorizedView"
	BigtableTableAdmin_DeleteAuthorizedView_FullMethodName     = "/google.bigtable.admin.v2.BigtableTableAdmin/DeleteAuthorizedView"
	BigtableTableAdmin_ModifyColumnFamilies_FullMethodName     = "/google.bigtable.admin.v2.BigtableTableAdmin/ModifyColumnFamilies"
	BigtableTableAdmin_DropRowRange_FullMethodName             = "/google.bigtable.admin.v2.BigtableTableAdmin/DropRowRange"
	BigtableTableAdmin_GenerateConsistencyToken_FullMethodName = "/google.bigtable.admin.v2.BigtableTableAdmin/GenerateConsistencyToken"
	BigtableTableAdmin_CheckConsistency_FullMethodName         = "/google.bigtable.admin.v2.BigtableTableAdmin/CheckConsistency"
	BigtableTableAdmin_SnapshotTable_FullMethodName            = "/google.bigtable.admin.v2.BigtableTableAdmin/SnapshotTable"
	BigtableTableAdmin_GetSnapshot_FullMethodName              = "/google.bigtable.admin.v2.BigtableTableAdmin/GetSnapshot"
	BigtableTableAdmin_ListSnapshots_FullMethodName            = "/google.bigtable.admin.v2.BigtableTableAdmin/ListSnapshots"
	BigtableTableAdmin_DeleteSnapshot_FullMethodName           = "/google.bigtable.admin.v2.BigtableTableAdmin/DeleteSnapshot"
	BigtableTableAdmin_CreateBackup_FullMethodName             = "/google.bigtable.admin.v2.BigtableTableAdmin/CreateBackup"
	BigtableTableAdmin_GetBackup_FullMethodName                = "/google.bigtable.admin.v2.BigtableTableAdmin/GetBackup"
	BigtableTableAdmin_UpdateBackup_FullMethodName             = "/google.bigtable.admin.v2.BigtableTableAdmin/UpdateBackup"
	BigtableTableAdmin_DeleteBackup_FullMethodName             = "/google.bigtable.admin.v2.BigtableTableAdmin/DeleteBackup"
	BigtableTableAdmin_ListBackups_FullMethodName              = "/google.bigtable.admin.v2.BigtableTableAdmin/ListBackups"
	BigtableTableAdmin_RestoreTable_FullMethodName             = "/google.bigtable.admin.v2.BigtableTableAdmin/RestoreTable"
	BigtableTableAdmin_CopyBackup_FullMethodName               = "/google.bigtable.admin.v2.BigtableTableAdmin/CopyBackup"
	BigtableTableAdmin_GetIamPolicy_FullMethodName             = "/google.bigtable.admin.v2.BigtableTableAdmin/GetIamPolicy"
	BigtableTableAdmin_SetIamPolicy_FullMethodName             = "/google.bigtable.admin.v2.BigtableTableAdmin/SetIamPolicy"
	BigtableTableAdmin_TestIamPermissions_FullMethodName       = "/google.bigtable.admin.v2.BigtableTableAdmin/TestIamPermissions"
	BigtableTableAdmin_CreateSchemaBundle_FullMethodName       = "/google.bigtable.admin.v2.BigtableTableAdmin/CreateSchemaBundle"
	BigtableTableAdmin_UpdateSchemaBundle_FullMethodName       = "/google.bigtable.admin.v2.BigtableTableAdmin/UpdateSchemaBundle"
	BigtableTableAdmin_GetSchemaBundle_FullMethodName          = "/google.bigtable.admin.v2.BigtableTableAdmin/GetSchemaBundle"
	BigtableTableAdmin_ListSchemaBundles_FullMethodName        = "/google.bigtable.admin.v2.BigtableTableAdmin/ListSchemaBundles"
	BigtableTableAdmin_DeleteSchemaBundle_FullMethodName       = "/google.bigtable.admin.v2.BigtableTableAdmin/DeleteSchemaBundle"
)

// BigtableTableAdminClient is the client API for BigtableTableAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BigtableTableAdminClient interface {
	// Creates a new table in the specified instance.
	// The table can be created with a full set of initial column families,
	// specified in the request.
	CreateTable(ctx context.Context, in *CreateTableRequest, opts ...grpc.CallOption) (*Table, error)
	// Creates a new table from the specified snapshot. The target table must
	// not exist. The snapshot and the table must be in the same instance.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	CreateTableFromSnapshot(ctx context.Context, in *CreateTableFromSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all tables served from a specified instance.
	ListTables(ctx context.Context, in *ListTablesRequest, opts ...grpc.CallOption) (*ListTablesResponse, error)
	// Gets metadata information about the specified table.
	GetTable(ctx context.Context, in *GetTableRequest, opts ...grpc.CallOption) (*Table, error)
	// Updates a specified table.
	UpdateTable(ctx context.Context, in *UpdateTableRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Permanently deletes a specified table and all of its data.
	DeleteTable(ctx context.Context, in *DeleteTableRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Restores a specified table which was accidentally deleted.
	UndeleteTable(ctx context.Context, in *UndeleteTableRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new AuthorizedView in a table.
	CreateAuthorizedView(ctx context.Context, in *CreateAuthorizedViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all AuthorizedViews from a specific table.
	ListAuthorizedViews(ctx context.Context, in *ListAuthorizedViewsRequest, opts ...grpc.CallOption) (*ListAuthorizedViewsResponse, error)
	// Gets information from a specified AuthorizedView.
	GetAuthorizedView(ctx context.Context, in *GetAuthorizedViewRequest, opts ...grpc.CallOption) (*AuthorizedView, error)
	// Updates an AuthorizedView in a table.
	UpdateAuthorizedView(ctx context.Context, in *UpdateAuthorizedViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Permanently deletes a specified AuthorizedView.
	DeleteAuthorizedView(ctx context.Context, in *DeleteAuthorizedViewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Performs a series of column family modifications on the specified table.
	// Either all or none of the modifications will occur before this method
	// returns, but data requests received prior to that point may see a table
	// where only some modifications have taken effect.
	ModifyColumnFamilies(ctx context.Context, in *ModifyColumnFamiliesRequest, opts ...grpc.CallOption) (*Table, error)
	// Permanently drop/delete a row range from a specified table. The request can
	// specify whether to delete all rows in a table, or only those that match a
	// particular prefix.
	DropRowRange(ctx context.Context, in *DropRowRangeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Generates a consistency token for a Table, which can be used in
	// CheckConsistency to check whether mutations to the table that finished
	// before this call started have been replicated. The tokens will be available
	// for 90 days.
	GenerateConsistencyToken(ctx context.Context, in *GenerateConsistencyTokenRequest, opts ...grpc.CallOption) (*GenerateConsistencyTokenResponse, error)
	// Checks replication consistency based on a consistency token, that is, if
	// replication has caught up based on the conditions specified in the token
	// and the check request.
	CheckConsistency(ctx context.Context, in *CheckConsistencyRequest, opts ...grpc.CallOption) (*CheckConsistencyResponse, error)
	// Creates a new snapshot in the specified cluster from the specified
	// source table. The cluster and the table must be in the same instance.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	SnapshotTable(ctx context.Context, in *SnapshotTableRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets metadata information about the specified snapshot.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error)
	// Lists all snapshots associated with the specified cluster.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error)
	// Permanently deletes the specified snapshot.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Starts creating a new Cloud Bigtable Backup.  The returned backup
	// [long-running operation][google.longrunning.Operation] can be used to
	// track creation of the backup. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateBackupMetadata][google.bigtable.admin.v2.CreateBackupMetadata]. The
	// [response][google.longrunning.Operation.response] field type is
	// [Backup][google.bigtable.admin.v2.Backup], if successful. Cancelling the
	// returned operation will stop the creation and delete the backup.
	CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets metadata on a pending or completed Cloud Bigtable Backup.
	GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error)
	// Updates a pending or completed Cloud Bigtable Backup.
	UpdateBackup(ctx context.Context, in *UpdateBackupRequest, opts ...grpc.CallOption) (*Backup, error)
	// Deletes a pending or completed Cloud Bigtable backup.
	DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists Cloud Bigtable backups. Returns both completed and pending
	// backups.
	ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error)
	// Create a new table by restoring from a completed backup.  The
	// returned table [long-running operation][google.longrunning.Operation] can
	// be used to track the progress of the operation, and to cancel it.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [RestoreTableMetadata][google.bigtable.admin.v2.RestoreTableMetadata].  The
	// [response][google.longrunning.Operation.response] type is
	// [Table][google.bigtable.admin.v2.Table], if successful.
	RestoreTable(ctx context.Context, in *RestoreTableRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Copy a Cloud Bigtable backup to a new backup in the destination cluster
	// located in the destination instance and project.
	CopyBackup(ctx context.Context, in *CopyBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the access control policy for a Bigtable resource.
	// Returns an empty policy if the resource exists but does not have a policy
	// set.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the access control policy on a Bigtable resource.
	// Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns permissions that the caller has on the specified Bigtable
	// resource.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Creates a new schema bundle in the specified table.
	CreateSchemaBundle(ctx context.Context, in *CreateSchemaBundleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a schema bundle in the specified table.
	UpdateSchemaBundle(ctx context.Context, in *UpdateSchemaBundleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets metadata information about the specified schema bundle.
	GetSchemaBundle(ctx context.Context, in *GetSchemaBundleRequest, opts ...grpc.CallOption) (*SchemaBundle, error)
	// Lists all schema bundles associated with the specified table.
	ListSchemaBundles(ctx context.Context, in *ListSchemaBundlesRequest, opts ...grpc.CallOption) (*ListSchemaBundlesResponse, error)
	// Deletes a schema bundle in the specified table.
	DeleteSchemaBundle(ctx context.Context, in *DeleteSchemaBundleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type bigtableTableAdminClient struct {
	cc grpc.ClientConnInterface
}

func NewBigtableTableAdminClient(cc grpc.ClientConnInterface) BigtableTableAdminClient {
	return &bigtableTableAdminClient{cc}
}

func (c *bigtableTableAdminClient) CreateTable(ctx context.Context, in *CreateTableRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_CreateTable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) CreateTableFromSnapshot(ctx context.Context, in *CreateTableFromSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_CreateTableFromSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) ListTables(ctx context.Context, in *ListTablesRequest, opts ...grpc.CallOption) (*ListTablesResponse, error) {
	out := new(ListTablesResponse)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_ListTables_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) GetTable(ctx context.Context, in *GetTableRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_GetTable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) UpdateTable(ctx context.Context, in *UpdateTableRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_UpdateTable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) DeleteTable(ctx context.Context, in *DeleteTableRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_DeleteTable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) UndeleteTable(ctx context.Context, in *UndeleteTableRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_UndeleteTable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) CreateAuthorizedView(ctx context.Context, in *CreateAuthorizedViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_CreateAuthorizedView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) ListAuthorizedViews(ctx context.Context, in *ListAuthorizedViewsRequest, opts ...grpc.CallOption) (*ListAuthorizedViewsResponse, error) {
	out := new(ListAuthorizedViewsResponse)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_ListAuthorizedViews_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) GetAuthorizedView(ctx context.Context, in *GetAuthorizedViewRequest, opts ...grpc.CallOption) (*AuthorizedView, error) {
	out := new(AuthorizedView)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_GetAuthorizedView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) UpdateAuthorizedView(ctx context.Context, in *UpdateAuthorizedViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_UpdateAuthorizedView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) DeleteAuthorizedView(ctx context.Context, in *DeleteAuthorizedViewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_DeleteAuthorizedView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) ModifyColumnFamilies(ctx context.Context, in *ModifyColumnFamiliesRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_ModifyColumnFamilies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) DropRowRange(ctx context.Context, in *DropRowRangeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_DropRowRange_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) GenerateConsistencyToken(ctx context.Context, in *GenerateConsistencyTokenRequest, opts ...grpc.CallOption) (*GenerateConsistencyTokenResponse, error) {
	out := new(GenerateConsistencyTokenResponse)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_GenerateConsistencyToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) CheckConsistency(ctx context.Context, in *CheckConsistencyRequest, opts ...grpc.CallOption) (*CheckConsistencyResponse, error) {
	out := new(CheckConsistencyResponse)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_CheckConsistency_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) SnapshotTable(ctx context.Context, in *SnapshotTableRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_SnapshotTable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_GetSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error) {
	out := new(ListSnapshotsResponse)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_ListSnapshots_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_DeleteSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_CreateBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_GetBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) UpdateBackup(ctx context.Context, in *UpdateBackupRequest, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_UpdateBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_DeleteBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error) {
	out := new(ListBackupsResponse)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_ListBackups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) RestoreTable(ctx context.Context, in *RestoreTableRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_RestoreTable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) CopyBackup(ctx context.Context, in *CopyBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_CopyBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) CreateSchemaBundle(ctx context.Context, in *CreateSchemaBundleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_CreateSchemaBundle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) UpdateSchemaBundle(ctx context.Context, in *UpdateSchemaBundleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_UpdateSchemaBundle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) GetSchemaBundle(ctx context.Context, in *GetSchemaBundleRequest, opts ...grpc.CallOption) (*SchemaBundle, error) {
	out := new(SchemaBundle)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_GetSchemaBundle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) ListSchemaBundles(ctx context.Context, in *ListSchemaBundlesRequest, opts ...grpc.CallOption) (*ListSchemaBundlesResponse, error) {
	out := new(ListSchemaBundlesResponse)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_ListSchemaBundles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) DeleteSchemaBundle(ctx context.Context, in *DeleteSchemaBundleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BigtableTableAdmin_DeleteSchemaBundle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BigtableTableAdminServer is the server API for BigtableTableAdmin service.
// All implementations should embed UnimplementedBigtableTableAdminServer
// for forward compatibility
type BigtableTableAdminServer interface {
	// Creates a new table in the specified instance.
	// The table can be created with a full set of initial column families,
	// specified in the request.
	CreateTable(context.Context, *CreateTableRequest) (*Table, error)
	// Creates a new table from the specified snapshot. The target table must
	// not exist. The snapshot and the table must be in the same instance.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	CreateTableFromSnapshot(context.Context, *CreateTableFromSnapshotRequest) (*longrunningpb.Operation, error)
	// Lists all tables served from a specified instance.
	ListTables(context.Context, *ListTablesRequest) (*ListTablesResponse, error)
	// Gets metadata information about the specified table.
	GetTable(context.Context, *GetTableRequest) (*Table, error)
	// Updates a specified table.
	UpdateTable(context.Context, *UpdateTableRequest) (*longrunningpb.Operation, error)
	// Permanently deletes a specified table and all of its data.
	DeleteTable(context.Context, *DeleteTableRequest) (*emptypb.Empty, error)
	// Restores a specified table which was accidentally deleted.
	UndeleteTable(context.Context, *UndeleteTableRequest) (*longrunningpb.Operation, error)
	// Creates a new AuthorizedView in a table.
	CreateAuthorizedView(context.Context, *CreateAuthorizedViewRequest) (*longrunningpb.Operation, error)
	// Lists all AuthorizedViews from a specific table.
	ListAuthorizedViews(context.Context, *ListAuthorizedViewsRequest) (*ListAuthorizedViewsResponse, error)
	// Gets information from a specified AuthorizedView.
	GetAuthorizedView(context.Context, *GetAuthorizedViewRequest) (*AuthorizedView, error)
	// Updates an AuthorizedView in a table.
	UpdateAuthorizedView(context.Context, *UpdateAuthorizedViewRequest) (*longrunningpb.Operation, error)
	// Permanently deletes a specified AuthorizedView.
	DeleteAuthorizedView(context.Context, *DeleteAuthorizedViewRequest) (*emptypb.Empty, error)
	// Performs a series of column family modifications on the specified table.
	// Either all or none of the modifications will occur before this method
	// returns, but data requests received prior to that point may see a table
	// where only some modifications have taken effect.
	ModifyColumnFamilies(context.Context, *ModifyColumnFamiliesRequest) (*Table, error)
	// Permanently drop/delete a row range from a specified table. The request can
	// specify whether to delete all rows in a table, or only those that match a
	// particular prefix.
	DropRowRange(context.Context, *DropRowRangeRequest) (*emptypb.Empty, error)
	// Generates a consistency token for a Table, which can be used in
	// CheckConsistency to check whether mutations to the table that finished
	// before this call started have been replicated. The tokens will be available
	// for 90 days.
	GenerateConsistencyToken(context.Context, *GenerateConsistencyTokenRequest) (*GenerateConsistencyTokenResponse, error)
	// Checks replication consistency based on a consistency token, that is, if
	// replication has caught up based on the conditions specified in the token
	// and the check request.
	CheckConsistency(context.Context, *CheckConsistencyRequest) (*CheckConsistencyResponse, error)
	// Creates a new snapshot in the specified cluster from the specified
	// source table. The cluster and the table must be in the same instance.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	SnapshotTable(context.Context, *SnapshotTableRequest) (*longrunningpb.Operation, error)
	// Gets metadata information about the specified snapshot.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	GetSnapshot(context.Context, *GetSnapshotRequest) (*Snapshot, error)
	// Lists all snapshots associated with the specified cluster.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	ListSnapshots(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error)
	// Permanently deletes the specified snapshot.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	DeleteSnapshot(context.Context, *DeleteSnapshotRequest) (*emptypb.Empty, error)
	// Starts creating a new Cloud Bigtable Backup.  The returned backup
	// [long-running operation][google.longrunning.Operation] can be used to
	// track creation of the backup. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateBackupMetadata][google.bigtable.admin.v2.CreateBackupMetadata]. The
	// [response][google.longrunning.Operation.response] field type is
	// [Backup][google.bigtable.admin.v2.Backup], if successful. Cancelling the
	// returned operation will stop the creation and delete the backup.
	CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error)
	// Gets metadata on a pending or completed Cloud Bigtable Backup.
	GetBackup(context.Context, *GetBackupRequest) (*Backup, error)
	// Updates a pending or completed Cloud Bigtable Backup.
	UpdateBackup(context.Context, *UpdateBackupRequest) (*Backup, error)
	// Deletes a pending or completed Cloud Bigtable backup.
	DeleteBackup(context.Context, *DeleteBackupRequest) (*emptypb.Empty, error)
	// Lists Cloud Bigtable backups. Returns both completed and pending
	// backups.
	ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error)
	// Create a new table by restoring from a completed backup.  The
	// returned table [long-running operation][google.longrunning.Operation] can
	// be used to track the progress of the operation, and to cancel it.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [RestoreTableMetadata][google.bigtable.admin.v2.RestoreTableMetadata].  The
	// [response][google.longrunning.Operation.response] type is
	// [Table][google.bigtable.admin.v2.Table], if successful.
	RestoreTable(context.Context, *RestoreTableRequest) (*longrunningpb.Operation, error)
	// Copy a Cloud Bigtable backup to a new backup in the destination cluster
	// located in the destination instance and project.
	CopyBackup(context.Context, *CopyBackupRequest) (*longrunningpb.Operation, error)
	// Gets the access control policy for a Bigtable resource.
	// Returns an empty policy if the resource exists but does not have a policy
	// set.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the access control policy on a Bigtable resource.
	// Replaces any existing policy.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns permissions that the caller has on the specified Bigtable
	// resource.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Creates a new schema bundle in the specified table.
	CreateSchemaBundle(context.Context, *CreateSchemaBundleRequest) (*longrunningpb.Operation, error)
	// Updates a schema bundle in the specified table.
	UpdateSchemaBundle(context.Context, *UpdateSchemaBundleRequest) (*longrunningpb.Operation, error)
	// Gets metadata information about the specified schema bundle.
	GetSchemaBundle(context.Context, *GetSchemaBundleRequest) (*SchemaBundle, error)
	// Lists all schema bundles associated with the specified table.
	ListSchemaBundles(context.Context, *ListSchemaBundlesRequest) (*ListSchemaBundlesResponse, error)
	// Deletes a schema bundle in the specified table.
	DeleteSchemaBundle(context.Context, *DeleteSchemaBundleRequest) (*emptypb.Empty, error)
}

// UnimplementedBigtableTableAdminServer should be embedded to have forward compatible implementations.
type UnimplementedBigtableTableAdminServer struct {
}

func (UnimplementedBigtableTableAdminServer) CreateTable(context.Context, *CreateTableRequest) (*Table, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTable not implemented")
}
func (UnimplementedBigtableTableAdminServer) CreateTableFromSnapshot(context.Context, *CreateTableFromSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTableFromSnapshot not implemented")
}
func (UnimplementedBigtableTableAdminServer) ListTables(context.Context, *ListTablesRequest) (*ListTablesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTables not implemented")
}
func (UnimplementedBigtableTableAdminServer) GetTable(context.Context, *GetTableRequest) (*Table, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTable not implemented")
}
func (UnimplementedBigtableTableAdminServer) UpdateTable(context.Context, *UpdateTableRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTable not implemented")
}
func (UnimplementedBigtableTableAdminServer) DeleteTable(context.Context, *DeleteTableRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTable not implemented")
}
func (UnimplementedBigtableTableAdminServer) UndeleteTable(context.Context, *UndeleteTableRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteTable not implemented")
}
func (UnimplementedBigtableTableAdminServer) CreateAuthorizedView(context.Context, *CreateAuthorizedViewRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAuthorizedView not implemented")
}
func (UnimplementedBigtableTableAdminServer) ListAuthorizedViews(context.Context, *ListAuthorizedViewsRequest) (*ListAuthorizedViewsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAuthorizedViews not implemented")
}
func (UnimplementedBigtableTableAdminServer) GetAuthorizedView(context.Context, *GetAuthorizedViewRequest) (*AuthorizedView, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuthorizedView not implemented")
}
func (UnimplementedBigtableTableAdminServer) UpdateAuthorizedView(context.Context, *UpdateAuthorizedViewRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAuthorizedView not implemented")
}
func (UnimplementedBigtableTableAdminServer) DeleteAuthorizedView(context.Context, *DeleteAuthorizedViewRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAuthorizedView not implemented")
}
func (UnimplementedBigtableTableAdminServer) ModifyColumnFamilies(context.Context, *ModifyColumnFamiliesRequest) (*Table, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyColumnFamilies not implemented")
}
func (UnimplementedBigtableTableAdminServer) DropRowRange(context.Context, *DropRowRangeRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DropRowRange not implemented")
}
func (UnimplementedBigtableTableAdminServer) GenerateConsistencyToken(context.Context, *GenerateConsistencyTokenRequest) (*GenerateConsistencyTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateConsistencyToken not implemented")
}
func (UnimplementedBigtableTableAdminServer) CheckConsistency(context.Context, *CheckConsistencyRequest) (*CheckConsistencyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckConsistency not implemented")
}
func (UnimplementedBigtableTableAdminServer) SnapshotTable(context.Context, *SnapshotTableRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SnapshotTable not implemented")
}
func (UnimplementedBigtableTableAdminServer) GetSnapshot(context.Context, *GetSnapshotRequest) (*Snapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSnapshot not implemented")
}
func (UnimplementedBigtableTableAdminServer) ListSnapshots(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSnapshots not implemented")
}
func (UnimplementedBigtableTableAdminServer) DeleteSnapshot(context.Context, *DeleteSnapshotRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSnapshot not implemented")
}
func (UnimplementedBigtableTableAdminServer) CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackup not implemented")
}
func (UnimplementedBigtableTableAdminServer) GetBackup(context.Context, *GetBackupRequest) (*Backup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackup not implemented")
}
func (UnimplementedBigtableTableAdminServer) UpdateBackup(context.Context, *UpdateBackupRequest) (*Backup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBackup not implemented")
}
func (UnimplementedBigtableTableAdminServer) DeleteBackup(context.Context, *DeleteBackupRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackup not implemented")
}
func (UnimplementedBigtableTableAdminServer) ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackups not implemented")
}
func (UnimplementedBigtableTableAdminServer) RestoreTable(context.Context, *RestoreTableRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreTable not implemented")
}
func (UnimplementedBigtableTableAdminServer) CopyBackup(context.Context, *CopyBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CopyBackup not implemented")
}
func (UnimplementedBigtableTableAdminServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedBigtableTableAdminServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedBigtableTableAdminServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedBigtableTableAdminServer) CreateSchemaBundle(context.Context, *CreateSchemaBundleRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSchemaBundle not implemented")
}
func (UnimplementedBigtableTableAdminServer) UpdateSchemaBundle(context.Context, *UpdateSchemaBundleRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSchemaBundle not implemented")
}
func (UnimplementedBigtableTableAdminServer) GetSchemaBundle(context.Context, *GetSchemaBundleRequest) (*SchemaBundle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSchemaBundle not implemented")
}
func (UnimplementedBigtableTableAdminServer) ListSchemaBundles(context.Context, *ListSchemaBundlesRequest) (*ListSchemaBundlesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSchemaBundles not implemented")
}
func (UnimplementedBigtableTableAdminServer) DeleteSchemaBundle(context.Context, *DeleteSchemaBundleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSchemaBundle not implemented")
}

// UnsafeBigtableTableAdminServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BigtableTableAdminServer will
// result in compilation errors.
type UnsafeBigtableTableAdminServer interface {
	mustEmbedUnimplementedBigtableTableAdminServer()
}

func RegisterBigtableTableAdminServer(s grpc.ServiceRegistrar, srv BigtableTableAdminServer) {
	s.RegisterService(&BigtableTableAdmin_ServiceDesc, srv)
}

func _BigtableTableAdmin_CreateTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).CreateTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_CreateTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).CreateTable(ctx, req.(*CreateTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_CreateTableFromSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTableFromSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).CreateTableFromSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_CreateTableFromSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).CreateTableFromSnapshot(ctx, req.(*CreateTableFromSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_ListTables_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTablesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).ListTables(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_ListTables_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).ListTables(ctx, req.(*ListTablesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_GetTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).GetTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_GetTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).GetTable(ctx, req.(*GetTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_UpdateTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).UpdateTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_UpdateTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).UpdateTable(ctx, req.(*UpdateTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_DeleteTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).DeleteTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_DeleteTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).DeleteTable(ctx, req.(*DeleteTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_UndeleteTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).UndeleteTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_UndeleteTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).UndeleteTable(ctx, req.(*UndeleteTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_CreateAuthorizedView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAuthorizedViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).CreateAuthorizedView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_CreateAuthorizedView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).CreateAuthorizedView(ctx, req.(*CreateAuthorizedViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_ListAuthorizedViews_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAuthorizedViewsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).ListAuthorizedViews(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_ListAuthorizedViews_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).ListAuthorizedViews(ctx, req.(*ListAuthorizedViewsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_GetAuthorizedView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAuthorizedViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).GetAuthorizedView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_GetAuthorizedView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).GetAuthorizedView(ctx, req.(*GetAuthorizedViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_UpdateAuthorizedView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAuthorizedViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).UpdateAuthorizedView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_UpdateAuthorizedView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).UpdateAuthorizedView(ctx, req.(*UpdateAuthorizedViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_DeleteAuthorizedView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAuthorizedViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).DeleteAuthorizedView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_DeleteAuthorizedView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).DeleteAuthorizedView(ctx, req.(*DeleteAuthorizedViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_ModifyColumnFamilies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyColumnFamiliesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).ModifyColumnFamilies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_ModifyColumnFamilies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).ModifyColumnFamilies(ctx, req.(*ModifyColumnFamiliesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_DropRowRange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DropRowRangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).DropRowRange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_DropRowRange_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).DropRowRange(ctx, req.(*DropRowRangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_GenerateConsistencyToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateConsistencyTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).GenerateConsistencyToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_GenerateConsistencyToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).GenerateConsistencyToken(ctx, req.(*GenerateConsistencyTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_CheckConsistency_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckConsistencyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).CheckConsistency(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_CheckConsistency_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).CheckConsistency(ctx, req.(*CheckConsistencyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_SnapshotTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SnapshotTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).SnapshotTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_SnapshotTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).SnapshotTable(ctx, req.(*SnapshotTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_GetSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).GetSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_GetSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).GetSnapshot(ctx, req.(*GetSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_ListSnapshots_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).ListSnapshots(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_ListSnapshots_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).ListSnapshots(ctx, req.(*ListSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_DeleteSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).DeleteSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_DeleteSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).DeleteSnapshot(ctx, req.(*DeleteSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_CreateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).CreateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_CreateBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).CreateBackup(ctx, req.(*CreateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_GetBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).GetBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_GetBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).GetBackup(ctx, req.(*GetBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_UpdateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).UpdateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_UpdateBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).UpdateBackup(ctx, req.(*UpdateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_DeleteBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).DeleteBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_DeleteBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).DeleteBackup(ctx, req.(*DeleteBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_ListBackups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).ListBackups(ctx, req.(*ListBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_RestoreTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).RestoreTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_RestoreTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).RestoreTable(ctx, req.(*RestoreTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_CopyBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CopyBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).CopyBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_CopyBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).CopyBackup(ctx, req.(*CopyBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_CreateSchemaBundle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSchemaBundleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).CreateSchemaBundle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_CreateSchemaBundle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).CreateSchemaBundle(ctx, req.(*CreateSchemaBundleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_UpdateSchemaBundle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSchemaBundleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).UpdateSchemaBundle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_UpdateSchemaBundle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).UpdateSchemaBundle(ctx, req.(*UpdateSchemaBundleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_GetSchemaBundle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSchemaBundleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).GetSchemaBundle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_GetSchemaBundle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).GetSchemaBundle(ctx, req.(*GetSchemaBundleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_ListSchemaBundles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSchemaBundlesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).ListSchemaBundles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_ListSchemaBundles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).ListSchemaBundles(ctx, req.(*ListSchemaBundlesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_DeleteSchemaBundle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSchemaBundleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).DeleteSchemaBundle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableTableAdmin_DeleteSchemaBundle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).DeleteSchemaBundle(ctx, req.(*DeleteSchemaBundleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BigtableTableAdmin_ServiceDesc is the grpc.ServiceDesc for BigtableTableAdmin service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BigtableTableAdmin_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.bigtable.admin.v2.BigtableTableAdmin",
	HandlerType: (*BigtableTableAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTable",
			Handler:    _BigtableTableAdmin_CreateTable_Handler,
		},
		{
			MethodName: "CreateTableFromSnapshot",
			Handler:    _BigtableTableAdmin_CreateTableFromSnapshot_Handler,
		},
		{
			MethodName: "ListTables",
			Handler:    _BigtableTableAdmin_ListTables_Handler,
		},
		{
			MethodName: "GetTable",
			Handler:    _BigtableTableAdmin_GetTable_Handler,
		},
		{
			MethodName: "UpdateTable",
			Handler:    _BigtableTableAdmin_UpdateTable_Handler,
		},
		{
			MethodName: "DeleteTable",
			Handler:    _BigtableTableAdmin_DeleteTable_Handler,
		},
		{
			MethodName: "UndeleteTable",
			Handler:    _BigtableTableAdmin_UndeleteTable_Handler,
		},
		{
			MethodName: "CreateAuthorizedView",
			Handler:    _BigtableTableAdmin_CreateAuthorizedView_Handler,
		},
		{
			MethodName: "ListAuthorizedViews",
			Handler:    _BigtableTableAdmin_ListAuthorizedViews_Handler,
		},
		{
			MethodName: "GetAuthorizedView",
			Handler:    _BigtableTableAdmin_GetAuthorizedView_Handler,
		},
		{
			MethodName: "UpdateAuthorizedView",
			Handler:    _BigtableTableAdmin_UpdateAuthorizedView_Handler,
		},
		{
			MethodName: "DeleteAuthorizedView",
			Handler:    _BigtableTableAdmin_DeleteAuthorizedView_Handler,
		},
		{
			MethodName: "ModifyColumnFamilies",
			Handler:    _BigtableTableAdmin_ModifyColumnFamilies_Handler,
		},
		{
			MethodName: "DropRowRange",
			Handler:    _BigtableTableAdmin_DropRowRange_Handler,
		},
		{
			MethodName: "GenerateConsistencyToken",
			Handler:    _BigtableTableAdmin_GenerateConsistencyToken_Handler,
		},
		{
			MethodName: "CheckConsistency",
			Handler:    _BigtableTableAdmin_CheckConsistency_Handler,
		},
		{
			MethodName: "SnapshotTable",
			Handler:    _BigtableTableAdmin_SnapshotTable_Handler,
		},
		{
			MethodName: "GetSnapshot",
			Handler:    _BigtableTableAdmin_GetSnapshot_Handler,
		},
		{
			MethodName: "ListSnapshots",
			Handler:    _BigtableTableAdmin_ListSnapshots_Handler,
		},
		{
			MethodName: "DeleteSnapshot",
			Handler:    _BigtableTableAdmin_DeleteSnapshot_Handler,
		},
		{
			MethodName: "CreateBackup",
			Handler:    _BigtableTableAdmin_CreateBackup_Handler,
		},
		{
			MethodName: "GetBackup",
			Handler:    _BigtableTableAdmin_GetBackup_Handler,
		},
		{
			MethodName: "UpdateBackup",
			Handler:    _BigtableTableAdmin_UpdateBackup_Handler,
		},
		{
			MethodName: "DeleteBackup",
			Handler:    _BigtableTableAdmin_DeleteBackup_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _BigtableTableAdmin_ListBackups_Handler,
		},
		{
			MethodName: "RestoreTable",
			Handler:    _BigtableTableAdmin_RestoreTable_Handler,
		},
		{
			MethodName: "CopyBackup",
			Handler:    _BigtableTableAdmin_CopyBackup_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _BigtableTableAdmin_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _BigtableTableAdmin_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _BigtableTableAdmin_TestIamPermissions_Handler,
		},
		{
			MethodName: "CreateSchemaBundle",
			Handler:    _BigtableTableAdmin_CreateSchemaBundle_Handler,
		},
		{
			MethodName: "UpdateSchemaBundle",
			Handler:    _BigtableTableAdmin_UpdateSchemaBundle_Handler,
		},
		{
			MethodName: "GetSchemaBundle",
			Handler:    _BigtableTableAdmin_GetSchemaBundle_Handler,
		},
		{
			MethodName: "ListSchemaBundles",
			Handler:    _BigtableTableAdmin_ListSchemaBundles_Handler,
		},
		{
			MethodName: "DeleteSchemaBundle",
			Handler:    _BigtableTableAdmin_DeleteSchemaBundle_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/bigtable/admin/v2/bigtable_table_admin.proto",
}
