// DO NOT EDIT: This file is autogenerated via the builtin command.

package aggregate

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 2,
					Line:   140,
				},
				File:   "aggregate.flux",
				Source: "package aggregate\n\n\nimport \"contrib/jsternberg/math\"\n\n// table will aggregate columns and create tables with a single\n// row containing the aggregated value.\n//\n// This function takes a single parameter of `columns`. The parameter\n// is an object with the output column name as the key and the aggregate\n// object as the value.\n//\n// The aggregate object is composed of at least the following required attributes:\n//     column = string\n//         The column name for the input.\n//     init = (values) -> state\n//         An initial function to compute the initial state of the\n//         output. This can return either the final aggregate or a\n//         temporary state object that can be used to compute the\n//         final aggregate. The values parameter will always be a\n//         non-empty array of values from the specified column.\n//     reduce = (values, state) -> state\n//         A function that takes in another buffer of values\n//         and the current state of the aggregate and computes\n//         the updated state.\n//     compute = (state) -> value\n//         A function that takes the state and computes the final\n//         aggregate.\n//     fill = value\n//         The value passed to fill, if present, will determine what\n//         the aggregate does when there are no values.\n//         This can either be a value or one of the predefined\n//         identifiers of null or none.\n//         This value must be the same type as the value return from\n//         compute.\n//\n// An example of usage is:\n//     tables |> aggregate.table(columns: {\n//         \"min_bottom_degrees\": aggregate.min(column: \"bottom_degrees\"),\n//     ])\nbuiltin table : (<-tables: [A], columns: C) => [B] where A: Record, B: Record, C: Record\n\n// window will aggregate columns and create tables by\n// organizing incoming points into windows.\n//\n// Each table will have two additional columns: start and stop.\n// These are the start and stop times for each interval.\n// It is not possible to use start or stop as destination column\n// names with this function. The start and stop columns are not\n// added to the group key.\n//\n// The same options as for table apply to window.\n// In addition to those options, window requires one\n// additional parameter.\n//     every = duration\n//         The duration between the start of each interval.\n//\n// Along with the above required option, there are a few additional\n// optional parameters.\n//     time = string\n//         The column name for the time input.\n//         This defaults to _time or time, whichever is earlier in\n//         the list of columns.\n//     period = duration\n//         The length of the interval. This defaults to the\n//         every duration.\nbuiltin window : (\n    <-tables: [A],\n    ?time: string,\n    every: duration,\n    ?period: duration,\n    columns: C,\n) => [B] where\n    A: Record,\n    B: Record,\n    C: Record\n\n// null is a sentinel value for fill that will fill\n// in a null value if there were no values for an interval.\nbuiltin null : A\n\n// none is a sentinel value for fill that will skip\n// emitting a row if there are no values for an interval.\nbuiltin none : A\n\n// define will define an aggregate function.\ndefine = (init, reduce, compute, fill=null) => (column=\"_value\", fill=fill) => ({\n    column: column,\n    init: init,\n    reduce: reduce,\n    compute: compute,\n    fill: fill,\n})\n_make_selector = (fn) => define(\n    init: (values) => fn(values),\n    reduce: (values, state) => {\n        v = fn(values)\n\n        return fn(values: [state, v])\n    },\n    compute: (state) => state,\n)\n\n// min constructs a min aggregate or selector for the column.\nmin = _make_selector(fn: math.min)\n\n// max constructs a max aggregate or selector for the column.\nmax = _make_selector(fn: math.max)\n\n// sum constructs a sum aggregate for the column.\nsum = define(\n    init: (values) => math.sum(values),\n    reduce: (values, state) => {\n        return state + math.sum(values)\n    },\n    compute: (state) => state,\n)\n\n// count constructs a count aggregate for the column.\ncount = define(\n    init: (values) => length(arr: values),\n    reduce: (values, state) => {\n        return state + length(arr: values)\n    },\n    compute: (state) => state,\n    fill: 0,\n)\n\n// mean constructs a mean aggregate for the column.\nmean = define(\n    init: (values) => ({\n        sum: math.sum(values),\n        count: length(arr: values),\n    }),\n    reduce: (values, state) => ({\n        sum: state.sum + math.sum(values),\n        count: state.count + length(arr: values),\n    }),\n    compute: (state) => float(v: state.sum) / float(v: state.count),\n)",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// table will aggregate columns and create tables with a single\n"}, ast.Comment{Text: "// row containing the aggregated value.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// This function takes a single parameter of `columns`. The parameter\n"}, ast.Comment{Text: "// is an object with the output column name as the key and the aggregate\n"}, ast.Comment{Text: "// object as the value.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The aggregate object is composed of at least the following required attributes:\n"}, ast.Comment{Text: "//     column = string\n"}, ast.Comment{Text: "//         The column name for the input.\n"}, ast.Comment{Text: "//     init = (values) -> state\n"}, ast.Comment{Text: "//         An initial function to compute the initial state of the\n"}, ast.Comment{Text: "//         output. This can return either the final aggregate or a\n"}, ast.Comment{Text: "//         temporary state object that can be used to compute the\n"}, ast.Comment{Text: "//         final aggregate. The values parameter will always be a\n"}, ast.Comment{Text: "//         non-empty array of values from the specified column.\n"}, ast.Comment{Text: "//     reduce = (values, state) -> state\n"}, ast.Comment{Text: "//         A function that takes in another buffer of values\n"}, ast.Comment{Text: "//         and the current state of the aggregate and computes\n"}, ast.Comment{Text: "//         the updated state.\n"}, ast.Comment{Text: "//     compute = (state) -> value\n"}, ast.Comment{Text: "//         A function that takes the state and computes the final\n"}, ast.Comment{Text: "//         aggregate.\n"}, ast.Comment{Text: "//     fill = value\n"}, ast.Comment{Text: "//         The value passed to fill, if present, will determine what\n"}, ast.Comment{Text: "//         the aggregate does when there are no values.\n"}, ast.Comment{Text: "//         This can either be a value or one of the predefined\n"}, ast.Comment{Text: "//         identifiers of null or none.\n"}, ast.Comment{Text: "//         This value must be the same type as the value return from\n"}, ast.Comment{Text: "//         compute.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// An example of usage is:\n"}, ast.Comment{Text: "//     tables |> aggregate.table(columns: {\n"}, ast.Comment{Text: "//         \"min_bottom_degrees\": aggregate.min(column: \"bottom_degrees\"),\n"}, ast.Comment{Text: "//     ])\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   41,
					},
					File:   "aggregate.flux",
					Source: "builtin table",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   41,
						},
						File:   "aggregate.flux",
						Source: "table",
						Start: ast.Position{
							Column: 9,
							Line:   41,
						},
					},
				},
				Name: "table",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 89,
							Line:   41,
						},
						File:   "aggregate.flux",
						Source: "(<-tables: [A], columns: C) => [B] where A: Record, B: Record, C: Record",
						Start: ast.Position{
							Column: 17,
							Line:   41,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 67,
								Line:   41,
							},
							File:   "aggregate.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 58,
								Line:   41,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   41,
								},
								File:   "aggregate.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 61,
									Line:   41,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   41,
								},
								File:   "aggregate.flux",
								Source: "A",
								Start: ast.Position{
									Column: 58,
									Line:   41,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 78,
								Line:   41,
							},
							File:   "aggregate.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 69,
								Line:   41,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   41,
								},
								File:   "aggregate.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 72,
									Line:   41,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   41,
								},
								File:   "aggregate.flux",
								Source: "B",
								Start: ast.Position{
									Column: 69,
									Line:   41,
								},
							},
						},
						Name: "B",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 89,
								Line:   41,
							},
							File:   "aggregate.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 80,
								Line:   41,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   41,
								},
								File:   "aggregate.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 83,
									Line:   41,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   41,
								},
								File:   "aggregate.flux",
								Source: "C",
								Start: ast.Position{
									Column: 80,
									Line:   41,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   41,
							},
							File:   "aggregate.flux",
							Source: "(<-tables: [A], columns: C) => [B]",
							Start: ast.Position{
								Column: 17,
								Line:   41,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   41,
								},
								File:   "aggregate.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   41,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   41,
									},
									File:   "aggregate.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   41,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   41,
									},
									File:   "aggregate.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   41,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   41,
										},
										File:   "aggregate.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   41,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   41,
											},
											File:   "aggregate.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   41,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   41,
								},
								File:   "aggregate.flux",
								Source: "columns: C",
								Start: ast.Position{
									Column: 33,
									Line:   41,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   41,
									},
									File:   "aggregate.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 33,
										Line:   41,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   41,
									},
									File:   "aggregate.flux",
									Source: "C",
									Start: ast.Position{
										Column: 42,
										Line:   41,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   41,
										},
										File:   "aggregate.flux",
										Source: "C",
										Start: ast.Position{
											Column: 42,
											Line:   41,
										},
									},
								},
								Name: "C",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   41,
								},
								File:   "aggregate.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 48,
									Line:   41,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   41,
									},
									File:   "aggregate.flux",
									Source: "B",
									Start: ast.Position{
										Column: 49,
										Line:   41,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   41,
										},
										File:   "aggregate.flux",
										Source: "B",
										Start: ast.Position{
											Column: 49,
											Line:   41,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// window will aggregate columns and create tables by\n"}, ast.Comment{Text: "// organizing incoming points into windows.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Each table will have two additional columns: start and stop.\n"}, ast.Comment{Text: "// These are the start and stop times for each interval.\n"}, ast.Comment{Text: "// It is not possible to use start or stop as destination column\n"}, ast.Comment{Text: "// names with this function. The start and stop columns are not\n"}, ast.Comment{Text: "// added to the group key.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The same options as for table apply to window.\n"}, ast.Comment{Text: "// In addition to those options, window requires one\n"}, ast.Comment{Text: "// additional parameter.\n"}, ast.Comment{Text: "//     every = duration\n"}, ast.Comment{Text: "//         The duration between the start of each interval.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Along with the above required option, there are a few additional\n"}, ast.Comment{Text: "// optional parameters.\n"}, ast.Comment{Text: "//     time = string\n"}, ast.Comment{Text: "//         The column name for the time input.\n"}, ast.Comment{Text: "//         This defaults to _time or time, whichever is earlier in\n"}, ast.Comment{Text: "//         the list of columns.\n"}, ast.Comment{Text: "//     period = duration\n"}, ast.Comment{Text: "//         The length of the interval. This defaults to the\n"}, ast.Comment{Text: "//         every duration.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   67,
					},
					File:   "aggregate.flux",
					Source: "builtin window",
					Start: ast.Position{
						Column: 1,
						Line:   67,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   67,
						},
						File:   "aggregate.flux",
						Source: "window",
						Start: ast.Position{
							Column: 9,
							Line:   67,
						},
					},
				},
				Name: "window",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   76,
						},
						File:   "aggregate.flux",
						Source: "(\n    <-tables: [A],\n    ?time: string,\n    every: duration,\n    ?period: duration,\n    columns: C,\n) => [B] where\n    A: Record,\n    B: Record,\n    C: Record",
						Start: ast.Position{
							Column: 18,
							Line:   67,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   74,
							},
							File:   "aggregate.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   74,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   74,
								},
								File:   "aggregate.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   74,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   74,
								},
								File:   "aggregate.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   74,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   75,
							},
							File:   "aggregate.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   75,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   75,
								},
								File:   "aggregate.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   75,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   75,
								},
								File:   "aggregate.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   75,
								},
							},
						},
						Name: "B",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   76,
							},
							File:   "aggregate.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 5,
								Line:   76,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   76,
								},
								File:   "aggregate.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   76,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   76,
								},
								File:   "aggregate.flux",
								Source: "C",
								Start: ast.Position{
									Column: 5,
									Line:   76,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   73,
							},
							File:   "aggregate.flux",
							Source: "(\n    <-tables: [A],\n    ?time: string,\n    every: duration,\n    ?period: duration,\n    columns: C,\n) => [B]",
							Start: ast.Position{
								Column: 18,
								Line:   67,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   68,
								},
								File:   "aggregate.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   68,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   68,
									},
									File:   "aggregate.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   68,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   68,
									},
									File:   "aggregate.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   68,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   68,
										},
										File:   "aggregate.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   68,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   68,
											},
											File:   "aggregate.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   68,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   69,
								},
								File:   "aggregate.flux",
								Source: "?time: string",
								Start: ast.Position{
									Column: 5,
									Line:   69,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   69,
									},
									File:   "aggregate.flux",
									Source: "time",
									Start: ast.Position{
										Column: 6,
										Line:   69,
									},
								},
							},
							Name: "time",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   69,
									},
									File:   "aggregate.flux",
									Source: "string",
									Start: ast.Position{
										Column: 12,
										Line:   69,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   69,
										},
										File:   "aggregate.flux",
										Source: "string",
										Start: ast.Position{
											Column: 12,
											Line:   69,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   70,
								},
								File:   "aggregate.flux",
								Source: "every: duration",
								Start: ast.Position{
									Column: 5,
									Line:   70,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   70,
									},
									File:   "aggregate.flux",
									Source: "every",
									Start: ast.Position{
										Column: 5,
										Line:   70,
									},
								},
							},
							Name: "every",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   70,
									},
									File:   "aggregate.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 12,
										Line:   70,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   70,
										},
										File:   "aggregate.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 12,
											Line:   70,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   71,
								},
								File:   "aggregate.flux",
								Source: "?period: duration",
								Start: ast.Position{
									Column: 5,
									Line:   71,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   71,
									},
									File:   "aggregate.flux",
									Source: "period",
									Start: ast.Position{
										Column: 6,
										Line:   71,
									},
								},
							},
							Name: "period",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   71,
									},
									File:   "aggregate.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 14,
										Line:   71,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   71,
										},
										File:   "aggregate.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 14,
											Line:   71,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   72,
								},
								File:   "aggregate.flux",
								Source: "columns: C",
								Start: ast.Position{
									Column: 5,
									Line:   72,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   72,
									},
									File:   "aggregate.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 5,
										Line:   72,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   72,
									},
									File:   "aggregate.flux",
									Source: "C",
									Start: ast.Position{
										Column: 14,
										Line:   72,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   72,
										},
										File:   "aggregate.flux",
										Source: "C",
										Start: ast.Position{
											Column: 14,
											Line:   72,
										},
									},
								},
								Name: "C",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   73,
								},
								File:   "aggregate.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   73,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   73,
									},
									File:   "aggregate.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   73,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   73,
										},
										File:   "aggregate.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   73,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// null is a sentinel value for fill that will fill\n"}, ast.Comment{Text: "// in a null value if there were no values for an interval.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   80,
					},
					File:   "aggregate.flux",
					Source: "builtin null",
					Start: ast.Position{
						Column: 1,
						Line:   80,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   80,
						},
						File:   "aggregate.flux",
						Source: "null",
						Start: ast.Position{
							Column: 9,
							Line:   80,
						},
					},
				},
				Name: "null",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   80,
						},
						File:   "aggregate.flux",
						Source: "A",
						Start: ast.Position{
							Column: 16,
							Line:   80,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.TvarType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   80,
							},
							File:   "aggregate.flux",
							Source: "A",
							Start: ast.Position{
								Column: 16,
								Line:   80,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   80,
								},
								File:   "aggregate.flux",
								Source: "A",
								Start: ast.Position{
									Column: 16,
									Line:   80,
								},
							},
						},
						Name: "A",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// none is a sentinel value for fill that will skip\n"}, ast.Comment{Text: "// emitting a row if there are no values for an interval.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   84,
					},
					File:   "aggregate.flux",
					Source: "builtin none",
					Start: ast.Position{
						Column: 1,
						Line:   84,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   84,
						},
						File:   "aggregate.flux",
						Source: "none",
						Start: ast.Position{
							Column: 9,
							Line:   84,
						},
					},
				},
				Name: "none",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   84,
						},
						File:   "aggregate.flux",
						Source: "A",
						Start: ast.Position{
							Column: 16,
							Line:   84,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.TvarType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   84,
							},
							File:   "aggregate.flux",
							Source: "A",
							Start: ast.Position{
								Column: 16,
								Line:   84,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   84,
								},
								File:   "aggregate.flux",
								Source: "A",
								Start: ast.Position{
									Column: 16,
									Line:   84,
								},
							},
						},
						Name: "A",
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   93,
					},
					File:   "aggregate.flux",
					Source: "define = (init, reduce, compute, fill=null) => (column=\"_value\", fill=fill) => ({\n    column: column,\n    init: init,\n    reduce: reduce,\n    compute: compute,\n    fill: fill,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   87,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// define will define an aggregate function.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   87,
						},
						File:   "aggregate.flux",
						Source: "define",
						Start: ast.Position{
							Column: 1,
							Line:   87,
						},
					},
				},
				Name: "define",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   93,
						},
						File:   "aggregate.flux",
						Source: "(init, reduce, compute, fill=null) => (column=\"_value\", fill=fill) => ({\n    column: column,\n    init: init,\n    reduce: reduce,\n    compute: compute,\n    fill: fill,\n})",
						Start: ast.Position{
							Column: 10,
							Line:   87,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   93,
							},
							File:   "aggregate.flux",
							Source: "(column=\"_value\", fill=fill) => ({\n    column: column,\n    init: init,\n    reduce: reduce,\n    compute: compute,\n    fill: fill,\n})",
							Start: ast.Position{
								Column: 48,
								Line:   87,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   93,
								},
								File:   "aggregate.flux",
								Source: "({\n    column: column,\n    init: init,\n    reduce: reduce,\n    compute: compute,\n    fill: fill,\n})",
								Start: ast.Position{
									Column: 80,
									Line:   87,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   93,
									},
									File:   "aggregate.flux",
									Source: "{\n    column: column,\n    init: init,\n    reduce: reduce,\n    compute: compute,\n    fill: fill,\n}",
									Start: ast.Position{
										Column: 81,
										Line:   87,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   88,
										},
										File:   "aggregate.flux",
										Source: "column: column",
										Start: ast.Position{
											Column: 5,
											Line:   88,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   88,
											},
											File:   "aggregate.flux",
											Source: "column",
											Start: ast.Position{
												Column: 5,
												Line:   88,
											},
										},
									},
									Name: "column",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   88,
											},
											File:   "aggregate.flux",
											Source: "column",
											Start: ast.Position{
												Column: 13,
												Line:   88,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   89,
										},
										File:   "aggregate.flux",
										Source: "init: init",
										Start: ast.Position{
											Column: 5,
											Line:   89,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   89,
											},
											File:   "aggregate.flux",
											Source: "init",
											Start: ast.Position{
												Column: 5,
												Line:   89,
											},
										},
									},
									Name: "init",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   89,
											},
											File:   "aggregate.flux",
											Source: "init",
											Start: ast.Position{
												Column: 11,
												Line:   89,
											},
										},
									},
									Name: "init",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   90,
										},
										File:   "aggregate.flux",
										Source: "reduce: reduce",
										Start: ast.Position{
											Column: 5,
											Line:   90,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   90,
											},
											File:   "aggregate.flux",
											Source: "reduce",
											Start: ast.Position{
												Column: 5,
												Line:   90,
											},
										},
									},
									Name: "reduce",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   90,
											},
											File:   "aggregate.flux",
											Source: "reduce",
											Start: ast.Position{
												Column: 13,
												Line:   90,
											},
										},
									},
									Name: "reduce",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   91,
										},
										File:   "aggregate.flux",
										Source: "compute: compute",
										Start: ast.Position{
											Column: 5,
											Line:   91,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   91,
											},
											File:   "aggregate.flux",
											Source: "compute",
											Start: ast.Position{
												Column: 5,
												Line:   91,
											},
										},
									},
									Name: "compute",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   91,
											},
											File:   "aggregate.flux",
											Source: "compute",
											Start: ast.Position{
												Column: 14,
												Line:   91,
											},
										},
									},
									Name: "compute",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   92,
										},
										File:   "aggregate.flux",
										Source: "fill: fill",
										Start: ast.Position{
											Column: 5,
											Line:   92,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   92,
											},
											File:   "aggregate.flux",
											Source: "fill",
											Start: ast.Position{
												Column: 5,
												Line:   92,
											},
										},
									},
									Name: "fill",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   92,
											},
											File:   "aggregate.flux",
											Source: "fill",
											Start: ast.Position{
												Column: 11,
												Line:   92,
											},
										},
									},
									Name: "fill",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   87,
								},
								File:   "aggregate.flux",
								Source: "column=\"_value\"",
								Start: ast.Position{
									Column: 49,
									Line:   87,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   87,
									},
									File:   "aggregate.flux",
									Source: "column",
									Start: ast.Position{
										Column: 49,
										Line:   87,
									},
								},
							},
							Name: "column",
						},
						Separator: nil,
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   87,
									},
									File:   "aggregate.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 56,
										Line:   87,
									},
								},
							},
							Value: "_value",
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   87,
								},
								File:   "aggregate.flux",
								Source: "fill=fill",
								Start: ast.Position{
									Column: 66,
									Line:   87,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   87,
									},
									File:   "aggregate.flux",
									Source: "fill",
									Start: ast.Position{
										Column: 66,
										Line:   87,
									},
								},
							},
							Name: "fill",
						},
						Separator: nil,
						Value: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   87,
									},
									File:   "aggregate.flux",
									Source: "fill",
									Start: ast.Position{
										Column: 71,
										Line:   87,
									},
								},
							},
							Name: "fill",
						},
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   87,
							},
							File:   "aggregate.flux",
							Source: "init",
							Start: ast.Position{
								Column: 11,
								Line:   87,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   87,
								},
								File:   "aggregate.flux",
								Source: "init",
								Start: ast.Position{
									Column: 11,
									Line:   87,
								},
							},
						},
						Name: "init",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   87,
							},
							File:   "aggregate.flux",
							Source: "reduce",
							Start: ast.Position{
								Column: 17,
								Line:   87,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   87,
								},
								File:   "aggregate.flux",
								Source: "reduce",
								Start: ast.Position{
									Column: 17,
									Line:   87,
								},
							},
						},
						Name: "reduce",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   87,
							},
							File:   "aggregate.flux",
							Source: "compute",
							Start: ast.Position{
								Column: 25,
								Line:   87,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   87,
								},
								File:   "aggregate.flux",
								Source: "compute",
								Start: ast.Position{
									Column: 25,
									Line:   87,
								},
							},
						},
						Name: "compute",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   87,
							},
							File:   "aggregate.flux",
							Source: "fill=null",
							Start: ast.Position{
								Column: 34,
								Line:   87,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   87,
								},
								File:   "aggregate.flux",
								Source: "fill",
								Start: ast.Position{
									Column: 34,
									Line:   87,
								},
							},
						},
						Name: "fill",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   87,
								},
								File:   "aggregate.flux",
								Source: "null",
								Start: ast.Position{
									Column: 39,
									Line:   87,
								},
							},
						},
						Name: "null",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   102,
					},
					File:   "aggregate.flux",
					Source: "_make_selector = (fn) => define(\n    init: (values) => fn(values),\n    reduce: (values, state) => {\n        v = fn(values)\n\n        return fn(values: [state, v])\n    },\n    compute: (state) => state,\n)",
					Start: ast.Position{
						Column: 1,
						Line:   94,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   94,
						},
						File:   "aggregate.flux",
						Source: "_make_selector",
						Start: ast.Position{
							Column: 1,
							Line:   94,
						},
					},
				},
				Name: "_make_selector",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   102,
						},
						File:   "aggregate.flux",
						Source: "(fn) => define(\n    init: (values) => fn(values),\n    reduce: (values, state) => {\n        v = fn(values)\n\n        return fn(values: [state, v])\n    },\n    compute: (state) => state,\n)",
						Start: ast.Position{
							Column: 18,
							Line:   94,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   101,
								},
								File:   "aggregate.flux",
								Source: "init: (values) => fn(values),\n    reduce: (values, state) => {\n        v = fn(values)\n\n        return fn(values: [state, v])\n    },\n    compute: (state) => state",
								Start: ast.Position{
									Column: 5,
									Line:   95,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   95,
									},
									File:   "aggregate.flux",
									Source: "init: (values) => fn(values)",
									Start: ast.Position{
										Column: 5,
										Line:   95,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   95,
										},
										File:   "aggregate.flux",
										Source: "init",
										Start: ast.Position{
											Column: 5,
											Line:   95,
										},
									},
								},
								Name: "init",
							},
							Separator: nil,
							Value: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   95,
										},
										File:   "aggregate.flux",
										Source: "(values) => fn(values)",
										Start: ast.Position{
											Column: 11,
											Line:   95,
										},
									},
								},
								Body: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   95,
												},
												File:   "aggregate.flux",
												Source: "values",
												Start: ast.Position{
													Column: 26,
													Line:   95,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   95,
													},
													File:   "aggregate.flux",
													Source: "values",
													Start: ast.Position{
														Column: 26,
														Line:   95,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   95,
														},
														File:   "aggregate.flux",
														Source: "values",
														Start: ast.Position{
															Column: 26,
															Line:   95,
														},
													},
												},
												Name: "values",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   95,
											},
											File:   "aggregate.flux",
											Source: "fn(values)",
											Start: ast.Position{
												Column: 23,
												Line:   95,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   95,
												},
												File:   "aggregate.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 23,
													Line:   95,
												},
											},
										},
										Name: "fn",
									},
									Lparen: nil,
									Rparen: nil,
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   95,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 12,
												Line:   95,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   95,
												},
												File:   "aggregate.flux",
												Source: "values",
												Start: ast.Position{
													Column: 12,
													Line:   95,
												},
											},
										},
										Name: "values",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   100,
									},
									File:   "aggregate.flux",
									Source: "reduce: (values, state) => {\n        v = fn(values)\n\n        return fn(values: [state, v])\n    }",
									Start: ast.Position{
										Column: 5,
										Line:   96,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   96,
										},
										File:   "aggregate.flux",
										Source: "reduce",
										Start: ast.Position{
											Column: 5,
											Line:   96,
										},
									},
								},
								Name: "reduce",
							},
							Separator: nil,
							Value: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   100,
										},
										File:   "aggregate.flux",
										Source: "(values, state) => {\n        v = fn(values)\n\n        return fn(values: [state, v])\n    }",
										Start: ast.Position{
											Column: 13,
											Line:   96,
										},
									},
								},
								Body: &ast.Block{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   100,
											},
											File:   "aggregate.flux",
											Source: "{\n        v = fn(values)\n\n        return fn(values: [state, v])\n    }",
											Start: ast.Position{
												Column: 32,
												Line:   96,
											},
										},
									},
									Body: []ast.Statement{&ast.VariableAssignment{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   97,
												},
												File:   "aggregate.flux",
												Source: "v = fn(values)",
												Start: ast.Position{
													Column: 9,
													Line:   97,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   97,
													},
													File:   "aggregate.flux",
													Source: "v",
													Start: ast.Position{
														Column: 9,
														Line:   97,
													},
												},
											},
											Name: "v",
										},
										Init: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   97,
														},
														File:   "aggregate.flux",
														Source: "values",
														Start: ast.Position{
															Column: 16,
															Line:   97,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   97,
															},
															File:   "aggregate.flux",
															Source: "values",
															Start: ast.Position{
																Column: 16,
																Line:   97,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   97,
																},
																File:   "aggregate.flux",
																Source: "values",
																Start: ast.Position{
																	Column: 16,
																	Line:   97,
																},
															},
														},
														Name: "values",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   97,
													},
													File:   "aggregate.flux",
													Source: "fn(values)",
													Start: ast.Position{
														Column: 13,
														Line:   97,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   97,
														},
														File:   "aggregate.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 13,
															Line:   97,
														},
													},
												},
												Name: "fn",
											},
											Lparen: nil,
											Rparen: nil,
										},
									}, &ast.ReturnStatement{
										Argument: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   99,
														},
														File:   "aggregate.flux",
														Source: "values: [state, v]",
														Start: ast.Position{
															Column: 19,
															Line:   99,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   99,
															},
															File:   "aggregate.flux",
															Source: "values: [state, v]",
															Start: ast.Position{
																Column: 19,
																Line:   99,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   99,
																},
																File:   "aggregate.flux",
																Source: "values",
																Start: ast.Position{
																	Column: 19,
																	Line:   99,
																},
															},
														},
														Name: "values",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   99,
																},
																File:   "aggregate.flux",
																Source: "[state, v]",
																Start: ast.Position{
																	Column: 27,
																	Line:   99,
																},
															},
														},
														Elements: []ast.Expression{&ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   99,
																	},
																	File:   "aggregate.flux",
																	Source: "state",
																	Start: ast.Position{
																		Column: 28,
																		Line:   99,
																	},
																},
															},
															Name: "state",
														}, &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   99,
																	},
																	File:   "aggregate.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 35,
																		Line:   99,
																	},
																},
															},
															Name: "v",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   99,
													},
													File:   "aggregate.flux",
													Source: "fn(values: [state, v])",
													Start: ast.Position{
														Column: 16,
														Line:   99,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   99,
														},
														File:   "aggregate.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 16,
															Line:   99,
														},
													},
												},
												Name: "fn",
											},
											Lparen: nil,
											Rparen: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   99,
												},
												File:   "aggregate.flux",
												Source: "return fn(values: [state, v])",
												Start: ast.Position{
													Column: 9,
													Line:   99,
												},
											},
										},
									}},
									Lbrace: nil,
									Rbrace: nil,
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   96,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 14,
												Line:   96,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   96,
												},
												File:   "aggregate.flux",
												Source: "values",
												Start: ast.Position{
													Column: 14,
													Line:   96,
												},
											},
										},
										Name: "values",
									},
									Separator: nil,
									Value:     nil,
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   96,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 22,
												Line:   96,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   96,
												},
												File:   "aggregate.flux",
												Source: "state",
												Start: ast.Position{
													Column: 22,
													Line:   96,
												},
											},
										},
										Name: "state",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   101,
									},
									File:   "aggregate.flux",
									Source: "compute: (state) => state",
									Start: ast.Position{
										Column: 5,
										Line:   101,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   101,
										},
										File:   "aggregate.flux",
										Source: "compute",
										Start: ast.Position{
											Column: 5,
											Line:   101,
										},
									},
								},
								Name: "compute",
							},
							Separator: nil,
							Value: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   101,
										},
										File:   "aggregate.flux",
										Source: "(state) => state",
										Start: ast.Position{
											Column: 14,
											Line:   101,
										},
									},
								},
								Body: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   101,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 25,
												Line:   101,
											},
										},
									},
									Name: "state",
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   101,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 15,
												Line:   101,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   101,
												},
												File:   "aggregate.flux",
												Source: "state",
												Start: ast.Position{
													Column: 15,
													Line:   101,
												},
											},
										},
										Name: "state",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   102,
							},
							File:   "aggregate.flux",
							Source: "define(\n    init: (values) => fn(values),\n    reduce: (values, state) => {\n        v = fn(values)\n\n        return fn(values: [state, v])\n    },\n    compute: (state) => state,\n)",
							Start: ast.Position{
								Column: 26,
								Line:   94,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   94,
								},
								File:   "aggregate.flux",
								Source: "define",
								Start: ast.Position{
									Column: 26,
									Line:   94,
								},
							},
						},
						Name: "define",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   94,
							},
							File:   "aggregate.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 19,
								Line:   94,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   94,
								},
								File:   "aggregate.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 19,
									Line:   94,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 35,
						Line:   105,
					},
					File:   "aggregate.flux",
					Source: "min = _make_selector(fn: math.min)",
					Start: ast.Position{
						Column: 1,
						Line:   105,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// min constructs a min aggregate or selector for the column.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   105,
						},
						File:   "aggregate.flux",
						Source: "min",
						Start: ast.Position{
							Column: 1,
							Line:   105,
						},
					},
				},
				Name: "min",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   105,
							},
							File:   "aggregate.flux",
							Source: "fn: math.min",
							Start: ast.Position{
								Column: 22,
								Line:   105,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   105,
								},
								File:   "aggregate.flux",
								Source: "fn: math.min",
								Start: ast.Position{
									Column: 22,
									Line:   105,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   105,
									},
									File:   "aggregate.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 22,
										Line:   105,
									},
								},
							},
							Name: "fn",
						},
						Separator: nil,
						Value: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   105,
									},
									File:   "aggregate.flux",
									Source: "math.min",
									Start: ast.Position{
										Column: 26,
										Line:   105,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   105,
										},
										File:   "aggregate.flux",
										Source: "math",
										Start: ast.Position{
											Column: 26,
											Line:   105,
										},
									},
								},
								Name: "math",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   105,
										},
										File:   "aggregate.flux",
										Source: "min",
										Start: ast.Position{
											Column: 31,
											Line:   105,
										},
									},
								},
								Name: "min",
							},
							Rbrack: nil,
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   105,
						},
						File:   "aggregate.flux",
						Source: "_make_selector(fn: math.min)",
						Start: ast.Position{
							Column: 7,
							Line:   105,
						},
					},
				},
				Callee: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   105,
							},
							File:   "aggregate.flux",
							Source: "_make_selector",
							Start: ast.Position{
								Column: 7,
								Line:   105,
							},
						},
					},
					Name: "_make_selector",
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 35,
						Line:   108,
					},
					File:   "aggregate.flux",
					Source: "max = _make_selector(fn: math.max)",
					Start: ast.Position{
						Column: 1,
						Line:   108,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// max constructs a max aggregate or selector for the column.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   108,
						},
						File:   "aggregate.flux",
						Source: "max",
						Start: ast.Position{
							Column: 1,
							Line:   108,
						},
					},
				},
				Name: "max",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   108,
							},
							File:   "aggregate.flux",
							Source: "fn: math.max",
							Start: ast.Position{
								Column: 22,
								Line:   108,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   108,
								},
								File:   "aggregate.flux",
								Source: "fn: math.max",
								Start: ast.Position{
									Column: 22,
									Line:   108,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   108,
									},
									File:   "aggregate.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 22,
										Line:   108,
									},
								},
							},
							Name: "fn",
						},
						Separator: nil,
						Value: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   108,
									},
									File:   "aggregate.flux",
									Source: "math.max",
									Start: ast.Position{
										Column: 26,
										Line:   108,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   108,
										},
										File:   "aggregate.flux",
										Source: "math",
										Start: ast.Position{
											Column: 26,
											Line:   108,
										},
									},
								},
								Name: "math",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   108,
										},
										File:   "aggregate.flux",
										Source: "max",
										Start: ast.Position{
											Column: 31,
											Line:   108,
										},
									},
								},
								Name: "max",
							},
							Rbrack: nil,
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   108,
						},
						File:   "aggregate.flux",
						Source: "_make_selector(fn: math.max)",
						Start: ast.Position{
							Column: 7,
							Line:   108,
						},
					},
				},
				Callee: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   108,
							},
							File:   "aggregate.flux",
							Source: "_make_selector",
							Start: ast.Position{
								Column: 7,
								Line:   108,
							},
						},
					},
					Name: "_make_selector",
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   117,
					},
					File:   "aggregate.flux",
					Source: "sum = define(\n    init: (values) => math.sum(values),\n    reduce: (values, state) => {\n        return state + math.sum(values)\n    },\n    compute: (state) => state,\n)",
					Start: ast.Position{
						Column: 1,
						Line:   111,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// sum constructs a sum aggregate for the column.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   111,
						},
						File:   "aggregate.flux",
						Source: "sum",
						Start: ast.Position{
							Column: 1,
							Line:   111,
						},
					},
				},
				Name: "sum",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   116,
							},
							File:   "aggregate.flux",
							Source: "init: (values) => math.sum(values),\n    reduce: (values, state) => {\n        return state + math.sum(values)\n    },\n    compute: (state) => state",
							Start: ast.Position{
								Column: 5,
								Line:   112,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   112,
								},
								File:   "aggregate.flux",
								Source: "init: (values) => math.sum(values)",
								Start: ast.Position{
									Column: 5,
									Line:   112,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   112,
									},
									File:   "aggregate.flux",
									Source: "init",
									Start: ast.Position{
										Column: 5,
										Line:   112,
									},
								},
							},
							Name: "init",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   112,
									},
									File:   "aggregate.flux",
									Source: "(values) => math.sum(values)",
									Start: ast.Position{
										Column: 11,
										Line:   112,
									},
								},
							},
							Body: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   112,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 32,
												Line:   112,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   112,
												},
												File:   "aggregate.flux",
												Source: "values",
												Start: ast.Position{
													Column: 32,
													Line:   112,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   112,
													},
													File:   "aggregate.flux",
													Source: "values",
													Start: ast.Position{
														Column: 32,
														Line:   112,
													},
												},
											},
											Name: "values",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   112,
										},
										File:   "aggregate.flux",
										Source: "math.sum(values)",
										Start: ast.Position{
											Column: 23,
											Line:   112,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   112,
											},
											File:   "aggregate.flux",
											Source: "math.sum",
											Start: ast.Position{
												Column: 23,
												Line:   112,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   112,
												},
												File:   "aggregate.flux",
												Source: "math",
												Start: ast.Position{
													Column: 23,
													Line:   112,
												},
											},
										},
										Name: "math",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   112,
												},
												File:   "aggregate.flux",
												Source: "sum",
												Start: ast.Position{
													Column: 28,
													Line:   112,
												},
											},
										},
										Name: "sum",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   112,
										},
										File:   "aggregate.flux",
										Source: "values",
										Start: ast.Position{
											Column: 12,
											Line:   112,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   112,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 12,
												Line:   112,
											},
										},
									},
									Name: "values",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   115,
								},
								File:   "aggregate.flux",
								Source: "reduce: (values, state) => {\n        return state + math.sum(values)\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   113,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   113,
									},
									File:   "aggregate.flux",
									Source: "reduce",
									Start: ast.Position{
										Column: 5,
										Line:   113,
									},
								},
							},
							Name: "reduce",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   115,
									},
									File:   "aggregate.flux",
									Source: "(values, state) => {\n        return state + math.sum(values)\n    }",
									Start: ast.Position{
										Column: 13,
										Line:   113,
									},
								},
							},
							Body: &ast.Block{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   115,
										},
										File:   "aggregate.flux",
										Source: "{\n        return state + math.sum(values)\n    }",
										Start: ast.Position{
											Column: 32,
											Line:   113,
										},
									},
								},
								Body: []ast.Statement{&ast.ReturnStatement{
									Argument: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   114,
												},
												File:   "aggregate.flux",
												Source: "state + math.sum(values)",
												Start: ast.Position{
													Column: 16,
													Line:   114,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   114,
													},
													File:   "aggregate.flux",
													Source: "state",
													Start: ast.Position{
														Column: 16,
														Line:   114,
													},
												},
											},
											Name: "state",
										},
										Operator: 5,
										Right: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   114,
														},
														File:   "aggregate.flux",
														Source: "values",
														Start: ast.Position{
															Column: 33,
															Line:   114,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   114,
															},
															File:   "aggregate.flux",
															Source: "values",
															Start: ast.Position{
																Column: 33,
																Line:   114,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 39,
																	Line:   114,
																},
																File:   "aggregate.flux",
																Source: "values",
																Start: ast.Position{
																	Column: 33,
																	Line:   114,
																},
															},
														},
														Name: "values",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   114,
													},
													File:   "aggregate.flux",
													Source: "math.sum(values)",
													Start: ast.Position{
														Column: 24,
														Line:   114,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   114,
														},
														File:   "aggregate.flux",
														Source: "math.sum",
														Start: ast.Position{
															Column: 24,
															Line:   114,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   114,
															},
															File:   "aggregate.flux",
															Source: "math",
															Start: ast.Position{
																Column: 24,
																Line:   114,
															},
														},
													},
													Name: "math",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   114,
															},
															File:   "aggregate.flux",
															Source: "sum",
															Start: ast.Position{
																Column: 29,
																Line:   114,
															},
														},
													},
													Name: "sum",
												},
												Rbrack: nil,
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   114,
											},
											File:   "aggregate.flux",
											Source: "return state + math.sum(values)",
											Start: ast.Position{
												Column: 9,
												Line:   114,
											},
										},
									},
								}},
								Lbrace: nil,
								Rbrace: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   113,
										},
										File:   "aggregate.flux",
										Source: "values",
										Start: ast.Position{
											Column: 14,
											Line:   113,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   113,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 14,
												Line:   113,
											},
										},
									},
									Name: "values",
								},
								Separator: nil,
								Value:     nil,
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   113,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 22,
											Line:   113,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   113,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 22,
												Line:   113,
											},
										},
									},
									Name: "state",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   116,
								},
								File:   "aggregate.flux",
								Source: "compute: (state) => state",
								Start: ast.Position{
									Column: 5,
									Line:   116,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   116,
									},
									File:   "aggregate.flux",
									Source: "compute",
									Start: ast.Position{
										Column: 5,
										Line:   116,
									},
								},
							},
							Name: "compute",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   116,
									},
									File:   "aggregate.flux",
									Source: "(state) => state",
									Start: ast.Position{
										Column: 14,
										Line:   116,
									},
								},
							},
							Body: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   116,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 25,
											Line:   116,
										},
									},
								},
								Name: "state",
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   116,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 15,
											Line:   116,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   116,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 15,
												Line:   116,
											},
										},
									},
									Name: "state",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   117,
						},
						File:   "aggregate.flux",
						Source: "define(\n    init: (values) => math.sum(values),\n    reduce: (values, state) => {\n        return state + math.sum(values)\n    },\n    compute: (state) => state,\n)",
						Start: ast.Position{
							Column: 7,
							Line:   111,
						},
					},
				},
				Callee: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   111,
							},
							File:   "aggregate.flux",
							Source: "define",
							Start: ast.Position{
								Column: 7,
								Line:   111,
							},
						},
					},
					Name: "define",
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   127,
					},
					File:   "aggregate.flux",
					Source: "count = define(\n    init: (values) => length(arr: values),\n    reduce: (values, state) => {\n        return state + length(arr: values)\n    },\n    compute: (state) => state,\n    fill: 0,\n)",
					Start: ast.Position{
						Column: 1,
						Line:   120,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// count constructs a count aggregate for the column.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   120,
						},
						File:   "aggregate.flux",
						Source: "count",
						Start: ast.Position{
							Column: 1,
							Line:   120,
						},
					},
				},
				Name: "count",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   126,
							},
							File:   "aggregate.flux",
							Source: "init: (values) => length(arr: values),\n    reduce: (values, state) => {\n        return state + length(arr: values)\n    },\n    compute: (state) => state,\n    fill: 0",
							Start: ast.Position{
								Column: 5,
								Line:   121,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   121,
								},
								File:   "aggregate.flux",
								Source: "init: (values) => length(arr: values)",
								Start: ast.Position{
									Column: 5,
									Line:   121,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   121,
									},
									File:   "aggregate.flux",
									Source: "init",
									Start: ast.Position{
										Column: 5,
										Line:   121,
									},
								},
							},
							Name: "init",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   121,
									},
									File:   "aggregate.flux",
									Source: "(values) => length(arr: values)",
									Start: ast.Position{
										Column: 11,
										Line:   121,
									},
								},
							},
							Body: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   121,
											},
											File:   "aggregate.flux",
											Source: "arr: values",
											Start: ast.Position{
												Column: 30,
												Line:   121,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   121,
												},
												File:   "aggregate.flux",
												Source: "arr: values",
												Start: ast.Position{
													Column: 30,
													Line:   121,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   121,
													},
													File:   "aggregate.flux",
													Source: "arr",
													Start: ast.Position{
														Column: 30,
														Line:   121,
													},
												},
											},
											Name: "arr",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   121,
													},
													File:   "aggregate.flux",
													Source: "values",
													Start: ast.Position{
														Column: 35,
														Line:   121,
													},
												},
											},
											Name: "values",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   121,
										},
										File:   "aggregate.flux",
										Source: "length(arr: values)",
										Start: ast.Position{
											Column: 23,
											Line:   121,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   121,
											},
											File:   "aggregate.flux",
											Source: "length",
											Start: ast.Position{
												Column: 23,
												Line:   121,
											},
										},
									},
									Name: "length",
								},
								Lparen: nil,
								Rparen: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   121,
										},
										File:   "aggregate.flux",
										Source: "values",
										Start: ast.Position{
											Column: 12,
											Line:   121,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   121,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 12,
												Line:   121,
											},
										},
									},
									Name: "values",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   124,
								},
								File:   "aggregate.flux",
								Source: "reduce: (values, state) => {\n        return state + length(arr: values)\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   122,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   122,
									},
									File:   "aggregate.flux",
									Source: "reduce",
									Start: ast.Position{
										Column: 5,
										Line:   122,
									},
								},
							},
							Name: "reduce",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   124,
									},
									File:   "aggregate.flux",
									Source: "(values, state) => {\n        return state + length(arr: values)\n    }",
									Start: ast.Position{
										Column: 13,
										Line:   122,
									},
								},
							},
							Body: &ast.Block{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   124,
										},
										File:   "aggregate.flux",
										Source: "{\n        return state + length(arr: values)\n    }",
										Start: ast.Position{
											Column: 32,
											Line:   122,
										},
									},
								},
								Body: []ast.Statement{&ast.ReturnStatement{
									Argument: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   123,
												},
												File:   "aggregate.flux",
												Source: "state + length(arr: values)",
												Start: ast.Position{
													Column: 16,
													Line:   123,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   123,
													},
													File:   "aggregate.flux",
													Source: "state",
													Start: ast.Position{
														Column: 16,
														Line:   123,
													},
												},
											},
											Name: "state",
										},
										Operator: 5,
										Right: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   123,
														},
														File:   "aggregate.flux",
														Source: "arr: values",
														Start: ast.Position{
															Column: 31,
															Line:   123,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   123,
															},
															File:   "aggregate.flux",
															Source: "arr: values",
															Start: ast.Position{
																Column: 31,
																Line:   123,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   123,
																},
																File:   "aggregate.flux",
																Source: "arr",
																Start: ast.Position{
																	Column: 31,
																	Line:   123,
																},
															},
														},
														Name: "arr",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   123,
																},
																File:   "aggregate.flux",
																Source: "values",
																Start: ast.Position{
																	Column: 36,
																	Line:   123,
																},
															},
														},
														Name: "values",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   123,
													},
													File:   "aggregate.flux",
													Source: "length(arr: values)",
													Start: ast.Position{
														Column: 24,
														Line:   123,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   123,
														},
														File:   "aggregate.flux",
														Source: "length",
														Start: ast.Position{
															Column: 24,
															Line:   123,
														},
													},
												},
												Name: "length",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   123,
											},
											File:   "aggregate.flux",
											Source: "return state + length(arr: values)",
											Start: ast.Position{
												Column: 9,
												Line:   123,
											},
										},
									},
								}},
								Lbrace: nil,
								Rbrace: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   122,
										},
										File:   "aggregate.flux",
										Source: "values",
										Start: ast.Position{
											Column: 14,
											Line:   122,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   122,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 14,
												Line:   122,
											},
										},
									},
									Name: "values",
								},
								Separator: nil,
								Value:     nil,
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   122,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 22,
											Line:   122,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   122,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 22,
												Line:   122,
											},
										},
									},
									Name: "state",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   125,
								},
								File:   "aggregate.flux",
								Source: "compute: (state) => state",
								Start: ast.Position{
									Column: 5,
									Line:   125,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   125,
									},
									File:   "aggregate.flux",
									Source: "compute",
									Start: ast.Position{
										Column: 5,
										Line:   125,
									},
								},
							},
							Name: "compute",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   125,
									},
									File:   "aggregate.flux",
									Source: "(state) => state",
									Start: ast.Position{
										Column: 14,
										Line:   125,
									},
								},
							},
							Body: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   125,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 25,
											Line:   125,
										},
									},
								},
								Name: "state",
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   125,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 15,
											Line:   125,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   125,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 15,
												Line:   125,
											},
										},
									},
									Name: "state",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   126,
								},
								File:   "aggregate.flux",
								Source: "fill: 0",
								Start: ast.Position{
									Column: 5,
									Line:   126,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   126,
									},
									File:   "aggregate.flux",
									Source: "fill",
									Start: ast.Position{
										Column: 5,
										Line:   126,
									},
								},
							},
							Name: "fill",
						},
						Separator: nil,
						Value: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   126,
									},
									File:   "aggregate.flux",
									Source: "0",
									Start: ast.Position{
										Column: 11,
										Line:   126,
									},
								},
							},
							Value: int64(0),
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   127,
						},
						File:   "aggregate.flux",
						Source: "define(\n    init: (values) => length(arr: values),\n    reduce: (values, state) => {\n        return state + length(arr: values)\n    },\n    compute: (state) => state,\n    fill: 0,\n)",
						Start: ast.Position{
							Column: 9,
							Line:   120,
						},
					},
				},
				Callee: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   120,
							},
							File:   "aggregate.flux",
							Source: "define",
							Start: ast.Position{
								Column: 9,
								Line:   120,
							},
						},
					},
					Name: "define",
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   140,
					},
					File:   "aggregate.flux",
					Source: "mean = define(\n    init: (values) => ({\n        sum: math.sum(values),\n        count: length(arr: values),\n    }),\n    reduce: (values, state) => ({\n        sum: state.sum + math.sum(values),\n        count: state.count + length(arr: values),\n    }),\n    compute: (state) => float(v: state.sum) / float(v: state.count),\n)",
					Start: ast.Position{
						Column: 1,
						Line:   130,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// mean constructs a mean aggregate for the column.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   130,
						},
						File:   "aggregate.flux",
						Source: "mean",
						Start: ast.Position{
							Column: 1,
							Line:   130,
						},
					},
				},
				Name: "mean",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   139,
							},
							File:   "aggregate.flux",
							Source: "init: (values) => ({\n        sum: math.sum(values),\n        count: length(arr: values),\n    }),\n    reduce: (values, state) => ({\n        sum: state.sum + math.sum(values),\n        count: state.count + length(arr: values),\n    }),\n    compute: (state) => float(v: state.sum) / float(v: state.count)",
							Start: ast.Position{
								Column: 5,
								Line:   131,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 7,
									Line:   134,
								},
								File:   "aggregate.flux",
								Source: "init: (values) => ({\n        sum: math.sum(values),\n        count: length(arr: values),\n    })",
								Start: ast.Position{
									Column: 5,
									Line:   131,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   131,
									},
									File:   "aggregate.flux",
									Source: "init",
									Start: ast.Position{
										Column: 5,
										Line:   131,
									},
								},
							},
							Name: "init",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   134,
									},
									File:   "aggregate.flux",
									Source: "(values) => ({\n        sum: math.sum(values),\n        count: length(arr: values),\n    })",
									Start: ast.Position{
										Column: 11,
										Line:   131,
									},
								},
							},
							Body: &ast.ParenExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 7,
											Line:   134,
										},
										File:   "aggregate.flux",
										Source: "({\n        sum: math.sum(values),\n        count: length(arr: values),\n    })",
										Start: ast.Position{
											Column: 23,
											Line:   131,
										},
									},
								},
								Expression: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   134,
											},
											File:   "aggregate.flux",
											Source: "{\n        sum: math.sum(values),\n        count: length(arr: values),\n    }",
											Start: ast.Position{
												Column: 24,
												Line:   131,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   132,
												},
												File:   "aggregate.flux",
												Source: "sum: math.sum(values)",
												Start: ast.Position{
													Column: 9,
													Line:   132,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 12,
														Line:   132,
													},
													File:   "aggregate.flux",
													Source: "sum",
													Start: ast.Position{
														Column: 9,
														Line:   132,
													},
												},
											},
											Name: "sum",
										},
										Separator: nil,
										Value: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   132,
														},
														File:   "aggregate.flux",
														Source: "values",
														Start: ast.Position{
															Column: 23,
															Line:   132,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 29,
																Line:   132,
															},
															File:   "aggregate.flux",
															Source: "values",
															Start: ast.Position{
																Column: 23,
																Line:   132,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 29,
																	Line:   132,
																},
																File:   "aggregate.flux",
																Source: "values",
																Start: ast.Position{
																	Column: 23,
																	Line:   132,
																},
															},
														},
														Name: "values",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   132,
													},
													File:   "aggregate.flux",
													Source: "math.sum(values)",
													Start: ast.Position{
														Column: 14,
														Line:   132,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   132,
														},
														File:   "aggregate.flux",
														Source: "math.sum",
														Start: ast.Position{
															Column: 14,
															Line:   132,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   132,
															},
															File:   "aggregate.flux",
															Source: "math",
															Start: ast.Position{
																Column: 14,
																Line:   132,
															},
														},
													},
													Name: "math",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   132,
															},
															File:   "aggregate.flux",
															Source: "sum",
															Start: ast.Position{
																Column: 19,
																Line:   132,
															},
														},
													},
													Name: "sum",
												},
												Rbrack: nil,
											},
											Lparen: nil,
											Rparen: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   133,
												},
												File:   "aggregate.flux",
												Source: "count: length(arr: values)",
												Start: ast.Position{
													Column: 9,
													Line:   133,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   133,
													},
													File:   "aggregate.flux",
													Source: "count",
													Start: ast.Position{
														Column: 9,
														Line:   133,
													},
												},
											},
											Name: "count",
										},
										Separator: nil,
										Value: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   133,
														},
														File:   "aggregate.flux",
														Source: "arr: values",
														Start: ast.Position{
															Column: 23,
															Line:   133,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   133,
															},
															File:   "aggregate.flux",
															Source: "arr: values",
															Start: ast.Position{
																Column: 23,
																Line:   133,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   133,
																},
																File:   "aggregate.flux",
																Source: "arr",
																Start: ast.Position{
																	Column: 23,
																	Line:   133,
																},
															},
														},
														Name: "arr",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   133,
																},
																File:   "aggregate.flux",
																Source: "values",
																Start: ast.Position{
																	Column: 28,
																	Line:   133,
																},
															},
														},
														Name: "values",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   133,
													},
													File:   "aggregate.flux",
													Source: "length(arr: values)",
													Start: ast.Position{
														Column: 16,
														Line:   133,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   133,
														},
														File:   "aggregate.flux",
														Source: "length",
														Start: ast.Position{
															Column: 16,
															Line:   133,
														},
													},
												},
												Name: "length",
											},
											Lparen: nil,
											Rparen: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   131,
										},
										File:   "aggregate.flux",
										Source: "values",
										Start: ast.Position{
											Column: 12,
											Line:   131,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   131,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 12,
												Line:   131,
											},
										},
									},
									Name: "values",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 7,
									Line:   138,
								},
								File:   "aggregate.flux",
								Source: "reduce: (values, state) => ({\n        sum: state.sum + math.sum(values),\n        count: state.count + length(arr: values),\n    })",
								Start: ast.Position{
									Column: 5,
									Line:   135,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   135,
									},
									File:   "aggregate.flux",
									Source: "reduce",
									Start: ast.Position{
										Column: 5,
										Line:   135,
									},
								},
							},
							Name: "reduce",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   138,
									},
									File:   "aggregate.flux",
									Source: "(values, state) => ({\n        sum: state.sum + math.sum(values),\n        count: state.count + length(arr: values),\n    })",
									Start: ast.Position{
										Column: 13,
										Line:   135,
									},
								},
							},
							Body: &ast.ParenExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 7,
											Line:   138,
										},
										File:   "aggregate.flux",
										Source: "({\n        sum: state.sum + math.sum(values),\n        count: state.count + length(arr: values),\n    })",
										Start: ast.Position{
											Column: 32,
											Line:   135,
										},
									},
								},
								Expression: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   138,
											},
											File:   "aggregate.flux",
											Source: "{\n        sum: state.sum + math.sum(values),\n        count: state.count + length(arr: values),\n    }",
											Start: ast.Position{
												Column: 33,
												Line:   135,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   136,
												},
												File:   "aggregate.flux",
												Source: "sum: state.sum + math.sum(values)",
												Start: ast.Position{
													Column: 9,
													Line:   136,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 12,
														Line:   136,
													},
													File:   "aggregate.flux",
													Source: "sum",
													Start: ast.Position{
														Column: 9,
														Line:   136,
													},
												},
											},
											Name: "sum",
										},
										Separator: nil,
										Value: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   136,
													},
													File:   "aggregate.flux",
													Source: "state.sum + math.sum(values)",
													Start: ast.Position{
														Column: 14,
														Line:   136,
													},
												},
											},
											Left: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   136,
														},
														File:   "aggregate.flux",
														Source: "state.sum",
														Start: ast.Position{
															Column: 14,
															Line:   136,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 19,
																Line:   136,
															},
															File:   "aggregate.flux",
															Source: "state",
															Start: ast.Position{
																Column: 14,
																Line:   136,
															},
														},
													},
													Name: "state",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   136,
															},
															File:   "aggregate.flux",
															Source: "sum",
															Start: ast.Position{
																Column: 20,
																Line:   136,
															},
														},
													},
													Name: "sum",
												},
												Rbrack: nil,
											},
											Operator: 5,
											Right: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   136,
															},
															File:   "aggregate.flux",
															Source: "values",
															Start: ast.Position{
																Column: 35,
																Line:   136,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   136,
																},
																File:   "aggregate.flux",
																Source: "values",
																Start: ast.Position{
																	Column: 35,
																	Line:   136,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   136,
																	},
																	File:   "aggregate.flux",
																	Source: "values",
																	Start: ast.Position{
																		Column: 35,
																		Line:   136,
																	},
																},
															},
															Name: "values",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   136,
														},
														File:   "aggregate.flux",
														Source: "math.sum(values)",
														Start: ast.Position{
															Column: 26,
															Line:   136,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   136,
															},
															File:   "aggregate.flux",
															Source: "math.sum",
															Start: ast.Position{
																Column: 26,
																Line:   136,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   136,
																},
																File:   "aggregate.flux",
																Source: "math",
																Start: ast.Position{
																	Column: 26,
																	Line:   136,
																},
															},
														},
														Name: "math",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   136,
																},
																File:   "aggregate.flux",
																Source: "sum",
																Start: ast.Position{
																	Column: 31,
																	Line:   136,
																},
															},
														},
														Name: "sum",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   137,
												},
												File:   "aggregate.flux",
												Source: "count: state.count + length(arr: values)",
												Start: ast.Position{
													Column: 9,
													Line:   137,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   137,
													},
													File:   "aggregate.flux",
													Source: "count",
													Start: ast.Position{
														Column: 9,
														Line:   137,
													},
												},
											},
											Name: "count",
										},
										Separator: nil,
										Value: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   137,
													},
													File:   "aggregate.flux",
													Source: "state.count + length(arr: values)",
													Start: ast.Position{
														Column: 16,
														Line:   137,
													},
												},
											},
											Left: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   137,
														},
														File:   "aggregate.flux",
														Source: "state.count",
														Start: ast.Position{
															Column: 16,
															Line:   137,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   137,
															},
															File:   "aggregate.flux",
															Source: "state",
															Start: ast.Position{
																Column: 16,
																Line:   137,
															},
														},
													},
													Name: "state",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   137,
															},
															File:   "aggregate.flux",
															Source: "count",
															Start: ast.Position{
																Column: 22,
																Line:   137,
															},
														},
													},
													Name: "count",
												},
												Rbrack: nil,
											},
											Operator: 5,
											Right: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   137,
															},
															File:   "aggregate.flux",
															Source: "arr: values",
															Start: ast.Position{
																Column: 37,
																Line:   137,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   137,
																},
																File:   "aggregate.flux",
																Source: "arr: values",
																Start: ast.Position{
																	Column: 37,
																	Line:   137,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   137,
																	},
																	File:   "aggregate.flux",
																	Source: "arr",
																	Start: ast.Position{
																		Column: 37,
																		Line:   137,
																	},
																},
															},
															Name: "arr",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   137,
																	},
																	File:   "aggregate.flux",
																	Source: "values",
																	Start: ast.Position{
																		Column: 42,
																		Line:   137,
																	},
																},
															},
															Name: "values",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   137,
														},
														File:   "aggregate.flux",
														Source: "length(arr: values)",
														Start: ast.Position{
															Column: 30,
															Line:   137,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   137,
															},
															File:   "aggregate.flux",
															Source: "length",
															Start: ast.Position{
																Column: 30,
																Line:   137,
															},
														},
													},
													Name: "length",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
									}},
									Rbrace: nil,
									With:   nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   135,
										},
										File:   "aggregate.flux",
										Source: "values",
										Start: ast.Position{
											Column: 14,
											Line:   135,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   135,
											},
											File:   "aggregate.flux",
											Source: "values",
											Start: ast.Position{
												Column: 14,
												Line:   135,
											},
										},
									},
									Name: "values",
								},
								Separator: nil,
								Value:     nil,
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   135,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 22,
											Line:   135,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   135,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 22,
												Line:   135,
											},
										},
									},
									Name: "state",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   139,
								},
								File:   "aggregate.flux",
								Source: "compute: (state) => float(v: state.sum) / float(v: state.count)",
								Start: ast.Position{
									Column: 5,
									Line:   139,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   139,
									},
									File:   "aggregate.flux",
									Source: "compute",
									Start: ast.Position{
										Column: 5,
										Line:   139,
									},
								},
							},
							Name: "compute",
						},
						Separator: nil,
						Value: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   139,
									},
									File:   "aggregate.flux",
									Source: "(state) => float(v: state.sum) / float(v: state.count)",
									Start: ast.Position{
										Column: 14,
										Line:   139,
									},
								},
							},
							Body: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   139,
										},
										File:   "aggregate.flux",
										Source: "float(v: state.sum) / float(v: state.count)",
										Start: ast.Position{
											Column: 25,
											Line:   139,
										},
									},
								},
								Left: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   139,
												},
												File:   "aggregate.flux",
												Source: "v: state.sum",
												Start: ast.Position{
													Column: 31,
													Line:   139,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   139,
													},
													File:   "aggregate.flux",
													Source: "v: state.sum",
													Start: ast.Position{
														Column: 31,
														Line:   139,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   139,
														},
														File:   "aggregate.flux",
														Source: "v",
														Start: ast.Position{
															Column: 31,
															Line:   139,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   139,
														},
														File:   "aggregate.flux",
														Source: "state.sum",
														Start: ast.Position{
															Column: 34,
															Line:   139,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   139,
															},
															File:   "aggregate.flux",
															Source: "state",
															Start: ast.Position{
																Column: 34,
																Line:   139,
															},
														},
													},
													Name: "state",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 43,
																Line:   139,
															},
															File:   "aggregate.flux",
															Source: "sum",
															Start: ast.Position{
																Column: 40,
																Line:   139,
															},
														},
													},
													Name: "sum",
												},
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   139,
											},
											File:   "aggregate.flux",
											Source: "float(v: state.sum)",
											Start: ast.Position{
												Column: 25,
												Line:   139,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   139,
												},
												File:   "aggregate.flux",
												Source: "float",
												Start: ast.Position{
													Column: 25,
													Line:   139,
												},
											},
										},
										Name: "float",
									},
									Lparen: nil,
									Rparen: nil,
								},
								Operator: 2,
								Right: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   139,
												},
												File:   "aggregate.flux",
												Source: "v: state.count",
												Start: ast.Position{
													Column: 53,
													Line:   139,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   139,
													},
													File:   "aggregate.flux",
													Source: "v: state.count",
													Start: ast.Position{
														Column: 53,
														Line:   139,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   139,
														},
														File:   "aggregate.flux",
														Source: "v",
														Start: ast.Position{
															Column: 53,
															Line:   139,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   139,
														},
														File:   "aggregate.flux",
														Source: "state.count",
														Start: ast.Position{
															Column: 56,
															Line:   139,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   139,
															},
															File:   "aggregate.flux",
															Source: "state",
															Start: ast.Position{
																Column: 56,
																Line:   139,
															},
														},
													},
													Name: "state",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 67,
																Line:   139,
															},
															File:   "aggregate.flux",
															Source: "count",
															Start: ast.Position{
																Column: 62,
																Line:   139,
															},
														},
													},
													Name: "count",
												},
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   139,
											},
											File:   "aggregate.flux",
											Source: "float(v: state.count)",
											Start: ast.Position{
												Column: 47,
												Line:   139,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   139,
												},
												File:   "aggregate.flux",
												Source: "float",
												Start: ast.Position{
													Column: 47,
													Line:   139,
												},
											},
										},
										Name: "float",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   139,
										},
										File:   "aggregate.flux",
										Source: "state",
										Start: ast.Position{
											Column: 15,
											Line:   139,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   139,
											},
											File:   "aggregate.flux",
											Source: "state",
											Start: ast.Position{
												Column: 15,
												Line:   139,
											},
										},
									},
									Name: "state",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   140,
						},
						File:   "aggregate.flux",
						Source: "define(\n    init: (values) => ({\n        sum: math.sum(values),\n        count: length(arr: values),\n    }),\n    reduce: (values, state) => ({\n        sum: state.sum + math.sum(values),\n        count: state.count + length(arr: values),\n    }),\n    compute: (state) => float(v: state.sum) / float(v: state.count),\n)",
						Start: ast.Position{
							Column: 8,
							Line:   130,
						},
					},
				},
				Callee: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   130,
							},
							File:   "aggregate.flux",
							Source: "define",
							Start: ast.Position{
								Column: 8,
								Line:   130,
							},
						},
					},
					Name: "define",
				},
				Lparen: nil,
				Rparen: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   4,
					},
					File:   "aggregate.flux",
					Source: "import \"contrib/jsternberg/math\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   4,
						},
						File:   "aggregate.flux",
						Source: "\"contrib/jsternberg/math\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "contrib/jsternberg/math",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "aggregate.flux",
					Source: "package aggregate",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "aggregate.flux",
						Source: "aggregate",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "aggregate",
			},
		},
	}},
	Package: "aggregate",
	Path:    "contrib/jsternberg/aggregate",
}
