// DO NOT EDIT: This file is autogenerated via the builtin command.

package opsgenie

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 6,
					Line:   96,
				},
				File:   "opsgenie.flux",
				Source: "package opsgenie\n\n\nimport \"http\"\nimport \"json\"\nimport \"strings\"\n\n// respondersToJSON converts an array of responder strings to JSON array that can be embedded into an alert message\nbuiltin respondersToJSON : (v: [string]) => string\n\n// `sendAlert` sends a message that creates an alert in Opsgenie. See https://docs.opsgenie.com/docs/alert-api#create-alert for details.\n// `url`         - string - Opsgenie API URL. Defaults to \"https://api.opsgenie.com/v2/alerts\". \n// `apiKey`      - string - API Authorization key. \n// `message`     - string - Alert message text, at most 130 characters. \n// `alias`       - string - Opsgenie alias, at most 250 characters that are used to de-deduplicate alerts. Defaults to message. \n// `description` - string - Description field of an alert, at most 15000 characters. Optional. \n// `priority`    - string - \"P1\", \"P2\", \"P3\", \"P4\" or \"P5\". Defaults to \"P3\". \n// `responders`  - array  - Array of strings to identify responder teams or teams, a 'user:' prefix is used for users, 'teams:' prefix for teams. \n// `tags`        - array  - Array of string tags. Optional. \n// `entity`      - string - Entity of the alert, used to specify domain of the alert. Optional. \n// `actions`     - array  - Array of strings that specifies actions that will be available for the alert. \n// `details`     - string - Additional details of an alert, it must be a JSON-encoded map of key-value string pairs. \n// `visibleTo`   - array  - Arrays of teams and users that the alert will become visible to without sending any notification. Optional. \nsendAlert = (\n        url=\"https://api.opsgenie.com/v2/alerts\",\n        apiKey,\n        message,\n        alias=\"\",\n        description=\"\",\n        priority=\"P3\",\n        responders=[],\n        tags=[],\n        entity=\"\",\n        actions=[],\n        visibleTo=[],\n        details=\"{}\",\n) => {\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"GenieKey \" + apiKey,\n    }\n    cutEncode = (v, max, defV=\"\") => {\n        v2 = if strings.strlen(v: v) != 0 then v else defV\n\n        return if strings.strlen(v: v2) > max then\n            string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n        else\n            string(v: json.encode(v: v2))\n    }\n    body = \"{\n\\\"message\\\": ${cutEncode(v: message, max: 130)},\n\\\"alias\\\": ${cutEncode(v: alias, max: 512, defV: message)},\n\\\"description\\\": ${cutEncode(v: description, max: 15000)},\n\\\"responders\\\": ${respondersToJSON(v: responders)},\n\\\"visibleTo\\\": ${respondersToJSON(v: visibleTo)},\n\\\"actions\\\": ${string(v: json.encode(v: actions))},\n\\\"tags\\\": ${string(v: json.encode(v: tags))},\n\\\"details\\\": ${details},\n\\\"entity\\\": ${cutEncode(v: entity, max: 512)},\n\\\"priority\\\": ${cutEncode(v: priority, max: 2)}\n}\"\n\n    return http.post(headers: headers, url: url, data: bytes(v: body))\n}\n\n// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send alerts to opsgenie for each table row.\n// `url`         - string - Opsgenie API URL. Defaults to \"https://api.opsgenie.com/v2/alerts\". \n// `apiKey`      - string - API Authorization key. \n// `entity`      - string - Entity of the alert, used to specify domain of the alert. Optional. \n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` must return an object with all properties defined in the `sendAlert` function arguments (except url, apiKey and entity).\nendpoint = (url=\"https://api.opsgenie.com/v2/alerts\", apiKey, entity=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// respondersToJSON converts an array of responder strings to JSON array that can be embedded into an alert message\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   9,
					},
					File:   "opsgenie.flux",
					Source: "builtin respondersToJSON",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   9,
						},
						File:   "opsgenie.flux",
						Source: "respondersToJSON",
						Start: ast.Position{
							Column: 9,
							Line:   9,
						},
					},
				},
				Name: "respondersToJSON",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 51,
							Line:   9,
						},
						File:   "opsgenie.flux",
						Source: "(v: [string]) => string",
						Start: ast.Position{
							Column: 28,
							Line:   9,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   9,
							},
							File:   "opsgenie.flux",
							Source: "(v: [string]) => string",
							Start: ast.Position{
								Column: 28,
								Line:   9,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   9,
								},
								File:   "opsgenie.flux",
								Source: "v: [string]",
								Start: ast.Position{
									Column: 29,
									Line:   9,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   9,
									},
									File:   "opsgenie.flux",
									Source: "v",
									Start: ast.Position{
										Column: 29,
										Line:   9,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   9,
									},
									File:   "opsgenie.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 32,
										Line:   9,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   9,
										},
										File:   "opsgenie.flux",
										Source: "string",
										Start: ast.Position{
											Column: 33,
											Line:   9,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   9,
											},
											File:   "opsgenie.flux",
											Source: "string",
											Start: ast.Position{
												Column: 33,
												Line:   9,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   9,
								},
								File:   "opsgenie.flux",
								Source: "string",
								Start: ast.Position{
									Column: 45,
									Line:   9,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   9,
									},
									File:   "opsgenie.flux",
									Source: "string",
									Start: ast.Position{
										Column: 45,
										Line:   9,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   64,
					},
					File:   "opsgenie.flux",
					Source: "sendAlert = (\n        url=\"https://api.opsgenie.com/v2/alerts\",\n        apiKey,\n        message,\n        alias=\"\",\n        description=\"\",\n        priority=\"P3\",\n        responders=[],\n        tags=[],\n        entity=\"\",\n        actions=[],\n        visibleTo=[],\n        details=\"{}\",\n) => {\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"GenieKey \" + apiKey,\n    }\n    cutEncode = (v, max, defV=\"\") => {\n        v2 = if strings.strlen(v: v) != 0 then v else defV\n\n        return if strings.strlen(v: v2) > max then\n            string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n        else\n            string(v: json.encode(v: v2))\n    }\n    body = \"{\n\\\"message\\\": ${cutEncode(v: message, max: 130)},\n\\\"alias\\\": ${cutEncode(v: alias, max: 512, defV: message)},\n\\\"description\\\": ${cutEncode(v: description, max: 15000)},\n\\\"responders\\\": ${respondersToJSON(v: responders)},\n\\\"visibleTo\\\": ${respondersToJSON(v: visibleTo)},\n\\\"actions\\\": ${string(v: json.encode(v: actions))},\n\\\"tags\\\": ${string(v: json.encode(v: tags))},\n\\\"details\\\": ${details},\n\\\"entity\\\": ${cutEncode(v: entity, max: 512)},\n\\\"priority\\\": ${cutEncode(v: priority, max: 2)}\n}\"\n\n    return http.post(headers: headers, url: url, data: bytes(v: body))\n}",
					Start: ast.Position{
						Column: 1,
						Line:   24,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `sendAlert` sends a message that creates an alert in Opsgenie. See https://docs.opsgenie.com/docs/alert-api#create-alert for details.\n"}, ast.Comment{Text: "// `url`         - string - Opsgenie API URL. Defaults to \"https://api.opsgenie.com/v2/alerts\". \n"}, ast.Comment{Text: "// `apiKey`      - string - API Authorization key. \n"}, ast.Comment{Text: "// `message`     - string - Alert message text, at most 130 characters. \n"}, ast.Comment{Text: "// `alias`       - string - Opsgenie alias, at most 250 characters that are used to de-deduplicate alerts. Defaults to message. \n"}, ast.Comment{Text: "// `description` - string - Description field of an alert, at most 15000 characters. Optional. \n"}, ast.Comment{Text: "// `priority`    - string - \"P1\", \"P2\", \"P3\", \"P4\" or \"P5\". Defaults to \"P3\". \n"}, ast.Comment{Text: "// `responders`  - array  - Array of strings to identify responder teams or teams, a 'user:' prefix is used for users, 'teams:' prefix for teams. \n"}, ast.Comment{Text: "// `tags`        - array  - Array of string tags. Optional. \n"}, ast.Comment{Text: "// `entity`      - string - Entity of the alert, used to specify domain of the alert. Optional. \n"}, ast.Comment{Text: "// `actions`     - array  - Array of strings that specifies actions that will be available for the alert. \n"}, ast.Comment{Text: "// `details`     - string - Additional details of an alert, it must be a JSON-encoded map of key-value string pairs. \n"}, ast.Comment{Text: "// `visibleTo`   - array  - Arrays of teams and users that the alert will become visible to without sending any notification. Optional. \n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   24,
						},
						File:   "opsgenie.flux",
						Source: "sendAlert",
						Start: ast.Position{
							Column: 1,
							Line:   24,
						},
					},
				},
				Name: "sendAlert",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   64,
						},
						File:   "opsgenie.flux",
						Source: "(\n        url=\"https://api.opsgenie.com/v2/alerts\",\n        apiKey,\n        message,\n        alias=\"\",\n        description=\"\",\n        priority=\"P3\",\n        responders=[],\n        tags=[],\n        entity=\"\",\n        actions=[],\n        visibleTo=[],\n        details=\"{}\",\n) => {\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"GenieKey \" + apiKey,\n    }\n    cutEncode = (v, max, defV=\"\") => {\n        v2 = if strings.strlen(v: v) != 0 then v else defV\n\n        return if strings.strlen(v: v2) > max then\n            string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n        else\n            string(v: json.encode(v: v2))\n    }\n    body = \"{\n\\\"message\\\": ${cutEncode(v: message, max: 130)},\n\\\"alias\\\": ${cutEncode(v: alias, max: 512, defV: message)},\n\\\"description\\\": ${cutEncode(v: description, max: 15000)},\n\\\"responders\\\": ${respondersToJSON(v: responders)},\n\\\"visibleTo\\\": ${respondersToJSON(v: visibleTo)},\n\\\"actions\\\": ${string(v: json.encode(v: actions))},\n\\\"tags\\\": ${string(v: json.encode(v: tags))},\n\\\"details\\\": ${details},\n\\\"entity\\\": ${cutEncode(v: entity, max: 512)},\n\\\"priority\\\": ${cutEncode(v: priority, max: 2)}\n}\"\n\n    return http.post(headers: headers, url: url, data: bytes(v: body))\n}",
						Start: ast.Position{
							Column: 13,
							Line:   24,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   64,
							},
							File:   "opsgenie.flux",
							Source: "{\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"GenieKey \" + apiKey,\n    }\n    cutEncode = (v, max, defV=\"\") => {\n        v2 = if strings.strlen(v: v) != 0 then v else defV\n\n        return if strings.strlen(v: v2) > max then\n            string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n        else\n            string(v: json.encode(v: v2))\n    }\n    body = \"{\n\\\"message\\\": ${cutEncode(v: message, max: 130)},\n\\\"alias\\\": ${cutEncode(v: alias, max: 512, defV: message)},\n\\\"description\\\": ${cutEncode(v: description, max: 15000)},\n\\\"responders\\\": ${respondersToJSON(v: responders)},\n\\\"visibleTo\\\": ${respondersToJSON(v: visibleTo)},\n\\\"actions\\\": ${string(v: json.encode(v: actions))},\n\\\"tags\\\": ${string(v: json.encode(v: tags))},\n\\\"details\\\": ${details},\n\\\"entity\\\": ${cutEncode(v: entity, max: 512)},\n\\\"priority\\\": ${cutEncode(v: priority, max: 2)}\n}\"\n\n    return http.post(headers: headers, url: url, data: bytes(v: body))\n}",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   41,
								},
								File:   "opsgenie.flux",
								Source: "headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"GenieKey \" + apiKey,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   38,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   38,
									},
									File:   "opsgenie.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   38,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   41,
									},
									File:   "opsgenie.flux",
									Source: "{\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"GenieKey \" + apiKey,\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   38,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   39,
										},
										File:   "opsgenie.flux",
										Source: "\"Content-Type\": \"application/json; charset=utf-8\"",
										Start: ast.Position{
											Column: 9,
											Line:   39,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   39,
											},
											File:   "opsgenie.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   39,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   39,
											},
											File:   "opsgenie.flux",
											Source: "\"application/json; charset=utf-8\"",
											Start: ast.Position{
												Column: 25,
												Line:   39,
											},
										},
									},
									Value: "application/json; charset=utf-8",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   40,
										},
										File:   "opsgenie.flux",
										Source: "\"Authorization\": \"GenieKey \" + apiKey",
										Start: ast.Position{
											Column: 9,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   40,
											},
											File:   "opsgenie.flux",
											Source: "\"Authorization\"",
											Start: ast.Position{
												Column: 9,
												Line:   40,
											},
										},
									},
									Value: "Authorization",
								},
								Separator: nil,
								Value: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   40,
											},
											File:   "opsgenie.flux",
											Source: "\"GenieKey \" + apiKey",
											Start: ast.Position{
												Column: 26,
												Line:   40,
											},
										},
									},
									Left: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   40,
												},
												File:   "opsgenie.flux",
												Source: "\"GenieKey \"",
												Start: ast.Position{
													Column: 26,
													Line:   40,
												},
											},
										},
										Value: "GenieKey ",
									},
									Operator: 5,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   40,
												},
												File:   "opsgenie.flux",
												Source: "apiKey",
												Start: ast.Position{
													Column: 40,
													Line:   40,
												},
											},
										},
										Name: "apiKey",
									},
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   49,
								},
								File:   "opsgenie.flux",
								Source: "cutEncode = (v, max, defV=\"\") => {\n        v2 = if strings.strlen(v: v) != 0 then v else defV\n\n        return if strings.strlen(v: v2) > max then\n            string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n        else\n            string(v: json.encode(v: v2))\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   42,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   42,
									},
									File:   "opsgenie.flux",
									Source: "cutEncode",
									Start: ast.Position{
										Column: 5,
										Line:   42,
									},
								},
							},
							Name: "cutEncode",
						},
						Init: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   49,
									},
									File:   "opsgenie.flux",
									Source: "(v, max, defV=\"\") => {\n        v2 = if strings.strlen(v: v) != 0 then v else defV\n\n        return if strings.strlen(v: v2) > max then\n            string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n        else\n            string(v: json.encode(v: v2))\n    }",
									Start: ast.Position{
										Column: 17,
										Line:   42,
									},
								},
							},
							Body: &ast.Block{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   49,
										},
										File:   "opsgenie.flux",
										Source: "{\n        v2 = if strings.strlen(v: v) != 0 then v else defV\n\n        return if strings.strlen(v: v2) > max then\n            string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n        else\n            string(v: json.encode(v: v2))\n    }",
										Start: ast.Position{
											Column: 38,
											Line:   42,
										},
									},
								},
								Body: []ast.Statement{&ast.VariableAssignment{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   43,
											},
											File:   "opsgenie.flux",
											Source: "v2 = if strings.strlen(v: v) != 0 then v else defV",
											Start: ast.Position{
												Column: 9,
												Line:   43,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   43,
												},
												File:   "opsgenie.flux",
												Source: "v2",
												Start: ast.Position{
													Column: 9,
													Line:   43,
												},
											},
										},
										Name: "v2",
									},
									Init: &ast.ConditionalExpression{
										Alternate: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   43,
													},
													File:   "opsgenie.flux",
													Source: "defV",
													Start: ast.Position{
														Column: 55,
														Line:   43,
													},
												},
											},
											Name: "defV",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   43,
												},
												File:   "opsgenie.flux",
												Source: "if strings.strlen(v: v) != 0 then v else defV",
												Start: ast.Position{
													Column: 14,
													Line:   43,
												},
											},
										},
										Consequent: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   43,
													},
													File:   "opsgenie.flux",
													Source: "v",
													Start: ast.Position{
														Column: 48,
														Line:   43,
													},
												},
											},
											Name: "v",
										},
										Test: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   43,
													},
													File:   "opsgenie.flux",
													Source: "strings.strlen(v: v) != 0",
													Start: ast.Position{
														Column: 17,
														Line:   43,
													},
												},
											},
											Left: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   43,
															},
															File:   "opsgenie.flux",
															Source: "v: v",
															Start: ast.Position{
																Column: 32,
																Line:   43,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   43,
																},
																File:   "opsgenie.flux",
																Source: "v: v",
																Start: ast.Position{
																	Column: 32,
																	Line:   43,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   43,
																	},
																	File:   "opsgenie.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 32,
																		Line:   43,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   43,
																	},
																	File:   "opsgenie.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 35,
																		Line:   43,
																	},
																},
															},
															Name: "v",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   43,
														},
														File:   "opsgenie.flux",
														Source: "strings.strlen(v: v)",
														Start: ast.Position{
															Column: 17,
															Line:   43,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   43,
															},
															File:   "opsgenie.flux",
															Source: "strings.strlen",
															Start: ast.Position{
																Column: 17,
																Line:   43,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 24,
																	Line:   43,
																},
																File:   "opsgenie.flux",
																Source: "strings",
																Start: ast.Position{
																	Column: 17,
																	Line:   43,
																},
															},
														},
														Name: "strings",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   43,
																},
																File:   "opsgenie.flux",
																Source: "strlen",
																Start: ast.Position{
																	Column: 25,
																	Line:   43,
																},
															},
														},
														Name: "strlen",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
											Operator: 18,
											Right: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   43,
														},
														File:   "opsgenie.flux",
														Source: "0",
														Start: ast.Position{
															Column: 41,
															Line:   43,
														},
													},
												},
												Value: int64(0),
											},
										},
										Tk_else: nil,
										Tk_if:   nil,
										Tk_then: nil,
									},
								}, &ast.ReturnStatement{
									Argument: &ast.ConditionalExpression{
										Alternate: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   48,
														},
														File:   "opsgenie.flux",
														Source: "v: json.encode(v: v2)",
														Start: ast.Position{
															Column: 20,
															Line:   48,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   48,
															},
															File:   "opsgenie.flux",
															Source: "v: json.encode(v: v2)",
															Start: ast.Position{
																Column: 20,
																Line:   48,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 21,
																	Line:   48,
																},
																File:   "opsgenie.flux",
																Source: "v",
																Start: ast.Position{
																	Column: 20,
																	Line:   48,
																},
															},
														},
														Name: "v",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   48,
																	},
																	File:   "opsgenie.flux",
																	Source: "v: v2",
																	Start: ast.Position{
																		Column: 35,
																		Line:   48,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 40,
																			Line:   48,
																		},
																		File:   "opsgenie.flux",
																		Source: "v: v2",
																		Start: ast.Position{
																			Column: 35,
																			Line:   48,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 36,
																				Line:   48,
																			},
																			File:   "opsgenie.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 35,
																				Line:   48,
																			},
																		},
																	},
																	Name: "v",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 40,
																				Line:   48,
																			},
																			File:   "opsgenie.flux",
																			Source: "v2",
																			Start: ast.Position{
																				Column: 38,
																				Line:   48,
																			},
																		},
																	},
																	Name: "v2",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   48,
																},
																File:   "opsgenie.flux",
																Source: "json.encode(v: v2)",
																Start: ast.Position{
																	Column: 23,
																	Line:   48,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   48,
																	},
																	File:   "opsgenie.flux",
																	Source: "json.encode",
																	Start: ast.Position{
																		Column: 23,
																		Line:   48,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 27,
																			Line:   48,
																		},
																		File:   "opsgenie.flux",
																		Source: "json",
																		Start: ast.Position{
																			Column: 23,
																			Line:   48,
																		},
																	},
																},
																Name: "json",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 34,
																			Line:   48,
																		},
																		File:   "opsgenie.flux",
																		Source: "encode",
																		Start: ast.Position{
																			Column: 28,
																			Line:   48,
																		},
																	},
																},
																Name: "encode",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   48,
													},
													File:   "opsgenie.flux",
													Source: "string(v: json.encode(v: v2))",
													Start: ast.Position{
														Column: 13,
														Line:   48,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   48,
														},
														File:   "opsgenie.flux",
														Source: "string",
														Start: ast.Position{
															Column: 13,
															Line:   48,
														},
													},
												},
												Name: "string",
											},
											Lparen: nil,
											Rparen: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   48,
												},
												File:   "opsgenie.flux",
												Source: "if strings.strlen(v: v2) > max then\n            string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n        else\n            string(v: json.encode(v: v2))",
												Start: ast.Position{
													Column: 16,
													Line:   45,
												},
											},
										},
										Consequent: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 88,
															Line:   46,
														},
														File:   "opsgenie.flux",
														Source: "v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\")",
														Start: ast.Position{
															Column: 20,
															Line:   46,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 88,
																Line:   46,
															},
															File:   "opsgenie.flux",
															Source: "v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\")",
															Start: ast.Position{
																Column: 20,
																Line:   46,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 21,
																	Line:   46,
																},
																File:   "opsgenie.flux",
																Source: "v",
																Start: ast.Position{
																	Column: 20,
																	Line:   46,
																},
															},
														},
														Name: "v",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 87,
																		Line:   46,
																	},
																	File:   "opsgenie.flux",
																	Source: "v: \"${strings.substring(v: v2, start: 0, end: max)}\"",
																	Start: ast.Position{
																		Column: 35,
																		Line:   46,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 87,
																			Line:   46,
																		},
																		File:   "opsgenie.flux",
																		Source: "v: \"${strings.substring(v: v2, start: 0, end: max)}\"",
																		Start: ast.Position{
																			Column: 35,
																			Line:   46,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 36,
																				Line:   46,
																			},
																			File:   "opsgenie.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 35,
																				Line:   46,
																			},
																		},
																	},
																	Name: "v",
																},
																Separator: nil,
																Value: &ast.StringExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 87,
																				Line:   46,
																			},
																			File:   "opsgenie.flux",
																			Source: "\"${strings.substring(v: v2, start: 0, end: max)}\"",
																			Start: ast.Position{
																				Column: 38,
																				Line:   46,
																			},
																		},
																	},
																	Parts: []ast.StringExpressionPart{&ast.InterpolatedPart{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 86,
																					Line:   46,
																				},
																				File:   "opsgenie.flux",
																				Source: "${strings.substring(v: v2, start: 0, end: max)}",
																				Start: ast.Position{
																					Column: 39,
																					Line:   46,
																				},
																			},
																		},
																		Expression: &ast.CallExpression{
																			Arguments: []ast.Expression{&ast.ObjectExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 84,
																							Line:   46,
																						},
																						File:   "opsgenie.flux",
																						Source: "v: v2, start: 0, end: max",
																						Start: ast.Position{
																							Column: 59,
																							Line:   46,
																						},
																					},
																				},
																				Lbrace: nil,
																				Properties: []*ast.Property{&ast.Property{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 64,
																								Line:   46,
																							},
																							File:   "opsgenie.flux",
																							Source: "v: v2",
																							Start: ast.Position{
																								Column: 59,
																								Line:   46,
																							},
																						},
																					},
																					Comma: nil,
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 60,
																									Line:   46,
																								},
																								File:   "opsgenie.flux",
																								Source: "v",
																								Start: ast.Position{
																									Column: 59,
																									Line:   46,
																								},
																							},
																						},
																						Name: "v",
																					},
																					Separator: nil,
																					Value: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 64,
																									Line:   46,
																								},
																								File:   "opsgenie.flux",
																								Source: "v2",
																								Start: ast.Position{
																									Column: 62,
																									Line:   46,
																								},
																							},
																						},
																						Name: "v2",
																					},
																				}, &ast.Property{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 74,
																								Line:   46,
																							},
																							File:   "opsgenie.flux",
																							Source: "start: 0",
																							Start: ast.Position{
																								Column: 66,
																								Line:   46,
																							},
																						},
																					},
																					Comma: nil,
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 71,
																									Line:   46,
																								},
																								File:   "opsgenie.flux",
																								Source: "start",
																								Start: ast.Position{
																									Column: 66,
																									Line:   46,
																								},
																							},
																						},
																						Name: "start",
																					},
																					Separator: nil,
																					Value: &ast.IntegerLiteral{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 74,
																									Line:   46,
																								},
																								File:   "opsgenie.flux",
																								Source: "0",
																								Start: ast.Position{
																									Column: 73,
																									Line:   46,
																								},
																							},
																						},
																						Value: int64(0),
																					},
																				}, &ast.Property{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 84,
																								Line:   46,
																							},
																							File:   "opsgenie.flux",
																							Source: "end: max",
																							Start: ast.Position{
																								Column: 76,
																								Line:   46,
																							},
																						},
																					},
																					Comma: nil,
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 79,
																									Line:   46,
																								},
																								File:   "opsgenie.flux",
																								Source: "end",
																								Start: ast.Position{
																									Column: 76,
																									Line:   46,
																								},
																							},
																						},
																						Name: "end",
																					},
																					Separator: nil,
																					Value: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 84,
																									Line:   46,
																								},
																								File:   "opsgenie.flux",
																								Source: "max",
																								Start: ast.Position{
																									Column: 81,
																									Line:   46,
																								},
																							},
																						},
																						Name: "max",
																					},
																				}},
																				Rbrace: nil,
																				With:   nil,
																			}},
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 85,
																						Line:   46,
																					},
																					File:   "opsgenie.flux",
																					Source: "strings.substring(v: v2, start: 0, end: max)",
																					Start: ast.Position{
																						Column: 41,
																						Line:   46,
																					},
																				},
																			},
																			Callee: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 58,
																							Line:   46,
																						},
																						File:   "opsgenie.flux",
																						Source: "strings.substring",
																						Start: ast.Position{
																							Column: 41,
																							Line:   46,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 48,
																								Line:   46,
																							},
																							File:   "opsgenie.flux",
																							Source: "strings",
																							Start: ast.Position{
																								Column: 41,
																								Line:   46,
																							},
																						},
																					},
																					Name: "strings",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 58,
																								Line:   46,
																							},
																							File:   "opsgenie.flux",
																							Source: "substring",
																							Start: ast.Position{
																								Column: 49,
																								Line:   46,
																							},
																						},
																					},
																					Name: "substring",
																				},
																				Rbrack: nil,
																			},
																			Lparen: nil,
																			Rparen: nil,
																		},
																	}},
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 88,
																	Line:   46,
																},
																File:   "opsgenie.flux",
																Source: "json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\")",
																Start: ast.Position{
																	Column: 23,
																	Line:   46,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   46,
																	},
																	File:   "opsgenie.flux",
																	Source: "json.encode",
																	Start: ast.Position{
																		Column: 23,
																		Line:   46,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 27,
																			Line:   46,
																		},
																		File:   "opsgenie.flux",
																		Source: "json",
																		Start: ast.Position{
																			Column: 23,
																			Line:   46,
																		},
																	},
																},
																Name: "json",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 34,
																			Line:   46,
																		},
																		File:   "opsgenie.flux",
																		Source: "encode",
																		Start: ast.Position{
																			Column: 28,
																			Line:   46,
																		},
																	},
																},
																Name: "encode",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 89,
														Line:   46,
													},
													File:   "opsgenie.flux",
													Source: "string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))",
													Start: ast.Position{
														Column: 13,
														Line:   46,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   46,
														},
														File:   "opsgenie.flux",
														Source: "string",
														Start: ast.Position{
															Column: 13,
															Line:   46,
														},
													},
												},
												Name: "string",
											},
											Lparen: nil,
											Rparen: nil,
										},
										Test: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   45,
													},
													File:   "opsgenie.flux",
													Source: "strings.strlen(v: v2) > max",
													Start: ast.Position{
														Column: 19,
														Line:   45,
													},
												},
											},
											Left: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   45,
															},
															File:   "opsgenie.flux",
															Source: "v: v2",
															Start: ast.Position{
																Column: 34,
																Line:   45,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 39,
																	Line:   45,
																},
																File:   "opsgenie.flux",
																Source: "v: v2",
																Start: ast.Position{
																	Column: 34,
																	Line:   45,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 35,
																		Line:   45,
																	},
																	File:   "opsgenie.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 34,
																		Line:   45,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 39,
																		Line:   45,
																	},
																	File:   "opsgenie.flux",
																	Source: "v2",
																	Start: ast.Position{
																		Column: 37,
																		Line:   45,
																	},
																},
															},
															Name: "v2",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   45,
														},
														File:   "opsgenie.flux",
														Source: "strings.strlen(v: v2)",
														Start: ast.Position{
															Column: 19,
															Line:   45,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 33,
																Line:   45,
															},
															File:   "opsgenie.flux",
															Source: "strings.strlen",
															Start: ast.Position{
																Column: 19,
																Line:   45,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   45,
																},
																File:   "opsgenie.flux",
																Source: "strings",
																Start: ast.Position{
																	Column: 19,
																	Line:   45,
																},
															},
														},
														Name: "strings",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 33,
																	Line:   45,
																},
																File:   "opsgenie.flux",
																Source: "strlen",
																Start: ast.Position{
																	Column: 27,
																	Line:   45,
																},
															},
														},
														Name: "strlen",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
											Operator: 10,
											Right: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   45,
														},
														File:   "opsgenie.flux",
														Source: "max",
														Start: ast.Position{
															Column: 43,
															Line:   45,
														},
													},
												},
												Name: "max",
											},
										},
										Tk_else: nil,
										Tk_if:   nil,
										Tk_then: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   48,
											},
											File:   "opsgenie.flux",
											Source: "return if strings.strlen(v: v2) > max then\n            string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n        else\n            string(v: json.encode(v: v2))",
											Start: ast.Position{
												Column: 9,
												Line:   45,
											},
										},
									},
								}},
								Lbrace: nil,
								Rbrace: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   42,
										},
										File:   "opsgenie.flux",
										Source: "v",
										Start: ast.Position{
											Column: 18,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   42,
											},
											File:   "opsgenie.flux",
											Source: "v",
											Start: ast.Position{
												Column: 18,
												Line:   42,
											},
										},
									},
									Name: "v",
								},
								Separator: nil,
								Value:     nil,
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   42,
										},
										File:   "opsgenie.flux",
										Source: "max",
										Start: ast.Position{
											Column: 21,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   42,
											},
											File:   "opsgenie.flux",
											Source: "max",
											Start: ast.Position{
												Column: 21,
												Line:   42,
											},
										},
									},
									Name: "max",
								},
								Separator: nil,
								Value:     nil,
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   42,
										},
										File:   "opsgenie.flux",
										Source: "defV=\"\"",
										Start: ast.Position{
											Column: 26,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   42,
											},
											File:   "opsgenie.flux",
											Source: "defV",
											Start: ast.Position{
												Column: 26,
												Line:   42,
											},
										},
									},
									Name: "defV",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   42,
											},
											File:   "opsgenie.flux",
											Source: "\"\"",
											Start: ast.Position{
												Column: 31,
												Line:   42,
											},
										},
									},
									Value: "",
								},
							}},
							Rparan: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   61,
								},
								File:   "opsgenie.flux",
								Source: "body = \"{\n\\\"message\\\": ${cutEncode(v: message, max: 130)},\n\\\"alias\\\": ${cutEncode(v: alias, max: 512, defV: message)},\n\\\"description\\\": ${cutEncode(v: description, max: 15000)},\n\\\"responders\\\": ${respondersToJSON(v: responders)},\n\\\"visibleTo\\\": ${respondersToJSON(v: visibleTo)},\n\\\"actions\\\": ${string(v: json.encode(v: actions))},\n\\\"tags\\\": ${string(v: json.encode(v: tags))},\n\\\"details\\\": ${details},\n\\\"entity\\\": ${cutEncode(v: entity, max: 512)},\n\\\"priority\\\": ${cutEncode(v: priority, max: 2)}\n}\"",
								Start: ast.Position{
									Column: 5,
									Line:   50,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   50,
									},
									File:   "opsgenie.flux",
									Source: "body",
									Start: ast.Position{
										Column: 5,
										Line:   50,
									},
								},
							},
							Name: "body",
						},
						Init: &ast.StringExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   61,
									},
									File:   "opsgenie.flux",
									Source: "\"{\n\\\"message\\\": ${cutEncode(v: message, max: 130)},\n\\\"alias\\\": ${cutEncode(v: alias, max: 512, defV: message)},\n\\\"description\\\": ${cutEncode(v: description, max: 15000)},\n\\\"responders\\\": ${respondersToJSON(v: responders)},\n\\\"visibleTo\\\": ${respondersToJSON(v: visibleTo)},\n\\\"actions\\\": ${string(v: json.encode(v: actions))},\n\\\"tags\\\": ${string(v: json.encode(v: tags))},\n\\\"details\\\": ${details},\n\\\"entity\\\": ${cutEncode(v: entity, max: 512)},\n\\\"priority\\\": ${cutEncode(v: priority, max: 2)}\n}\"",
									Start: ast.Position{
										Column: 12,
										Line:   50,
									},
								},
							},
							Parts: []ast.StringExpressionPart{&ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   51,
										},
										File:   "opsgenie.flux",
										Source: "{\n\\\"message\\\": ",
										Start: ast.Position{
											Column: 13,
											Line:   50,
										},
									},
								},
								Value: "{\n\"message\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   51,
										},
										File:   "opsgenie.flux",
										Source: "${cutEncode(v: message, max: 130)}",
										Start: ast.Position{
											Column: 14,
											Line:   51,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   51,
												},
												File:   "opsgenie.flux",
												Source: "v: message, max: 130",
												Start: ast.Position{
													Column: 26,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   51,
													},
													File:   "opsgenie.flux",
													Source: "v: message",
													Start: ast.Position{
														Column: 26,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   51,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 26,
															Line:   51,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   51,
														},
														File:   "opsgenie.flux",
														Source: "message",
														Start: ast.Position{
															Column: 29,
															Line:   51,
														},
													},
												},
												Name: "message",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   51,
													},
													File:   "opsgenie.flux",
													Source: "max: 130",
													Start: ast.Position{
														Column: 38,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   51,
														},
														File:   "opsgenie.flux",
														Source: "max",
														Start: ast.Position{
															Column: 38,
															Line:   51,
														},
													},
												},
												Name: "max",
											},
											Separator: nil,
											Value: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   51,
														},
														File:   "opsgenie.flux",
														Source: "130",
														Start: ast.Position{
															Column: 43,
															Line:   51,
														},
													},
												},
												Value: int64(130),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   51,
											},
											File:   "opsgenie.flux",
											Source: "cutEncode(v: message, max: 130)",
											Start: ast.Position{
												Column: 16,
												Line:   51,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   51,
												},
												File:   "opsgenie.flux",
												Source: "cutEncode",
												Start: ast.Position{
													Column: 16,
													Line:   51,
												},
											},
										},
										Name: "cutEncode",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   52,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"alias\\\": ",
										Start: ast.Position{
											Column: 48,
											Line:   51,
										},
									},
								},
								Value: ",\n\"alias\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   52,
										},
										File:   "opsgenie.flux",
										Source: "${cutEncode(v: alias, max: 512, defV: message)}",
										Start: ast.Position{
											Column: 12,
											Line:   52,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   52,
												},
												File:   "opsgenie.flux",
												Source: "v: alias, max: 512, defV: message",
												Start: ast.Position{
													Column: 24,
													Line:   52,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   52,
													},
													File:   "opsgenie.flux",
													Source: "v: alias",
													Start: ast.Position{
														Column: 24,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   52,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 24,
															Line:   52,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   52,
														},
														File:   "opsgenie.flux",
														Source: "alias",
														Start: ast.Position{
															Column: 27,
															Line:   52,
														},
													},
												},
												Name: "alias",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   52,
													},
													File:   "opsgenie.flux",
													Source: "max: 512",
													Start: ast.Position{
														Column: 34,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   52,
														},
														File:   "opsgenie.flux",
														Source: "max",
														Start: ast.Position{
															Column: 34,
															Line:   52,
														},
													},
												},
												Name: "max",
											},
											Separator: nil,
											Value: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   52,
														},
														File:   "opsgenie.flux",
														Source: "512",
														Start: ast.Position{
															Column: 39,
															Line:   52,
														},
													},
												},
												Value: int64(512),
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   52,
													},
													File:   "opsgenie.flux",
													Source: "defV: message",
													Start: ast.Position{
														Column: 44,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   52,
														},
														File:   "opsgenie.flux",
														Source: "defV",
														Start: ast.Position{
															Column: 44,
															Line:   52,
														},
													},
												},
												Name: "defV",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 57,
															Line:   52,
														},
														File:   "opsgenie.flux",
														Source: "message",
														Start: ast.Position{
															Column: 50,
															Line:   52,
														},
													},
												},
												Name: "message",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   52,
											},
											File:   "opsgenie.flux",
											Source: "cutEncode(v: alias, max: 512, defV: message)",
											Start: ast.Position{
												Column: 14,
												Line:   52,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   52,
												},
												File:   "opsgenie.flux",
												Source: "cutEncode",
												Start: ast.Position{
													Column: 14,
													Line:   52,
												},
											},
										},
										Name: "cutEncode",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   53,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"description\\\": ",
										Start: ast.Position{
											Column: 59,
											Line:   52,
										},
									},
								},
								Value: ",\n\"description\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   53,
										},
										File:   "opsgenie.flux",
										Source: "${cutEncode(v: description, max: 15000)}",
										Start: ast.Position{
											Column: 18,
											Line:   53,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   53,
												},
												File:   "opsgenie.flux",
												Source: "v: description, max: 15000",
												Start: ast.Position{
													Column: 30,
													Line:   53,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   53,
													},
													File:   "opsgenie.flux",
													Source: "v: description",
													Start: ast.Position{
														Column: 30,
														Line:   53,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   53,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 30,
															Line:   53,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   53,
														},
														File:   "opsgenie.flux",
														Source: "description",
														Start: ast.Position{
															Column: 33,
															Line:   53,
														},
													},
												},
												Name: "description",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   53,
													},
													File:   "opsgenie.flux",
													Source: "max: 15000",
													Start: ast.Position{
														Column: 46,
														Line:   53,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   53,
														},
														File:   "opsgenie.flux",
														Source: "max",
														Start: ast.Position{
															Column: 46,
															Line:   53,
														},
													},
												},
												Name: "max",
											},
											Separator: nil,
											Value: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   53,
														},
														File:   "opsgenie.flux",
														Source: "15000",
														Start: ast.Position{
															Column: 51,
															Line:   53,
														},
													},
												},
												Value: int64(15000),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   53,
											},
											File:   "opsgenie.flux",
											Source: "cutEncode(v: description, max: 15000)",
											Start: ast.Position{
												Column: 20,
												Line:   53,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   53,
												},
												File:   "opsgenie.flux",
												Source: "cutEncode",
												Start: ast.Position{
													Column: 20,
													Line:   53,
												},
											},
										},
										Name: "cutEncode",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   54,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"responders\\\": ",
										Start: ast.Position{
											Column: 58,
											Line:   53,
										},
									},
								},
								Value: ",\n\"responders\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   54,
										},
										File:   "opsgenie.flux",
										Source: "${respondersToJSON(v: responders)}",
										Start: ast.Position{
											Column: 17,
											Line:   54,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   54,
												},
												File:   "opsgenie.flux",
												Source: "v: responders",
												Start: ast.Position{
													Column: 36,
													Line:   54,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   54,
													},
													File:   "opsgenie.flux",
													Source: "v: responders",
													Start: ast.Position{
														Column: 36,
														Line:   54,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   54,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 36,
															Line:   54,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   54,
														},
														File:   "opsgenie.flux",
														Source: "responders",
														Start: ast.Position{
															Column: 39,
															Line:   54,
														},
													},
												},
												Name: "responders",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   54,
											},
											File:   "opsgenie.flux",
											Source: "respondersToJSON(v: responders)",
											Start: ast.Position{
												Column: 19,
												Line:   54,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   54,
												},
												File:   "opsgenie.flux",
												Source: "respondersToJSON",
												Start: ast.Position{
													Column: 19,
													Line:   54,
												},
											},
										},
										Name: "respondersToJSON",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   55,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"visibleTo\\\": ",
										Start: ast.Position{
											Column: 51,
											Line:   54,
										},
									},
								},
								Value: ",\n\"visibleTo\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   55,
										},
										File:   "opsgenie.flux",
										Source: "${respondersToJSON(v: visibleTo)}",
										Start: ast.Position{
											Column: 16,
											Line:   55,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   55,
												},
												File:   "opsgenie.flux",
												Source: "v: visibleTo",
												Start: ast.Position{
													Column: 35,
													Line:   55,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   55,
													},
													File:   "opsgenie.flux",
													Source: "v: visibleTo",
													Start: ast.Position{
														Column: 35,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   55,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 35,
															Line:   55,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   55,
														},
														File:   "opsgenie.flux",
														Source: "visibleTo",
														Start: ast.Position{
															Column: 38,
															Line:   55,
														},
													},
												},
												Name: "visibleTo",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   55,
											},
											File:   "opsgenie.flux",
											Source: "respondersToJSON(v: visibleTo)",
											Start: ast.Position{
												Column: 18,
												Line:   55,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   55,
												},
												File:   "opsgenie.flux",
												Source: "respondersToJSON",
												Start: ast.Position{
													Column: 18,
													Line:   55,
												},
											},
										},
										Name: "respondersToJSON",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   56,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"actions\\\": ",
										Start: ast.Position{
											Column: 49,
											Line:   55,
										},
									},
								},
								Value: ",\n\"actions\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   56,
										},
										File:   "opsgenie.flux",
										Source: "${string(v: json.encode(v: actions))}",
										Start: ast.Position{
											Column: 14,
											Line:   56,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   56,
												},
												File:   "opsgenie.flux",
												Source: "v: json.encode(v: actions)",
												Start: ast.Position{
													Column: 23,
													Line:   56,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   56,
													},
													File:   "opsgenie.flux",
													Source: "v: json.encode(v: actions)",
													Start: ast.Position{
														Column: 23,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   56,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 23,
															Line:   56,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   56,
															},
															File:   "opsgenie.flux",
															Source: "v: actions",
															Start: ast.Position{
																Column: 38,
																Line:   56,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   56,
																},
																File:   "opsgenie.flux",
																Source: "v: actions",
																Start: ast.Position{
																	Column: 38,
																	Line:   56,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 39,
																		Line:   56,
																	},
																	File:   "opsgenie.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 38,
																		Line:   56,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   56,
																	},
																	File:   "opsgenie.flux",
																	Source: "actions",
																	Start: ast.Position{
																		Column: 41,
																		Line:   56,
																	},
																},
															},
															Name: "actions",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   56,
														},
														File:   "opsgenie.flux",
														Source: "json.encode(v: actions)",
														Start: ast.Position{
															Column: 26,
															Line:   56,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   56,
															},
															File:   "opsgenie.flux",
															Source: "json.encode",
															Start: ast.Position{
																Column: 26,
																Line:   56,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   56,
																},
																File:   "opsgenie.flux",
																Source: "json",
																Start: ast.Position{
																	Column: 26,
																	Line:   56,
																},
															},
														},
														Name: "json",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   56,
																},
																File:   "opsgenie.flux",
																Source: "encode",
																Start: ast.Position{
																	Column: 31,
																	Line:   56,
																},
															},
														},
														Name: "encode",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   56,
											},
											File:   "opsgenie.flux",
											Source: "string(v: json.encode(v: actions))",
											Start: ast.Position{
												Column: 16,
												Line:   56,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   56,
												},
												File:   "opsgenie.flux",
												Source: "string",
												Start: ast.Position{
													Column: 16,
													Line:   56,
												},
											},
										},
										Name: "string",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   57,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"tags\\\": ",
										Start: ast.Position{
											Column: 51,
											Line:   56,
										},
									},
								},
								Value: ",\n\"tags\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   57,
										},
										File:   "opsgenie.flux",
										Source: "${string(v: json.encode(v: tags))}",
										Start: ast.Position{
											Column: 11,
											Line:   57,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   57,
												},
												File:   "opsgenie.flux",
												Source: "v: json.encode(v: tags)",
												Start: ast.Position{
													Column: 20,
													Line:   57,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   57,
													},
													File:   "opsgenie.flux",
													Source: "v: json.encode(v: tags)",
													Start: ast.Position{
														Column: 20,
														Line:   57,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   57,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 20,
															Line:   57,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   57,
															},
															File:   "opsgenie.flux",
															Source: "v: tags",
															Start: ast.Position{
																Column: 35,
																Line:   57,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   57,
																},
																File:   "opsgenie.flux",
																Source: "v: tags",
																Start: ast.Position{
																	Column: 35,
																	Line:   57,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   57,
																	},
																	File:   "opsgenie.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 35,
																		Line:   57,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 42,
																		Line:   57,
																	},
																	File:   "opsgenie.flux",
																	Source: "tags",
																	Start: ast.Position{
																		Column: 38,
																		Line:   57,
																	},
																},
															},
															Name: "tags",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   57,
														},
														File:   "opsgenie.flux",
														Source: "json.encode(v: tags)",
														Start: ast.Position{
															Column: 23,
															Line:   57,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   57,
															},
															File:   "opsgenie.flux",
															Source: "json.encode",
															Start: ast.Position{
																Column: 23,
																Line:   57,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   57,
																},
																File:   "opsgenie.flux",
																Source: "json",
																Start: ast.Position{
																	Column: 23,
																	Line:   57,
																},
															},
														},
														Name: "json",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   57,
																},
																File:   "opsgenie.flux",
																Source: "encode",
																Start: ast.Position{
																	Column: 28,
																	Line:   57,
																},
															},
														},
														Name: "encode",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   57,
											},
											File:   "opsgenie.flux",
											Source: "string(v: json.encode(v: tags))",
											Start: ast.Position{
												Column: 13,
												Line:   57,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   57,
												},
												File:   "opsgenie.flux",
												Source: "string",
												Start: ast.Position{
													Column: 13,
													Line:   57,
												},
											},
										},
										Name: "string",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   58,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"details\\\": ",
										Start: ast.Position{
											Column: 45,
											Line:   57,
										},
									},
								},
								Value: ",\n\"details\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   58,
										},
										File:   "opsgenie.flux",
										Source: "${details}",
										Start: ast.Position{
											Column: 14,
											Line:   58,
										},
									},
								},
								Expression: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   58,
											},
											File:   "opsgenie.flux",
											Source: "details",
											Start: ast.Position{
												Column: 16,
												Line:   58,
											},
										},
									},
									Name: "details",
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   59,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"entity\\\": ",
										Start: ast.Position{
											Column: 24,
											Line:   58,
										},
									},
								},
								Value: ",\n\"entity\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   59,
										},
										File:   "opsgenie.flux",
										Source: "${cutEncode(v: entity, max: 512)}",
										Start: ast.Position{
											Column: 13,
											Line:   59,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   59,
												},
												File:   "opsgenie.flux",
												Source: "v: entity, max: 512",
												Start: ast.Position{
													Column: 25,
													Line:   59,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   59,
													},
													File:   "opsgenie.flux",
													Source: "v: entity",
													Start: ast.Position{
														Column: 25,
														Line:   59,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   59,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 25,
															Line:   59,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   59,
														},
														File:   "opsgenie.flux",
														Source: "entity",
														Start: ast.Position{
															Column: 28,
															Line:   59,
														},
													},
												},
												Name: "entity",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   59,
													},
													File:   "opsgenie.flux",
													Source: "max: 512",
													Start: ast.Position{
														Column: 36,
														Line:   59,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   59,
														},
														File:   "opsgenie.flux",
														Source: "max",
														Start: ast.Position{
															Column: 36,
															Line:   59,
														},
													},
												},
												Name: "max",
											},
											Separator: nil,
											Value: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   59,
														},
														File:   "opsgenie.flux",
														Source: "512",
														Start: ast.Position{
															Column: 41,
															Line:   59,
														},
													},
												},
												Value: int64(512),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   59,
											},
											File:   "opsgenie.flux",
											Source: "cutEncode(v: entity, max: 512)",
											Start: ast.Position{
												Column: 15,
												Line:   59,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   59,
												},
												File:   "opsgenie.flux",
												Source: "cutEncode",
												Start: ast.Position{
													Column: 15,
													Line:   59,
												},
											},
										},
										Name: "cutEncode",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   60,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"priority\\\": ",
										Start: ast.Position{
											Column: 46,
											Line:   59,
										},
									},
								},
								Value: ",\n\"priority\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   60,
										},
										File:   "opsgenie.flux",
										Source: "${cutEncode(v: priority, max: 2)}",
										Start: ast.Position{
											Column: 15,
											Line:   60,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   60,
												},
												File:   "opsgenie.flux",
												Source: "v: priority, max: 2",
												Start: ast.Position{
													Column: 27,
													Line:   60,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   60,
													},
													File:   "opsgenie.flux",
													Source: "v: priority",
													Start: ast.Position{
														Column: 27,
														Line:   60,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   60,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 27,
															Line:   60,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   60,
														},
														File:   "opsgenie.flux",
														Source: "priority",
														Start: ast.Position{
															Column: 30,
															Line:   60,
														},
													},
												},
												Name: "priority",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   60,
													},
													File:   "opsgenie.flux",
													Source: "max: 2",
													Start: ast.Position{
														Column: 40,
														Line:   60,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   60,
														},
														File:   "opsgenie.flux",
														Source: "max",
														Start: ast.Position{
															Column: 40,
															Line:   60,
														},
													},
												},
												Name: "max",
											},
											Separator: nil,
											Value: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   60,
														},
														File:   "opsgenie.flux",
														Source: "2",
														Start: ast.Position{
															Column: 45,
															Line:   60,
														},
													},
												},
												Value: int64(2),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   60,
											},
											File:   "opsgenie.flux",
											Source: "cutEncode(v: priority, max: 2)",
											Start: ast.Position{
												Column: 17,
												Line:   60,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   60,
												},
												File:   "opsgenie.flux",
												Source: "cutEncode",
												Start: ast.Position{
													Column: 17,
													Line:   60,
												},
											},
										},
										Name: "cutEncode",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 2,
											Line:   61,
										},
										File:   "opsgenie.flux",
										Source: "\n}",
										Start: ast.Position{
											Column: 48,
											Line:   60,
										},
									},
								},
								Value: "\n}",
							}},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   63,
										},
										File:   "opsgenie.flux",
										Source: "headers: headers, url: url, data: bytes(v: body)",
										Start: ast.Position{
											Column: 22,
											Line:   63,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   63,
											},
											File:   "opsgenie.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   63,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   63,
												},
												File:   "opsgenie.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   63,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   63,
												},
												File:   "opsgenie.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   63,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   63,
											},
											File:   "opsgenie.flux",
											Source: "url: url",
											Start: ast.Position{
												Column: 40,
												Line:   63,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   63,
												},
												File:   "opsgenie.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   63,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   63,
												},
												File:   "opsgenie.flux",
												Source: "url",
												Start: ast.Position{
													Column: 45,
													Line:   63,
												},
											},
										},
										Name: "url",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   63,
											},
											File:   "opsgenie.flux",
											Source: "data: bytes(v: body)",
											Start: ast.Position{
												Column: 50,
												Line:   63,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   63,
												},
												File:   "opsgenie.flux",
												Source: "data",
												Start: ast.Position{
													Column: 50,
													Line:   63,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   63,
													},
													File:   "opsgenie.flux",
													Source: "v: body",
													Start: ast.Position{
														Column: 62,
														Line:   63,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   63,
														},
														File:   "opsgenie.flux",
														Source: "v: body",
														Start: ast.Position{
															Column: 62,
															Line:   63,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 63,
																Line:   63,
															},
															File:   "opsgenie.flux",
															Source: "v",
															Start: ast.Position{
																Column: 62,
																Line:   63,
															},
														},
													},
													Name: "v",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   63,
															},
															File:   "opsgenie.flux",
															Source: "body",
															Start: ast.Position{
																Column: 65,
																Line:   63,
															},
														},
													},
													Name: "body",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   63,
												},
												File:   "opsgenie.flux",
												Source: "bytes(v: body)",
												Start: ast.Position{
													Column: 56,
													Line:   63,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   63,
													},
													File:   "opsgenie.flux",
													Source: "bytes",
													Start: ast.Position{
														Column: 56,
														Line:   63,
													},
												},
											},
											Name: "bytes",
										},
										Lparen: nil,
										Rparen: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   63,
									},
									File:   "opsgenie.flux",
									Source: "http.post(headers: headers, url: url, data: bytes(v: body))",
									Start: ast.Position{
										Column: 12,
										Line:   63,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   63,
										},
										File:   "opsgenie.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   63,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   63,
											},
											File:   "opsgenie.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   63,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   63,
											},
											File:   "opsgenie.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   63,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   63,
								},
								File:   "opsgenie.flux",
								Source: "return http.post(headers: headers, url: url, data: bytes(v: body))",
								Start: ast.Position{
									Column: 5,
									Line:   63,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   25,
							},
							File:   "opsgenie.flux",
							Source: "url=\"https://api.opsgenie.com/v2/alerts\"",
							Start: ast.Position{
								Column: 9,
								Line:   25,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   25,
								},
								File:   "opsgenie.flux",
								Source: "url",
								Start: ast.Position{
									Column: 9,
									Line:   25,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   25,
								},
								File:   "opsgenie.flux",
								Source: "\"https://api.opsgenie.com/v2/alerts\"",
								Start: ast.Position{
									Column: 13,
									Line:   25,
								},
							},
						},
						Value: "https://api.opsgenie.com/v2/alerts",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   26,
							},
							File:   "opsgenie.flux",
							Source: "apiKey",
							Start: ast.Position{
								Column: 9,
								Line:   26,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   26,
								},
								File:   "opsgenie.flux",
								Source: "apiKey",
								Start: ast.Position{
									Column: 9,
									Line:   26,
								},
							},
						},
						Name: "apiKey",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   27,
							},
							File:   "opsgenie.flux",
							Source: "message",
							Start: ast.Position{
								Column: 9,
								Line:   27,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   27,
								},
								File:   "opsgenie.flux",
								Source: "message",
								Start: ast.Position{
									Column: 9,
									Line:   27,
								},
							},
						},
						Name: "message",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   28,
							},
							File:   "opsgenie.flux",
							Source: "alias=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   28,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   28,
								},
								File:   "opsgenie.flux",
								Source: "alias",
								Start: ast.Position{
									Column: 9,
									Line:   28,
								},
							},
						},
						Name: "alias",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   28,
								},
								File:   "opsgenie.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 15,
									Line:   28,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   29,
							},
							File:   "opsgenie.flux",
							Source: "description=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   29,
								},
								File:   "opsgenie.flux",
								Source: "description",
								Start: ast.Position{
									Column: 9,
									Line:   29,
								},
							},
						},
						Name: "description",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   29,
								},
								File:   "opsgenie.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 21,
									Line:   29,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   30,
							},
							File:   "opsgenie.flux",
							Source: "priority=\"P3\"",
							Start: ast.Position{
								Column: 9,
								Line:   30,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   30,
								},
								File:   "opsgenie.flux",
								Source: "priority",
								Start: ast.Position{
									Column: 9,
									Line:   30,
								},
							},
						},
						Name: "priority",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   30,
								},
								File:   "opsgenie.flux",
								Source: "\"P3\"",
								Start: ast.Position{
									Column: 18,
									Line:   30,
								},
							},
						},
						Value: "P3",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   31,
							},
							File:   "opsgenie.flux",
							Source: "responders=[]",
							Start: ast.Position{
								Column: 9,
								Line:   31,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   31,
								},
								File:   "opsgenie.flux",
								Source: "responders",
								Start: ast.Position{
									Column: 9,
									Line:   31,
								},
							},
						},
						Name: "responders",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   31,
								},
								File:   "opsgenie.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 20,
									Line:   31,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   32,
							},
							File:   "opsgenie.flux",
							Source: "tags=[]",
							Start: ast.Position{
								Column: 9,
								Line:   32,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   32,
								},
								File:   "opsgenie.flux",
								Source: "tags",
								Start: ast.Position{
									Column: 9,
									Line:   32,
								},
							},
						},
						Name: "tags",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   32,
								},
								File:   "opsgenie.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 14,
									Line:   32,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   33,
							},
							File:   "opsgenie.flux",
							Source: "entity=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   33,
								},
								File:   "opsgenie.flux",
								Source: "entity",
								Start: ast.Position{
									Column: 9,
									Line:   33,
								},
							},
						},
						Name: "entity",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   33,
								},
								File:   "opsgenie.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 16,
									Line:   33,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   34,
							},
							File:   "opsgenie.flux",
							Source: "actions=[]",
							Start: ast.Position{
								Column: 9,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   34,
								},
								File:   "opsgenie.flux",
								Source: "actions",
								Start: ast.Position{
									Column: 9,
									Line:   34,
								},
							},
						},
						Name: "actions",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   34,
								},
								File:   "opsgenie.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 17,
									Line:   34,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   35,
							},
							File:   "opsgenie.flux",
							Source: "visibleTo=[]",
							Start: ast.Position{
								Column: 9,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   35,
								},
								File:   "opsgenie.flux",
								Source: "visibleTo",
								Start: ast.Position{
									Column: 9,
									Line:   35,
								},
							},
						},
						Name: "visibleTo",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   35,
								},
								File:   "opsgenie.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 19,
									Line:   35,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   36,
							},
							File:   "opsgenie.flux",
							Source: "details=\"{}\"",
							Start: ast.Position{
								Column: 9,
								Line:   36,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   36,
								},
								File:   "opsgenie.flux",
								Source: "details",
								Start: ast.Position{
									Column: 9,
									Line:   36,
								},
							},
						},
						Name: "details",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   36,
								},
								File:   "opsgenie.flux",
								Source: "\"{}\"",
								Start: ast.Position{
									Column: 17,
									Line:   36,
								},
							},
						},
						Value: "{}",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   96,
					},
					File:   "opsgenie.flux",
					Source: "endpoint = (url=\"https://api.opsgenie.com/v2/alerts\", apiKey, entity=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   72,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send alerts to opsgenie for each table row.\n"}, ast.Comment{Text: "// `url`         - string - Opsgenie API URL. Defaults to \"https://api.opsgenie.com/v2/alerts\". \n"}, ast.Comment{Text: "// `apiKey`      - string - API Authorization key. \n"}, ast.Comment{Text: "// `entity`      - string - Entity of the alert, used to specify domain of the alert. Optional. \n"}, ast.Comment{Text: "// The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "// The `mapFn` must return an object with all properties defined in the `sendAlert` function arguments (except url, apiKey and entity).\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   72,
						},
						File:   "opsgenie.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   72,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   96,
						},
						File:   "opsgenie.flux",
						Source: "(url=\"https://api.opsgenie.com/v2/alerts\", apiKey, entity=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
						Start: ast.Position{
							Column: 12,
							Line:   72,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   96,
							},
							File:   "opsgenie.flux",
							Source: "(mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
							Start: ast.Position{
								Column: 77,
								Line:   72,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   96,
								},
								File:   "opsgenie.flux",
								Source: "(tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
								Start: ast.Position{
									Column: 88,
									Line:   72,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 109,
											Line:   72,
										},
										File:   "opsgenie.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 103,
											Line:   72,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   96,
									},
									File:   "opsgenie.flux",
									Source: "tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
									Start: ast.Position{
										Column: 103,
										Line:   72,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   95,
											},
											File:   "opsgenie.flux",
											Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100,\n                ),\n            }\n        }",
											Start: ast.Position{
												Column: 9,
												Line:   74,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   95,
												},
												File:   "opsgenie.flux",
												Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100,\n                ),\n            }\n        }",
												Start: ast.Position{
													Column: 9,
													Line:   74,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   74,
													},
													File:   "opsgenie.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   74,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   95,
													},
													File:   "opsgenie.flux",
													Source: "(r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100,\n                ),\n            }\n        }",
													Start: ast.Position{
														Column: 13,
														Line:   74,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   95,
														},
														File:   "opsgenie.flux",
														Source: "{\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100,\n                ),\n            }\n        }",
														Start: ast.Position{
															Column: 20,
															Line:   74,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   75,
															},
															File:   "opsgenie.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 13,
																Line:   75,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   75,
																},
																File:   "opsgenie.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 13,
																	Line:   75,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   75,
																	},
																	File:   "opsgenie.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   75,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   75,
																		},
																		File:   "opsgenie.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 25,
																			Line:   75,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   75,
																			},
																			File:   "opsgenie.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 25,
																				Line:   75,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   75,
																			},
																			File:   "opsgenie.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 28,
																				Line:   75,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   75,
																},
																File:   "opsgenie.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 19,
																	Line:   75,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   75,
																	},
																	File:   "opsgenie.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 19,
																		Line:   75,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   94,
																},
																File:   "opsgenie.flux",
																Source: "{r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100,\n                ),\n            }",
																Start: ast.Position{
																	Column: 20,
																	Line:   77,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   93,
																	},
																	File:   "opsgenie.flux",
																	Source: "_sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100,\n                )",
																	Start: ast.Position{
																		Column: 17,
																		Line:   78,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   78,
																		},
																		File:   "opsgenie.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 17,
																			Line:   78,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   92,
																			},
																			File:   "opsgenie.flux",
																			Source: "v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100",
																			Start: ast.Position{
																				Column: 21,
																				Line:   79,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   92,
																				},
																				File:   "opsgenie.flux",
																				Source: "v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100",
																				Start: ast.Position{
																					Column: 21,
																					Line:   79,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   79,
																					},
																					File:   "opsgenie.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 21,
																						Line:   79,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 28,
																						Line:   92,
																					},
																					File:   "opsgenie.flux",
																					Source: "2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100",
																					Start: ast.Position{
																						Column: 24,
																						Line:   79,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   79,
																						},
																						File:   "opsgenie.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 24,
																							Line:   79,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 28,
																							Line:   92,
																						},
																						File:   "opsgenie.flux",
																						Source: "sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100",
																						Start: ast.Position{
																							Column: 29,
																							Line:   79,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 45,
																									Line:   91,
																								},
																								File:   "opsgenie.flux",
																								Source: "url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details",
																								Start: ast.Position{
																									Column: 25,
																									Line:   80,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 33,
																										Line:   80,
																									},
																									File:   "opsgenie.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 25,
																										Line:   80,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   80,
																										},
																										File:   "opsgenie.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 25,
																											Line:   80,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   80,
																										},
																										File:   "opsgenie.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 30,
																											Line:   80,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   81,
																									},
																									File:   "opsgenie.flux",
																									Source: "apiKey: apiKey",
																									Start: ast.Position{
																										Column: 25,
																										Line:   81,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   81,
																										},
																										File:   "opsgenie.flux",
																										Source: "apiKey",
																										Start: ast.Position{
																											Column: 25,
																											Line:   81,
																										},
																									},
																								},
																								Name: "apiKey",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   81,
																										},
																										File:   "opsgenie.flux",
																										Source: "apiKey",
																										Start: ast.Position{
																											Column: 33,
																											Line:   81,
																										},
																									},
																								},
																								Name: "apiKey",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   82,
																									},
																									File:   "opsgenie.flux",
																									Source: "entity: entity",
																									Start: ast.Position{
																										Column: 25,
																										Line:   82,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   82,
																										},
																										File:   "opsgenie.flux",
																										Source: "entity",
																										Start: ast.Position{
																											Column: 25,
																											Line:   82,
																										},
																									},
																								},
																								Name: "entity",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   82,
																										},
																										File:   "opsgenie.flux",
																										Source: "entity",
																										Start: ast.Position{
																											Column: 33,
																											Line:   82,
																										},
																									},
																								},
																								Name: "entity",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   83,
																									},
																									File:   "opsgenie.flux",
																									Source: "message: obj.message",
																									Start: ast.Position{
																										Column: 25,
																										Line:   83,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 32,
																											Line:   83,
																										},
																										File:   "opsgenie.flux",
																										Source: "message",
																										Start: ast.Position{
																											Column: 25,
																											Line:   83,
																										},
																									},
																								},
																								Name: "message",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   83,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.message",
																										Start: ast.Position{
																											Column: 34,
																											Line:   83,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   83,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 34,
																												Line:   83,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   83,
																											},
																											File:   "opsgenie.flux",
																											Source: "message",
																											Start: ast.Position{
																												Column: 38,
																												Line:   83,
																											},
																										},
																									},
																									Name: "message",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   84,
																									},
																									File:   "opsgenie.flux",
																									Source: "alias: obj.alias",
																									Start: ast.Position{
																										Column: 25,
																										Line:   84,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   84,
																										},
																										File:   "opsgenie.flux",
																										Source: "alias",
																										Start: ast.Position{
																											Column: 25,
																											Line:   84,
																										},
																									},
																								},
																								Name: "alias",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   84,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.alias",
																										Start: ast.Position{
																											Column: 32,
																											Line:   84,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   84,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 32,
																												Line:   84,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   84,
																											},
																											File:   "opsgenie.flux",
																											Source: "alias",
																											Start: ast.Position{
																												Column: 36,
																												Line:   84,
																											},
																										},
																									},
																									Name: "alias",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 53,
																										Line:   85,
																									},
																									File:   "opsgenie.flux",
																									Source: "description: obj.description",
																									Start: ast.Position{
																										Column: 25,
																										Line:   85,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 36,
																											Line:   85,
																										},
																										File:   "opsgenie.flux",
																										Source: "description",
																										Start: ast.Position{
																											Column: 25,
																											Line:   85,
																										},
																									},
																								},
																								Name: "description",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 53,
																											Line:   85,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.description",
																										Start: ast.Position{
																											Column: 38,
																											Line:   85,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   85,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 38,
																												Line:   85,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 53,
																												Line:   85,
																											},
																											File:   "opsgenie.flux",
																											Source: "description",
																											Start: ast.Position{
																												Column: 42,
																												Line:   85,
																											},
																										},
																									},
																									Name: "description",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 47,
																										Line:   86,
																									},
																									File:   "opsgenie.flux",
																									Source: "priority: obj.priority",
																									Start: ast.Position{
																										Column: 25,
																										Line:   86,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   86,
																										},
																										File:   "opsgenie.flux",
																										Source: "priority",
																										Start: ast.Position{
																											Column: 25,
																											Line:   86,
																										},
																									},
																								},
																								Name: "priority",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 47,
																											Line:   86,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.priority",
																										Start: ast.Position{
																											Column: 35,
																											Line:   86,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 38,
																												Line:   86,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 35,
																												Line:   86,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 47,
																												Line:   86,
																											},
																											File:   "opsgenie.flux",
																											Source: "priority",
																											Start: ast.Position{
																												Column: 39,
																												Line:   86,
																											},
																										},
																									},
																									Name: "priority",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 51,
																										Line:   87,
																									},
																									File:   "opsgenie.flux",
																									Source: "responders: obj.responders",
																									Start: ast.Position{
																										Column: 25,
																										Line:   87,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 35,
																											Line:   87,
																										},
																										File:   "opsgenie.flux",
																										Source: "responders",
																										Start: ast.Position{
																											Column: 25,
																											Line:   87,
																										},
																									},
																								},
																								Name: "responders",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 51,
																											Line:   87,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.responders",
																										Start: ast.Position{
																											Column: 37,
																											Line:   87,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 40,
																												Line:   87,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 37,
																												Line:   87,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 51,
																												Line:   87,
																											},
																											File:   "opsgenie.flux",
																											Source: "responders",
																											Start: ast.Position{
																												Column: 41,
																												Line:   87,
																											},
																										},
																									},
																									Name: "responders",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   88,
																									},
																									File:   "opsgenie.flux",
																									Source: "tags: obj.tags",
																									Start: ast.Position{
																										Column: 25,
																										Line:   88,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   88,
																										},
																										File:   "opsgenie.flux",
																										Source: "tags",
																										Start: ast.Position{
																											Column: 25,
																											Line:   88,
																										},
																									},
																								},
																								Name: "tags",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   88,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.tags",
																										Start: ast.Position{
																											Column: 31,
																											Line:   88,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 34,
																												Line:   88,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 31,
																												Line:   88,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   88,
																											},
																											File:   "opsgenie.flux",
																											Source: "tags",
																											Start: ast.Position{
																												Column: 35,
																												Line:   88,
																											},
																										},
																									},
																									Name: "tags",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   89,
																									},
																									File:   "opsgenie.flux",
																									Source: "actions: obj.actions",
																									Start: ast.Position{
																										Column: 25,
																										Line:   89,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 32,
																											Line:   89,
																										},
																										File:   "opsgenie.flux",
																										Source: "actions",
																										Start: ast.Position{
																											Column: 25,
																											Line:   89,
																										},
																									},
																								},
																								Name: "actions",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   89,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.actions",
																										Start: ast.Position{
																											Column: 34,
																											Line:   89,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   89,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 34,
																												Line:   89,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   89,
																											},
																											File:   "opsgenie.flux",
																											Source: "actions",
																											Start: ast.Position{
																												Column: 38,
																												Line:   89,
																											},
																										},
																									},
																									Name: "actions",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 49,
																										Line:   90,
																									},
																									File:   "opsgenie.flux",
																									Source: "visibleTo: obj.visibleTo",
																									Start: ast.Position{
																										Column: 25,
																										Line:   90,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 34,
																											Line:   90,
																										},
																										File:   "opsgenie.flux",
																										Source: "visibleTo",
																										Start: ast.Position{
																											Column: 25,
																											Line:   90,
																										},
																									},
																								},
																								Name: "visibleTo",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 49,
																											Line:   90,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.visibleTo",
																										Start: ast.Position{
																											Column: 36,
																											Line:   90,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   90,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 36,
																												Line:   90,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 49,
																												Line:   90,
																											},
																											File:   "opsgenie.flux",
																											Source: "visibleTo",
																											Start: ast.Position{
																												Column: 40,
																												Line:   90,
																											},
																										},
																									},
																									Name: "visibleTo",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   91,
																									},
																									File:   "opsgenie.flux",
																									Source: "details: obj.details",
																									Start: ast.Position{
																										Column: 25,
																										Line:   91,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 32,
																											Line:   91,
																										},
																										File:   "opsgenie.flux",
																										Source: "details",
																										Start: ast.Position{
																											Column: 25,
																											Line:   91,
																										},
																									},
																								},
																								Name: "details",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   91,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.details",
																										Start: ast.Position{
																											Column: 34,
																											Line:   91,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   91,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 34,
																												Line:   91,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   91,
																											},
																											File:   "opsgenie.flux",
																											Source: "details",
																											Start: ast.Position{
																												Column: 38,
																												Line:   91,
																											},
																										},
																									},
																									Name: "details",
																								},
																								Rbrack: nil,
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   92,
																							},
																							File:   "opsgenie.flux",
																							Source: "sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    )",
																							Start: ast.Position{
																								Column: 29,
																								Line:   79,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 38,
																									Line:   79,
																								},
																								File:   "opsgenie.flux",
																								Source: "sendAlert",
																								Start: ast.Position{
																									Column: 29,
																									Line:   79,
																								},
																							},
																						},
																						Name: "sendAlert",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 28,
																								Line:   92,
																							},
																							File:   "opsgenie.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 25,
																								Line:   92,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   93,
																		},
																		File:   "opsgenie.flux",
																		Source: "string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100,\n                )",
																		Start: ast.Position{
																			Column: 24,
																			Line:   78,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   78,
																			},
																			File:   "opsgenie.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 24,
																				Line:   78,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   77,
																	},
																	File:   "opsgenie.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   77,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   94,
															},
															File:   "opsgenie.flux",
															Source: "return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100,\n                ),\n            }",
															Start: ast.Position{
																Column: 13,
																Line:   77,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   74,
														},
														File:   "opsgenie.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   74,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   74,
															},
															File:   "opsgenie.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   74,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   96,
										},
										File:   "opsgenie.flux",
										Source: "map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == sendAlert(\n                        url: url,\n                        apiKey: apiKey,\n                        entity: entity,\n                        message: obj.message,\n                        alias: obj.alias,\n                        description: obj.description,\n                        priority: obj.priority,\n                        responders: obj.responders,\n                        tags: obj.tags,\n                        actions: obj.actions,\n                        visibleTo: obj.visibleTo,\n                        details: obj.details,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   73,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   73,
											},
											File:   "opsgenie.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   73,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 98,
										Line:   72,
									},
									File:   "opsgenie.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 89,
										Line:   72,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 95,
											Line:   72,
										},
										File:   "opsgenie.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 89,
											Line:   72,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 98,
										Line:   72,
									},
									File:   "opsgenie.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 96,
										Line:   72,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   72,
								},
								File:   "opsgenie.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 78,
									Line:   72,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 83,
										Line:   72,
									},
									File:   "opsgenie.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 78,
										Line:   72,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   72,
							},
							File:   "opsgenie.flux",
							Source: "url=\"https://api.opsgenie.com/v2/alerts\"",
							Start: ast.Position{
								Column: 13,
								Line:   72,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   72,
								},
								File:   "opsgenie.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   72,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   72,
								},
								File:   "opsgenie.flux",
								Source: "\"https://api.opsgenie.com/v2/alerts\"",
								Start: ast.Position{
									Column: 17,
									Line:   72,
								},
							},
						},
						Value: "https://api.opsgenie.com/v2/alerts",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   72,
							},
							File:   "opsgenie.flux",
							Source: "apiKey",
							Start: ast.Position{
								Column: 55,
								Line:   72,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   72,
								},
								File:   "opsgenie.flux",
								Source: "apiKey",
								Start: ast.Position{
									Column: 55,
									Line:   72,
								},
							},
						},
						Name: "apiKey",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   72,
							},
							File:   "opsgenie.flux",
							Source: "entity=\"\"",
							Start: ast.Position{
								Column: 63,
								Line:   72,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   72,
								},
								File:   "opsgenie.flux",
								Source: "entity",
								Start: ast.Position{
									Column: 63,
									Line:   72,
								},
							},
						},
						Name: "entity",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   72,
								},
								File:   "opsgenie.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 70,
									Line:   72,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "opsgenie.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "opsgenie.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "opsgenie.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "opsgenie.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "json",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   6,
					},
					File:   "opsgenie.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   6,
						},
						File:   "opsgenie.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "opsgenie.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   1,
					},
					File:   "opsgenie.flux",
					Source: "package opsgenie",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   1,
						},
						File:   "opsgenie.flux",
						Source: "opsgenie",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "opsgenie",
			},
		},
	}},
	Package: "opsgenie",
	Path:    "contrib/sranka/opsgenie",
}
